/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;

public class UserInfo
implements Parcelable {
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

        public UserInfo createFromParcel(Parcel parcel) {
            String username = parcel.readString();
            String email = parcel.readString();
            String password = parcel.readString();
            String password2 = parcel.readString();
            boolean founder = parcel.readByte() == 1;
            return new UserInfo(username, email, founder, password, password2);
        }

        public UserInfo[] newArray(int size) {
            return new UserInfo[size];
        }
    };
    private String username;
    private String email;
    private String password;
    private String password2;
    private boolean founder;

    public UserInfo() {
    }

    public UserInfo(String username, String email, boolean founder) {
        this.username = username;
        this.email = email;
        this.founder = founder;
    }

    public UserInfo(String username, String email, boolean founder, String password, String password2) {
        this(username, email, founder);
        this.password = password;
        this.password2 = password2;
    }

    public String getEmail() {
        return this.email;
    }

    public UserInfo setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPassword2() {
        return this.password2;
    }

    public UserInfo setPassword2(String password2) {
        this.password2 = password2;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public UserInfo setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public UserInfo setUsername(String username) {
        this.username = username;
        return this;
    }

    public boolean isFounder() {
        return this.founder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        if (this.email != null ? !this.email.equals(userInfo.email) : userInfo.email != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(userInfo.password) : userInfo.password != null) {
            return false;
        }
        if (this.password2 != null ? !this.password2.equals(userInfo.password2) : userInfo.password2 != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(userInfo.username) : userInfo.username != null) {
            return false;
        }
        return this.founder == userInfo.founder;
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.password2 != null ? this.password2.hashCode() : 0);
        result = 31 * result + new Boolean(this.founder).hashCode();
        return result;
    }

    public String toString() {
        return "UserInfo{username='" + this.username + '\'' + ", email='" + this.email + '\'' + ", password='" + this.password + '\'' + ", password2='" + this.password2 + '\'' + ", founder='" + (this.founder ? 1 : 0) + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.username);
        parcel.writeString(this.email);
        parcel.writeString(this.password);
        parcel.writeString(this.password2);
        parcel.writeByte((byte)(this.founder ? 1 : 0));
    }
}

