/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import tv.ouya.console.api.OuyaResponseListener;
import tv.ouya.console.api.RequestRunnable;
import tv.ouya.console.api.UserInfo;
import tv.ouya.console.api.store.AppDescription;
import tv.ouya.console.api.store.AppDetails;
import tv.ouya.console.api.store.StoreSection;
import tv.ouya.console.api.store.Tag;
import tv.ouya.console.internal.AppDescriptionListListenerBinder;
import tv.ouya.console.internal.AppDetailsListenerBinder;
import tv.ouya.console.internal.IStoreServiceDefinition;
import tv.ouya.console.internal.StoreStructureListenerBinder;
import tv.ouya.console.internal.StringListenerBinder;
import tv.ouya.console.internal.TagListListenerBinder;
import tv.ouya.console.internal.UserInfoListenerBinder;
import tv.ouya.console.internal.VoidListenerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreManager
implements ServiceConnection {
    private static final String LOG_TAG = "OUYASM";
    private static StoreManager instance;
    private Context context;
    private IStoreServiceDefinition remoteService;
    private List<Runnable> pendingRequests = new ArrayList<Runnable>();
    private boolean bindRequestHasBeenMade;

    public static StoreManager getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        return new StoreManager(context);
    }

    @Deprecated
    protected static void setInstance(StoreManager instance) {
        StoreManager.instance = instance;
    }

    protected StoreManager(Context context) {
        this.context = context;
    }

    public void init(Context context) {
        if (this.isInitialized()) {
            return;
        }
        this.context = context.getApplicationContext();
    }

    public void shutdown() {
        if (this.context != null) {
            if (this.remoteService != null) {
                this.context.unbindService((ServiceConnection)this);
                this.remoteService = null;
                this.bindRequestHasBeenMade = false;
            }
            this.context = null;
        }
    }

    public boolean isInitialized() {
        return this.context != null;
    }

    public void requestAppDownloadUrl(String uuid, OuyaResponseListener<String> listener) {
        if (uuid == null) {
            throw new RuntimeException("null uuid specified");
        }
        this.runRequest(new RequestAppDownloadUrlRunnable(uuid, listener));
    }

    public void requestAppInfo(String uuid, OuyaResponseListener<AppDetails> listener) {
        if (uuid == null) {
            throw new RuntimeException("null uuid specified");
        }
        this.runRequest(new RequestAppInfoRunnable(uuid, listener));
    }

    public void requestAppList(OuyaResponseListener<List<AppDescription>> listener) {
        this.runRequest(new RequestAppsListRunnable(listener));
    }

    public void requestAppList(String tag, OuyaResponseListener<List<AppDescription>> listener) {
        this.runRequest(new RequestAppsListForTagRunnable(tag, listener));
    }

    public void requestTagList(OuyaResponseListener<List<Tag>> listener) {
        this.runRequest(new RequestTagListRunnable(listener));
    }

    public void requestStoreStructure(OuyaResponseListener<StoreSection> listener) {
        this.runRequest(new RequestStoreStructureRunnable(listener));
    }

    public void requestCreateNewUser(UserInfo userInfo, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestCreateNewUserRunnable(userInfo, listener));
    }

    public void requestDeregisterConsole(String consoleId, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestDeregisterConsoleRunnable(consoleId, listener));
    }

    public void requestDeveloperAppList(OuyaResponseListener<List<AppDescription>> listener) {
        this.runRequest(new RequestDeveloperAppsListRunnable(listener));
    }

    public void requestResendEmail(String emailAddress, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestResendEmailRunnable(emailAddress, listener));
    }

    public void requestRegisterConsole(OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestRegisterConsoleRunnable(listener));
    }

    public void requestUpdateUserInfo(UserInfo userInfo, OuyaResponseListener<Void> listener) {
        this.runRequest(new RequestUpdateUserInfoRunnable(userInfo, listener));
    }

    public void requestUserInfo(OuyaResponseListener<UserInfo> listener) {
        this.runRequest(new RequestUserInfoRunnable(listener));
    }

    public void requestCachedUserInfo(OuyaResponseListener<UserInfo> listener) {
        this.runRequest(new RequestCachedUserInfoRunnable(listener));
    }

    public void requestSystemMessage(String buildNumber, OuyaResponseListener<String> listener) {
        this.runRequest(new RequestSystemMessageRunnable(buildNumber, listener));
    }

    private void runRequest(Runnable requestRunnable) {
        this.ensureServiceIsBound();
        if (this.remoteService != null) {
            requestRunnable.run();
        } else {
            this.pendingRequests.add(requestRunnable);
        }
    }

    @Deprecated
    IStoreServiceDefinition getRemoteService() {
        return this.remoteService;
    }

    @Deprecated
    public boolean bindRequestHasBeenMade() {
        return this.bindRequestHasBeenMade;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Log.d((String)"inAppPurchase", (String)"Successfully bound to IapService");
        this.remoteService = IStoreServiceDefinition.Stub.asInterface(iBinder);
        while (this.pendingRequests.size() > 0) {
            this.pendingRequests.remove(0).run();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.remoteService = null;
        this.bindRequestHasBeenMade = false;
    }

    void ensureServiceIsBound() {
        if (this.context == null) {
            Log.e((String)LOG_TAG, (String)"Dropping request because connect has been shut down");
            return;
        }
        if (!this.bindRequestHasBeenMade) {
            Log.d((String)"inAppPurchase", (String)"Binding to StoreService");
            Intent intent = new Intent();
            intent.setClassName("tv.ouya", "tv.ouya.console.service.store.StoreService");
            this.context.bindService(intent, (ServiceConnection)this, 1);
            this.bindRequestHasBeenMade = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestSystemMessageRunnable
    extends RequestRunnable<String> {
        private String buildNumber;

        public RequestSystemMessageRunnable(String buildNumber, OuyaResponseListener<String> listener) {
            super(listener, "requesting system message");
            this.buildNumber = buildNumber;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestSystemMessage(this.buildNumber, new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestCachedUserInfoRunnable
    extends RequestRunnable<UserInfo> {
        public RequestCachedUserInfoRunnable(OuyaResponseListener<UserInfo> listener) {
            super(listener, "requesting cached UserInfo");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestCachedUserInfo(new UserInfoListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUserInfoRunnable
    extends RequestRunnable<UserInfo> {
        public RequestUserInfoRunnable(OuyaResponseListener<UserInfo> listener) {
            super(listener, "requesting UserInfo");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestUserInfo(new UserInfoListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestUpdateUserInfoRunnable
    extends RequestRunnable<Void> {
        private UserInfo mUserInfo;

        public RequestUpdateUserInfoRunnable(UserInfo userInfo, OuyaResponseListener<Void> listener) {
            super(listener, "requesting UserInfo update");
            this.mUserInfo = userInfo;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestUpdateUserInfo(this.mUserInfo, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestRegisterConsoleRunnable
    extends RequestRunnable<Void> {
        public RequestRegisterConsoleRunnable(OuyaResponseListener<Void> listener) {
            super(listener, "registering console");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestRegisterConsole(new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestResendEmailRunnable
    extends RequestRunnable<Void> {
        final String mEmailAddress;

        public RequestResendEmailRunnable(String emailAddress, OuyaResponseListener<Void> listener) {
            super(listener, "requesting email resend");
            this.mEmailAddress = emailAddress;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestResendEmail(this.mEmailAddress, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestDeveloperAppsListRunnable
    extends RequestRunnable<List<AppDescription>> {
        public RequestDeveloperAppsListRunnable(OuyaResponseListener<List<AppDescription>> listener) {
            super(listener, "fetching developer apps list");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestDeveloperAppList(new AppDescriptionListListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestDeregisterConsoleRunnable
    extends RequestRunnable<Void> {
        private String mConsoleId;

        public RequestDeregisterConsoleRunnable(String consoleId, OuyaResponseListener<Void> listener) {
            super(listener, "fetching developer apps list");
            this.mConsoleId = consoleId;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestDeregisterConsole(this.mConsoleId, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestCreateNewUserRunnable
    extends RequestRunnable<Void> {
        private UserInfo mUserInfo;

        public RequestCreateNewUserRunnable(UserInfo userInfo, OuyaResponseListener<Void> listener) {
            super(listener, "registering console");
            this.mUserInfo = userInfo;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestCreateNewUser(this.mUserInfo, new VoidListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestAppDownloadUrlRunnable
    extends RequestRunnable<String> {
        final String mUuid;

        public RequestAppDownloadUrlRunnable(String uuid, OuyaResponseListener<String> listener) {
            super(listener, "fetching username");
            this.mUuid = uuid;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestAppDownloadUrl(this.mUuid, new StringListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestStoreStructureRunnable
    extends RequestRunnable<StoreSection> {
        public RequestStoreStructureRunnable(OuyaResponseListener<StoreSection> listener) {
            super(listener, "fetching store structure");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestStoreStructure(new StoreStructureListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestTagListRunnable
    extends RequestRunnable<List<Tag>> {
        public RequestTagListRunnable(OuyaResponseListener<List<Tag>> listener) {
            super(listener, "fetching tag list");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestTagList(new TagListListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestAppsListForTagRunnable
    extends RequestRunnable<List<AppDescription>> {
        private String mTag;

        public RequestAppsListForTagRunnable(String tag, OuyaResponseListener<List<AppDescription>> listener) {
            super(listener, "fetching developer apps list");
            this.mTag = tag;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestAppListForTag(this.mTag, new AppDescriptionListListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestAppsListRunnable
    extends RequestRunnable<List<AppDescription>> {
        public RequestAppsListRunnable(OuyaResponseListener<List<AppDescription>> listener) {
            super(listener, "fetching developer apps list");
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestAppList(new AppDescriptionListListenerBinder(this.listener));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestAppInfoRunnable
    extends RequestRunnable<AppDetails> {
        final String mUuid;

        public RequestAppInfoRunnable(String uuid, OuyaResponseListener<AppDetails> gamerUuidListener) {
            super(gamerUuidListener, "fetching username");
            this.mUuid = uuid;
        }

        @Override
        void doRun() throws RemoteException {
            StoreManager.this.remoteService.requestAppInfo(this.mUuid, new AppDetailsListenerBinder(this.listener));
        }
    }
}

