/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Receipt
implements Parcelable {
    public static final Parcelable.Creator<Receipt> CREATOR;
    private static final SimpleDateFormat DATE_PARSER;
    private String identifier;
    private int priceInCents;
    private Date purchaseDate;
    private Date generatedDate;

    public Receipt() {
    }

    public Receipt(String identifier, int priceInCents, Date purchaseDate, Date generatedDate) {
        this.identifier = identifier;
        this.priceInCents = priceInCents;
        this.purchaseDate = purchaseDate;
        this.generatedDate = generatedDate;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getPriceInCents() {
        return this.priceInCents;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPriceInCents(int priceInCents) {
        this.priceInCents = priceInCents;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public void setDate(String date) {
        try {
            this.setPurchaseDate(DATE_PARSER.parse(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date getGeneratedDate() {
        return this.generatedDate;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.identifier);
        dest.writeInt(this.priceInCents);
        dest.writeLong(this.purchaseDate.getTime());
        dest.writeLong(this.generatedDate.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Receipt)) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        if (this.priceInCents != receipt.priceInCents) {
            return false;
        }
        if (!this.purchaseDate.equals(receipt.purchaseDate)) {
            return false;
        }
        return this.identifier.equals(receipt.identifier);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.priceInCents;
        result = 31 * result + this.purchaseDate.hashCode();
        return result;
    }

    static {
        DATE_PARSER = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss'Z'");
        DATE_PARSER.setTimeZone(TimeZone.getTimeZone("UTC"));
        CREATOR = new Parcelable.Creator<Receipt>(){

            public Receipt createFromParcel(Parcel parcel) {
                return new Receipt(parcel.readString(), parcel.readInt(), new Date(parcel.readLong()), new Date(parcel.readLong()));
            }

            public Receipt[] newArray(int size) {
                return new Receipt[size];
            }
        };
    }
}

