/***
	Copyright (c) 2008-2011 CommonsWare, LLC
	Licensed under the Apache License, Version 2.0 (the "License"); you may not
	use this file except in compliance with the License. You may obtain a copy
	of the License at http://www.apache.org/licenses/LICENSE-2.0. Unless required
	by applicable law or agreed to in writing, software distributed under the
	License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
	OF ANY KIND, either express or implied. See the License for the specific
	language governing permissions and limitations under the License.
	
	From _The Busy Coder's Guide to Android Development_
		http://commonsware.com/Android
*/

package com.commonsware.android.contacts.spinners;

import android.app.Activity;
import android.database.Cursor;
import android.provider.Contacts;
import android.widget.ListAdapter;
import android.widget.SimpleCursorAdapter;

class OldContactsAdapterBridge extends ContactsAdapterBridge {
	ListAdapter buildNameAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts.People._ID,
																				Contacts.PeopleColumns.NAME
																			};
		Cursor c=a.managedQuery(Contacts.People.CONTENT_URI,
														PROJECTION, null, null,
														Contacts.People.DEFAULT_SORT_ORDER);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_1,
																		c,
																		new String[] {
																			Contacts.PeopleColumns.NAME
																		},
																		new int[] {
																			android.R.id.text1
																		}));
	}
	
	ListAdapter buildPhonesAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts.Phones._ID,
																				Contacts.Phones.NAME,
																				Contacts.Phones.NUMBER
																			};
		Cursor c=a.managedQuery(Contacts.Phones.CONTENT_URI,
														PROJECTION, null, null,
														Contacts.Phones.DEFAULT_SORT_ORDER);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_2,
																		c,
																		new String[] {
																			Contacts.Phones.NAME,
																			Contacts.Phones.NUMBER
																		},
																		new int[] {
																			android.R.id.text1,
																			android.R.id.text2
																		}));
	}
	
	ListAdapter buildEmailAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts.ContactMethods._ID,
																				Contacts.ContactMethods.DATA,
																				Contacts.PeopleColumns.NAME
																			};
		Cursor c=a.managedQuery(Contacts.ContactMethods.CONTENT_EMAIL_URI,
														PROJECTION, null, null,
														Contacts.ContactMethods.DEFAULT_SORT_ORDER);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_2,
																		c,
																		new String[] {
																			Contacts.PeopleColumns.NAME,
																			Contacts.ContactMethods.DATA
																		},
																		new int[] {
																			android.R.id.text1,
																			android.R.id.text2
																		}));
	}
}