/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.android.gcm.cmd;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class GCM {
    public static void main(String[] args) {
        Option helpOpt = new Option("h", "help", false, "print this message");
        OptionBuilder.withArgName((String)"key");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"GCM API key");
        OptionBuilder.withLongOpt((String)"apiKey");
        Option apiKeyOpt = OptionBuilder.create((char)'a');
        OptionBuilder.withArgName((String)"regId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"device to send to");
        OptionBuilder.withLongOpt((String)"device");
        Option deviceOpt = OptionBuilder.create((char)'d');
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"datum to send");
        OptionBuilder.withValueSeparator();
        OptionBuilder.withLongOpt((String)"data");
        Option dataOpt = OptionBuilder.create((char)'D');
        Options options = new Options();
        options.addOption(apiKeyOpt);
        options.addOption(deviceOpt);
        options.addOption(dataOpt);
        options.addOption(helpOpt);
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption('h') || !line.hasOption('a') || !line.hasOption('d')) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("gcm", options, true);
            } else {
                GCM.sendMessage(line.getOptionValue('a'), Arrays.asList(line.getOptionValues('d')), line.getOptionProperties("data"));
            }
        }
        catch (MissingOptionException moe) {
            System.err.println("Invalid command syntax");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("gcm", options, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendMessage(String apiKey, List<String> devices, Properties data) throws Exception {
        Sender sender = new Sender(apiKey);
        Message.Builder builder = new Message.Builder();
        for (Object o : data.keySet()) {
            String key = o.toString();
            builder.addData(key, data.getProperty(key));
        }
        MulticastResult mcResult = sender.send(builder.build(), devices, 5);
        int i = 0;
        while (i < mcResult.getTotal()) {
            Result result = (Result)mcResult.getResults().get(i);
            if (result.getMessageId() != null) {
                String canonicalRegId = result.getCanonicalRegistrationId();
                if (canonicalRegId != null) {
                    System.err.println(String.format("%s canonical ID = %s", devices.get(i), canonicalRegId));
                } else {
                    System.out.println(String.format("%s success", devices.get(i)));
                }
            } else {
                String error = result.getErrorCodeName();
                if ("NotRegistered".equals(error)) {
                    System.err.println(String.format("%s is unregistered", devices.get(i)));
                } else if (error != null) {
                    System.err.println(String.format("%s error = %s", devices.get(i), error));
                }
            }
            ++i;
        }
    }
}

