/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.layouts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.commonsware.cwac.layouts.MirrorSink;

public class Mirror
extends View
implements MirrorSink {
    private Rect rect = new Rect();
    private Bitmap bmp = null;

    public Mirror(Context context) {
        super(context);
    }

    public Mirror(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Mirror(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void update(Bitmap bmp) {
        this.bmp = bmp;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bmp != null) {
            this.getDrawingRect(this.rect);
            Mirror.calcCenter(this.rect.width(), this.rect.height(), this.bmp.getWidth(), this.bmp.getHeight(), this.rect);
            canvas.drawBitmap(this.bmp, null, this.rect, null);
        }
    }

    static void calcCenter(int vw, int vh, int iw, int ih, Rect out) {
        double scale = Math.min((double)vw / (double)iw, (double)vh / (double)ih);
        int h = (int)(scale * (double)ih);
        int w = (int)(scale * (double)iw);
        int x = vw - w >> 1;
        int y = vh - h >> 1;
        out.set(x, y, x + w, y + h);
    }
}

