/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DirectoryManager {
    private static final String LOG_TAG = "DirectoryManager";

    protected static boolean testFileExists(String name) {
        boolean status;
        if (DirectoryManager.testSaveLocationExists() && !name.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = DirectoryManager.constructFilePaths(path.toString(), name);
            status = newPath.exists();
        } else {
            status = false;
        }
        return status;
    }

    protected static long getFreeDiskSpace() {
        String status = Environment.getExternalStorageState();
        long freeSpace = 0L;
        if (status.equals("mounted")) {
            try {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSize();
                long availableBlocks = stat.getAvailableBlocks();
                freeSpace = availableBlocks * blockSize / 1024L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return -1L;
        }
        return freeSpace;
    }

    protected static boolean createDirectory(String directoryName) {
        boolean status;
        if (DirectoryManager.testSaveLocationExists() && !directoryName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = DirectoryManager.constructFilePaths(path.toString(), directoryName);
            status = newPath.mkdir();
            status = true;
        } else {
            status = false;
        }
        return status;
    }

    protected static boolean testSaveLocationExists() {
        String sDCardStatus = Environment.getExternalStorageState();
        boolean status = sDCardStatus.equals("mounted");
        return status;
    }

    protected static boolean deleteDirectory(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (DirectoryManager.testSaveLocationExists() && !fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = DirectoryManager.constructFilePaths(path.toString(), fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isDirectory()) {
                String[] listfile = newPath.list();
                try {
                    for (int i = 0; i < listfile.length; ++i) {
                        File deletedFile = new File(newPath.toString() + "/" + listfile[i].toString());
                        deletedFile.delete();
                    }
                    newPath.delete();
                    Log.i((String)"DirectoryManager deleteDirectory", (String)fileName);
                    status = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    protected static boolean deleteFile(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (DirectoryManager.testSaveLocationExists() && !fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = DirectoryManager.constructFilePaths(path.toString(), fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isFile()) {
                try {
                    Log.i((String)"DirectoryManager deleteFile", (String)fileName);
                    newPath.delete();
                    status = true;
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    private static File constructFilePaths(String file1, String file2) {
        File newPath = file2.startsWith(file1) ? new File(file2) : new File(file1 + "/" + file2);
        return newPath;
    }

    protected static JSONObject getFile(String filePath) {
        File fp = new File(filePath);
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)fp.getAbsolutePath());
            obj.put("lastModifiedDate", (Object)new Date(fp.lastModified()).toString());
            obj.put("size", fp.length());
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    protected static JSONArray getRootPaths() {
        JSONArray retVal = new JSONArray();
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/";
        retVal.put((Object)path);
        return retVal;
    }
}

