/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.ResponseSource;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.Failure;
import com.squareup.okhttp.internal.http.Headers;
import com.squareup.okhttp.internal.http.HttpDate;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.okio.Source;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Response {
    private final Request request;
    private final StatusLine statusLine;
    private final Handshake handshake;
    private final Headers headers;
    private final Body body;
    private final Response redirectedBy;
    private volatile ParsedHeaders parsedHeaders;
    private volatile CacheControl cacheControl;

    private Response(Builder builder) {
        this.request = builder.request;
        this.statusLine = builder.statusLine;
        this.handshake = builder.handshake;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.redirectedBy = builder.redirectedBy;
    }

    public Request request() {
        return this.request;
    }

    public String statusLine() {
        return this.statusLine.getStatusLine();
    }

    public int code() {
        return this.statusLine.code();
    }

    public String statusMessage() {
        return this.statusLine.message();
    }

    public int httpMinorVersion() {
        return this.statusLine.httpMinorVersion();
    }

    public Handshake handshake() {
        return this.handshake;
    }

    public List<String> headers(String name) {
        return this.headers.values(name);
    }

    public String header(String name) {
        return this.header(name, null);
    }

    public String header(String name, String defaultValue) {
        String result = this.headers.get(name);
        return result != null ? result : defaultValue;
    }

    public Headers headers() {
        return this.headers;
    }

    public Body body() {
        return this.body;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Response redirectedBy() {
        return this.redirectedBy;
    }

    public Set<String> getVaryFields() {
        return this.parsedHeaders().varyFields;
    }

    public boolean hasVaryAll() {
        return this.parsedHeaders().varyFields.contains("*");
    }

    public boolean varyMatches(Headers varyHeaders, Request newRequest) {
        for (String field : this.parsedHeaders().varyFields) {
            if (Util.equal(varyHeaders.values(field), newRequest.headers(field))) continue;
            return false;
        }
        return true;
    }

    public boolean validate(Response network) {
        if (network.code() == 304) {
            return true;
        }
        ParsedHeaders networkHeaders = network.parsedHeaders();
        return this.parsedHeaders().lastModified != null && networkHeaders.lastModified != null && networkHeaders.lastModified.getTime() < this.parsedHeaders().lastModified.getTime();
    }

    private ParsedHeaders parsedHeaders() {
        ParsedHeaders result = this.parsedHeaders;
        return result != null ? result : (this.parsedHeaders = new ParsedHeaders(this.headers));
    }

    public CacheControl cacheControl() {
        CacheControl result = this.cacheControl;
        return result != null ? result : (this.cacheControl = CacheControl.parse(this.headers));
    }

    public static class Builder {
        private Request request;
        private StatusLine statusLine;
        private Handshake handshake;
        private Headers.Builder headers;
        private Body body;
        private Response redirectedBy;

        public Builder() {
            this.headers = new Headers.Builder();
        }

        private Builder(Response response) {
            this.request = response.request;
            this.statusLine = response.statusLine;
            this.handshake = response.handshake;
            this.headers = response.headers.newBuilder();
            this.body = response.body;
            this.redirectedBy = response.redirectedBy;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder statusLine(StatusLine statusLine) {
            if (statusLine == null) {
                throw new IllegalArgumentException("statusLine == null");
            }
            this.statusLine = statusLine;
            return this;
        }

        public Builder statusLine(String statusLine) {
            try {
                return this.statusLine(new StatusLine(statusLine));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder handshake(Handshake handshake) {
            this.handshake = handshake;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(String name) {
            this.headers.removeAll(name);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public Builder setResponseSource(ResponseSource responseSource) {
            return this.header(OkHeaders.RESPONSE_SOURCE, (Object)((Object)responseSource) + " " + this.statusLine.code());
        }

        public Builder redirectedBy(Response redirectedBy) {
            this.redirectedBy = redirectedBy;
            return this;
        }

        public Response build() {
            if (this.request == null) {
                throw new IllegalStateException("request == null");
            }
            if (this.statusLine == null) {
                throw new IllegalStateException("statusLine == null");
            }
            return new Response(this);
        }
    }

    public static interface Receiver {
        public void onFailure(Failure var1);

        public boolean onResponse(Response var1) throws IOException;
    }

    private static class ParsedHeaders {
        Date lastModified;
        private Set<String> varyFields = Collections.emptySet();

        private ParsedHeaders(Headers headers) {
            for (int i = 0; i < headers.size(); ++i) {
                String fieldName = headers.name(i);
                String value = headers.value(i);
                if ("Last-Modified".equalsIgnoreCase(fieldName)) {
                    this.lastModified = HttpDate.parse(value);
                    continue;
                }
                if (!"Vary".equalsIgnoreCase(fieldName)) continue;
                if (this.varyFields.isEmpty()) {
                    this.varyFields = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                }
                for (String varyField : value.split(",")) {
                    this.varyFields.add(varyField.trim());
                }
            }
        }
    }

    public static abstract class Body
    implements Closeable {
        private Reader reader;
        private Source source;

        public abstract boolean ready() throws IOException;

        public abstract MediaType contentType();

        public abstract long contentLength();

        public abstract InputStream byteStream();

        public Source source() {
            Source s = this.source;
            return s != null ? s : (this.source = Okio.source(this.byteStream()));
        }

        public final byte[] bytes() throws IOException {
            long contentLength = this.contentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IOException("Cannot buffer entire body for content length: " + contentLength);
            }
            if (contentLength != -1L) {
                byte[] content = new byte[(int)contentLength];
                InputStream in = this.byteStream();
                Util.readFully(in, content);
                if (in.read() != -1) {
                    throw new IOException("Content-Length and stream length disagree");
                }
                return content;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copy(this.byteStream(), out);
            return out.toByteArray();
        }

        public final Reader charStream() {
            Reader r = this.reader;
            return r != null ? r : (this.reader = new InputStreamReader(this.byteStream(), this.charset()));
        }

        public final String string() throws IOException {
            return new String(this.bytes(), this.charset().name());
        }

        private Charset charset() {
            MediaType contentType = this.contentType();
            return contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8;
        }

        @Override
        public void close() throws IOException {
            this.byteStream().close();
        }
    }
}

