/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterReader;
import com.koushikdutta.async.callback.DataCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

abstract class HybiParser {
    private static final String TAG = "HybiParser";
    private boolean mMasking = true;
    private int mStage;
    private boolean mFinal;
    private boolean mMasked;
    private int mOpcode;
    private int mLengthSize;
    private int mLength;
    private int mMode;
    private byte[] mMask = new byte[0];
    private byte[] mPayload = new byte[0];
    private boolean mClosed = false;
    private ByteArrayOutputStream mBuffer = new ByteArrayOutputStream();
    private static final int BYTE = 255;
    private static final int FIN = 128;
    private static final int MASK = 128;
    private static final int RSV1 = 64;
    private static final int RSV2 = 32;
    private static final int RSV3 = 16;
    private static final int OPCODE = 15;
    private static final int LENGTH = 127;
    private static final int MODE_TEXT = 1;
    private static final int MODE_BINARY = 2;
    private static final int OP_CONTINUATION = 0;
    private static final int OP_TEXT = 1;
    private static final int OP_BINARY = 2;
    private static final int OP_CLOSE = 8;
    private static final int OP_PING = 9;
    private static final int OP_PONG = 10;
    private static final List<Integer> OPCODES = Arrays.asList(0, 1, 2, 8, 9, 10);
    private static final List<Integer> FRAGMENTED_OPCODES = Arrays.asList(0, 1, 2);
    DataCallback mStage0 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            try {
                HybiParser.this.parseOpcode(bb.get());
            }
            catch (ProtocolError e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.parse();
        }
    };
    DataCallback mStage1 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            HybiParser.this.parseLength(bb.get());
            HybiParser.this.parse();
        }
    };
    DataCallback mStage2 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            byte[] bytes = new byte[HybiParser.this.mLengthSize];
            bb.get(bytes);
            try {
                HybiParser.this.parseExtendedLength(bytes);
            }
            catch (ProtocolError e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.parse();
        }
    };
    DataCallback mStage3 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            HybiParser.access$402(HybiParser.this, new byte[4]);
            bb.get(HybiParser.this.mMask);
            HybiParser.this.mStage = 4;
            HybiParser.this.parse();
        }
    };
    DataCallback mStage4 = new DataCallback(){

        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            assert (bb.remaining() == HybiParser.this.mLength);
            HybiParser.access$702(HybiParser.this, new byte[HybiParser.this.mLength]);
            bb.get(HybiParser.this.mPayload);
            try {
                HybiParser.this.emitFrame();
            }
            catch (IOException e) {
                HybiParser.this.report(e);
                e.printStackTrace();
            }
            HybiParser.this.mStage = 0;
            HybiParser.this.parse();
        }
    };
    private DataEmitterReader mReader = new DataEmitterReader();

    private static byte[] mask(byte[] payload, byte[] mask, int offset) {
        if (mask.length == 0) {
            return payload;
        }
        for (int i = 0; i < payload.length - offset; ++i) {
            payload[offset + i] = (byte)(payload[offset + i] ^ mask[i % 4]);
        }
        return payload;
    }

    public void setMasking(boolean masking) {
        this.mMasking = masking;
    }

    void parse() {
        switch (this.mStage) {
            case 0: {
                this.mReader.read(1, this.mStage0);
                break;
            }
            case 1: {
                this.mReader.read(1, this.mStage1);
                break;
            }
            case 2: {
                this.mReader.read(this.mLengthSize, this.mStage2);
                break;
            }
            case 3: {
                this.mReader.read(4, this.mStage3);
                break;
            }
            case 4: {
                this.mReader.read(this.mLength, this.mStage4);
            }
        }
    }

    public HybiParser(DataEmitter socket) {
        socket.setDataCallback(this.mReader);
        this.parse();
    }

    private void parseOpcode(byte data) throws ProtocolError {
        boolean rsv3;
        boolean rsv1 = (data & 0x40) == 64;
        boolean rsv2 = (data & 0x20) == 32;
        boolean bl = rsv3 = (data & 0x10) == 16;
        if (rsv1 || rsv2 || rsv3) {
            throw new ProtocolError("RSV not zero");
        }
        this.mFinal = (data & 0x80) == 128;
        this.mOpcode = data & 0xF;
        this.mMask = new byte[0];
        this.mPayload = new byte[0];
        if (!OPCODES.contains(this.mOpcode)) {
            throw new ProtocolError("Bad opcode");
        }
        if (!FRAGMENTED_OPCODES.contains(this.mOpcode) && !this.mFinal) {
            throw new ProtocolError("Expected non-final packet");
        }
        this.mStage = 1;
    }

    private void parseLength(byte data) {
        this.mMasked = (data & 0x80) == 128;
        this.mLength = data & 0x7F;
        if (this.mLength >= 0 && this.mLength <= 125) {
            this.mStage = this.mMasked ? 3 : 4;
        } else {
            this.mLengthSize = this.mLength == 126 ? 2 : 8;
            this.mStage = 2;
        }
    }

    private void parseExtendedLength(byte[] buffer) throws ProtocolError {
        this.mLength = this.getInteger(buffer);
        this.mStage = this.mMasked ? 3 : 4;
    }

    public byte[] frame(String data) {
        return this.frame(data, 1, -1);
    }

    public byte[] frame(byte[] data) {
        return this.frame(data, 2, -1);
    }

    private byte[] frame(byte[] data, int opcode, int errorCode) {
        return this.frame((Object)data, opcode, errorCode);
    }

    private byte[] frame(String data, int opcode, int errorCode) {
        return this.frame((Object)data, opcode, errorCode);
    }

    private byte[] frame(Object data, int opcode, int errorCode) {
        int insert;
        if (this.mClosed) {
            return null;
        }
        byte[] buffer = data instanceof String ? this.decode((String)data) : (byte[])data;
        int length = buffer.length + (insert = errorCode > 0 ? 2 : 0);
        int header = length <= 125 ? 2 : (length <= 65535 ? 4 : 10);
        int offset = header + (this.mMasking ? 4 : 0);
        int masked = this.mMasking ? 128 : 0;
        byte[] frame = new byte[length + offset];
        frame[0] = (byte)(0xFFFFFF80 | (byte)opcode);
        if (length <= 125) {
            frame[1] = (byte)(masked | length);
        } else if (length <= 65535) {
            frame[1] = (byte)(masked | 0x7E);
            frame[2] = (byte)Math.floor(length / 256);
            frame[3] = (byte)(length & 0xFF);
        } else {
            frame[1] = (byte)(masked | 0x7F);
            frame[2] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 56.0)) & 0xFF);
            frame[3] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 48.0)) & 0xFF);
            frame[4] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 40.0)) & 0xFF);
            frame[5] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 32.0)) & 0xFF);
            frame[6] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 24.0)) & 0xFF);
            frame[7] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 16.0)) & 0xFF);
            frame[8] = (byte)((int)Math.floor((double)length / Math.pow(2.0, 8.0)) & 0xFF);
            frame[9] = (byte)(length & 0xFF);
        }
        if (errorCode > 0) {
            frame[offset] = (byte)((int)Math.floor(errorCode / 256) & 0xFF);
            frame[offset + 1] = (byte)(errorCode & 0xFF);
        }
        System.arraycopy(buffer, 0, frame, offset + insert, buffer.length);
        if (this.mMasking) {
            byte[] mask = new byte[]{(byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0)};
            System.arraycopy(mask, 0, frame, header, mask.length);
            HybiParser.mask(frame, mask, offset);
        }
        return frame;
    }

    public void ping(String message) {
    }

    public void close(int code, String reason) {
        if (this.mClosed) {
            return;
        }
        this.sendFrame(this.frame(reason, 8, code));
        this.mClosed = true;
    }

    private void emitFrame() throws IOException {
        byte[] payload = HybiParser.mask(this.mPayload, this.mMask, 0);
        int opcode = this.mOpcode;
        if (opcode == 0) {
            if (this.mMode == 0) {
                throw new ProtocolError("Mode was not set.");
            }
            this.mBuffer.write(payload);
            if (this.mFinal) {
                byte[] message = this.mBuffer.toByteArray();
                if (this.mMode == 1) {
                    this.onMessage(this.encode(message));
                } else {
                    this.onMessage(message);
                }
                this.reset();
            }
        } else if (opcode == 1) {
            if (this.mFinal) {
                String messageText = this.encode(payload);
                this.onMessage(messageText);
            } else {
                this.mMode = 1;
                this.mBuffer.write(payload);
            }
        } else if (opcode == 2) {
            if (this.mFinal) {
                this.onMessage(payload);
            } else {
                this.mMode = 2;
                this.mBuffer.write(payload);
            }
        } else if (opcode == 8) {
            int code = payload.length >= 2 ? 256 * payload[0] + payload[1] : 0;
            String reason = payload.length > 2 ? this.encode(this.slice(payload, 2)) : null;
            this.onDisconnect(code, reason);
        } else if (opcode == 9) {
            if (payload.length > 125) {
                throw new ProtocolError("Ping payload too large");
            }
            this.sendFrame(this.frame(payload, 10, -1));
        } else if (opcode == 10) {
            String string = this.encode(payload);
        }
    }

    protected abstract void onMessage(byte[] var1);

    protected abstract void onMessage(String var1);

    protected abstract void onDisconnect(int var1, String var2);

    protected abstract void report(Exception var1);

    protected abstract void sendFrame(byte[] var1);

    private void reset() {
        this.mMode = 0;
        this.mBuffer.reset();
    }

    private String encode(byte[] buffer) {
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int getInteger(byte[] bytes) throws ProtocolError {
        long i = HybiParser.byteArrayToLong(bytes, 0, bytes.length);
        if (i < 0L || i > Integer.MAX_VALUE) {
            throw new ProtocolError("Bad integer: " + i);
        }
        return (int)i;
    }

    private byte[] slice(byte[] array, int start) {
        byte[] copy = new byte[array.length - start];
        System.arraycopy(array, start, copy, 0, array.length - start);
        return copy;
    }

    private static long byteArrayToLong(byte[] b, int offset, int length) {
        if (b.length < length) {
            throw new IllegalArgumentException("length must be less than or equal to b.length");
        }
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            int shift = (length - 1 - i) * 8;
            value += (long)((b[i + offset] & 0xFF) << shift);
        }
        return value;
    }

    static /* synthetic */ byte[] access$402(HybiParser x0, byte[] x1) {
        x0.mMask = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(HybiParser x0, byte[] x1) {
        x0.mPayload = x1;
        return x1;
    }

    public static class ProtocolError
    extends IOException {
        public ProtocolError(String detailMessage) {
            super(detailMessage);
        }
    }
}

