/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.sqliteasset;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.readystatesoftware.sqliteasset.Utils;
import com.readystatesoftware.sqliteasset.VersionComparator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;

public class SQLiteAssetHelper
extends SQLiteOpenHelper {
    private static final String TAG = SQLiteAssetHelper.class.getSimpleName();
    private static final String ASSET_DB_PATH = "databases";
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;
    private String mDatabasePath;
    private String mAssetPath;
    private String mUpgradePathFormat;
    private int mForcedUpgradeVersion = 0;

    public SQLiteAssetHelper(Context context, String name, String storageDirectory, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        if (name == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mAssetPath = "databases/" + name;
        this.mDatabasePath = storageDirectory != null ? storageDirectory : context.getApplicationInfo().dataDir + "/databases";
        this.mUpgradePathFormat = "databases/" + name + "_upgrade_%s-%s.sql";
    }

    public SQLiteAssetHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, null, factory, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        try {
            this.mIsInitializing = true;
            db = this.createOrOpenDatabase(false);
            int version = db.getVersion();
            if (version != 0 && version < this.mForcedUpgradeVersion) {
                db = this.createOrOpenDatabase(true);
                db.setVersion(this.mNewVersion);
                version = db.getVersion();
            }
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else {
                        if (version > this.mNewVersion) {
                            Log.w((String)TAG, (String)("Can't downgrade read-only database from version " + version + " to " + this.mNewVersion + ": " + db.getPath()));
                        }
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception e) {}
                }
                this.mDatabase = db;
            } else if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase();
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                db = SQLiteDatabase.openDatabase((String)path, (SQLiteDatabase.CursorFactory)this.mFactory, (int)1);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public final void onConfigure(SQLiteDatabase db) {
    }

    public final void onCreate(SQLiteDatabase db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.w((String)TAG, (String)("Upgrading database " + this.mName + " from version " + oldVersion + " to " + newVersion + "..."));
        ArrayList<String> paths = new ArrayList<String>();
        this.getUpgradeFilePaths(oldVersion, newVersion - 1, newVersion, paths);
        if (paths.isEmpty()) {
            Log.e((String)TAG, (String)("no upgrade script path from " + oldVersion + " to " + newVersion));
            throw new SQLiteAssetException("no upgrade script path from " + oldVersion + " to " + newVersion);
        }
        Collections.sort(paths, new VersionComparator());
        for (String path : paths) {
            try {
                Log.w((String)TAG, (String)("processing upgrade: " + path));
                InputStream is = this.mContext.getAssets().open(path);
                String sql = Utils.convertStreamToString(is);
                if (sql == null) continue;
                List<String> cmds = Utils.splitSqlScript(sql, ';');
                for (String cmd : cmds) {
                    if (cmd.trim().length() <= 0) continue;
                    db.execSQL(cmd);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Log.w((String)TAG, (String)("Successfully upgraded database " + this.mName + " from version " + oldVersion + " to " + newVersion));
    }

    public final void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    @Deprecated
    public void setForcedUpgradeVersion(int version) {
        this.setForcedUpgrade(version);
    }

    public void setForcedUpgrade(int version) {
        this.mForcedUpgradeVersion = version;
    }

    public void setForcedUpgrade() {
        this.setForcedUpgrade(this.mNewVersion);
    }

    private SQLiteDatabase createOrOpenDatabase(boolean force) throws SQLiteAssetException {
        SQLiteDatabase db = null;
        File file = new File(this.mDatabasePath + "/" + this.mName);
        if (file.exists()) {
            db = this.returnDatabase();
        }
        if (db != null) {
            if (force) {
                Log.w((String)TAG, (String)"forcing database upgrade!");
                this.copyDatabaseFromAssets();
                db = this.returnDatabase();
            }
            return db;
        }
        this.copyDatabaseFromAssets();
        db = this.returnDatabase();
        return db;
    }

    private SQLiteDatabase returnDatabase() {
        try {
            SQLiteDatabase db = SQLiteDatabase.openDatabase((String)(this.mDatabasePath + "/" + this.mName), (SQLiteDatabase.CursorFactory)this.mFactory, (int)0);
            Log.i((String)TAG, (String)("successfully opened database " + this.mName));
            return db;
        }
        catch (SQLiteException e) {
            Log.w((String)TAG, (String)("could not open database " + this.mName + " - " + e.getMessage()));
            return null;
        }
    }

    private void copyDatabaseFromAssets() throws SQLiteAssetException {
        InputStream is;
        Log.w((String)TAG, (String)"copying database from assets...");
        String path = this.mAssetPath;
        String dest = this.mDatabasePath + "/" + this.mName;
        boolean isZip = false;
        try {
            is = this.mContext.getAssets().open(path);
        }
        catch (IOException e) {
            try {
                is = this.mContext.getAssets().open(path + ".zip");
                isZip = true;
            }
            catch (IOException e2) {
                try {
                    is = this.mContext.getAssets().open(path + ".gz");
                }
                catch (IOException e3) {
                    SQLiteAssetException se = new SQLiteAssetException("Missing " + this.mAssetPath + " file (or .zip, .gz archive) in assets, or target folder not writable");
                    se.setStackTrace(e3.getStackTrace());
                    throw se;
                }
            }
        }
        try {
            File f = new File(this.mDatabasePath + "/");
            if (!f.exists()) {
                f.mkdir();
            }
            if (isZip) {
                ZipInputStream zis = Utils.getFileFromZip(is);
                if (zis == null) {
                    throw new SQLiteAssetException("Archive is missing a SQLite database file");
                }
                Utils.writeExtractedFileToDisk(zis, new FileOutputStream(dest));
            } else {
                Utils.writeExtractedFileToDisk(is, new FileOutputStream(dest));
            }
            Log.w((String)TAG, (String)"database copy complete");
        }
        catch (IOException e) {
            SQLiteAssetException se = new SQLiteAssetException("Unable to write " + dest + " to data directory");
            se.setStackTrace(e.getStackTrace());
            throw se;
        }
    }

    private InputStream getUpgradeSQLStream(int oldVersion, int newVersion) {
        String path = String.format(this.mUpgradePathFormat, oldVersion, newVersion);
        try {
            return this.mContext.getAssets().open(path);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("missing database upgrade script: " + path));
            return null;
        }
    }

    private void getUpgradeFilePaths(int baseVersion, int start, int end, ArrayList<String> paths) {
        int b;
        int a;
        InputStream is = this.getUpgradeSQLStream(start, end);
        if (is != null) {
            String path = String.format(this.mUpgradePathFormat, start, end);
            paths.add(path);
            a = start - 1;
            b = start;
            is = null;
        } else {
            a = start - 1;
            b = end;
        }
        if (a < baseVersion) {
            return;
        }
        this.getUpgradeFilePaths(baseVersion, a, b, paths);
    }

    public static class SQLiteAssetException
    extends SQLiteException {
        public SQLiteAssetException() {
        }

        public SQLiteAssetException(String error) {
            super(error);
        }
    }
}

