/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.loader;

import android.net.Uri;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.stream.InputStreamDataEmitter;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Loader;
import java.io.InputStream;

public class ContentLoader
implements Loader {
    @Override
    public Future<InputStream> load(Ion ion, AsyncHttpRequest request) {
        return null;
    }

    @Override
    public Future<DataEmitter> load(final Ion ion, final AsyncHttpRequest request, final FutureCallback<Loader.LoaderEmitter> callback) {
        if (!request.getUri().getScheme().startsWith("content")) {
            return null;
        }
        final InputStreamDataEmitterFuture ret = new InputStreamDataEmitterFuture();
        ion.getHttpClient().getServer().post(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream stream = ion.getContext().getContentResolver().openInputStream(Uri.parse((String)request.getUri().toString()));
                    if (stream == null) {
                        throw new Exception("Unable to load content stream");
                    }
                    int available = stream.available();
                    InputStreamDataEmitter emitter = new InputStreamDataEmitter(ion.getHttpClient().getServer(), stream);
                    ret.setComplete(emitter);
                    callback.onCompleted(null, (Object)new Loader.LoaderEmitter((DataEmitter)emitter, available, 1, null, null));
                }
                catch (Exception e) {
                    ret.setComplete(e);
                    callback.onCompleted(e, null);
                }
            }
        });
        return ret;
    }

    private static final class InputStreamDataEmitterFuture
    extends SimpleFuture<DataEmitter> {
        private InputStreamDataEmitterFuture() {
        }
    }
}

