/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.graphics.Bitmap;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.BitmapCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import java.io.InputStream;

class LoadBitmapStream
extends BitmapCallback
implements FutureCallback<InputStream> {
    int resizeWidth;
    int resizeHeight;

    public LoadBitmapStream(Ion ion, String urlKey, boolean put, int resizeWidth, int resizeHeight) {
        super(ion, urlKey, put);
        this.resizeWidth = resizeWidth;
        this.resizeHeight = resizeHeight;
    }

    public void loadInputStream(InputStream result) {
        try {
            Bitmap bitmap = this.ion.bitmapCache.loadBitmap(result, this.resizeWidth, this.resizeHeight);
            if (bitmap == null) {
                throw new Exception("bitmap failed to load");
            }
            BitmapInfo info = new BitmapInfo();
            info.key = this.key;
            info.bitmap = bitmap;
            info.loadedFrom = 1;
            this.report(null, info);
        }
        catch (Exception e) {
            this.report(e, null);
        }
    }

    public void onCompleted(Exception e, final InputStream result) {
        if (e != null) {
            this.report(e, null);
            return;
        }
        this.ion.getServer().getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                LoadBitmapStream.this.loadInputStream(result);
            }
        });
    }
}

