/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WebImageCache {
    private static final String DISK_CACHE_PATH = "/web_image_cache/";
    private ConcurrentHashMap<String, SoftReference<Bitmap>> memoryCache = new ConcurrentHashMap();
    private String diskCachePath;
    private boolean diskCacheEnabled = false;
    private ExecutorService writeThread;

    public WebImageCache(Context context) {
        Context context2 = context.getApplicationContext();
        this.diskCachePath = context2.getCacheDir().getAbsolutePath() + DISK_CACHE_PATH;
        File file = new File(this.diskCachePath);
        file.mkdirs();
        this.diskCacheEnabled = file.exists();
        this.writeThread = Executors.newSingleThreadExecutor();
    }

    public Bitmap get(String string) {
        Bitmap bitmap = null;
        bitmap = this.getBitmapFromMemory(string);
        if (bitmap == null && (bitmap = this.getBitmapFromDisk(string)) != null) {
            this.cacheBitmapToMemory(string, bitmap);
        }
        return bitmap;
    }

    public void put(String string, Bitmap bitmap) {
        this.cacheBitmapToMemory(string, bitmap);
        this.cacheBitmapToDisk(string, bitmap);
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        this.memoryCache.remove(this.getCacheKey(string));
        File file = new File(this.diskCachePath, string);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public void clear() {
        this.memoryCache.clear();
        File file = new File(this.diskCachePath);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.exists() || !file2.isFile()) continue;
                file2.delete();
            }
        }
    }

    private void cacheBitmapToMemory(String string, Bitmap bitmap) {
        this.memoryCache.put(this.getCacheKey(string), new SoftReference<Bitmap>(bitmap));
    }

    private void cacheBitmapToDisk(final String string, final Bitmap bitmap) {
        this.writeThread.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (WebImageCache.this.diskCacheEnabled) {
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(WebImageCache.this.diskCachePath, WebImageCache.this.getCacheKey(string))), 2048);
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bufferedOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    finally {
                        try {
                            if (bufferedOutputStream != null) {
                                bufferedOutputStream.flush();
                                bufferedOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    private Bitmap getBitmapFromMemory(String string) {
        Bitmap bitmap = null;
        SoftReference<Bitmap> softReference = this.memoryCache.get(this.getCacheKey(string));
        if (softReference != null) {
            bitmap = softReference.get();
        }
        return bitmap;
    }

    private Bitmap getBitmapFromDisk(String string) {
        String string2;
        File file;
        Bitmap bitmap = null;
        if (this.diskCacheEnabled && (file = new File(string2 = this.getFilePath(string))).exists()) {
            bitmap = BitmapFactory.decodeFile((String)string2);
        }
        return bitmap;
    }

    private String getFilePath(String string) {
        return this.diskCachePath + this.getCacheKey(string);
    }

    private String getCacheKey(String string) {
        if (string == null) {
            throw new RuntimeException("Null url passed in");
        }
        return string.replaceAll("[.:/,%?&=]", "+").replaceAll("[+]+", "+");
    }
}

