/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.loopj.android.image.SmartImage;

public class SmartImageTask
implements Runnable {
    private static final int BITMAP_READY = 0;
    private boolean cancelled = false;
    private OnCompleteHandler onCompleteHandler;
    private SmartImage image;
    private Context context;

    public SmartImageTask(Context context, SmartImage smartImage) {
        this.image = smartImage;
        this.context = context;
    }

    @Override
    public void run() {
        if (this.image != null) {
            this.complete(this.image.getBitmap(this.context));
            this.context = null;
        }
    }

    public void setOnCompleteHandler(OnCompleteHandler onCompleteHandler) {
        this.onCompleteHandler = onCompleteHandler;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void complete(Bitmap bitmap) {
        if (this.onCompleteHandler != null && !this.cancelled) {
            this.onCompleteHandler.sendMessage(this.onCompleteHandler.obtainMessage(0, bitmap));
        }
    }

    public static class OnCompleteHandler
    extends Handler {
        public void handleMessage(Message message) {
            Bitmap bitmap = (Bitmap)message.obj;
            this.onComplete(bitmap);
        }

        public void onComplete(Bitmap bitmap) {
        }
    }
}

