/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.Http20Draft09;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.Ping;
import com.squareup.okhttp.internal.spdy.PushObserver;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.Spdy3;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import com.squareup.okhttp.internal.spdy.Variant;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class SpdyConnection
implements Closeable {
    private static final ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp SpdyConnection", true));
    final Protocol protocol;
    final boolean client;
    private final IncomingStreamHandler handler;
    private final Map<Integer, SpdyStream> streams = new HashMap<Integer, SpdyStream>();
    private final String hostName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean shutdown;
    private long idleStartTimeNs = System.nanoTime();
    private Map<Integer, Ping> pings;
    private final PushObserver pushObserver;
    private int nextPingId;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final Settings okHttpSettings = new Settings();
    final Settings peerSettings = new Settings();
    private boolean receivedInitialPeerSettings = false;
    final FrameReader frameReader;
    final FrameWriter frameWriter;
    final long maxFrameSize;
    final Reader readerRunnable;
    private final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    private SpdyConnection(Builder builder) {
        Variant variant;
        this.protocol = builder.protocol;
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.handler = builder.handler;
        this.nextStreamId = builder.client ? 1 : 2;
        int n = this.nextPingId = builder.client ? 1 : 2;
        if (builder.client) {
            this.okHttpSettings.set(7, 0, 0x1000000);
        }
        this.hostName = builder.hostName;
        if (this.protocol == Protocol.HTTP_2) {
            variant = new Http20Draft09();
        } else if (this.protocol == Protocol.SPDY_3) {
            variant = new Spdy3();
        } else {
            throw new AssertionError((Object)this.protocol);
        }
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize(65536);
        this.frameReader = variant.newReader(builder.source, this.client);
        this.frameWriter = variant.newWriter(builder.sink, this.client);
        this.maxFrameSize = variant.maxFrameSize();
        this.readerRunnable = new Reader();
        new Thread(this.readerRunnable).start();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized SpdyStream getStream(int id) {
        return this.streams.get(id);
    }

    synchronized SpdyStream removeStream(int streamId) {
        SpdyStream stream = this.streams.remove(streamId);
        if (stream != null && this.streams.isEmpty()) {
            this.setIdle(true);
        }
        return stream;
    }

    private synchronized void setIdle(boolean value) {
        this.idleStartTimeNs = value ? System.nanoTime() : Long.MAX_VALUE;
    }

    public synchronized boolean isIdle() {
        return this.idleStartTimeNs != Long.MAX_VALUE;
    }

    public synchronized long getIdleStartTimeNs() {
        return this.idleStartTimeNs;
    }

    public SpdyStream pushStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        if (this.protocol != Protocol.HTTP_2) {
            throw new IllegalStateException("protocol != HTTP_2");
        }
        return this.newStream(associatedStreamId, requestHeaders, out, false);
    }

    public SpdyStream newStream(List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        return this.newStream(0, requestHeaders, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpdyStream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out, boolean in) throws IOException {
        SpdyStream stream;
        boolean outFinished = !out;
        boolean inFinished = !in;
        int priority = -1;
        int slot = 0;
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int streamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    throw new IOException("shutdown");
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new SpdyStream(streamId, this, outFinished, inFinished, priority, requestHeaders);
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                    this.setIdle(false);
                }
            }
            if (associatedStreamId == 0) {
                this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, priority, slot, requestHeaders);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.frameWriter.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
        }
        if (!out) {
            this.frameWriter.flush();
        }
        return stream;
    }

    void writeSynReply(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        this.frameWriter.synReply(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int streamId, boolean outFinished, OkBuffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.frameWriter.data(outFinished, streamId, buffer, 0);
            return;
        }
        while (byteCount > 0L) {
            int toWrite;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(Math.min(byteCount, this.bytesLeftInWriteWindow), this.maxFrameSize);
                this.bytesLeftInWriteWindow -= (long)toWrite;
            }
            this.frameWriter.data(outFinished && (byteCount -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int streamId, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writeSynReset(streamId, errorCode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void writeSynReset(int streamId, ErrorCode statusCode) throws IOException {
        this.frameWriter.rstStream(streamId, statusCode);
    }

    void writeWindowUpdateLater(final int streamId, final long unacknowledgedBytesRead) {
        executor.submit(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostName, streamId}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.frameWriter.windowUpdate(streamId, unacknowledgedBytesRead);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ping ping() throws IOException {
        int pingId;
        Ping ping = new Ping();
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.shutdown) {
                throw new IOException("shutdown");
            }
            pingId = this.nextPingId;
            this.nextPingId += 2;
            if (this.pings == null) {
                this.pings = new HashMap<Integer, Ping>();
            }
            this.pings.put(pingId, ping);
        }
        this.writePing(false, pingId, 1330343787, ping);
        return ping;
    }

    private void writePingLater(final boolean reply, final int payload1, final int payload2, final Ping ping) {
        executor.submit(new NamedRunnable("OkHttp %s ping %08x%08x", new Object[]{this.hostName, payload1, payload2}){

            @Override
            public void execute() {
                try {
                    SpdyConnection.this.writePing(reply, payload1, payload2, ping);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePing(boolean reply, int payload1, int payload2, Ping ping) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            if (ping != null) {
                ping.send();
            }
            this.frameWriter.ping(reply, payload1, payload2);
        }
    }

    private synchronized Ping removePing(int id) {
        return this.pings != null ? this.pings.remove(id) : null;
    }

    public void flush() throws IOException {
        this.frameWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode statusCode) throws IOException {
        FrameWriter frameWriter = this.frameWriter;
        synchronized (frameWriter) {
            int lastGoodStreamId;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                lastGoodStreamId = this.lastGoodStreamId;
            }
            this.frameWriter.goAway(lastGoodStreamId, statusCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ErrorCode connectionCode, ErrorCode streamCode) throws IOException {
        IOException thrown;
        block19: {
            assert (!Thread.holdsLock(this));
            thrown = null;
            try {
                this.shutdown(connectionCode);
            }
            catch (IOException e) {
                thrown = e;
            }
            SpdyStream[] streamsToClose = null;
            Ping[] pingsToCancel = null;
            SpdyConnection spdyConnection = this;
            synchronized (spdyConnection) {
                if (!this.streams.isEmpty()) {
                    streamsToClose = this.streams.values().toArray(new SpdyStream[this.streams.size()]);
                    this.streams.clear();
                    this.setIdle(false);
                }
                if (this.pings != null) {
                    pingsToCancel = this.pings.values().toArray(new Ping[this.pings.size()]);
                    this.pings = null;
                }
            }
            if (streamsToClose != null) {
                for (SpdyStream spdyStream : streamsToClose) {
                    try {
                        spdyStream.close(streamCode);
                    }
                    catch (IOException e) {
                        if (thrown == null) continue;
                        thrown = e;
                    }
                }
            }
            if (pingsToCancel != null) {
                for (SpdyStream spdyStream : pingsToCancel) {
                    ((Ping)((Object)spdyStream)).cancel();
                }
            }
            try {
                this.frameReader.close();
            }
            catch (IOException e) {
                thrown = e;
            }
            try {
                this.frameWriter.close();
            }
            catch (IOException e) {
                if (thrown != null) break block19;
                thrown = e;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    public void sendConnectionHeader() throws IOException {
        this.frameWriter.connectionHeader();
        this.frameWriter.settings(this.okHttpSettings);
    }

    private boolean pushedStream(int streamId) {
        return this.protocol == Protocol.HTTP_2 && streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRequestLater(final int streamId, final List<Header> requestHeaders) {
        SpdyConnection spdyConnection = this;
        synchronized (spdyConnection) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        executor.submit(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block5: {
                    boolean cancel = SpdyConnection.this.pushObserver.onRequest(streamId, requestHeaders);
                    try {
                        if (!cancel) break block5;
                        SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushHeadersLater(final int streamId, final List<Header> requestHeaders, final boolean inFinished) {
        executor.submit(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    boolean cancel = SpdyConnection.this.pushObserver.onHeaders(streamId, requestHeaders, inFinished);
                    try {
                        if (cancel) {
                            SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushDataLater(final int streamId, BufferedSource source, final int byteCount, final boolean inFinished) throws IOException {
        final OkBuffer buffer = new OkBuffer();
        source.require(byteCount);
        source.read(buffer, byteCount);
        if (buffer.size() != (long)byteCount) {
            throw new IOException(buffer.size() + " != " + byteCount);
        }
        executor.submit(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean cancel = SpdyConnection.this.pushObserver.onData(streamId, buffer, byteCount, inFinished);
                        if (cancel) {
                            SpdyConnection.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                        }
                        if (!cancel && !inFinished) break block6;
                        SpdyConnection spdyConnection = SpdyConnection.this;
                        synchronized (spdyConnection) {
                            SpdyConnection.this.currentPushRequests.remove(streamId);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void pushResetLater(final int streamId, final ErrorCode errorCode) {
        executor.submit(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostName, streamId}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                SpdyConnection.this.pushObserver.onReset(streamId, errorCode);
                SpdyConnection spdyConnection = SpdyConnection.this;
                synchronized (spdyConnection) {
                    SpdyConnection.this.currentPushRequests.remove(streamId);
                }
            }
        });
    }

    class Reader
    extends NamedRunnable
    implements FrameReader.Handler {
        private Reader() {
            super("OkHttp %s", SpdyConnection.this.hostName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            try {
                if (!SpdyConnection.this.client) {
                    SpdyConnection.this.frameReader.readConnectionHeader();
                }
                while (SpdyConnection.this.frameReader.nextFrame(this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    SpdyConnection.this.close(connectionErrorCode, streamErrorCode);
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushDataLater(streamId, source, length, inFinished);
                return;
            }
            SpdyStream dataStream = SpdyConnection.this.getStream(streamId);
            if (dataStream == null) {
                SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                source.skip(length);
                return;
            }
            dataStream.receiveData(source, length);
            if (inFinished) {
                dataStream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, int priority, List<Header> headerBlock, HeadersMode headersMode) {
            SpdyStream stream;
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushHeadersLater(streamId, headerBlock, inFinished);
                return;
            }
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                if (SpdyConnection.this.shutdown) {
                    return;
                }
                stream = SpdyConnection.this.getStream(streamId);
                if (stream == null) {
                    if (headersMode.failIfStreamAbsent()) {
                        SpdyConnection.this.writeSynResetLater(streamId, ErrorCode.INVALID_STREAM);
                        return;
                    }
                    if (streamId <= SpdyConnection.this.lastGoodStreamId) {
                        return;
                    }
                    if (streamId % 2 == SpdyConnection.this.nextStreamId % 2) {
                        return;
                    }
                    final SpdyStream newStream = new SpdyStream(streamId, SpdyConnection.this, outFinished, inFinished, priority, headerBlock);
                    SpdyConnection.this.lastGoodStreamId = streamId;
                    SpdyConnection.this.streams.put(streamId, newStream);
                    executor.submit(new NamedRunnable("OkHttp %s stream %d", new Object[]{SpdyConnection.this.hostName, streamId}){

                        @Override
                        public void execute() {
                            try {
                                SpdyConnection.this.handler.receive(newStream);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return;
                }
            }
            if (headersMode.failIfStreamPresent()) {
                stream.closeLater(ErrorCode.PROTOCOL_ERROR);
                SpdyConnection.this.removeStream(streamId);
                return;
            }
            stream.receiveHeaders(headerBlock, headersMode);
            if (inFinished) {
                stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            if (SpdyConnection.this.pushedStream(streamId)) {
                SpdyConnection.this.pushResetLater(streamId, errorCode);
                return;
            }
            SpdyStream rstStream = SpdyConnection.this.removeStream(streamId);
            if (rstStream != null) {
                rstStream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings newSettings) {
            long delta = 0L;
            SpdyStream[] streamsToNotify = null;
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                int peerInitialWindowSize;
                int priorWriteWindowSize = SpdyConnection.this.peerSettings.getInitialWindowSize(65536);
                if (clearPrevious) {
                    SpdyConnection.this.peerSettings.clear();
                }
                SpdyConnection.this.peerSettings.merge(newSettings);
                if (SpdyConnection.this.getProtocol() == Protocol.HTTP_2) {
                    this.ackSettingsLater();
                }
                if ((peerInitialWindowSize = SpdyConnection.this.peerSettings.getInitialWindowSize(65536)) != -1 && peerInitialWindowSize != priorWriteWindowSize) {
                    delta = peerInitialWindowSize - priorWriteWindowSize;
                    if (!SpdyConnection.this.receivedInitialPeerSettings) {
                        SpdyConnection.this.addBytesToWriteWindow(delta);
                        SpdyConnection.this.receivedInitialPeerSettings = true;
                    }
                    if (!SpdyConnection.this.streams.isEmpty()) {
                        streamsToNotify = SpdyConnection.this.streams.values().toArray(new SpdyStream[SpdyConnection.this.streams.size()]);
                    }
                }
            }
            if (streamsToNotify != null && delta != 0L) {
                Iterator i$ = SpdyConnection.this.streams.values().iterator();
                while (i$.hasNext()) {
                    SpdyStream stream;
                    SpdyStream spdyStream = stream = (SpdyStream)i$.next();
                    synchronized (spdyStream) {
                        stream.addBytesToWriteWindow(delta);
                    }
                }
            }
        }

        private void ackSettingsLater() {
            executor.submit(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{SpdyConnection.this.hostName}){

                @Override
                public void execute() {
                    try {
                        SpdyConnection.this.frameWriter.ackSettings();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void ping(boolean reply, int payload1, int payload2) {
            if (reply) {
                Ping ping = SpdyConnection.this.removePing(payload1);
                if (ping != null) {
                    ping.receive();
                }
            } else {
                SpdyConnection.this.writePingLater(true, payload1, payload2, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            if (debugData.size() > 0) {
                // empty if block
            }
            SpdyConnection spdyConnection = SpdyConnection.this;
            synchronized (spdyConnection) {
                SpdyConnection.this.shutdown = true;
                Iterator i = SpdyConnection.this.streams.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    int streamId = (Integer)entry.getKey();
                    if (streamId <= lastGoodStreamId || !((SpdyStream)entry.getValue()).isLocallyInitiated()) continue;
                    ((SpdyStream)entry.getValue()).receiveRstStream(ErrorCode.REFUSED_STREAM);
                    i.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                SpdyConnection spdyConnection = SpdyConnection.this;
                synchronized (spdyConnection) {
                    SpdyConnection.this.bytesLeftInWriteWindow += windowSizeIncrement;
                    SpdyConnection.this.notifyAll();
                }
            }
            SpdyStream stream = SpdyConnection.this.getStream(streamId);
            if (stream != null) {
                SpdyStream spdyStream = stream;
                synchronized (spdyStream) {
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                }
            }
        }

        @Override
        public void priority(int streamId, int priority) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            SpdyConnection.this.pushRequestLater(promisedStreamId, requestHeaders);
        }
    }

    public static class Builder {
        private String hostName;
        private BufferedSource source;
        private BufferedSink sink;
        private IncomingStreamHandler handler = IncomingStreamHandler.REFUSE_INCOMING_STREAMS;
        private Protocol protocol = Protocol.SPDY_3;
        private PushObserver pushObserver = PushObserver.CANCEL;
        private boolean client;

        public Builder(boolean client, Socket socket) throws IOException {
            this("", client, Okio.buffer(Okio.source(socket.getInputStream())), Okio.buffer(Okio.sink(socket.getOutputStream())));
        }

        public Builder(String hostName, boolean client, BufferedSource source, BufferedSink sink) {
            this.hostName = hostName;
            this.client = client;
            this.source = source;
            this.sink = sink;
        }

        public Builder handler(IncomingStreamHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public SpdyConnection build() {
            return new SpdyConnection(this);
        }
    }
}

