/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.MutableInteger;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.res.StringManager;

public class InternalNioOutputBuffer
implements OutputBuffer {
    int bbufLimit = 0;
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected MutableInteger lastWrite = new MutableInteger(1);
    protected NioChannel socket;
    protected NioSelectorPool pool;
    protected OutputBuffer outputStreamOutputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    int total = 0;

    public InternalNioOutputBuffer(Response response) {
        this(response, 49152);
    }

    public InternalNioOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbufLimit = headerBufferSize < 8192 ? 9000 : (headerBufferSize / 1500 + 1) * 1500;
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getMessage(200);
    }

    public void setSocket(NioChannel socket) {
        this.socket = socket;
    }

    public NioChannel getSocket() {
        return this.socket;
    }

    public void setSelectorPool(NioSelectorPool pool) {
        this.pool = pool;
    }

    public NioSelectorPool getSelectorPool() {
        return this.pool;
    }

    public void setSocketBuffer(int socketBufferSize) {
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        this.flushBuffer();
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.response.recycle();
    }

    public void recycle() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.socket.getBufHandler().getWriteBuffer().clear();
        this.socket = null;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.lastWrite.set(1);
    }

    public void nextRequest() {
        this.response.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    public boolean isWritable() {
        return this.lastWrite.get() > 0;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.socket.getBufHandler().getWriteBuffer().put(org.apache.coyote.http11.Constants.ACK_BYTES, 0, org.apache.coyote.http11.Constants.ACK_BYTES.length);
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int writeToSocket(ByteBuffer bytebuffer, boolean block, boolean flip) throws IOException {
        int written;
        block9: {
            if (flip) {
                bytebuffer.flip();
            }
            written = 0;
            NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
            if (att == null) {
                throw new IOException("Key must be cancelled");
            }
            long writeTimeout = att.getTimeout();
            Selector selector = null;
            try {
                selector = this.getSelectorPool().get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                written = this.getSelectorPool().write(bytebuffer, this.socket, selector, writeTimeout, block, this.lastWrite);
                while (!this.socket.flush(true, selector, writeTimeout, this.lastWrite)) {
                }
                Object var11_9 = null;
                if (selector == null) break block9;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (selector != null) {
                    this.getSelectorPool().put(selector);
                }
                throw throwable;
            }
            this.getSelectorPool().put(selector);
        }
        if (block) {
            bytebuffer.clear();
        }
        this.total = 0;
        return written;
    }

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.buf[this.pos++] = 32;
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(HttpMessages.getMessage(status));
        } else {
            this.write(message.replace('\n', ' ').replace('\r', ' '));
        }
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.addToBB(this.buf, 0, this.pos);
        }
    }

    private synchronized void addToBB(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            int thisTime = length;
            if (this.socket.getBufHandler().getWriteBuffer().position() == this.socket.getBufHandler().getWriteBuffer().capacity() || this.socket.getBufHandler().getWriteBuffer().remaining() == 0) {
                this.flushBuffer();
            }
            if (thisTime > this.socket.getBufHandler().getWriteBuffer().remaining()) {
                thisTime = this.socket.getBufHandler().getWriteBuffer().remaining();
            }
            this.socket.getBufHandler().getWriteBuffer().put(buf, offset, thisTime);
            length -= thisTime;
            offset += thisTime;
            this.total += thisTime;
        }
        NioEndpoint.KeyAttachment ka = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        if (ka != null) {
            ka.access();
        }
    }

    protected void write(MessageBytes mb) {
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.write(bc);
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            this.write(cc);
        } else {
            this.write(mb.toString());
        }
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, length);
        this.pos += length;
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    protected void flushBuffer() throws IOException {
        SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
        if (key != null) {
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)key.attachment();
            attach.access();
        }
        if (this.socket.getBufHandler().getWriteBuffer().position() > 0) {
            this.socket.getBufHandler().getWriteBuffer().flip();
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, false);
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            InternalNioOutputBuffer.this.addToBB(b, start, len);
            return chunk.getLength();
        }
    }
}

