/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.AnnotationProcessor;
import org.apache.catalina.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationProcessor
implements AnnotationProcessor {
    protected Context context = null;

    public DefaultAnnotationProcessor(Context context) {
        this.context = context;
    }

    @Override
    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return clazz2.getDeclaredMethods();
                    }
                });
            } else {
                methods = clazz.getDeclaredMethods();
            }
            AccessibleObject postConstruct = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(PostConstruct.class)) continue;
                if (postConstruct != null || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers()) || methods[i].getExceptionTypes().length > 0 || !methods[i].getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PostConstruct annotation");
                }
                postConstruct = methods[i];
            }
            if (postConstruct == null) continue;
            boolean accessibility = postConstruct.isAccessible();
            ((Method)postConstruct).setAccessible(true);
            ((Method)postConstruct).invoke(instance, new Object[0]);
            ((Method)postConstruct).setAccessible(accessibility);
        }
    }

    @Override
    public void preDestroy(Object instance) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            AccessibleObject preDestroy = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(PreDestroy.class)) continue;
                if (preDestroy != null || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers()) || methods[i].getExceptionTypes().length > 0 || !methods[i].getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PreDestroy annotation");
                }
                preDestroy = methods[i];
            }
            if (preDestroy == null) continue;
            boolean accessibility = preDestroy.isAccessible();
            ((Method)preDestroy).setAccessible(true);
            ((Method)preDestroy).invoke(instance, new Object[0]);
            ((Method)preDestroy).setAccessible(accessibility);
        }
    }

    @Override
    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                    @Override
                    public Field[] run() {
                        return clazz2.getDeclaredFields();
                    }
                });
            } else {
                fields = clazz.getDeclaredFields();
            }
            for (int i = 0; i < fields.length; ++i) {
                Annotation annotation;
                if (fields[i].isAnnotationPresent(Resource.class)) {
                    annotation = fields[i].getAnnotation(Resource.class);
                    DefaultAnnotationProcessor.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(EJB.class)) {
                    annotation = fields[i].getAnnotation(EJB.class);
                    DefaultAnnotationProcessor.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = fields[i].getAnnotation(WebServiceRef.class);
                    DefaultAnnotationProcessor.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = fields[i].getAnnotation(PersistenceContext.class);
                    DefaultAnnotationProcessor.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (!fields[i].isAnnotationPresent(PersistenceUnit.class)) continue;
                annotation = fields[i].getAnnotation(PersistenceUnit.class);
                DefaultAnnotationProcessor.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
            }
            Method[] methods = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return clazz2.getDeclaredMethods();
                    }
                });
            } else {
                methods = clazz.getDeclaredMethods();
            }
            for (int i = 0; i < methods.length; ++i) {
                Annotation annotation;
                if (methods[i].isAnnotationPresent(Resource.class)) {
                    annotation = methods[i].getAnnotation(Resource.class);
                    DefaultAnnotationProcessor.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(EJB.class)) {
                    annotation = methods[i].getAnnotation(EJB.class);
                    DefaultAnnotationProcessor.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = methods[i].getAnnotation(WebServiceRef.class);
                    DefaultAnnotationProcessor.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = methods[i].getAnnotation(PersistenceContext.class);
                    DefaultAnnotationProcessor.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (!methods[i].isAnnotationPresent(PersistenceUnit.class)) continue;
                annotation = methods[i].getAnnotation(PersistenceUnit.class);
                DefaultAnnotationProcessor.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
            }
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + field.getName());
        accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + method.getName().substring(3));
        accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }
}

