/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected static final String info = "org.apache.catalina.realm.JDBCRealm/1.0";
    protected static final String name = "JDBCRealm";
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    @Override
    public synchronized Principal authenticate(String username, String credentials) {
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            try {
                this.open();
                Principal principal = this.authenticate(this.dbConnection, username, credentials);
                return principal;
            }
            catch (SQLException e) {
                this.containerLog.error((Object)sm.getString("jdbcRealm.exception"), (Throwable)e);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    public synchronized Principal authenticate(Connection dbConnection, String username, String credentials) {
        if (username == null || credentials == null) {
            return null;
        }
        String dbCredentials = this.getPassword(username);
        boolean validated = false;
        validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(dbCredentials) : this.digest(credentials).equals(dbCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateSuccess", username));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return null;
        }
        ArrayList<String> roles = this.getRoles(username);
        return new GenericPrincipal(this, username, credentials, roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedCredentials = null;
        try {
            this.preparedRoles.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedRoles = null;
        try {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                this.containerLog.warn((Object)sm.getString("jdbcRealm.close"), (Throwable)e);
                Object var4_7 = null;
                this.dbConnection = null;
            }
            Object var4_6 = null;
            this.dbConnection = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.dbConnection = null;
            throw throwable;
        }
    }

    protected PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.userCredCol);
            sb.append(" FROM ");
            sb.append(this.userTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("credentials query: " + sb.toString()));
            }
            this.preparedCredentials = dbConnection.prepareStatement(sb.toString());
        }
        if (username == null) {
            this.preparedCredentials.setNull(1, 12);
        } else {
            this.preparedCredentials.setString(1, username);
        }
        return this.preparedCredentials;
    }

    @Override
    protected String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized String getPassword(String username) {
        dbCredentials = null;
        stmt = null;
        rs = null;
        numberOfTries = 2;
        while (true) {
            if (numberOfTries <= 0) {
                return null;
            }
            try {
                block19: {
                    block17: {
                        block15: {
                            block16: {
                                this.open();
                                try {
                                    stmt = this.credentials(this.dbConnection, username);
                                    rs = stmt.executeQuery();
                                    if (rs.next()) {
                                        dbCredentials = rs.getString(1);
                                    }
                                    rs.close();
                                    rs = null;
                                    if (dbCredentials == null) {
                                        var6_7 = null;
                                        var8_9 = null;
                                        if (rs == null) break block15;
                                        break block16;
                                    }
                                    var6_8 = dbCredentials = dbCredentials.trim();
                                    break block17;
                                }
                                catch (Throwable var7_15) {
                                    var8_11 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            this.containerLog.warn((Object)JDBCRealm.sm.getString("jdbcRealm.abnormalCloseResultSet"));
                                        }
                                    }
                                    this.dbConnection.commit();
                                    throw var7_15;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [3 : 109->119)] { 
lbl41:
                            // 1 sources

                            rs.close();
                            break block15;
lbl43:
                            // 1 sources

                            catch (SQLException e) {
                                this.containerLog.warn((Object)JDBCRealm.sm.getString("jdbcRealm.abnormalCloseResultSet"));
                            }
                        }
                        this.dbConnection.commit();
                        return var6_7;
                    }
                    var8_10 = null;
                    if (rs != null) {
                        ** try [egrp 2[TRYBLOCK] [3 : 109->119)] { 
lbl52:
                        // 1 sources

                        rs.close();
                        break block19;
lbl54:
                        // 1 sources

                        catch (SQLException e) {
                            this.containerLog.warn((Object)JDBCRealm.sm.getString("jdbcRealm.abnormalCloseResultSet"));
                        }
                    }
                }
                this.dbConnection.commit();
                return var6_8;
            }
            catch (SQLException e) {
                this.containerLog.error((Object)JDBCRealm.sm.getString("jdbcRealm.exception"), (Throwable)e);
                if (this.dbConnection != null) {
                    this.close(this.dbConnection);
                }
                --numberOfTries;
                continue;
            }
            break;
        }
    }

    @Override
    protected synchronized Principal getPrincipal(String username) {
        return new GenericPrincipal(this, username, this.getPassword(username), this.getRoles(username));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected ArrayList<String> getRoles(String username) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            try {
                ArrayList<String> arrayList;
                block10: {
                    this.open();
                    try {
                        ArrayList<String> roleList = new ArrayList<String>();
                        stmt = this.roles(this.dbConnection, username);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            String role = rs.getString(1);
                            if (null == role) continue;
                            roleList.add(role.trim());
                        }
                        rs.close();
                        rs = null;
                        arrayList = roleList;
                        Object var8_8 = null;
                        if (rs == null) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e) {
                                this.containerLog.warn((Object)sm.getString("jdbcRealm.abnormalCloseResultSet"));
                            }
                        }
                        this.dbConnection.commit();
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.containerLog.warn((Object)sm.getString("jdbcRealm.abnormalCloseResultSet"));
                    }
                }
                this.dbConnection.commit();
                return arrayList;
            }
            catch (SQLException e) {
                this.containerLog.error((Object)sm.getString("jdbcRealm.exception"), (Throwable)e);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    protected Connection open() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SQLException(e.getMessage());
            }
        }
        Properties props = new Properties();
        if (this.connectionName != null) {
            props.put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, props);
        if (this.dbConnection == null) {
            throw new SQLException(sm.getString("jdbcRealm.open.invalidurl", this.driverName, this.connectionURL));
        }
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected void release(Connection dbConnection) {
    }

    protected synchronized PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.roleNameCol);
            sb.append(" FROM ");
            sb.append(this.userRoleTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedRoles = dbConnection.prepareStatement(sb.toString());
        }
        this.preparedRoles.setString(1, username);
        return this.preparedRoles;
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
        try {
            this.open();
        }
        catch (SQLException e) {
            this.containerLog.error((Object)sm.getString("jdbcRealm.open"), (Throwable)e);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.dbConnection);
    }
}

