/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class TldConfig
implements LifecycleListener {
    private static final String JAR_EXT = ".jar";
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final boolean SCAN_CLASSPATH = Boolean.valueOf(System.getProperty("org.apache.jasper.compiler.TldLocationsCache.SCAN_CLASSPATH", "true"));
    private static final boolean SCAN_ALL_FILES = Boolean.valueOf(System.getProperty("org.apache.jasper.compiler.TldLocationsCache.SCAN_ALL_FILES", "false"));
    private static final boolean SCAN_ALL_DIRS = Boolean.valueOf(System.getProperty("org.apache.jasper.compiler.TldLocationsCache.SCAN_ALL_DIRS", "false"));
    private static HashSet<String> noTldJars;
    private static Log log;
    private static final StringManager sm;
    private static Digester[] tldDigesters;
    private Context context = null;
    private Digester tldDigester = null;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    private boolean rescan = true;
    private Set<String> taglibUris = new HashSet<String>();
    private ArrayList<String> listeners = new ArrayList();

    private static Digester createTldDigester(boolean namespaceAware, boolean validation) {
        Digester digester = null;
        if (!namespaceAware && !validation) {
            if (tldDigesters[0] == null) {
                TldConfig.tldDigesters[0] = DigesterFactory.newDigester(validation, namespaceAware, new TldRuleSet());
            }
            digester = tldDigesters[0];
        } else if (!namespaceAware && validation) {
            if (tldDigesters[1] == null) {
                TldConfig.tldDigesters[1] = DigesterFactory.newDigester(validation, namespaceAware, new TldRuleSet());
            }
            digester = tldDigesters[1];
        } else if (namespaceAware && !validation) {
            if (tldDigesters[2] == null) {
                TldConfig.tldDigesters[2] = DigesterFactory.newDigester(validation, namespaceAware, new TldRuleSet());
            }
            digester = tldDigesters[2];
        } else {
            if (tldDigesters[3] == null) {
                TldConfig.tldDigesters[3] = DigesterFactory.newDigester(validation, namespaceAware, new TldRuleSet());
            }
            digester = tldDigesters[3];
        }
        return digester;
    }

    public void addTaglibUri(String uri) {
        this.taglibUris.add(uri);
    }

    public boolean isKnownTaglibUri(String uri) {
        return this.taglibUris.contains(uri);
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public boolean isRescan() {
        return this.rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void addApplicationListener(String s) {
        log.debug((Object)("Add tld listener " + s));
        this.listeners.add(s);
    }

    public String[] getTldListeners() {
        String[] result = new String[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    public void execute() throws Exception {
        long t1 = System.currentTimeMillis();
        this.tldScanWebXml();
        this.tldScanResourcePaths(WEB_INF);
        this.tldScanWebInfLib();
        if (SCAN_CLASSPATH) {
            this.tldScanClassloaders();
        }
        String[] list = this.getTldListeners();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("tldConfig.addListeners", list.length));
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.addApplicationListener(list[i]);
        }
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(t2 - t1);
        }
    }

    private void tldScanWebXml() {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.webxmlStart"));
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String resourcePath = this.context.findTaglib(taglibs[i]);
            if (!resourcePath.startsWith("/")) {
                resourcePath = WEB_INF + resourcePath;
            }
            if (this.taglibUris.contains(taglibs[i])) {
                log.warn((Object)sm.getString("tldConfig.webxmlSkip", resourcePath, taglibs[i]));
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("tldConfig.webxmlAdd", resourcePath, taglibs[i]));
            }
            try {
                InputStream stream = this.context.getServletContext().getResourceAsStream(resourcePath);
                this.tldScanStream(stream);
                this.taglibUris.add(taglibs[i]);
                continue;
            }
            catch (IOException ioe) {
                log.warn((Object)sm.getString("tldConfig.webxmlFail", resourcePath, taglibs[i]), (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void tldScanResourcePaths(String startPath) {
        ServletContext ctxt;
        Set dirList;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.webinfScan", startPath));
        }
        if ((dirList = (ctxt = this.context.getServletContext()).getResourcePaths(startPath)) != null) {
            for (String path : dirList) {
                if (!path.endsWith(TLD_EXT) && (path.startsWith(WEB_INF_LIB) || path.startsWith("/WEB-INF/classes/"))) continue;
                if (path.endsWith(TLD_EXT)) {
                    if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) continue;
                    InputStream stream = ctxt.getResourceAsStream(path);
                    this.tldScanStream(stream);
                    Object var9_8 = null;
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                    continue;
                    {
                        catch (IOException ioe) {
                            log.warn((Object)sm.getString("tldConfig.webinfFail", path), (Throwable)ioe);
                            var9_8 = null;
                            if (stream == null) continue;
                            try {
                                stream.close();
                            }
                            catch (Throwable t) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                this.tldScanResourcePaths(path);
            }
        }
    }

    private void tldScanWebInfLib() {
        ServletContext ctxt;
        Set dirList;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.webinflibStart"));
        }
        if ((dirList = (ctxt = this.context.getServletContext()).getResourcePaths(WEB_INF_LIB)) != null) {
            for (String path : dirList) {
                if (!path.endsWith(JAR_EXT) || noTldJars.contains(path.substring(path.lastIndexOf(47)))) continue;
                URL url = null;
                try {
                    url = ctxt.getResource(path);
                    this.tldScanJar(url);
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("tldConfig.webinflibJarFail"), (Throwable)e);
                }
            }
        }
    }

    private void tldScanClassloaders() {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.classloaderStart"));
        }
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String jarName = this.getJarName(urls[i]);
                if (noTldJars.contains(jarName) || urls[i].toString().contains(WEB_INF_LIB + jarName)) continue;
                try {
                    this.tldScanJar(urls[i]);
                    continue;
                }
                catch (IOException ioe) {
                    log.warn((Object)sm.getString("tldConfig.classloaderFail", urls[i]), (Throwable)ioe);
                }
            }
        }
    }

    private void tldScanJar(URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.jarUrlStart", url));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            this.tldScanJar((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:")) {
                if (urlStr.endsWith(JAR_EXT)) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    this.tldScanJar((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && SCAN_ALL_FILES) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            this.tldScanJar((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && SCAN_ALL_DIRS && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            this.tldScanDir(metainf);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void tldScanDir(File start) {
        File[] fileList;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("tldConfig.dirScan", start.getAbsolutePath()));
        }
        if ((fileList = start.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    this.tldScanDir(fileList[i]);
                    continue;
                }
                if (!fileList[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream stream = null;
                stream = new FileInputStream(fileList[i]);
                this.tldScanStream(stream);
                Object var7_6 = null;
                if (stream == null) continue;
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable t) {}
                continue;
                {
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("tldConfig.dirFail", fileList[i].getAbsolutePath()), (Throwable)ioe);
                        var7_6 = null;
                        if (stream == null) continue;
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable t) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tldScanJar(JarURLConnection conn) throws IOException {
        JarFile jarFile = null;
        try {
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(TLD_EXT)) continue;
                InputStream stream = jarFile.getInputStream(entry);
                this.tldScanStream(stream);
            }
            Object var8_7 = null;
            if (jarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jarFile.close();
            return;
        }
        catch (Throwable t) {}
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(JAR_EXT);
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tldScanStream(InputStream resourceStream) throws IOException {
        InputSource source = new InputSource(resourceStream);
        Digester digester = this.tldDigester;
        synchronized (digester) {
            try {
                try {
                    this.tldDigester.push(this);
                    this.tldDigester.parse(source);
                }
                catch (SAXException s) {
                    IOException ioe = new IOException();
                    ioe.initCause(s);
                    throw ioe;
                }
                Object var7_4 = null;
                this.tldDigester.reset();
                if (resourceStream == null) return;
                {
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.tldDigester.reset();
                if (resourceStream == null) throw throwable;
                try {
                    resourceStream.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Throwable t) {}
            resourceStream.close();
            return;
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("tldConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("init")) {
            this.init();
        } else if (event.getType().equals("start")) {
            try {
                this.execute();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("tldConfig.execute", this.context.getPath()), (Throwable)e);
            }
        }
    }

    private void init() {
        if (this.tldDigester == null) {
            this.setTldValidation(this.context.getTldValidation());
            this.setTldNamespaceAware(this.context.getTldNamespaceAware());
            if (!this.context.getOverride()) {
                if (!this.tldValidation) {
                    this.setTldValidation(((StandardHost)this.context.getParent()).getXmlValidation());
                }
                if (!this.tldNamespaceAware) {
                    this.setTldNamespaceAware(((StandardHost)this.context.getParent()).getXmlNamespaceAware());
                }
            }
            this.tldDigester = TldConfig.createTldDigester(this.tldNamespaceAware, this.tldValidation);
        }
    }

    static {
        log = LogFactory.getLog(TldConfig.class);
        sm = StringManager.getManager("org.apache.catalina.startup");
        tldDigesters = new Digester[4];
        noTldJars = new HashSet();
        noTldJars.add("bootstrap.jar");
        noTldJars.add("commons-daemon.jar");
        noTldJars.add("tomcat-juli.jar");
        noTldJars.add("annotations-api.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-ha.jar");
        noTldJars.add("catalina-tribes.jar");
        noTldJars.add("el-api.jar");
        noTldJars.add("jasper.jar");
        noTldJars.add("jasper-el.jar");
        noTldJars.add("jasper-jdt.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("tomcat-dbcp.jar");
        noTldJars.add("tomcat-i18n-en.jar");
        noTldJars.add("tomcat-i18n-es.jar");
        noTldJars.add("tomcat-i18n-fr.jar");
        noTldJars.add("tomcat-i18n-ja.jar");
        noTldJars.add("ant.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        noTldJars.add("tools.jar");
        noTldJars.add("sunpkcs11.jar");
    }
}

