// Copyright (c) 2015 GitHub, Inc.
// Use of this source code is governed by the MIT license that can be
// found in the LICENSE file.

#ifndef SHELL_BROWSER_NET_HTTP_PROTOCOL_HANDLER_H_
#define SHELL_BROWSER_NET_HTTP_PROTOCOL_HANDLER_H_

#include <string>

#include "net/url_request/url_request_job_factory.h"

namespace electron {

class HttpProtocolHandler : public net::URLRequestJobFactory::ProtocolHandler {
 public:
  explicit HttpProtocolHandler(const std::string&);
  ~HttpProtocolHandler() override;

  // net::URLRequestJobFactory::ProtocolHandler:
  net::URLRequestJob* MaybeCreateJob(
      net::URLRequest* request,
      net::NetworkDelegate* network_delegate) const override;

 private:
  std::string scheme_;
};

}  // namespace electron

#endif  // SHELL_BROWSER_NET_HTTP_PROTOCOL_HANDLER_H_
