# Tool Introduction
This tool is designed to interface with a test to get the random numbers generated by the using a hash of a block of uninitialized SRAM.  In order to run the test a certain hardware setup is required due to the requirement to power off the DUT (device under test) for a certain time. Furthermore, the module detects button and/or software resets. If you push the reset button for example (without powering off the DUT), a warning should be printed to the console.

# Setup
## Required Tools
- DUT (a supported RIOT target board)
- USB to UART converter that supports setting the RTS pin and 5 volts (ie. FT232RL FTDI USB to TTL adapter)
- MOSFET to control power to the DUT (ie. STP36NF06L)
- Jumper cables
- Solderless breadboard

## Wiring Example
1. RTS <--> MOSFET gate pin (FT232RL RTS - STP36NF06L 1)
2. +5V <--> MOSFET drain pin (FT232RL 5V - STP36NF06L 2)
3. DUT Power <--> MOSFET source pin (E15 - STP36NF06L 3)
4. DUT UART TX <--> USB to UART RX
5. GND <--> GND

## Example Setup
![PUF SRAM test setup](https://raw.githubusercontent.com/wiki/RIOT-OS/RIOT/images/puf-sram-setup.jpg)


# Running the test
1. Plug the USB to UART converter in (it should be done first so it can autoconnect to the serial port)
2. Program the DUT with the puf_sram test
3. Connect all wires
4. change jumpers to only run on power provided by the USB to USRT converter
5. Run the example_test.py

# Running Custom Tests
Different tests can be run using the get_seed_list(self, n=10000, off_time=1, allow_print=False)
n -> the number of samples to take
off_time -> The time that the device is powered off to properly randomize the RAM
