RIOT-OS Code of Conduct
=======================

RIOT, like so many other free and open source software projects, is made up of a
mixed group of professionals and volunteers from all over the world, working on
every aspect of our goals - including teaching, steering, and connecting people.

We want diversity to be one of our greatest strengths, but it can also lead to
communication issues and unhappiness. This is why we ask people to adhere to a
few ground rules. They apply equally to founders, maintainers, contributors and
those seeking help and guidance.

This is not meant to be an exhaustive list of things you are not allowed to do.
We rather would like you to think of it as a guide to enrich our community and
the technical community in general with new knowledge and perspectives by
allowing everyone to participate.

This code of conduct applies to all spaces managed by the RIOT community. This
includes IRC, the mailing lists, our GitHub projects, face to face events, and
any other forums created by the community for communication within the
community. In addition, violations of this code outside these spaces may also
affect a person's ability to participate within them.

If you believe someone is violating the code of conduct, we ask that you report
it by emailing <conduct@riot-os.org>. For more details please see our [Reporting
Guidelines](https://github.com/RIOT-OS/RIOT/wiki/CoC:-Reporting-Guidelines).

-   **Be friendly and patient.**
-   **Be welcoming.** We strive to be a community that welcomes and supports
    people of all backgrounds and identities. This includes, but is not limited
    to members of any race, ethnicity, culture, national origin, colour,
    immigration status, social and economic class, educational level, sex,
    sexual orientation, gender identity and expression, age, size, family
    status, political belief, religion, and mental and physical ability.
-   **Be considerate.** Your work will be used by other people, and you in turn
    will depend on the work of others. Any decision you take will affect users
    and colleagues, and you should take those consequences into account when
    making decisions. Remember that we're a world-wide community, so you might
    not be communicating in someone else's primary language.
-   **Be respectful.** Not all of us will agree all the time, but disagreement
    is no excuse for poor behavior and poor manners. We might all experience
    some frustration now and then, but we cannot allow that frustration to turn
    into a personal attack. It’s important to remember that a community where
    people feel uncomfortable or threatened is not a productive one. Members of
    the RIOT community should be respectful when dealing with other members as
    well as with people outside the RIOT community.
-   **Be careful in the words that you choose.** We are a community of
    professionals, and we conduct ourselves professionally. Be kind to others.
    Do not insult or put down other participants. Harassment and other
    exclusionary behavior aren't acceptable. This includes, but is not limited
    to:
    -   Violent threats or language directed against another person.
    -   Discriminatory jokes and language.
    -   Posting sexually explicit or violent material.
    -   Posting (or threatening to post) other people's personally identifying
        information ("doxing").
    -   Personal insults, especially those using racist or sexist terms.
    -   Unwelcome sexual attention.
    -   Advocating for, or encouraging, any of the above behavior.
    -   Repeated harassment of others. In general, if someone asks you to stop,
        then stop.
-   **When we disagree, try to understand why.** Disagreements, both social and
    technical, happen all the time and RIOT is no exception. It is important
    that we resolve disagreements and differing views constructively. Remember
    that we’re different. The strength of RIOT comes from its varied community,
    people from a wide range of backgrounds. Different people have different
    perspectives on issues. Being unable to understand why someone holds a
    viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to
    err and blaming each other doesn’t get us anywhere. Instead, focus on
    helping to resolve issues and learning from mistakes.

Text based on the Code of Conduct of the [Django
community](https://www.djangoproject.com/conduct/).

Questions?
----------

If you have questions, please see [the FAQ](https://github.com/RIOT-OS/RIOT/wiki/CoC:-FAQ).
If that doesn't answer your questions, feel free to [contact us](mailto:conduct@riot-os.org).
