/**************************************************************************//**
 * @file em_device.h
 * @brief CMSIS Cortex-M Peripheral Access Layer for Silicon Laboratories
 *        microcontroller devices
 *
 * This is a convenience header file for defining the part number on the
 * build command line, instead of specifying the part specific header file.
 *
 * @verbatim
 * Example: Add "-DEFM32G890F128" to your build options, to define part
 *          Add "#include "em_device.h" to your source files

 *
 * @endverbatim
 * @version 5.4.0
 ******************************************************************************
 * # License
 * <b>Copyright 2017 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.@n
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.@n
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Laboratories, Inc.
 * has no obligation to support this Software. Silicon Laboratories, Inc. is
 * providing the Software "AS IS", with no express or implied warranties of any
 * kind, including, but not limited to, any implied warranties of
 * merchantability or fitness for any particular purpose or warranties against
 * infringement of any proprietary rights of a third party.
 *
 * Silicon Laboratories, Inc. will not be liable for any consequential,
 * incidental, or special damages, or any other relief, or for any claim by
 * any third party, arising from your use of this Software.
 *
 *****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif


#ifndef EM_DEVICE_H
#define EM_DEVICE_H

#if defined(EFM32LG230F128)
#include "efm32lg230f128.h"

#elif defined(EFM32LG230F256)
#include "efm32lg230f256.h"

#elif defined(EFM32LG230F64)
#include "efm32lg230f64.h"

#elif defined(EFM32LG232F128)
#include "efm32lg232f128.h"

#elif defined(EFM32LG232F256)
#include "efm32lg232f256.h"

#elif defined(EFM32LG232F64)
#include "efm32lg232f64.h"

#elif defined(EFM32LG280F128)
#include "efm32lg280f128.h"

#elif defined(EFM32LG280F256)
#include "efm32lg280f256.h"

#elif defined(EFM32LG280F64)
#include "efm32lg280f64.h"

#elif defined(EFM32LG290F128)
#include "efm32lg290f128.h"

#elif defined(EFM32LG290F256)
#include "efm32lg290f256.h"

#elif defined(EFM32LG290F64)
#include "efm32lg290f64.h"

#elif defined(EFM32LG295F128)
#include "efm32lg295f128.h"

#elif defined(EFM32LG295F256)
#include "efm32lg295f256.h"

#elif defined(EFM32LG295F64)
#include "efm32lg295f64.h"

#elif defined(EFM32LG330F128)
#include "efm32lg330f128.h"

#elif defined(EFM32LG330F256)
#include "efm32lg330f256.h"

#elif defined(EFM32LG330F64)
#include "efm32lg330f64.h"

#elif defined(EFM32LG332F128)
#include "efm32lg332f128.h"

#elif defined(EFM32LG332F256)
#include "efm32lg332f256.h"

#elif defined(EFM32LG332F64)
#include "efm32lg332f64.h"

#elif defined(EFM32LG360F128)
#include "efm32lg360f128.h"

#elif defined(EFM32LG360F256)
#include "efm32lg360f256.h"

#elif defined(EFM32LG360F64)
#include "efm32lg360f64.h"

#elif defined(EFM32LG380F128)
#include "efm32lg380f128.h"

#elif defined(EFM32LG380F256)
#include "efm32lg380f256.h"

#elif defined(EFM32LG380F64)
#include "efm32lg380f64.h"

#elif defined(EFM32LG390F128)
#include "efm32lg390f128.h"

#elif defined(EFM32LG390F256)
#include "efm32lg390f256.h"

#elif defined(EFM32LG390F64)
#include "efm32lg390f64.h"

#elif defined(EFM32LG395F128)
#include "efm32lg395f128.h"

#elif defined(EFM32LG395F256)
#include "efm32lg395f256.h"

#elif defined(EFM32LG395F64)
#include "efm32lg395f64.h"

#elif defined(EFM32LG840F128)
#include "efm32lg840f128.h"

#elif defined(EFM32LG840F256)
#include "efm32lg840f256.h"

#elif defined(EFM32LG840F64)
#include "efm32lg840f64.h"

#elif defined(EFM32LG842F128)
#include "efm32lg842f128.h"

#elif defined(EFM32LG842F256)
#include "efm32lg842f256.h"

#elif defined(EFM32LG842F64)
#include "efm32lg842f64.h"

#elif defined(EFM32LG880F128)
#include "efm32lg880f128.h"

#elif defined(EFM32LG880F256)
#include "efm32lg880f256.h"

#elif defined(EFM32LG880F64)
#include "efm32lg880f64.h"

#elif defined(EFM32LG890F128)
#include "efm32lg890f128.h"

#elif defined(EFM32LG890F256)
#include "efm32lg890f256.h"

#elif defined(EFM32LG890F64)
#include "efm32lg890f64.h"

#elif defined(EFM32LG895F128)
#include "efm32lg895f128.h"

#elif defined(EFM32LG895F256)
#include "efm32lg895f256.h"

#elif defined(EFM32LG895F64)
#include "efm32lg895f64.h"

#elif defined(EFM32LG900F256)
#include "efm32lg900f256.h"

#elif defined(EFM32LG940F128)
#include "efm32lg940f128.h"

#elif defined(EFM32LG940F256)
#include "efm32lg940f256.h"

#elif defined(EFM32LG940F64)
#include "efm32lg940f64.h"

#elif defined(EFM32LG942F128)
#include "efm32lg942f128.h"

#elif defined(EFM32LG942F256)
#include "efm32lg942f256.h"

#elif defined(EFM32LG942F64)
#include "efm32lg942f64.h"

#elif defined(EFM32LG980F128)
#include "efm32lg980f128.h"

#elif defined(EFM32LG980F256)
#include "efm32lg980f256.h"

#elif defined(EFM32LG980F64)
#include "efm32lg980f64.h"

#elif defined(EFM32LG990F128)
#include "efm32lg990f128.h"

#elif defined(EFM32LG990F256)
#include "efm32lg990f256.h"

#elif defined(EFM32LG990F64)
#include "efm32lg990f64.h"

#elif defined(EFM32LG995F128)
#include "efm32lg995f128.h"

#elif defined(EFM32LG995F256)
#include "efm32lg995f256.h"

#elif defined(EFM32LG995F64)
#include "efm32lg995f64.h"

#else
#error "em_device.h: PART NUMBER undefined"
#endif
#endif /* EM_DEVICE_H */
#ifdef __cplusplus
}
#endif

