<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [ (2021-10-20)](#2021-10-20)
  - [Breaking Changes](#breaking-changes)
    - [Bug Fixes](#bug-fixes)
    - [Code Refactoring](#code-refactoring)
    - [Documentation](#documentation)
    - [Features](#features)
    - [Reverts](#reverts)
    - [Tests](#tests)
    - [Unclassified](#unclassified)
- [0.7.6-alpha.1 (2021-09-12)](#076-alpha1-2021-09-12)
    - [Code Generation](#code-generation)
- [0.7.5-alpha.1 (2021-09-11)](#075-alpha1-2021-09-11)
    - [Code Generation](#code-generation-1)
- [0.7.4-alpha.1 (2021-09-09)](#074-alpha1-2021-09-09)
    - [Bug Fixes](#bug-fixes-1)
    - [Code Generation](#code-generation-2)
    - [Documentation](#documentation-1)
    - [Features](#features-1)
    - [Tests](#tests-1)
- [0.7.3-alpha.1 (2021-08-28)](#073-alpha1-2021-08-28)
    - [Bug Fixes](#bug-fixes-2)
    - [Code Generation](#code-generation-3)
    - [Documentation](#documentation-2)
    - [Features](#features-2)
- [0.7.1-alpha.1 (2021-07-22)](#071-alpha1-2021-07-22)
    - [Bug Fixes](#bug-fixes-3)
    - [Code Generation](#code-generation-4)
    - [Documentation](#documentation-3)
    - [Tests](#tests-2)
- [0.7.0-alpha.1 (2021-07-13)](#070-alpha1-2021-07-13)
  - [Breaking Changes](#breaking-changes-1)
    - [Bug Fixes](#bug-fixes-4)
    - [Code Generation](#code-generation-5)
    - [Code Refactoring](#code-refactoring-1)
    - [Documentation](#documentation-4)
    - [Features](#features-3)
    - [Tests](#tests-3)
    - [Unclassified](#unclassified-1)
- [0.6.3-alpha.1 (2021-05-17)](#063-alpha1-2021-05-17)
  - [Breaking Changes](#breaking-changes-2)
    - [Bug Fixes](#bug-fixes-5)
    - [Code Generation](#code-generation-6)
    - [Code Refactoring](#code-refactoring-2)
- [0.6.2-alpha.1 (2021-05-14)](#062-alpha1-2021-05-14)
    - [Code Generation](#code-generation-7)
    - [Documentation](#documentation-5)
- [0.6.1-alpha.1 (2021-05-11)](#061-alpha1-2021-05-11)
    - [Code Generation](#code-generation-8)
    - [Features](#features-4)
- [0.6.0-alpha.2 (2021-05-07)](#060-alpha2-2021-05-07)
    - [Bug Fixes](#bug-fixes-6)
    - [Code Generation](#code-generation-9)
    - [Features](#features-5)
- [0.6.0-alpha.1 (2021-05-05)](#060-alpha1-2021-05-05)
  - [Breaking Changes](#breaking-changes-3)
    - [Bug Fixes](#bug-fixes-7)
    - [Code Generation](#code-generation-10)
    - [Code Refactoring](#code-refactoring-3)
    - [Documentation](#documentation-6)
    - [Features](#features-6)
    - [Tests](#tests-4)
    - [Unclassified](#unclassified-2)
- [0.5.5-alpha.1 (2020-12-09)](#055-alpha1-2020-12-09)
    - [Bug Fixes](#bug-fixes-8)
    - [Code Generation](#code-generation-11)
    - [Documentation](#documentation-7)
    - [Features](#features-7)
    - [Tests](#tests-5)
    - [Unclassified](#unclassified-3)
- [0.5.4-alpha.1 (2020-11-11)](#054-alpha1-2020-11-11)
    - [Bug Fixes](#bug-fixes-9)
    - [Code Generation](#code-generation-12)
    - [Code Refactoring](#code-refactoring-4)
    - [Documentation](#documentation-8)
    - [Features](#features-8)
- [0.5.3-alpha.1 (2020-10-27)](#053-alpha1-2020-10-27)
    - [Bug Fixes](#bug-fixes-10)
    - [Code Generation](#code-generation-13)
    - [Documentation](#documentation-9)
    - [Features](#features-9)
    - [Tests](#tests-6)
- [0.5.2-alpha.1 (2020-10-22)](#052-alpha1-2020-10-22)
    - [Bug Fixes](#bug-fixes-11)
    - [Code Generation](#code-generation-14)
    - [Documentation](#documentation-10)
    - [Tests](#tests-7)
- [0.5.1-alpha.1 (2020-10-20)](#051-alpha1-2020-10-20)
    - [Bug Fixes](#bug-fixes-12)
    - [Code Generation](#code-generation-15)
    - [Documentation](#documentation-11)
    - [Features](#features-10)
    - [Tests](#tests-8)
    - [Unclassified](#unclassified-4)
- [0.5.0-alpha.1 (2020-10-15)](#050-alpha1-2020-10-15)
  - [Breaking Changes](#breaking-changes-4)
    - [Bug Fixes](#bug-fixes-13)
    - [Code Generation](#code-generation-16)
    - [Code Refactoring](#code-refactoring-5)
    - [Documentation](#documentation-12)
    - [Features](#features-11)
    - [Tests](#tests-9)
    - [Unclassified](#unclassified-5)
- [0.4.6-alpha.1 (2020-07-13)](#046-alpha1-2020-07-13)
    - [Bug Fixes](#bug-fixes-14)
    - [Code Generation](#code-generation-17)
- [0.4.5-alpha.1 (2020-07-13)](#045-alpha1-2020-07-13)
    - [Bug Fixes](#bug-fixes-15)
    - [Code Generation](#code-generation-18)
- [0.4.4-alpha.1 (2020-07-10)](#044-alpha1-2020-07-10)
    - [Bug Fixes](#bug-fixes-16)
    - [Code Generation](#code-generation-19)
    - [Documentation](#documentation-13)
- [0.4.3-alpha.1 (2020-07-08)](#043-alpha1-2020-07-08)
    - [Bug Fixes](#bug-fixes-17)
    - [Code Generation](#code-generation-20)
- [0.4.2-alpha.1 (2020-07-08)](#042-alpha1-2020-07-08)
    - [Bug Fixes](#bug-fixes-18)
    - [Code Generation](#code-generation-21)
- [0.4.0-alpha.1 (2020-07-08)](#040-alpha1-2020-07-08)
  - [Breaking Changes](#breaking-changes-5)
    - [Bug Fixes](#bug-fixes-19)
    - [Code Generation](#code-generation-22)
    - [Code Refactoring](#code-refactoring-6)
    - [Documentation](#documentation-14)
    - [Features](#features-12)
    - [Unclassified](#unclassified-6)
- [0.3.0-alpha.1 (2020-05-15)](#030-alpha1-2020-05-15)
  - [Breaking Changes](#breaking-changes-6)
    - [Bug Fixes](#bug-fixes-20)
    - [Chores](#chores)
    - [Code Refactoring](#code-refactoring-7)
    - [Documentation](#documentation-15)
    - [Features](#features-13)
    - [Unclassified](#unclassified-7)
- [0.2.1-alpha.1 (2020-05-05)](#021-alpha1-2020-05-05)
    - [Chores](#chores-1)
    - [Documentation](#documentation-16)
- [0.2.0-alpha.2 (2020-05-04)](#020-alpha2-2020-05-04)
  - [Breaking Changes](#breaking-changes-7)
    - [Bug Fixes](#bug-fixes-21)
    - [Chores](#chores-2)
    - [Code Refactoring](#code-refactoring-8)
    - [Documentation](#documentation-17)
    - [Features](#features-14)
    - [Unclassified](#unclassified-8)
- [0.1.1-alpha.1 (2020-02-18)](#011-alpha1-2020-02-18)
    - [Bug Fixes](#bug-fixes-22)
    - [Code Refactoring](#code-refactoring-9)
    - [Documentation](#documentation-18)
- [0.1.0-alpha.6 (2020-02-16)](#010-alpha6-2020-02-16)
    - [Bug Fixes](#bug-fixes-23)
    - [Code Refactoring](#code-refactoring-10)
    - [Documentation](#documentation-19)
    - [Features](#features-15)
- [0.1.0-alpha.5 (2020-02-06)](#010-alpha5-2020-02-06)
    - [Documentation](#documentation-20)
    - [Features](#features-16)
- [0.1.0-alpha.4 (2020-02-06)](#010-alpha4-2020-02-06)
    - [Continuous Integration](#continuous-integration)
    - [Documentation](#documentation-21)
- [0.1.0-alpha.3 (2020-02-06)](#010-alpha3-2020-02-06)
    - [Continuous Integration](#continuous-integration-1)
- [0.1.0-alpha.2 (2020-02-03)](#010-alpha2-2020-02-03)
    - [Bug Fixes](#bug-fixes-24)
    - [Documentation](#documentation-22)
    - [Features](#features-17)
    - [Unclassified](#unclassified-9)
- [0.1.0-alpha.1 (2020-01-31)](#010-alpha1-2020-01-31)
    - [Documentation](#documentation-23)
- [0.0.3-alpha.15 (2020-01-31)](#003-alpha15-2020-01-31)
    - [Unclassified](#unclassified-10)
- [0.0.3-alpha.14 (2020-01-31)](#003-alpha14-2020-01-31)
    - [Unclassified](#unclassified-11)
- [0.0.3-alpha.13 (2020-01-31)](#003-alpha13-2020-01-31)
    - [Unclassified](#unclassified-12)
- [0.0.3-alpha.11 (2020-01-31)](#003-alpha11-2020-01-31)
    - [Unclassified](#unclassified-13)
- [0.0.3-alpha.10 (2020-01-31)](#003-alpha10-2020-01-31)
    - [Unclassified](#unclassified-14)
- [0.0.3-alpha.7 (2020-01-30)](#003-alpha7-2020-01-30)
    - [Unclassified](#unclassified-15)
- [0.0.3-alpha.5 (2020-01-30)](#003-alpha5-2020-01-30)
    - [Continuous Integration](#continuous-integration-2)
    - [Unclassified](#unclassified-16)
- [0.0.3-alpha.4 (2020-01-30)](#003-alpha4-2020-01-30)
    - [Unclassified](#unclassified-17)
- [0.0.3-alpha.2 (2020-01-30)](#003-alpha2-2020-01-30)
    - [Unclassified](#unclassified-18)
- [0.0.3-alpha.1 (2020-01-30)](#003-alpha1-2020-01-30)
    - [Unclassified](#unclassified-19)
- [0.0.1-alpha.9 (2020-01-29)](#001-alpha9-2020-01-29)
    - [Continuous Integration](#continuous-integration-3)
- [0.0.2-alpha.1 (2020-01-29)](#002-alpha1-2020-01-29)
    - [Unclassified](#unclassified-20)
- [0.0.1-alpha.6 (2020-01-29)](#001-alpha6-2020-01-29)
    - [Continuous Integration](#continuous-integration-4)
- [0.0.1-alpha.5 (2020-01-29)](#001-alpha5-2020-01-29)
    - [Continuous Integration](#continuous-integration-5)
    - [Unclassified](#unclassified-21)
- [0.0.1-alpha.3 (2020-01-28)](#001-alpha3-2020-01-28)
    - [Continuous Integration](#continuous-integration-6)
- [0.0.1-alpha.2 (2020-01-28)](#001-alpha2-2020-01-28)
    - [Continuous Integration](#continuous-integration-7)
- [0.0.1-alpha.1 (2020-01-28)](#001-alpha1-2020-01-28)
    - [Documentation](#documentation-24)
    - [Unclassified](#unclassified-22)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# [](https://github.com/ory/kratos/compare/v0.7.6-alpha.1...v) (2021-10-20)
## Breaking Changes

The SDKs are now generated with tag v0alpha2 to reflect that some signatures have changed in a breaking fashion. Please update your imports from `v0alpha1` to `v0alpha2`.

To support 2FA on non-browser (e.g. native mobile) apps we have added the Ory Session Token as a possible parameter to both `initializeSelfServiceLoginFlowWithoutBrowser` and `submitSelfServiceLoginFlow`. Depending on the SDK generator, the order of the arguments may have changed. In JavaScript:

```patch
- .submitSelfServiceLoginFlow(flow.id, payload)
+ .submitSelfServiceLoginFlow(flow.id, sessionToken, payload)
+ // or if the user has no session yet:
+ .submitSelfServiceLoginFlow(flow.id, undefined, payload)
```

To improve the overall API design we have changed the result of `POST /self-service/settings`. Instead of having flow be a key, the flow is now the response. The updated identity payload stays the same!

```patch
 {
-  "flow": {
-    "id": "flow-id-..."
-    ...
-  },
+  "id": "flow-id-..."
+  ...
   "identity": {
     "id": "identity-id-..."
   }
 }
```

The SMTPS scheme used in courier config url with cleartext/StartTLS/TLS SMTP connection types is now only supporting implicit TLS. For StartTLS and cleartext SMTP, please use the smtp scheme instead.

Example:
- SMTP Cleartext: `smtp://foo:bar@my-mailserver:1234/?disable_starttls=true`
- SMTP with StartTLS: `smtps://foo:bar@my-mailserver:1234/` -> `smtp://foo:bar@my-mailserver:1234/`
- SMTP with implicit TLS: `smtps://foo:bar@my-mailserver:1234/?legacy_ssl=true` -> `smtps://foo:bar@my-mailserver:1234/`

This patch changes the naming and number of prometheus metrics (see: https://github.com/ory/x/pull/379). In short: all metrics will have now `http_` prefix to conform to Prometheus best practices.



### Bug Fixes

* Add error id ([1442784](https://github.com/ory/kratos/commit/1442784264d1f5032830a0646b853b925bb19c62))
* Add mfa e2e test scenarios and resolve found issues ([436992d](https://github.com/ory/kratos/commit/436992ddf2ace68b247c708fc955fccb95cf6fd2))
* Add middleware earlier [#1775](https://github.com/ory/kratos/issues/1775) ([#1776](https://github.com/ory/kratos/issues/1776)) ([b9d253e](https://github.com/ory/kratos/commit/b9d253ef05ff7cd616111a817d03a17e39f8f4a8))
* Allow refresh and aal upgrade at the same time ([2ec801f](https://github.com/ory/kratos/commit/2ec801f262cd8f6dcdf8121a20897257e3b74ad3))
* API client leaks stack trace with an error ([#1772](https://github.com/ory/kratos/issues/1772)) ([d3aff6d](https://github.com/ory/kratos/commit/d3aff6d3eb11942fbfd6f2de71f4399053075b62)), closes [#1771](https://github.com/ory/kratos/issues/1771)
* Better const handling for internal context ([1e457e3](https://github.com/ory/kratos/commit/1e457e3b3dea9ea9a05c12740578af2d45902aba))
* Correct swagger path for /identities/:id/session endpoint ([#1756](https://github.com/ory/kratos/issues/1756)) ([d614f2a](https://github.com/ory/kratos/commit/d614f2a737eef90ad60a4bdedae248b74131ff35))
* Decoder regression in registration ([febf75a](https://github.com/ory/kratos/commit/febf75ae959a2b67c19fcd1705b591f22ff5314b))
* Deterministic clidoc dates ([e48d90a](https://github.com/ory/kratos/commit/e48d90ad5a178ab3317d89800526c516aad6e274))
* Disable totp per default ([7278589](https://github.com/ory/kratos/commit/7278589ff2460a13302650b5e3fae01d774f9684))
* Docs autogen should not use `time.Now` ([a830f5b](https://github.com/ory/kratos/commit/a830f5b3b535bc375e879c797626b6084b76776e))
* Ensure refresh issues a new session when the identity changes ([a10b385](https://github.com/ory/kratos/commit/a10b385510a0102ede5850f9be30b7deba810acf))
* Ensure return_to works for OIDC flows ([d615734](https://github.com/ory/kratos/commit/d615734c312db6f7fa48fb8c7b4090a80c9e5ce7)), closes [#1773](https://github.com/ory/kratos/issues/1773)
* Explicit validation for return to in new flows ([284cf29](https://github.com/ory/kratos/commit/284cf29a6be82530b55c24a15c465ec9f1b6a210))
* Follow chrome webauthn best practice recommendation ([0a7c812](https://github.com/ory/kratos/commit/0a7c8128bb0b78f8dc236af06ca9be038b201829))
* Githup-app name in config ([#1822](https://github.com/ory/kratos/issues/1822)) ([1b50963](https://github.com/ory/kratos/commit/1b50963525ceaceea9afb8d1236d728de3107a8e))
* Handle return errors on the frontend and break early ([0e8d481](https://github.com/ory/kratos/commit/0e8d481cc220777aa56faf2e716da15537fa27fc)):

    Closes https://github.com/ory-corp/cloud/issues/1426

* Identity credential identifiers are now unique per method ([57fd99a](https://github.com/ory/kratos/commit/57fd99ac05d29fc0362f14e5910641944232d61e))
* **link:** Resolve incorrect response types when opening API recovery link in browser ([35ea8db](https://github.com/ory/kratos/commit/35ea8db300c2d3eeaf7d8f0e29c604ecc455cd2b))
* **login:** Properly handle refresh ([8dc7059](https://github.com/ory/kratos/commit/8dc7059222fa12dd0bca0183f42306b5169addb6))
* **lookup:** Ensure correct fields are set ([5ed4c55](https://github.com/ory/kratos/commit/5ed4c5572f9cbb35461e45dfc6b7c5eb4bce7434))
* **lookup:** Resolve reuse scenarios ([dbfe475](https://github.com/ory/kratos/commit/dbfe475ba5f0d2b9d4b0b67d0d8e7cb99e89ad5d))
* **lookup:** Set up codes correctly ([2f373f3](https://github.com/ory/kratos/commit/2f373f344326fbd5dbebf6233dbf5b56252b7e95))
* OIDC provider field in spec ([#1809](https://github.com/ory/kratos/issues/1809)) ([11b25de](https://github.com/ory/kratos/commit/11b25deb46b73c7d0ab95a77ff2ab60c032c1942))
* **oidc:** Ensure nested keys work on login ([71583c5](https://github.com/ory/kratos/commit/71583c57f1334bee1e5c9be1fae6a1b241ea3d6d))
* Omitempty for VerifiedAt and StateChangedAt ([#1736](https://github.com/ory/kratos/issues/1736)) ([bf2ec6e](https://github.com/ory/kratos/commit/bf2ec6e6ae8d656ea6dcac037dedd3603ad12915)):

    Closes https://github.com/ory/sdk/issues/95
    
    

* Panic when recovering deactivated user ([0a49f27](https://github.com/ory/kratos/commit/0a49f2714991a3f397dc5c721fe22d11846d3db5)), closes [#1794](https://github.com/ory/kratos/issues/1794) [#1826](https://github.com/ory/kratos/issues/1826)
* Properly open recovery endpoints in browser if flow was initiated via API ([23c12e5](https://github.com/ory/kratos/commit/23c12e55d24591ca69c9178017355a9262fa35eb))
* Remove duplicate schema error ([4e69123](https://github.com/ory/kratos/commit/4e691238da3bf3ee8d9a92d4d9507b27fce20199))
* Remove initial_value again as it was not useful outside of booleans ([0cc984b](https://github.com/ory/kratos/commit/0cc984b85baff3db500fb656bd541cfa0396df98))
* Remove obsolete openapi patch ([11618ec](https://github.com/ory/kratos/commit/11618ecc6681a9108ee70a3e0d1ab3d21e33f9db))
* Remove unnecessary cmd reference ([351760e](https://github.com/ory/kratos/commit/351760ece01d421687179b8e3f6f48a720247a1d))
* Replace 302 with 303 ([2e2b0f8](https://github.com/ory/kratos/commit/2e2b0f840450c6d23f3e51e5885d0908685ef3f6))
* Resolve clidoc generation issue ([1aaaa03](https://github.com/ory/kratos/commit/1aaaa035f863852799575e1f65e9d9ed276a3160))
* Resolve merge issues ([1dc7497](https://github.com/ory/kratos/commit/1dc74976c785afca8079379cd5060116b5f3d831))
* Resolve openapi issues and regenerate clients ([f7d60c0](https://github.com/ory/kratos/commit/f7d60c02392d2ad664c73ee4ff6bb108a4cb04e2))
* Resolve swagger regression ([02b9d47](https://github.com/ory/kratos/commit/02b9d470df012ae9818a8516a5549aee83c0963d))
* Run format on ts files ([f55f6f6](https://github.com/ory/kratos/commit/f55f6f69bf0df88d001fda791b330bdcbf5d92b2))
* **test:** OIDC storategy test ([#1836](https://github.com/ory/kratos/issues/1836)) ([b877dbe](https://github.com/ory/kratos/commit/b877dbecaf84e2d102bcceff4ad85c5b4efe18c5))
* **totp:** Reorder QR ([d096df7](https://github.com/ory/kratos/commit/d096df734ba8cf7dcfb872af03a19550d320c8b7))
* Typo ([8c4d8a2](https://github.com/ory/kratos/commit/8c4d8a2284f7a52a2dca7e7fd5e686756d410647))
* **ui:** Use correct type for anchor ([a6595e4](https://github.com/ory/kratos/commit/a6595e49c38a302f4a603dd46f5a0764680a24b1))
* Use parallelism of 1 in go test ([8736334](https://github.com/ory/kratos/commit/8736334bf11fc9a742e2972aa97ee56c407c7c0c))
* **webauthn:** Support react-based webauth ([b6123b4](https://github.com/ory/kratos/commit/b6123b4840547b295be44272e76454462a0f60c4))
* X-session-token must not be mandatory ([05d73be](https://github.com/ory/kratos/commit/05d73beed26f1be31c6f2a62499c7c71d7d54bec))

### Code Refactoring

* **courier:** Support SMTP schemes for implicit TLS, explicit StartTLS, and cleartext SMTP ([#1831](https://github.com/ory/kratos/issues/1831)) ([4cb082c](https://github.com/ory/kratos/commit/4cb082ce1e15ddd1d992a2def9e7d6410142cc02)), closes [#1770](https://github.com/ory/kratos/issues/1770) [#1769](https://github.com/ory/kratos/issues/1769)
* Improved prometheus metrics ([#1830](https://github.com/ory/kratos/issues/1830)) ([0be993b](https://github.com/ory/kratos/commit/0be993bebeb9e50d90806ad13f60bb8d72c3b2d3)), closes [#1735](https://github.com/ory/kratos/issues/1735):

    This will add new prometheus metrics for Kratos that are more useful for alerting and increase overall observability.

* **login:** Rename forced -> refresh ([8d1e54b](https://github.com/ory/kratos/commit/8d1e54bd79cf617985602997f1121e168f58c389))
* **login:** Support 2FA for non-browser SDKs ([df4846d](https://github.com/ory/kratos/commit/df4846d3867599f49e58b6b4d59b338916f37cbf))
* Move expired error into top-level flow module ([01a2602](https://github.com/ory/kratos/commit/01a26025375f1d958a7e345c61fb6ba5e3403efe))
* Move node identifiers to node package ([b0a86dc](https://github.com/ory/kratos/commit/b0a86dc6e5005017a9a0fa2120560f668ab2432f))
* Revert decision to return 422 errors and streamline 401/403 ([8aa5318](https://github.com/ory/kratos/commit/8aa53187f1e78d693463a47fcd9aedab30d1b55f))
* Sdk API is no v0alpha2 ([3f06738](https://github.com/ory/kratos/commit/3f067386e32ad3baeec48fd21dd51659a5725970))
* **session:** CreateAndIssueCookie is now UpsertAndIssueCookie ([a6d134d](https://github.com/ory/kratos/commit/a6d134de7710c7e92e51f735f13b7757eb7011e5))
* **session:** CreateSession is now UpsertSession ([3ec81a2](https://github.com/ory/kratos/commit/3ec81a2cc401ff18052abd2a9ba060e665f0baa2))
* **settings:** Change settings success response ([12f98f2](https://github.com/ory/kratos/commit/12f98f2884294669bbb7eab7e8ed73a5372386f6))

### Documentation

* Add 2fa credentials ([f7899a7](https://github.com/ory/kratos/commit/f7899a761aaf59d2cfddc2c330a805456cfca947))
* Add 2fa guide ([b4eed76](https://github.com/ory/kratos/commit/b4eed76305ecf1de3461525fd2ea748ec94da53c))
* Add a commandline example for the logout ([#1753](https://github.com/ory/kratos/issues/1753)) ([81ba264](https://github.com/ory/kratos/commit/81ba2647a66fca99b7ed2e56a67deec75ac06b89))
* Add admin ui guide ([ac88060](https://github.com/ory/kratos/commit/ac88060ed7390f0a34db637880c1660b8c45b352))
* Add advanced custom UI documentation ([5e3a2cd](https://github.com/ory/kratos/commit/5e3a2cdbedf0005c89db717d1136c56ab3304ede))
* Add image assets ([6bc93ca](https://github.com/ory/kratos/commit/6bc93ca79283bd993b0176dda11ad9d5860a5e4f))
* Add missing angle bracket ([#1799](https://github.com/ory/kratos/issues/1799)) ([4270140](https://github.com/ory/kratos/commit/427014052ef905c2003e2cd0133d57bf83819776))
* Add ory sessions as a concept ([626c0c9](https://github.com/ory/kratos/commit/626c0c90bd2d683048618452ba421e40be92f587))
* Add powershell to deps ([#1853](https://github.com/ory/kratos/issues/1853)) ([e945336](https://github.com/ory/kratos/commit/e94533690b658c4afba81e694a052579f0ffff42)), closes [#1848](https://github.com/ory/kratos/issues/1848)
* **credentials:** Add AAL explanation ([c1f501e](https://github.com/ory/kratos/commit/c1f501e9ec3ba203fb252fbd56cb87843d667b17))
* Enhance error return values ([3799c24](https://github.com/ory/kratos/commit/3799c24fbc0397876df4f1c530e325bd1212d750))
* Fix invalid syntax ([#1819](https://github.com/ory/kratos/issues/1819)) ([8cd6428](https://github.com/ory/kratos/commit/8cd6428e40610fa40b9c59414beb3d5c614dddaa))
* Fix the flow links used for rendering ([#1752](https://github.com/ory/kratos/issues/1752)) ([131d2c2](https://github.com/ory/kratos/commit/131d2c284d4191ee979077937ea3b48fce772f3c))
* Remove obsolete file ([b7f9052](https://github.com/ory/kratos/commit/b7f905278edf4aed1e2984aa3d2d94a41368d6d8))
* Update generated docs ([72afb81](https://github.com/ory/kratos/commit/72afb81be8bfaa36236087ec7715bca1804aa62c))
* Update quickstart curl examples ([#1778](https://github.com/ory/kratos/issues/1778)) ([6c677c4](https://github.com/ory/kratos/commit/6c677c49df8fa8d48e7c0bbf91bbd18874f4c514))
* Use correct link ([f007919](https://github.com/ory/kratos/commit/f007919b7bd86c1d1b20b3625709e01b5f123302)), closes [#1793](https://github.com/ory/kratos/issues/1793)

### Features

* Add `intended_for_someone_else` error code ([572a131](https://github.com/ory/kratos/commit/572a1315aec7d1103c8d4fb9c128644ea2af6d3b))
* Add aal fallback for existing sessions ([a5c7b11](https://github.com/ory/kratos/commit/a5c7b1143bca7029bf94fc42fe638534961a06bc))
* Add authenticators after set up ([035c276](https://github.com/ory/kratos/commit/035c276152a22a2c9c7159b1cf89dbe7724728dd))
* Add DeleteCredentialsType to identity struct including tests ([b12bf52](https://github.com/ory/kratos/commit/b12bf523e4213e49f545206c457a1739f493d385))
* Add e2e tests for react native 2fa ([a3ac253](https://github.com/ory/kratos/commit/a3ac253bdb9c42df6dce9288a2e7c2dada24d255))
* Add error ids for csrf-related errors ([dc2adbf](https://github.com/ory/kratos/commit/dc2adbf52f7ee845778ee5c3c943b9e10c41e181))
* Add error ids for redirect-related errors ([246a045](https://github.com/ory/kratos/commit/246a0453e65e70635331c95ff02ec9133ae81e46))
* Add error ids for session-related errors ([087d907](https://github.com/ory/kratos/commit/087d90731185b71cd88cc6451ce360d6c1dada34))
* Add explicit return_to to flow objects and API parameters ([50d04ea](https://github.com/ory/kratos/commit/50d04eaa455932a9a5cc31f812f66518e1d4ad3b)), closes [#1605](https://github.com/ory/kratos/issues/1605) [#1121](https://github.com/ory/kratos/issues/1121):

    This patch adds a `return_to` field to the flow objects which contains the original `?return_to=...` value. It uses the Flow's `request_url` for that purpose.

* Add ids for user-facing errors for login, registration, settings ([787558b](https://github.com/ory/kratos/commit/787558b48fd7405ac61a48d3c18c7252ac1aaf19)):

    This patch adds a new field `id` to JSON error payloads. This helps tremendously in implementing better client-side (native / SPA) apps as the API now returns error IDs like `no_active_session`, `orbidden_return_to`, `no_verified_address` and more. UIs can use these IDs to decide what to do next in the application - for example redirecting to a particular endpoint or showing an error message.

* Add initial value to bool checkboxes ([63dba73](https://github.com/ory/kratos/commit/63dba737376dbe2f15c5afb5df22c593328c6483))
* Add internal context to login and registration ([723e6ee](https://github.com/ory/kratos/commit/723e6eee731d34f85bc4346a1040f2f121662ae9))
* Add internal context to settings flow ([afb6895](https://github.com/ory/kratos/commit/afb6895daa8743edbf4fca957b2a156e676ef63a))
* Add lookup node to disable lookup ([d0836be](https://github.com/ory/kratos/commit/d0836beb53709c88eb9ed78df39e95a3204c7cec)):

    See https://github.com/ory/cloud/issues/12

* Add lookup to config ([14119b6](https://github.com/ory/kratos/commit/14119b623941b6f5e795ef0d369ee9e3adb73207))
* Add lookup to identity ([ead3833](https://github.com/ory/kratos/commit/ead3833e254b4939f2b86b34e954580960cc7ea1))
* Add lookup to migrations ([dac4f75](https://github.com/ory/kratos/commit/dac4f759a0b92c1eebca177c3c931fb3146e7dee))
* Add MFA enforcment option to whoami and settings ([554d725](https://github.com/ory/kratos/commit/554d72552702818c8f1fc45fd1daf9d93c0d2cad))
* Add mfa for non-browser ([4096fd3](https://github.com/ory/kratos/commit/4096fd3fbdb430fd325b38fe9102defa31dd1b6d))
* Add missing migrations ([ccc64d8](https://github.com/ory/kratos/commit/ccc64d87935c6b5ad506dce6a5f903d56541f864))
* Add option to disable recovery codes ([9d3daa6](https://github.com/ory/kratos/commit/9d3daa656a5361ef8a90fe3511f9c1a6e9015969)):

    Closes https://github.com/ory/cloud/issues/12

* Add schema patch for new initial_value field ([131e380](https://github.com/ory/kratos/commit/131e3803ff6d04af9ec668286c8e6fcf88467214)):

    The field sets a node input's initial value. This is primarily used for fields which are e.g. checkboxes or buttons (active/inactive). If this field is set on a button, it implies that clicking the button should trigger the "value" to be set.

* Add script type and discriminator for attributes ([de0af95](https://github.com/ory/kratos/commit/de0af955904894d97997cf598686b6d33cd88bd4)):

    See https://github.com/ory/sdk/issues/72

* Add smtp headers config option ([#1747](https://github.com/ory/kratos/issues/1747)) ([7ffe0e9](https://github.com/ory/kratos/commit/7ffe0e9766e930615dbb6833e650b73a8975a544)), closes [#1725](https://github.com/ory/kratos/issues/1725)
* Add support for onclick javascript in ui nodes ([7cc7efa](https://github.com/ory/kratos/commit/7cc7efa00ff0e8107f1369573bfdf766fcfc0e93))
* Add totp strategy for settings flow ([d1d6617](https://github.com/ory/kratos/commit/d1d6617013fbcc37eaf48cf19061b86955fc5d5e)):

    This patch allows adding a TOTP device in the settings, and also removing it when no longer needed.

* Add webauthn identity credential ([f8b9582](https://github.com/ory/kratos/commit/f8b95828ea41d29c7f3577cc7772168135bc5514))
* Adding Dockle Container Linter ([#1852](https://github.com/ory/kratos/issues/1852)) ([3c0d519](https://github.com/ory/kratos/commit/3c0d519dd47657c6adca3d64bca8b3ed02cb7a8f))
* Adjust to new aal error handling ([b8956bc](https://github.com/ory/kratos/commit/b8956bc0fc8a45e88dd51f79608f9d6c34e2b6f3))
* API to return access, refresh, id tokens from social sign in ([#1818](https://github.com/ory/kratos/issues/1818)) ([198991a](https://github.com/ory/kratos/commit/198991a9ce25fbaccc927be3bd3f6b1593771bec)), closes [#1518](https://github.com/ory/kratos/issues/1518) [#397](https://github.com/ory/kratos/issues/397):

    This patch introduces the new `include_credential` query parameter to the `GET /identities` endpoint which allows administrators to receive the initial access, refresh, and ID tokens from Social Sign In (OpenID Connect / OAuth 2.0) flows.
    
    These tokens can be stored in an encrypted format (XChaCha20Poly1305 or AES-GCM) in the database if an appropriate encryption secret is set. To get started easily these values are not encrypted per default.
    
    For more information head [over to the docs](https://kratos/docs/guides/retrieve-social-sign-in-access-refresh-id-token).

* Auto-generate list of messages ([cf46339](https://github.com/ory/kratos/commit/cf46339b9a07cd72b4d01e40c2df72e6c8104e9b)), closes [#1784](https://github.com/ory/kratos/issues/1784)
* Endpoint to list all identity schemas ([#1703](https://github.com/ory/kratos/issues/1703)) ([aa23d5d](https://github.com/ory/kratos/commit/aa23d5d5af28d8a7789b4a0c7e97197c7758ad98)), closes [#1699](https://github.com/ory/kratos/issues/1699)
* Generate sdks and update versions ([c9d22d9](https://github.com/ory/kratos/commit/c9d22d91f5fe49b5f2818160ade58bfd265f03e5))
* Identity schema validation on startup ([#1779](https://github.com/ory/kratos/issues/1779)) ([99db3f0](https://github.com/ory/kratos/commit/99db3f03afd4b2525cbce54133a1abd1d49d2886)), closes [#701](https://github.com/ory/kratos/issues/701)
* **identity:** Add AAL constants ([882573d](https://github.com/ory/kratos/commit/882573df5621446e799b17ca0ab09d3934e44437))
* Implement AAL for login and sessions ([45467e0](https://github.com/ory/kratos/commit/45467e0caba7ed31e2ebde71a8b32ecd5f8db7c2))
* Implement endpoint for invalidating all sessions for a given identity ([#1740](https://github.com/ory/kratos/issues/1740)) ([dbd1689](https://github.com/ory/kratos/commit/dbd1689c11fd0a3d999ea09b553dd4a14a7a6972)), closes [#655](https://github.com/ory/kratos/issues/655):

    This PR introduces endpoint to destroy all sessions for a given identity which effectively logouts user from all devices/sessions. This is useful when for some security concern we want to make sure there are no "old" sessions active or other "staff" related actions (such as force logout after password change etc.).

* Implement lookup code settings and login ([8f3ce7b](https://github.com/ory/kratos/commit/8f3ce7b33390fcae85e605193806364ca9d099c9))
* Improve detection of AAL errors and return 422 instead of 403 ([e2bfbea](https://github.com/ory/kratos/commit/e2bfbea1541aca983eb835d3da2b5fe70ac4b7a5))
* Improve labels for totp and lookup ([b92e00e](https://github.com/ory/kratos/commit/b92e00e345da1f8ab76750e3f0ae1301977bbae0))
* Improve session device annotations ([87907b8](https://github.com/ory/kratos/commit/87907b8d29dc9cd7140535e81ea62c2d7f8e41c3))
* In docker debug support with delve ([#1789](https://github.com/ory/kratos/issues/1789)) ([37325a1](https://github.com/ory/kratos/commit/37325a18d9430130d0062674433fa0d3f9a59eb3))
* Introduce cve scanning ([#1798](https://github.com/ory/kratos/issues/1798)) ([ade13ea](https://github.com/ory/kratos/commit/ade13ea082ee11e9c1005de3ccb3ae6b5f02bb49))
* **logout:** Add logout token to browser response ([#1758](https://github.com/ory/kratos/issues/1758)) ([d3f1177](https://github.com/ory/kratos/commit/d3f1177a9a82dc2c4f930f15c6ec87c3ec5a1d53))
* Mark recovery email address verified ([#1665](https://github.com/ory/kratos/issues/1665)) ([e3efc5d](https://github.com/ory/kratos/commit/e3efc5d0673106115a236e38b5d76d6672d64d20)), closes [#1662](https://github.com/ory/kratos/issues/1662)
* Mark required fiels as required ([34cd5e8](https://github.com/ory/kratos/commit/34cd5e8e638be3d48ed8174112417bc36400e8cb)):

    Closes https://github.com/ory-corp/cloud/issues/1328
    Closes https://github.com/ory/kratos/issues/400
    Closes https://github.com/ory/kratos/issues/1058
    See https://ory-community.slack.com/archives/C012RJ2MQ1H/p1631825476159000

* Natively support social sign in for single-page apps ([1a1a350](https://github.com/ory/kratos/commit/1a1a350a9f0df85195505690fc52086eddf78371))
* **persistence:** Add new columns for mfa ([6184fe3](https://github.com/ory/kratos/commit/6184fe385cf87b260117290089b06445e5b6b205))
* Potentially add arm64 docker support ([68112de](https://github.com/ory/kratos/commit/68112defb97db1c6f4b8bf65e2e522b22e27d280))
* Proper enum and type assertions for openapi ([c4d8516](https://github.com/ory/kratos/commit/c4d8516fb93c2127c6d0c28a914ed7b8f8646832))
* Publish webauthn as loadable script instead of eval ([2717c59](https://github.com/ory/kratos/commit/2717c5958ab3f088821fdf96fdf6d44d48fea310))
* Redirect on login if session aal is not matched ([8feff8d](https://github.com/ory/kratos/commit/8feff8daaf4ac744fab22627d9bdab45740570d5))
* Respect webauthn in session aal ([869b4a5](https://github.com/ory/kratos/commit/869b4a5a812b840196eaf1e591aeb685d7f0e904))
* **session:** Respect 2fa enforcement in whoami ([3a82c88](https://github.com/ory/kratos/commit/3a82c8806931a2b4cd05142a6dae8040a76658bc))
* Sign in with apple ([#1833](https://github.com/ory/kratos/issues/1833)) ([16ed123](https://github.com/ory/kratos/commit/16ed123adba06167f70eb952ae3877d4476f8c71)), closes [#1782](https://github.com/ory/kratos/issues/1782):

    Adds an adapter and configuration options for enabling Social Sign In with Apple.

* Sort totp nodes ([5c9a494](https://github.com/ory/kratos/commit/5c9a49487f45af5b7edf069edf9c3d37ef293cd5))
* Stubable time in text package ([22e4ed1](https://github.com/ory/kratos/commit/22e4ed15e2eecb51b393762077872b19f6f2acd2))
* Support apple m1 ([54b4fb6](https://github.com/ory/kratos/commit/54b4fb698c6a087afef8821fa8300798e484ae18))
* Support setting the identity state via the admin API ([#1805](https://github.com/ory/kratos/issues/1805)) ([29c060b](https://github.com/ory/kratos/commit/29c060bd348733eeafee98d5f255c737a8cbcad0)), closes [#1767](https://github.com/ory/kratos/issues/1767)
* Support strategy return to ui for settings ([74670bb](https://github.com/ory/kratos/commit/74670bb4b0cc45626537e5ac63283fd14f05dee1))
* Support webauthn for mfa ([e8f4d3c](https://github.com/ory/kratos/commit/e8f4d3cb899d44c777b094f2ae4d84ff68532bf9))
* **totp:** Add width and height to QR code ([a648ba3](https://github.com/ory/kratos/commit/a648ba3de9a0ba707ce39c37fa5d5e38c4da74d3))
* **totp:** Support account name setting from schema ([19a6bcc](https://github.com/ory/kratos/commit/19a6bcc9d8940acb2a5f0eb4a6cc7f28801a2f92))
* Treat lookup as aal2 in session ([3269028](https://github.com/ory/kratos/commit/3269028d46d0ef23de3f905c325d514f24db43b8))
* Use discriminators for ui node types in spec ([59e808e](https://github.com/ory/kratos/commit/59e808e8dc6339da59bbe08ebbcf7b840e3fdd50))
* Use initial_value in lookup strategy ([efe272f](https://github.com/ory/kratos/commit/efe272f06966edc4858602d94740b6ed36c12e57))

### Reverts

* 3745014 ([d493d10](https://github.com/ory/kratos/commit/d493d1049f90ca6ee7b85931e3652aa9fdeb0254))

### Tests

* Aal in login.NewFlow ([5986e38](https://github.com/ory/kratos/commit/5986e38e6ab9eec1761e4c723c807dc0ef2a3dfa))
* AcceptToRedirectOrJSON ([2ca153f](https://github.com/ory/kratos/commit/2ca153f027599c18583ce0ebacb5ed577b56ddf3))
* Add credentials test ([58b388c](https://github.com/ory/kratos/commit/58b388c70d5ff32822e8ac5f3a394e683273ac6a))
* Add expired test to login handler ([3bdb8ab](https://github.com/ory/kratos/commit/3bdb8abb558c0f8c4b33f712678f5da02d0ef4ee))
* Add identity change test to settings submit ([5eb090b](https://github.com/ory/kratos/commit/5eb090b2564192deb77e64dd74a07b96c381391d))
* Add initial spa e2e test ([20617f6](https://github.com/ory/kratos/commit/20617f628ac84981c3b47ce9e9ab193b8ff426d0))
* Add initial totp integration tests ([c9d456b](https://github.com/ory/kratos/commit/c9d456bf03cb33baf0745fe9a511f84b4c9427e3))
* Add login tests ([a71cadd](https://github.com/ory/kratos/commit/a71cadde91bdaf960caf30dcfa957a2646da86a2))
* Add migrations tests for new tables ([3c96ab0](https://github.com/ory/kratos/commit/3c96ab059af9bf6002b341c5db51d1b3ca5da655))
* Add react app to e2e tests ([1214eee](https://github.com/ory/kratos/commit/1214eeee24b06e6e72c55cfed2176860ecbf3c13))
* Add schema test for totp config ([c4f05ba](https://github.com/ory/kratos/commit/c4f05ba60af1d7ca31b4cf54097cbefa88085704))
* Add session amr test ([eedb60b](https://github.com/ory/kratos/commit/eedb60bec9bebfb0a4ffb67dd484d2e6b466e776))
* Add settings tests ([6959565](https://github.com/ory/kratos/commit/6959565212dc5e7296aad7f1365a944379dd5d6d))
* Add test for TOTPIssuer ([14731c4](https://github.com/ory/kratos/commit/14731c4e7809c2202c9298422c005358b7b26fc3))
* Add test for ui error page ([3977a9c](https://github.com/ory/kratos/commit/3977a9c4d6f98ef6d8f7f4c88d55b46579401ba8))
* Add TestEnsureInternalContext ([152bfc7](https://github.com/ory/kratos/commit/152bfc7294078081ca9f8fc6dd194db6d2e699ad))
* Add totp registry tests ([817e3ec](https://github.com/ory/kratos/commit/817e3ecb213454e4ce3f987ce8a8714301ee8165))
* Add totp settings tests ([c5a0d0f](https://github.com/ory/kratos/commit/c5a0d0f8435690786eaf719bb1376f7da15a6203))
* Add TOTP to profile ([7431e9f](https://github.com/ory/kratos/commit/7431e9fcf4e9c9853ec4d378221c7a3744b3b239))
* Add update session test ([47bd057](https://github.com/ory/kratos/commit/47bd057da0fbf849d643c27c6eb75ef09c5075fb))
* Additional checks for flow hydration ([a40d7fe](https://github.com/ory/kratos/commit/a40d7fe4340ff61c3fa9ac0a70dc5f7e4641a15e))
* Amr persistence ([b0b2d81](https://github.com/ory/kratos/commit/b0b2d8174ca46e066e8eb912a24d9e6efeea0ce8))
* Check if internal context is validated in store ([a23d851](https://github.com/ory/kratos/commit/a23d8518fc65f645cae9c196ff70df4efca67266))
* CheckAAL ([03b37e7](https://github.com/ory/kratos/commit/03b37e7675e369817d2bb226047ec9f26b18a456))
* Complete TOTP login integration tests ([6e503cf](https://github.com/ory/kratos/commit/6e503cff28428e707b3812cd2bf8e44ccc487b89))
* **e2e:** Add checkboxes to schemas ([0c91f0c](https://github.com/ory/kratos/commit/0c91f0c89081726e7451d5411a6adeb631ae2edb))
* **e2e:** Add config for proxy to simplify cy.visit logic ([7d87985](https://github.com/ory/kratos/commit/7d8798560947227d64a35d2dd69623bc1a1ddc8f))
* **e2e:** Add mfa profile ([a60d157](https://github.com/ory/kratos/commit/a60d157bfeb79cb527bf73b3fc38e1ba5388cbed))
* **e2e:** Add modd to build ([48cd8ae](https://github.com/ory/kratos/commit/48cd8aeb851d02e2fd31e73e044befb45242e953))
* **e2e:** Add more helpers and ts defs ([21b35b0](https://github.com/ory/kratos/commit/21b35b025a21b1f6ab3ac8be79339f1734b3033a))
* **e2e:** Add more helpers for various flows and proxy settings ([755ac60](https://github.com/ory/kratos/commit/755ac60cb1a54cd188ab07d9448598d738c5e866))
* **e2e:** Add more routes to registry ([30423c9](https://github.com/ory/kratos/commit/30423c92ba27709e003e88e58072b78ef3e2aa04))
* **e2e:** Add more typings for cypress helpers ([60bd63f](https://github.com/ory/kratos/commit/60bd63f31d6b639af19048cc3d1e392b885213e0))
* **e2e:** Add plugin for using got ([8fafc40](https://github.com/ory/kratos/commit/8fafc40dff8a0d9d5d678b59ecf4c13755906a4f))
* **e2e:** Add proxy capabilities for react native app ([b5668df](https://github.com/ory/kratos/commit/b5668df755e186f12c0e543715bc2e16011583a6))
* **e2e:** Add recovery tests for SPA ([b6014ee](https://github.com/ory/kratos/commit/b6014eee8b507abf6e3b4324097b3015f722cbe3))
* **e2e:** Add spa as allowed redirect url ([2625d16](https://github.com/ory/kratos/commit/2625d1689d47fb1cdbe34708be27f2317cdc7bea))
* **e2e:** Add SPA tests for login and refactor tests to typescript ([d9a25df](https://github.com/ory/kratos/commit/d9a25df1ba34cbefd416dccfdb2f5fc93e0290b9))
* **e2e:** Add SPA tests for logout and refactor tests to typescript ([b0c6776](https://github.com/ory/kratos/commit/b0c67769e4afcdbc05d2c1966e38faa18404a5db))
* **e2e:** Add SPA tests for registration and refactor tests to typescript ([a61ed1e](https://github.com/ory/kratos/commit/a61ed1edb41df64f58e23f8c88894fb742fd275d))
* **e2e:** Add support functions and type definitions ([c82d68d](https://github.com/ory/kratos/commit/c82d68db36563b16623a63be9efaf6b25322f855))
* **e2e:** Clean up helper ([4806add](https://github.com/ory/kratos/commit/4806add17a5dd0ea8c8fded644a6c240b17861b3))
* **e2e:** Complete SPA tests for all mfa flows ([2196129](https://github.com/ory/kratos/commit/219612903bd4dce208e2074e4595980c1cb60711))
* **e2e:** Default and empty values and required fields ([72f2c5f](https://github.com/ory/kratos/commit/72f2c5fbd8227e19d62f26aeddfb1bd14d7c768b))
* **e2e:** Ensure advanced types work in forms also ([287269c](https://github.com/ory/kratos/commit/287269c9992390b52ff380b31eda3bb7ad205f09))
* **e2e:** Ensure correct app ([a9ff545](https://github.com/ory/kratos/commit/a9ff5457cb48a90668b62e54d0b08cb1e9108994))
* **e2e:** Finalize mobile tests ([acf5c3d](https://github.com/ory/kratos/commit/acf5c3d649e51edfd9e1e3755222d9c7161a92e7))
* **e2e:** Force port ([a49eda8](https://github.com/ory/kratos/commit/a49eda8e0405954d62058d8c1410a62f72bfb7ae))
* **e2e:** Homogenize profiles ([7798e19](https://github.com/ory/kratos/commit/7798e193aa3cce0347e5ca018e09685b6fda0ba2))
* **e2e:** Hot reload ory kratos on changes ([841da09](https://github.com/ory/kratos/commit/841da091689f9a3fceb5509490d7a2f4828b926f))
* **e2e:** Implement recovery tests for SPA ([3dea57f](https://github.com/ory/kratos/commit/3dea57ff986702b9a31621198794e1cc94e4881e))
* **e2e:** Implement required verification tests for SPA ([fb55f34](https://github.com/ory/kratos/commit/fb55f3475f25ab3aa6f7b1765ec5b9f13ef72b15))
* **e2e:** Improve stability for login tests ([43df22b](https://github.com/ory/kratos/commit/43df22bdd52305b2b5d98a0db1c09751bd3ebb4f))
* **e2e:** Improve stability for registration tests ([a1c59a3](https://github.com/ory/kratos/commit/a1c59a349cab3819e5f869dc89eba3c05100f1b8))
* **e2e:** Migrate email tests to new proxy set up ([54d8cd6](https://github.com/ory/kratos/commit/54d8cd65b8b19f7a643bf9d4060906b818fc91d6))
* **e2e:** Migrate settings tests to typescript and add SPA tests ([566336d](https://github.com/ory/kratos/commit/566336d910f0b3deb4675e1413bfd0182bde6a79))
* **e2e:** Move config to lower level and publish as package ([c21fa26](https://github.com/ory/kratos/commit/c21fa2688e560bb9c714d2078dbc9a72a1da125f))
* **e2e:** Move registration tests to new proxy set up ([eddeb85](https://github.com/ory/kratos/commit/eddeb8510ca4cb13d0644d7083d436778828d0bd))
* **e2e:** Port mobile test to typescript ([db42346](https://github.com/ory/kratos/commit/db4234694723b7dc965c9e2cf4ba792bad0374e9))
* **e2e:** Port remaining e2e tests to typescript ([5853d1a](https://github.com/ory/kratos/commit/5853d1a64b3f7b20af79cc6ebbc381de0d213139))
* **e2e:** Potentially resolve webauthn startup issues ([eae6f5d](https://github.com/ory/kratos/commit/eae6f5d1e9dc08dc8f7152a9c441e029dd4351f3))
* **e2e:** Prototype typescript implementation ([2e869cf](https://github.com/ory/kratos/commit/2e869cff7b1cb87e15013a86b54fda16a01e0267))
* **e2e:** Recreate identities per flow ([1a560a3](https://github.com/ory/kratos/commit/1a560a37c13240d9ae16d34188a6221f589ebbbc))
* **e2e:** Refactor and add support for SPA app ([7609219](https://github.com/ory/kratos/commit/7609219448effde35844675533e71583babe1d14))
* **e2e:** Remove wait condition ([af10b03](https://github.com/ory/kratos/commit/af10b03ebca03cdb5654c116efbd3c23b47c7594))
* **e2e:** Resolve flaky test ([de7cc59](https://github.com/ory/kratos/commit/de7cc59f07a6b77e3bbf3d98a7b2104b60ce708c))
* **e2e:** Resolve flaky test issues ([1627745](https://github.com/ory/kratos/commit/162774567d44336c8999ee0c1362adb191855d0c))
* **e2e:** Resolve next not starting ([2a2a3cb](https://github.com/ory/kratos/commit/2a2a3cb016e820f651f3cf6cd33123672e5977cb))
* **e2e:** Resolve regressions ([af9aedc](https://github.com/ory/kratos/commit/af9aedc8d29678f480b1b6bad128aefbacd6a373))
* **e2e:** Revert proxy changes ([293d920](https://github.com/ory/kratos/commit/293d92084a7614ae0cd7d5326dc82a209a0841be))
* **e2e:** Temporarily add totp to default profile ([8ffac9d](https://github.com/ory/kratos/commit/8ffac9d138656eb2322913992b350cea31ed7e87))
* **e2e:** Update e2e profiles to new proxy set up ([a3204cf](https://github.com/ory/kratos/commit/a3204cf9b85e274441c02592288a4f322481e894))
* Ensure aal and amr is set on recovery ([5cbab54](https://github.com/ory/kratos/commit/5cbab54fe5780689f0b64700567ac4632eb04c0b)), closes [#1322](https://github.com/ory/kratos/issues/1322)
* Ensure aal2 can not be used for oidc ([cbbcdd2](https://github.com/ory/kratos/commit/cbbcdd2e86c2d4da14c478637105eb8a36ae06c0))
* Ensure aal2 can not be used for password ([d9d39f0](https://github.com/ory/kratos/commit/d9d39f0bdda0725989a0a8261a449cf1a71afb6b))
* Ensure authenticated_at after all upgrade ([80408b4](https://github.com/ory/kratos/commit/80408b4c90229c61138411be8534fc577b8f0f33))
* Ensure redirect_url in password strategy ([9eafc10](https://github.com/ory/kratos/commit/9eafc10189ca88724fa6d75748299c2dd2c470b1))
* ErrStrategyAsksToReturnToUI behavior ([f739018](https://github.com/ory/kratos/commit/f7390184b02d526bb6e3ff496abc4522afc39d5a))
* Finalize webauthn tests ([97e59e6](https://github.com/ory/kratos/commit/97e59e61ee8be263199c3749e27dd81344777166))
* Fix regressions in the tests ([246c580](https://github.com/ory/kratos/commit/246c580222acd193eea784a6cbfd1e75181a484f))
* Fix tests in cmd/serve ([#1755](https://github.com/ory/kratos/issues/1755)) ([b704d08](https://github.com/ory/kratos/commit/b704d08382a9059157c2a649872e88943d66a99f))
* ID methods of node attributes ([ff9ff04](https://github.com/ory/kratos/commit/ff9ff048ddfa13ae73571064a36b33a867727392))
* Login form submission with AAL ([4d54fbb](https://github.com/ory/kratos/commit/4d54fbb37349126418274de8e21473c2ff81f785))
* **lookup:** Add secret_disable to snapshots ([68d6a87](https://github.com/ory/kratos/commit/68d6a876a4f1a0fd74789798397bd325a68d71d6))
* **lookup:** Ensure context is cleaned up after use ([8a210c4](https://github.com/ory/kratos/commit/8a210c41696d1865cce4c589a7cb3e52283fe24d))
* **lookup:** Refresh and reuse scenarios ([89736ed](https://github.com/ory/kratos/commit/89736ed9ba8667314313ca549a6377faddcc3d80))
* **migration:** Resolve mysql migration issue with empty array ([71a5649](https://github.com/ory/kratos/commit/71a5649a52036e29b351b6b4ee220ec7ce3aed05))
* Move to cupaloy for snapshots ([0cce70f](https://github.com/ory/kratos/commit/0cce70f47712da44d891c6d2890e818da6d9971b))
* Properly refresh mobile session ([c31915d](https://github.com/ory/kratos/commit/c31915de32e4b3db4af8ca8f3b5ecb0adf01a510))
* Registry regression ([25c88b5](https://github.com/ory/kratos/commit/25c88b55577b016aa77d2df3c595410633d0eefe))
* Remove todo items ([f60050e](https://github.com/ory/kratos/commit/f60050e0e30b1bf5441c95ada5777743719d65f1))
* Resolve flaky config test ([147c670](https://github.com/ory/kratos/commit/147c6704a9d38b5687eb8aba5661f24f99e577e3))
* Resolve flaky config test ([#1832](https://github.com/ory/kratos/issues/1832)) ([db98d01](https://github.com/ory/kratos/commit/db98d010639bfc387ef927c4f80ff6cd0ebc9588))
* Resolve flaky example tests ([#1817](https://github.com/ory/kratos/issues/1817)) ([0e700d8](https://github.com/ory/kratos/commit/0e700d89c0aaa99b9eec7ce070b7974373377f03))
* Resolve flaky tests ([2bd9100](https://github.com/ory/kratos/commit/2bd910037efd20ab1829784ee087c533e5e8b177))
* Resolve migratest regressions ([e9a1ed1](https://github.com/ory/kratos/commit/e9a1ed188a8f2556e1f60d1c171506dc0dd931d4))
* Resolve regressions ([1a93b2f](https://github.com/ory/kratos/commit/1a93b2fba1fc41a6ba314253387af9770fd36f5a))
* Resolve regressions ([64850ed](https://github.com/ory/kratos/commit/64850ed3277185ebf68b50449721c903c01eab89))
* Resolve remaining regressions ([f02804c](https://github.com/ory/kratos/commit/f02804c567a532a30eaa228b0ba784b7f7fb0d9a))
* Resolve remaining regressions ([0224c22](https://github.com/ory/kratos/commit/0224c22ebda566c69363ae09dea9d42368c86f48))
* Resolve remaining regressions ([1fa2aa5](https://github.com/ory/kratos/commit/1fa2aa5b60d0b81e2035ae18c60d199b060a4c1f))
* Resolve time locality issues ([53b8b2a](https://github.com/ory/kratos/commit/53b8b2a22e5bad12dabf90c7bcbaf05b13a73a55))
* Restructure session struct tests ([50d3f66](https://github.com/ory/kratos/commit/50d3f66f82cb4e85a213fd86dc20bfadafefae23))
* Session AAL handling ([6fea3e5](https://github.com/ory/kratos/commit/6fea3e5aec6556697092c9a9d12295ed7e4d408b))
* Session activate ([c86fa03](https://github.com/ory/kratos/commit/c86fa03d3b2390403dcb14ef93307adc61ac7c79))
* **sql:** Fix incorrect UUID ([ea2894e](https://github.com/ory/kratos/commit/ea2894ed0f12de011fd5ce304dd614579ea5e96c))
* Temporarily enable lookup globally ([458f559](https://github.com/ory/kratos/commit/458f559ec816e64c6c9f53ecacdb4ae30fc9f8f7))
* **totp:** Ensure context is cleaned up after use ([1905883](https://github.com/ory/kratos/commit/19058830c0541f717360d3f599760b2a5cf47c4e))
* Upgrade cypress to 8.x ([c8a1dfc](https://github.com/ory/kratos/commit/c8a1dfcae3d42555b1215ad7eaa03a521bdcb1da))
* Use different return handler ([e489a43](https://github.com/ory/kratos/commit/e489a439e56dcd4218cf81284beaca0ef2ecd35e))
* Various aal combinations for newflow ([b095b99](https://github.com/ory/kratos/commit/b095b990224cbbd5ffa272b8f443b3345634d353))
* Webauth settings flow ([4c82772](https://github.com/ory/kratos/commit/4c82772ae28643ce69a5778c37f3c67644ef6f4c))
* Webauthn aal2 login ([60ace8b](https://github.com/ory/kratos/commit/60ace8b36c033ac4f9cd7e8cd929921e2e882946))
* Webauthn credentials ([c3e1184](https://github.com/ory/kratos/commit/c3e1184e719cd2041df8894edd4bd921bf2c3b00))
* Webauthn credentials counter ([f7701f6](https://github.com/ory/kratos/commit/f7701f629d5553e229546b00d3c345a8d74dd627))
* **webauthn:** Ensure context is cleaned up after use ([7a8055b](https://github.com/ory/kratos/commit/7a8055be357a64a1f4074fe28b249fbaf05cf519))

### Unclassified

* Correct session godoc ([7108e65](https://github.com/ory/kratos/commit/7108e65447c37cc6f2937083a2a61442e0a43cb8))


# [0.7.6-alpha.1](https://github.com/ory/kratos/compare/v0.7.5-alpha.1...v0.7.6-alpha.1) (2021-09-12)

Resolves further issues in the SDK and release pipeline.





### Code Generation

* Pin v0.7.6-alpha.1 release commit ([8b0d1ee](https://github.com/ory/kratos/commit/8b0d1ee66f1ee2b9f37cd178ac2bcbd8980d6f1d))


# [0.7.5-alpha.1](https://github.com/ory/kratos/compare/v0.7.4-alpha.1...v0.7.5-alpha.1) (2021-09-11)

Primarily resolves issues in the SDK pipeline.





### Code Generation

* Pin v0.7.5-alpha.1 release commit ([3a741a5](https://github.com/ory/kratos/commit/3a741a5ed5cff78e0e060bc98f8526537e8719d7))


# [0.7.4-alpha.1](https://github.com/ory/kratos/compare/v0.7.3-alpha.1...v0.7.4-alpha.1) (2021-09-09)

This release adds the GitHub-app provider, improves SQL instrumentation, resolves an expired flow bug, and resolves documentation issues.





### Bug Fixes

* Corret sdk annotations for enums ([6152363](https://github.com/ory/kratos/commit/6152363cda20992a9b894e618c3a438f30808a97))
* Do not panic if cookiemanager returns a nil cookie ([6ea5678](https://github.com/ory/kratos/commit/6ea56785fa0354d8d9479a699304a4b933d6c294)), closes [#1695](https://github.com/ory/kratos/issues/1695)
* Respect return_to in expired flows ([#1697](https://github.com/ory/kratos/issues/1697)) ([394a8de](https://github.com/ory/kratos/commit/394a8de9c0cdd33df91d56008eac12510ff14e07)), closes [#1251](https://github.com/ory/kratos/issues/1251)

### Code Generation

* Pin v0.7.4-alpha.1 release commit ([67ff8a9](https://github.com/ory/kratos/commit/67ff8a947b5b339648aeb4c22aba89205c61382b))

### Documentation

* Add e2e quickstart ([2b749d3](https://github.com/ory/kratos/commit/2b749d39fcb0d320d193290966a558ee2c5734d1))
* Browser redirects ([#1700](https://github.com/ory/kratos/issues/1700)) ([a44089a](https://github.com/ory/kratos/commit/a44089a506f5ea9daa406fcb862ad707f569c2bb))
* Mark logout_url always available ([9021805](https://github.com/ory/kratos/commit/9021805c4399beb73f234726f8f5f3bfd312482c))
* Minor improvements ([#1707](https://github.com/ory/kratos/issues/1707)) ([79c132c](https://github.com/ory/kratos/commit/79c132c5a0737ea1632655d8aea0af63c4200d37))

### Features

* Making use of the updated instrumentedsql version ([#1723](https://github.com/ory/kratos/issues/1723)) ([9e6fbdd](https://github.com/ory/kratos/commit/9e6fbdd06a75d7207b4801d1148267b3a1a0a0c7))
* **oidc:** Github-app provider ([#1711](https://github.com/ory/kratos/issues/1711)) ([fb1fe8c](https://github.com/ory/kratos/commit/fb1fe8c468bb6f8275618b84c5fa157a314c345f))

### Tests

* **session:** Resolve incorrect assertion ([0531220](https://github.com/ory/kratos/commit/05312203ab12eec44e59dcd9210160f2781a69b4))


# [0.7.3-alpha.1](https://github.com/ory/kratos/compare/v0.7.1-alpha.1...v0.7.3-alpha.1) (2021-08-28)

This patch resolves a regression issue with Facebook login, a memory leak issue introduced by an external dependency, adds a "requires verification" login hook, and improves performance for some endpoints.

Also, Ory Kratos SDKs are now published in individual [GitHub repositories for every language](https://github.com/ory?q=kratos-client).





### Bug Fixes

* Add new message when refresh parameter is true ([#1560](https://github.com/ory/kratos/issues/1560)) ([0525623](https://github.com/ory/kratos/commit/05256232bf85d68e068eece6c883f46a447ba5bd)), closes [#1117](https://github.com/ory/kratos/issues/1117)
* Add session in spa registration if session cook is configured ([#1657](https://github.com/ory/kratos/issues/1657)) ([639a7dd](https://github.com/ory/kratos/commit/639a7dd52d43c57e9708ed3e7360c17d6efde6a5)), closes [#1604](https://github.com/ory/kratos/issues/1604)
* **docs:** Ensure config reference is updated ([f6b3aa4](https://github.com/ory/kratos/commit/f6b3aa45b1f39ca5e9ee7ef4cd96de1970b2ed71)), closes [#1597](https://github.com/ory/kratos/issues/1597)
* Facebook sign in regression ([#1689](https://github.com/ory/kratos/issues/1689)) ([85337bf](https://github.com/ory/kratos/commit/85337bf65af767d7296b14e8fd21bab5c64d23e2)), closes [#1687](https://github.com/ory/kratos/issues/1687) [#1686](https://github.com/ory/kratos/issues/1686)
* Http context memory leak ([b21bd22](https://github.com/ory/kratos/commit/b21bd224059e8a42da9814237572a118297c5210)):

    Ory Kratos was using `gorilla/sessions` prior to version v1.2 which had a dependency on `gorilla/context`, a deprecated library with known memory management issues. Even though we used `gorilla/context`'s clean up middleware, it appears that `r.Context()` was not properly cleaned up, causing memory leaks.
    
    On average, the memory leak is pretty small, but depending on what gets added to `r.Context()` it could significantly increase the memory leak.
    
    By replacing `gorilla/sessions` with v1.2.1 we:
    
    1. Increased the HTTP API throughput by an estimate of 4 times;
    2. Brought average memory use back down to about 12MB;
    
    Closes https://github.com/ory-corp/cloud/issues/1292

* Outdated label ([#1681](https://github.com/ory/kratos/issues/1681)) ([149101e](https://github.com/ory/kratos/commit/149101ed145dae2b75e5150013efc478f5fd0cc3))
* Register argon2 CLI commands properly ([#1592](https://github.com/ory/kratos/issues/1592)) ([45c28d9](https://github.com/ory/kratos/commit/45c28d99064baf8051521a1078ac2b59bb3206ec))
* Remove session cookie on logout ([#1587](https://github.com/ory/kratos/issues/1587)) ([cdb30bb](https://github.com/ory/kratos/commit/cdb30bb65ac932a17e4924b4efc8952113452513)), closes [#1584](https://github.com/ory/kratos/issues/1584):

    Before, the logout endpoint would invalidate the session cookie, but not remove it. This was a regression introduced in 0.7.0. This patch resolves that issue.

* **sdk:** Use proper annotation for genericError ([#1611](https://github.com/ory/kratos/issues/1611)) ([da214b2](https://github.com/ory/kratos/commit/da214b2933ae2a91d8c5bf6aa8eea613a2078b9d)), closes [#1609](https://github.com/ory/kratos/issues/1609)
* Skip prompt on discord authorization by default ([#1594](https://github.com/ory/kratos/issues/1594)) ([a667255](https://github.com/ory/kratos/commit/a6672554b02378eb2dac7b1af99ea2915395867b)):

    When a value for prompt is not provided, Discord defaults to `prompt="consent"`. This change makes it so that if the request is not forced, prompt is explicitly set to "none".

* Static parameter for warning message in config.baseURL(...) ([#1673](https://github.com/ory/kratos/issues/1673)) ([db54a1b](https://github.com/ory/kratos/commit/db54a1bd0c93d7a5845ee09d0a16cbc3b8f26a4a)), closes [#1672](https://github.com/ory/kratos/issues/1672)
* Update csrf token cookie name ([#1601](https://github.com/ory/kratos/issues/1601)) ([64c90bf](https://github.com/ory/kratos/commit/64c90bf5e5cec6545a81f88ad5fabb29e9e80850)):

    See https://github.com/ory-corp/cloud/issues/1252

* Use eager preloading for list identites endpoint ([#1588](https://github.com/ory/kratos/issues/1588)) ([de5fb3e](https://github.com/ory/kratos/commit/de5fb3e52af9f2d0f1209eed217403a5d7d1ae2d))

### Code Generation

* Pin v0.7.3-alpha.1 release commit ([b5ad53e](https://github.com/ory/kratos/commit/b5ad53eca933438126eda3c6c647d99e05e37695))

### Documentation

* Change model to schema ([#1639](https://github.com/ory/kratos/issues/1639)) ([09c403e](https://github.com/ory/kratos/commit/09c403e55482e91a5bfe9a253e514b7a90826709))
* Fix func naming for Logout flow ([#1676](https://github.com/ory/kratos/issues/1676)) ([bbeb613](https://github.com/ory/kratos/commit/bbeb6132ba82e28057bc14bf35ea99b70f0c4118)):

    rename createSelfServiceLogoutUrlForBrowsers  to createSelfServiceLogoutFlowUrlForBrowsers

* Fix stub error example ([#1642](https://github.com/ory/kratos/issues/1642)) ([9bc2fd0](https://github.com/ory/kratos/commit/9bc2fd088ed9b3e7334713e63bae3c7bbcb922db)), closes [#1568](https://github.com/ory/kratos/issues/1568)
* Fixes incorrect yaml identation ([#1641](https://github.com/ory/kratos/issues/1641)) ([6b58278](https://github.com/ory/kratos/commit/6b582784b49c1d103bbf7a6843cdf197fbd93931))
* Identity traits are visible to user ([#1621](https://github.com/ory/kratos/issues/1621)) ([641eba6](https://github.com/ory/kratos/commit/641eba675bdc583661565a6378776bfad26067c6))
* Make qickstart URLs consistent (playground vs. localhost) ([#1626](https://github.com/ory/kratos/issues/1626)) ([bae1847](https://github.com/ory/kratos/commit/bae1847eba0d925f28a010876e35e3c2093bc8c6)):

    Since the quick-start describes how to run Kratos locally the actual location of the redirect is `http://127.0.0.1:4433/self-service/login/browser`.

* Update docker.md - Outdated information ([#1627](https://github.com/ory/kratos/issues/1627)) ([dc32720](https://github.com/ory/kratos/commit/dc32720de25f52b7deb3e32f7530c7827a6ce5df)), closes [#1619](https://github.com/ory/kratos/issues/1619):

    Kratos does not automatically use a config file that exists at `$HOME/.kratos.yaml`, or any other similar pattern. The documentation in the Docker Images section of the guides could lead developers to believe that the --config flag is unnecessary if they are binding the directory the configuration file is in to $HOME or using a custom docker image to provide the file.


### Features

* Allow multiple webhook body sources ([#1606](https://github.com/ory/kratos/issues/1606)) ([51b1311](https://github.com/ory/kratos/commit/51b131177c9e0db018eced939fef43742c9e86cf)):

    This patch adds support for loading webhooks from the local filesystem, base64 encoded inline string, and remote (http/https) sources. Please note that support for relative/absolute paths without an URI scheme are deprecated and will eventually be removed.

* Require verified address ([#1355](https://github.com/ory/kratos/issues/1355)) ([1cf61cd](https://github.com/ory/kratos/commit/1cf61cdeedbd8bf5b66310793249681ff976baab)), closes [#1328](https://github.com/ory/kratos/issues/1328)


# [0.7.1-alpha.1](https://github.com/ory/kratos/compare/v0.7.0-alpha.1...v0.7.1-alpha.1) (2021-07-22)

This release addresses regressions introduced in Ory Kratos v0.7.0 and resolves some bugs and documentation inconsistencies.





### Bug Fixes

* Automatic tagging for node ui ([fe5056e](https://github.com/ory/kratos/commit/fe5056e11d1f8e4355cafa72ed1ff953077181cc)), closes [#1537](https://github.com/ory/kratos/issues/1537)
* Bump kratos ui image for quickstart ([aedbb5a](https://github.com/ory/kratos/commit/aedbb5a259ea8ee63fb06c36fb1c7af78bb63ffc)), closes [#1537](https://github.com/ory/kratos/issues/1537)
* Cleanup lint errors and add doc to x ([#1545](https://github.com/ory/kratos/issues/1545)) ([3cfd784](https://github.com/ory/kratos/commit/3cfd7845730685a4493c2b5d1974b79d873eea86))
* Correct meta schema ([8d4f3ff](https://github.com/ory/kratos/commit/8d4f3ff22d4ade6ae3f923c33303002e5f534cff))
* Do not reset link method ([#1573](https://github.com/ory/kratos/issues/1573)) ([835fb31](https://github.com/ory/kratos/commit/835fb3127bc10b1642b4a7573722e5dce63fedc7))
* Do not set csrf cookies on /sessions/whoami ([#1580](https://github.com/ory/kratos/issues/1580)) ([36bbd43](https://github.com/ory/kratos/commit/36bbd434114d120006d49785787a3c94c7f103f9))
* Export extensionschemas ([#1553](https://github.com/ory/kratos/issues/1553)) ([6af7638](https://github.com/ory/kratos/commit/6af76387caf37160ded75d83dc09ba0bc177a895))
* Generate CSRF token on validation creation ([#1549](https://github.com/ory/kratos/issues/1549)) ([6612c5f](https://github.com/ory/kratos/commit/6612c5f62e5cc242a808032def5714715ce49d11)), closes [#1547](https://github.com/ory/kratos/issues/1547)
* Identity extension meta schema ([#1554](https://github.com/ory/kratos/issues/1554)) ([ba5ca64](https://github.com/ory/kratos/commit/ba5ca642d01917b43d49e009bf140ae13b4f1313)):

    Up until now the extension meta schema was only applied to top level keys. This fix now recursively checks the extension schema on any depth.

* Remove domain alias config constraint ([#1542](https://github.com/ory/kratos/issues/1542)) ([c6145db](https://github.com/ory/kratos/commit/c6145dbfb278369c8e3ad6eae7e8574ed49ba193))
* Resolve wrong openapi types ([b07927c](https://github.com/ory/kratos/commit/b07927cd23cbfce23f3b0676303a2d0ca564143b))
* Update identity state openapi spec ([0217737](https://github.com/ory/kratos/commit/0217737f5a2860e299ccec4387a2cc83aaac1557))
* Use legacy ssl in quickstart config ([6c13c2b](https://github.com/ory/kratos/commit/6c13c2bedd45c10713907e24976658d4a4b88de6)), closes [#1569](https://github.com/ory/kratos/issues/1569)

### Code Generation

* Pin v0.7.1-alpha.1 release commit ([4fe76af](https://github.com/ory/kratos/commit/4fe76af1302d45ddf4cf3c2c5949311c9cf1f8b8))

### Documentation

* Add instruction for creating user  ([#1541](https://github.com/ory/kratos/issues/1541)) ([c2a1b6d](https://github.com/ory/kratos/commit/c2a1b6df95bcb5dfe2b238be5903f483b9e701b5)), closes [#1530](https://github.com/ory/kratos/issues/1530)
* Clarify flags in schema which are not available in config file ([e5ea5fe](https://github.com/ory/kratos/commit/e5ea5fee31eb2f70dc7c33565f791da9e2e87cc2)), closes [#1514](https://github.com/ory/kratos/issues/1514)
* Fix formatting of Email and Phone Verification Flow tab content ([#1536](https://github.com/ory/kratos/issues/1536)) ([0bfac67](https://github.com/ory/kratos/commit/0bfac67a06ef0d96ffd6a487c90edb44d3a40710))
* Fix typo ([#1543](https://github.com/ory/kratos/issues/1543)) ([b25bae7](https://github.com/ory/kratos/commit/b25bae7f2cdcbb60384808041744edd718a2a814))
* Fix typo ([#1544](https://github.com/ory/kratos/issues/1544)) ([547788d](https://github.com/ory/kratos/commit/547788de74794a1dcf43e5190cdfc9d2e1a2dc92))
* Update csrf pitfall flow section ([#1558](https://github.com/ory/kratos/issues/1558)) ([cc7ed4b](https://github.com/ory/kratos/commit/cc7ed4b5f65d2971a45d5d0ec6188908d070d915)), closes [#1557](https://github.com/ory/kratos/issues/1557)

### Tests

* Longer wait time for e2e boot ([3a85a33](https://github.com/ory/kratos/commit/3a85a33ad8a8eec2ebf57d5a47937499141b6bc0))


# [0.7.0-alpha.1](https://github.com/ory/kratos/compare/v0.6.3-alpha.1...v0.7.0-alpha.1) (2021-07-13)

About two months ago we released Ory Kratos v0.6. Today, we are excited to announce the next iteration of Ory Kratos v0.7! This release includes 215 commits from 24 contributors with over 770 files and more than 100.000 lines of code changed!

Ory Kratos v0.7 brings massive developer experience improvements:

- A reworked, tested, and standardized SDK based on OpenAPI 3.0.3 ([#1477](https://github.com/ory/kratos/pull/1477), [#1424](https://github.com/ory/kratos/issues/1424));
- Native support of Single-Page-Apps (ReactJS, AngularJS, ...) for all self-service flows ([#1367](https://github.com/ory/kratos/pull/1367));
- Sign in with Yandex, VK, Auth0, Slack;
- An all-new, secure logout flow ([#1433](https://github.com/ory/kratos/pull/1433));
- Important security updates to the self-service GET APIs ([#1458](https://github.com/ory/kratos/pull/1458), [#1282](https://github.com/ory/kratos/issues/1282));
- Built-in support for TLS ([#1466](https://github.com/ory/kratos/pull/1466));
- Improved documentation and Go Module structure;
- Resolving a case-sensitivity bug in self-service recovery and verification flows;
- Improved performance for listing identities;
- Support for Instant tracing ([#1429](https://github.com/ory/kratos/pull/1429));
- Improved control for SMTPS, supporting SSL and STARTTLS ([#1430](https://github.com/ory/kratos/pull/1430));
- Ability to run Ory Kratos in networks without outbound requests ([#1445](https://github.com/ory/kratos/pull/1445));
- Improved control over HTTP Cookie behavior ([#1531](https://github.com/ory/kratos/pull/1531));
- Several smaller user experience improvements and bug fixes;
- Improved e2e test pipeline.

In the next iteration of Ory Kratos, we will focus on providing a NextJS example application for the SPA integration as well as the long-awaited MFA flows!

Please be aware that upgrading to Ory Kratos 0.7 requires you to apply SQL migrations. Make sure to back up your database before migration!

For more details on breaking changes and patch notes, see below.



## Breaking Changes

Prior to this change it was not possible to specify the verification/recovery link lifetime. Instead, it was bound to the flow expiry. This patch changes that and adds the ability to configure the lifespan of the link individually:

```patch
 selfservice:
   methods:
     link:
       enabled: true
       config:
+        # Defines how long a recovery link is valid for (default 1h)
+        lifespan: 15m
```

This is a breaking change because the link strategy no longer respects the recovery / verification flow expiry time and, unless set, will default to one hour.

This change introduces a better SDK. As part of this change, several breaking changes with regards to the SDK have been introduced. We recommend reading this section carefully to understand the changes and how they might affect you.

Before, the SDK was structured into tags `public` and `admin`. This stems from the fact that we have two ports in Ory Kratos - one administrative and one public port.

While serves as a good overview when working with Ory Kratos, it does not express:

- What module the API belongs to (e.g. self-service, identity, ...)
- What maturity the API has (e.g. experimental, alpha, beta, ...)
- What version the API has (e.g. v0alpha0, v1beta0, ...)

This patch replaces the current `admin` and `public` tags with a versioned approach indicating the maturity of the API used. For example, `initializeSelfServiceSettingsForBrowsers` would no longer be under the `public` tag but instead under the `v0alpha1` tag:

```patch
import {
  Configuration,
- PublicApi
+ V0Alpha1
} from '@ory/kratos-client';

- const kratos = new PublicApi(new Configuration({ basePath: config.kratos.public }));
+ const kratos = new V0Alpha1(new Configuration({ basePath: config.kratos.public }));
```

To avoid confusion when setting up the SDK, and potentially using the wrong endpoints in your codebase and ending up with strange 404 errors, Ory Kratos now redirects you to the correct port, given that `serve.(public|admin).base_url` are configured correctly. This is a significant improvement towards a more robust API experience!

Further, all administrative functions require, in the Ory SaaS, authorization using e.g. an Ory Personal Access Token. In the open source, we do not know what developers use to protect their APIs. As such, we believe that it is ok to have admin and public functions under one common API and differentiate with an `admin` prefix. Therefore, the following patches should be made in your codebase:

```patch
import {
- AdminApi,
+ V0Alpha1,
  Configuration
} from '@ory/kratos-client';

-const kratos = new AdminApi(new Configuration({ basePath: config.kratos.admin }));
+const kratos = new V0Alpha1(new Configuration({ basePath: config.kratos.admin }));

-kratos.createIdentity({
+kratos.adminCreateIdentity({
  schema_id: 'default',
  traits: { /* ... */ }
})
```

Further, we have introduced a [style guide for writing SDKs annotations](https://www.ory.sh/docs/ecosystem/contributing#openapi-spec-and-go-swagger) governing how naming conventions should be chosen.

We also streamlined how credentials are used. We now differentiate between:

- Per-request credentials such as the Ory Session Token / Cookie
    ```
    - public getSelfServiceRegistrationFlow(id: string, cookie?: string, options?: any) {}
    + public getSelfServiceSettingsFlow(id: string, xSessionToken?: string, cookie?: string, options?: any) {}
    ```
- Global credentials such as the Ory (SaaS) Personal Access Token.
    ```typescript
    const kratos = new V0Alpha0(new Configuration({ basePath: config.kratos.admin, accessToken: 'some-token' }));

    kratosAdmin.adminCreateIdentity({
      schema_id: 'default',
      traits: { /* ... */ },
    });
    ```

This patch introduces CSRF countermeasures for fetching all self-service flows. This ensures that users can not accidentally leak sensitive information when copy/pasting e.g. login URLs (see #1282). If a self-service flow for browsers is requested, the CSRF cookie must be included in the call, regardless if it is a client-side browser app or a server-side browser app calling. This **does not apply** for API-based flows.

As part of this change, the following endpoints have been removed:

- `GET <ory-kratos-admin>/self-service/login/flows`;
- `GET <ory-kratos-admin>/self-service/registration/flows`;
- `GET <ory-kratos-admin>/self-service/verification/flows`;
- `GET <ory-kratos-admin>/self-service/recovery/flows`;
- `GET <ory-kratos-admin>/self-service/settings/flows`.

Please ensure that your server-side applications use the public port (e.g. `GET <ory-kratos-public>/self-service/login/flows`) for fetching self-service flows going forward.

If you use the SDKs, upgrading is easy by adding the `cookie` header when fetching the flows. This is only required when **using browser flows on the server side**.

The following example illustrates a ExpressJS (NodeJS) server-side application fetching the self-service flows.

```patch
app.get('some-route', (req: Request, res: Response) => {
-   kratos.getSelfServiceLoginFlow(flow).then((flow) => /* ... */ )
+   kratos.getSelfServiceLoginFlow(flow, req.header('cookie')).then((flow) => /* ... */ )

-   kratos.getSelfServiceRecoveryFlow(flow).then((flow) => /* ... */ )
+   kratos.getSelfServiceRecoveryFlow(flow, req.header('cookie')).then((flow) => /* ... */ )

-   kratos.getSelfServiceRegistrationFlow(flow).then((flow) => /* ... */ )
+   kratos.getSelfServiceRegistrationFlow(flow, req.header('cookie')).then((flow) => /* ... */ )

-   kratos.getSelfServiceVerificationFlow(flow).then((flow) => /* ... */ )
+   kratos.getSelfServiceVerificationFlow(flow, req.header('cookie')).then((flow) => /* ... */ )

-   kratos.getSelfServiceSettingsFlow(flow).then((flow) => /* ... */ )
+   kratos.getSelfServiceSettingsFlow(flow, undefined, req.header('cookie')).then((flow) => /* ... */ )
})
```

For concrete details, check out [the changes in the NodeJS app](https://github.com/ory/kratos-selfservice-ui-node/commit/e7fa292968111e06401fcfc9b1dd0e8e285a4d87).

This patch refactors the logout functionality for browsers and APIs. It adds increased security and DoS-defenses to the logout flow.

Previously, calling `GET /self-service/browser/flows/logout` would remove the session cookie and redirect the user to the logout endpoint. Now you have to make a call to `GET /self-service/logout/browser` which returns a JSON response including a `logout_url` URL to be used for logout. The call to `/self-service/logout/browser` must be made using AJAX with cookies enabled or by including the Ory Session Cookie in the `X-Session-Cookie` HTTP Header. You may also use the SDK method `createSelfServiceLogoutUrlForBrowsers` to do that.

Additionally, the endpoint `DELETE /sessions` has been moved to `DELETE /self-service/logout/api`. Payloads and responses stay equal. The SDK method `revokeSession` has been renamed to `submitSelfServiceLogoutFlowWithoutBrowser`.

We listened to your feedback and have improved the naming of the SDK method `initializeSelfServiceRecoveryForNativeApps` to better match what it does: `initializeSelfServiceRecoveryWithoutBrowser`. As in the previous release you may still use the old SDK if you do not want to deal with the SDK breaking changes for now.

We listened to your feedback and have improved the naming of the SDK method `initializeSelfServiceVerificationForNativeApps` to better match what it does: `initializeSelfServiceVerificationWithoutBrowser`. As in the previous release you may still use the old SDK if you do not want to deal with the SDK breaking changes for now.

We listened to your feedback and have improved the naming of the SDK method `initializeSelfServiceSettingsForNativeApps` to better match what it does: `initializeSelfServiceSettingsWithoutBrowser`. As in the previous release you may still use the old SDK if you do not want to deal with the SDK breaking changes for now.

We listened to your feedback and have improved the naming of the SDK method `initializeSelfServiceregistrationForNativeApps` to better match what it does: `initializeSelfServiceregistrationWithoutBrowser`. As in the previous release you may still use the old SDK if you do not want to deal with the SDK breaking changes for now.

We listened to your feedback and have improved the naming of the SDK method `initializeSelfServiceLoginForNativeApps` to better match what it does: `initializeSelfServiceLoginWithoutBrowser`. As in the previous release you may still use the old SDK if you do not want to deal with the SDK breaking changes for now.



### Bug Fixes

* Add json detection to setting error subbranches ([fb83dcb](https://github.com/ory/kratos/commit/fb83dcb8ae7463079ddb33c04673cf4556f6058c))
* Add verification success message ([#1526](https://github.com/ory/kratos/issues/1526)) ([126698c](https://github.com/ory/kratos/commit/126698c0b531ca304bb323c825cbeb86b5814f31)), closes [#1450](https://github.com/ory/kratos/issues/1450)
* Cache migration status ([5be2f14](https://github.com/ory/kratos/commit/5be2f149cd79ddfbe8496eccf5d5aacb6a9a0b8e)), closes [#1337](https://github.com/ory/kratos/issues/1337)
* Change SMTP config validation from URI to a Regex pattern ([#1436](https://github.com/ory/kratos/issues/1436)) ([5ab1e8f](https://github.com/ory/kratos/commit/5ab1e8f17bcbc229fada2c584b2c1f576b819761)), closes [#1435](https://github.com/ory/kratos/issues/1435)
* Check filesystem before fallback to bundled templates ([#1401](https://github.com/ory/kratos/issues/1401)) ([22d999e](https://github.com/ory/kratos/commit/22d999e78eb4f67d2f3ba07e62fd28ffb3331d6d))
* Continue button for oidc registration step ([2aad5ac](https://github.com/ory/kratos/commit/2aad5ac8f7055f39f4f434d26fbca74cdbe75337)), closes [#1422](https://github.com/ory/kratos/issues/1422) [#1320](https://github.com/ory/kratos/issues/1320):

    When signing up with an OIDC provider and the traits model is missing some fields, the submit button shows all OIDC options. Instead, it should show just one option called "Continue".

* Deprecate sessionCookie ([#1428](https://github.com/ory/kratos/issues/1428)) ([eccad74](https://github.com/ory/kratos/commit/eccad741a1702181d4b207aad954a950906a808b)), closes [#1426](https://github.com/ory/kratos/issues/1426)
* Do not cache incomplete migrations ([#1434](https://github.com/ory/kratos/issues/1434)) ([154c26f](https://github.com/ory/kratos/commit/154c26f6da4bb7040deabdc352c90cdae42c69fe))
* Do not run network migrations when booting ([12bbab9](https://github.com/ory/kratos/commit/12bbab9d3cf788998cd4a9be50ac8c7a9d2232bd)), closes [#1399](https://github.com/ory/kratos/issues/1399)
* Format test files ([0468aa1](https://github.com/ory/kratos/commit/0468aa19ebfb0f68de5d9d1e59180d953f197cc0))
* Improve identity list performance ([f76886f](https://github.com/ory/kratos/commit/f76886fe7436f71fbef00081888a2f8d0106ba98)), closes [#1412](https://github.com/ory/kratos/issues/1412)
* Incorrect openapi specification for verification submission  ([#1431](https://github.com/ory/kratos/issues/1431)) ([ecb0a01](https://github.com/ory/kratos/commit/ecb0a01f61441aa97751943b5e9ddcc28f783d91)), closes [#1368](https://github.com/ory/kratos/issues/1368)
* Link t docker guide ([953c6d6](https://github.com/ory/kratos/commit/953c6d60f6b6d82ac1406e84c2d87119e63dac48))
* Mark ui node message as optional ([#1365](https://github.com/ory/kratos/issues/1365)) ([7b8d59f](https://github.com/ory/kratos/commit/7b8d59f48ed14a6d0672238645d8675d4bf7fd77)), closes [#1361](https://github.com/ory/kratos/issues/1361) [#1362](https://github.com/ory/kratos/issues/1362)
* Mark verified_at as omitempty ([77b258e](https://github.com/ory/kratos/commit/77b258e57a3d53fe437838a5e9c57805e9c970aa)):

    Closes https://github.com/ory/sdk/issues/46

* Panic if contextualizer is not set ([760035a](https://github.com/ory/kratos/commit/760035a6c5efa08561b93daff57ebb4655032b2a))
* Panic on error in issue session ([5fbd855](https://github.com/ory/kratos/commit/5fbd8557e1f907dd400bfcd26c187db16dc344ba)), closes [#1384](https://github.com/ory/kratos/issues/1384)
* Prometheus metrics fix ([#1299](https://github.com/ory/kratos/issues/1299)) ([ac5d00d](https://github.com/ory/kratos/commit/ac5d00d472a87ab51e7c6834e2cb59f107fc3b3b))
* Recovery email case sensitive ([#1357](https://github.com/ory/kratos/issues/1357)) ([bce14c4](https://github.com/ory/kratos/commit/bce14c487450bd668859f362b98704644fa4c72a)), closes [#1329](https://github.com/ory/kratos/issues/1329)
* Remove changelog ([7affb7a](https://github.com/ory/kratos/commit/7affb7a25bc84082e0ad8096e6c0e4b3933ac5f6))
* Remove obsolete ADD for corp module ([#1455](https://github.com/ory/kratos/issues/1455)) ([0fa3a53](https://github.com/ory/kratos/commit/0fa3a539fbe1ae498434b200c3b636de10d73a7c))
* Remove typing from node.attribute.value ([63a5e08](https://github.com/ory/kratos/commit/63a5e08afab76dafbfe13e6126e165af28492aad)):

    Closes https://github.com/ory/sdk/issues/75
    Closes https://github.com/ory/sdk/issues/74
    Closes https://github.com/ory/sdk/issues/72

* Rename client package for external consumption ([cba8b00](https://github.com/ory/kratos/commit/cba8b00c8b755cc0bdc7818bc9d7390ff3532ce1))
* Resolve build issues on release ([7c265a8](https://github.com/ory/kratos/commit/7c265a8b909dcc07ceeeda546a748ad28ab0c746))
* Resolve driver issues ([47b1c8d](https://github.com/ory/kratos/commit/47b1c8dce57a023e89a2b178bc8a033496ef4ff2))
* Resolve network regression ([8f96b1f](https://github.com/ory/kratos/commit/8f96b1fe4d0846a3ad97a45bc972ece04109289d))
* Resolve network regressions ([8fc52c0](https://github.com/ory/kratos/commit/8fc52c034ed9978c2a04cc66bccc9b795c9bbefa))
* Testhelper regressions ([bf3b04f](https://github.com/ory/kratos/commit/bf3b04fd2c7f9162073cb584d6fb0d59e868ecbf))
* Use correct url in submitSelfServiceVerificationFlow ([ab8a600](https://github.com/ory/kratos/commit/ab8a600080ac0d6a6235806b74c5b9e3dc1c2d60))
* Use local schema URL for sorting UI nodes ([#1449](https://github.com/ory/kratos/issues/1449)) ([a003885](https://github.com/ory/kratos/commit/a0038853f30cd7d139d42d1d4601c8cf49d03934))
* Use session cookie path settings for csrf cookie ([#1493](https://github.com/ory/kratos/issues/1493)) ([c6d08ed](https://github.com/ory/kratos/commit/c6d08edae32fd94877fb58355d3c711460c7d1a2)), closes [#1292](https://github.com/ory/kratos/issues/1292):

    This PR adds configuration option for CSRF cookies and improves the domain alias logic as well as adding tests for it.

* Use STARTTLS for smtps connections ([#1430](https://github.com/ory/kratos/issues/1430)) ([c21bb80](https://github.com/ory/kratos/commit/c21bb80a749df7b224a8ac3f15fa62523a78d805)), closes [#781](https://github.com/ory/kratos/issues/781)
* Version schema ([#1359](https://github.com/ory/kratos/issues/1359)) ([8c4bac7](https://github.com/ory/kratos/commit/8c4bac71674e45e440d916c6c947ed018a8ea29a)), closes [#1331](https://github.com/ory/kratos/issues/1331) [#1101](https://github.com/ory/kratos/issues/1101) [ory/hydra#2427](https://github.com/ory/hydra/issues/2427)

### Code Generation

* Pin v0.7.0-alpha.1 release commit ([53a0e38](https://github.com/ory/kratos/commit/53a0e38c2b5d7003786a8386a9c4cf129acc06aa))

### Code Refactoring

* Corp package ([#1402](https://github.com/ory/kratos/issues/1402)) ([0202dc5](https://github.com/ory/kratos/commit/0202dc57aacc0d48e4c1ee4e68c91654451f63fa))
* Finalize SDK refactoring ([e772641](https://github.com/ory/kratos/commit/e772641f9bcfa462aa5111cf1329a479e3cdff99)), closes [kratos#1424](https://github.com/kratos/issues/1424) [#1424](https://github.com/ory/kratos/issues/1424)
* Identity SDKs ([d8658dc](https://github.com/ory/kratos/commit/d8658dc887a76d82e3cf23386c03b5ebf7053189)), closes [#1477](https://github.com/ory/kratos/issues/1477)
* Improve session sdk ([7207af4](https://github.com/ory/kratos/commit/7207af4cdf6c78dd3f0fd42b6727d7e320d252e6))
* Introduce DefaultContextualizer in corp package ([#1390](https://github.com/ory/kratos/issues/1390)) ([944d045](https://github.com/ory/kratos/commit/944d045aa7fc59eadfdd18951f0d4937b1ea79df)), closes [#1363](https://github.com/ory/kratos/issues/1363)
* Move cleansql to separate package ([7c203dc](https://github.com/ory/kratos/commit/7c203dc8219afe07f180143f832158615b51f60a))
* Openapi.json -> api.json ([6df0de5](https://github.com/ory/kratos/commit/6df0de5d0b4c952576bf9e14c18d521934edd9bb))
* Self-service error APIs ([65c482f](https://github.com/ory/kratos/commit/65c482fba62c2782b03a3b840124eac062499266))

### Documentation

* Add docs for registration SPA flow ([84458f1](https://github.com/ory/kratos/commit/84458f1a9dfe8be6a97bddd832fcc508b60b8498))
* Add go sdk examples ([e948fad](https://github.com/ory/kratos/commit/e948faddce3a1f52df964c701f6ba2a28f5dfe03))
* Add kratos quickstart config notes ([#1490](https://github.com/ory/kratos/issues/1490)) ([2f8094c](https://github.com/ory/kratos/commit/2f8094c50eaf7e1cd964067172adcad407713764))
* Add replit instructions ([8ab8607](https://github.com/ory/kratos/commit/8ab8607dee433f6e708ade296a6c26d0a87d0aae))
* Add tested and running go sdk examples ([3b56bb5](https://github.com/ory/kratos/commit/3b56bb5fd37d0e7d4479967aa0b5721a68a267f2))
* Correct CII badge ([#1447](https://github.com/ory/kratos/issues/1447)) ([048aec3](https://github.com/ory/kratos/commit/048aec39295f0a3534df5e43e3cd7684d4fbd758))
* Fix broken link ([9eaf764](https://github.com/ory/kratos/commit/9eaf764b28f3ca1dae2816d4c0a985c4866c409b))
* Fix building from source ([#1473](https://github.com/ory/kratos/issues/1473)) ([af54d5b](https://github.com/ory/kratos/commit/af54d5bb9e36f90d272d293817f0d6d7eb2e79a8))
* Fix typo in "Sign in/up with ID & assword" ([#1383](https://github.com/ory/kratos/issues/1383)) ([f39739d](https://github.com/ory/kratos/commit/f39739d94e97f20b94630b957371d11294dc8300))
* Mark login endpoints as experimental ([6faf0f6](https://github.com/ory/kratos/commit/6faf0f65bb05bbafdee6b1274a719695fd5b4173))
* Refactor documentation and adopt changes for [#1477](https://github.com/ory/kratos/issues/1477) ([f5e96cd](https://github.com/ory/kratos/commit/f5e96cd5054e734c319ed32992357fcd73ac44a1)), closes [#1472](https://github.com/ory/kratos/issues/1472)
* Remove changelog from docs folder ([5a7e3d8](https://github.com/ory/kratos/commit/5a7e3d83a5fb7f3e6945f37d42abca14d2982e72))
* Resolve build issues ([b51bb55](https://github.com/ory/kratos/commit/b51bb555d829ab020e593a764cbce4c5ba4885a2))
* Resolve typos and docs react issues ([2d640e4](https://github.com/ory/kratos/commit/2d640e4b9b556fd866c29c83564cb1c7702ab9ff))
* Update docs for all flows ([d29ea69](https://github.com/ory/kratos/commit/d29ea69f6bb908b529502030942b1ced52227372))
* Update documentation for plaintext templates ([#1369](https://github.com/ory/kratos/issues/1369)) ([419784d](https://github.com/ory/kratos/commit/419784dd0d4ddc338830ed0d77a7d99f8f440777)), closes [#1351](https://github.com/ory/kratos/issues/1351)
* Update error documentation ([7d83609](https://github.com/ory/kratos/commit/7d8360973a3359bec321a60f4f3a4202ac7d2430))
* Update login flow documentation ([a27de91](https://github.com/ory/kratos/commit/a27de91e9e06f8501ae9cb70446ed0aae5a39f71))
* Update path ([f0384d9](https://github.com/ory/kratos/commit/f0384d9c11085230fd16290c524d22fac6002870))
* Update README.md Go instructions ([#1464](https://github.com/ory/kratos/issues/1464)) ([8db4b4a](https://github.com/ory/kratos/commit/8db4b4a966c5c418cf9d9169b66d7dacff256113))
* Update remaining self service documentation ([bcc6284](https://github.com/ory/kratos/commit/bcc62846297a67216e01e8c31d375d376c1b7cef))
* Update sdk use ([bcb8c06](https://github.com/ory/kratos/commit/bcb8c06ee324c639e548fc06315d9e952f470582))
* Update settings documentation ([258ceaf](https://github.com/ory/kratos/commit/258ceaf84e6ee15b8eee2f203f456f73e7d406d5))
* Use correct path ([#1333](https://github.com/ory/kratos/issues/1333)) ([e401135](https://github.com/ory/kratos/commit/e401135cf415d7e3e6a8ca463dd47e46fe399b33))

### Features

* Add examples for usage of go sdk ([870c2bd](https://github.com/ory/kratos/commit/870c2bd316a3e5b7ce9d526ebf369e41dbea2630))
* Add GetContextualizer ([ac32717](https://github.com/ory/kratos/commit/ac3271742c9c2b968b08dd2b35a5d120c5befcd9))
* Add helper for starting kratos e2e ([#1469](https://github.com/ory/kratos/issues/1469)) ([b9c7674](https://github.com/ory/kratos/commit/b9c7674c30df8200bcd7223c2fa6b058e833bb8a))
* Add instana as possible tracing provider ([#1429](https://github.com/ory/kratos/issues/1429)) ([abe48a9](https://github.com/ory/kratos/commit/abe48a97ee75567979a70f00dd73ff698efcc75d)), closes [#1385](https://github.com/ory/kratos/issues/1385)
* Add redoc ([#1502](https://github.com/ory/kratos/issues/1502)) ([492266d](https://github.com/ory/kratos/commit/492266de9c9b7b775a7b21b5890361380d911da4))
* Add vk and yandex providers to oidc providers and documentation ([#1339](https://github.com/ory/kratos/issues/1339)) ([22a3ef9](https://github.com/ory/kratos/commit/22a3ef98181eb5922cc0f1c016d42ce46732d0a2)), closes [#1234](https://github.com/ory/kratos/issues/1234)
* Anti-CSRF measures when fetching flows ([#1458](https://github.com/ory/kratos/issues/1458)) ([5171557](https://github.com/ory/kratos/commit/51715572ea08f654d1e97d760b9c3d3a9113aa3d)), closes [#1282](https://github.com/ory/kratos/issues/1282)
* Configurable recovery/verification link lifetime ([f80d4e3](https://github.com/ory/kratos/commit/f80d4e3bf7df603b73589dbc6805c69d049921e0))
* Disable HaveIBeenPwned validation when HaveIBeenPwnedEnabled is set to false ([#1445](https://github.com/ory/kratos/issues/1445)) ([44002f4](https://github.com/ory/kratos/commit/44002f4fa93b40a6bb18f1e759bb416d082cec08)), closes [#316](https://github.com/ory/kratos/issues/316):

    This patch introduces an option to disable HaveIBeenPwned checks in environments where outbound network calls are disabled.

* **identities:** Add a state to identities ([#1312](https://github.com/ory/kratos/issues/1312)) ([d22954e](https://github.com/ory/kratos/commit/d22954e2fdb7b2dd5206651b6dd5cf96185a33ba)), closes [#598](https://github.com/ory/kratos/issues/598)
* Improve contextualization in serve/daemon ([f83cd35](https://github.com/ory/kratos/commit/f83cd355422fb4b422f703406473bda914d8419c))
* Include Credentials Metadata in admin api ([#1274](https://github.com/ory/kratos/issues/1274)) ([c8b6219](https://github.com/ory/kratos/commit/c8b62190fca53db4e1b3a4ddb5253fbd2fd46002)), closes [#820](https://github.com/ory/kratos/issues/820)
* Include Credentials Metadata in admin api Missing changes in handler ([#1366](https://github.com/ory/kratos/issues/1366)) ([a71c220](https://github.com/ory/kratos/commit/a71c2208dedac45d32dab578e62a5e3105c8dee0))
* Natively support SPA for login flows ([6ff67af](https://github.com/ory/kratos/commit/6ff67afa8b0fc0a95cec44d3dda2cbc1987b51dd)), closes [#1138](https://github.com/ory/kratos/issues/1138) [#668](https://github.com/ory/kratos/issues/668):

    This patch adds the long-awaited capabilities for natively working with SPAs and AJAX requests. Previously, requests to the `/self-service/login/browser` endpoint would always end up in a redirect. Now, if the `Accept` header is set to `application/json`, the login flow will be returned as JSON instead. Accordingly, changes to the error and submission flow have been made to support `application/json` content types and SPA / AJAX requests.

* Natively support SPA for recovery flows ([5461244](https://github.com/ory/kratos/commit/5461244943286081e13c304a3b38413b8ee6fdf2)):

    This patch adds the long-awaited capabilities for natively working with SPAs and AJAX requests. Previously, requests to the `/self-service/recovery/browser` endpoint would always end up in a redirect. Now, if the `Accept` header is set to `application/json`, the registration flow will be returned as JSON instead. Accordingly, changes to the error and submission flow have been made to support `application/json` content types and SPA / AJAX requests.

* Natively support SPA for registration flows ([57d3c57](https://github.com/ory/kratos/commit/57d3c5786a88f0648e7fa57f181f060a057ec19f)), closes [#1138](https://github.com/ory/kratos/issues/1138) [#668](https://github.com/ory/kratos/issues/668):

    This patch adds the long-awaited capabilities for natively working with SPAs and AJAX requests. Previously, requests to the `/self-service/registration/browser` endpoint would always end up in a redirect. Now, if the `Accept` header is set to `application/json`, the registration flow will be returned as JSON instead. Accordingly, changes to the error and submission flow have been made to support `application/json` content types and SPA / AJAX requests.

* Natively support SPA for settings flows ([ea4395e](https://github.com/ory/kratos/commit/ea4395ed25d5668e4ce365336cd7a5e13e0ba1cc)):

    This patch adds the long-awaited capabilities for natively working with SPAs and AJAX requests. Previously, requests to the `/self-service/settings/browser` endpoint would always end up in a redirect. Now, if the `Accept` header is set to `application/json`, the registration flow will be returned as JSON instead. Accordingly, changes to the error and submission flow have been made to support `application/json` content types and SPA / AJAX requests.

* Natively support SPA for verification flows ([c151500](https://github.com/ory/kratos/commit/c1515009dcd1b5946a93733feedb01753de91c3d)):

    This patch adds the long-awaited capabilities for natively working with SPAs and AJAX requests. Previously, requests to the `/self-service/verification/browser` endpoint would always end up in a redirect. Now, if the `Accept` header is set to `application/json`, the registration flow will be returned as JSON instead. Accordingly, changes to the error and submission flow have been made to support `application/json` content types and SPA / AJAX requests.

* Protect logout against CSRF ([#1433](https://github.com/ory/kratos/issues/1433)) ([1a7a74c](https://github.com/ory/kratos/commit/1a7a74c3fe425f139a87bb68fbc07f8862c00e58)), closes [#142](https://github.com/ory/kratos/issues/142)
* Sign in with Auth0 ([#1352](https://github.com/ory/kratos/issues/1352)) ([f618a53](https://github.com/ory/kratos/commit/f618a53fb971ad16121aa8728cfec54253bb3f44)), closes [#609](https://github.com/ory/kratos/issues/609)
* Support api in settings error ([23105db](https://github.com/ory/kratos/commit/23105dbb836d920b8766536b65de58932f53d6f6))
* Support reading session token from X-Session-Token HTTP header ([dcaefd9](https://github.com/ory/kratos/commit/dcaefd94a0b2cf819424f2e10b3bdae63b256726))
* Team id in slack oidc ([#1409](https://github.com/ory/kratos/issues/1409)) ([e4d021a](https://github.com/ory/kratos/commit/e4d021a037a6b44f8bd66372e9c260c640e87b9d)), closes [#1408](https://github.com/ory/kratos/issues/1408)
* TLS support for public and admin endpoints ([#1466](https://github.com/ory/kratos/issues/1466)) ([7f44f81](https://github.com/ory/kratos/commit/7f44f819a5989a699e403e02c69541369573078f)), closes [#791](https://github.com/ory/kratos/issues/791)
* Update openapi specs and regenerate ([cac507e](https://github.com/ory/kratos/commit/cac507eb5b1f39d003d72e57912dbbfe6f92deb1))

### Tests

* Add tests for cookie behavior of API and browser endpoints ([d1b1521](https://github.com/ory/kratos/commit/d1b15217867cfb92a615c793b26fad288f5e5742))
* **e2e:** Greatly improve test performance ([#1421](https://github.com/ory/kratos/issues/1421)) ([2ffad9e](https://github.com/ory/kratos/commit/2ffad9ee751471451e2151719a2e70d5f89437b0)):

    Instead of running the individual profiles as separate Cypress instances, we now use one singular instance which updates the Ory Kratos configuration depending on the test context. This ensures that hot-reloading is properly working while also signficantly reducing the amount of time spent on booting up the service dependencies.

* **e2e:** Resolve flaky test issues related to timeouts and speed ([b083791](https://github.com/ory/kratos/commit/b083791858bc26a02250d7f5a4e8883cd7392a58))
* **e2e:** Resolve recovery regression ([72c47d6](https://github.com/ory/kratos/commit/72c47d65415efbb53d5d680bd9d78156d577b67f))
* **e2e:** Resolve test config regressions ([eb9c4f9](https://github.com/ory/kratos/commit/eb9c4f98f2e30ac420ed1e3f18a3f0d9ff23846e))
* Remove obsolete console.log ([3ecc869](https://github.com/ory/kratos/commit/3ecc869ebfef5c97334ae4334fb4af98ca9baf97))
* Resolve e2e regressions ([b0d3b82](https://github.com/ory/kratos/commit/b0d3b82f301942bebe3c0027c8b3160749f907af))
* Resolve migratest panic ([89d05ae](https://github.com/ory/kratos/commit/89d05ae0c376c4ea1f23708cccf95c9754a29c94))
* Resolve mobile regressions ([868e82e](https://github.com/ory/kratos/commit/868e82e3d7aec4cde80d7c1d0ce4601e40695f27))
* Resolve oidc regressions ([2403082](https://github.com/ory/kratos/commit/2403082701ac5d667706afd893a6d406496f67fa))

### Unclassified

* add CoC shield (#1439) ([826ed1a](https://github.com/ory/kratos/commit/826ed1a6deafdc2631a5c72f0bfacc91b06a3435)), closes [#1439](https://github.com/ory/kratos/issues/1439)
* u ([b03549b](https://github.com/ory/kratos/commit/b03549b6340ec0bf4f9d741ce145ca90bbc09968))
* u ([318a31d](https://github.com/ory/kratos/commit/318a31d400b97653b4f377c67df4ae0afea189d9))
* Format ([eca7aff](https://github.com/ory/kratos/commit/eca7aff2be96c673dd6be5dc36ab1f4850cc44f0))
* Format ([5cc9fc3](https://github.com/ory/kratos/commit/5cc9fc3a6e91a96225d016d60c8da5cef647ac18))
* Format ([e525805](https://github.com/ory/kratos/commit/e525805246431075d26c3f47596ae93f6580d8ee))
* Format ([4a692ac](https://github.com/ory/kratos/commit/4a692acc7db160068ed7d81461b173bc957e4736))
* Format ([169c0cd](https://github.com/ory/kratos/commit/169c0cd8d424babef69a52ddf65e2b75ded09a46))


# [0.6.3-alpha.1](https://github.com/ory/kratos/compare/v0.6.2-alpha.1...v0.6.3-alpha.1) (2021-05-17)

This release addresses some minor bugs and improves the SDK experience. Please be aware that the Ory Kratos SDK v0.6.3+ have breaking changes compared to Ory Kratos SDK v0.6.2. If you do not wish to update your code, you can keep using the Ory Kratos v0.6.2 SDK and upgrade to v0.6.3+ SDKs at a later stage, as only naming conventions have changed!



## Breaking Changes

Unfortunately, some method signatures have changed in the SDKs. Below is a list of changed entries:

- Error `genericError` was renamed to `jsonError` and now includes more information and better typing for errors;
- The following functions have been renamed:
   - `initializeSelfServiceLoginViaAPIFlow` -> `initializeSelfServiceLoginForNativeApps`
   - `initializeSelfServiceLoginViaBrowserFlow` -> `initializeSelfServiceLoginForBrowsers`
   - `initializeSelfServiceRegistrationViaAPIFlow` -> `initializeSelfServiceRegistrationForNativeApps`
   - `initializeSelfServiceRegistrationViaBrowserFlow` -> `initializeSelfServiceRegistrationForBrowsers`
   - `initializeSelfServiceSettingsViaAPIFlow` -> `initializeSelfServiceSettingsForNativeApps`
   - `initializeSelfServiceSettingsViaBrowserFlow` -> `initializeSelfServiceSettingsForBrowsers`
   - `initializeSelfServiceRecoveryViaAPIFlow` -> `initializeSelfServiceRecoveryForNativeApps`
   - `initializeSelfServiceRecoveryViaBrowserFlow` -> `initializeSelfServiceRecoveryForBrowsers`
   - `initializeSelfServiceVerificationViaAPIFlow` -> `initializeSelfServiceVerificationForNativeApps`
   - `initializeSelfServiceVerificationViaBrowserFlow` -> `initializeSelfServiceVerificationForBrowsers`
- Some type names have changed, for example `traits` -> `identityTraits`.



### Bug Fixes

* Improve settings oas definition ([867abfc](https://github.com/ory/kratos/commit/867abfc813b08142786f71bfe28e373d4754c959))
* Properly handle CSRF for API flows in recovery and verification strategies ([461c829](https://github.com/ory/kratos/commit/461c829dc4d7f7b70620abee2263efba78ce463a)), closes [#1141](https://github.com/ory/kratos/issues/1141)
* **session:** Use specific headers before bearer use ([82c0b54](https://github.com/ory/kratos/commit/82c0b545b29b30fcf3521d9621ec5c5f1a23dc96))
* Use correct api spec path ([5f41f87](https://github.com/ory/kratos/commit/5f41f87bea2919cdf4e9f55c6ad938c5bc08b619))
* Use correct openapi path for validation ([#1340](https://github.com/ory/kratos/issues/1340)) ([a0f5673](https://github.com/ory/kratos/commit/a0f5673d6aa4e60bab06ef699dce231f0bf4aeff))

### Code Generation

* Pin v0.6.3-alpha.1 release commit ([5edf952](https://github.com/ory/kratos/commit/5edf9524d812795ac5712e4a9541b34359234724))

### Code Refactoring

* Improve SDK experience ([71b8511](https://github.com/ory/kratos/commit/71b8511ae1f6f77b2996a01a55accc99d171cfaf)):

    This patch resolves UX issues in the auto-generated SDKs by using consistent naming and introducing a test suite for the Ory SaaS.



# [0.6.2-alpha.1](https://github.com/ory/kratos/compare/v0.6.1-alpha.1...v0.6.2-alpha.1) (2021-05-14)

Resolves an issue in the Go SDK.





### Code Generation

* Pin v0.6.2-alpha.1 release commit ([99c1b1d](https://github.com/ory/kratos/commit/99c1b1d674df3bd8263f7cbf1ed2bdfae6281f69))

### Documentation

* Update link to example email template. ([#1326](https://github.com/ory/kratos/issues/1326)) ([28a1723](https://github.com/ory/kratos/commit/28a17234b557cabf17b592ee68041aec695f6d20))


# [0.6.1-alpha.1](https://github.com/ory/kratos/compare/v0.6.0-alpha.2...v0.6.1-alpha.1) (2021-05-11)

This release primarily addresses issues in the SDK CI pipeline.





### Code Generation

* Pin v0.6.1-alpha.1 release commit ([1df82da](https://github.com/ory/kratos/commit/1df82daaf3f9cfd3a470d7c9bf8d96abbd52b872))

### Features

* Allow changing password validation API DNS name ([#1009](https://github.com/ory/kratos/issues/1009)) ([ced85e8](https://github.com/ory/kratos/commit/ced85e8091b06d864cc55c9975f8b006f6be1ce4))


# [0.6.0-alpha.2](https://github.com/ory/kratos/compare/v0.6.0-alpha.1...v0.6.0-alpha.2) (2021-05-07)

This release addresses issues with the SDK pipeline and also closes a bug related to email sending.





### Bug Fixes

* Update node image ([eef307e](https://github.com/ory/kratos/commit/eef307e6bc33c9ec36ed9138f99c19f72c7be575))

### Code Generation

* Pin v0.6.0-alpha.2 release commit ([a3658ba](https://github.com/ory/kratos/commit/a3658badb848656b61d54b3ee35114972afc1f35))

### Features

* Fix unexpected emails when update profile ([#1300](https://github.com/ory/kratos/issues/1300)) ([7b24485](https://github.com/ory/kratos/commit/7b2448566f82e69d555997654ee410f9b4ff3939)), closes [#1221](https://github.com/ory/kratos/issues/1221)


# [0.6.0-alpha.1](https://github.com/ory/kratos/compare/v0.5.5-alpha.1...v0.6.0-alpha.1) (2021-05-05)

Today Ory Kratos v0.6 has been released! We are extremely happy with this release where we made many changes that pave the path for exciting future additions such as integrating 2FA more easily! We would like to thank the awesome community for the many contributions.

Kratos v0.6 includes an insane amount of work spread over the last five months - 480 commits and over 4200 files changed. The team at Ory would like to thank all the amazing contributors that made this release possible!

Here is a summary of the most important changes:

- Ory Kratos now support highly customizable web hooks - contributed by [@dadrus](https://github.com/dadrus) and [@martinei](https://github.com/martinei);
- Ory Kratos Courier can now be run as a standalone task using `kratos courier watch -c your/config.yaml`. To use the mail courier as a background task of the server run `kratos serve --watch-courier` - contributed by [@mattbonnell](https://github.com/mattbonnell);
- Reworked migrations to ensure stable migrations in production systems - backward compatibility is ensured and tested;
- Upgraded to Go 1.16 and removed all static file packers, greatly improving build time;
- Refactored our SDK pipeline from Swagger 2.0 to OpenAPI Spec 3.0. Ory's SDKs are now properly typed and bugs can easily be addressed using a patch process. Due to this, we had to move away from go-swagger client generation for the Go SDK and replace it with openapi-generator. This, unfortunately, introduced breaking changes in the Go SDK APIs. If you have problems migrating, or have a tutorial on how to migrate, please share it with the community on GitHub!
- Created reliable health and status checks by ensuring that e.g. migrations have completed;
- Made resilient CLI client commands e.g. kratos identities list;
- Better support for cookies in multi-domain setups called [domain aliasing](https://www.ory.sh/kratos/docs/guides/configuring-cookies);
- A new, [dynamically generated FAQ](https://www.ory.sh/kratos/docs/next/faq);
- Enhanced GitHub and Google claims parsing;
- Faster and more resilient CI/CD pipeline;
- Improvements for running Ory Kratos in secure Kubernetes environments;
- Better Helm Charts for Ory Kratos;
- Support for BCrypt hashing, which is now the default hashing implementation. Existing Argon2id hashes will be automatically translated to BCrypt hashes when the user signs in the next time. We recommend using Argon2id in use cases where password hashing is required to take at least 2 seconds. For regular web workloads (200ms) BCrypt is recommended - contributed by [@seremenko-wish](https://github.com/seremenko-wish);
- The Argon2 memory configuration is now human readable: `hashers.argon2.memory: 131072` ->  `hashers.argon2.memory: 131072B` (supports kb, mb, kib, mib, ...).
- Add possibility to keep track of the return_to URLs for verification_flows after sign up using the new `after_verification_return_to` query parameter (e.g. `http://foo.com/registration?after_verification_return_to=verification_callback`) - contributed by [@mattbonnell](https://github.com/mattbonnell);
- Emails are now populated at delivery time, offering more flexibility in terms of templating;
- Emails contain a plaintext variant for email clients that do not display HTML emails - contributed by [@mattbonnell](https://github.com/mattbonnell);
- Mitigation for password hash timing attacks by adding a random delay to login attempts where the user does not exist;
- Resolving SDKs issues for whoami requests;
- Simplified database schema for faster processing, significantly reducing the amount of data stored and latency as several JOINS have been removed;
- Support for binding the HTTP server on UNIX sockets - contributed by [@sloonz](https://github.com/sloonz);

There are even more contributions by [@NickUfer](https://github.com/NickUfer) and [harnash](https://github.com/harnash). In total, [33 people contributed to this release](https://github.com/ory/kratos/graphs/contributors?from=2020-12-09&to=2021-05-04&type=c)! Thank you all!

*IMPORTANT:* Please be aware that the database schema has changed significantly. Applying migrations might, depending on the size of your tables, take a long time. If your database does not support online schema migrations, you will experience downtimes. Please test the migration process before applying it to production!

The probably biggest and most significant change is the refactoring of how self-service flows work and what their payloads look like. This took the most amount of time and introduces the biggest breaking changes in our APIs. We did this refactoring to support several flows planned for Ory Kratos 0.7:

1. Displaying QR codes (images) in login, registration, settings flows - necessary for TOTP 2FA;
2. Asking the login/registration/... UI to render JavaScript - necessary for CAPTCHA, WebAuthN, and more;
3. Refactoring the form submission API to use one endpoint per flow instead of one endpoint per flow per method. This allows us to process several registration/settings/login/... methods such as password + 2FA in one Go.

[Check out how we migrated the NodeJS app](https://github.com/ory/kratos-selfservice-ui-node/commit/53ad90b6c82cde48994feebcc75d754ba74929ec) from the Ory Kratos 0.5 to Ory Kratos 0.6 SDK.

Let's take a look into how these payloads have changed (the flows have identical configuration):

**Ory Kratos v0.5**

*Login*

```json
{
  "id": "ee6e1565-d3c3-4f3a-a6ff-0ba6b3a6481b",
  "type": "browser",
  "expires_at": "2020-09-13T10:49:54.8295242Z",
  "issued_at": "2020-09-13T10:39:54.8295242Z",
  "request_url": "http://127.0.0.1:4433/self-service/login/browser",
  "methods": {
    "password": {
      "method": "password",
      "config": {
        "action": "http://127.0.0.1:4433/self-service/login/methods/password?flow=ee6e1565-d3c3-4f3a-a6ff-0ba6b3a6481b",
        "method": "POST",
        "fields": [
          {
            "name": "identifier",
            "type": "text",
            "required": true,
            "value": ""
          },
          {
            "name": "password",
            "type": "password",
            "required": true
          },
          {
            "name": "csrf_token",
            "type": "hidden",
            "required": true,
            "value": "lNrB8sW2fZY6xnnA91V7ISYrUVcJbmRCOoGHjsnsfI7MsIL5RTbuWFm5TRv1azQW+7IRCfnt2Ch6pC42/45sJQ=="
          }
        ]
      }
    }
  },
  "forced": false
}
```

*Registration*

```json
{
  "id": "2b1f8c5d-e830-4068-97b8-35f776df9217",
  "type": "browser",
  "expires_at": "2020-09-13T10:53:15.1774019Z",
  "issued_at": "2020-09-13T10:43:15.1774019Z",
  "request_url": "http://127.0.0.1:4433/self-service/registration/browser",
  "active": "password",
  "messages": null,
  "methods": {
    "password": {
      "method": "password",
      "config": {
        "action": "http://127.0.0.1:4433/self-service/registration/methods/password?flow=2b1f8c5d-e830-4068-97b8-35f776df9217",
        "method": "POST",
        "fields": [
          {
            "name": "csrf_token",
            "type": "hidden",
            "required": true,
            "value": "1IlHWNjkAZxuYhO82WPgNTgujKsUSaW87j6og/20i2uM4wRTWGSSUg0dJ2fbXa8C5bfM9eTKGdauGwE7y9abwA=="
          },
          {
            "name": "password",
            "type": "password",
            "required": true,
            "messages": [
              {
                "id": 4000005,
                "text": "The password can not be used because the password has been found in at least 23597311 data breaches and must no longer be used..",
                "type": "error",
                "context": {
                  "reason": "the password has been found in at least 23597311 data breaches and must no longer be used."
                }
              }
            ]
          },
          {
            "name": "traits.email",
            "type": "text",
            "value": "foo@ory.sh"
          },
          {
            "name": "traits.name.first",
            "type": "text",
            "value": "Ory"
          },
          {
            "name": "traits.name.last",
            "type": "text",
            "value": "Corp"
          }
        ]
      }
    }
  }
}
```

**Ory Kratos v0.6**

*Login*

As you can see below, the input name `identifier` has changed to `password_identifier`.

```json
{
  "id": "07016811-917d-4788-bb9c-fc297897af6c",
  "type": "browser",
  "expires_at": "2021-04-28T08:37:53.924337873Z",
  "issued_at": "2021-04-28T08:27:53.924337873Z",
  "request_url": "http://127.0.0.1:4433/self-service/login/browser",
  "ui": {
    "action": "http://127.0.0.1:4433/self-service/login?flow=07016811-917d-4788-bb9c-fc297897af6c",
    "method": "POST",
    "nodes": [
      {
        "type": "input",
        "group": "default",
        "attributes": {
          "name": "csrf_token",
          "type": "hidden",
          "value": "IuiHo8fajl6Nwi2CfR33bmC7ZI+geYY44oinK/npkS9gaeV6DlkzS0voYZuyGawsCruvlawFl/pY6/Ph6d9JVg==",
          "required": true,
          "disabled": false
        },
        "messages": null,
        "meta": {}
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "password_identifier",
          "type": "text",
          "value": "",
          "required": true,
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070004,
            "text": "ID",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "password",
          "type": "password",
          "required": true,
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070001,
            "text": "Password",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "method",
          "type": "submit",
          "value": "password",
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1010001,
            "text": "Sign in",
            "type": "info",
            "context": {}
          }
        }
      }
    ]
  },
  "forced": false
}
```

*Registration*

```json
{
  "id": "f0c0830a-f5b2-4c2d-a37f-2e70152a4f7c",
  "type": "browser",
  "expires_at": "2021-04-28T08:54:12.951178972Z",
  "issued_at": "2021-04-28T08:44:12.951178972Z",
  "request_url": "http://127.0.0.1:4433/self-service/registration/browser",
  "ui": {
    "action": "http://127.0.0.1:4433/self-service/registration?flow=f0c0830a-f5b2-4c2d-a37f-2e70152a4f7c",
    "method": "POST",
    "nodes": [
      {
        "type": "input",
        "group": "default",
        "attributes": {
          "name": "csrf_token",
          "type": "hidden",
          "value": "408SIAOvpKxW/WbcYfKue26MlLTMbON7T7JT1yhiSemhznD5yiwZuZDXKsWu9vU5BIxfrsAQ8rn10QcdOFSRkA==",
          "required": true,
          "disabled": false
        },
        "messages": null,
        "meta": {}
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "traits.email",
          "type": "email",
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070002,
            "text": "E-Mail",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "password",
          "type": "password",
          "required": true,
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070001,
            "text": "Password",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "traits.name.first",
          "type": "text",
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070002,
            "text": "First Name",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "traits.name.last",
          "type": "text",
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1070002,
            "text": "Last Name",
            "type": "info"
          }
        }
      },
      {
        "type": "input",
        "group": "password",
        "attributes": {
          "name": "method",
          "type": "submit",
          "value": "password",
          "disabled": false
        },
        "messages": null,
        "meta": {
          "label": {
            "id": 1040001,
            "text": "Sign up",
            "type": "info",
            "context": {}
          }
        }
      }
    ]
  }
}
```

These changes are analogous to settings, recovery, verification as well!

We hope you enjoy these new features as much as we do, even if we were not able to deliver 2FA in time for 0.6!

On the last note, Ory Platform, a SaaS is launching in May as early access. It includes Ory Kratos as a managed service and we plan on adding all the other Ory open source technology soon. In our view, Ory is a 10x improvement to the existing "IAM" ecosystem:

1. The major components of Ory Platform are and will remain Apache 2.0 licensed open source. We are *not changing our approach or commitment to open source*. The SaaS model allows us to keep commercialization and open source in harmony;
2. Affordable pricing - Ory does not charge on a per identity basis;
3. Supporting migrations from the Ory Platform (SaaS) to the open-source and vice versa;
4. Offering a planet-scale service with ultra-low latencies no matter where your users are;
5. The largest set of features and APIs of any Identity Product, including Identity and Credentials Management (Ory Kratos), Permissions and Access Control (Ory Keto), Zero-Trust Networking (Ory Oathkeeper), OAuth2, and OpenID Connect (Ory Hydra) plus integrations with Stripe, Mailchimp, Salesforce, and much more.
6. Data aggregation for threat mitigation, auditing, and other use cases (e.g. integration with Snowflake, AWS RedShift, GCP BigQuery, ...)
7. All the advantages of the open source projects - headless, fully customizable, strong security, built with a community;
If you wish to become a part of the preview, please write a short email to [sales@ory.sh](mailto:sales@ory.sh). Early access adopters are also eligible for Ory Hypercare - helping you integrate with Ory fast and designing your security architecture following industry best practices.

Thank you for being a part of our community!



## Breaking Changes

BCrypt is now the default hashing alogrithm. If you wish to continue using Argon2id please set `hashers.algorithm` to `argon2`.

This implies a significant breaking change in the verification flow payload. Please consult the new ui documentation. In essence, the login flow's `methods` key was replaced with a generic `ui` key which provides information for the UI that needs to be rendered.

To apply this patch you must apply SQL migrations. These migrations will drop the flow method table implying that all verification flows that are ongoing will become invalid. We recommend purging the flow table manually as well after this migration has been applied, if you have users doing at least one self-service flow per minute.

This implies a significant breaking change in the recovery flow payload. Please consult the new ui documentation. In essence, the login flow's `methods` key was replaced with a generic `ui` key which provides information for the UI that needs to be rendered.

To apply this patch you must apply SQL migrations. These migrations will drop the flow method table implying that all recovery flows that are ongoing will become invalid. We recommend purging the flow table manually as well after this migration has been applied, if you have users doing at least one self-service flow per minute.

This implies a significant breaking change in the settings flow payload. Please consult the new ui documentation. In essence, the login flow's `methods` key was replaced with a generic `ui` key which provides information for the UI that needs to be rendered.

To apply this patch you must apply SQL migrations. These migrations will drop the flow method table implying that all settings flows that are ongoing will become invalid. We recommend purging the flow table manually as well after this migration has been applied, if you have users doing at least one self-service flow per minute.

This implies a significant breaking change in the registration flow payload. Please consult the new ui documentation. In essence, the login flow's `methods` key was replaced with a generic `ui` key which provides information for the UI that needs to be rendered.

To apply this patch you must apply SQL migrations. These migrations will drop the flow method table implying that all registration flows that are ongoing will become invalid. We recommend purging the flow table manually as well after this migration has been applied, if you have users doing at least one self-service flow per minute.

This implies a significant breaking change in the login flow payload. Please consult the new ui documentation. In essence, the login flow's `methods` key was replaced with a generic `ui` key which provides information for the UI that needs to be rendered.

To apply this patch you must apply SQL migrations. These migrations will drop the flow method table implying that all login flows that are ongoing will become invalid. We recommend purging the flow table manually as well after this migration has been applied, if you have users doing at least one self-service flow per minute.

This change introduces a new feature: UI Nodes. Previously, all self-service flows (login, registration, ...) included form fields (e.g. `methods.password.config.fields`). However, these form fields lacked support for other types of UI elements such as links (for e.g. "Sign in with Google"), images (e.g. QR codes), javascript (e.g. WebAuthn), or text (e.g. recovery codes). With this patch, these new features have been introduced. Please be aware that this introduces significant breaking changes which you will need to adopt to in your UI. Please refer to the most recent documentation to see what has changed. Conceptionally, most things stayed the same - you do however need to update how you access and render the form fields.

Please be also aware that this patch includes SQL migrations which **purge existing self-service forms** from the database. This means that users will need to re-start the login/registration/... flow after the SQL migrations have been applied! If you wish to keep these records, make a back up of your database prior!

This change introduces a new feature: UI Nodes. Previously, all self-service flows (login, registration, ...) included form fields (e.g. `methods.password.config.fields`). However, these form fields lacked support for other types of UI elements such as links (for e.g. "Sign in with Google"), images (e.g. QR codes), javascript (e.g. WebAuthn), or text (e.g. recovery codes). With this patch, these new features have been introduced. Please be aware that this introduces significant breaking changes which you will need to adopt to in your UI. Please refer to the most recent documentation to see what has changed. Conceptionally, most things stayed the same - you do however need to update how you access and render the form fields.

Please be also aware that this patch includes SQL migrations which **purge existing self-service forms** from the database. This means that users will need to re-start the login/registration/... flow after the SQL migrations have been applied! If you wish to keep these records, make a back up of your database prior!

The configuration value for `hashers.argon2.memory` is now a string representation of the memory amount including the unit of measurement. To convert the value divide your current setting (KB) by 1024 to get a result in MB or 1048576 to get a result in GB. Example: `131072` would now become `128MB`.

Co-authored-by: aeneasr <3372410+aeneasr@users.noreply.github.com>
Co-authored-by: aeneasr <aeneas@ory.sh>

Please run SQL migrations when applying this patch.

The following configuration keys were updated:

```patch
selfservice.methods.password.config.max_breaches
```
- `password.max_breaches` -> `selfservice.methods.password.config.max_breaches`
- `password.ignore_network_errors` -> `selfservice.methods.password.config.ignore_network_errors`

After battling with [spf13/viper](https://github.com/spf13/viper) for several years we finally found a viable alternative with [knadh/koanf](https://github.com/knadh/koanf). The complete internal configuration infrastructure has changed, with several highlights:

1. Configuration sourcing works from all sources (file, env, cli flags) with validation against the configuration schema, greatly improving developer experience when changing or updating configuration.
2. Configuration reloading has improved significantly and works flawlessly on Kubernetes.
3. Performance increased dramatically, completely removing the need for a cache layer between the configuration system and ORY Hydra.
4. It is now possible to load several config files using the `--config` flag.
5. Configuration values are now sent to the tracer (e.g. Jaeger) if tracing is enabled.

Please be aware that ORY Kratos might complain about an invalid configuration, because the validation process has improved significantly.



### Bug Fixes

* Add include stub go files ([6d725b1](https://github.com/ory/kratos/commit/6d725b1461a26d99c8b179be8ca219ba83ba0f17))
* Add index to migration status ([8c6ec27](https://github.com/ory/kratos/commit/8c6ec2741535c090aae16f02a744f56c15923e2b))
* Add node_modules to format tasks ([e5f6b36](https://github.com/ory/kratos/commit/e5f6b36caeff080905d15566cf55f8fe4905dbc0))
* Add titles to identity schema ([73c15d2](https://github.com/ory/kratos/commit/73c15d23840aa83d2c99c013cad52ad7df285f18))
* Adopt to new go-swagger changes ([5c45bd9](https://github.com/ory/kratos/commit/5c45bd9f354bfe19b8cbcd7eb4eaebf22c441f42))
* Allow absolute file URLs as config values ([#1069](https://github.com/ory/kratos/issues/1069)) ([4bb4f67](https://github.com/ory/kratos/commit/4bb4f679d1fe0a49edb0c0189bb7a2188d4f850d))
* Allow hashtag in ui urls ([#1040](https://github.com/ory/kratos/issues/1040)) ([7591f07](https://github.com/ory/kratos/commit/7591f07f7d48376a03e9eacfdb6f4a93fd26c0d5))
* Avoid unicode-escaping ampersand in recovery URL query string ([#1212](https://github.com/ory/kratos/issues/1212)) ([d172368](https://github.com/ory/kratos/commit/d17236870af490f043d87e220179b35c9eb2dd4e))
* Bcrypt regression in credentials counting ([23fc13b](https://github.com/ory/kratos/commit/23fc13ba778e0045ca30c00d673ebd6c2f2b7fb7))
* Broken make quickstart-dev task ([#980](https://github.com/ory/kratos/issues/980)) ([999828a](https://github.com/ory/kratos/commit/999828ae036f20bde6d12fe89851e1fde9bdaca6)), closes [#965](https://github.com/ory/kratos/issues/965)
* Broken make sdk task ([#977](https://github.com/ory/kratos/issues/977)) ([5b01c7a](https://github.com/ory/kratos/commit/5b01c7a368c5bcfaa3af218d42f15288f51ab3e4)), closes [#950](https://github.com/ory/kratos/issues/950)
* Call contextualized test helpers ([e1f3f78](https://github.com/ory/kratos/commit/e1f3f7835696b039409c9d05f63665aba7a179ae))
* **cmd:** Make HTTP calls resilient ([e8ed61f](https://github.com/ory/kratos/commit/e8ed61fc3e806453f78b8fa629e96ff7b320bf95))
* Code integer parsing bit size ([#1178](https://github.com/ory/kratos/issues/1178)) ([31e9632](https://github.com/ory/kratos/commit/31e9632bcd6ec3bdeabe862a4cce89021c6dd361)):

    In some cases we had a wrong bitsize of `64`, while the var was later cast to `int`. Replaced with a bitsize of `0`, which is the value to cast to `int`.

* Contextualize identity persister ([f8640c0](https://github.com/ory/kratos/commit/f8640c04f0c5873c39c8af4652d16bfbd347b79e))
* Convert all identifiers to lower case on login ([#815](https://github.com/ory/kratos/issues/815)) ([d64b575](https://github.com/ory/kratos/commit/d64b5757c710c436d6789dbdb33ed04dc11cbdf9)), closes [#814](https://github.com/ory/kratos/issues/814)
* Courier adress ([#1198](https://github.com/ory/kratos/issues/1198)) ([ebe4e64](https://github.com/ory/kratos/commit/ebe4e643150f7603a1e3a3cf6f909135097b3f49)), closes [#1194](https://github.com/ory/kratos/issues/1194)
* Courier message dequeue race condition ([#1024](https://github.com/ory/kratos/issues/1024)) ([5396a82](https://github.com/ory/kratos/commit/5396a82c34eef5d42444b5c4371bd4f820fe3eb0)), closes [#652](https://github.com/ory/kratos/issues/652) [#732](https://github.com/ory/kratos/issues/732):

    Fixes the courier message dequeuing race condition by modifying `*sql.Persister.NextMessages(ctx context.Context, limit uint8)` to retrieve only messages with status `MessageStatusQueued` and update the status of the retrieved messages to `MessageStatusProcessing` within a transaction. On message send failure, the message's status is reset to `MessageStatusQueued`, so that the message can be dequeued in a subsequent `NextMessages` call. On message send success, the status is updated to `MessageStatusSent` (no change there).

* Define credentials types as sql template and resolve crdb issue ([a2d6eeb](https://github.com/ory/kratos/commit/a2d6eeb2928c9750741237f559197fd80494310d))
* Dereference pointer types from new flow structures ([#1019](https://github.com/ory/kratos/issues/1019)) ([efedc92](https://github.com/ory/kratos/commit/efedc920e592bd6e963726e6b123ddc40df93a59))
* Do not include smtp in tracing ([#1268](https://github.com/ory/kratos/issues/1268)) ([bbfcbf9](https://github.com/ory/kratos/commit/bbfcbf9ce595d842a53a3ea21c286d5899eeb28f))
* Do not publish version at public endpoint ([3726ed4](https://github.com/ory/kratos/commit/3726ed4d145a949b25f5b5da5f58d4f448a2a90f))
* Do not reset registration method ([554bb0b](https://github.com/ory/kratos/commit/554bb0b4e62e4ac2a321fa4dbf89ffdf37b188df))
* Do not return system errors for missing identifiers ([1fcc855](https://github.com/ory/kratos/commit/1fcc8557bfee0f7ba562a635670b61dc9acb3530)), closes [#1286](https://github.com/ory/kratos/issues/1286)
* Export mailhog dockertest runner ([1384148](https://github.com/ory/kratos/commit/138414873ad319c6c32c6cc64a73547540dffc74))
* Fix random delay norm distribution math ([#1131](https://github.com/ory/kratos/issues/1131)) ([bd9d28f](https://github.com/ory/kratos/commit/bd9d28fe354710957f4ebaf71d1fffeae3968364))
* Fork audit logger from root logger ([68a09e7](https://github.com/ory/kratos/commit/68a09e7f3dc3ded9a477bb309c68ac8c4e2c2836))
* Gitlab oidc flow ([#1159](https://github.com/ory/kratos/issues/1159)) ([0bb3eb6](https://github.com/ory/kratos/commit/0bb3eb6db1144a09f4ac356cc45e1644d862bb70)), closes [#1157](https://github.com/ory/kratos/issues/1157)
* Give specific message instead of only 404 when method is disabled ([#1025](https://github.com/ory/kratos/issues/1025)) ([2f62041](https://github.com/ory/kratos/commit/2f62041a62588f5b3b062092c57053facb858e62)):

    Enabled strategies are not only used for handlers but also in other areas
    (e.g. populating the flow methods). So we should keep the logic to get
    enabled strategies and add new functions for getting all strategies.

* **hashing:** Make bcrypt default hashing algorithm ([04abe77](https://github.com/ory/kratos/commit/04abe774ada1ef4bf318658fcf84c1d39a2a922d))
* Ignore unset domain aliases ([ada6997](https://github.com/ory/kratos/commit/ada6997ff3dc7e48fd098e40267db5f231a5201f))
* Improve cli error output ([43e9678](https://github.com/ory/kratos/commit/43e967887280b57639565dabd92a07f02fbddeb5))
* Improve error stack trace ([4351773](https://github.com/ory/kratos/commit/43517737109088eda3b1d7f5b42f78bd5eb701d2))
* Improve error tracing ([#1005](https://github.com/ory/kratos/issues/1005)) ([456fd25](https://github.com/ory/kratos/commit/456fd254485fc80b9ae02dfca672a9fea8ae0134))
* Improve test contextualization ([2f92a70](https://github.com/ory/kratos/commit/2f92a7066d72535d32146a98207996fda45e0b96))
* Initialize randomdelay with seeded source ([9896289](https://github.com/ory/kratos/commit/9896289216f10b808a8c78b86d9c27b8d74379de))
* Insert credentials type constants as part of migrations ([#865](https://github.com/ory/kratos/issues/865)) ([92b79b8](https://github.com/ory/kratos/commit/92b79b86762edddf2ad6529b98b3383b641148d5)), closes [#861](https://github.com/ory/kratos/issues/861)
* Linking a connection may result in system error ([#990](https://github.com/ory/kratos/issues/990)) ([be02a70](https://github.com/ory/kratos/commit/be02a70c3cd60adbcc13559e1cb5dc01a8572da4)), closes [#694](https://github.com/ory/kratos/issues/694)
* Marking whoami auhorization parameter as 'in header' ([#1244](https://github.com/ory/kratos/issues/1244)) ([62d8b85](https://github.com/ory/kratos/commit/62d8b85223a0535b07620b08d35c6c3f6b127642)), closes [#1215](https://github.com/ory/kratos/issues/1215)
* Move schema loaders to correct file ([029781f](https://github.com/ory/kratos/commit/029781f69448e8abc85607a03b4bd2055158cf2c))
* Move to new transaction-safe migrations ([#1063](https://github.com/ory/kratos/issues/1063)) ([2588fb4](https://github.com/ory/kratos/commit/2588fb489d76939aeec2986d30fde9075b373831)):

    This patch introduces a new SQL transaction model for running SQL migrations. This fix is particularly targeted at CockroachDB which has limited support for mixing DDL and DML statements. 
    
    Previously it could happen that migrations failure needed manual intervention. This has now been resolved. The new migration model is compatible with the old one and should work without a problem.

* Pass down context to registry ([0879446](https://github.com/ory/kratos/commit/08794461ed95965a9e5460ded2b4c04ab0f5e2e8))
* Re-enable SDK generation ([1d5854d](https://github.com/ory/kratos/commit/1d5854d6298e3d21f85a8fa01d3004166c4b3f50))
* Record cypress runs ([db35d8f](https://github.com/ory/kratos/commit/db35d8ff6bb44dc9e9acf131cb0a14a7f4a7d160))
* Rehydrate settings form on successful submission ([3457e1a](https://github.com/ory/kratos/commit/3457e1a46f48ed79eabff76f8af08b82f12ecc89)), closes [#1305](https://github.com/ory/kratos/issues/1305)
* Remove absolete 'make pack' from Dockerfile ([#1172](https://github.com/ory/kratos/issues/1172)) ([b8eb908](https://github.com/ory/kratos/commit/b8eb908529cc72a3147ad28e4eeee71850a8e431))
* Remove continuity cookies on errors ([85eea67](https://github.com/ory/kratos/commit/85eea6748be6ae8cdfc10cabaa6b677e4efd63eb))
* Remove include stubs ([1764e3a](https://github.com/ory/kratos/commit/1764e3a08a24db82dc391a77fdea09a91faffb5f))
* Remove obsolete clihelpers ([230fd13](https://github.com/ory/kratos/commit/230fd138d1bc7ec57647ea8eeca8e17baaacce0a))
* Remove record from bash script ([84a9315](https://github.com/ory/kratos/commit/84a9315a824cacd29d30b98b65725343af22732d))
* Remove stray non-ctx configs ([#1053](https://github.com/ory/kratos/issues/1053)) ([1fe137e](https://github.com/ory/kratos/commit/1fe137e0d6314bd0af47a29c00e2f72564e71cef))
* Remove trailing double-dot from error ([59581e3](https://github.com/ory/kratos/commit/59581e3fede0fd43028a5f064c350c3cc833b5b0))
* Remove unused sql migration ([1445d1d](https://github.com/ory/kratos/commit/1445d1d1b4b0b5e8ef3426a98ced9573063d8646))
* Remove unused var ([30a8cee](https://github.com/ory/kratos/commit/30a8cee22238d9f400e6d315a9bc99f710945f81))
* Remove verify hook ([98cfec6](https://github.com/ory/kratos/commit/98cfec6d72c2e7bf2db2e8dd6f8875e885923ba8)), closes [#1302](https://github.com/ory/kratos/issues/1302):

    The verify hook is automatically used when verification is enabled and has been removed as a configuration option.

* Replace jwt module ([#1254](https://github.com/ory/kratos/issues/1254)) ([3803c8c](https://github.com/ory/kratos/commit/3803c8ce43e35c51a9c1d7ab55bc662c398cf0d8)), closes [#1250](https://github.com/ory/kratos/issues/1250)
* Resolve build and release issues ([fb582aa](https://github.com/ory/kratos/commit/fb582aa06ad55ca3fd4e2b083e1e9bbb4ba7c715))
* Resolve clidoc issues ([599e9f7](https://github.com/ory/kratos/commit/599e9f773a743f811329cc57cea2748831105e58))
* Resolve compile issues ([63063c1](https://github.com/ory/kratos/commit/63063c15c17f4d3aca96b106275a3478a8ed717e))
* Resolve contextualized table issues ([5a4f0d9](https://github.com/ory/kratos/commit/5a4f0d92800df7fb5ca0df18203a6d73416814e1))
* Resolve crdb migration issue ([9f6edfd](https://github.com/ory/kratos/commit/9f6edfd1f544d5f85e5f5558a08672f40e928136))
* Resolve double hook invokation for registration ([032322c](https://github.com/ory/kratos/commit/032322c66fb6925d8f1473746cb4bfd800d60590))
* Resolve incorrect field types on oidc sign up completion ([f88b6ab](https://github.com/ory/kratos/commit/f88b6abe202605739092a8230fbdebaebcd4407a))
* Resolve lint issues ([0348825](https://github.com/ory/kratos/commit/03488250bcdbfda6ef6a536b4de6117fa8924dc8))
* Resolve lint issues ([75a995b](https://github.com/ory/kratos/commit/75a995b3f69778655611929b65ae22bd77c5370b))
* Resolve linting issues and disable nancy ([c8396f6](https://github.com/ory/kratos/commit/c8396f6007831240d83f77433876c5971a2191ef))
* Resolve mail queue issues ([b968bc4](https://github.com/ory/kratos/commit/b968bc4ed8962d421175adbcaa2dba6eaeea2245))
* Resolve merge regressions ([9862ac7](https://github.com/ory/kratos/commit/9862ac72e0877df4cf17c93e140c354e1ddbd0e7))
* Resolve oidc e2e regressions ([f28087a](https://github.com/ory/kratos/commit/f28087aaf133c116a81213f787dc6f2e982564c0))
* Resolve oidc regressions and e2e tests ([f5091fa](https://github.com/ory/kratos/commit/f5091fac161db0b1401b340a002278bc26891251))
* Resolve potential fsnotify leaks ([3159c0a](https://github.com/ory/kratos/commit/3159c0abe109ea4e3832770278c4e9bc4ca3b3e1))
* Resolve regressions and test failures ([8bae356](https://github.com/ory/kratos/commit/8bae3565ea5410b60c3e638a49f5454fac8e63d3))
* Resolve regressions in cookies and payloads ([9e34bf2](https://github.com/ory/kratos/commit/9e34bf2f6a2f3b007069a5415643c448798207a6))
* Resolve settings sudo regressions ([4b611f3](https://github.com/ory/kratos/commit/4b611f34755369eafcbafa2fc16da13ea3b82370))
* Resolve test regressions ([e3fb028](https://github.com/ory/kratos/commit/e3fb0281dd9be123271d11f2934cfb08fdc470b7))
* Resolve ui issues with nested form objects ([8e744b9](https://github.com/ory/kratos/commit/8e744b931954283cf5f5cbf3ebaca3fa94e035ed))
* Resolve update regression ([d0d661a](https://github.com/ory/kratos/commit/d0d661aaffcba8b039738b773c891ee6e8f6449e))
* Return delay instead of sleeping to improve tests ([27b977e](https://github.com/ory/kratos/commit/27b977ebbaa25b95caa7e3e4536a09ea0bfa61c3))
* Revert generator changes ([c18b97f](https://github.com/ory/kratos/commit/c18b97f333a638d4b4495678013c55faca4b04d0))
* Run correct error handler for registration hooks ([0d80447](https://github.com/ory/kratos/commit/0d80447102d5092e310ca728012f083147c0c5c9))
* Simplify data breaches password error reason ([#1136](https://github.com/ory/kratos/issues/1136)) ([33d29bf](https://github.com/ory/kratos/commit/33d29bf72af03aea77f1d318c19f5087a506719f)):

    This PR simplifies the error reason given when a password has appeared in data breaches to not include the actual number and rather just show "this password has appeared in data breaches and must not be used".

* Support form and json formats in decoder ([d420fe6](https://github.com/ory/kratos/commit/d420fe6e8a491b20063d4bfeaa0a841058087d32))
* Update openapi definitions for signup ([eb0b69d](https://github.com/ory/kratos/commit/eb0b69d50ce834b170186a39bbc9cda4d3366c36))
* Update quickstart node image ([c19b2f4](https://github.com/ory/kratos/commit/c19b2f4c57307e27ce289d44eff34f5aec1341da)):

    See https://github.com/ory/kratos/discussions/1301

* Update to new goreleaser config ([4c2a1b7](https://github.com/ory/kratos/commit/4c2a1b7f5a0059a6e0c28779808ffb27e8910553))
* Update to new healthx ([6ec987a](https://github.com/ory/kratos/commit/6ec987ae81ef0c05f2c4d1eb836c40f9d15950b2))
* Use equalfold ([1c0e52e](https://github.com/ory/kratos/commit/1c0e52ec36ff95b53e3537c5ef457f1c818d7f6b))
* Use new TB interface ([d75a378](https://github.com/ory/kratos/commit/d75a378e700a206753f2cb17032315f2981960e7))
* Use numerical User ID instead of name to avoid k8s security warnings ([#1151](https://github.com/ory/kratos/issues/1151)) ([468a12e](https://github.com/ory/kratos/commit/468a12e56f22cfdf7bd05d68159cc735e75211b2)):

    Our docker image scanner does not allow running processes inside
    container using non-numeric User spec (to determine if we are trying
    to run docker image as root).

* Use remote dependencies ([1e56457](https://github.com/ory/kratos/commit/1e56457d49e1cde69baa41e3111ca113aa49ee3c))

### Code Generation

* Pin v0.6.0-alpha.1 release commit ([507d13a](https://github.com/ory/kratos/commit/507d13a8ec9cd89c9933fc8814a8a99921da69fb))

### Code Refactoring

* Adapt new sdk in testhelpers ([6e15f6f](https://github.com/ory/kratos/commit/6e15f6f86c0f146e846a384ffd6eac78406178bc))
* Add nid everywhere ([407fd95](https://github.com/ory/kratos/commit/407fd95889f416f0d76d6f3f43644a6fafa13b44))
* Contextualize everything ([7ebc3a9](https://github.com/ory/kratos/commit/7ebc3a9a1a2cd85d28c5a9adf2c0c8c10cbd072e)):

    This patch contextualizes all configuration and DBAL models.

* Do not use prefixed node names ([fc42ece](https://github.com/ory/kratos/commit/fc42ece24107dcb6e6a416cc54a2fb5de524fd94))
* Improve Argon2 tooling ([#961](https://github.com/ory/kratos/issues/961)) ([3151187](https://github.com/ory/kratos/commit/315118720419194be8baf5e5e64d7bf190179568)), closes [#955](https://github.com/ory/kratos/issues/955):

    This adds a load testing CLI that allows to adjust the hasher parameters under simulated load.

* Move faker to exportable module ([09f8ae5](https://github.com/ory/kratos/commit/09f8ae5755c9978574e91676bf5df6a23a2feb78))
* Move migratest helpers to ory/x ([7eca67e](https://github.com/ory/kratos/commit/7eca67eb9ec3e4ab065af7221911a74ed16c7c48))
* Move password config to selfservice ([cd0e0eb](https://github.com/ory/kratos/commit/cd0e0ebb0de372ff31c982ef023fe1979addb05a))
* Move to go 1.16 embed ([43c4a13](https://github.com/ory/kratos/commit/43c4a13c25be4a3a23a1ffdbecfaa0f9eda1a11d)):

    This patch replaces packr and pkged with the Go 1.16 embed feature.

* Remove password node attribute prefix ([e27fae4](https://github.com/ory/kratos/commit/e27fae4b0d7a91ff3964804963d4885178b80803))
* Remove profile node attribute prefix ([a3ff6f7](https://github.com/ory/kratos/commit/a3ff6f7eec45b1a9a1e7eb8569793fbc6a047d4f))
* Rename config structs and interfaces ([4a2f419](https://github.com/ory/kratos/commit/4a2f41977439354415118df3e37dd0cde8dac1aa))
* Rename form to container ([5da155a](https://github.com/ory/kratos/commit/5da155a07d3737cefabaf98c4ff650115f662480))
* Replace flow's forms with new ui node module ([647eb1e](https://github.com/ory/kratos/commit/647eb1e66850c67e539d0338cca6cb8ae476ee55))
* Replace flow's forms with new ui node module ([f74a5c2](https://github.com/ory/kratos/commit/f74a5c25af60936b59caee0866a21637a5c0ae6f))
* Replace login flow methods with ui container ([d4ca364](https://github.com/ory/kratos/commit/d4ca364fd8905cfb205ee047a9cb831064a6b9d0))
* Replace recovery flow methods with ui container ([cac0456](https://github.com/ory/kratos/commit/cac04562f2e4e77875275fcfd82c039d787607fb))
* Replace registration flow methods with ui container ([3f6388d](https://github.com/ory/kratos/commit/3f6388d03f91cfad17bd74ebca4d924b4b546668))
* Replace settings flow methods with ui container ([0efd17e](https://github.com/ory/kratos/commit/0efd17e76ba0a0cbd46916a7644b7bdf19bd4ab4))
* Replace verification flow methods with ui container ([dbf2668](https://github.com/ory/kratos/commit/dbf2668747922c93dd967961cd843354afbecfde))
* Replace viper with koanf config management ([5eb1bc0](https://github.com/ory/kratos/commit/5eb1bc0bff7c5d0f83c604484b8e845701112cad))
* Update RegisterFakes calls ([6268310](https://github.com/ory/kratos/commit/626831069ab4f971094ba0bc0b43ac9ff618d91d))
* Use underscore in webhook auth types ([26829d2](https://github.com/ory/kratos/commit/26829d21911cccd4a87c8693b6089af661c1bfe3))

### Documentation

* Add docker to docs main ([8ce8b78](https://github.com/ory/kratos/commit/8ce8b785e2246557253420ea97cf6b7d5ee75d58))
* Add docker to sidebar ([ed38c88](https://github.com/ory/kratos/commit/ed38c88bdbadcdcd2527a2b5270390251742bbe4))
* Add dotnet sdk ([#1183](https://github.com/ory/kratos/issues/1183)) ([32d874a](https://github.com/ory/kratos/commit/32d874a04bb384259aeb544a3fcd6b3a8b23acdd))
* Add faq sidebar ([#1105](https://github.com/ory/kratos/issues/1105)) ([10697aa](https://github.com/ory/kratos/commit/10697aa4ab5dc3e2ab90d1c037dfbe3492bf2bdf))
* Add log docs to schema config ([4967f11](https://github.com/ory/kratos/commit/4967f11d8df177ebdae855eb745e90d21ce38e9f))
* Add more HA docs ([cbb2e27](https://github.com/ory/kratos/commit/cbb2e27f8919a8991c4797a3f1c192ec364f0dd3))
* Add Rust and Dart SDKs ([6d96952](https://github.com/ory/kratos/commit/6d969528e13350ef099669510d3d37df1c007c82)):

    We now support for Rust and Dart SDKs!

* Add SameSite help ([2df6729](https://github.com/ory/kratos/commit/2df6729b4acc70532024658e8874682de64b06b3))
* Add shell-session language ([d16db87](https://github.com/ory/kratos/commit/d16db87802ae2f230a02e4deed189f473588552c))
* Add ui node docs ([e48a07d](https://github.com/ory/kratos/commit/e48a07d03c19a0677d3a56f9e57294b358f24501))
* Adding double colons ([#1187](https://github.com/ory/kratos/issues/1187)) ([fc712f4](https://github.com/ory/kratos/commit/fc712f4530066c429242491c19d1534ffb267b0c))
* Bcrypt is default and add 72 char warning ([29ae53a](https://github.com/ory/kratos/commit/29ae53a96b4472ff549b34241894d72d439c8ea1))
* Better import identities examples ([#997](https://github.com/ory/kratos/issues/997)) ([2e2880a](https://github.com/ory/kratos/commit/2e2880ac057b5c98cd69481c4f6f36b564b5871d))
* Change forum to discussions readme ([#1220](https://github.com/ory/kratos/issues/1220)) ([ae39956](https://github.com/ory/kratos/commit/ae399561ea6ed89aaadd4128bc564254984520e8))
* Describe more about Kratos login/browser flow on quickstart doc ([#1047](https://github.com/ory/kratos/issues/1047)) ([fe725ad](https://github.com/ory/kratos/commit/fe725ad12b5aed5faa8f95bec24ed3aa82512de8))
* Docker file links ([#1182](https://github.com/ory/kratos/issues/1182)) ([4d9b6a3](https://github.com/ory/kratos/commit/4d9b6a3fd5de81310016a811126e40a263ecd27c))
* Document hash timing attack mitigation ([ec86993](https://github.com/ory/kratos/commit/ec869930a9c0e6f6f56c2614835894e0a6a3eaab))
* Explain how to use `after_verification_return_to` ([7e1546b](https://github.com/ory/kratos/commit/7e1546be1fd20baca10507d642d4f209eb88dcbc))
* FAQ improvements ([#1135](https://github.com/ory/kratos/issues/1135)) ([44d0bc9](https://github.com/ory/kratos/commit/44d0bc968a7c0ba5c0793b2349820fa8133bada3))
* FAQ item & minor changes ([#1174](https://github.com/ory/kratos/issues/1174)) ([11cf630](https://github.com/ory/kratos/commit/11cf630082b56c80d12f5915f8e34aa03a7e8c54))
* Fix broken link ([#1037](https://github.com/ory/kratos/issues/1037)) ([6b9aae8](https://github.com/ory/kratos/commit/6b9aae8af5aa3bd614c99b32e341fbd533caf116))
* Fix failing build ([0de328f](https://github.com/ory/kratos/commit/0de328ff0053605e6bded589a79d3ab938d55b31))
* Fix formatting ([#966](https://github.com/ory/kratos/issues/966)) ([687251a](https://github.com/ory/kratos/commit/687251a24e796322b43f8aed6b1fb3d7900e3271))
* Fix identity state bullets ([#1095](https://github.com/ory/kratos/issues/1095)) ([f476334](https://github.com/ory/kratos/commit/f476334c4693277656ad88e768f66b59cbcba126))
* Fix known/unknown email account recovery ([#1211](https://github.com/ory/kratos/issues/1211)) ([e208ca5](https://github.com/ory/kratos/commit/e208ca50ba4f03d5410c9644aaa3b04bdf1b8dbd))
* Fix link ([7f6d7f5](https://github.com/ory/kratos/commit/7f6d7f501d7118dfe6868c9d923fb5ecc5eded48))
* Fix link ([#1128](https://github.com/ory/kratos/issues/1128)) ([e7043e9](https://github.com/ory/kratos/commit/e7043e9b99260eaff2b48ca6f457af46a1521654))
* Fix link to blogpost ([#949](https://github.com/ory/kratos/issues/949)) ([4622e32](https://github.com/ory/kratos/commit/4622e3228fb12231222c7e6b602458111f35f727)), closes [#945](https://github.com/ory/kratos/issues/945)
* Fix link to self-service flows overview ([#995](https://github.com/ory/kratos/issues/995)) ([2be8778](https://github.com/ory/kratos/commit/2be877847644a3df2645ac3be4bbd7704db30b17))
* Fix note block in third party login guide ([#920](https://github.com/ory/kratos/issues/920)) ([745cea0](https://github.com/ory/kratos/commit/745cea02d0e9940f689e668bbd814b29fd53bf37)):

    Allows the document to render properly

* Fix npm links ([#991](https://github.com/ory/kratos/issues/991)) ([4ce4468](https://github.com/ory/kratos/commit/4ce4468132dde21c1692e3a834ad7780bee12b90))
* Fix self-service code flows labels ([#1253](https://github.com/ory/kratos/issues/1253)) ([f2ed424](https://github.com/ory/kratos/commit/f2ed424289cdd2a0edc1736888dd15be6df65f11))
* Fix typo in README ([#1122](https://github.com/ory/kratos/issues/1122)) ([e500707](https://github.com/ory/kratos/commit/e5007078c3cd597cea669827b96c7e6f205f2f32))
* Link to argon2 blogpost and add cross-references ([#1038](https://github.com/ory/kratos/issues/1038)) ([9ab7c3d](https://github.com/ory/kratos/commit/9ab7c3df59ecd94a74a7bf18af9c0ded5305e042))
* Make explicit the ID of the default schema ([#1173](https://github.com/ory/kratos/issues/1173)) ([cc6e9ff](https://github.com/ory/kratos/commit/cc6e9ffbac7118436d85078720cde2de98a68044))
* Minor cosmetics ([#1050](https://github.com/ory/kratos/issues/1050)) ([34db06f](https://github.com/ory/kratos/commit/34db06fd4f83d415c09109b06dfd3b82ce03705e))
* Minor improvements ([#1052](https://github.com/ory/kratos/issues/1052)) ([f0672b5](https://github.com/ory/kratos/commit/f0672b5cb8cca41fa914db21798d20f00a5699f9))
* ORY -> Ory ([ea30979](https://github.com/ory/kratos/commit/ea309797bf59f3da5c5cd184e45f2e585144be56))
* **prometheus:** Update codedoc ([47146ea](https://github.com/ory/kratos/commit/47146ea8ce169ee908aa4d33b59a01e9df4bae10))
* Reformat settings code samples ([cdbbf4d](https://github.com/ory/kratos/commit/cdbbf4df5fa3fa667a78d5cf682bc7fa36693e9d))
* Remove unnecessary and wrong docker pull commands ([#1203](https://github.com/ory/kratos/issues/1203)) ([2b0342a](https://github.com/ory/kratos/commit/2b0342ad7607d705bcebfafd5a78e4e09e57a940))
* Resolve duplication error ([a3d8284](https://github.com/ory/kratos/commit/a3d8284ab20ae76bccba361601b7290af20bdde6))
* Update build from source ([9b5754f](https://github.com/ory/kratos/commit/9b5754f36661f6de9c95f30c06f28164fe5be48b)), closes [#979](https://github.com/ory/kratos/issues/979)
* Update email template docs ([1778cb9](https://github.com/ory/kratos/commit/1778cb9a293feb2c91c0b1921ab78a0395cdca98)), closes [#897](https://github.com/ory/kratos/issues/897)
* Update identity-data-model links ([b5fd9a3](https://github.com/ory/kratos/commit/b5fd9a3a0821215f94da168c9c6f87dceba8c8f4))
* Update identity.ID field documentation ([4624f03](https://github.com/ory/kratos/commit/4624f03a5e9249a5449992a1f0b7ec80dc3499fd)):

    See https://github.com/ory/kratos/discussions/956

* Update kratos video link ([#1073](https://github.com/ory/kratos/issues/1073)) ([e86178f](https://github.com/ory/kratos/commit/e86178f4ee66e5053e0da2fab2c21ecb2e730ada))
* Update login code samples ([695a30f](https://github.com/ory/kratos/commit/695a30f6c80f277676bf04b4665efeb7ea4db618))
* Update login code samples ([ce6c755](https://github.com/ory/kratos/commit/ce6c75587bea80ef83855d764fed79a9d6c948d3))
* Update quickstart samples ([c3fcaba](https://github.com/ory/kratos/commit/c3fcaba65899d9d46a08ca8b60ec0c010f70b16c))
* Update recovery code samples ([d9fbb62](https://github.com/ory/kratos/commit/d9fbb62faff5144f587136935f15d24b6399f29c))
* Update registration code samples ([317810f](https://github.com/ory/kratos/commit/317810ffd8ba6faf87f2248263b6c82cf4e9ffd8))
* Update self-service code samples ([6415011](https://github.com/ory/kratos/commit/6415011ab83a19972c6f52467055fbdcef23a0cc))
* Update settings code samples ([bbd6266](https://github.com/ory/kratos/commit/bbd6266c22097fae195654957cbab589d04892c7))
* Update verification code samples ([4285dec](https://github.com/ory/kratos/commit/4285dec59a8fc31fa3416b594c765f5da9a9de1c))
* Use correct extension for identity-data-model ([acab3e8](https://github.com/ory/kratos/commit/acab3e8b489d9865e4bf0805895f0b7ae9e6f1b8)), closes [/github.com/ory/kratos/pull/1197#issuecomment-819455322](https://github.com//github.com/ory/kratos/pull/1197/issues/issuecomment-819455322)

### Features

* Add email template specification in doc ([#898](https://github.com/ory/kratos/issues/898)) ([4230d9e](https://github.com/ory/kratos/commit/4230d9e0fc35c651b0d2cbdbbf9e1f1c514743f8))
* Add error for when no login strategy was found ([6bae66c](https://github.com/ory/kratos/commit/6bae66cde362c4e2995c9d06a0d3ffee403feb74))
* Add facebook provider to oidc providers and documentation ([#1035](https://github.com/ory/kratos/issues/1035)) ([905bb03](https://github.com/ory/kratos/commit/905bb032520189212bd88f29641903945ae03608)), closes [#1034](https://github.com/ory/kratos/issues/1034)
* Add FAQ to docs ([#1096](https://github.com/ory/kratos/issues/1096)) ([9c6b68c](https://github.com/ory/kratos/commit/9c6b68c454f472b26c34e1975b6a67b24b218f47))
* Add gh login to claims ([49deb2e](https://github.com/ory/kratos/commit/49deb2e166362a5d051bc08523ef44425f144bdd))
* Add login strategy text message ([7468c83](https://github.com/ory/kratos/commit/7468c835d4800c207035897fc9962860d8ab7803))
* Add more tests for multi domain args ([e99803b](https://github.com/ory/kratos/commit/e99803b62a847bcee52bcd87fa8088124b4deae2))
* Add Prometheus monitoring to Public APIs ([#1022](https://github.com/ory/kratos/issues/1022)) ([75a4f1a](https://github.com/ory/kratos/commit/75a4f1a5472ffd780fed43a7395a191ed495c6e9))
* Add random delay to login flow ([#1088](https://github.com/ory/kratos/issues/1088)) ([cb9894f](https://github.com/ory/kratos/commit/cb9894fefc694a4092215d3981e80f287021542f)), closes [#832](https://github.com/ory/kratos/issues/832)
* Add return_url to verification flow ([#1149](https://github.com/ory/kratos/issues/1149)) ([bb99912](https://github.com/ory/kratos/commit/bb99912d823e9bcffa41edf50a01dcae40117fe6)), closes [#1123](https://github.com/ory/kratos/issues/1123) [#1133](https://github.com/ory/kratos/issues/1133)
* Add sql migrations for new login flow ([e947edf](https://github.com/ory/kratos/commit/e947edf497b36bc576061c9ae38049e84ee48575))
* Add sql tracing ([3c4cc1c](https://github.com/ory/kratos/commit/3c4cc1cec170df14331288170a94ada770d3289f))
* Add tracing to config schema ([007dde4](https://github.com/ory/kratos/commit/007dde4482d11f22b8527c94b002da675152a872))
* Add transporter with host modification ([2c41b81](https://github.com/ory/kratos/commit/2c41b81be947f9972638d082105f0f5c83078b91))
* Add workaround template for go openapi ([5d72d10](https://github.com/ory/kratos/commit/5d72d10f6c6948c48c5701fe348084a668c8311a))
* Adds slack sogial login ([#974](https://github.com/ory/kratos/issues/974)) ([7c66053](https://github.com/ory/kratos/commit/7c66053390b3086fe7233625038a78431a61e507)), closes [#953](https://github.com/ory/kratos/issues/953)
* Allow session cookie name configuration ([77ce316](https://github.com/ory/kratos/commit/77ce3162ba97cf5c516c26ef499d9fa892162f0a)), closes [#268](https://github.com/ory/kratos/issues/268)
* Allow specifying sender name in smtp.from_address ([#1100](https://github.com/ory/kratos/issues/1100)) ([5904fe3](https://github.com/ory/kratos/commit/5904fe319f75f8138783434d568db6fc7c55b301))
* Bcrypt algorithm support ([#1169](https://github.com/ory/kratos/issues/1169)) ([b2612ee](https://github.com/ory/kratos/commit/b2612eefbad98d29482d364f670549f470d0a6f5)):

    This patch adds the ability to use BCrypt instead of Argon2id for password hashing. We recommend using BCrypt for web workloads where password hashing should take around 200ms. For workloads where login takes >= 2 seconds, we recommend to continue using Argon2id.
    
    To use bcrypt for password hashing, set your config as follows:
    
     ```
    hashers:
     bcrypt:
        cost: 12
      algorithm: bcrypt
     ```
    
    Switching the hashing algorithm will not break existing passwords!
    
    
    Co-authored-by: Patrik <zepatrik@users.noreply.github.com>

* Check migrations in health check ([c6ef7ad](https://github.com/ory/kratos/commit/c6ef7ad16b70310c645550f7e41b3c8aff847de3))
* Configure domain alias as query param ([9d8563e](https://github.com/ory/kratos/commit/9d8563eeb3293c42cce440ad74f025b304cccbbe))
* Contextualize configuration ([d3d5327](https://github.com/ory/kratos/commit/d3d5327a3622318265a063be4782caa25e645a05))
* Contextualize health checks ([8145a1c](https://github.com/ory/kratos/commit/8145a1c9acaeab441e787118d40ccd448ea82fe4))
* Contextualize http client in cli calls ([3b3ef8f](https://github.com/ory/kratos/commit/3b3ef8f025d75b244d9285036e66f79af7d5ee35))
* Contextualize persitence testers ([6440373](https://github.com/ory/kratos/commit/64403736ad9f8b264567e1f8eed1af710cab6046))
* Courier foreground worker with "kratos courier watch" ([#1062](https://github.com/ory/kratos/issues/1062)) ([500b8ba](https://github.com/ory/kratos/commit/500b8bacd9fd541afd053f42fec66443cfebabda)), closes [#1033](https://github.com/ory/kratos/issues/1033) [#1024](https://github.com/ory/kratos/issues/1024):

    BREACKING CHANGES: This patch moves the courier watcher (responsible for sending mail) to its own foreground worker, which can be executed as a, for example, Kubernetes job.
    
    It is still possible to have the previous behaviour which would run the worker as a background task when running `kratos serve` by using the `--watch-courier` flag.
    
    To run the foreground worker, use `kratos courier watch -c your/config.yaml`.

* **courier:** Allow sending individual messages ([cbb2c0b](https://github.com/ory/kratos/commit/cbb2c0bef63323a177589e9d2a809c84b4f1acdd))
* Do not enforce bcrypt 12 for dev envs ([bbf44d8](https://github.com/ory/kratos/commit/bbf44d887ae5cdb5975516149c74b3ba10896209))
* Email input validation ([#1287](https://github.com/ory/kratos/issues/1287)) ([cd56b73](https://github.com/ory/kratos/commit/cd56b73df363dd37485f07d31fef11fd4d9f40a6)), closes [#1285](https://github.com/ory/kratos/issues/1285)
* Export and add config options ([4391fe5](https://github.com/ory/kratos/commit/4391fe572eb6a766afe9808396847ca5fdca07f5))
* Expose courier worker ([f50969e](https://github.com/ory/kratos/commit/f50969ecba757dea558e9e8b9dd142f5f564d53a))
* Expose crdb ui ([504d518](https://github.com/ory/kratos/commit/504d5181f5e391bb8d67768b314a0348ed252c8b))
* Global docs sidebar ([#1258](https://github.com/ory/kratos/issues/1258)) ([7108262](https://github.com/ory/kratos/commit/71082624e093b8c100e71ae59050f89b35ac20a2))
* Implement and test domain aliasing ([1516a54](https://github.com/ory/kratos/commit/1516a54657df485627251de4e7019bc16353c956)):

    This patch adds a feature called domain aliasing. For more information, head over to http://ory.sh/docs/kratos/next/guides/multi-domain-cookies

* Improve oas spec and fix mobile tests ([4ead2c8](https://github.com/ory/kratos/commit/4ead2c826a2f1a307e327b9736dd8ac99ef52743))
* Improve sorting of ui fields ([797b49d](https://github.com/ory/kratos/commit/797b49d0175280f85f568014cf3083e9bc42d354)):

    See https://github.com/ory/kratos/discussions/1196

* Include schema ([348a493](https://github.com/ory/kratos/commit/348a493c9e5381830b76e57cad803a308e6ce53a))
* Make cli commands consumable in Ory Cloud ([#926](https://github.com/ory/kratos/issues/926)) ([fed790b](https://github.com/ory/kratos/commit/fed790b0f71f028f6d92e8ebceee188dbdb20770))
* Migrate to openapi v3 ([595224b](https://github.com/ory/kratos/commit/595224b1efd5a225702ef236a87f08180a7118b8))
* **oidc:** Support google hd claim ([#1097](https://github.com/ory/kratos/issues/1097)) ([1f20a5c](https://github.com/ory/kratos/commit/1f20a5ceba7682719112d24a3b18bf046fb2ac22))
* Populate email templates at delivery time, add plaintext defaults ([#1155](https://github.com/ory/kratos/issues/1155)) ([7749c7a](https://github.com/ory/kratos/commit/7749c7a75a4386c1fd53db57626355467b698c2f)), closes [#1065](https://github.com/ory/kratos/issues/1065)
* **schema:** Add totp errors ([a61f881](https://github.com/ory/kratos/commit/a61f8814101401dbb422967e37b6c6c1ae85d113))
* Sort and label nodes with easy to use defaults ([cbec27c](https://github.com/ory/kratos/commit/cbec27c957a733411e4c1d511ed5854855b7236e)):

    Ory Kratos takes a guess based on best practices for
    
    - ordering UI nodes (e.g. email, password, submit button)
    - grouping UI nodes (e.g. keep password and oidc nodes together)
    - labeling UI nodes (e.g. "Sign in with GitHub")
    - using the "title" attribute from the identity schema to label trait fields
    
    This greatly simplifies front-end code on your end and makes it even easier to integrate with Ory Kratos! If you want a custom experience with e.g. translations or other things you can always adjust this in your UI integration!

* Support base64 inline schemas ([815a248](https://github.com/ory/kratos/commit/815a24890a118f4128ac083241a93d8df27042f7))
* Support contextual csrf cookies ([957ef38](https://github.com/ory/kratos/commit/957ef38b69fc6ab071b91262736e6c191be3a4b8))
* Support domain aliasing in session cookie ([0681c12](https://github.com/ory/kratos/commit/0681c123f2d856ca27caee645dadc9e6e3731d2c))
* Support label in oidc config ([a99cdcd](https://github.com/ory/kratos/commit/a99cdcddaa0c4bd7b679884b232c2ef8f2dcd978))
* Support retryable CRDB transactions ([f0c21d7](https://github.com/ory/kratos/commit/f0c21d7e0a6ed85818d0e9025a451cb8cbdee086))
* Unix sockets support ([#1255](https://github.com/ory/kratos/issues/1255)) ([ad010de](https://github.com/ory/kratos/commit/ad010de240ddd9219f0cfb2ca3fbb180d2d3a697))
* Web hooks support (recovery) ([#1289](https://github.com/ory/kratos/issues/1289)) ([3e181fe](https://github.com/ory/kratos/commit/3e181fe3d7750a715ab31eb8347fbb4bdb89d6e6)), closes [#271](https://github.com/ory/kratos/issues/271):

    feat: web hooks for self-service flows
    
    This feature adds the ability to define web-hooks using a mixture of configuration and JsonNet. This allows integration with services like Mailchimp, Stripe, CRMs, and all other APIs that support REST requests. Additional to these new changes it is now possible to define hooks for verification and recovery as well!
    
    For more information, head over to the [hooks documentation](https://www.ory.sh/kratos/docs/self-service/hooks).


### Tests

* Add case to ensure correct behavior when verifying a different email address ([#999](https://github.com/ory/kratos/issues/999)) ([f95a117](https://github.com/ory/kratos/commit/f95a117677c9c59436ad10aa8951fe875c39a64f)), closes [#998](https://github.com/ory/kratos/issues/998)
* Add oasis test case ([f80691b](https://github.com/ory/kratos/commit/f80691b9dd77566857c4284e2639cc94d5b8c333))
* Bump poll interval ([b3dc925](https://github.com/ory/kratos/commit/b3dc925a5d43557293745ee81c0ffb3db37b6342))
* Bump video quality ([b7f8d04](https://github.com/ory/kratos/commit/b7f8d042646037e1589ae2d03602bd63a5cec2fe))
* Bump wait times ([b2e43f8](https://github.com/ory/kratos/commit/b2e43f8b0b64784f60e5f57d9a0f5d2928c2b891))
* Clean up hydra env before restart ([cf49414](https://github.com/ory/kratos/commit/cf494149e6a46b15e3b174185e1e87cfcd6f9f7a))
* **e2e:** Significantly reduce wait and idle times ([f525fc5](https://github.com/ory/kratos/commit/f525fc53afec6f5232ce507fe25ddec1b9069196))
* Longer wait times ([4bec9ef](https://github.com/ory/kratos/commit/4bec9ef50f14f22342a311f09ba1b59cde47befc))
* Reliable migration tests on crdb ([2e3764b](https://github.com/ory/kratos/commit/2e3764ba66c156d810de66fba2b0e142dced6f4d))
* Remove old noop test ([16dca3f](https://github.com/ory/kratos/commit/16dca3f78b2021c09ec83e81ab6d2e68c42ca081))
* Resolve compile issues ([c1b5ba4](https://github.com/ory/kratos/commit/c1b5ba42171ec522579df9dfaff27b5b74a1566a))
* Resolve flaky tests ([cb670a8](https://github.com/ory/kratos/commit/cb670a854cbb09b8437bfed7e4a6908ff6dcfd27))
* Resolve json parser test regression ([a1b9b9a](https://github.com/ory/kratos/commit/a1b9b9a95d58583dc7ecf6d2a501da52f84dd6bb))
* Resolve login integration regressions ([388b5b2](https://github.com/ory/kratos/commit/388b5b27d6dee7770e5f37d6d83c532044a4e984))
* Resolve migration regression ([2051a71](https://github.com/ory/kratos/commit/2051a716cb4b8cf334dd65f2ccddb31e5fbed545))
* Resolve more json parser test regressions ([ff791c4](https://github.com/ory/kratos/commit/ff791c41a1d9ce25af4e883469d3f8c0ef9eb302))
* Resolve more regressions ([c5a23af](https://github.com/ory/kratos/commit/c5a23af81427480088651833d904e3403a969fab))
* Resolve order regression ([40a849c](https://github.com/ory/kratos/commit/40a849ca35f4700185322e9ac4f6a4b70132851c))
* Resolve regression ([e2b0ad3](https://github.com/ory/kratos/commit/e2b0ad3c1845da80f078b11b327b9a0376cbb7c5))
* Resolve regression ([f0c9e5f](https://github.com/ory/kratos/commit/f0c9e5ff105d76d6bc9478c98522b2440c7181df))
* Resolve regressions ([4b9da3c](https://github.com/ory/kratos/commit/4b9da3c9d98d40f7b71a56c51543fc115974630d))
* Resolve stub regressions ([82650cf](https://github.com/ory/kratos/commit/82650cf1843f6bfde015f556f4452a7b6fd52b11))
* Resolve test migrations ([de0b65d](https://github.com/ory/kratos/commit/de0b65d96daef0e31c12b3b6915f283a8e71244b))
* Resolve test regression issues ([ccf9fed](https://github.com/ory/kratos/commit/ccf9feddade11f9fcaaf1c37dd3efeb2c4df6649))
* Speed up tests ([a16737c](https://github.com/ory/kratos/commit/a16737cccc36a14444711660f1737913ffd7ba01))
* Update schema tests for webhooks ([d1ddfa8](https://github.com/ory/kratos/commit/d1ddfa80742728b28dc5710ca5b6e7282a2dec55))
* Update test description ([55fb37f](https://github.com/ory/kratos/commit/55fb37f62fc3ab7c0d5324ed31ef3e7f66a73aa2))
* Use bcrypt cost 4 to reduce CI times ([cabe97d](https://github.com/ory/kratos/commit/cabe97d0656858fd1ee0442b40881417e91294f3))
* Use fast bcrypt for e2e ([d90cf13](https://github.com/ory/kratos/commit/d90cf13230632e76eb74965c0945573b4f2e98ff))

### Unclassified

*  fix: resolve clidoc issues (#976) ([346bc73](https://github.com/ory/kratos/commit/346bc73921655d52861b8803eb3351c4205657ee)), closes [#976](https://github.com/ory/kratos/issues/976) [#951](https://github.com/ory/kratos/issues/951)
* :bug: fix ory home directory path (#897) ([2fca2be](https://github.com/ory/kratos/commit/2fca2bedaa907691bef324c11545e007b51d4881)), closes [#897](https://github.com/ory/kratos/issues/897)
* Fix typo in config schema ([16337f1](https://github.com/ory/kratos/commit/16337f13e4388a715c8109c29cf198c82a848a16))
* Format ([e4b7e79](https://github.com/ory/kratos/commit/e4b7e79f4ee91dadfcd008a5b3e318b6bfedad10))
* Format ([193d266](https://github.com/ory/kratos/commit/193d2668ae0955a1346390057539a8b796d17afd))
* Format ([1ebfbde](https://github.com/ory/kratos/commit/1ebfbdea75f27c8eeafa7d3aff45de133ea340bb))
* Format ([ba1eeef](https://github.com/ory/kratos/commit/ba1eeef4f232c4ab59343a2ca3c7cf0eb6dfd110))
* Format ([ada5dbb](https://github.com/ory/kratos/commit/ada5dbb58c45502b8275850a3bc0876debc66888))
* Format ([17a0bf5](https://github.com/ory/kratos/commit/17a0bf5872b33eac615afc675c7d92d7c7441b2e))
* Initial documentation tests via Text-Runner ([#567](https://github.com/ory/kratos/issues/567)) ([c30eb26](https://github.com/ory/kratos/commit/c30eb26f76ab70a6098c0b40c9a04726d36d72f2))


# [0.5.5-alpha.1](https://github.com/ory/kratos/compare/v0.5.4-alpha.1...v0.5.5-alpha.1) (2020-12-09)

The ORY Community is proud to present you the next iteration of ORY Kratos. In this release, we focused on improving production stability!





### Bug Fixes

* CSRF token is required when using the Revoke Session API endpoint ([#839](https://github.com/ory/kratos/issues/839)) ([d3218a0](https://github.com/ory/kratos/commit/d3218a0f23de7293b0a4a966ad21369a92b68b1a)), closes [#838](https://github.com/ory/kratos/issues/838)
* Incorrect home path ([#848](https://github.com/ory/kratos/issues/848)) ([5265af0](https://github.com/ory/kratos/commit/5265af00c92fe505819300caddfcc64004d45c65))
* Make password policy configurable ([#888](https://github.com/ory/kratos/issues/888)) ([7a00483](https://github.com/ory/kratos/commit/7a00483908bb623efdf281e76005c4485ea6b1ab)), closes [#450](https://github.com/ory/kratos/issues/450) [#316](https://github.com/ory/kratos/issues/316):

    Allows configuring password breach thresholds and optionally enforces checks against the HIBP API.

* Remove obsolete types ([#887](https://github.com/ory/kratos/issues/887)) ([b8bac7a](https://github.com/ory/kratos/commit/b8bac7aa56c16cd98f76a95a5e0d01fb1bbde6b7)), closes [#716](https://github.com/ory/kratos/issues/716)
* Set samesite attribute to lax if in dev mode ([#824](https://github.com/ory/kratos/issues/824)) ([91d6698](https://github.com/ory/kratos/commit/91d6698e4ce05ee59bb72fc84b54af9d1d204b41)), closes [#821](https://github.com/ory/kratos/issues/821)
* Use working cache-control header for cdn/proxies/cache ([#869](https://github.com/ory/kratos/issues/869)) ([d8e3d40](https://github.com/ory/kratos/commit/d8e3d40001ffdc64da2288f3cffd53cf3bfdf781)), closes [#601](https://github.com/ory/kratos/issues/601)

### Code Generation

* Pin v0.5.5-alpha.1 release commit ([83aedcb](https://github.com/ory/kratos/commit/83aedcb885acb96c5deb39fff675d5f0528af32d))

### Documentation

* Add contributing to sidebar ([#866](https://github.com/ory/kratos/issues/866)) ([44f33f9](https://github.com/ory/kratos/commit/44f33f97d43f2a3c553a65ebb2986e0731c0e5f2)):

    The same change as in https://github.com/ory/hydra/pull/2209

* Add newsletter to config ([1735ca2](https://github.com/ory/kratos/commit/1735ca2ced104971de4e97524d0a23d57ba045f2))
* Add recovery flow  ([#868](https://github.com/ory/kratos/issues/868)) ([d95cfe9](https://github.com/ory/kratos/commit/d95cfe9759d3ffc08c24048a064c0c800abdf4b4)), closes [#864](https://github.com/ory/kratos/issues/864):

    Added a short section for the recovery flow on managing-user-identities.

* Fix account recovery click instruction ([#870](https://github.com/ory/kratos/issues/870)) ([383de9e](https://github.com/ory/kratos/commit/383de9ecf6f6504dbb9c20fb4cb984e934f0751e))
* Fix broken link ([#893](https://github.com/ory/kratos/issues/893)) ([dec38a2](https://github.com/ory/kratos/commit/dec38a28964aaa13827d356e5bfa12c2a6d1400e)), closes [#835](https://github.com/ory/kratos/issues/835)
* Fix oidc config example structure ([#845](https://github.com/ory/kratos/issues/845)) ([c102a68](https://github.com/ory/kratos/commit/c102a6844db29f994b67d23bb04e64ee71376264))
* Fix redirect ([#802](https://github.com/ory/kratos/issues/802)) ([b868782](https://github.com/ory/kratos/commit/b86878229f343e6b11521596b04040f892d1e2c3))
* Fix typo ([#847](https://github.com/ory/kratos/issues/847)) ([9b3da9f](https://github.com/ory/kratos/commit/9b3da9f0fe2ce71743115844d8c91a1dc9c4cbae))
* Fix typo ([#881](https://github.com/ory/kratos/issues/881)) ([3078293](https://github.com/ory/kratos/commit/3078293717a2ce21c4b939de4c2c4886c75303b5))
* Fix typo MKFA to MFA ([#826](https://github.com/ory/kratos/issues/826)) ([a5613d0](https://github.com/ory/kratos/commit/a5613d08aa21f90f4d192e5663ba4977b3de16c3))
* Remove workaround note ([#886](https://github.com/ory/kratos/issues/886)) ([05409bc](https://github.com/ory/kratos/commit/05409bc13f527398e3de01f29437e5d4353ef8d4)), closes [#718](https://github.com/ory/kratos/issues/718)
* Swagger specs for selfservice settings browser flow ([#825](https://github.com/ory/kratos/issues/825)) ([28d50f4](https://github.com/ory/kratos/commit/28d50f45ab14d561609be7047cac13902394b547))
* Update oidc provider with json conf support ([#833](https://github.com/ory/kratos/issues/833)) ([670eb37](https://github.com/ory/kratos/commit/670eb37d19674f33a36402cd9a88d61ca7327751))

### Features

* Add return_to parameter to logout flow ([#823](https://github.com/ory/kratos/issues/823)) ([1c146dd](https://github.com/ory/kratos/commit/1c146dd21d616a56f510019abadd37402782bb39)), closes [#702](https://github.com/ory/kratos/issues/702)
* Add selinux compatible quickstart config ([#889](https://github.com/ory/kratos/issues/889)) ([0f87948](https://github.com/ory/kratos/commit/0f879481df209ed96b778799adcc2a9424449b37)), closes [#831](https://github.com/ory/kratos/issues/831)

### Tests

* Ensure registration runs only once ([#872](https://github.com/ory/kratos/issues/872)) ([5ffc036](https://github.com/ory/kratos/commit/5ffc036ac82f36ad6ef499e217971275a35fc23a))

### Unclassified

* docs: fix link and typo in Configuring Cookies (#883) ([c51ed6b](https://github.com/ory/kratos/commit/c51ed6b789d2e3a8fe4e93565c3bded37d298f98)), closes [#883](https://github.com/ory/kratos/issues/883)


# [0.5.4-alpha.1](https://github.com/ory/kratos/compare/v0.5.3-alpha.1...v0.5.4-alpha.1) (2020-11-11)

This release introduces the new CLI command `kratos hashers argon2 calibrate 500ms`. This command will choose the best parameterization for Argon2. Check out the [Choose Argon2 Parameters for Secure Password Hashing and Login](https://www.ory.sh/choose-recommended-argon2-parameters-password-hashing/) blog article for more insights!





### Bug Fixes

* Case in settings handler method ([#798](https://github.com/ory/kratos/issues/798)) ([83eb4e0](https://github.com/ory/kratos/commit/83eb4e0021621014d2b543e57a01401381f07fe4))
* Force brew install statement ([#796](https://github.com/ory/kratos/issues/796)) ([ad542ad](https://github.com/ory/kratos/commit/ad542ad5919205ac26a757145474e5a46f3937ec)):

    Closes https://github.com/ory/homebrew-kratos/issues/1


### Code Generation

* Pin v0.5.4-alpha.1 release commit ([b02926c](https://github.com/ory/kratos/commit/b02926c42aee2748bc37ce2600596bd0c2537a0d))

### Code Refactoring

* Move pkger and ioutil helpers to ory/x ([60a0fc4](https://github.com/ory/kratos/commit/60a0fc449d90ead6065ca00926536a989d8b2a2b))

### Documentation

* Fix another broken link ([15bae9f](https://github.com/ory/kratos/commit/15bae9f893c2e2910167326d987455246c110001))
* Fix broken links ([#795](https://github.com/ory/kratos/issues/795)) ([0ab0e7e](https://github.com/ory/kratos/commit/0ab0e7eca8e95d6c26d028c177cbbd1f06b68871)), closes [#793](https://github.com/ory/kratos/issues/793)
* Fix broken relative link ([#812](https://github.com/ory/kratos/issues/812)) ([b32b173](https://github.com/ory/kratos/commit/b32b173fe30b7c5c43700abfa4ddb3409a33556b))
* Fix links ([#800](https://github.com/ory/kratos/issues/800)) ([5fcc272](https://github.com/ory/kratos/commit/5fcc272e625de9e583b2ec24d5679895a6d24c1b))
* Fix oidc config examples ([#799](https://github.com/ory/kratos/issues/799)) ([8a4f480](https://github.com/ory/kratos/commit/8a4f480121995d9899668f037382086fcdd2da4c))
* Fix self-service recovery flow typo ([#807](https://github.com/ory/kratos/issues/807)) ([800110d](https://github.com/ory/kratos/commit/800110d87c9df70a5ec79b58d9fcb9ae39ff76b9))
* Remove duplicate words & fix spelling ([#810](https://github.com/ory/kratos/issues/810)) ([4e1b966](https://github.com/ory/kratos/commit/4e1b96667d9f08dbafeb2f5ce144ca43309de8e0))
* Remove leftover category from reference sidebar ([#813](https://github.com/ory/kratos/issues/813)) ([94fde51](https://github.com/ory/kratos/commit/94fde5101d00b9e1f7228e9d122ef0a8e4719355))
* Use correct links ([#797](https://github.com/ory/kratos/issues/797)) ([a4de293](https://github.com/ory/kratos/commit/a4de29399e4f1b5d0a33acc85478f2d38579a174))

### Features

* Add helper for choosing argon2 parameters ([#803](https://github.com/ory/kratos/issues/803)) ([ca5a69b](https://github.com/ory/kratos/commit/ca5a69b798635d0e5361fd5b0cc369b035dca738)), closes [#723](https://github.com/ory/kratos/issues/723) [#572](https://github.com/ory/kratos/issues/572) [#647](https://github.com/ory/kratos/issues/647):

    This patch adds the new command "hashers argon2 calibrate" which allows one to pick the desired hashing time for password hashing and then chooses the optimal parameters for the hardware the command is running on:
    
    ```
    $ kratos hashers argon2 calibrate 500ms
    Increasing memory to get over 500ms:
        took 2.846592732s in try 0
        took 6.006488824s in try 1
      took 4.42657975s with 4.00GB of memory
    [...]
    Decreasing iterations to get under 500ms:
        took 484.257775ms in try 0
        took 488.784192ms in try 1
      took 486.534204ms with 3 iterations
    Settled on 3 iterations.
    
    {
      "memory": 1048576,
      "iterations": 3,
      "parallelism": 32,
      "salt_length": 16,
      "key_length": 32
    }
    ```



# [0.5.3-alpha.1](https://github.com/ory/kratos/compare/v0.5.2-alpha.1...v0.5.3-alpha.1) (2020-10-27)

This release improves the developer and user experience around CSRF counter-measures. It should now be possible to use the self-service API flows without having to explicitly disable cookie features in your SDKs and integrations. Additionally, another issue in the CGO pipeline was resolved which finally allows running ORY Kratos without CGO if the target database is not SQLite.

Further improvements to default config values have been made and a full end-to-end test suite for the exemplary [kratos-selfservice-ui-react-native](kratos-selfservice-ui-react-native) app. The app is now available in the iTunes store as well - just search for "ORY Profile App"!





### Bug Fixes

* Add "x-session-token" to default allowed headers ([3c912e4](https://github.com/ory/kratos/commit/3c912e4c7d46fd45c00cabb68ed7770bd44f7d07))
* Do not set cookies on api endpoints ([2f67c28](https://github.com/ory/kratos/commit/2f67c28718856ea03ea2effa89b28a8c4b3b8ae0))
* Do not set csrf cookies on potential api endpoints ([4d97a95](https://github.com/ory/kratos/commit/4d97a95d084ea99f5aca158609e197acd256cdd7))
* Ignore unsupported migration dialects ([12bb8d1](https://github.com/ory/kratos/commit/12bb8d14ae1edef18591996411be67d5693e5101)), closes [#778](https://github.com/ory/kratos/issues/778):

    Skips sqlite3 migrations when support is lacking.

* Improve semver regex ([584c0b5](https://github.com/ory/kratos/commit/584c0b5043e85e88ac2648cf699d60fed3e775a9))
* Properly set nosurf context even when ignored ([0dcb774](https://github.com/ory/kratos/commit/0dcb774157bcbfd41a5d9df3914c31162226da75))
* Update cypress ([ba8b172](https://github.com/ory/kratos/commit/ba8b1729477233f79d099e5d7b397430ac1c6ace))
* Use correct regex for version replacement ([ce870ab](https://github.com/ory/kratos/commit/ce870ababdf089344a9428d3a405e18504a3c906)), closes [#787](https://github.com/ory/kratos/issues/787)

### Code Generation

* Pin v0.5.3-alpha.1 release commit ([64dc91a](https://github.com/ory/kratos/commit/64dc91af54cdf3eba158a50690240cdc8f7cb43b))

### Documentation

* Fix docosaurus admonitions ([#788](https://github.com/ory/kratos/issues/788)) ([281a7c9](https://github.com/ory/kratos/commit/281a7c9289570d4bee33447655281b610cbe7e52))
* Pin download script version ([e4137a6](https://github.com/ory/kratos/commit/e4137a6a41d68b1480af2075bda8c5f46c42cd22))
* Remove trailing garbage from quickstart ([#787](https://github.com/ory/kratos/issues/787)) ([7e70924](https://github.com/ory/kratos/commit/7e709242ada28b7781c6ace272f60f9d1b9d5b2f))

### Features

* Improve makefile install process and update deps ([d1eb37f](https://github.com/ory/kratos/commit/d1eb37f5d9d0f16e7864b5f8f08a44ba80853fa5))

### Tests

* Add e2e tests for mobile ([d481d51](https://github.com/ory/kratos/commit/d481d51f5f4de96cbbc7c347f5dbff381b44462d))
* Add option to disable csrf protection in apis ([a0077f1](https://github.com/ory/kratos/commit/a0077f12adf94ff428b502b69bbb0eaafd05be66))
* Bump wait time ([7a719e1](https://github.com/ory/kratos/commit/7a719e17c5641f4df47314f6f0ac2cf73dddc8bb))
* Install expo-cli globally ([db21cfa](https://github.com/ory/kratos/commit/db21cfa1c589a2dab829a4c8eaf1db15d14d965e))
* Install expo-cli in cci config with sudo ([d255f46](https://github.com/ory/kratos/commit/d255f462402f2d2c2278dcba1a139d0064343b22))
* Log wait-on output ([62b5ba9](https://github.com/ory/kratos/commit/62b5ba92d56e9f6b98adb8fb9c4daff03be08f2e))
* Output web server address ([cb41ca7](https://github.com/ory/kratos/commit/cb41ca78367b1943d230fa9ac116fcf3cf69b1c1))
* Resolve csrf test issues in settings ([ef8ba7d](https://github.com/ory/kratos/commit/ef8ba7dc93d6ba84f22b7aa65d00797e33b520a3))
* Resolve test panic ([6f6461f](https://github.com/ory/kratos/commit/6f6461fe3690576015ded9146c065a1e5d950be1))
* Revert delay increase and improve install scripts ([1eafcaa](https://github.com/ory/kratos/commit/1eafcaa86be194e412b0470a759bff6afc6c21af))


# [0.5.2-alpha.1](https://github.com/ory/kratos/compare/v0.5.1-alpha.1...v0.5.2-alpha.1) (2020-10-22)

This release addresses bugs and user experience issues.





### Bug Fixes

* Add debug quickstart yml ([#780](https://github.com/ory/kratos/issues/780)) ([16e6b4d](https://github.com/ory/kratos/commit/16e6b4d76d297182ea9a1f5dc6367570f02f7b42))
* Gracefully handle double slashes in URLs ([aeb9414](https://github.com/ory/kratos/commit/aeb941477910b5ab54429a6aab7a3e1e388c48c5)), closes [#779](https://github.com/ory/kratos/issues/779)
* Merge gobuffalo CGO fix ([fea2e77](https://github.com/ory/kratos/commit/fea2e77ca0f9b20185c7a7704854fdcf29b7ab33))
* Remove obsolete recovery_token and add link to schema ([acf6ac4](https://github.com/ory/kratos/commit/acf6ac4e11c755e56c7d40728088257de367f7ff))
* Return correct error in login csrf ([dd9cab0](https://github.com/ory/kratos/commit/dd9cab0e02400c88e89877f755f03c6179013123)), closes [#785](https://github.com/ory/kratos/issues/785)
* Use correct assert package ([76be5b0](https://github.com/ory/kratos/commit/76be5b0a5d94c251f5f07eee9f700ec11b341e2e))

### Code Generation

* Pin v0.5.2-alpha.1 release commit ([79fcd8a](https://github.com/ory/kratos/commit/79fcd8a6949886f847f7be0c9ba2aba7554ab204))

### Documentation

* Small improvements to discord oidc provider guide ([#783](https://github.com/ory/kratos/issues/783)) ([6a3c453](https://github.com/ory/kratos/commit/6a3c45330885eb95015fa7ee9b58a72c38132499))

### Tests

* Add tests for csrf behavior ([48993e2](https://github.com/ory/kratos/commit/48993e2c496fb8af7e7b9e2752ba7078a134a75a)), closes [#785](https://github.com/ory/kratos/issues/785)
* Mark link as enabled in e2e test ([c214b81](https://github.com/ory/kratos/commit/c214b81a7026b06aaca062b2aa77951d01b0e237))
* Resolve schema test regression ([bb7af1b](https://github.com/ory/kratos/commit/bb7af1b759d6c812755956ef872bcbd31b9c50be))


# [0.5.1-alpha.1](https://github.com/ory/kratos/compare/v0.5.0-alpha.1...v0.5.1-alpha.1) (2020-10-20)

This release resolves an issue where ORY Kratos Docker Images without CGO and SQLite support would fail to boot even when SQLite was not used as a data source.





### Bug Fixes

* Do not require sqlite without build tag ([2ee787b](https://github.com/ory/kratos/commit/2ee787bc1e97bdc11d0c92d55664d59e777f7ed1))
* Use extra dc config file for quickstart-dev ([72c03f9](https://github.com/ory/kratos/commit/72c03f9bcb91d30d5ff6b94030f2cbb6144fbf8d))

### Code Generation

* Pin v0.5.1-alpha.1 release commit ([b85b36b](https://github.com/ory/kratos/commit/b85b36b967d91c13b6d70ed668f17d3474eafae7))

### Documentation

* Fix spelling mistake ([14e7f65](https://github.com/ory/kratos/commit/14e7f6535e69f4bee2e3ca611a8d1a36bfd5f8f8))
* Fix spelling mistake ([#772](https://github.com/ory/kratos/issues/772)) ([bf401a2](https://github.com/ory/kratos/commit/bf401a26ee4422a8ea1b52f642885b0d8bac1272))
* Improve schemas ([#773](https://github.com/ory/kratos/issues/773)) ([e614859](https://github.com/ory/kratos/commit/e6148590577e1688d58534b8559d3bc602f9c2e7))

### Features

* Auto-update docker and git tags on release ([08084a9](https://github.com/ory/kratos/commit/08084a987501939544da1a1c7ee102819e2480ce))
* Use fixed versions for docker-compose ([e73c4ce](https://github.com/ory/kratos/commit/e73c4ce6f328376ad310b8f6d5c391ea06573003))

### Tests

* Increase waittime ([5e911d6](https://github.com/ory/kratos/commit/5e911d687247e4878bdcf82e5b008617f0bbdf4e))
* Reduce flakes by increasing wait time for expiry test ([cddf29e](https://github.com/ory/kratos/commit/cddf29e7dc5304c497d5ba7c1e6a2d63c9b6c137))

### Unclassified

* Format ([8be02c8](https://github.com/ory/kratos/commit/8be02c8938769dfcd7c9b7ed5e72e4ded3b1924b))


# [0.5.0-alpha.1](https://github.com/ory/kratos/compare/v0.4.6-alpha.1...v0.5.0-alpha.1) (2020-10-15)

The ORY team and community is very proud to present the next ORY Kratos iteration!

ORY Kratos is now capable of handling native (iOS, Android, Windows, macOS, ...) login, registration, settings, recovery, and verification flows. As a goodie on top, we released a reference React Native application which you can find on [GitHub](http://github.com/ory/kratos-selfservice-ui-react-native).

We co-released our reference React Native application which acts as a reference on implementing these flows:

![Registration](http://ory.sh/images/newsletter/kratos-0.5.0/registration-screen.png)

![Welcome](http://ory.sh/images/newsletter/kratos-0.5.0/welcome-screen.png)

![Settings](http://ory.sh/images/newsletter/kratos-0.5.0/settings-screen.png)

In total, almost 1200 files were changed in about 480 commits. While you can find a list of all changes in the changelist below, these are the changes we are most proud of:

- We renamed login, registration, ... requests to "flows" consistently across the code base, APIs, and data storage. We now:
  - Initiate a login, registration, ... flow;
  - Fetch a login, registration, ... flow; and
  - Complete a login, registration, ... flow using a login flow method such as "Log in with username and password".
- All self-service flows are now capable of handling API-based requests that do not originate from Browser such as Chrome. This is set groundwork for handling native flows (see above)!
- The self service documentation has been refactored and simplified. We added code samples, screenshots, payloads, and curl commands to make things easier and clearer to understand. Video guides have also been added to help you and the community get things done faster!
- Documentation for rotating important secrets such as the cookie and session secrets was added.
- The need for reverse proxies was removed by adding the ability to change the ORY Kratos Session Cookie domain and path! The [kratos-selfservice-ui-node](https://github.com/ory/kratos-selfservice-ui-node) reference implementation no longer requires HTTP Request piping which greatly simplifies the network layout and codebase!
- The ORY Kratos CLI is now capable of managing identities with an interface that works almost like the Docker CLI we all love!
- Admins are now able to initiate account recovery for identities.
- Email verification and account recovery were refactored. It is now possible to add additional strategies (e.g. recovery codes) in the future, greatly increasing the feature set and security capabilities of future ORY Kratos versions!
- Lookup to Have I Been Pwnd is no longer a hard requirement, allowing registration processes to complete when the service is unavailable or the network is slow.
- We contributed several issues and features in upstream projects such as justinas/nosurf, gobuffalo/pop, and many more!
- The build pipeline has been upgraded to support cross-compilation of CGO with Go 1.15+.
- Fetching flows no longer requires CSRF cookies to be set, improving developer experience while not compromising on security!
- ORY Kratos now has ORY Kratos Session Cookies (set in the HTTP Cookie header) and ORY Kratos Session Tokens (set as a HTTP Bearer Authorization token or the `X-Session-Token` HTTP Header).

Additionally tons of bugs were fixed, tests added, documentation improved, and much more. Please note that several things have changed in a breaking fashion. You can find details for the individual breaking changes in the changelog below.

We would like to thank all community members who contributed towards this release (in no particular order):

- https://github.com/kevgo
- https://github.com/NickUfer
- https://github.com/drwatsno
- https://github.com/alsuren
- https://github.com/wezzle
- https://github.com/sherbang
- https://github.com/perryao
- https://github.com/jikunchong
- https://github.com/err0r500
- https://github.com/debrutal
- https://github.com/c0depwn
- https://github.com/aschepis
- https://github.com/jakhog

Have fun exploring the new release, we hope you like it! If you haven't already, join the [ORY Community Slack](http://slack.ory.sh) where we hold weekly community hangouts via video chat and answer your questions, exchange ideas, and present new developments!



## Breaking Changes

The "common" keyword has been removed from the Swagger 2.0 spec which deprecates the `common` module / package / class (depending on the generated SDK). Please use `public` or `admin` instead!

Additionally, the SDK for TypeScript now uses the `fetch` API which allows the SDK to be used in both client-side as well as server-side contexts. Please note that several methods and parameters in the generated TypeScript SDK have changed. Please check the TypeScript results to see what needs to be changed!

This patch changes the OpenID Connect and OAuth2 ("Sign in with Google, Facebook, ...") Callback URL from `http(s)://<kratos-public>/self-service/browser/flows/strategies/oidc/<provider>` to `http(s)://<kratos-public>/self-service/methods/oidc/<provider>`. To apply this patch, you need to update these URLs at the OAuth2 Client configuration pages of the individual OpenID Conenct providers (e.g. GitHub, Google).

Configuration key `selfservice.strategies` was renamed to `selfservice.methods`.

This patch significantly changes how email verification works. The Verification Flow no longer uses its own system but now re-uses the API and Browser flows and flow methods established in other components such as login, recovery, registration.

Due to the many changes these patch notes does not cover how to upgrade this particular flow. We instead want to kindly ask you to check out the updated documentation for this flow at: https://www.ory.sh/kratos/docs/self-service/flows/verify-email-account-activation

This patch changes the SQL schema and thus requires running the SQL Migration command (e.g. `... migrate sql`).
Never apply SQL migrations without backing up your database prior.

Configuration items `selfservice.flows.<name>.request_lifespan` have been renamed to `selfservice.flows.<name>.lifespan` to match the new flow semantics.

Wording has changed from "Self-Service Recovery Request" to "Self-Service Recovery Flow" to follow community feedback and practice already applied in the documentation. Additionally, fetching a recovery flow over the public API no longer requires Anti-CSRF cookies to be sent.

This patch renames several important recovery flow endpoints:

- `/self-service/browser/flows/recovery` is now `/self-service/recovery/browser` without functional changes.
- `/self-service/browser/flows/requests/recovery?request=abcd` is now `/self-service/recovery/flows?id=abcd` and no longer needs anti-CSRF cookies to be available.

Additionally, the URL for completing the password and oidc recovery method has been moved. Given that this endpoint is typically not manually called, you can probably ignore this change:

- `/self-service/browser/flows/recovery/link?request=abcd` is now `/self-service/recovery/methods/link?flow=abcd` without functional changes.

The Recovery UI Endpoint no longer receives a `?request=abcde` query parameter but instead a `?flow=abcde` query parameter. Functionality did not change however.

As part of this change SDK methods have been renamed:

```
  const kratos = new CommonApi(config.kratos.public)
  // ...
- kratos.completeSelfServiceBrowserRecoveryLinkStrategyFlow(req.query.request)
+ kratos.completeSelfServiceRecoveryFlowWithLinkMethod(req.query.flow)
```

This patch requires you to run SQL migrations.

Wording has changed from "Self-Service Settings Request" to "Self-Service Settings Flow" to follow community feedback and practice already applied in the documentation.

This patch renames several important settings flow endpoints:

- `/self-service/browser/flows/settings` is now `/self-service/settings/browser` without functional changes.
- `/self-service/browser/flows/requests/settings?request=abcd` is now `/self-service/settings/flows?id=abcd` and no longer needs anti-CSRF cookies to be available.

Additionally, the URL for completing the password, profile, and oidc settings method has been moved. Given that this endpoint is typically not manually called, you can probably ignore this change:

- `/self-service/browser/flows/login/strategies/password?request=abcd` is now `/self-service/login/methods/password?flow=abcd` without functional changes.
- `/self-service/browser/flows/strategies/oidc?request=abcd` is now `/self-service/methods/oidc?flow=abcd` without functional changes.
- `/self-service/browser/flows/settings/strategies/profile?request=abcd` is now `/self-service/settings/methods/profile?flow=abcd` without functional changes.

The Settings UI Endpoint no longer receives a `?request=abcde` query parameter but instead a `?flow=abcde` query parameter. Functionality did not change however.

As part of this change SDK methods have been renamed:

```
  const kratos = new CommonApi(config.kratos.public)
  // ...
- kratos.getSelfServiceBrowserSettingsRequest(req.query.request)
+ kratos.getSelfServiceSettingsFlow(req.query.flow)

  // You will most likely not be using this:
  const kratos = new PublicApi(config.kratos.public)
- kratos.completeSelfServiceBrowserSettingsPasswordStrategyFlow //...
- kratos.completeSelfServiceSettingsFlowWithPasswordMethod //..
- kratos.completeSelfServiceBrowserSettingsProfileStrategyFlow //...
- kratos.completeSelfServiceSettingsFlowWithProfileMethod //..
```

This patch requires you to run SQL migrations.

This patch makes the reverse proxy functionality required in prior versions of the self-service UI example obsolete. All examples work now with a simple set up and documentation has been added to assist in subdomain scenarios.

The session field `sid` has been renamed to `id` to stay consistent with other APIs which also use `id` terminology to clarify identifiers. The payload of, for example, `/session/whoami` has changed as follows:

```patch
  {
-   "sid": "abcde",
+   "id": "abcde",
    "expires_at": "..."
    "identity": {
      // ..
    }
  }
```

Wording has changed from "Self-Service Registration Request" to "Self-Service Registration Flow" to follow community feedback and practice already applied in the documentation. Additionally, fetching a login flow over the public API no longer requires Anti-CSRF cookies to be sent.

This patch renames several important registration flow endpoints:

- `/self-service/browser/flows/registration` is now `/self-service/registration/browser` without behavioral change.
- `/self-service/browser/flows/requests/registration?request=abcd` is now `/self-service/registration/flows?id=abcd` and no longer needs anti-CSRF cookies to be available.

Additionally, the URL for completing the password registration method has been moved. Given that this endpoint is typically not manually called, you can probably ignore this change:

- `/self-service/browser/flows/registration/strategies/password?request=abcd` is now `/self-service/registration/methods/password?flow=abcd` without functional changes.
- `/self-service/browser/flows/strategies/oidc?request=abcd` is now `/self-service/methods/oidc?flow=abcd` without functional changes.

The Registration UI Endpoint no longer receives a `?request=abcde` query parameter but instead a `?flow=abcde` query parameter. Functionality did not change however.

As part of this change SDK methods have been renamed:

```
  const kratos = new CommonApi(config.kratos.public)
  // ...
- kratos.getSelfServiceBrowserRegistrationRequest(req.query.request)
+ kratos.getSelfServiceRegistrationFlow(req.query.flow)
```

This patch requires you to run SQL migrations.

Existing login sessions will no longer be valid because the session cookie data model changed. If you apply this patch, your users will need to sign in again.

Wording has changed from "Self-Service Login Request" to "Self-Service Login Flow" to follow community feedback and practice already applied in the documentation. Additionally, fetching a login flow over the public API no longer requires Anti-CSRF cookies to be sent.

This patch renames several important login flow endpoints:

- `/self-service/browser/flows/login` is now `/self-service/login/browser` without functional changes.
- `/self-service/browser/flows/requests/login?request=abcd` is now `/self-service/login/flows?id=abcd` and no longer needs anti-CSRF cookies to be available.

Additionally, the URL for completing the password and oidc login method has been moved. Given that this endpoint is typically not manually called, you can probably ignore this change:

- `/self-service/browser/flows/login/strategies/password?request=abcd` is now `/self-service/login/methods/password?flow=abcd` without functional changes.
- `/self-service/browser/flows/strategies/oidc?request=abcd` is now `/self-service/methods/oidc?flow=abcd` without functional changes.

The Login UI Endpoint no longer receives a `?request=abcde` query parameter but instead a `?flow=abcde` query parameter. Functionality did not change however.

As part of this change SDK methods have been renamed:

```
  const kratos = new CommonApi(config.kratos.public)
  // ...
- kratos.getSelfServiceBrowserLoginRequest(req.query.request)
+ kratos.getSelfServiceLoginFlow(req.query.flow)
```

This patch requires you to run SQL migrations.

Configuraiton value `session.cookie_same_site` has moved to `session.cookie.same_site`. There was no functional change.



### Bug Fixes

* Add missing 'recovery' path in oathkeeper access-rules.yml ([#763](https://github.com/ory/kratos/issues/763)) ([f180dba](https://github.com/ory/kratos/commit/f180dba2207638e83e4a23ebc213cddaecb5677f))
* Add missing error handling ([43c1446](https://github.com/ory/kratos/commit/43c14464efa7b736695e2144b031daf6fca87703))
* Add ory-prettier-styles to main repo ([#744](https://github.com/ory/kratos/issues/744)) ([aeaddbc](https://github.com/ory/kratos/commit/aeaddbcb27f89d61b076bdd9ad1739fb1da2ffd9))
* Add remote help description ([f66bbe1](https://github.com/ory/kratos/commit/f66bbe18cfad1e8725ecbcf6e2843b34c3d5119f))
* Add serve help description ([2eb072b](https://github.com/ory/kratos/commit/2eb072b71e5602895d4232e197bfd76180fcdcd7))
* Allow using json with form layout in password registration ([bd2225c](https://github.com/ory/kratos/commit/bd2225c0fff3e0363716d2096346d59046838bb7))
* Annotate whoami endpoint with cookie and token ([a8a781c](https://github.com/ory/kratos/commit/a8a781c00847c74c65558b55e882e12c1e69d8c8))
* Bump datadog version to fix build failure ([4dfd322](https://github.com/ory/kratos/commit/4dfd322290313ec8467ebe8b385b56004b2417bd))
* Change KRATOS_ADMIN_ENDPOINT to KRATOS_ADMIN_URL ([763fdc5](https://github.com/ory/kratos/commit/763fdc56d19d12fa2b83eed2757fbf178d9288b1))
* Clarify fetch use ([8eb2e6f](https://github.com/ory/kratos/commit/8eb2e6f222788a9a579774772696c77987f3cf97))
* Complete verification by redirecting to UI with success ([f0ecf51](https://github.com/ory/kratos/commit/f0ecf5144970f666643aa7c00a3f4ca73f4ab047))
* Correct cookie domain on logout ([#646](https://github.com/ory/kratos/issues/646)) ([6d77e04](https://github.com/ory/kratos/commit/6d77e043ce3bec0864b8abdee371a101f68e4335)), closes [#645](https://github.com/ory/kratos/issues/645)
* Correct help message for import ([a5f46d2](https://github.com/ory/kratos/commit/a5f46d260b43d15f8e77b04cb36c589e103468bf))
* Correct password and profile swagger annotations ([668c184](https://github.com/ory/kratos/commit/668c1847c4c4236ca28f9dcd5147b523a2f60832))
* Correct password registration method api spec ([08dd582](https://github.com/ory/kratos/commit/08dd582195cdb6a891d2428ba5d02cd956555e48))
* Correct PHONY spelling ([#739](https://github.com/ory/kratos/issues/739)) ([e3d3617](https://github.com/ory/kratos/commit/e3d3617b8d82812b0ad67cc1cb02ff86c2c0c66c))
* Cover more test cases for persister ([37d2e08](https://github.com/ory/kratos/commit/37d2e0839b88792733387f26abb98c51bd1e1395))
* Create decoder only once ([34dc43b](https://github.com/ory/kratos/commit/34dc43b0c75303f88d2c304225c027faf5366c1f))
* Deprecate packr2 dependency in makefile ([be9a84d](https://github.com/ory/kratos/commit/be9a84dcffbccd5f0e073a38264cf11a404d3b66)), closes [#711](https://github.com/ory/kratos/issues/711) [#750](https://github.com/ory/kratos/issues/750)
* Do not propagate parent validation error ([bf6093d](https://github.com/ory/kratos/commit/bf6093d442d9779b4df051031565d020ef628ded))
* Don't resend verification emails once verified ([#583](https://github.com/ory/kratos/issues/583)) ([a4d9969](https://github.com/ory/kratos/commit/a4d99694525e65b58d49197c96324b27fb8c31c2)), closes [#578](https://github.com/ory/kratos/issues/578)
* Enforce endpoint to be set ([171ac18](https://github.com/ory/kratos/commit/171ac18d73eaa0822b45f544a9034d6734400f31))
* Escape jsx characters in api documentation ([0946094](https://github.com/ory/kratos/commit/09460948a24918b2a84804cafa86cf88189af919))
* Exit with code 1 on unimplemented CLI commands ([66943d7](https://github.com/ory/kratos/commit/66943d7e5b47fc477a378d8a7cf2b2009ccfceb3))
* Explicitly ignore fprint return values ([f50e582](https://github.com/ory/kratos/commit/f50e5823f4ee047fdc3e276b80b4fb08c9128d99))
* Explicitly ignore fprintf results ([a83dc50](https://github.com/ory/kratos/commit/a83dc509970b3be46d832743481357f336fecc35))
* Fallback to default return url if logout after url is not defined ([#594](https://github.com/ory/kratos/issues/594)) ([7edd367](https://github.com/ory/kratos/commit/7edd367dc64a01dbe252ca0ab8cf4d3926a35014))
* Favor packr2 over pkger ([ac18a45](https://github.com/ory/kratos/commit/ac18a45ea55929c34ca20953e3baa197363483bc)):

    See https://github.com/markbates/pkger/issues/117

* Find and replace "request" references ([41fb673](https://github.com/ory/kratos/commit/41fb673e38779cb27d4400f70458617eb7e5b93c))
* Force exe buildmode for windows CGO ([e017bb5](https://github.com/ory/kratos/commit/e017bb579cd29ad1a634cd552e2601295ff9c104))
* Html form parse regression issue ([6b07cbb](https://github.com/ory/kratos/commit/6b07cbb657702d36423d1fa66fe8a149222c8772))
* Ignore x/net false positives ([7044b95](https://github.com/ory/kratos/commit/7044b95f6188c4ffbfff42c666dee6ebaba055c8))
* Improve debugging output for login hook and restructure files ([dabac40](https://github.com/ory/kratos/commit/dabac40f82407f72071780840f468d0b5b389777))
* Improve debugging output for registration hook and restructure files ([ec11775](https://github.com/ory/kratos/commit/ec117754f5dd41e5a3a43b3807c05796396ced55))
* Improve expired error responses ([124a92e](https://github.com/ory/kratos/commit/124a92ee98d62abeb695e1e271ee2536a69d6047))
* Improve hook tests ([55ba485](https://github.com/ory/kratos/commit/55ba48530a890fdd55ed7da380940f2791148f26))
* Improve makefile dependency building ([8e1d69a](https://github.com/ory/kratos/commit/8e1d69a024414196b39eb3d419f4850cd547e3b5))
* Improve pagination when listing identities ([c60bf44](https://github.com/ory/kratos/commit/c60bf440b9c85b4f2e871237e3d7725571151efe))
* Improve post login hook log and audit messages ([ddd5d5a](https://github.com/ory/kratos/commit/ddd5d5a253d01d2b7b74239a1c7c701759084140))
* Improve post registration hook log and audit messages ([2495629](https://github.com/ory/kratos/commit/24956296dd91cf6f5b110a17f65f9f60d8a7aa78))
* Improve registration hook tests ([8163152](https://github.com/ory/kratos/commit/8163152a4d9595b1ea73d2887205e7ba80b016f9))
* Improve session max-age behavior ([65189fe](https://github.com/ory/kratos/commit/65189fe4a2f84f832240cd67366400e44bb7f09a)), closes [#42](https://github.com/ory/kratos/issues/42)
* Keep HTML form type on registration error ([#698](https://github.com/ory/kratos/issues/698)) ([6c9e756](https://github.com/ory/kratos/commit/6c9e7564efffe1452004d4eda42e1b9ec9feac6b)), closes [#670](https://github.com/ory/kratos/issues/670)
* Lowercase emails on login ([244b4dd](https://github.com/ory/kratos/commit/244b4dd825b9a2448cc61465cef81bd9dcb051db))
* Mark flow methods' fields as required ([#708](https://github.com/ory/kratos/issues/708)) ([834c607](https://github.com/ory/kratos/commit/834c60738ca7bb26e982ff73134b7b0e85a72076))
* Merge public and admin login flow fetch handlers ([48c4906](https://github.com/ory/kratos/commit/48c4906a606396d889e057a03dc83b619220db54))
* Missing write in registration error handler ([3b2af53](https://github.com/ory/kratos/commit/3b2af5397048d63099eace092bf2e50e84a4c610))
* Properly annotate swagger password parameters ([2ef57c4](https://github.com/ory/kratos/commit/2ef57c4323eb2623f4115bee0e44ee27dd1648a9))
* Properly fetch identity for session ([7be4086](https://github.com/ory/kratos/commit/7be4086045fddfacc38813ca3dd7fbcc7039391f))
* Recursive loop on network errors in password validator ([#589](https://github.com/ory/kratos/issues/589)) ([b4d5a42](https://github.com/ory/kratos/commit/b4d5a42346510e40222b8eb59b455b585f0a05cf)), closes [#316](https://github.com/ory/kratos/issues/316):

    The old code no error when ignoreNetworkErrors was set to true, but did not set a hash result which caused an infinite loop.

* Remove incorrect security specs ([4c3d46d](https://github.com/ory/kratos/commit/4c3d46dac20363202f0ccd043e1c9d6bf97fb1f8))
* Remove obsolete tests ([f102f95](https://github.com/ory/kratos/commit/f102f95f420c8a03520602880d096616069c9233)):

    The test is no longer valid as CSRF checks now happen after checking for login sessions in settings flows.

* Remove redirector from code base ([6689ecf](https://github.com/ory/kratos/commit/6689ecf110b11ba15ec39af822906c2b4b17369e))
* Remove stray debug statements ([a8e1ec4](https://github.com/ory/kratos/commit/a8e1ec42cda6ebc664e9434bb5ba7e4dd7c21b4c))
* Rename import to put ([8003e0f](https://github.com/ory/kratos/commit/8003e0f42a5d1b77e326d1dba0a70fcd44c704c0))
* Rename quickstart config files and path ([#671](https://github.com/ory/kratos/issues/671)) ([be8b9e5](https://github.com/ory/kratos/commit/be8b9e5f1ca70b1aa06b77bb2ca35644d8cd3c00))
* Rename quickstart schema file name ([e943c90](https://github.com/ory/kratos/commit/e943c9018a495b39b72ae463fd4727b1798d5ba2))
* Rename recovery models and generate SDKs ([d764435](https://github.com/ory/kratos/commit/d7644359c39732e0b25f43e122d05c1566fb837b))
* Resolve and test for missing data when updating flows ([045ecab](https://github.com/ory/kratos/commit/045ecab11ec185ca688a10de75e506fe413afa26))
* Resolve broken csrf tests ([6befe2e](https://github.com/ory/kratos/commit/6befe2ec08c01c6c9fb397ba119ecebdcecf7db3))
* Resolve broken docs links ([56f4a39](https://github.com/ory/kratos/commit/56f4a397a715b6c0428ae63baa0d2e4bc936f737))
* Resolve broken migrations and bump fizz ([1ed9c70](https://github.com/ory/kratos/commit/1ed9c700b946a090bce9587a57eeb9ac64f04c59))
* Resolve broken OIDC tests and disallow API flows ([9986d8f](https://github.com/ory/kratos/commit/9986d8f818934bd5e073f59bf7a73c6b7a74b6e2))
* Resolve cookie issues ([6e2b6d2](https://github.com/ory/kratos/commit/6e2b6d2f0ce2fb6df7d3e26d6cc8e755e6593a81))
* Resolve e2e headless test failures ([82d506e](https://github.com/ory/kratos/commit/82d506e9d35bbbe4c1578f72e5bcf380ebc97142))
* Resolve e2e test failures ([2627db2](https://github.com/ory/kratos/commit/2627db26089e8f8e4c18782ff59b4cb2068b276f))
* Resolve failing test cases ([f8647b4](https://github.com/ory/kratos/commit/f8647b4c637b4aee29d68df2336fd216306ec78c))
* Resolve flaky passwort setting tests ([#582](https://github.com/ory/kratos/issues/582)) ([c42d936](https://github.com/ory/kratos/commit/c42d936ef51d2ffb48b491b99988d048442e3b8b)), closes [#581](https://github.com/ory/kratos/issues/581) [#577](https://github.com/ory/kratos/issues/577)
* Resolve handler testing issue ([4f6bafd](https://github.com/ory/kratos/commit/4f6bafdc84ba4d878c68700dc243cd3cfe8fe530))
* Resolve identity admin api issues ([#586](https://github.com/ory/kratos/issues/586)) ([feef8a7](https://github.com/ory/kratos/commit/feef8a7d4454c1b343c34a96fa4dadd56149b0cd)), closes [#435](https://github.com/ory/kratos/issues/435) [#500](https://github.com/ory/kratos/issues/500):

    This patch resolves several issues that occurred when creating or updating identities using the Admin API. Now, all hooks are running properly and updating privileged properties no longer causes errors.

* Resolve interface type issues ([064b305](https://github.com/ory/kratos/commit/064b305ab31dc003ccb5992eb1ed2804f85085b9))
* Resolve logout csrf issues ([#761](https://github.com/ory/kratos/issues/761)) ([74c0aac](https://github.com/ory/kratos/commit/74c0aac3b94446c3824ae52b04b6f69395938b81))
* Resolve migratest failures ([e2f34d3](https://github.com/ory/kratos/commit/e2f34d3f411bac042079d7f5425063ef117fae77))
* Resolve migratest ordering failing tests ([dffecc0](https://github.com/ory/kratos/commit/dffecc0e80810ffae57870fd313ee0103ad3f60c))
* Resolve migration issues ([b545e15](https://github.com/ory/kratos/commit/b545e15eeaa3e6e1f4a8fe0f8e1890012ac62c94))
* Resolve panic on `serve` ([ae34155](https://github.com/ory/kratos/commit/ae341555e7b2b622cf58d09d3eb6a78d833dfdcc))
* Resolve panic when DSN="memory" ([#574](https://github.com/ory/kratos/issues/574)) ([05e55f3](https://github.com/ory/kratos/commit/05e55f3584e20ae5d39cfda6e542d4da40d718e4)):

    Executing the migration logic in registry.go cause a panic as the registry is not initalized at that point. Therefore we decided to move the handling to driver_default.go, after the registry has been initialized.

* Resolve pkger issues ([294066c](https://github.com/ory/kratos/commit/294066c41be1d508681caa435afda4858a37b7f1))
* Resolve remaining testing issues ([af40d93](https://github.com/ory/kratos/commit/af40d933b2f663adb6a537b32546b43ba13ae237))
* Resolve SQL persistence tester issues ([4952df4](https://github.com/ory/kratos/commit/4952df43e0aba067c06cdedb1fc2c2d9a2a81a40))
* Resolve swagger issues and regenerate SDK ([be4c7e4](https://github.com/ory/kratos/commit/be4c7e4ea72d2ad7cec67b1d6709858d5a1b3d61))
* Resolve template loading issue ([145fb20](https://github.com/ory/kratos/commit/145fb204d9a8ca189480f9f2221527ccc62980a0))
* Resolve test issues introduced by new csrf protection ([625ef5e](https://github.com/ory/kratos/commit/625ef5e4781700449af0c4e4f1f6cb8aa1787764))
* Resolve verification sql errors ([784da53](https://github.com/ory/kratos/commit/784da53ddefe59aea90254be40ae63e919b4b419))
* Resolves a bug that prevents sessions from expiring ([#612](https://github.com/ory/kratos/issues/612)) ([86b281a](https://github.com/ory/kratos/commit/86b281a46b676d80c8f70bfc42c91d988997c21c)), closes [#611](https://github.com/ory/kratos/issues/611)
* Revert disabling `swagger flatten` during sdk generation ([98c7915](https://github.com/ory/kratos/commit/98c7915cc493ad99c959244eef68b70bc9baa971))
* Set correct path for kratos in oathkeeper set up ([414259f](https://github.com/ory/kratos/commit/414259f9383f30b762051c712763d484f5358075))
* Set quickstart logging to trace ([d3e9192](https://github.com/ory/kratos/commit/d3e919249ae59b449367511d3cc8adef839f31c9))
* Support browser flows only in redirector ([cab5280](https://github.com/ory/kratos/commit/cab5280859b0fc7fc7fec2b2ec9945f457910b20))
* Swagger models ([1b5f9ab](https://github.com/ory/kratos/commit/1b5f9abd5d82251ab93a05d4ff26b4c48c8151ca)):

    The `swagger:parameters <id>` definitions for `updateIdentity` and `createIdentity` where defined two times with the same ID. They had some old definition swagger used. The `internal/httpclient` should now work again as expected.

* Tell tls what the smtps server name is ([#634](https://github.com/ory/kratos/issues/634)) ([b724038](https://github.com/ory/kratos/commit/b724038a67e84ca71b146bf4b9b044be2dc8c0b4))
* Type ([e264c69](https://github.com/ory/kratos/commit/e264c69a07e569429b5e835b1e15c318eff23339))
* Update cli documentation examples ([216ea7f](https://github.com/ory/kratos/commit/216ea7f926798ff03d211447200919f9ef3c8b39))
* Update contrib samples ([79d24b4](https://github.com/ory/kratos/commit/79d24b4472017a75854cce4a45b4c762e5390a67))
* Update crdb quickstart version ([249a6ba](https://github.com/ory/kratos/commit/249a6bae32ccaa6cf002eaab921388e8cb10e58f))
* Update import description ([aef1e1a](https://github.com/ory/kratos/commit/aef1e1acf757637590fe19644952a44d1994ba18))
* Update quickstart kratos config ([e3246e5](https://github.com/ory/kratos/commit/e3246e5d56b95750529239663bab03168789cc09))
* Update recovery token field and column names ([42abfa1](https://github.com/ory/kratos/commit/42abfa1dea2a6291c5b723baf25f35a66f2af835))
* Update status help description ([b147831](https://github.com/ory/kratos/commit/b1478316d2f601843133fd33d75c3b047384f283))
* Update swagger names and fix broken tests ([85b7fb1](https://github.com/ory/kratos/commit/85b7fb1d466bc4dcee97ad75cc92b8bea8e44d9f))
* Update version help description ([8bf4a79](https://github.com/ory/kratos/commit/8bf4a79064a93cb53ef8aee3433b24602bc9f30a))
* Use and test for csrf tokens and prevent api misuse ([a4e3bc5](https://github.com/ory/kratos/commit/a4e3bc55e43ba42582a33551c1cc2e83ecd865fa))
* Use correct HTTP method for password login ([4f4fcee](https://github.com/ory/kratos/commit/4f4fcee8931ab4998e974106b8d88e0c61736e3f))
* Use correct log message ([53c384a](https://github.com/ory/kratos/commit/53c384a542a583259a75315b2602cf4fb41a0ef0))
* Use correct redirection for registration ([8d47113](https://github.com/ory/kratos/commit/8d47113a5f7c0c25dc5f92c683b560763cfd47c9))
* Use correct security annotation ([c9bebe0](https://github.com/ory/kratos/commit/c9bebe00452a73d1c831831e5a95cb4ed8de37b9))
* Use correct swagger tags and regenerate ([df99d8c](https://github.com/ory/kratos/commit/df99d8cbe6e0f2f6a5da872f66db557b2a5e9f70))
* Use helpers to create flow ([aba8610](https://github.com/ory/kratos/commit/aba861097d2c67ce9ebff85df59fce8018862516))
* Use nosurf fork to address VerifyToken bug ([cd84e51](https://github.com/ory/kratos/commit/cd84e51b7b1861ca9bd2312a4dfc5e84afd890cf))
* Use params per_page and page for pagination ([5dfb6e3](https://github.com/ory/kratos/commit/5dfb6e32c44420ed49d652733b9099a41c9347f2))
* Use proper pwd in makefile ([52e22c3](https://github.com/ory/kratos/commit/52e22c3b5c0130afd3e235aba9847389369f435e))
* Use public instead of common sdk ([dcb4a36](https://github.com/ory/kratos/commit/dcb4a36f9fb3c25ace9a252b7e05f7ab71d2e21f))
* Use relative threshold to judge longest common substring in password policy ([#585](https://github.com/ory/kratos/issues/585)) ([3e9f8cc](https://github.com/ory/kratos/commit/3e9f8cce4b058b05d69c73fff514f3b8e46c2be3)), closes [#581](https://github.com/ory/kratos/issues/581)
* Whoami returns 401 not 403 ([3b3b78c](https://github.com/ory/kratos/commit/3b3b78c04bbbbb7b7fb05635d96b4f7c7fa7776f)), closes [#729](https://github.com/ory/kratos/issues/729)

### Code Generation

* Pin v0.5.0-alpha.1 release commit ([557d37d](https://github.com/ory/kratos/commit/557d37d1139adb14a25abe40d0174d47d4e18fee))

### Code Refactoring

* Add flow methods to verification ([00ee828](https://github.com/ory/kratos/commit/00ee828842bd4bc6f917ba2446b1374d28b62000)):

    Completely refactors the verification flow to support other methods. The original email verification flow now moved to the "link" method also used for recovery.
    
    Additionally, several upstream bugs in gobuffalo/pop and gobuffalo/fizz have been addressed, patched, and merged which improves support for SQLite and CockroachDB migrations:
    
    - https://github.com/gobuffalo/fizz/pull/97
    - https://github.com/gobuffalo/fizz/pull/96

* Add method and rename request to flow ([006bf56](https://github.com/ory/kratos/commit/006bf56671d8162cdb5bcce630c027b67935263d))
* Change oidc callback URL ([36d9380](https://github.com/ory/kratos/commit/36d9380b2123d27219c908b51ad97574ee11bc57))
* Complete login flow refactoring ([ad2b3db](https://github.com/ory/kratos/commit/ad2b3db4493085b80889cbc0dce9562288ec6896))
* Dry up login.NewFlow ([f261c44](https://github.com/ory/kratos/commit/f261c442dbe74e3b9887193b74e36fe70306f9d8))
* Improve CSRF infrastructure ([7e367e7](https://github.com/ory/kratos/commit/7e367e7f45481147d5c231d0ea8cbb30b738226f))
* Improve login test reuse ([b4184e5](https://github.com/ory/kratos/commit/b4184e5f1525a9918bc795f2353b186141ce5399))
* Improve NewFlowExpiredError ([1caefac](https://github.com/ory/kratos/commit/1caefac6e0e82aa2b12458ef16d7f5af24014bf9))
* Improve registration tests with testhelpers ([9bf4530](https://github.com/ory/kratos/commit/9bf45303be908449b78c68c7382eab5cfc5c40fa))
* Improve selfservice method tests ([df4d06d](https://github.com/ory/kratos/commit/df4d06d553852cdb8b914810c19bdd0fcc845c9c))
* Improve settings helper functions ([fda17ca](https://github.com/ory/kratos/commit/fda17ca5ea7824c4bf5010218cace7d5fbc7ad5b))
* Move samesite config to cookie parent-key ([753eb86](https://github.com/ory/kratos/commit/753eb86c904c4af9e7d91e46ff4c836dcce35807))
* Moved clihelpers to ory/x ([#756](https://github.com/ory/kratos/issues/756)) ([6ccffa8](https://github.com/ory/kratos/commit/6ccffa8a1cc5b9fd33435187720257bb66323546)):

    Contributes to https://github.com/ory/hydra/issues/2124.
    
    

* Profile settings method is now API-able ([c5f361f](https://github.com/ory/kratos/commit/c5f361ff418336cfcaa452eded4bd61132808b16))
* Remove common keyword from API spec ([6619562](https://github.com/ory/kratos/commit/6619562667ef0e363d14c57cfbcd15c16f292853))
* Remove need for reverse proxy in selfservice-ui ([beb4c32](https://github.com/ory/kratos/commit/beb4c3284e552fe51c3a8cebb20a8c2bfc07cdf8)), closes [#661](https://github.com/ory/kratos/issues/661)
* Rename `session.sid` to `session.id` ([809fe73](https://github.com/ory/kratos/commit/809fe7334e4a308405c1f03ada1dbef6ed33c01a))
* Rename login request to login flow ([9369d1b](https://github.com/ory/kratos/commit/9369d1bb637fc80b5d5980140693d5bcac0c76bb)), closes [#635](https://github.com/ory/kratos/issues/635):

    As part of this change, fetching a login flow over the public API no longer requires Anti-CSRF cookies to be sent.

* Rename LoginRequestErrorHandler to LoginFlowErrorHandler ([66ae029](https://github.com/ory/kratos/commit/66ae029f49aecdfba5fa6905cfccfcdad992dd5a))
* Rename package recoverytoken to link ([f87fb54](https://github.com/ory/kratos/commit/f87fb549f6d8a10ba5adffddeb2fe12060d520ab))
* Rename recovery request to flow internally ([16c5618](https://github.com/ory/kratos/commit/16c5618644e78cf1081f966e01b570a36eea709b))
* Rename recovery request to recovery flow ([b0f433d](https://github.com/ory/kratos/commit/b0f433d4cb65d79acba789394d828663e873a833)), closes [#635](https://github.com/ory/kratos/issues/635):

    As part of this change, fetching a login flow over the public API no longer requires Anti-CSRF cookies to be sent.

* Rename registration request to flow ([8437ebc](https://github.com/ory/kratos/commit/8437ebcf4deb2844562ec701af3bbbb2a9b5dea4))
* Rename registration request to registration flow ([0470956](https://github.com/ory/kratos/commit/0470956128d03921d8554c43af2c5a0003abe82f)), closes [#635](https://github.com/ory/kratos/issues/635):

    As part of this change, fetching a registration flow over the public API no longer requires Anti-CSRF cookies to be sent.

* Rename request_lifespan to lifespan ([#677](https://github.com/ory/kratos/issues/677)) ([3c8d5e0](https://github.com/ory/kratos/commit/3c8d5e02b04686a1e0bfbd28caa0bc536e3414e4)), closes [#666](https://github.com/ory/kratos/issues/666)
* Rename strategies to methods ([8985189](https://github.com/ory/kratos/commit/89851896d563518909bc2b47a7ff91683eec4958)):

    This patch renames `strategies` such as "Username/Email & Password" to methods.

* Rename verify to verificaiton ([#597](https://github.com/ory/kratos/issues/597)) ([0ecd69a](https://github.com/ory/kratos/commit/0ecd69a60f741fc334c9b060b6aeaafc39e048b1))
* Replace all occurrences of login request to flow ([1b3c491](https://github.com/ory/kratos/commit/1b3c49174a7a2eff51dd531f3a49afc15c31c536))
* Replace all registration request occurrences with registration flow ([308ef47](https://github.com/ory/kratos/commit/308ef47846c9ab4f18a598ef6ef78514fad77c42))
* Replace packr2 with pkger fork ([4e2acae](https://github.com/ory/kratos/commit/4e2acae7c4fc17880cf88ef05cf7cca5f20f5be3))
* Restructure login package ([c99e2a2](https://github.com/ory/kratos/commit/c99e2a2f23c3c2aabaae55de67e40ab7fb2dd307))
* Use session token as cookie identifier ([60fd9c2](https://github.com/ory/kratos/commit/60fd9c2efa881fcdd769a8967abe73c05a198868))

### Documentation

* Add administrative user management guide ([b97e0c6](https://github.com/ory/kratos/commit/b97e0c69bb1115bdec88b218e8cdda34f137d798))
* Add code samples to session checking ([eba8eda](https://github.com/ory/kratos/commit/eba8eda70423aa802eace278889a5e8d2e0bc513))
* Add configuring introduction ([#630](https://github.com/ory/kratos/issues/630)) ([b8cfb35](https://github.com/ory/kratos/commit/b8cfb351c2dca783e355f39d25ce17b65fef7dd4))
* Add descriptions to cobra commands ([607b76d](https://github.com/ory/kratos/commit/607b76d109d1fa519235fe9d6af78c8315b9c4fc))
* Add documentation for configuring cookies ([e3dbc8a](https://github.com/ory/kratos/commit/e3dbc8acc055f6e2d78bc959be7356f9a66ac90f)), closes [#516](https://github.com/ory/kratos/issues/516)
* Add domain, subdomain, multi-domain cookie guides ([3eb1e59](https://github.com/ory/kratos/commit/3eb1e5987df56993c792684a6a2bc11f5eb570b8)), closes [#661](https://github.com/ory/kratos/issues/661)
* Add github video tutorial ([#622](https://github.com/ory/kratos/issues/622)) ([0c4222c](https://github.com/ory/kratos/commit/0c4222c0d12df4e971fd7e5099006484e0bcb317))
* Add guide for cors ([a8ae759](https://github.com/ory/kratos/commit/a8ae759565d94ebd9d0f758b7eb6efbddf486372))
* Add guide for cors ([91fd278](https://github.com/ory/kratos/commit/91fd278d1a6720576998b115dedb882b90915561))
* Add guide for dealing with login sessions ([4e2718c](https://github.com/ory/kratos/commit/4e2718c779031c0e3b877e9df1747ccb2371927b))
* Add identity state ([fb4aedb](https://github.com/ory/kratos/commit/fb4aedb9a95367e25080491b54aab11de491d819))
* Add login session to navbar ([b212d64](https://github.com/ory/kratos/commit/b212d6484e40c9f2cce10f2ba4aaf4e2a72f03a1))
* Add milestones to sidebar ([aae13ec](https://github.com/ory/kratos/commit/aae13ec141a2c315aff1a53aa005bb9465efcdc0))
* Add missing GitLab provider to the list of supported OIDC providers ([#766](https://github.com/ory/kratos/issues/766)) ([a43ed33](https://github.com/ory/kratos/commit/a43ed335262fd542f349224aef918af5263c384d))
* Add missing TOC entries ([#748](https://github.com/ory/kratos/issues/748)) ([bd7edfb](https://github.com/ory/kratos/commit/bd7edfbebd19f01af337c34293ebc2865f2b077d))
* Add pagination docs ([7fe0901](https://github.com/ory/kratos/commit/7fe0901ee5d0e829e110bd0c4fdecb24bfc27768))
* Add secret key rotation guide ([3d6e21a](https://github.com/ory/kratos/commit/3d6e21af2f726944468299c326600a8ab0e4e885))
* Add sequence diagrams for browser/api flows ([590d767](https://github.com/ory/kratos/commit/590d767352b9253b7550eaba56fea99400399cd7))
* Add session hook to ssi guide ([#623](https://github.com/ory/kratos/issues/623)) ([1bbed39](https://github.com/ory/kratos/commit/1bbed390ffedd811afdb5fcfe69047554419d8ce))
* Add terminology section ([29b81a7](https://github.com/ory/kratos/commit/29b81a78fcf880cd6d9d3b2cbb03f955b701ffbd))
* Add theme helpers and decouple mermaid ([7c3eb32](https://github.com/ory/kratos/commit/7c3eb32df5d9287845258bf25d6719733f6c4227))
* Add video to OIDC guide ([#619](https://github.com/ory/kratos/issues/619)) ([f286980](https://github.com/ory/kratos/commit/f286980c29ce8460ba550e5d74b8dee23602e920))
* Added sidebar cli label ([5d24a29](https://github.com/ory/kratos/commit/5d24a2998b412159295feca40421b8b11cf02274)):

    `clidoc.Generate` expects to find an entry under `sidebar.json/Reference` that contains the substring "CLI" in it's label. Because that was missing, a new entry was appended on every regeneration of the file.

* Added sidebar item ([#639](https://github.com/ory/kratos/issues/639)) ([8574761](https://github.com/ory/kratos/commit/857476112d12b8ab79ef49054452a950ff81bc23)):

    Added Kratos Video Tutorial Transcripts document to sidebar.

* Added transcript ([#627](https://github.com/ory/kratos/issues/627)) ([cec7f1f](https://github.com/ory/kratos/commit/cec7f1fc4955b02d21d772e748ec791f31bad24e)):

    Added Login with Github Transcript

* Adds twitch oidc provider guide ([#760](https://github.com/ory/kratos/issues/760)) ([339e622](https://github.com/ory/kratos/commit/339e62202170bf21d469d1a2bfe6b053a78c374d))
* Bring oidc docs up to date ([7d0e470](https://github.com/ory/kratos/commit/7d0e47058cd6dca1763f01e45ed46cee49321240))
* Changed transcript location ([#642](https://github.com/ory/kratos/issues/642)) ([c52764d](https://github.com/ory/kratos/commit/c52764d4394181b24dffbf8301418530ba5dbcc2)):

    Changed the location so it is in the right place.

* Clarify 302 redirect on expired login flows ([ca31b53](https://github.com/ory/kratos/commit/ca31b53837e8eb2b811bf384da3724fdf61b423b))
* Clarify api flow use ([a38b4a1](https://github.com/ory/kratos/commit/a38b4a1684cfbc385ca21005c91a47e57df5a35d))
* Clarify feature-set ([2266ae7](https://github.com/ory/kratos/commit/2266ae7ea92207cdc4fcb58ef1384e287a5b34dc))
* Clarify kratos config snippet ([e7732f3](https://github.com/ory/kratos/commit/e7732f3283d82a1678076cd2463ef5ff33dd30ea))
* Clean up docs and correct samples ([8627ec5](https://github.com/ory/kratos/commit/8627ec58edb15118e0c4ce2cfcef7a5573482c5a))
* Complete registration documentation ([b3af02b](https://github.com/ory/kratos/commit/b3af02b0ea4cbf16ea282b7ce5f5057d99044ac3))
* Consistent formatting of badges ([#745](https://github.com/ory/kratos/issues/745)) ([b391a03](https://github.com/ory/kratos/commit/b391a036f3b49cd6c1915444c9f26dead4855a7c))
* Correct settings and verification redir ([30e25e7](https://github.com/ory/kratos/commit/30e25e7287a2579da99a6a6dc2f890e7e06fcc81))
* Docker image documentation ([#573](https://github.com/ory/kratos/issues/573)) ([bfe032e](https://github.com/ory/kratos/commit/bfe032e2b6bfd8b9415d466011bdd7e36efa4146))
* Document APi flows in self-service overview ([71ed0bd](https://github.com/ory/kratos/commit/71ed0bd2027d61c2e5cebf6b031fe66469bdf97e))
* Document how to check for login sessions ([9ad73b8](https://github.com/ory/kratos/commit/9ad73b8dab06c6796933448cb93ae4e55d9f2c51))
* Explain high-level API and browser flows ([fe3ee0a](https://github.com/ory/kratos/commit/fe3ee0a0c8681a99dc6b61b90cff547c6a7fc6d2))
* Fix logout url ([#593](https://github.com/ory/kratos/issues/593)) ([f0971d4](https://github.com/ory/kratos/commit/f0971d44a911caed8a6071358fa6b7ebc0fcf145))
* Fix sidebar missing comment ([d90123a](https://github.com/ory/kratos/commit/d90123ae31edbae6a39a1f039cc9362f9acdfdcb))
* Fix typo ([c2f94da](https://github.com/ory/kratos/commit/c2f94daa4143a70c13426ccd5366ec891182e4d0))
* Fix typo on index page ([#656](https://github.com/ory/kratos/issues/656)) ([907add5](https://github.com/ory/kratos/commit/907add5edb526adb4de57d35da16929ac08041e1))
* Fix url of admin-api /recovery/link ([#650](https://github.com/ory/kratos/issues/650)) ([e68c7cb](https://github.com/ory/kratos/commit/e68c7cbdc2191565570d0ee6812318ac9ad3421d))
* Fixed link ([c2aebbd](https://github.com/ory/kratos/commit/c2aebbd898f38388d849954938d56212c88d280f))
* Fixed link ([#629](https://github.com/ory/kratos/issues/629)) ([ad1276f](https://github.com/ory/kratos/commit/ad1276f2b2cf3cbbecba4dee1d6d433999286946))
* Fixed typos/readability ([#620](https://github.com/ory/kratos/issues/620)) ([7fd3ce0](https://github.com/ory/kratos/commit/7fd3ce0d8c52346ba3504ce5777321937baf8d1e)):

    Fixed a few typos, and moved some sentences around to improve readability.

* Fixed typos/readability ([#621](https://github.com/ory/kratos/issues/621)) ([c4fc75f](https://github.com/ory/kratos/commit/c4fc75f7dca59fa8f31d068f57179f49bf798b6a))
* Import mermaid ([#696](https://github.com/ory/kratos/issues/696)) ([6f75004](https://github.com/ory/kratos/commit/6f750047d41add6bd2d30adb1c654181c9636d2d))
* Improve charts and examples in self-service overview ([312c91d](https://github.com/ory/kratos/commit/312c91de3ae3c086f836ec3928735d787ad40dde))
* Improve documentation and add tests ([3dde956](https://github.com/ory/kratos/commit/3dde956e09d1f3f6411046b12f8684d8760f9b91))
* Improve long messages and render cli documentation ([e5fc02f](https://github.com/ory/kratos/commit/e5fc02ff22836e074a1dfca043d4b4b8ad64c747))
* Make assumptions neutral in concepts overview ([e89d980](https://github.com/ory/kratos/commit/e89d98099bd3fc5c8361f9015e44668494211152))
* Move development section ([2e6f643](https://github.com/ory/kratos/commit/2e6f6430f88105efd5618482043809c6d643216b))
* Move hooks ([c02b588](https://github.com/ory/kratos/commit/c02b58867ee2c0a386b2b741375ec8cd76122461))
* Move to json sidebar ([504af3b](https://github.com/ory/kratos/commit/504af3b89d728eb11bf42f4a2037c78b3b7cb788))
* Password login and registration methods for API clients ([5a44356](https://github.com/ory/kratos/commit/5a4435643ae3463df85458f22f87730c11af10ab))
* Prettify all files ([#743](https://github.com/ory/kratos/issues/743)) ([d9d1bfd](https://github.com/ory/kratos/commit/d9d1bfdff70ad835629a2dba00579925fcb3094d))
* Quickstart next steps ([#676](https://github.com/ory/kratos/issues/676)) ([ee9dd0d](https://github.com/ory/kratos/commit/ee9dd0d58a4146a0e131f6a7b74943bb39d26c0b)):

    Added a section outlining some easy config changes, that users can apply to the quickstart to test out different scenarios and configurations.

* Refactor login and registration documentation ([c660a04](https://github.com/ory/kratos/commit/c660a04ed6a70aefca18896662331fcc5d1919cf))
* Refactor settings and recovery documentation ([11ca9f7](https://github.com/ory/kratos/commit/11ca9f7d1b858dcda3a96e1e1d2607ba64f7fbbe))
* Refactor verification docs ([70f2789](https://github.com/ory/kratos/commit/70f2789363773fccc4bd8691597ff588ac6892c6))
* Regenerate clidocs with up-to-date binary ([e53289c](https://github.com/ory/kratos/commit/e53289c8e9f34a02ec66ec7ee03e2269a4a13c42))
* Remove `make tools` task ([ec6e664](https://github.com/ory/kratos/commit/ec6e6641234191d4eb39e1ad17bc7fcc03c2a0b5)), closes [#711](https://github.com/ory/kratos/issues/711) [#750](https://github.com/ory/kratos/issues/750):

    This task does not exist any more and the dependency building is much smarter now.

* Remove contraction ([#747](https://github.com/ory/kratos/issues/747)) ([cd4f21d](https://github.com/ory/kratos/commit/cd4f21dbfa2b3824468146677f542fbab2417c42))
* Remove duplicate word ([b84e659](https://github.com/ory/kratos/commit/b84e659af29aa1b129f33ccf5ca9e0d54353c019))
* Remove duplicate word ([#700](https://github.com/ory/kratos/issues/700)) ([a12100e](https://github.com/ory/kratos/commit/a12100e7644b535c4bd3073e03c48229bb81e7b2))
* Remove react native guide for now ([daa5f2e](https://github.com/ory/kratos/commit/daa5f2e3de3fe8380a91f594e034afcadc6e6ba5))
* Rename self service and add admin section ([639c424](https://github.com/ory/kratos/commit/639c424d3bde0557f7edd7edc489a476f1aa60b3))
* Replace ampersand ([#749](https://github.com/ory/kratos/issues/749)) ([8337b80](https://github.com/ory/kratos/commit/8337b80a13e8cf0cb2848241c93bb151420ac6a4))
* Resolve regression issues ([0470fd7](https://github.com/ory/kratos/commit/0470fd734fb30170033e10758d99cf5711c80eb1))
* Resolve typo in message IDs ([562cfc4](https://github.com/ory/kratos/commit/562cfc4392ba1c9c1fb8854ea0ac85bd44d0fac9))
* Resolve typo in message IDs ([#607](https://github.com/ory/kratos/issues/607)) ([f7688f0](https://github.com/ory/kratos/commit/f7688f0ab07b579a375ce4cc25361b360e82dd88))
* Update cli docs ([085efca](https://github.com/ory/kratos/commit/085efcae895b3aa3c76c819dca0f080ea79d57cd))
* Update link to mfa issue ([d03a706](https://github.com/ory/kratos/commit/d03a706307be21b83d18601223fb0d1430459a29))
* Update links ([a06fd88](https://github.com/ory/kratos/commit/a06fd88b0dcb747808ffea450bf1ac74dd941769))
* Update MFA link to issue ([#690](https://github.com/ory/kratos/issues/690)) ([7a744ad](https://github.com/ory/kratos/commit/7a744ad7b62540dd5789aee8532c1f97ddcab32d)):

    MFA issue was pushed to a later milestone. Update the documentation to point to the issue instead of the milestone.

* Update repository templates ([f422485](https://github.com/ory/kratos/commit/f4224852ceeb054405251b21895efa493e1abc9c))
* Update repository templates ([#678](https://github.com/ory/kratos/issues/678)) ([bdb6875](https://github.com/ory/kratos/commit/bdb6875e55aed454cda061969e1dd4f712e09bb5))
* Update sidebar ([ea15c20](https://github.com/ory/kratos/commit/ea15c2093fc66e4cfc0a66aabf7dfad6965777dc))
* Update ts examples ([65cb46e](https://github.com/ory/kratos/commit/65cb46e57595b920bd6544f9a9a4f7b886462be0))
* Use correct id for multi-domain-cookies ([b49288a](https://github.com/ory/kratos/commit/b49288a351647c91a3c7d4a62537146d4a9f1bd0))
* Use correct path in 0.4 docs ([9fcaac4](https://github.com/ory/kratos/commit/9fcaac4048e05500d0456eb3cd9cd11cc123e370)), closes [#588](https://github.com/ory/kratos/issues/588)
* Use NYT Capitalization for all Swagger headlines ([#675](https://github.com/ory/kratos/issues/675)) ([6c96429](https://github.com/ory/kratos/commit/6c9642959dab8cf042ad227711609d5726328394)), closes [#664](https://github.com/ory/kratos/issues/664)

### Features

* Add ability to configure session cookie domain/path ([faeb332](https://github.com/ory/kratos/commit/faeb3328dab343c6ef3974065ba0c5c590a8817e)), closes [#516](https://github.com/ory/kratos/issues/516)
* Add and improve settings testhelpers ([10a43fc](https://github.com/ory/kratos/commit/10a43fc518bd5c764712b549e6d35bf7159d757a))
* Add bearer helper ([ec6ca20](https://github.com/ory/kratos/commit/ec6ca20279d839dc10e7e3bc80e0442a630e586b))
* Add config version schema ([#608](https://github.com/ory/kratos/issues/608)) ([d218662](https://github.com/ory/kratos/commit/d218662388ef4fb7ea3bfee7b29c5cc8d34f1c8c)), closes [#590](https://github.com/ory/kratos/issues/590)
* Add discord oidc provider ([#767](https://github.com/ory/kratos/issues/767)) ([487296d](https://github.com/ory/kratos/commit/487296dd39d2e59d61b63f00f3d61fea9b8aed8c))
* Add enum to form field type ([96028d8](https://github.com/ory/kratos/commit/96028d8c80414cdcea177150ba6e986d0ecb29c6))
* Add flow type to login ([ce9133b](https://github.com/ory/kratos/commit/ce9133b0ff6d03738a5d27cf9c6a213496d75772))
* Add HTTP request flow validator ([1a6e847](https://github.com/ory/kratos/commit/1a6e84774b65ee7be9294baaaff77192cec8f0f2))
* Add new prometheus metrics endpoint [#672](https://github.com/ory/kratos/issues/672) ([#673](https://github.com/ory/kratos/issues/673)) ([0f5c436](https://github.com/ory/kratos/commit/0f5c436ce6e4aa78ca52ae63e58812e6703a1ab7)):

    Adds endpoint `/metrics` for prometheus metrics collection to the Admin API Endpoint.

* Add nocache helpers ([54dcc4d](https://github.com/ory/kratos/commit/54dcc4da2ff22bdb17e53dd6eac1c0bd54a20390))
* Add pagination tests ([e3aa81b](https://github.com/ory/kratos/commit/e3aa81b7da55108f43ea6e16c817c97e2f8a1d50))
* Add session token security definition ([d36c26f](https://github.com/ory/kratos/commit/d36c26f2edd66ddbd8338de4901957a9b9b7342e)):

    Adds the new Session Token as a Swagger security definition to allow setting the session token as a Bearer token when calling `/sessions/whoami`.

* Add stub errors to errorx ([5d452bb](https://github.com/ory/kratos/commit/5d452bb582e6a9e3b893424ec135d0cbdf875659)), closes [#610](https://github.com/ory/kratos/issues/610)
* Add test helper for fetching settings requests ([3646383](https://github.com/ory/kratos/commit/36463838d81d8b108aa9ded8c1ec6bc8f48f2267))
* Add tests and helpers to test recovery/verifiable addresses ([#579](https://github.com/ory/kratos/issues/579)) ([29979e6](https://github.com/ory/kratos/commit/29979e6c4934b71c7fb158cfa5b85e97be3ea8fc)), closes [#576](https://github.com/ory/kratos/issues/576)
* Add tests to cover auth ([c9d3a15](https://github.com/ory/kratos/commit/c9d3a1525cc74976d16b483e0ab5c48909b84022))
* Add texts for settings ([795548c](https://github.com/ory/kratos/commit/795548c25507c34c7fc37ce1c1a8ecc076c34ef4))
* Add the already declared (and settable) tracer as a middleware ([#614](https://github.com/ory/kratos/issues/614)) ([e24fffe](https://github.com/ory/kratos/commit/e24fffe3f13c353e3c07214c1e056a849533a9f6))
* Add token to session ([08c8c78](https://github.com/ory/kratos/commit/08c8c7837dbf799e6ba01d1820812c9e792d7850))
* Add type to all flows in SQL ([5515776](https://github.com/ory/kratos/commit/551577659f6a416ff6ef032c35af224b517df413))
* Allow import/validation of arrays ([d11ac32](https://github.com/ory/kratos/commit/d11ac32db6ddc0dce73067ffe7d4d0a734a3f991))
* Bump cli and migration render tasks ([6dcb42a](https://github.com/ory/kratos/commit/6dcb42a487476371a545b72f7ee7e820b815bbee))
* Finalize tests for registration flow refactor ([8e52c3a](https://github.com/ory/kratos/commit/8e52c3a99bd39b3429ff476340b5df49e0a85707))
* Finish off client cli ([36d60c7](https://github.com/ory/kratos/commit/36d60c7e7bc38d83726b4b4a3061ba6353dd1978))
* Implement administrative account recovery ([f5f9c43](https://github.com/ory/kratos/commit/f5f9c43e10dd3a9547e87776164d2d4a171f35ce))
* Implement API flow for recovery link method ([d65bf66](https://github.com/ory/kratos/commit/d65bf66781bdd2fae73e75c0ba39287b1575c45a))
* Implement API-based tests for password method settings flows ([60664aa](https://github.com/ory/kratos/commit/60664aaf05dbd6b228f420688d0171e5789246be))
* Implement max-age for session cookie ([2e642ff](https://github.com/ory/kratos/commit/2e642ff13c59a7e23babe9209c1a114ef0163bad)), closes [#326](https://github.com/ory/kratos/issues/326)
* Implement tests and anti-csrf for API settings flows ([8b8b6e5](https://github.com/ory/kratos/commit/8b8b6e5367e05f49950b851ea6834a9f18e896e7))
* Implement tests for new migrations ([e08ece9](https://github.com/ory/kratos/commit/e08ece9bb1c8c52580c15cf9152b4203821a0a0e))
* Improve test readability for password method ([a896d9b](https://github.com/ory/kratos/commit/a896d9b55596d2925941a6b6a91b8a6e4ef2caa1))
* Log successful hook execution ([f6026cf](https://github.com/ory/kratos/commit/f6026cfb0418767d99d18cd50529c2b71b21d775))
* Log successful hook execution ([1e7d044](https://github.com/ory/kratos/commit/1e7d044603b204632d2ec73c2e54db896992300b))
* Make login error handle JSON aware ([88f581f](https://github.com/ory/kratos/commit/88f581ff40a183cb96b5fb6d1ba398c58a9792d1))
* Make password settings method API-able ([0cf6027](https://github.com/ory/kratos/commit/0cf60274f87f098d5eb57531f5071cd407b65f4d))
* Make public cors configurable ([863a0d4](https://github.com/ory/kratos/commit/863a0d4f4696b05209b16f2e0c3daa9e8f4c1945)), closes [#712](https://github.com/ory/kratos/issues/712)
* Oidc provider claims config option ([#753](https://github.com/ory/kratos/issues/753)) ([bf94a40](https://github.com/ory/kratos/commit/bf94a40acd52128303c0b878ddb92d56abc4ceaf)), closes [#735](https://github.com/ory/kratos/issues/735)
* Reply with cache-control: 0 for browser-facing APIs ([1a45b53](https://github.com/ory/kratos/commit/1a45b5341e0ab4580208bfb6a505859d1e5d2faf)), closes [#360](https://github.com/ory/kratos/issues/360)
* Schemas are now static assets ([1776d58](https://github.com/ory/kratos/commit/1776d58278c42094b2c703e269a5901a96617051))
* Support and document api flow in session issuer hook ([91f3cc7](https://github.com/ory/kratos/commit/91f3cc7a559b1ea1279216f8dc81abd8e6f73776))
* Support application/json in registration ([3476b97](https://github.com/ory/kratos/commit/3476b978fdaee90358cc5505e20a0526f812a460)), closes [#44](https://github.com/ory/kratos/issues/44)
* Support custom session token header ([56bec76](https://github.com/ory/kratos/commit/56bec760fd1b94428ba296395a11358664d9e830)):

    The `/sessions/whoami` endpoint now accepts the ORY Kratos Session Token in the `X-Session-Token` HTTP header.

* Support GitLab OIDC Provider  ([#519](https://github.com/ory/kratos/issues/519)) ([8580d96](https://github.com/ory/kratos/commit/8580d96b7e345cc85a646f2945c3931f831afebf)), closes [#518](https://github.com/ory/kratos/issues/518)
* Support json payloads for login and password ([354e8b2](https://github.com/ory/kratos/commit/354e8b2cd63ee8feb1fd8a4ed8b033490155d90c))
* Support JSON payloads in password login flow ([dd32c23](https://github.com/ory/kratos/commit/dd32c23121da42e7eb3294fc8cb940fb7982723b))
* Support session token bearer auth and lifecycle ([c12600a](https://github.com/ory/kratos/commit/c12600a7243b541a91631169ec09d618a45c72dc)):

    This patch adds support for issuing, validating, and revoking session tokens. Session tokens carry a reference to a session, and are equal to session cookies but can be used on environments which do not support cookies (e.g. React Native) by sending them in the Bearer Authorization.

* Update migration tests ([fb28173](https://github.com/ory/kratos/commit/fb28173afa46ee828a3090981f394043c075f1ec))
* Use uri-reference for ui_url etc. to allow relative urls ([#617](https://github.com/ory/kratos/issues/617)) ([2dba450](https://github.com/ory/kratos/commit/2dba4503266436a615f4c1c18e07aa36ec713498))
* Write request -> flow rename migrations ([d7189a9](https://github.com/ory/kratos/commit/d7189a99c9d3e0ce33b4cc9846e6b2530ddfe5ec))

### Tests

* Add handler update tests ([aea1fb8](https://github.com/ory/kratos/commit/aea1fb807a16acd8406b94a72c3b39be8c3e1280)), closes [#325](https://github.com/ory/kratos/issues/325)
* Add init browser flow tests ([f477ece](https://github.com/ory/kratos/commit/f477ecebc73741b638cd62ef8aa2adb8b7adb8f2))
* Add test for no-cache on public router ([b8aa63b](https://github.com/ory/kratos/commit/b8aa63b7ebd269a87578e8a5c6b2df27e18f9efa))
* Add test for registration request ([79ed63c](https://github.com/ory/kratos/commit/79ed63cb4536499712796dab52999bcb73fe8466))
* Add tests for registration flows ([4772f71](https://github.com/ory/kratos/commit/4772f710f66d1ee36b52eca120d617a354f72413))
* Complete test suite for API-based auth ([fb9d62f](https://github.com/ory/kratos/commit/fb9d62f658165aa80bd117e1f827bbcc7c635150))
* Implement API login password tests ([8bfd5f2](https://github.com/ory/kratos/commit/8bfd5f294ff03280bcf01c5066acefe767eabc73))
* Implement API registration password tests ([db178b7](https://github.com/ory/kratos/commit/db178b73b097820c8dcd8760eec041a6fd0740aa))
* Replace e2e-memory with unit test ([52bd839](https://github.com/ory/kratos/commit/52bd839ea9fe8de1aac4663b9dc0a88ae18a5765)), closes [#580](https://github.com/ory/kratos/issues/580)
* Resolve broken decoder tests ([07add1b](https://github.com/ory/kratos/commit/07add1b3e4f46e4aff52174ce43d6970f60cf3ee))
* Use correct hook in test ([421320c](https://github.com/ory/kratos/commit/421320ca4ad5b346c6dfb6ef0a9d14d7cf23fded))

### Unclassified

* u ([e207a6a](https://github.com/ory/kratos/commit/e207a6adb98f639413accce383633d7e74ca4db9))
* As part of this change, fetching a settings flow over the public API no longer requires Anti-CSRF cookies to be sent. ([31d560e](https://github.com/ory/kratos/commit/31d560e47d55b087519355081cbca20b2a49da4e)), closes [#635](https://github.com/ory/kratos/issues/635)
* Create labels.json ([68b1f6f](https://github.com/ory/kratos/commit/68b1f6f5a35c66cc71f74f1473796fa16a852366))
* Add codedoc to identifier hint block ([6fe840f](https://github.com/ory/kratos/commit/6fe840f9c7a27ed97593e01936913e2239fd9446))
* Format ([e61a51d](https://github.com/ory/kratos/commit/e61a51dd6e2d5e003165a0b7906a9c86ebbc87d9))
* Format ([1e5b738](https://github.com/ory/kratos/commit/1e5b738f0765ec110c3ee70d7fc90fad0d1c89ac))
* Format code ([c3b5ff5](https://github.com/ory/kratos/commit/c3b5ff5d3bc3a1e72f48498fbed60bae9f159617))


# [0.4.6-alpha.1](https://github.com/ory/kratos/compare/v0.4.5-alpha.1...v0.4.6-alpha.1) (2020-07-13)

Resolves build and install issues and includes a few bugfixes.





### Bug Fixes

* Use proper binary name in dockerfile ([d36bbb0](https://github.com/ory/kratos/commit/d36bbb0875177ccd68747f4a17e59c981a7a6464))

### Code Generation

* Pin v0.4.6-alpha.1 release commit ([ad90e77](https://github.com/ory/kratos/commit/ad90e772cf59a33b213bc0fb782959a1685d9741)):

    Bumps from v0.4.4-alpha.1



# [0.4.5-alpha.1](https://github.com/ory/kratos/compare/v0.4.4-alpha.1...v0.4.5-alpha.1) (2020-07-13)

Resolves build and install issues and includes a few bugfixes.





### Bug Fixes

* Ensure default_browser_return_url for flows is configured in after ([#570](https://github.com/ory/kratos/issues/570)) ([cf9753c](https://github.com/ory/kratos/commit/cf9753c690c67e6401be52d2c1ce69f168aae6e8)), closes [#569](https://github.com/ory/kratos/issues/569)
* Require selfservice.default_browser_return_url to be set in config ([#571](https://github.com/ory/kratos/issues/571)) ([af2af7d](https://github.com/ory/kratos/commit/af2af7d35ba8b10dcd6d7636b044b0f7761a719d))

### Code Generation

* Pin v0.4.5-alpha.1 release commit ([3ea7fd3](https://github.com/ory/kratos/commit/3ea7fd3e7fd2c0b4aef638aa30e2b5b05c1bad26)):

    Bumps from v0.4.4-alpha.1



# [0.4.4-alpha.1](https://github.com/ory/kratos/compare/v0.4.3-alpha.1...v0.4.4-alpha.1) (2020-07-10)

The purpose of this release is to resolve issues with install scripts, homebrew, and scoop.





### Bug Fixes

* Detection of SQLite memory mode ([#564](https://github.com/ory/kratos/issues/564)) ([605cd57](https://github.com/ory/kratos/commit/605cd579895f3b765d398074cfdb37fa3eae0c4e))
* Improve goreleaser config ([0f8a0d8](https://github.com/ory/kratos/commit/0f8a0d8afa6489383800d3eff1b7b1da01fbef08))

### Code Generation

* Pin v0.4.4-alpha.1 release commit ([154d543](https://github.com/ory/kratos/commit/154d543eef29ab67be8637a96d8d06620974094f))

### Documentation

* Add description for subkeys of serve ([#562](https://github.com/ory/kratos/issues/562)) ([deae005](https://github.com/ory/kratos/commit/deae005a259747872f678d355b49cca21904e565))
* Add section about password expiry ([19c2414](https://github.com/ory/kratos/commit/19c2414c3defe79fe6e80e50dd0e85026ecd60e6))
* Specify the use of secrets ([#565](https://github.com/ory/kratos/issues/565)) ([7680450](https://github.com/ory/kratos/commit/7680450cfa44049759b27ec09d5bebc236b19a29))
* Update upgrade guide ([a40b1ec](https://github.com/ory/kratos/commit/a40b1ec18e7801f2862aad4e37becb7ce8f99c37))


# [0.4.3-alpha.1](https://github.com/ory/kratos/compare/v0.4.2-alpha.1...v0.4.3-alpha.1) (2020-07-08)

We are very happy to announce the 0.4 release of ORY Kratos with 163 commits and 817 changed files with 52,681 additions and 9,876 deletions.

There have been many improvements and bugfixes merged. The biggest changes are:

1. Account recovery ("reset password") has been implemented.
2. Documentation has been improved with easier to understand examples - currently only for account recovery so let us know what you think!
3. The configuration has been simplified a lot. It is now much easier to enable account recovery and email verification. This is a breaking change - please read the breaking changes section with care!
4. The Identity Traits JSON Schema has been renamed to the Identity JSON Schema. This is a breaking change - please read the breaking changes section with care!
5. `prompt=login` has been renamed to `refresh=true`. This is a breaking change - please read the breaking changes section with care!
6. We have reworked how (error) messages are returned. They now include an ID and all the parameters required for translating and customizing UI messages. This is a breaking change - please read the breaking changes section with care!
7. Instead of keeping track of `update_successful` with booleans, flows (e.g. the settings flow) that have more than one state now include a state machine. This is a breaking change - please read the breaking changes section with care!
8. Tons of tests have been added.
9. We have reworked and fully tested the migration pipeline to prevent breaking schema changes in future versions.
10. ORY Kratos now supports login with Azure AD and the Microsoft Identity Platform.

Before upgrading, please make a backup of your database and read the section "Breaking Changes" with care!





### Bug Fixes

* Resolve goreleaser build issues ([223571b](https://github.com/ory/kratos/commit/223571bca15f507067d20bedb104923331f88e59))
* Update install.sh script ([883d99b](https://github.com/ory/kratos/commit/883d99ba42de084018a32eaa094b5ae1a8ad4fc2))

### Code Generation

* Pin v0.4.3-alpha.1 release commit ([a3a34b1](https://github.com/ory/kratos/commit/a3a34b1e43b2d010ed85e098cd7cea31127df311)):

    Bumps from v0.4.0-alpha.1



# [0.4.2-alpha.1](https://github.com/ory/kratos/compare/v0.4.0-alpha.1...v0.4.2-alpha.1) (2020-07-08)

We are very happy to announce the 0.4 release of ORY Kratos with 153 commits and 760 changed files with 36,223 additions and 9,754 deletions.

There have been many improvements and bugfixes merged. The biggest changes are:

1. Account recovery ("reset password") has been implemented.
2. Documentation has been improved with easier to understand examples - currently only for account recovery so let us know what you think!
3. The configuration has been simplified a lot. It is now much easier to enable account recovery and email verification. This is a breaking change - please read the breaking changes section with care!
4. The Identity Traits JSON Schema has been renamed to the Identity JSON Schema. This is a breaking change - please read the breaking changes section with care!
5. `prompt=login` has been renamed to `refresh=true`. This is a breaking change - please read the breaking changes section with care!
6. We have reworked how (error) messages are returned. They now include an ID and all the parameters required for translating and customizing UI messages. This is a breaking change - please read the breaking changes section with care!
7. Instead of keeping track of `update_successful` with booleans, flows (e.g. the settings flow) that have more than one state now include a state machine. This is a breaking change - please read the breaking changes section with care!
8. Tons of tests have been added.
9. We have reworked and fully tested the migration pipeline to prevent breaking schema changes in future versions.
10. ORY Kratos now supports login with Azure AD and the Microsoft Identity Platform.

Before upgrading, please make a backup of your database and read the section "Breaking Changes" with care!





### Bug Fixes

* Ignore pkged generated files ([1d385e4](https://github.com/ory/kratos/commit/1d385e4d1a004405099242c3003006d1713a24c6))

### Code Generation

* Pin v0.4.2-alpha.1 release commit ([20024cb](https://github.com/ory/kratos/commit/20024cbbb44b4f556004ef752a7f37e70a070e6a)):

    Bumps from v0.4.0-alpha.1



# [0.4.0-alpha.1](https://github.com/ory/kratos/compare/v0.3.0-alpha.1...v0.4.0-alpha.1) (2020-07-08)

We are very happy to announce the 0.4 release of ORY Kratos with 153 commits and 760 changed files with 36,223 additions and 9,754 deletions.

There have been many improvements and bugfixes merged. The biggest changes are:

1. Account recovery ("reset password") has been implemented.
2. Documentation has been improved with easier to understand examples - currently only for account recovery so let us know what you think!
3. The configuration has been simplified a lot. It is now much easier to enable account recovery and email verification. This is a breaking change - please read the breaking changes section with care!
4. The Identity Traits JSON Schema has been renamed to the Identity JSON Schema. This is a breaking change - please read the breaking changes section with care!
5. `prompt=login` has been renamed to `refresh=true`. This is a breaking change - please read the breaking changes section with care!
6. We have reworked how (error) messages are returned. They now include an ID and all the parameters required for translating and customizing UI messages. This is a breaking change - please read the breaking changes section with care!
7. Instead of keeping track of `update_successful` with booleans, flows (e.g. the settings flow) that have more than one state now include a state machine. This is a breaking change - please read the breaking changes section with care!
8. Tons of tests have been added.
9. We have reworked and fully tested the migration pipeline to prevent breaking schema changes in future versions.
10. ORY Kratos now supports login with Azure AD and the Microsoft Identity Platform.

Before upgrading, please make a backup of your database and read the section "Breaking Changes" with care! This release requires running SQL migrations when upgrading!



## Breaking Changes

This patch renames the Identity Traits JSON Schema to Identity JSON Schema.

The identity payload has changed from

```
 {
-  "traits_schema_url": "...",
-  "traits_schema_id": "...",
+  "schema_url": "...",
+  "schema_id": "...",
 }
```

Additionally, it is now expected that your Identity JSON Schema includes a "traits" key at the
root level.

**Before (example)**

```
{
  "$id": "https://schemas.ory.sh/presets/kratos/quickstart/email-password/identity.schema.json",
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "Person",
  "type": "object",
  "properties": {
    "email": {
      "type": "string",
      "format": "email",
      "title": "E-Mail",
      "minLength": 3,
      "ory.sh/kratos": {
        "credentials": {
          "password": {
            "identifier": true
          }
        },
        "verification": {
          "via": "email"
        },
        "recovery": {
          "via": "email"
        }
      }
    }
  },
  "required": [
    "email"
  ],
  "additionalProperties": false
}
```

**After (example)**

```
{
  "$id": "https://schemas.ory.sh/presets/kratos/quickstart/email-password/identity.schema.json",
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "Person",
  "type": "object",
  "properties": {
    "traits": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string",
          "format": "email",
          "title": "E-Mail",
          "minLength": 3,
          "ory.sh/kratos": {
            "credentials": {
              "password": {
                "identifier": true
              }
            },
            "verification": {
              "via": "email"
            },
            "recovery": {
              "via": "email"
            }
          }
        }
      },
      "required": [
        "email"
      ],
      "additionalProperties": false
    }
  }
}
```

You also need to remove the `traits` key from your ORY Kratos config like this:

```
 identity:
-   traits:
-     default_schema_url: http://test.kratos.ory.sh/default-identity.schema.json
-     schemas:
-       - id: other
-         url: http://test.kratos.ory.sh/other-identity.schema.json
+   default_schema_url: http://test.kratos.ory.sh/default-identity.schema.json
+   schemas:
+     - id: other
+       url: http://test.kratos.ory.sh/other-identity.schema.json
```

Do not forget to also update environment variables for the Identity JSON Schema as well if set.

To address these refactorings, the configuration had to be changed and with breaking changes
as keys have moved or have been removed.

Hook configuration has also changed. It is no longer required to include hooks such as `verification` to get
verification working. Instead, verification is enabled globally (`selfservice.flows.verification.enabled`).
Also, the `redirect` hook has been removed as it lead to confusion because there are already default redirect
URLs configurable. You will find more information in the details below.

**Session Management**

```diff
-ttl:
-  session: 1h
-security:
-  session:
-    cookie:
-      same_site: Lax
+session:
+  lifespan: 1h
+  cookie_same_site: Lax
```

**Secrets**

```diff
-secrets:
-  session:
-    - secret-to-encrypt-session-cookies
-    - old-session-cookie-secret-that-has-been-rotated
+secrets:
+  default:
+    # This secret is used as default and will also be used for encrypting e.g. cookies when a dedicated cookie secret (as shown below) is not defined.
+    - default-secret-to-encrypt-stuff
+  cookie:
+    - secret-to-encrypt-session-cookies
+    - old-session-cookie-secret-that-has-been-rotated
```

**URLs**

The Base URL configuration has moved to `serve.public` and `serve.admin`. They are also no longer required and fall
back to defaults based on the machine's hostname, port configuration, and other settings:

```diff
-urls:
-  self:
-    public: https://kratos.my-website.com/
-    admin: https://admin.kratos.cluster.localnet/
+serve:
+  public:
+    base_url: https://kratos.my-website.com/
+  admin:
+    base_url: https://admin.kratos.cluster.localnet/
```

The UI URLs have moved from `urls` to their respective self-service flows:

```diff
-urls:
-  login_ui: http://127.0.0.1:4455/auth/login
-  registration_ui: http://127.0.0.1:4455/auth/registration
-  settings_ui: http://127.0.0.1:4455/settings
-  verify_ui: http://127.0.0.1:4455/verify
-  error_ui: http://127.0.0.1:4455/error
+selfservice:
+  flows:
+    login:
+      ui_url: http://127.0.0.1:4455/auth/login
+    registration:
+      ui_url: http://127.0.0.1:4455/auth/registration
+    settings:
+      ui_url: http://127.0.0.1:4455/settings
+    # please note that `verify` has changed to `verification`!
+    verification:
+      ui_url: http://127.0.0.1:4455/verify
+    error:
+      ui_url: http://127.0.0.1:4455/error
```

The default redirect URL as well as whitelisted redirect URLs have also changed their location:

```diff
-urls:
-  default_return_to: https://self-service/dashboard
-  whitelisted_return_to_urls:
-    - https://self-service/some-other-url
-    - https://example.org/another-url
+selfservice:
+  default_browser_return_url: https://self-service/dashboard
#  Please note that the `to` has been removed (`whitelisted_return_to_urls` -> `whitelisted_return_urls`)
+  whitelisted_return_urls:
+    - https://self-service/some-other-url
+    - https://example.org/another-url
```

**Self-Service Login**

`selfservice.login` has moved to `selfservice.flow.login`:

```diff
 selfservice:
-  login:
+  flows:
+    login:
```

On top of this change, a few keys under `login` have changed as well:

```diff
 selfservice
   flows:
     login:
+      ui_url: http://127.0.0.1:4455/auth/login
       request_lifespan: 99m
-      before:
-        hooks:
-          - hook: redirect
-            config:
-              default_redirect_url: http://test.kratos.ory.sh:4000/
-              allow_user_defined_redirect: false
+      # The before hooks have been removed because there were no good use cases for them. If
+      # this is a problem for you feel free to open an issue!

     after:
-      default_return_to: https://self-service/login/return_to
+      default_browser_return_url: https://self-service/login/return_to
       password:
-         default_return_to: https://self-service/login/password/return_to
+         default_browser_return_url: https://self-service/login/password/return_to
          hooks:
            - hook: revoke_active_sessions
       oidc:
-         default_return_to: https://self-service/login/podc/return_to
+         default_browser_return_url: https://self-service/login/podc/return_to
          hooks:
            - hook: revoke_active_sessions
```

**Self-Service Registration**

`selfservice.registration` has moved from to `selfservice.flow.registration`:

```diff
 selfservice:
-  registration:
+  flows:
+    registration:
```

On top of this change, a few keys under `registration` have changed as well:

```diff
 selfservice
   flows:
     registration:
+      ui_url: http://127.0.0.1:4455/auth/registration
       request_lifespan: 99m
-      before:
-        hooks:
-          - hook: redirect
-            config:
-              default_redirect_url: http://test.kratos.ory.sh:4000/
-              allow_user_defined_redirect: false
+      # The before hooks have been removed because there were no good use cases for them. If
+      # this is a problem for you feel free to open an issue!

     after:
-      default_return_to: https://self-service/registration/return_to
+      default_browser_return_url: https://self-service/registration/return_to
       password:
-        default_return_to: https://self-service/registration/password/return_to
+        default_browser_return_url: https://self-service/registration/password/return_to
         hooks:
           - hook: revoke_active_sessions
+          # The verify hook is now executed automatically when verification is turned on.
-          - hook: verify
+          # The redirect hook was confusing as it aborts the registration flow and does not solve redirection on
+          # success. It has thus been removed.
-          - hook: redirect
       oidc:
-        default_return_to: https://self-service/registration/podc/return_to
+        default_browser_return_url: https://self-service/registration/podc/return_to
         hooks:
           - hook: revoke_active_sessions
+          # The verify hook is now executed automatically when verification is turned on.
-          - hook: verify
+          # The redirect hook was confusing as it aborts the registration flow and does not solve redirection on
+          # success. It has thus been removed.
-          - hook: redirect
```

**Self-Service Settings**

`selfservice.settings` has moved from to `selfservice.flow.settings`:

```diff
 selfservice:
-  settings:
+  flows:
+    settings:
```

On top of this change, a few keys under `settings` have changed as well:

```diff
 selfservice
   flows:
     settings:
+      ui_url: http://127.0.0.1:4455/settings
       request_lifespan: 99m
       privileged_session_max_age: 99m
-      default_return_to: https://self-service/settings/return_to
       after:
+        default_browser_return_url: https://self-service/settings/return_to
+        # The profile/password after hooks have been removed as verification is now executed automatically
+        # when turned on.
-        password:
-          hooks:
-            - hook: verify
-        profile:
-          hooks:
-            - hook: verify
```

**Self-Service Verification**

`selfservice.verify` has moved from to `selfservice.flow.verification`:

```diff
 selfservice:
-  verify:
+  flows:
+    verification:
```

Instead of configuring verification with hooks and other components, it can now be enabled
in a central place. If enabled, a SMTP server must be configured in the `courier` section.
You are still required to mark a field as verifiable in your Identity JSON Schema.

```diff
 selfservice:
   flows:
     verification:
+      enabled: true # defaults to true
+      ui_url: http://127.0.0.1:4455/recovery
       request_lifespan: 1m
-      default_return_to: https://self-service/verification/return_to
       after:
+        default_browser_return_url: https://self-service/verification/return_to
```

Replaces the `update_successful` field of the settings request
with a field called `state` which can be either `show_form` or `success`.

Flows, request methods, form fields have had a key errors to show e.g. validation errors such as ("not an email address", "incorrect username/password", and so on. The `errors` key is now called `messages`. Each message now has a `type` which can be `error` or `info`, an `id` which can be used to translate messages, a `text` (which was previously errors[*].message). This affects all login, request, settings, and recovery flows and methods.

To refresh a login session it is now required to append `refresh=true` instead of `prompt=login` as the second has implications for revoking an existing issue and might be confusing when used in combination with OpenID Connect.

* Applying this patch requires running SQL Migrations.
* The field `identity.addresses` has moved to `identity.verifiable_addresses`.
* Configuration key `selfservice.verification.link_lifespan`
has been merged with  `selfservice.verification.request_lifespan`.



### Bug Fixes

* Account recovery can't use recovery token ([#526](https://github.com/ory/kratos/issues/526)) ([379f24e](https://github.com/ory/kratos/commit/379f24e96e50a3e5c71b53a11195bdd84a8dc957)), closes [#525](https://github.com/ory/kratos/issues/525)
* Add and document recovery to quickstart ([c229c54](https://github.com/ory/kratos/commit/c229c54603bdc3efb863fd76b64096ae599d1aac))
* Add pkger to docker builds ([d3ef5a0](https://github.com/ory/kratos/commit/d3ef5a0fe90f430999d0d94cb2f55acc8d628212))
* Allow linking oidc credentials without existing oidc connection ([#548](https://github.com/ory/kratos/issues/548)) ([39c1234](https://github.com/ory/kratos/commit/39c1234f8ff3f6c7b0923053c8a317677d6cb667)), closes [#532](https://github.com/ory/kratos/issues/532)
* Bump pop version ([#558](https://github.com/ory/kratos/issues/558)) ([9e46cea](https://github.com/ory/kratos/commit/9e46ceabec8d5c1995321b62cbba9ac3900de446)), closes [#556](https://github.com/ory/kratos/issues/556)
* Clear error messages after updating settings successfully ([#421](https://github.com/ory/kratos/issues/421)) ([7eec388](https://github.com/ory/kratos/commit/7eec38829449237cffe345d8bec67578764559be)), closes [#420](https://github.com/ory/kratos/issues/420)
* Do not send debug on session/whoami ([16d3670](https://github.com/ory/kratos/commit/16d3670070bf46170c4540203e8380ad81bfb4c3)), closes [#483](https://github.com/ory/kratos/issues/483)
* Document login refresh parameter in swagger ([#482](https://github.com/ory/kratos/issues/482)) ([6b94993](https://github.com/ory/kratos/commit/6b949936725a6100a31851a5d879c877c2c76cbf))
* Embedded video link properly ([#514](https://github.com/ory/kratos/issues/514)) ([962bbc6](https://github.com/ory/kratos/commit/962bbc6e4af0797c190418b812f6298372dabdde))
* Embedded video link properly ([#515](https://github.com/ory/kratos/issues/515)) ([821ca93](https://github.com/ory/kratos/commit/821ca93838a360551378e336e9ce10cfe13369ec))
* Enable recovery for quickstart ([0ccc651](https://github.com/ory/kratos/commit/0ccc651f809b1e39dd6c41b88f1a10c67451eae2))
* Improve grammar of similar password error ([#471](https://github.com/ory/kratos/issues/471)) ([39873bf](https://github.com/ory/kratos/commit/39873bfad89a654fe12e101b54e9b0c2f95714ec))
* Improvements to Dockerfiles ([#552](https://github.com/ory/kratos/issues/552)) ([6023877](https://github.com/ory/kratos/commit/6023877184efeadd6ec27a050a6969b6d0dd6caa)):

    - expose ory home as volume to simplify passing in own config file
    - declare Kratos default ports in Dockerfile

* Initialize verification request with correct state ([3264ecf](https://github.com/ory/kratos/commit/3264ecfbb8f7b34d9dbb22237df8d9f591ac09f3)), closes [#543](https://github.com/ory/kratos/issues/543)
* Re-add all databases to persister ([#527](https://github.com/ory/kratos/issues/527)) ([b04d178](https://github.com/ory/kratos/commit/b04d17815b5a28b5fe73a6a94ce1d907a63115e1))
* Re-add redirect targets for quickstart ([3c48ad2](https://github.com/ory/kratos/commit/3c48ad26961560d6e10a627a64052e316d9ffdc7))
* Reduce docker bloat by ignoring docs and others ([ecc555b](https://github.com/ory/kratos/commit/ecc555b5ad0fa888a8d5ba39cc09094fd251e655))
* Resolve broken redirect in verify flow ([a9ca8fd](https://github.com/ory/kratos/commit/a9ca8fd793347ed8e4404a4bd29e330a3f1ef684)), closes [#436](https://github.com/ory/kratos/issues/436)
* Respect multiple secrets and fix used flag ([#526](https://github.com/ory/kratos/issues/526)) ([b16c2b8](https://github.com/ory/kratos/commit/b16c2b80edfc78afca0c72fa8da7d73b51b3075a)), closes [#525](https://github.com/ory/kratos/issues/525)
* Respect self-service enabled flag ([#470](https://github.com/ory/kratos/issues/470)) ([b198faf](https://github.com/ory/kratos/commit/b198fafce9d96fbb644300243e6a757242fbbd06)), closes [#417](https://github.com/ory/kratos/issues/417):

    Respects the `enabled` flag for self-service strategies.
    
    Also a new testhelper function was needed, to defer route registration
    (because whether strategies are enabled or not is determined only once:
    at route registration)

* Typo accent -> account ([984d978](https://github.com/ory/kratos/commit/984d978cf44763d916a9329742d046e00f21577b))
* Use correct brew replacements ([fd269b1](https://github.com/ory/kratos/commit/fd269b1afa784becac7ee79cd7a6f9d2bbe39121)), closes [#423](https://github.com/ory/kratos/issues/423)
* Write migration tests ([#499](https://github.com/ory/kratos/issues/499)) ([d32413a](https://github.com/ory/kratos/commit/d32413a1fcd0ce1a82d2529f18b5d4334a490a2a)), closes [#481](https://github.com/ory/kratos/issues/481)

### Code Generation

* Pin v0.4.0-alpha.1 release commit ([e8690c4](https://github.com/ory/kratos/commit/e8690c4037ba5d80aa2459625be553c5bc2d2152))

### Code Refactoring

* Improve and simplify configuration ([#536](https://github.com/ory/kratos/issues/536)) ([8e7f9f5](https://github.com/ory/kratos/commit/8e7f9f5ec3ac6f5675584974e8d189247b539634)), closes [#432](https://github.com/ory/kratos/issues/432)
* Move schema packing to pkger ([173f9d2](https://github.com/ory/kratos/commit/173f9d2b09d597376490b5d4588f7c0a4f525857))
* Move verify fallback to verification ([1ce6469](https://github.com/ory/kratos/commit/1ce64695ec61c3a31e00875069d2847be502744b))
* Rename identity traits schema to identity schema  ([#557](https://github.com/ory/kratos/issues/557)) ([949e743](https://github.com/ory/kratos/commit/949e743ef9ddbc6e711f0174593f59f4fa3a1171)), closes [#531](https://github.com/ory/kratos/issues/531)
* Rename prompt=login to refresh=true ([#478](https://github.com/ory/kratos/issues/478)) ([c04346e](https://github.com/ory/kratos/commit/c04346e0f01aa7ce5627c0b7135032b225e7faf9)), closes [#477](https://github.com/ory/kratos/issues/477)
* Replace settings update_successful with state ([#488](https://github.com/ory/kratos/issues/488)) ([ca3b3f4](https://github.com/ory/kratos/commit/ca3b3f4dbdcd75ceb13c9a1b2c8dc991aba7c7e4)), closes [#449](https://github.com/ory/kratos/issues/449)
* Text errors to text messages ([#476](https://github.com/ory/kratos/issues/476)) ([8106951](https://github.com/ory/kratos/commit/81069514e5ef1d851f76d44bb45d6a896d4985a6)), closes [#428](https://github.com/ory/kratos/issues/428):

    This patch implements a better way to deal with text messages by giving them a unique ID, a context, and a default message.


### Documentation

* Add azure to next docs ([e1dd3fa](https://github.com/ory/kratos/commit/e1dd3fad30a07be6f105201a8478642e9792df46))
* Add fixme note for viper workaround ([7e3eef6](https://github.com/ory/kratos/commit/7e3eef6d36dcbb1a06ce0a20e2de0874a7dc5d38)):

    See https://github.com/ory/x/issues/169

* Add guide for setting up account recovery ([bbf3762](https://github.com/ory/kratos/commit/bbf37620d5b47fd18cb754c8ed43856652ee33c0))
* Add guide for setting up email verification ([1435cbc](https://github.com/ory/kratos/commit/1435cbcea5d45c9cde1a0eb7e5ebb66ce65c4b82))
* Add guide for SSO via Google ([#424](https://github.com/ory/kratos/issues/424)) ([5c45b16](https://github.com/ory/kratos/commit/5c45b1653791cc3ab5d4e4694da98da7543e816d))
* Add new guides to sidebar ([24c5cbc](https://github.com/ory/kratos/commit/24c5cbc129ad185ec02883c3451d7e573409b865))
* Added video tutorials to guides ([#513](https://github.com/ory/kratos/issues/513)) ([956731d](https://github.com/ory/kratos/commit/956731d562f33f2849197b2e692a4f20b18279f9))
* Added youtube manual ([#490](https://github.com/ory/kratos/issues/490)) ([ec232f7](https://github.com/ory/kratos/commit/ec232f72d7204b2cdf946874d51f7473a10a76a4))
* Connecting Kratos to AzureAD ([#433](https://github.com/ory/kratos/issues/433)) ([7660bcd](https://github.com/ory/kratos/commit/7660bcd2ba90d83c4ab0683a2f011e6841b2c810))
* Correct claims.email in github guide ([#422](https://github.com/ory/kratos/issues/422)) ([052a622](https://github.com/ory/kratos/commit/052a622de79d34e32ccab9c7da12a1275c7be51b)):

    There is no email_primary in claims, and the selfservice strategy is currently using claims.email.

* Correct claims.email in github guide ([#422](https://github.com/ory/kratos/issues/422)) ([58f7e15](https://github.com/ory/kratos/commit/58f7e15093d2461d4322fe68adb0723ae244bed9)):

    There is no email_primary in claims, and the selfservice strategy is currently using claims.email.

* Correct link in user-settings ([d13317d](https://github.com/ory/kratos/commit/d13317d9bf71db775067a7c17f4c98cdbf1cc7e5))
* Correct SDK use in quickstart ([#480](https://github.com/ory/kratos/issues/480)) ([dfdf975](https://github.com/ory/kratos/commit/dfdf9751d9333994a49537d82a15b780ebd8bc76)), closes [#430](https://github.com/ory/kratos/issues/430)
* Correct stray dot ([e820f41](https://github.com/ory/kratos/commit/e820f41e63aff1a85094a9e14dfd968353ae6b1b))
* Correct user settings render form ([197e246](https://github.com/ory/kratos/commit/197e24603fc67707131e54e52e1bfb52011ca839))
* Delete old redirect homepage ([b6d9244](https://github.com/ory/kratos/commit/b6d9244b5d683f5baf27e9af5970596261a4fd20))
* Document new account recovery feature ([2252a86](https://github.com/ory/kratos/commit/2252a8676e573b9ade85814acc40b212dcfd48c1)), closes [#436](https://github.com/ory/kratos/issues/436)
* Document refresh=true for login ([#479](https://github.com/ory/kratos/issues/479)) ([2ab5ead](https://github.com/ory/kratos/commit/2ab5ead77517ab5b750835195ab6673e219da71a)), closes [#464](https://github.com/ory/kratos/issues/464)
* Embedded quickstart video ([#491](https://github.com/ory/kratos/issues/491)) ([ee80346](https://github.com/ory/kratos/commit/ee80346a30ebc2c7b06292e58bd3578e002e242a))
* Fix broken link ([d20816e](https://github.com/ory/kratos/commit/d20816e5335abb8bcde5c6d68b17eaabae5d01b0))
* Fix broken link ([aa9d3e6](https://github.com/ory/kratos/commit/aa9d3e6347375170a84ba53b2a9050c9544e7e2a))
* Fix broken link ([#506](https://github.com/ory/kratos/issues/506)) ([dac8dfd](https://github.com/ory/kratos/commit/dac8dfd970255f8e79e7fc7811f563e6903f6fc9)):

    The rest api is no longer under sdk but under reference.

* Fix broken link ([#554](https://github.com/ory/kratos/issues/554)) ([e80d691](https://github.com/ory/kratos/commit/e80d691e256326aacfa89b391583e0494d8a6872))
* Fix code sample comment ([781a76b](https://github.com/ory/kratos/commit/781a76bb6de20767d6150b1fcb5236f4f376edd7))
* Fix copy paste errors in code docs ([e456a4e](https://github.com/ory/kratos/commit/e456a4e435265eade7026fd899c4bc7d2b28a5c9))
* Fix iframe syntax ([#520](https://github.com/ory/kratos/issues/520)) ([0cb36ca](https://github.com/ory/kratos/commit/0cb36ca9d8459dc8027358190e6e8aa8764bffe4))
* Fix typo ([#535](https://github.com/ory/kratos/issues/535)) ([c57d270](https://github.com/ory/kratos/commit/c57d270758a97315c874df3fae867b0031300501))
* Fix typo in base docs ([#503](https://github.com/ory/kratos/issues/503)) ([6668048](https://github.com/ory/kratos/commit/666804812d707b1d50ea160877bdb3878ddfe6b0))
* Fix typo in oauth sign in documentation ([#504](https://github.com/ory/kratos/issues/504)) ([886e24d](https://github.com/ory/kratos/commit/886e24d93a5eb233062b8c7d562c8208f7a4f48f))
* Fix typos ([81903a5](https://github.com/ory/kratos/commit/81903a5137d87588531391623b92afde70abc3ea))
* Fix typos ([#489](https://github.com/ory/kratos/issues/489)) ([57a7bc8](https://github.com/ory/kratos/commit/57a7bc89961612fea0255202d3dd6a535921ef3c))
* Fix ui url keys everywhere ([b75debb](https://github.com/ory/kratos/commit/b75debb0ee4f87dd9910b30bd76d8c6ad382fb38))
* Fix username example by renaming property and removing format ([#508](https://github.com/ory/kratos/issues/508)) ([4573426](https://github.com/ory/kratos/commit/45734260bcead3087aadcaaf3033cc1e89bc1844))
* Fix wording in settings flow graph ([e2a0084](https://github.com/ory/kratos/commit/e2a00842cb5bd3cfbddd0e5117c7f3f968e9f2df))
* Fixed broken link ([#452](https://github.com/ory/kratos/issues/452)) ([d1ddbd1](https://github.com/ory/kratos/commit/d1ddbd1ee465a7d3e29815fcfd9c75b5decbb5f9))
* Fixed broken link ([#455](https://github.com/ory/kratos/issues/455)) ([4f3d179](https://github.com/ory/kratos/commit/4f3d17906f3fa2aea3a0b0505047da6aa54938e4))
* Fixed broken link ([#456](https://github.com/ory/kratos/issues/456)) ([4b43e99](https://github.com/ory/kratos/commit/4b43e993df62d2bf54fa39624651f081eb75bbb0))
* Fixed broken link ([#460](https://github.com/ory/kratos/issues/460)) ([7da304c](https://github.com/ory/kratos/commit/7da304caf0de93442f047872cdd30d7fc316218e))
* Fixed broken link ([#461](https://github.com/ory/kratos/issues/461)) ([c248e4e](https://github.com/ory/kratos/commit/c248e4e2a48a409b53ed02644abfc27e3cebeb11))
* Fixed broken link ([#462](https://github.com/ory/kratos/issues/462)) ([ceacac3](https://github.com/ory/kratos/commit/ceacac30eda7d94cb24403c1fb988d4dd5fcd21f))
* Fixed broken links ([#451](https://github.com/ory/kratos/issues/451)) ([193a781](https://github.com/ory/kratos/commit/193a781576031818006d6e2b72418293cf94dda1)):

    Fixed a few broken links, .md in the url was the problem.

* Fixed broken links ([#453](https://github.com/ory/kratos/issues/453)) ([59d00eb](https://github.com/ory/kratos/commit/59d00ebb87564cc9ff9c5ae12bcd7d25fb0b26c9))
* Fixed broken links ([#457](https://github.com/ory/kratos/issues/457)) ([00ec00d](https://github.com/ory/kratos/commit/00ec00d09ca5318c75832caff5e7a97d640ac083))
* Fixed broken links ([#458](https://github.com/ory/kratos/issues/458)) ([f960887](https://github.com/ory/kratos/commit/f9608876e30dbdd7c67ee70dcf5d9a1985b80f0f))
* Fixed broken links ([#459](https://github.com/ory/kratos/issues/459)) ([2749596](https://github.com/ory/kratos/commit/27495964c7cd34e9bf914b19c83157e484c9cde4))
* Fixed broken markdown ([#474](https://github.com/ory/kratos/issues/474)) ([22d5be1](https://github.com/ory/kratos/commit/22d5be16f91ed9df206310c6f04d843cd79328ca))
* Format guides ([407c70f](https://github.com/ory/kratos/commit/407c70f23d815380d98ee9252f263e07c1f0f4a9))
* Improve grammar and wording ([#448](https://github.com/ory/kratos/issues/448)) ([a19adf3](https://github.com/ory/kratos/commit/a19adf30426ff8df03a3eb725ae0101ebb6c4ab1))
* Improve grammar, clarify sections, update images ([#419](https://github.com/ory/kratos/issues/419)) ([79019d1](https://github.com/ory/kratos/commit/79019d1246b1517b3297996a207a3d2f517fab01))
* Make whitelisted_return_to_urls examples an array ([#426](https://github.com/ory/kratos/issues/426)) ([7ed5605](https://github.com/ory/kratos/commit/7ed56057f533f23ca18cab5a2614429554e877e2)), closes [#425](https://github.com/ory/kratos/issues/425)
* Minor fixes ([#467](https://github.com/ory/kratos/issues/467)) ([8d15307](https://github.com/ory/kratos/commit/8d153079ee44f0765993640500bbe746dc0a34aa))
* Move security questions to own document ([2b77fba](https://github.com/ory/kratos/commit/2b77fba79b724dcd68ff0cd739cd65517aea4325))
* Properly annotate forms disabled field ([#486](https://github.com/ory/kratos/issues/486)) ([be1acb3](https://github.com/ory/kratos/commit/be1acb3d161412d18599c970364f0c91fa6ebffb)), closes [/github.com/ory/kratos/pull/467#discussion_r434764266](https://github.com//github.com/ory/kratos/pull/467/issues/discussion_r434764266)
* Remove rogue slash and fix closing tag ([#521](https://github.com/ory/kratos/issues/521)) ([3fd1076](https://github.com/ory/kratos/commit/3fd1076929eeecffb7e8aa8e906970774283daeb))
* Rename redirect page to browser-redirect-flow-completion ([ae77d48](https://github.com/ory/kratos/commit/ae77d48a3435069556382b9403cb1ad45a9d7c07))
* Replace mailhog references with mailslurper ([#509](https://github.com/ory/kratos/issues/509)) ([d0e5a0f](https://github.com/ory/kratos/commit/d0e5a0fa64e2d46437fb2abd17dc306bdec34a91))
* Run format ([2b3f299](https://github.com/ory/kratos/commit/2b3f29913be844498a02b9869789c2b2d4aaacf8))
* Typo correction in credentials.md ([#551](https://github.com/ory/kratos/issues/551)) ([3b7e104](https://github.com/ory/kratos/commit/3b7e104c2bcba52326f89761c9e3da14b4f06d08))
* Typos and stale links ([29fb466](https://github.com/ory/kratos/commit/29fb466d9881b6574ee697d7e25e45785f07114b))
* Typos and stale links ([#510](https://github.com/ory/kratos/issues/510)) ([7557ab8](https://github.com/ory/kratos/commit/7557ab85ddf8501935d70e2558682dff2024897b))
* Update repository templates ([4c89834](https://github.com/ory/kratos/commit/4c89834ce59195c5b59da5bc5b41db7ed03bf1c4))
* Use central banner repo for README ([d1e8a82](https://github.com/ory/kratos/commit/d1e8a8272cd536b6e12326778258bfbe0b7e8af7))
* Use shorthand closing tag for Mermaid ([f9f2dbc](https://github.com/ory/kratos/commit/f9f2dbc063f82a852b540013ddff81501f7c1222))

### Features

* Add support for Multitenant Azure AD as an OIDC provider ([#434](https://github.com/ory/kratos/issues/434)) ([a8f1179](https://github.com/ory/kratos/commit/a8f117985217c753cfca52905e43b640e89a6bd1))
* Add tests for defaults ([a16fc51](https://github.com/ory/kratos/commit/a16fc5121b36353cf2e684190eda976a1ea53a8f))
* Add User ID to a header when calling whoami ([#530](https://github.com/ory/kratos/issues/530)) ([183b4d0](https://github.com/ory/kratos/commit/183b4d075a9ff50c1f9f53d108a48789e49a5138))
* Implement account recovery ([#428](https://github.com/ory/kratos/issues/428)) ([e169a3e](https://github.com/ory/kratos/commit/e169a3e4079b1ef3a18564e0723baf81c44c38ec)), closes [#37](https://github.com/ory/kratos/issues/37):

    This patch implements the account recovery with endpoints such as "Init Account Recovery", a new config value `urls.recovery_ui` and so on. A new identity field has been added `identity.recovery_addresses` containing all recovery addresses.
    
    Additionally, some refactoring was made to DRY code and make naming consistent. As part of dependency upgrades, structured logging has also improved and an audit trail prototype has been added (currently streams to stderr only).


### Unclassified

* docs:fixed broken link (#454) ([22720c6](https://github.com/ory/kratos/commit/22720c6c5e3d31acc175980223183e2336b3751d)), closes [#454](https://github.com/ory/kratos/issues/454)
* Allow kratos to talk to databases in docker-compose quickstart ([#522](https://github.com/ory/kratos/issues/522)) ([8bf9a1a](https://github.com/ory/kratos/commit/8bf9a1ac4162c677a455c2f02de658bd5d146905)):

    All of the databases must exist on the same docker network to allow the
    main kratos applications to communicate with them.

* Fixed typo ([#472](https://github.com/ory/kratos/issues/472)) ([31263b6](https://github.com/ory/kratos/commit/31263b68ab8d81d264e0fa375a915f8f82d70bb3))


# [0.3.0-alpha.1](https://github.com/ory/kratos/compare/v0.2.1-alpha.1...v0.3.0-alpha.1) (2020-05-15)

This release finalizes the OpenID Connect and OAuth2 login, registration, and settings strategy with JsonNet data transformation! From now on, "Sign in with Google, Github, ..." is officially supported! It's also possible to link and unlink these connections using the Self-Service Settings Flow! The documentation has been updated to reflect those changes and includes guides to setting up "Sign in with GitHub" in under 5 Minutes! Please be aware that existing OpenID Connect connections will stop working. Check out the "Breaking Changes" section for more info! Want to learn more? Check [out the docs](https://www.ory.sh/kratos/docs/concepts/credentials/openid-connect-oidc-oauth2)!

We also changed the config validation output, making it easier than ever to find bugs in your config:

```
% kratos --config invalid-config.yml serve
INFO[0001] Config file loaded successfully.              path=invalid-config.yml
ERRO[0001] The provided configuration is invalid and could not be loaded. Check the output below to understand why.  config_file=invalid-config.yml

dsn: <nil>
     ^-- one or more required properties are missing

urls.whitelisted_return_to_urls: https://selfservice.office.example.com
                                 ^-- expected array, but got string

FATA[0001] The services failed to start because the configuration is invalid. Check the output above for more details.
```

This release concludes over 50 commits and 16.000 lines of code changed.



## Breaking Changes

If you upgrade and have existing Social Sign In connections, it will no longer be possible to use them to sign in. Because the oidc strategy was undocumented and not officially released we do not provide an upgrade guide. If you run into this issue on a production system you may need to use SQL to change the config of those identities. If this is a real issue for you that you're unable to solve, please create an issue on GitHub.

This is a breaking change as previous OIDC configurations will not work. Please consult the newly written documentation on OpenID Connect to learn how to use OIDC in your login and registration flows. Since the OIDC feature was not publicly broadcasted yet we have chosen not to provide an upgrade path. If you have issues, please reach out on the forums or slack.



### Bug Fixes

* Access rules of oathkeeper for quick start ([#390](https://github.com/ory/kratos/issues/390)) ([5ed6d05](https://github.com/ory/kratos/commit/5ed6d05b3e13027e4e7ffef1ff10ab2fb948093d)), closes [#389](https://github.com/ory/kratos/issues/389):

    To access `/` as dashboard

* Active field should not be required ([#401](https://github.com/ory/kratos/issues/401)) ([aed2a5c](https://github.com/ory/kratos/commit/aed2a5c3c8e39132df53ae8f0eecfb7924296796)), closes [ory/sdk#14](https://github.com/ory/sdk/issues/14)
* Adopt jsonnet in e2e oidc tests ([5e518fb](https://github.com/ory/kratos/commit/5e518fb2de678e27fcc0e4fff020a4d575f1c109))
* Detect postgres unique constraint ([3a777af](https://github.com/ory/kratos/commit/3a777af00244066a42751005d832e4058ddad8d2))
* Fix oidc strategy jsonnet test ([f6c48bf](https://github.com/ory/kratos/commit/f6c48bf2c64cea1f111e5777de22878e0be5f03c))
* Improve config validation error message ([#414](https://github.com/ory/kratos/issues/414)) ([d1e6896](https://github.com/ory/kratos/commit/d1e6896b3870cad49217ee78f6024a8a5c416f46)), closes [#413](https://github.com/ory/kratos/issues/413)
* Reset request id after parse ([9550205](https://github.com/ory/kratos/commit/9550205a35364473e0f620ef2b2a7eac223dbfff))
* Resolve flaky swagger generation ([#416](https://github.com/ory/kratos/issues/416)) ([ac4acfc](https://github.com/ory/kratos/commit/ac4acfcd7f4e686b5d5c01136158fdf1687329ac))
* Resolve regression issues and bugs ([e6d5369](https://github.com/ory/kratos/commit/e6d53693e146ec6e0d9de2ea366323721af3d8fb))
* Return correct error on id mismatch ([5915f28](https://github.com/ory/kratos/commit/5915f2882d2a481ea357d50b0058093ba3ddb51b))
* Test and implement mapper_url for jsonnet ([40ac3dc](https://github.com/ory/kratos/commit/40ac3dc7b5828ac775055fed3c0bd9ff393e5d86))
* Transaction usage in the identity persister ([#404](https://github.com/ory/kratos/issues/404)) ([7f5072d](https://github.com/ory/kratos/commit/7f5072dc2d4fbf1f48cdf4d199ce4e89683a87b1))

### Chores

* Pin v0.3.0-alpha.1 release commit ([43b693a](https://github.com/ory/kratos/commit/43b693a449bf7cd219eb6901acf36725ace1c41c))

### Code Refactoring

* Adopt new request parser ([ad16cc9](https://github.com/ory/kratos/commit/ad16cc917c8067eb1c4b89ef8192287be1c912c8))
* Dry config and oidc tests ([3e98756](https://github.com/ory/kratos/commit/3e9875612ea895f9b565d34f4d5b0f80d136868f))
* Improve oidc flows and payloads and add e2e tests ([#381](https://github.com/ory/kratos/issues/381)) ([f9a5079](https://github.com/ory/kratos/commit/f9a50790637a848897ba275373bc538728e09f3d)), closes [#387](https://github.com/ory/kratos/issues/387):

    This patch improves the OpenID Connect login and registration user experience by simplifying the network flows and introduces e2e tests using ORY Hydra.

* Move cypress files to test/e2e ([df8e627](https://github.com/ory/kratos/commit/df8e627d81d69682e01ec5670c7088ba564df578))
* Moved scanner json to ory/x ([#412](https://github.com/ory/kratos/issues/412)) ([8a0967d](https://github.com/ory/kratos/commit/8a0967daef4329981b01e6c2b8bb55a8105b4829))
* Partition files and change creds structure ([4f1eb94](https://github.com/ory/kratos/commit/4f1eb946fe1e74e537fc2166fc000180a11c2048)):

    This patch changes the data model of the OpenID Connect strategy. Instead of using an array of providers as the base config item (e.g. `{"type":"oidc","config":[{"provider":"google","subject":"..."}]}`) the credentials config is now an object with a `providers` key: `{"type":"oidc","config":{"providers":[{"provider":"google","subject":"..."}]}}`. This change allows introduction of future changes to the schema without breaking compatibility.

* Replace oidc jsonschema with jsonnet ([2b45e79](https://github.com/ory/kratos/commit/2b45e7953787ad46a6937fe44cb24b6c786eb223)), closes [#380](https://github.com/ory/kratos/issues/380):

    This patch replaces the previous methodology of merging OIDC data which used JSON Schema with Extensions and JSON Path in favor of a much easier to use approach with JSONNet.

* **settings:** Use common request parser ([ad6c402](https://github.com/ory/kratos/commit/ad6c4026e5fd15924dc906cdc9cb6c9de2fc4daa))

### Documentation

* Document account enumeration defenses for oidc ([266329c](https://github.com/ory/kratos/commit/266329cd2969627c823418c1267360193e6342df)), closes [#32](https://github.com/ory/kratos/issues/32)
* Document new oidc jsonnet mapper ([#392](https://github.com/ory/kratos/issues/392)) ([088b30f](https://github.com/ory/kratos/commit/088b30feb6845863e6651489e0c963cde7e10516))
* Document oidc strategy ([#415](https://github.com/ory/kratos/issues/415)) ([9f079f4](https://github.com/ory/kratos/commit/9f079f4f77e54f7be67ac59e13e8ec2696522637)), closes [#409](https://github.com/ory/kratos/issues/409) [#124](https://github.com/ory/kratos/issues/124) [#32](https://github.com/ory/kratos/issues/32)
* Explain that form data is merged with oidc data ([#394](https://github.com/ory/kratos/issues/394)) ([b0dbec4](https://github.com/ory/kratos/commit/b0dbec403c96af41346b6b14fc74b7010e7f8e8a)), closes [#127](https://github.com/ory/kratos/issues/127)
* Fix links in README ([efb6102](https://github.com/ory/kratos/commit/efb610239ac2ae828db26ee84c4c5a83c54c0a6a)), closes [#403](https://github.com/ory/kratos/issues/403)
* Improve social sign in guide ([#393](https://github.com/ory/kratos/issues/393)) ([647ced3](https://github.com/ory/kratos/commit/647ced3084d203e9954ca037afea34316f2080d8)), closes [#49](https://github.com/ory/kratos/issues/49):

    This patch changes the social sign in guide to represent more use cases such as Google and Facebook. Additionally, the example has been updated to work with Jsonnet.
    
    This patch also documents limitations around merging user data from GitHub.

* Improve the identity data model page ([#410](https://github.com/ory/kratos/issues/410)) ([2915b8f](https://github.com/ory/kratos/commit/2915b8faf3530fe7b9d252094c3aeb9fdbe9dd08))
* Include redirect doc in nav ([5aaebff](https://github.com/ory/kratos/commit/5aaebffd8c03e613ec60735536b6ef38d4da39e3)), closes [#406](https://github.com/ory/kratos/issues/406)
* Prepare v0.3.0-alpha.1 ([d6a6f43](https://github.com/ory/kratos/commit/d6a6f432f375018a2dc79d6b60de18455057c25a))
* Ui should show only active form sections ([#395](https://github.com/ory/kratos/issues/395)) ([4db674d](https://github.com/ory/kratos/commit/4db674de14bc50e782321c7bd88ac8077db2bf75))
* Update github templates ([#408](https://github.com/ory/kratos/issues/408)) ([6e646b0](https://github.com/ory/kratos/commit/6e646b033e0d43499bf37579a2f04b726af0e3f7))

### Features

* Add format and lint for JSONNet files ([0a1b244](https://github.com/ory/kratos/commit/0a1b244a6fd2f714a12d101071b3c0f82b4da584)):

    This patch adds two commands `kratos jsonnet format` and `kratos jsonnet lint` that help with formatting and linting JSONNet code.

* Implement oidc settings e2e tests ([919925c](https://github.com/ory/kratos/commit/919925c87be561064300c3981b5a230c6cada4f7))
* Introduce leaklog for debugging oidc map payloads ([238d7a4](https://github.com/ory/kratos/commit/238d7a493566bcc28f08b1b2bf6463f95b100254))
* Write tests and fix bugs for oidc settings ([575a61f](https://github.com/ory/kratos/commit/575a61f58a887fefa6b2917761c06304c94c9892))

### Unclassified

* Format code ([bc7557a](https://github.com/ory/kratos/commit/bc7557a4247ede1fdb4141f2670532aec7cbd456))


# [0.2.1-alpha.1](https://github.com/ory/kratos/compare/v0.2.0-alpha.2...v0.2.1-alpha.1) (2020-05-05)

Resolves a bug in the kratos-selfservice-ui-node application.





### Chores

* Pin v0.2.1-alpha.1 release commit ([16463ea](https://github.com/ory/kratos/commit/16463ead91a009f33373150d10095aa3857b38f4))

### Documentation

* Fix quickstart hero sections ([7c6c439](https://github.com/ory/kratos/commit/7c6c4397bccd2b505fc04cc8d3b0944ceca18982))
* Fix typo in upgrade guide ([a1b1d7c](https://github.com/ory/kratos/commit/a1b1d7c9cbe5fad3b1112a16eced4f3064cfdda0))


# [0.2.0-alpha.2](https://github.com/ory/kratos/compare/v0.1.1-alpha.1...v0.2.0-alpha.2) (2020-05-04)

This is a heavy release with over hundreds of commits and files changed! Let's
take a look at some of the highlights!

**ORY Oathkeeper now optional**

Using ORY Oathkeeper to protect your API is now optional. The basic quickstart
now uses a much simpler set up. Go
[check it out](https://www.ory.sh/kratos/docs/quickstart) now!

**PostgreSQL, MySQL, CockroachDB support now tested and official!**

All three databases now pass acceptance tests and are thus officially supported!

**Self-Service Profile Flow**

The self-service profile flow has been refactored into a more generic flow
allowing users to make modifications to their traits and credentials. Check out
the [docs to learn
more](https://www.ory.sh/kratos/docs/self-service/flows/user-settings-profile-management)
about the flow and it's features.

Please keep in mind that the flow's APIs have changed. We recommend re-reading
the docs!

**Managing Privileged Profile Fields**

Flows such as changing ones profile or primary email address should not be
possible unless the login session is fresh. This prevents your colleague or evil
friend to take over your account while you make yourself a coffee.

ORY Kratos now supports this by redirecting the user to the login screen if
changes to sensitive fields are made. The changes will only be applied after
successful reauthentication.

**Changes to Hooks**

This patch focuses on refactoring how self-service flows terminate and changes
how hooks behave and when they are executed.

Before this patch, it was not clear whether hooks run before or after an
identity is persisted. This caused problems with multiple writes on the HTTP
ResponseWriter and other bugs.

This patch removes certain hooks from after login, registration, and profile
flows. Per default, these flows now respond with an appropriate payload (
redirect for browsers, JSON for API clients) and deprecate the `redirect` hook.
This patch includes documentation which explains how these hooks work now.

Additionally, the documentation was updated. Especially the sections about hooks
have been refactored. The login and user registration docs have been updated to
reflect the latest changes as well.

BREAKING CHANGE: Please remove the `redirect` hook from both login,
registration, and settings after configuration. Please remove the `session` hook
from your login after configuration. Hooks have moved down a level and are now
configured at `selfservice.<login|registration|settings>.<after|before>.hooks`
instead of `selfservice.<login|registration|settings>.<after|before>.hooks`.
Hooks are now identified by `hook:` instead of `job:`. Please rename those
sections accordingly.

We recommend re-reading the
[Hooks Documentation](https://www.ory.sh/kratos/docs/self-service/hooks/index).

**Changing Passwords**

It's now possible to change your password using the Self-Service Settings Flow!
Lean more about this flow
[here](https://www.ory.sh/kratos/docs/self-service/flows/user-settings-profile-management)

**End-To-End Tests**

We added tons of end-to-end and integration tests to find and fix pesky bugs.



## Breaking Changes

Please remove the `redirect` hook from both login,
registration, and settings after configuration. Please remove
the `session` hook from your login after configuration. Hooks
have moved down a level and are now configured at
`selfservice.<login|registration|settings>.<after|before>.hooks`
instead of
`selfservice.<login|registration|settings>.<after|before>.hooks`.
Hooks are now identified by `hook:` instead of `job:`. Please
rename those sections accordingly.

Several profile-related URLs have and payloads been updated. Please consult the most recent documentation.

The payloads of the Profile Management Request API
that previously were set in `{ "methods": { "traits": { ... } }}` have now moved to
`{ "methods": { "profile": { ... } }}`.

This patch introduces a refactor that is needed
for the profile management API to be capable of handling (password,
oidc, ...) credential changes as well.

To implement this, the payloads of the Profile Management Request API
that previously were set in `{"form": {...} }` have now moved to
`{"methods": { "traits": { ... } }}`.

In the future, as more credential updates are handled, there will
be additional keys in the forms key
`{"methods": { "traits": { ... }, "password": { ... } }}`.



### Bug Fixes

* Allow setting new password in profile flow ([3b5fd5c](https://github.com/ory/kratos/commit/3b5fd5ca8c09b2344c0262547f2b387bda362362))
* Automatically append multiStatements parameter to mySQL URI ([#374](https://github.com/ory/kratos/issues/374)) ([39f77bb](https://github.com/ory/kratos/commit/39f77bb29637db048b15c097d869d8828b0d292b))
* **config:** Rename config key stmp to smtp ([#278](https://github.com/ory/kratos/issues/278)) ([ef95811](https://github.com/ory/kratos/commit/ef95811bb891afe3a0ef3b19514f13a56a32ea3b))
* Create pop connection without parsed connection options ([#366](https://github.com/ory/kratos/issues/366)) ([10b6481](https://github.com/ory/kratos/commit/10b6481774aaff42b70b9c6af3ed776ac8f7734c))
* Declare proper vars for setting version ([#383](https://github.com/ory/kratos/issues/383)) ([2fc7556](https://github.com/ory/kratos/commit/2fc7556b70b11e519162326ded0ba2638b6d32df))
* Decouple quickstart scenarios ([#336](https://github.com/ory/kratos/issues/336)) ([17363b3](https://github.com/ory/kratos/commit/17363b312deff8b92fc1b0d158dc70670d5938e5)), closes [#262](https://github.com/ory/kratos/issues/262):

    Creates several docker compose examples which include various
    scenarios of the quickstart.
    
    The regular quickstart guide now works without ORY Oathkeeper
    and uses the standalone mode of the example app instead.
    
    Additionally, the Makefile was improved and now automatically pulls
    required dependencies in the appropriate version.

* **docker:** Throw away build artifacts ([481ec1b](https://github.com/ory/kratos/commit/481ec1ba14480ced39516f6e0c47a40b6a44a631))
* Document Schema API and serve over admin endpoint ([#299](https://github.com/ory/kratos/issues/299)) ([4be417c](https://github.com/ory/kratos/commit/4be417c0ee18622247a15d2803f7f436cfe3c229)), closes [#287](https://github.com/ory/kratos/issues/287)
* Exempt whomai from csrf protection ([#329](https://github.com/ory/kratos/issues/329)) ([31d4065](https://github.com/ory/kratos/commit/31d4065c2b0cbd6c8d2b0031ce8f6f157ff967cf))
* Fix swagger annotation ([#331](https://github.com/ory/kratos/issues/331)) ([5c5c78f](https://github.com/ory/kratos/commit/5c5c78f404a11d5df25cb68584b826b685bf5385)):

    Closes https://github.com/ory/sdk/issues/10

* Move to ory sqa service ([#309](https://github.com/ory/kratos/issues/309)) ([7c244e0](https://github.com/ory/kratos/commit/7c244e0a28a010e56e07d061132dad7a0309ea75))
* Properly annotate error API ([a6f1300](https://github.com/ory/kratos/commit/a6f1300951010e7c862c410e93653f7c02c2e79f))
* Remove unused returnTo ([e64e5b0](https://github.com/ory/kratos/commit/e64e5b0cecceedda29a525f683cbf6070a9ef1eb))
* Resolve docker build permission issues ([f3612e8](https://github.com/ory/kratos/commit/f3612e8f82018bae17c9146d273fe7e82ceb033d))
* Resolve failing test issues ([2e968e5](https://github.com/ory/kratos/commit/2e968e52d3ae3396a3f2e212c0dab22677b4b5fd))
* Resolve linux install script archive naming ([#302](https://github.com/ory/kratos/issues/302)) ([c98b8aa](https://github.com/ory/kratos/commit/c98b8aa4cd3ab881b904e9dc4cdcb6383a8ad09b))
* Resolve NULL value for seen_at ([#259](https://github.com/ory/kratos/issues/259)) ([a7d1e86](https://github.com/ory/kratos/commit/a7d1e86844a9cdd0c58353e1f1e4340dac4260b3)), closes [#244](https://github.com/ory/kratos/issues/244):

    Previously, errorx tests were not executed which caused several bugs.

* Resolve password continuity issues ([56a44fa](https://github.com/ory/kratos/commit/56a44fa33d325eea9fddec4269e34e632310f77b))
* Revert use host volume mount for sqlite ([#272](https://github.com/ory/kratos/issues/272)) ([#285](https://github.com/ory/kratos/issues/285)) ([a7477ab](https://github.com/ory/kratos/commit/a7477ab1db0d986f96e754946607d05888de4c97)):

    This reverts commit 230ab2d83f4d187f410e267c6d68554e82514948.

* Self-service error query parameter name ([#308](https://github.com/ory/kratos/issues/308)) ([be257f5](https://github.com/ory/kratos/commit/be257f5448abaa48e25735a088757f3fd6dc6d22)):

    The query parameter for the self-service errors endpoint was named `id`
    in the API docs, whereas it is the `error` param that is used by the
    handler.

* **session:** Regenerate CSRF Token on principal change ([#290](https://github.com/ory/kratos/issues/290)) ([1527ef4](https://github.com/ory/kratos/commit/1527ef4209b937e2175b60d56efd019f17b33b04)), closes [#217](https://github.com/ory/kratos/issues/217)
* **session:** Whoami endpoint now supports all HTTP methods ([#283](https://github.com/ory/kratos/issues/283)) ([4bf645b](https://github.com/ory/kratos/commit/4bf645b66c7a128182ff55e52fdad7f53d752ce7)), closes [#270](https://github.com/ory/kratos/issues/270)
* Show log in ui only when unauthenticated or forced ([df77310](https://github.com/ory/kratos/commit/df77310ffbe7cfc90fa3bc5dad0450e79c34ebef)), closes [#323](https://github.com/ory/kratos/issues/323)
* **sql:** Rename migrations with same version ([#280](https://github.com/ory/kratos/issues/280)) ([07e46b9](https://github.com/ory/kratos/commit/07e46b9c9e57940bec904d744ffdd272d610a77b)), closes [#279](https://github.com/ory/kratos/issues/279)
* **swagger:** Move nolint,deadcode instructions to own file ([#293](https://github.com/ory/kratos/issues/293)) ([1935510](https://github.com/ory/kratos/commit/1935510ad9b0f387eb3b2e690e31c5313a06883e)):

    Closes https://github.com/ory/docs/pull/279

* Use host volume mount for sqlite ([#272](https://github.com/ory/kratos/issues/272)) ([230ab2d](https://github.com/ory/kratos/commit/230ab2d83f4d187f410e267c6d68554e82514948))
* Use resilient client for HIBP lookup ([#288](https://github.com/ory/kratos/issues/288)) ([735b435](https://github.com/ory/kratos/commit/735b43508392c6966a57907c20caa7cf9df4fc4d)), closes [#261](https://github.com/ory/kratos/issues/261)
* Use semver-regex replacer func ([d5c9a47](https://github.com/ory/kratos/commit/d5c9a47800fc2a55b96c7b9330f68b0a2db328cb))
* Use sqlite tag on make install ([2c82784](https://github.com/ory/kratos/commit/2c82784cd69e0468a72354f6898945032d826306))
* Verified_at field should not be required ([#353](https://github.com/ory/kratos/issues/353)) ([15d5e26](https://github.com/ory/kratos/commit/15d5e268d2ec397f0647d2407d86404c4ee8bfa3)):

    Closes https://github.com/ory/sdk/issues/11
    
    


### Chores

* Pin v0.2.0-alpha.2 release commit ([ab91689](https://github.com/ory/kratos/commit/ab916894b761b18c53e4ed1fd0e42d9f5aa0817c))

### Code Refactoring

* Move docs to this repository ([#317](https://github.com/ory/kratos/issues/317)) ([aa0d726](https://github.com/ory/kratos/commit/aa0d72639ecae3b0649761e6ee881a59b2f3e94e))
* Prepare profile management payloads for credentials ([44493f3](https://github.com/ory/kratos/commit/44493f3ddbb449981576ec317ac45530ca3be14d))
* Rename traits method to profile ([4f1e033](https://github.com/ory/kratos/commit/4f1e0339ecc1efbdfa3d3680ad64b7683e90e447))
* Rework hooks and self-service flow completion ([#349](https://github.com/ory/kratos/issues/349)) ([a7c7fef](https://github.com/ory/kratos/commit/a7c7fef758e843393b0dc1e60bee11b88b8c9b4a)), closes [#348](https://github.com/ory/kratos/issues/348) [#347](https://github.com/ory/kratos/issues/347) [#179](https://github.com/ory/kratos/issues/179) [#51](https://github.com/ory/kratos/issues/51) [#50](https://github.com/ory/kratos/issues/50) [#31](https://github.com/ory/kratos/issues/31):

    This patch focuses on refactoring how self-service flows terminate and
    changes how hooks behave and when they are executed.
    
    Before this patch, it was not clear whether hooks run before or
    after an identity is persisted. This caused problems with multiple
    writes on the HTTP ResponseWriter and other bugs.
    
    This patch removes certain hooks from after login, registration, and profile flows.
    Per default, these flows now respond with an appropriate payload (
    redirect for browsers, JSON for API clients) and deprecate
    the `redirect` hook. This patch includes documentation which explains
    how these hooks work now.
    
    Additionally, the documentation was updated. Especially the sections
    about hooks have been refactored. The login and user registration docs
    have been updated to reflect the latest changes as well.
    
    Also, some other minor, cosmetic, changes to the documentation have been made.


### Documentation

* Add banner kratos ([8a9dfbb](https://github.com/ory/kratos/commit/8a9dfbbd54bac14778cc84ec13326eb1ef80f5b3))
* Add csrf and cookie debug section ([#342](https://github.com/ory/kratos/issues/342)) ([cac2948](https://github.com/ory/kratos/commit/cac2948685ed2a3c3edbc8eb4696bbfb8523dfeb)), closes [#341](https://github.com/ory/kratos/issues/341)
* Add database connection documentation ([#332](https://github.com/ory/kratos/issues/332)) ([4f9e8b0](https://github.com/ory/kratos/commit/4f9e8b00bacda3612db3f48b81fabd562075470a))
* Add HA docs ([2e5c591](https://github.com/ory/kratos/commit/2e5c59158915d1ccbb90363e23f73a09c227b6f7))
* Add hook changes to upgrade guide ([55b5fe0](https://github.com/ory/kratos/commit/55b5fe00c0472f5f6f7408eee76bf9a39318db7e))
* Add info to oidc ([#382](https://github.com/ory/kratos/issues/382)) ([6eeeb5d](https://github.com/ory/kratos/commit/6eeeb5dbe98d2f31fd922d60a35d9d8f81d0b2a8))
* Add more examples to config schema ([#372](https://github.com/ory/kratos/issues/372)) ([ed2ccb9](https://github.com/ory/kratos/commit/ed2ccb935fdcfcb11999996cd582726bba096435)), closes [#345](https://github.com/ory/kratos/issues/345)
* Add quickstart notes for docker debugging ([74f082a](https://github.com/ory/kratos/commit/74f082a407ee73741453ff6a394f47790e79b667))
* Add settings docs and improve flows ([#375](https://github.com/ory/kratos/issues/375)) ([478cd9c](https://github.com/ory/kratos/commit/478cd9c5b5755030307d1f11e9bcbd4e171ee0d6)), closes [#345](https://github.com/ory/kratos/issues/345)
* **concepts:** Fix typo ([a49184c](https://github.com/ory/kratos/commit/a49184c30d9c2ccff5a2d41d3aff61b24e7d2ea9)):

    Closes https://github.com/ory/docs/pull/296

* **concepts:** Properly close code tag ([1c841c2](https://github.com/ory/kratos/commit/1c841c213bdbc79a6aa41e8450444d8d6c1f0284))
* Declare api frontmatter properly ([df7591f](https://github.com/ory/kratos/commit/df7591f7b70c94cfe62042a598eceb36b6a4f29a))
* Document 0.2.0 high-level changes ([9be1064](https://github.com/ory/kratos/commit/9be1064500dd86489b79e1abd9cbf1268b97853a))
* Document multi-tenant set up ([891594d](https://github.com/ory/kratos/commit/891594df488e42ce30a81465f10f2936d152cb55)), closes [#370](https://github.com/ory/kratos/issues/370)
* Fix broken images in quickstart ([52aa4cf](https://github.com/ory/kratos/commit/52aa4cf0b6967108fa58f58b6b151e6f6118bcc9))
* Fix broken link ([bf7843c](https://github.com/ory/kratos/commit/bf7843cd96795a894488a0910529c847cf7eee19)), closes [#327](https://github.com/ory/kratos/issues/327)
* Fix broken link ([c2adc73](https://github.com/ory/kratos/commit/c2adc734a73758d858d50d8738dc2a556110f26c)), closes [#327](https://github.com/ory/kratos/issues/327)
* Fix broken mermaid links ([f24fc1b](https://github.com/ory/kratos/commit/f24fc1bbba234d71098298bcddbba236ac4297f3))
* Fix spelling in quickstart ([#356](https://github.com/ory/kratos/issues/356)) ([3ce6b4a](https://github.com/ory/kratos/commit/3ce6b4a1b0722a96bcbae79b7261616f20741494))
* Improve changelog ([#384](https://github.com/ory/kratos/issues/384)) ([a973ca7](https://github.com/ory/kratos/commit/a973ca7719cd820bb196ec5732c85418528be1d0))
* Improve profile section and restructure nav ([#373](https://github.com/ory/kratos/issues/373)) ([3cc0979](https://github.com/ory/kratos/commit/3cc097934edc81d4c6d853594eed5e68e9e48445)), closes [#345](https://github.com/ory/kratos/issues/345)
* Regenerate and update changelog ([7d4ed98](https://github.com/ory/kratos/commit/7d4ed9873f25b14b59f727002fb08a8b8a4e91a6))
* Regenerate and update changelog ([175b626](https://github.com/ory/kratos/commit/175b626f74b4471e068bd79259c6d479fd6c1a7d))
* Regenerate and update changelog ([e60e2df](https://github.com/ory/kratos/commit/e60e2df5d5cc4c1ef8a6a7f13487d4ebbf54741e))
* Regenerate and update changelog ([41eeb75](https://github.com/ory/kratos/commit/41eeb7587fad864f64c4179ac20847f902c438b3))
* Regenerate and update changelog ([468105a](https://github.com/ory/kratos/commit/468105a6080b861f1e02db3a404f2bac7f2f5eb6))
* Regenerate and update changelog ([8414520](https://github.com/ory/kratos/commit/8414520c995cb2405ed051952357d37ca8111f25))
* Regenerate and update changelog ([85d5866](https://github.com/ory/kratos/commit/85d5866df403b3cfa5566cef5cb983714b395505))
* Regenerate and update changelog ([e8d2d10](https://github.com/ory/kratos/commit/e8d2d1019bbc05fbe4eeaaee7a8eb1e8f2d18cf9))
* Regenerate and update changelog ([4c58b6d](https://github.com/ory/kratos/commit/4c58b6de4a3a39b1e94516abd1ea8ed7b09c1fe4))
* Regenerate and update changelog ([a726eb2](https://github.com/ory/kratos/commit/a726eb202a070038148612f98f12e5d22170d1ec))
* Regenerate and update changelog ([87b47ba](https://github.com/ory/kratos/commit/87b47baa9cdc0175c58ccbb20e67b458ce6a445f))
* Regenerate and update changelog ([537d496](https://github.com/ory/kratos/commit/537d496d2043a17c68f31a8744c39bc76f76314c))
* Regenerate and update changelog ([00e6af9](https://github.com/ory/kratos/commit/00e6af96060ec38059c449ac5e8b3c1df5bb8c95))
* Regenerate and update changelog ([48a2eca](https://github.com/ory/kratos/commit/48a2eca2dcd274ca73d55132efca4a6dae63efdf))
* Regenerate and update changelog ([8a71948](https://github.com/ory/kratos/commit/8a719481b54957681aa21eff5415229f3e5d4bff))
* Regenerate and update changelog ([ad3d510](https://github.com/ory/kratos/commit/ad3d5101dad3c8a2725083c63f155638905b6e8c))
* Regenerate and update changelog ([48bcc70](https://github.com/ory/kratos/commit/48bcc704ed22d8c78620aa3a5f8ecb5b41937759))
* Regenerate and update changelog ([816a55c](https://github.com/ory/kratos/commit/816a55c81a27b53d5bd823392751853b68d3f607))
* Regenerate and update changelog ([4ed74d2](https://github.com/ory/kratos/commit/4ed74d25c45f6e439377329d42cd7ae0acf9d0f1))
* Regenerate and update changelog ([367927e](https://github.com/ory/kratos/commit/367927e716e7c1c6898151a5f14876fb30070dd3))
* Regenerate and update changelog ([38f4019](https://github.com/ory/kratos/commit/38f40190f54264808c7a2716555876d05cdf560f))
* Typo in README.md ([#265](https://github.com/ory/kratos/issues/265)) ([9f865a2](https://github.com/ory/kratos/commit/9f865a2ebace801414b2de17fe2f627d91f23474))
* Update banner url ([292c986](https://github.com/ory/kratos/commit/292c986729d83187f7e77365e11ef74a6f3cadf6))
* Update forum and chat links ([3039191](https://github.com/ory/kratos/commit/30391919d7ea58609dd3cd37db2709495e7abc76))
* Update github templates ([#338](https://github.com/ory/kratos/issues/338)) ([57dbc77](https://github.com/ory/kratos/commit/57dbc77b548383522ca428e899dfde461334216c))
* Update github templates ([#343](https://github.com/ory/kratos/issues/343)) ([eb13dc1](https://github.com/ory/kratos/commit/eb13dc1285cb16515d1c63b99cc389147508a31e))
* Update github templates ([#350](https://github.com/ory/kratos/issues/350)) ([faf2f30](https://github.com/ory/kratos/commit/faf2f305aea1826e3d5f0b2614313920ac2b585b))
* Update github templates ([#351](https://github.com/ory/kratos/issues/351)) ([20ff289](https://github.com/ory/kratos/commit/20ff2890004745231073cd4fd6ef1b37521cde72))
* Update linux install guide ([3b8e549](https://github.com/ory/kratos/commit/3b8e5493a01357f8c442a8a2dc9437712498452c))
* Update linux install guide ([#354](https://github.com/ory/kratos/issues/354)) ([ec49cae](https://github.com/ory/kratos/commit/ec49caec6ddea2c800db0779005bac6da73903e1))
* Update self service reg docs ([#367](https://github.com/ory/kratos/issues/367)) ([4cf0323](https://github.com/ory/kratos/commit/4cf0323095990c5ec25283a01561cb9b8833f9ef)), closes [/github.com/ory/kratos-selfservice-ui-node/blob/489c76d1b0474ee55ef56804b28f54d8718747ba/src/routes/auth.ts#L28](https://github.com//github.com/ory/kratos-selfservice-ui-node/blob/489c76d1b0474ee55ef56804b28f54d8718747ba/src/routes/auth.ts/issues/L28):

    The old links pointed at `/auth/browser/(login|registration)`
    which seems to be outdated now.

* Update user-settings-profile-management.md ([#322](https://github.com/ory/kratos/issues/322)) ([45dc3a5](https://github.com/ory/kratos/commit/45dc3a56c15ae442890313a7dbc784b75644248a))
* Updates issue and pull request templates ([#298](https://github.com/ory/kratos/issues/298)) ([1be738d](https://github.com/ory/kratos/commit/1be738d3f8e9bbc6dae31ffad5d990657a66761c))
* Updates issue and pull request templates ([#313](https://github.com/ory/kratos/issues/313)) ([299063c](https://github.com/ory/kratos/commit/299063caf2fdde40713bae4c36abb3b6fac7271d))
* Updates issue and pull request templates ([#314](https://github.com/ory/kratos/issues/314)) ([d5ae452](https://github.com/ory/kratos/commit/d5ae452a8ce5f641a40e510e82441d4eb8137218))
* Updates issue and pull request templates ([#315](https://github.com/ory/kratos/issues/315)) ([8b68db1](https://github.com/ory/kratos/commit/8b68db140a7fc1c0eaa9318c1759ea9d8d0c27df))
* Use git checkout <tag> in quickstart ([#339](https://github.com/ory/kratos/issues/339)) ([2d2562b](https://github.com/ory/kratos/commit/2d2562b587a69a2891ff29d927cb001e15d75b5d)), closes [#335](https://github.com/ory/kratos/issues/335)

### Features

* Add `dsn: memory` shorthand ([#284](https://github.com/ory/kratos/issues/284)) ([e66a030](https://github.com/ory/kratos/commit/e66a030f7d67dec639121fb23dfc7f1444474c6b)), closes [#228](https://github.com/ory/kratos/issues/228)
* Add and test id hint in reauth flow ([2298f01](https://github.com/ory/kratos/commit/2298f0140e77da870c842daa8eaca274e5d64254)), closes [#323](https://github.com/ory/kratos/issues/323)
* Add cypress e2e tests ([#334](https://github.com/ory/kratos/issues/334)) ([abc0e91](https://github.com/ory/kratos/commit/abc0e91e278f7938b264598ac0c60d18c5a9e8a0))
* Allow configuring same-site for session cookies ([#303](https://github.com/ory/kratos/issues/303)) ([2eb2054](https://github.com/ory/kratos/commit/2eb2054a94281aefa9a0818110d168cc9c052094)), closes [#257](https://github.com/ory/kratos/issues/257):

    It is now possible to set SameSite for the session cookie via the key `security.session.cookie.same_site`.

* **continuity:** Implement request continuity ([135e047](https://github.com/ory/kratos/commit/135e04750b1855ab0db812517c61e292a770ba94)), closes [#304](https://github.com/ory/kratos/issues/304) [#311](https://github.com/ory/kratos/issues/311):

    This patch adds a module which is capable of aborting a request, waiting for
    another option to complete, and then resuming the request again.
    
    This feature makes use of a temporary cookie which keeps track of the
    request state.
    
    This feature is required for several workflows that update privileged
    fields such as passwords, 2fa recovery codes, email addresses.
    
    refactor: rename profile to settings flow
    
    Renames selfservice/profile to settings. The settings flow includes a strategy for managing profile information

* Enable CockroachDB integration ([#260](https://github.com/ory/kratos/issues/260)) ([adc5153](https://github.com/ory/kratos/commit/adc5153410fb4d9f99702d7c73a78aeec8c1e9f1)), closes [#132](https://github.com/ory/kratos/issues/132) [#155](https://github.com/ory/kratos/issues/155)
* Enable continuity management for settings module ([009d755](https://github.com/ory/kratos/commit/009d7558f525168fecf86168de2906088662535e))
* Enable updating auth related traits ([#266](https://github.com/ory/kratos/issues/266)) ([65b88ba](https://github.com/ory/kratos/commit/65b88ba52fb9e6da3c1a65f734352519303327a6)), closes [#243](https://github.com/ory/kratos/issues/243)
* Implement password profile management flow ([a31839a](https://github.com/ory/kratos/commit/a31839a5c33c80500c900fb50d1dd499ab1161a1)), closes [#243](https://github.com/ory/kratos/issues/243)
* Introduce fallbacks for required configs ([#376](https://github.com/ory/kratos/issues/376)) ([b3bcb25](https://github.com/ory/kratos/commit/b3bcb25be6b417647ece2b3dda26d691f8e8d685)), closes [#369](https://github.com/ory/kratos/issues/369) [#352](https://github.com/ory/kratos/issues/352)
* **login:** Forced reauthentication ([#248](https://github.com/ory/kratos/issues/248)) ([344fc9c](https://github.com/ory/kratos/commit/344fc9cddccff958f13249b999a835d3e46a7771)), closes [#243](https://github.com/ory/kratos/issues/243)
* Return 410 when selfservice requests expire ([#289](https://github.com/ory/kratos/issues/289)) ([b414607](https://github.com/ory/kratos/commit/b4146076148d9ff079e9d433f0a90f5bc938650c)), closes [#235](https://github.com/ory/kratos/issues/235)
* Send verification emails on profile update ([#333](https://github.com/ory/kratos/issues/333)) ([1cacc80](https://github.com/ory/kratos/commit/1cacc80c54f92b380ef3752591970cc4dd97085e)), closes [#267](https://github.com/ory/kratos/issues/267)

### Unclassified

* u ([0b6fa48](https://github.com/ory/kratos/commit/0b6fa48e90fa0c50b9c26bae034eb1662c855d69))
* u ([03fa4f0](https://github.com/ory/kratos/commit/03fa4f05363aa1f38fe45730317375ce380cfa31))
* u ([a3dfd9d](https://github.com/ory/kratos/commit/a3dfd9d15e1f7287558b85c3a4f23d02444b0bf4))
* u ([616aa0f](https://github.com/ory/kratos/commit/616aa0f0cf3d662b48fcaa02715e02e854e05581))
* fix:add graceful shutdown to courier handler (#296) ([235d784](https://github.com/ory/kratos/commit/235d784b7f8bf38859d15d68c37b089fc9371195)), closes [#296](https://github.com/ory/kratos/issues/296) [#295](https://github.com/ory/kratos/issues/295):

    Courier would not stop with the provided Background handler.
    This changes the methods of Courier so that the graceful package can be
    used in the same way as the http endpoints can be used.

* fix(sql) change courier body to text field (#276) ([ed5268d](https://github.com/ory/kratos/commit/ed5268d539b2a28f5367e8ba2e2e6bd3a605ce5b)), closes [#276](https://github.com/ory/kratos/issues/276) [#269](https://github.com/ory/kratos/issues/269)
* Make format ([b85e5af](https://github.com/ory/kratos/commit/b85e5af2e29f9ca3bc3341ba4f2b1b338b441398))


# [0.1.1-alpha.1](https://github.com/ory/kratos/compare/v0.1.0-alpha.6...v0.1.1-alpha.1) (2020-02-18)

docs: Regenerate and update changelog





### Bug Fixes

* Add verify return to address ([#252](https://github.com/ory/kratos/issues/252)) ([64ab9e5](https://github.com/ory/kratos/commit/64ab9e510e6b65f9dd16fdfaadfd24785dab0c93))
* Clean up docker quickstart ([#255](https://github.com/ory/kratos/issues/255)) ([7f0996b](https://github.com/ory/kratos/commit/7f0996b99646e57136f20c04a77a6f682eecdd9c))
* Resolve several verification problems ([#253](https://github.com/ory/kratos/issues/253)) ([30d4632](https://github.com/ory/kratos/commit/30d46326373cf038b600ee07db3e95ce6d94ab12))
* Update verify URLs ([#258](https://github.com/ory/kratos/issues/258)) ([5d4f909](https://github.com/ory/kratos/commit/5d4f9099b5c61ff9572ad23a3eb9c0e0025d92da))

### Code Refactoring

* Support context-based SQL transactions ([#254](https://github.com/ory/kratos/issues/254)) ([6ace1ee](https://github.com/ory/kratos/commit/6ace1ee2070c35b0da3e36dcd5417ff70a4ff9cb))

### Documentation

* Regenerate and update changelog ([a125822](https://github.com/ory/kratos/commit/a1258221a1fef82cc525be7b1042e91e2d20b1eb))
* Regenerate and update changelog ([b3a8220](https://github.com/ory/kratos/commit/b3a822035509ec2c9fb04037b2088ce6df8191da))
* Regenerate and update changelog ([a141b30](https://github.com/ory/kratos/commit/a141b309a1fc22bc45d70a090869fdee198a065e))
* Regenerate and update changelog ([7e12e20](https://github.com/ory/kratos/commit/7e12e20be0fa61a2f41a416a3edcd2b522165196))
* Regenerate and update changelog ([3c1c67b](https://github.com/ory/kratos/commit/3c1c67b31a54dd8d5fceac9449d305db82ff8844))
* Regenerate and update changelog ([ee07937](https://github.com/ory/kratos/commit/ee07937d5e797f0217c86946da42d0070ca7c250))


# [0.1.0-alpha.6](https://github.com/ory/kratos/compare/v0.1.0-alpha.5...v0.1.0-alpha.6) (2020-02-16)

feat: Add verification to quickstart (#251)






### Bug Fixes

* Adapt quickstart to verify changes ([#247](https://github.com/ory/kratos/issues/247)) ([24eceb7](https://github.com/ory/kratos/commit/24eceb7147cef1081ac1ad969713ca1bc36229cb))
* Gracefully handle selfservice request expiry ([#242](https://github.com/ory/kratos/issues/242)) ([4421e6b](https://github.com/ory/kratos/commit/4421e6bde494fbe9672251cf813a39e3031bf3fd)), closes [#233](https://github.com/ory/kratos/issues/233)
* Set AuthenticatedAt in session issuer hook ([#246](https://github.com/ory/kratos/issues/246)) ([29c83fa](https://github.com/ory/kratos/commit/29c83fa986c612fb17e13fe9415f7836062159d2)), closes [#224](https://github.com/ory/kratos/issues/224)
* **swagger:** Sanitize before validate ([c72f140](https://github.com/ory/kratos/commit/c72f140083e94f3a47ee2398c56d188e6d4edcb4))
* **swagger:** Use correct annotations for request methods ([#237](https://github.com/ory/kratos/issues/237)) ([8473c85](https://github.com/ory/kratos/commit/8473c85d8282b27375b53babbbc79046d407b3fb)), closes [#234](https://github.com/ory/kratos/issues/234)

### Code Refactoring

* Move to ory/jsonschema/v3 everywhere ([#229](https://github.com/ory/kratos/issues/229)) ([61f5c1d](https://github.com/ory/kratos/commit/61f5c1d3d896841b08deb08c42ba896118e3fc71)), closes [#225](https://github.com/ory/kratos/issues/225)

### Documentation

* Regenerate and update changelog ([922cf0f](https://github.com/ory/kratos/commit/922cf0f3d7ec8860d13aff3b88849a71fb59e2c9))
* Regenerate and update changelog ([e097c23](https://github.com/ory/kratos/commit/e097c23d8b4902a9013f3a8fa9a397033a92fb88))
* Regenerate and update changelog ([2d1685f](https://github.com/ory/kratos/commit/2d1685f4f4235e9293b1ab79e67050042787c6e9))
* Regenerate and update changelog ([f8964e9](https://github.com/ory/kratos/commit/f8964e9e5c442f75ba501ce7cfcb18916b781dc1))
* Regenerate and update changelog ([92b8001](https://github.com/ory/kratos/commit/92b80013c98e9556138eff04aa24dc696b8d6128))
* Regenerate and update changelog ([d7083ab](https://github.com/ory/kratos/commit/d7083ab9fb8e8172707cae3ac4a8a183f0c25903))
* Regenerate and update changelog ([c4547dc](https://github.com/ory/kratos/commit/c4547dc53ecf167b63e5d7d3b6764535bd86fa5a))
* Regenerate and update changelog ([d8d8bba](https://github.com/ory/kratos/commit/d8d8bbae055e2220023a45b832d2435984191029))
* Regenerate and update changelog ([b012ed9](https://github.com/ory/kratos/commit/b012ed9ce1f4fd0ece2e3463e952711b4380f4a4))

### Features

* Add disabled flag to identifier form fields ([#238](https://github.com/ory/kratos/issues/238)) ([a2178bd](https://github.com/ory/kratos/commit/a2178bdbbe20798a3e1e3fb5ed7b44afc187c640)), closes [#227](https://github.com/ory/kratos/issues/227)
* Add verification to quickstart ([#251](https://github.com/ory/kratos/issues/251)) ([172dc87](https://github.com/ory/kratos/commit/172dc87d22f925668c21da1b3b581156e01d45a4))
* Implement email verification ([#245](https://github.com/ory/kratos/issues/245)) ([eed00f4](https://github.com/ory/kratos/commit/eed00f4b328c173057455980ce0e1aad909c278f)), closes [#27](https://github.com/ory/kratos/issues/27)
* Improve password validation strategy ([#231](https://github.com/ory/kratos/issues/231)) ([256fad3](https://github.com/ory/kratos/commit/256fad37164c81cc44c35e77b99911996722a86a))


# [0.1.0-alpha.5](https://github.com/ory/kratos/compare/v0.1.0-alpha.4...v0.1.0-alpha.5) (2020-02-06)

docs: Regenerate and update changelog





### Documentation

* Regenerate and update changelog ([e87e9c9](https://github.com/ory/kratos/commit/e87e9c9ec9cf55351439ab16a778f3ea303ec646))
* Regenerate and update changelog ([d6f0794](https://github.com/ory/kratos/commit/d6f0794d53b6e7d6d9e3bc63a77d402e43a29bed))
* Regenerate and update changelog ([eb7326c](https://github.com/ory/kratos/commit/eb7326c98c2d5e87a8ac3cd9f2efb43f2552164a))

### Features

* Redirect to new auth session on expired auth sessions ([#230](https://github.com/ory/kratos/issues/230)) ([b477ecd](https://github.com/ory/kratos/commit/b477ecd47de33a9a45159a298ac288c4ad5a0b55)), closes [#96](https://github.com/ory/kratos/issues/96)


# [0.1.0-alpha.4](https://github.com/ory/kratos/compare/v0.1.0-alpha.3...v0.1.0-alpha.4) (2020-02-06)

ci: Bump ory/sdk to 0.1.22




### Continuous Integration

* Bump ory/sdk to 0.1.22 ([c0d0edf](https://github.com/ory/kratos/commit/c0d0edf1f369ecaeb28d1337930b16222b97337f))

### Documentation

* Regenerate and update changelog ([f02afb3](https://github.com/ory/kratos/commit/f02afb3fed310f7fe9c5e6f7df34dfc9738018ad))


# [0.1.0-alpha.3](https://github.com/ory/kratos/compare/v0.1.0-alpha.2...v0.1.0-alpha.3) (2020-02-06)

ci: Bump ory/sdk orb




### Continuous Integration

* Bump ory/sdk orb ([65b2ca0](https://github.com/ory/kratos/commit/65b2ca0b8a1da8249aa4b4cb439b1d63aecaf8e0))


# [0.1.0-alpha.2](https://github.com/ory/kratos/compare/v0.1.0-alpha.1...v0.1.0-alpha.2) (2020-02-03)

docs: Regenerate and update changelog





### Bug Fixes

* Add paths to sqa middleware ([#216](https://github.com/ory/kratos/issues/216)) ([130c9c2](https://github.com/ory/kratos/commit/130c9c242e1434074d9fa4970b60ccb9b4f2ff47))
* **daemon:** Register error routes on admin port ([#226](https://github.com/ory/kratos/issues/226)) ([decd8d8](https://github.com/ory/kratos/commit/decd8d8ef8dac3674938b564962238195ffaf017))
* Set csrf token on public endpoints ([d0b15ae](https://github.com/ory/kratos/commit/d0b15aeca991a94771715a6eabd4a956be41ceda))

### Documentation

* Introduce upgrade guide ([736a3b1](https://github.com/ory/kratos/commit/736a3b19bfe35cc699dea508b4bdb56b3302ba7e))
* Prepare ecosystem automation ([7013b6c](https://github.com/ory/kratos/commit/7013b6c9a856e05f6ad385eb8ce36c5faf342f5a))
* Regenerate and update changelog ([f39b942](https://github.com/ory/kratos/commit/f39b9422d79d3e69304f013c85f3850337ca1730))
* Regenerate and update changelog ([c121601](https://github.com/ory/kratos/commit/c121601b5c741c846d9c478b01aabb9907d81b95))
* Regenerate and update changelog ([a947d55](https://github.com/ory/kratos/commit/a947d554ba2be94f334568a4e77a501742ca95af))
* Regenerate and update changelog ([8ba2044](https://github.com/ory/kratos/commit/8ba2044ebb369ea741f99c65163f650c607e6c07))
* Regenerate and update changelog ([9c023e1](https://github.com/ory/kratos/commit/9c023e1a9288f156c79ea78b3a979d0fefab8825))
* Regenerate and update changelog ([1e855a9](https://github.com/ory/kratos/commit/1e855a9e0ebd232ba2b07dc4a8bb79b84cd548e6))
* Regenerate and update changelog ([01ce3a8](https://github.com/ory/kratos/commit/01ce3a891edd84174694111637dd44fe65e48b37))
* Updates issue and pull request templates ([#222](https://github.com/ory/kratos/issues/222)) ([4daae88](https://github.com/ory/kratos/commit/4daae88af527018e9ee4e1e9717a07dffab427fe))

### Features

* Override semantic config ([#220](https://github.com/ory/kratos/issues/220)) ([9b4214b](https://github.com/ory/kratos/commit/9b4214bf5eac81a92513e04dc5f862b93df86935))

### Unclassified

* Update CHANGELOG [ci skip] ([ce9390c](https://github.com/ory/kratos/commit/ce9390c27f61966b7ed23244400215c2218bbc0b))
* refactor!: Improve user-facing error APIs (#219) ([7d4054f](https://github.com/ory/kratos/commit/7d4054f4363da7bc0e943e7abfbd0c804eb7f0c1)), closes [#219](https://github.com/ory/kratos/issues/219) [#204](https://github.com/ory/kratos/issues/204):

    This patch refactors user-facing error APIs:
    
    - The `/errors` endpoint moved to `/self-service/errors`
    - The endpoint is now available at both the Admin and Public API. The Public API requires CSRF Token match or a 403 error will be returned.
    - The Public API endpoint no longer returns 404 errors but 403 instead.
    - The response payload changed. What was `[{"code": ...}]` is now `{"id": "...", "errors": [{"code": ...}]}`
    
    This patch requires running `kratos migrate sql` as a new column (`csrf_token`) has been added to the user-facing error store.

* Update CHANGELOG [ci skip] ([c368a11](https://github.com/ory/kratos/commit/c368a11523a9bcb30a830d65c11e4f6d27417a78))


# [0.1.0-alpha.1](https://github.com/ory/kratos/compare/v0.0.3-alpha.15...v0.1.0-alpha.1) (2020-01-31)

docs: Updates issue and pull request templates (#215)

Signed-off-by: aeneasr <aeneas@ory.sh>




### Documentation

* Updates issue and pull request templates ([#215](https://github.com/ory/kratos/issues/215)) ([10c45f2](https://github.com/ory/kratos/commit/10c45f23e11abba1ca82095548769cd923a6a6a6))


# [0.0.3-alpha.15](https://github.com/ory/kratos/compare/v0.0.3-alpha.14...v0.0.3-alpha.15) (2020-01-31)

Update permissions in SQLite Dockerfile





### Unclassified

* Update permissions in SQLite Dockerfile ([1266e53](https://github.com/ory/kratos/commit/1266e533ac9a1f6ec375980cadce9755998f9fe6))


# [0.0.3-alpha.14](https://github.com/ory/kratos/compare/v0.0.3-alpha.13...v0.0.3-alpha.14) (2020-01-31)

Update README.md




### Unclassified

* Update README.md ([db8d65b](https://github.com/ory/kratos/commit/db8d65bf136223df546aa27f1ecff03d01159624))


# [0.0.3-alpha.13](https://github.com/ory/kratos/compare/v0.0.3-alpha.12...v0.0.3-alpha.13) (2020-01-31)

Allow mounting SQLite in /home/ory/sqlite (#212)






### Unclassified

* Allow mounting SQLite in /home/ory/sqlite (#212) ([2fe8c0f](https://github.com/ory/kratos/commit/2fe8c0f752e870028d68e8593a46c0902f673a65)), closes [#212](https://github.com/ory/kratos/issues/212)


# [0.0.3-alpha.11](https://github.com/ory/kratos/compare/v0.0.3-alpha.10...v0.0.3-alpha.11) (2020-01-31)

Clean up cmd and resolve packr2 issues (#211)

This patch addresses issues with the build pipeline caused by an invalid import. Profiling was also added.




### Unclassified

* Clean up cmd and resolve packr2 issues (#211) ([2e43ec0](https://github.com/ory/kratos/commit/2e43ec09e9d6aa572c4351bfef4c59dfc43f2343)), closes [#211](https://github.com/ory/kratos/issues/211):

    This patch addresses issues with the build pipeline caused by an invalid import. Profiling was also added.

* Improve field types (#209) ([aeefa93](https://github.com/ory/kratos/commit/aeefa93bf0427685f6ffadad5abfaa1fc26ce074)), closes [#209](https://github.com/ory/kratos/issues/209)
* Update CHANGELOG [ci skip] ([fc32207](https://github.com/ory/kratos/commit/fc32207482861b8f989cb1d6fe5d96bf34c54e4c))


# [0.0.3-alpha.10](https://github.com/ory/kratos/compare/v0.0.3-alpha.9...v0.0.3-alpha.10) (2020-01-31)

Update README




### Unclassified

* Update README ([35a310d](https://github.com/ory/kratos/commit/35a310d6de52fa74ad8728b1df67f88ce900aa61))
* Update CHANGELOG [ci skip] ([3c98745](https://github.com/ory/kratos/commit/3c987455a44b9e12e31619ba9f447e8a5feafc38))
* Update CHANGELOG [ci skip] ([c1c01df](https://github.com/ory/kratos/commit/c1c01df3a04fc7988bf847e3f31680112f5a642d))


# [0.0.3-alpha.7](https://github.com/ory/kratos/compare/v0.0.3-alpha.5...v0.0.3-alpha.7) (2020-01-30)

Use correct project root in Dockerfile





### Unclassified

* Use correct project root in Dockerfile ([3528758](https://github.com/ory/kratos/commit/352875878c74d15b522336b518df339c8ad48e49))
* Update CHANGELOG [ci skip] ([e78bbbe](https://github.com/ory/kratos/commit/e78bbbecbd9515c02e447efc3208599bf27ef85c))


# [0.0.3-alpha.5](https://github.com/ory/kratos/compare/v0.0.3-alpha.4...v0.0.3-alpha.5) (2020-01-30)

ci: Resolve final docker build issues (#210)






### Continuous Integration

* Resolve final docker build issues ([#210](https://github.com/ory/kratos/issues/210)) ([d703a1e](https://github.com/ory/kratos/commit/d703a1e328808df6761a9da5866a3f4df4c7923e))

### Unclassified

* Update CHANGELOG [ci skip] ([ebb1744](https://github.com/ory/kratos/commit/ebb1744d68b8a416774477182b1e2b2cd8bdfc43))
* Add libmusl to binary output ([e9b8445](https://github.com/ory/kratos/commit/e9b8445f2fc8e9e571ec0b8480cc70fe3251db9e))


# [0.0.3-alpha.4](https://github.com/ory/kratos/compare/v0.0.3-alpha.3...v0.0.3-alpha.4) (2020-01-30)

Update CHANGELOG [ci skip]





### Unclassified

* Update CHANGELOG [ci skip] ([018c229](https://github.com/ory/kratos/commit/018c229c4cff62e47c1154ca29ab9c70766a43e5))
* Add and use ory docker user ([cccbe09](https://github.com/ory/kratos/commit/cccbe09cc6e2ad72847206d46afe3e0bf7f79ab5))
* Update CHANGELOG [ci skip] ([0e436e5](https://github.com/ory/kratos/commit/0e436e57f79692c4c6e0a0c25f48a41654afcda1))
* Update goreleaser changelog filters ([7e5af97](https://github.com/ory/kratos/commit/7e5af97fded9f56a3cc9d1d92a7726e7b613b586))
* Update CHANGELOG [ci skip] ([4387503](https://github.com/ory/kratos/commit/438750326c5d6ad1569802c82806e831f43e785e))


# [0.0.3-alpha.2](https://github.com/ory/kratos/compare/v0.0.3-alpha.1...v0.0.3-alpha.2) (2020-01-30)

Resolve goreleaser build issues (#208)







### Unclassified

* Resolve goreleaser build issues (#208) ([d59a08a](https://github.com/ory/kratos/commit/d59a08a0ef680a984352d7f5068626cc1958185a)), closes [#208](https://github.com/ory/kratos/issues/208)


# [0.0.3-alpha.1](https://github.com/ory/kratos/compare/v0.0.1-alpha.9...v0.0.3-alpha.1) (2020-01-30)

Update CHANGELOG [ci skip]





### Unclassified

* Update CHANGELOG [ci skip] ([49e09ea](https://github.com/ory/kratos/commit/49e09eaaab1fc681f9330e12ce6e5483c62ee9e3))
* Take form field orders from JSON Schema (#205) ([a880f0d](https://github.com/ory/kratos/commit/a880f0ddb52fb4366acf8fbd80aabaa9843445a9)), closes [#205](https://github.com/ory/kratos/issues/205) [#176](https://github.com/ory/kratos/issues/176)
* Update CHANGELOG [ci skip] ([ff52bbb](https://github.com/ory/kratos/commit/ff52bbb264542b48658679bf5563b0f3b7ad73c7))
* Adapt quickstart docker compose config (#207) ([e532583](https://github.com/ory/kratos/commit/e532583b35a22cb39bbab0101bf86c0bf01b1088)), closes [#207](https://github.com/ory/kratos/issues/207)
* Update CHANGELOG [ci skip] ([7f4800b](https://github.com/ory/kratos/commit/7f4800b07556e688ba0cd551438876b3bf23ace5))
* Update CHANGELOG [ci skip] ([1b2c3f6](https://github.com/ory/kratos/commit/1b2c3f645e64848e7fba6656aa730c7e346ed75d))
* Rework public and admin fetch strategy (#203) ([99aa169](https://github.com/ory/kratos/commit/99aa1693e758f706f264c2439594e2be37ae9bc6)), closes [#203](https://github.com/ory/kratos/issues/203) [#122](https://github.com/ory/kratos/issues/122)
* Update CHANGELOG [ci skip] ([1cea427](https://github.com/ory/kratos/commit/1cea42780a95d4ebf5520e1c1803fb13ef596d52))
* ss/profile: Use request ID as query param everywhere (#202) ([ed32b14](https://github.com/ory/kratos/commit/ed32b14f8ea972cf549480f29cbf1b95d010789c)), closes [#202](https://github.com/ory/kratos/issues/202) [#190](https://github.com/ory/kratos/issues/190)
* Update CHANGELOG [ci skip] ([a392027](https://github.com/ory/kratos/commit/a3920278129399ce576c5336c2e50dd015b8f2f8))
* Update HTTP routes for a consistent API naming (#199) ([9ed4bda](https://github.com/ory/kratos/commit/9ed4bda9f0b0d45e8ac0de0c42b78f717f3d92f3)), closes [#199](https://github.com/ory/kratos/issues/199) [#195](https://github.com/ory/kratos/issues/195)


# [0.0.1-alpha.9](https://github.com/ory/kratos/compare/v0.0.1-alpha.11...v0.0.1-alpha.9) (2020-01-29)

ci: Bump goreleaser orb




### Continuous Integration

* Bump goreleaser orb ([29cd754](https://github.com/ory/kratos/commit/29cd754d33ec2f800730bd007f17fc0ce53a51eb))


# [0.0.2-alpha.1](https://github.com/ory/kratos/compare/v0.0.1-alpha.8...v0.0.2-alpha.1) (2020-01-29)

Use correct build archive for homebrew




### Unclassified

* Use correct build archive for homebrew ([74ac29f](https://github.com/ory/kratos/commit/74ac29f43f2937cad9065ad3c03cf3cf909cff42))


# [0.0.1-alpha.6](https://github.com/ory/kratos/compare/v0.0.1-alpha.5...v0.0.1-alpha.6) (2020-01-29)

ci: Bump goreleaser orb




### Continuous Integration

* Bump goreleaser orb ([018c94c](https://github.com/ory/kratos/commit/018c94ccc9e833f28f827fd10d607a7a1c954ac5))


# [0.0.1-alpha.5](https://github.com/ory/kratos/compare/v0.0.1-alpha.3...v0.0.1-alpha.5) (2020-01-29)

ci: Bump goreleaser dependency





### Continuous Integration

* Bump goreleaser dependency ([ec49bfb](https://github.com/ory/kratos/commit/ec49bfb4b636a72e51d3a68521ba047f97d4c5e6))

### Unclassified

* Resolve build issues with CGO (#196) ([298f4ea](https://github.com/ory/kratos/commit/298f4ea85b3e7405929f481b756efe8c5c133479)), closes [#196](https://github.com/ory/kratos/issues/196)
* ss/password: Make form fields an array (#197) ([6cb0058](https://github.com/ory/kratos/commit/6cb005860755ff897ad847f09af50bc911bbc7f0)), closes [#197](https://github.com/ory/kratos/issues/197) [#186](https://github.com/ory/kratos/issues/186)


# [0.0.1-alpha.3](https://github.com/ory/kratos/compare/v0.0.1-alpha.2...v0.0.1-alpha.3) (2020-01-28)

ci: Only compile goarmv7





### Continuous Integration

* Only compile goarmv7 ([d8e7ec7](https://github.com/ory/kratos/commit/d8e7ec788d1b43bcbbe221becde3432fdbf28e9b))


# [0.0.1-alpha.2](https://github.com/ory/kratos/compare/v0.0.1-alpha.1...v0.0.1-alpha.2) (2020-01-28)

ci: Use CGO_ENABLED=1





### Continuous Integration

* Use CGO_ENABLED=1 ([bf0060c](https://github.com/ory/kratos/commit/bf0060c0296c421af0083f38044b1444dd6e7bc9))


# [0.0.1-alpha.1](https://github.com/ory/kratos/compare/ab6f24a85276bdd8687f2fc06390c1279892b005...v0.0.1-alpha.1) (2020-01-28)

session: Inject Identity Traits JSON Schema

Closes #189





### Documentation

* Present ORY Hive to the world ([#107](https://github.com/ory/kratos/issues/107)) ([7883589](https://github.com/ory/kratos/commit/78835897664a5ab5564751fc9f04172f7d20d572))
* Updates issue and pull request templates ([0441dff](https://github.com/ory/kratos/commit/0441dffe0c439cc54214bf9ee8f4a4bd25206999))
* Updates issue and pull request templates ([#174](https://github.com/ory/kratos/issues/174)) ([ad405e9](https://github.com/ory/kratos/commit/ad405e9037e2db2910a012f414556fea672e732a))
* Updates issue and pull request templates ([#39](https://github.com/ory/kratos/issues/39)) ([daf5aa8](https://github.com/ory/kratos/commit/daf5aa89c717de6176ee25119d2e751ae2ef6558))
* Updates issue and pull request templates ([#40](https://github.com/ory/kratos/issues/40)) ([f5907f3](https://github.com/ory/kratos/commit/f5907f3f248e05511b19ff6dc15bf6f60f8b62da))
* Updates issue and pull request templates ([#59](https://github.com/ory/kratos/issues/59)) ([8c5612c](https://github.com/ory/kratos/commit/8c5612c080e5b7531028b778b86cc4cde2abd516))
* Updates issue and pull request templates ([#7](https://github.com/ory/kratos/issues/7)) ([a1220ba](https://github.com/ory/kratos/commit/a1220ba1e950498a6e9594266dc730c9a8731b49))
* Updates issue and pull request templates ([#8](https://github.com/ory/kratos/issues/8)) ([c56798a](https://github.com/ory/kratos/commit/c56798ab29e72ed308fff840e3b1b98ead19aea6))

### Unclassified

* Remove redundant return statement ([7c2989f](https://github.com/ory/kratos/commit/7c2989f52c090bb9900380b4ec74e04d9c37a441))
* ss/oidc: Remove obsolete request field from form (#193) ([59671ba](https://github.com/ory/kratos/commit/59671badb63009e2440b14868b622adc75cf882f)), closes [#193](https://github.com/ory/kratos/issues/193) [#180](https://github.com/ory/kratos/issues/180)
* strategy/oidc: Allow multiple OIDC Connections (#191) ([8984831](https://github.com/ory/kratos/commit/898483137ff9dc47d65750cd94a973f2e5bee770)), closes [#191](https://github.com/ory/kratos/issues/191) [#114](https://github.com/ory/kratos/issues/114)
* Improve Docker Compose Quickstart (#187) ([9459072](https://github.com/ory/kratos/commit/945907297ded4b18e1bd0e7c9824a975ac7395c6)), closes [#187](https://github.com/ory/kratos/issues/187) [#188](https://github.com/ory/kratos/issues/188)
* selfservice/password: Remove request field and ensure method is set (#183) ([e035adc](https://github.com/ory/kratos/commit/e035adc233198e9b5c9a6e08d442fb5fb3290816)), closes [#183](https://github.com/ory/kratos/issues/183)
* Add tests and fixtures for the config JSON Schema (#171) ([ede9c0e](https://github.com/ory/kratos/commit/ede9c0e9c45ee91e60587311dc18a0a04ff62295)), closes [#171](https://github.com/ory/kratos/issues/171)
* Add example values for config JSON Schema ([12ba728](https://github.com/ory/kratos/commit/12ba7283bf879cd7682d3017c3b3f12e49029d6b))
* Replace `url` with `uri` format in config JSON Schema ([68eddef](https://github.com/ory/kratos/commit/68eddef0cf179bf61abb999d84d2af19c3703c80))
* Replace number with integer in config JSON Schema (#177) ([9eff6fd](https://github.com/ory/kratos/commit/9eff6fd09720b11acae089ebfcaf37288bc031b0)), closes [#177](https://github.com/ory/kratos/issues/177)
* Improve `--dev` flag (#167) ([9b61ee1](https://github.com/ory/kratos/commit/9b61ee10bbb4710d6694addfa60c04313855516f)), closes [#167](https://github.com/ory/kratos/issues/167) [#162](https://github.com/ory/kratos/issues/162)
* Add goreleaser orb task (#170) ([5df0def](https://github.com/ory/kratos/commit/5df0defefc95ced289a9c59a4f5deb3c67446e75)), closes [#170](https://github.com/ory/kratos/issues/170)
* Add changelog generation task (#169) ([edd937c](https://github.com/ory/kratos/commit/edd937c21b7e37b2f2e926f0fe62c2e7d4a7d608)), closes [#169](https://github.com/ory/kratos/issues/169)
* Adopt new SDK pipeline (#168) ([21d9b6d](https://github.com/ory/kratos/commit/21d9b6d27adbfe8504fb46ac95952e7cea239085)), closes [#168](https://github.com/ory/kratos/issues/168)
* Add docker-compose quickstart (#153) ([e096190](https://github.com/ory/kratos/commit/e096190e778f22573e30f35e85b7cf147caf851b)), closes [#153](https://github.com/ory/kratos/issues/153)
* Update README (#160) ([533775b](https://github.com/ory/kratos/commit/533775ba78a2c1758c47ed093da6acc18ab951c2)), closes [#160](https://github.com/ory/kratos/issues/160)
* Separate post register/login hooks (#150) ([f4b7812](https://github.com/ory/kratos/commit/f4b78122d9cbe4dcc05b4fd52d94a2d9f1b16eb2)), closes [#150](https://github.com/ory/kratos/issues/150) [#149](https://github.com/ory/kratos/issues/149)
* Update README badges ([4f7838e](https://github.com/ory/kratos/commit/4f7838e69181c5a10e27cde1e241779e4e724909))
* Bump go-acc and resolve test issues (#154) ([15b1b63](https://github.com/ory/kratos/commit/15b1b630c5363e0e1afbed53285b3f39098c0792)), closes [#154](https://github.com/ory/kratos/issues/154) [#152](https://github.com/ory/kratos/issues/152) [#151](https://github.com/ory/kratos/issues/151):

    Due to a bug in `go-acc`, tests would not run if `-tags sqlite` was supplied as a go tool argument to `go-acc`. This patch resolves that issue and also includes several test patches from previous community PRs and some internal test issues.

* Add ORY Kratos banner to README (#145) ([23b824f](https://github.com/ory/kratos/commit/23b824f7f99efbc23787508c03506e73a3240a2a)), closes [#145](https://github.com/ory/kratos/issues/145)
* Replace DBAL layer with gobuffalo/pop (#130) ([21d08b8](https://github.com/ory/kratos/commit/21d08b84560230d8a063a418a74efcf53c146872)), closes [#130](https://github.com/ory/kratos/issues/130):

    This is a major refactoring of the internal DBAL. After a successful proof of concept and evaluation of gobuffalo/pop, we believe this to be the best DBAL for Go at the moment. It abstracts a lot of boilerplate code away.
    
    As with all sophisticated DBALs, pop too has its quirks. There are several issues that have been discovered during testing and adoption: https://github.com/gobuffalo/pop/issues/136 https://github.com/gobuffalo/pop/issues/476 https://github.com/gobuffalo/pop/issues/473 https://github.com/gobuffalo/pop/issues/469 https://github.com/gobuffalo/pop/issues/466
    
    However, the upside of moving much of the hard database/sql plumbing into another library cleans up the code base significantly and reduces complexity.
    
    As part of this change, the "ephermal" DBAL ("in memory") will be removed and sqlite will be used instead. This further reduces complexity of the code base and code-duplication.
    
    To support sqlite, CGO is required, which means that we need to run tests with `go test -tags sqlite` on a machine that has g++ installed. This also means that we need a Docker Image with `alpine` as opposed to pure `scratch`. While this is certainly a downside, the upside of less maintenance and "free" support for SQLite, PostgreSQL, MySQL, and CockroachDB simply outweighs any downsides that come with CGO.

* Replace local deps with remote ones ([8605e45](https://github.com/ory/kratos/commit/8605e454cf538e047c5a9c3479372892d6b3f483))
* ss/profile: Improve success and error flows ([9e0015a](https://github.com/ory/kratos/commit/9e0015acec7f8d927498e48366b377e22ec768b7)), closes [#112](https://github.com/ory/kratos/issues/112):

    This patch completes the profile management flow by implementing proper error and success states and adding several data integrity tests.

* Rebrand ORY Hive to ORY Kratos (#111) ([ceda7fb](https://github.com/ory/kratos/commit/ceda7fb3472b081f0c6066aa1f282d4ec1787f7b)), closes [#111](https://github.com/ory/kratos/issues/111)
* Fix broken tests and ci linter issues  (#104) ([69760fe](https://github.com/ory/kratos/commit/69760fe9fecb2f302dd5c1821185ea990f4e411c)), closes [#104](https://github.com/ory/kratos/issues/104)
* Update to Go modules 1.13 ([1da4d75](https://github.com/ory/kratos/commit/1da4d757bc2434f97c588e395305066edce9ef0d))
* Resolve minor configuration issues and response errors (#85) ([a44913b](https://github.com/ory/kratos/commit/a44913b26b515333576def6b882861ff2c8d4aff)), closes [#85](https://github.com/ory/kratos/issues/85)
* Clean up dead files (#84) ([e0c96ef](https://github.com/ory/kratos/commit/e0c96effbee2521b12eeedc851b67fa3a1ae41c8)), closes [#84](https://github.com/ory/kratos/issues/84)
* Add health endpoints (#83) ([0e936f7](https://github.com/ory/kratos/commit/0e936f7047bb9eacae0c5107360ce752a23d8282)), closes [#83](https://github.com/ory/kratos/issues/83) [#82](https://github.com/ory/kratos/issues/82)
* Update Dockerfile and related build tools (#80) ([d20c701](https://github.com/ory/kratos/commit/d20c701433cea916d3df4863846cf09743150966)), closes [#80](https://github.com/ory/kratos/issues/80)
* Implement SQL Database adapter (#79) ([86d07c4](https://github.com/ory/kratos/commit/86d07c4a9e3b3e6607e73f4d54b4e7b9f0382e59)), closes [#79](https://github.com/ory/kratos/issues/79) [#69](https://github.com/ory/kratos/issues/69)
* Prevent duplicate signups (#76) ([4c88968](https://github.com/ory/kratos/commit/4c88968a6853396755f61db2673a0cb2201868f7)), closes [#76](https://github.com/ory/kratos/issues/76) [#46](https://github.com/ory/kratos/issues/46)
* Contributing 08 10 19 00 52 45 (#74) ([43b511f](https://github.com/ory/kratos/commit/43b511f1a43be114ac04b377434b22ec8afe465b)), closes [#74](https://github.com/ory/kratos/issues/74)
* Echo form values from oidc signup ([98b1da5](https://github.com/ory/kratos/commit/98b1da5f59d5dcde4416b74ea323af3e29fefa75)), closes [#71](https://github.com/ory/kratos/issues/71)
* Properly decode values in error handler ([5eb9088](https://github.com/ory/kratos/commit/5eb9088efb291256d65fadbd5a803369cc96bdd2)), closes [#71](https://github.com/ory/kratos/issues/71)
* Force path and domain on CSRF cookie (#70) ([a80d8b0](https://github.com/ory/kratos/commit/a80d8b0e0bb16fce530559826de29fd6b9836873)), closes [#70](https://github.com/ory/kratos/issues/70) [#68](https://github.com/ory/kratos/issues/68)
* Require no session when accessing login or sign up (#67) ([c0e0da1](https://github.com/ory/kratos/commit/c0e0da1b38ebadaa33eb5b59dc566731b3320b70)), closes [#67](https://github.com/ory/kratos/issues/67) [#63](https://github.com/ory/kratos/issues/63)
* Add tests for selfservice ErrorHandler (#62) ([4bb9e70](https://github.com/ory/kratos/commit/4bb9e7086ee57c4eb1a73fea436c7b2dec0257b7)), closes [#62](https://github.com/ory/kratos/issues/62)
* Enable Circle CI (#57) ([6fb0afd](https://github.com/ory/kratos/commit/6fb0afd30e3755026b6ffca0cc80f2fe00267681)), closes [#57](https://github.com/ory/kratos/issues/57) [#53](https://github.com/ory/kratos/issues/53)
* OIDC provider selfservice data enrichment (#56) ([936970a](https://github.com/ory/kratos/commit/936970a9abaadeab5c191ff52218bf4f65af2220)), closes [#56](https://github.com/ory/kratos/issues/56) [#23](https://github.com/ory/kratos/issues/23) [#55](https://github.com/ory/kratos/issues/55)
* Remove local jsonschema module override ([cd2a5d8](https://github.com/ory/kratos/commit/cd2a5d8c74b21b122f5d5437702d8c74fb1cb726))
* Implement identity management, login, and registration (#22) ([bf3395e](https://github.com/ory/kratos/commit/bf3395ea34ecf85303034f3e941a049c8cbd6229)), closes [#22](https://github.com/ory/kratos/issues/22)
* Revert incorrect license changes ([fb9740b](https://github.com/ory/kratos/commit/fb9740b37a94dbdde1a8f4433fb7e5a8b4dac295))
* Create FUNDING.yml ([3c67ac8](https://github.com/ory/kratos/commit/3c67ac83f58c5b03dc3935d279083268b8a85e0d))
* Initial commit ([ab6f24a](https://github.com/ory/kratos/commit/ab6f24a85276bdd8687f2fc06390c1279892b005))
* Add ability to define multiple schemas and serve them over HTTP ([#164](https://github.com/ory/kratos/issues/164)) ([c65119c](https://github.com/ory/kratos/commit/c65119c24378dabd306e5a49f89c28c0367f7c2e)), closes [#86](https://github.com/ory/kratos/issues/86):

    All identity traits schemas have to be configured using a human readable ID and the corresponding URL. This PR enables multiple schemas to be used next to the default schema.
    It also adds the kratos.public/schemas/:id endpoint that mirrors all schemas.

* Add helper for requiring authentication ([3888fbd](https://github.com/ory/kratos/commit/3888fbdc239b7a06c7fca34d08de7d55af69a48c))
* Add helpers for go-swagger ([165a660](https://github.com/ory/kratos/commit/165a660f277588ed572d7843354c207f72f1678d)):

    See https://github.com/go-swagger/go-swagger/issues/2119

* Add profile management and refactor internals ([3ec9263](https://github.com/ory/kratos/commit/3ec9263f597a5949d0de6d10073cc626cfcfcca4)), closes [#112](https://github.com/ory/kratos/issues/112)
* Add session destroyer hook  ([#148](https://github.com/ory/kratos/issues/148)) ([d17f002](https://github.com/ory/kratos/commit/d17f002cdfe1f11ebb6bcbb17f6976aa329eab4a)), closes [#139](https://github.com/ory/kratos/issues/139):

    This patch adds a hook that destroys all active session by the identity which is being logged in. This can be useful in scenarios where only one session should be active at any given time.

* Add SQL adapter ([#100](https://github.com/ory/kratos/issues/100)) ([9e7f998](https://github.com/ory/kratos/commit/9e7f99871e3f09e7ae9ec1c38c8b8cf94d076f45)), closes [#92](https://github.com/ory/kratos/issues/92)
* Explicitly whitelist form parser keys ([#105](https://github.com/ory/kratos/issues/105)) ([28b056e](https://github.com/ory/kratos/commit/28b056e5bbfec645262914c52f0386d70c787a32)), closes [#98](https://github.com/ory/kratos/issues/98):

    Previously the form parser would try to detect the field type by
    asserting types for the whole form. That caused passwords
    containing only numbers to fail to unmarshal into a string
    value.
    
    This patch resolves that issue by introducing a prefix
    option to the BodyParser

* Fix broken import ([308aa13](https://github.com/ory/kratos/commit/308aa1334dd43bc4bebade4e70e9c81c83fe8806))
* Handle securecookie errors appropriately ([#101](https://github.com/ory/kratos/issues/101)) ([75bf6fe](https://github.com/ory/kratos/commit/75bf6fe3f79d025f2aaa79d06db39c26430dc3fc)), closes [#97](https://github.com/ory/kratos/issues/97):

    Previously, IsNotAuthenticated would not handle securecookie errors appropriately.
    This has been resolved.

* Implement CRUD for identities ([#60](https://github.com/ory/kratos/issues/60)) ([58a3c24](https://github.com/ory/kratos/commit/58a3c240fca66e1195bf310024a2f8473826bce6)), closes [#58](https://github.com/ory/kratos/issues/58)
* Implement message templates and SMTP delivery ([#146](https://github.com/ory/kratos/issues/146)) ([dc674bf](https://github.com/ory/kratos/commit/dc674bfa7d1fa9ee94b014d09866bbdc0a97c321)), closes [#99](https://github.com/ory/kratos/issues/99):

    This patch adds a message templates (with override capabilities)
    and SMTP delivery.
    
    Integration tests using MailHog test fault resilience and e2e email
    delivery.
    
    This system is designed to be extended for SMS and other use cases.

* Improve migration command ([#94](https://github.com/ory/kratos/issues/94)) ([2b631de](https://github.com/ory/kratos/commit/2b631de6d621dcebac5318f6dd628646fec7712f))
* Inject Identity Traits JSON Schema ([3a4c5ad](https://github.com/ory/kratos/commit/3a4c5ad35f885c7d38ffcf1d5836fb485f122fe9)), closes [#189](https://github.com/ory/kratos/issues/189)
* Mark active field as nullable ([#89](https://github.com/ory/kratos/issues/89)) ([292702d](https://github.com/ory/kratos/commit/292702d9e031e43c63e0ecb59354557139499e87))
* Move package to selfservice ([063b767](https://github.com/ory/kratos/commit/063b7679af76333fc546e94e92b197079e5bdb30)):

    Because this module is primarily used
    in selfservice scenarios, it has been
    moved to the selfservice parent.

* Omit request header from login/registration request ([#106](https://github.com/ory/kratos/issues/106)) ([9b07587](https://github.com/ory/kratos/commit/9b07587f2de2b270c5c326e37b2b6b3dbbfa8595)), closes [#95](https://github.com/ory/kratos/issues/95):

    When fetching a login and registration request, the HTTP Request Headers
    must not be included in the response, as they contain irrelevant
    information for the API caller.

* Properly handle empty credentials config in sql ([#93](https://github.com/ory/kratos/issues/93)) ([b79c5d1](https://github.com/ory/kratos/commit/b79c5d1d5216e994f986ce739285cb1a89523df5))
* Re-introduce migration plans to CLI command ([#192](https://github.com/ory/kratos/issues/192)) ([bb32cd3](https://github.com/ory/kratos/commit/bb32cd3cad3cd0bd6f3166de0166701e1f676ac6)), closes [#131](https://github.com/ory/kratos/issues/131)
* Reset CSRF token on principal change ([#64](https://github.com/ory/kratos/issues/64)) ([9c889ab](https://github.com/ory/kratos/commit/9c889ab4f6c846812a4290545fef7d8106da35f0)), closes [#38](https://github.com/ory/kratos/issues/38):

    Add tests for logout.

* Resolve wrong column reference in sql ([#90](https://github.com/ory/kratos/issues/90)) ([0c0eb87](https://github.com/ory/kratos/commit/0c0eb87cd341bd3e73eb9adb303054b38c103ba9)):

    Reference ic.method instead of ici.method.
    
    Added regression tests against this particular issue.

* Update keyword from kratos to ory.sh/kratos ([f45cbe0](https://github.com/ory/kratos/commit/f45cbe0339db8d129522314f3099e6944e4a6ea3)), closes [#115](https://github.com/ory/kratos/issues/115)
* Update sdk generation method ([24aa3d7](https://github.com/ory/kratos/commit/24aa3d73354d5a28f05999a09e7bbbe51a44d44e))
* Update to ory/x 0.0.80 ([#110](https://github.com/ory/kratos/issues/110)) ([64de2f8](https://github.com/ory/kratos/commit/64de2f86540bf8715a1703d773fa95011603a854)):

    Removes the need for BindEnv()

* Use JSON Schema to type assert form body ([#116](https://github.com/ory/kratos/issues/116)) ([1944c7c](https://github.com/ory/kratos/commit/1944c7c6e82b5b6a3b9d47db94c8f8f45248feb7)), closes [#109](https://github.com/ory/kratos/issues/109)


