/*
 * Ory Kratos API
 *
 * Documentation for all public and administrative Ory Kratos APIs. Public and administrative APIs are exposed on different ports. Public APIs can face the public internet without any protection while administrative APIs should never be exposed without prior authorization. To protect the administative API port you should use something like Nginx, Ory Oathkeeper, or any other technology capable of authorizing incoming requests.
 *
 * API version: 1.0.0
 * Contact: hi@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// UiNodeAnchorAttributes struct for UiNodeAnchorAttributes
type UiNodeAnchorAttributes struct {
	// The link's href (destination) URL.  format: uri
	Href  string `json:"href"`
	Title UiText `json:"title"`
}

// NewUiNodeAnchorAttributes instantiates a new UiNodeAnchorAttributes object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUiNodeAnchorAttributes(href string, title UiText) *UiNodeAnchorAttributes {
	this := UiNodeAnchorAttributes{}
	this.Href = href
	this.Title = title
	return &this
}

// NewUiNodeAnchorAttributesWithDefaults instantiates a new UiNodeAnchorAttributes object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUiNodeAnchorAttributesWithDefaults() *UiNodeAnchorAttributes {
	this := UiNodeAnchorAttributes{}
	return &this
}

// GetHref returns the Href field value
func (o *UiNodeAnchorAttributes) GetHref() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Href
}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
func (o *UiNodeAnchorAttributes) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Href, true
}

// SetHref sets field value
func (o *UiNodeAnchorAttributes) SetHref(v string) {
	o.Href = v
}

// GetTitle returns the Title field value
func (o *UiNodeAnchorAttributes) GetTitle() UiText {
	if o == nil {
		var ret UiText
		return ret
	}

	return o.Title
}

// GetTitleOk returns a tuple with the Title field value
// and a boolean to check if the value has been set.
func (o *UiNodeAnchorAttributes) GetTitleOk() (*UiText, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Title, true
}

// SetTitle sets field value
func (o *UiNodeAnchorAttributes) SetTitle(v UiText) {
	o.Title = v
}

func (o UiNodeAnchorAttributes) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["href"] = o.Href
	}
	if true {
		toSerialize["title"] = o.Title
	}
	return json.Marshal(toSerialize)
}

type NullableUiNodeAnchorAttributes struct {
	value *UiNodeAnchorAttributes
	isSet bool
}

func (v NullableUiNodeAnchorAttributes) Get() *UiNodeAnchorAttributes {
	return v.value
}

func (v *NullableUiNodeAnchorAttributes) Set(val *UiNodeAnchorAttributes) {
	v.value = val
	v.isSet = true
}

func (v NullableUiNodeAnchorAttributes) IsSet() bool {
	return v.isSet
}

func (v *NullableUiNodeAnchorAttributes) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUiNodeAnchorAttributes(val *UiNodeAnchorAttributes) *NullableUiNodeAnchorAttributes {
	return &NullableUiNodeAnchorAttributes{value: val, isSet: true}
}

func (v NullableUiNodeAnchorAttributes) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUiNodeAnchorAttributes) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
