/*
 * Ory Kratos API
 *
 * Documentation for all public and administrative Ory Kratos APIs. Public and administrative APIs are exposed on different ports. Public APIs can face the public internet without any protection while administrative APIs should never be exposed without prior authorization. To protect the administative API port you should use something like Nginx, Ory Oathkeeper, or any other technology capable of authorizing incoming requests.
 *
 * API version: 1.0.0
 * Contact: hi@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// SubmitSelfServiceSettingsFlowWithOidcMethod struct for SubmitSelfServiceSettingsFlowWithOidcMethod
type SubmitSelfServiceSettingsFlowWithOidcMethod struct {
	// Flow ID is the flow's ID.  in: query
	Flow *string `json:"flow,omitempty"`
	// Link this provider  Either this or `unlink` must be set.  type: string in: body
	Link *string `json:"link,omitempty"`
	// Unlink this provider  Either this or `link` must be set.  type: string in: body
	Unlink *string `json:"unlink,omitempty"`
}

// NewSubmitSelfServiceSettingsFlowWithOidcMethod instantiates a new SubmitSelfServiceSettingsFlowWithOidcMethod object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSubmitSelfServiceSettingsFlowWithOidcMethod() *SubmitSelfServiceSettingsFlowWithOidcMethod {
	this := SubmitSelfServiceSettingsFlowWithOidcMethod{}
	return &this
}

// NewSubmitSelfServiceSettingsFlowWithOidcMethodWithDefaults instantiates a new SubmitSelfServiceSettingsFlowWithOidcMethod object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSubmitSelfServiceSettingsFlowWithOidcMethodWithDefaults() *SubmitSelfServiceSettingsFlowWithOidcMethod {
	this := SubmitSelfServiceSettingsFlowWithOidcMethod{}
	return &this
}

// GetFlow returns the Flow field value if set, zero value otherwise.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetFlow() string {
	if o == nil || o.Flow == nil {
		var ret string
		return ret
	}
	return *o.Flow
}

// GetFlowOk returns a tuple with the Flow field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetFlowOk() (*string, bool) {
	if o == nil || o.Flow == nil {
		return nil, false
	}
	return o.Flow, true
}

// HasFlow returns a boolean if a field has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) HasFlow() bool {
	if o != nil && o.Flow != nil {
		return true
	}

	return false
}

// SetFlow gets a reference to the given string and assigns it to the Flow field.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) SetFlow(v string) {
	o.Flow = &v
}

// GetLink returns the Link field value if set, zero value otherwise.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetLink() string {
	if o == nil || o.Link == nil {
		var ret string
		return ret
	}
	return *o.Link
}

// GetLinkOk returns a tuple with the Link field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetLinkOk() (*string, bool) {
	if o == nil || o.Link == nil {
		return nil, false
	}
	return o.Link, true
}

// HasLink returns a boolean if a field has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) HasLink() bool {
	if o != nil && o.Link != nil {
		return true
	}

	return false
}

// SetLink gets a reference to the given string and assigns it to the Link field.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) SetLink(v string) {
	o.Link = &v
}

// GetUnlink returns the Unlink field value if set, zero value otherwise.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetUnlink() string {
	if o == nil || o.Unlink == nil {
		var ret string
		return ret
	}
	return *o.Unlink
}

// GetUnlinkOk returns a tuple with the Unlink field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) GetUnlinkOk() (*string, bool) {
	if o == nil || o.Unlink == nil {
		return nil, false
	}
	return o.Unlink, true
}

// HasUnlink returns a boolean if a field has been set.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) HasUnlink() bool {
	if o != nil && o.Unlink != nil {
		return true
	}

	return false
}

// SetUnlink gets a reference to the given string and assigns it to the Unlink field.
func (o *SubmitSelfServiceSettingsFlowWithOidcMethod) SetUnlink(v string) {
	o.Unlink = &v
}

func (o SubmitSelfServiceSettingsFlowWithOidcMethod) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Flow != nil {
		toSerialize["flow"] = o.Flow
	}
	if o.Link != nil {
		toSerialize["link"] = o.Link
	}
	if o.Unlink != nil {
		toSerialize["unlink"] = o.Unlink
	}
	return json.Marshal(toSerialize)
}

type NullableSubmitSelfServiceSettingsFlowWithOidcMethod struct {
	value *SubmitSelfServiceSettingsFlowWithOidcMethod
	isSet bool
}

func (v NullableSubmitSelfServiceSettingsFlowWithOidcMethod) Get() *SubmitSelfServiceSettingsFlowWithOidcMethod {
	return v.value
}

func (v *NullableSubmitSelfServiceSettingsFlowWithOidcMethod) Set(val *SubmitSelfServiceSettingsFlowWithOidcMethod) {
	v.value = val
	v.isSet = true
}

func (v NullableSubmitSelfServiceSettingsFlowWithOidcMethod) IsSet() bool {
	return v.isSet
}

func (v *NullableSubmitSelfServiceSettingsFlowWithOidcMethod) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSubmitSelfServiceSettingsFlowWithOidcMethod(val *SubmitSelfServiceSettingsFlowWithOidcMethod) *NullableSubmitSelfServiceSettingsFlowWithOidcMethod {
	return &NullableSubmitSelfServiceSettingsFlowWithOidcMethod{value: val, isSet: true}
}

func (v NullableSubmitSelfServiceSettingsFlowWithOidcMethod) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSubmitSelfServiceSettingsFlowWithOidcMethod) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
