/*
 * Ory Kratos API
 *
 * Documentation for all public and administrative Ory Kratos APIs. Public and administrative APIs are exposed on different ports. Public APIs can face the public internet without any protection while administrative APIs should never be exposed without prior authorization. To protect the administative API port you should use something like Nginx, Ory Oathkeeper, or any other technology capable of authorizing incoming requests.
 *
 * API version: 1.0.0
 * Contact: hi@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
	"fmt"
)

// RecoveryFlowState The state represents the state of the recovery flow.  choose_method: ask the user to choose a method (e.g. recover account via email) sent_email: the email has been sent to the user passed_challenge: the request was successful and the recovery challenge was passed.
type RecoveryFlowState string

// List of recoveryFlowState
const (
	CHOOSE_METHOD    RecoveryFlowState = "choose_method"
	SENT_EMAIL       RecoveryFlowState = "sent_email"
	PASSED_CHALLENGE RecoveryFlowState = "passed_challenge"
)

func (v *RecoveryFlowState) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := RecoveryFlowState(value)
	for _, existing := range []RecoveryFlowState{"choose_method", "sent_email", "passed_challenge"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid RecoveryFlowState", value)
}

// Ptr returns reference to recoveryFlowState value
func (v RecoveryFlowState) Ptr() *RecoveryFlowState {
	return &v
}

type NullableRecoveryFlowState struct {
	value *RecoveryFlowState
	isSet bool
}

func (v NullableRecoveryFlowState) Get() *RecoveryFlowState {
	return v.value
}

func (v *NullableRecoveryFlowState) Set(val *RecoveryFlowState) {
	v.value = val
	v.isSet = true
}

func (v NullableRecoveryFlowState) IsSet() bool {
	return v.isSet
}

func (v *NullableRecoveryFlowState) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRecoveryFlowState(val *RecoveryFlowState) *NullableRecoveryFlowState {
	return &NullableRecoveryFlowState{value: val, isSet: true}
}

func (v NullableRecoveryFlowState) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRecoveryFlowState) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
