/*
 * Ory Kratos API
 *
 * Documentation for all public and administrative Ory Kratos APIs. Public and administrative APIs are exposed on different ports. Public APIs can face the public internet without any protection while administrative APIs should never be exposed without prior authorization. To protect the administative API port you should use something like Nginx, Ory Oathkeeper, or any other technology capable of authorizing incoming requests.
 *
 * API version: 1.0.0
 * Contact: hi@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// LogoutUrl struct for LogoutUrl
type LogoutUrl struct {
	// LogoutURL can be opened in a browser to  format: uri
	LogoutUrl *string `json:"logout_url,omitempty"`
}

// NewLogoutUrl instantiates a new LogoutUrl object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewLogoutUrl() *LogoutUrl {
	this := LogoutUrl{}
	return &this
}

// NewLogoutUrlWithDefaults instantiates a new LogoutUrl object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewLogoutUrlWithDefaults() *LogoutUrl {
	this := LogoutUrl{}
	return &this
}

// GetLogoutUrl returns the LogoutUrl field value if set, zero value otherwise.
func (o *LogoutUrl) GetLogoutUrl() string {
	if o == nil || o.LogoutUrl == nil {
		var ret string
		return ret
	}
	return *o.LogoutUrl
}

// GetLogoutUrlOk returns a tuple with the LogoutUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *LogoutUrl) GetLogoutUrlOk() (*string, bool) {
	if o == nil || o.LogoutUrl == nil {
		return nil, false
	}
	return o.LogoutUrl, true
}

// HasLogoutUrl returns a boolean if a field has been set.
func (o *LogoutUrl) HasLogoutUrl() bool {
	if o != nil && o.LogoutUrl != nil {
		return true
	}

	return false
}

// SetLogoutUrl gets a reference to the given string and assigns it to the LogoutUrl field.
func (o *LogoutUrl) SetLogoutUrl(v string) {
	o.LogoutUrl = &v
}

func (o LogoutUrl) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.LogoutUrl != nil {
		toSerialize["logout_url"] = o.LogoutUrl
	}
	return json.Marshal(toSerialize)
}

type NullableLogoutUrl struct {
	value *LogoutUrl
	isSet bool
}

func (v NullableLogoutUrl) Get() *LogoutUrl {
	return v.value
}

func (v *NullableLogoutUrl) Set(val *LogoutUrl) {
	v.value = val
	v.isSet = true
}

func (v NullableLogoutUrl) IsSet() bool {
	return v.isSet
}

func (v *NullableLogoutUrl) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableLogoutUrl(val *LogoutUrl) *NullableLogoutUrl {
	return &NullableLogoutUrl{value: val, isSet: true}
}

func (v NullableLogoutUrl) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableLogoutUrl) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
