/*
 * Ory Kratos API
 *
 * Documentation for all public and administrative Ory Kratos APIs. Public and administrative APIs are exposed on different ports. Public APIs can face the public internet without any protection while administrative APIs should never be exposed without prior authorization. To protect the administative API port you should use something like Nginx, Ory Oathkeeper, or any other technology capable of authorizing incoming requests.
 *
 * API version: 1.0.0
 * Contact: hi@ory.sh
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package client

import (
	"encoding/json"
)

// AdminCreateSelfServiceRecoveryLink struct for AdminCreateSelfServiceRecoveryLink
type AdminCreateSelfServiceRecoveryLink struct {
	// Link Expires In  The recovery link will expire at that point in time. Defaults to the configuration value of `selfservice.flows.recovery.request_lifespan`.
	ExpiresIn  *string `json:"expires_in,omitempty"`
	IdentityId string  `json:"identity_id"`
}

// NewAdminCreateSelfServiceRecoveryLink instantiates a new AdminCreateSelfServiceRecoveryLink object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAdminCreateSelfServiceRecoveryLink(identityId string) *AdminCreateSelfServiceRecoveryLink {
	this := AdminCreateSelfServiceRecoveryLink{}
	this.IdentityId = identityId
	return &this
}

// NewAdminCreateSelfServiceRecoveryLinkWithDefaults instantiates a new AdminCreateSelfServiceRecoveryLink object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAdminCreateSelfServiceRecoveryLinkWithDefaults() *AdminCreateSelfServiceRecoveryLink {
	this := AdminCreateSelfServiceRecoveryLink{}
	return &this
}

// GetExpiresIn returns the ExpiresIn field value if set, zero value otherwise.
func (o *AdminCreateSelfServiceRecoveryLink) GetExpiresIn() string {
	if o == nil || o.ExpiresIn == nil {
		var ret string
		return ret
	}
	return *o.ExpiresIn
}

// GetExpiresInOk returns a tuple with the ExpiresIn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AdminCreateSelfServiceRecoveryLink) GetExpiresInOk() (*string, bool) {
	if o == nil || o.ExpiresIn == nil {
		return nil, false
	}
	return o.ExpiresIn, true
}

// HasExpiresIn returns a boolean if a field has been set.
func (o *AdminCreateSelfServiceRecoveryLink) HasExpiresIn() bool {
	if o != nil && o.ExpiresIn != nil {
		return true
	}

	return false
}

// SetExpiresIn gets a reference to the given string and assigns it to the ExpiresIn field.
func (o *AdminCreateSelfServiceRecoveryLink) SetExpiresIn(v string) {
	o.ExpiresIn = &v
}

// GetIdentityId returns the IdentityId field value
func (o *AdminCreateSelfServiceRecoveryLink) GetIdentityId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.IdentityId
}

// GetIdentityIdOk returns a tuple with the IdentityId field value
// and a boolean to check if the value has been set.
func (o *AdminCreateSelfServiceRecoveryLink) GetIdentityIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IdentityId, true
}

// SetIdentityId sets field value
func (o *AdminCreateSelfServiceRecoveryLink) SetIdentityId(v string) {
	o.IdentityId = v
}

func (o AdminCreateSelfServiceRecoveryLink) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ExpiresIn != nil {
		toSerialize["expires_in"] = o.ExpiresIn
	}
	if true {
		toSerialize["identity_id"] = o.IdentityId
	}
	return json.Marshal(toSerialize)
}

type NullableAdminCreateSelfServiceRecoveryLink struct {
	value *AdminCreateSelfServiceRecoveryLink
	isSet bool
}

func (v NullableAdminCreateSelfServiceRecoveryLink) Get() *AdminCreateSelfServiceRecoveryLink {
	return v.value
}

func (v *NullableAdminCreateSelfServiceRecoveryLink) Set(val *AdminCreateSelfServiceRecoveryLink) {
	v.value = val
	v.isSet = true
}

func (v NullableAdminCreateSelfServiceRecoveryLink) IsSet() bool {
	return v.isSet
}

func (v *NullableAdminCreateSelfServiceRecoveryLink) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAdminCreateSelfServiceRecoveryLink(val *AdminCreateSelfServiceRecoveryLink) *NullableAdminCreateSelfServiceRecoveryLink {
	return &NullableAdminCreateSelfServiceRecoveryLink{value: val, isSet: true}
}

func (v NullableAdminCreateSelfServiceRecoveryLink) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAdminCreateSelfServiceRecoveryLink) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
