/*
 * Copyright (C) 2021. Uber Technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.uber.debug.broadcast.core;

import com.uber.debug.broadcast.core.DebugBroadcastReceiver.Handler;

/*
 * Simple example handler for responding to 'ACK' command requests.
 */
public class AckDebugBroadcastHandler implements Handler<String> {

  static final String COMMAND_ACK = "ACK";

  public AckDebugBroadcastHandler() {}

  @Override
  public boolean canHandle(DebugBroadcastRequest request) {
    return request.isCommand(COMMAND_ACK);
  }

  @Override
  public void handle(DebugBroadcastRequest request) {
    request.respond("Hello");
  }
}
