/*
 * Decompiled with CFR 0.152.
 */
package com.uber.presidio.intellij_plugin.action.rib;

import com.google.common.base.Preconditions;
import com.intellij.ide.IdeView;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.RefactoringUtil;
import com.uber.presidio.intellij_plugin.generator.Generator;
import java.util.List;
import javax.swing.JOptionPane;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class GenerateAction
extends AnAction {
    private DataContext dataContext;

    private static SourceFolder suitableTestSourceFolders(Project project, Module module) {
        ContentEntry[] contentEntries;
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            List testSourceFolders = contentEntry.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
            for (SourceFolder testSourceFolder : testSourceFolders) {
                if (testSourceFolder.getFile() == null || JavaProjectRootsUtil.isInGeneratedCode((VirtualFile)testSourceFolder.getFile(), (Project)project)) continue;
                return testSourceFolder;
            }
        }
        return null;
    }

    private static void createSourceFile(Project project, Generator generator, PsiDirectory directory) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(String.format("%s" + generator.getFileExtension(), generator.getClassName()), (Language)JavaLanguage.INSTANCE, (CharSequence)generator.generate());
        directory.add((PsiElement)file);
    }

    public final void update(AnActionEvent e) {
        this.dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(this.dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    protected void generate(final List<Generator> mainSourceGenerators, final List<Generator> testSourceGenerators) {
        IdeView view;
        PsiDirectory directory;
        Module currentModule;
        final Project project = (Project)Preconditions.checkNotNull((Object)CommonDataKeys.PROJECT.getData(this.dataContext));
        final SourceFolder testSourceFolder = GenerateAction.suitableTestSourceFolders(project, currentModule = (Module)Preconditions.checkNotNull((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)(directory = (PsiDirectory)Preconditions.checkNotNull((Object)(view = (IdeView)Preconditions.checkNotNull((Object)LangDataKeys.IDE_VIEW.getData(this.dataContext))).getOrChooseDirectory())))));
        if (null == testSourceFolder) {
            JOptionPane.showMessageDialog(null, "Cannot create a RIB in a module without a test source set.");
            return;
        }
        final PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)project), this.getPackageName());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        for (Generator generator : mainSourceGenerators) {
                            GenerateAction.createSourceFile(project, generator, directory);
                        }
                        PsiDirectory testDirectory = RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)targetPackage, (VirtualFile)testSourceFolder.getFile());
                        for (Generator generator : testSourceGenerators) {
                            GenerateAction.createSourceFile(project, generator, testDirectory);
                        }
                    }
                }, "Generate new RIB", null);
            }
        });
    }

    protected final String getPackageName() {
        Project project = (Project)Preconditions.checkNotNull((Object)CommonDataKeys.PROJECT.getData(this.dataContext));
        IdeView view = (IdeView)Preconditions.checkNotNull((Object)LangDataKeys.IDE_VIEW.getData(this.dataContext));
        PsiDirectory directory = (PsiDirectory)Preconditions.checkNotNull((Object)view.getOrChooseDirectory());
        PsiPackage psiPackage = (PsiPackage)Preconditions.checkNotNull((Object)JavaDirectoryService.getInstance().getPackage(directory));
        return psiPackage.getQualifiedName();
    }

    private boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || view.getDirectories().length == 0) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || !this.checkPackageExists(dir)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPackageExists(PsiDirectory directory) {
        PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(directory);
        if (pkg == null) {
            return false;
        }
        String name = pkg.getQualifiedName();
        return StringUtil.isEmpty((String)name) || PsiNameHelper.getInstance((Project)directory.getProject()).isQualifiedName(name);
    }
}

