// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: tendermint/consensus/types.proto

package consensus

import (
	fmt "fmt"
	bits "github.com/cometbft/cometbft/proto/tendermint/libs/bits"
	types "github.com/cometbft/cometbft/proto/tendermint/types"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// NewRoundStep is sent for every step taken in the ConsensusState.
// For every height/round/step transition
type NewRoundStep struct {
	Height                int64  `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round                 int32  `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	Step                  uint32 `protobuf:"varint,3,opt,name=step,proto3" json:"step,omitempty"`
	SecondsSinceStartTime int64  `protobuf:"varint,4,opt,name=seconds_since_start_time,json=secondsSinceStartTime,proto3" json:"seconds_since_start_time,omitempty"`
	LastCommitRound       int32  `protobuf:"varint,5,opt,name=last_commit_round,json=lastCommitRound,proto3" json:"last_commit_round,omitempty"`
}

func (m *NewRoundStep) Reset()         { *m = NewRoundStep{} }
func (m *NewRoundStep) String() string { return proto.CompactTextString(m) }
func (*NewRoundStep) ProtoMessage()    {}
func (*NewRoundStep) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{0}
}
func (m *NewRoundStep) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NewRoundStep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NewRoundStep.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NewRoundStep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewRoundStep.Merge(m, src)
}
func (m *NewRoundStep) XXX_Size() int {
	return m.Size()
}
func (m *NewRoundStep) XXX_DiscardUnknown() {
	xxx_messageInfo_NewRoundStep.DiscardUnknown(m)
}

var xxx_messageInfo_NewRoundStep proto.InternalMessageInfo

func (m *NewRoundStep) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *NewRoundStep) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *NewRoundStep) GetStep() uint32 {
	if m != nil {
		return m.Step
	}
	return 0
}

func (m *NewRoundStep) GetSecondsSinceStartTime() int64 {
	if m != nil {
		return m.SecondsSinceStartTime
	}
	return 0
}

func (m *NewRoundStep) GetLastCommitRound() int32 {
	if m != nil {
		return m.LastCommitRound
	}
	return 0
}

// NewValidBlock is sent when a validator observes a valid block B in some round r,
// i.e., there is a Proposal for block B and 2/3+ prevotes for the block B in the round r.
// In case the block is also committed, then IsCommit flag is set to true.
type NewValidBlock struct {
	Height             int64               `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round              int32               `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	BlockPartSetHeader types.PartSetHeader `protobuf:"bytes,3,opt,name=block_part_set_header,json=blockPartSetHeader,proto3" json:"block_part_set_header"`
	BlockParts         *bits.BitArray      `protobuf:"bytes,4,opt,name=block_parts,json=blockParts,proto3" json:"block_parts,omitempty"`
	IsCommit           bool                `protobuf:"varint,5,opt,name=is_commit,json=isCommit,proto3" json:"is_commit,omitempty"`
}

func (m *NewValidBlock) Reset()         { *m = NewValidBlock{} }
func (m *NewValidBlock) String() string { return proto.CompactTextString(m) }
func (*NewValidBlock) ProtoMessage()    {}
func (*NewValidBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{1}
}
func (m *NewValidBlock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NewValidBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NewValidBlock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NewValidBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewValidBlock.Merge(m, src)
}
func (m *NewValidBlock) XXX_Size() int {
	return m.Size()
}
func (m *NewValidBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_NewValidBlock.DiscardUnknown(m)
}

var xxx_messageInfo_NewValidBlock proto.InternalMessageInfo

func (m *NewValidBlock) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *NewValidBlock) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *NewValidBlock) GetBlockPartSetHeader() types.PartSetHeader {
	if m != nil {
		return m.BlockPartSetHeader
	}
	return types.PartSetHeader{}
}

func (m *NewValidBlock) GetBlockParts() *bits.BitArray {
	if m != nil {
		return m.BlockParts
	}
	return nil
}

func (m *NewValidBlock) GetIsCommit() bool {
	if m != nil {
		return m.IsCommit
	}
	return false
}

// Proposal is sent when a new block is proposed.
type Proposal struct {
	Proposal types.Proposal `protobuf:"bytes,1,opt,name=proposal,proto3" json:"proposal"`
}

func (m *Proposal) Reset()         { *m = Proposal{} }
func (m *Proposal) String() string { return proto.CompactTextString(m) }
func (*Proposal) ProtoMessage()    {}
func (*Proposal) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{2}
}
func (m *Proposal) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Proposal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Proposal.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Proposal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Proposal.Merge(m, src)
}
func (m *Proposal) XXX_Size() int {
	return m.Size()
}
func (m *Proposal) XXX_DiscardUnknown() {
	xxx_messageInfo_Proposal.DiscardUnknown(m)
}

var xxx_messageInfo_Proposal proto.InternalMessageInfo

func (m *Proposal) GetProposal() types.Proposal {
	if m != nil {
		return m.Proposal
	}
	return types.Proposal{}
}

// ProposalPOL is sent when a previous proposal is re-proposed.
type ProposalPOL struct {
	Height           int64         `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	ProposalPolRound int32         `protobuf:"varint,2,opt,name=proposal_pol_round,json=proposalPolRound,proto3" json:"proposal_pol_round,omitempty"`
	ProposalPol      bits.BitArray `protobuf:"bytes,3,opt,name=proposal_pol,json=proposalPol,proto3" json:"proposal_pol"`
}

func (m *ProposalPOL) Reset()         { *m = ProposalPOL{} }
func (m *ProposalPOL) String() string { return proto.CompactTextString(m) }
func (*ProposalPOL) ProtoMessage()    {}
func (*ProposalPOL) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{3}
}
func (m *ProposalPOL) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProposalPOL) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProposalPOL.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProposalPOL) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProposalPOL.Merge(m, src)
}
func (m *ProposalPOL) XXX_Size() int {
	return m.Size()
}
func (m *ProposalPOL) XXX_DiscardUnknown() {
	xxx_messageInfo_ProposalPOL.DiscardUnknown(m)
}

var xxx_messageInfo_ProposalPOL proto.InternalMessageInfo

func (m *ProposalPOL) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *ProposalPOL) GetProposalPolRound() int32 {
	if m != nil {
		return m.ProposalPolRound
	}
	return 0
}

func (m *ProposalPOL) GetProposalPol() bits.BitArray {
	if m != nil {
		return m.ProposalPol
	}
	return bits.BitArray{}
}

// BlockPart is sent when gossipping a piece of the proposed block.
type BlockPart struct {
	Height int64      `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round  int32      `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	Part   types.Part `protobuf:"bytes,3,opt,name=part,proto3" json:"part"`
}

func (m *BlockPart) Reset()         { *m = BlockPart{} }
func (m *BlockPart) String() string { return proto.CompactTextString(m) }
func (*BlockPart) ProtoMessage()    {}
func (*BlockPart) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{4}
}
func (m *BlockPart) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BlockPart) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BlockPart.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BlockPart) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockPart.Merge(m, src)
}
func (m *BlockPart) XXX_Size() int {
	return m.Size()
}
func (m *BlockPart) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockPart.DiscardUnknown(m)
}

var xxx_messageInfo_BlockPart proto.InternalMessageInfo

func (m *BlockPart) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *BlockPart) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *BlockPart) GetPart() types.Part {
	if m != nil {
		return m.Part
	}
	return types.Part{}
}

// Vote is sent when voting for a proposal (or lack thereof).
type Vote struct {
	Vote *types.Vote `protobuf:"bytes,1,opt,name=vote,proto3" json:"vote,omitempty"`
}

func (m *Vote) Reset()         { *m = Vote{} }
func (m *Vote) String() string { return proto.CompactTextString(m) }
func (*Vote) ProtoMessage()    {}
func (*Vote) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{5}
}
func (m *Vote) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Vote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Vote.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Vote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vote.Merge(m, src)
}
func (m *Vote) XXX_Size() int {
	return m.Size()
}
func (m *Vote) XXX_DiscardUnknown() {
	xxx_messageInfo_Vote.DiscardUnknown(m)
}

var xxx_messageInfo_Vote proto.InternalMessageInfo

func (m *Vote) GetVote() *types.Vote {
	if m != nil {
		return m.Vote
	}
	return nil
}

// HasVote is sent to indicate that a particular vote has been received.
type HasVote struct {
	Height int64               `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round  int32               `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	Type   types.SignedMsgType `protobuf:"varint,3,opt,name=type,proto3,enum=tendermint.types.SignedMsgType" json:"type,omitempty"`
	Index  int32               `protobuf:"varint,4,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *HasVote) Reset()         { *m = HasVote{} }
func (m *HasVote) String() string { return proto.CompactTextString(m) }
func (*HasVote) ProtoMessage()    {}
func (*HasVote) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{6}
}
func (m *HasVote) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HasVote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HasVote.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HasVote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HasVote.Merge(m, src)
}
func (m *HasVote) XXX_Size() int {
	return m.Size()
}
func (m *HasVote) XXX_DiscardUnknown() {
	xxx_messageInfo_HasVote.DiscardUnknown(m)
}

var xxx_messageInfo_HasVote proto.InternalMessageInfo

func (m *HasVote) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *HasVote) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *HasVote) GetType() types.SignedMsgType {
	if m != nil {
		return m.Type
	}
	return types.UnknownType
}

func (m *HasVote) GetIndex() int32 {
	if m != nil {
		return m.Index
	}
	return 0
}

// VoteSetMaj23 is sent to indicate that a given BlockID has seen +2/3 votes.
type VoteSetMaj23 struct {
	Height  int64               `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round   int32               `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	Type    types.SignedMsgType `protobuf:"varint,3,opt,name=type,proto3,enum=tendermint.types.SignedMsgType" json:"type,omitempty"`
	BlockID types.BlockID       `protobuf:"bytes,4,opt,name=block_id,json=blockId,proto3" json:"block_id"`
}

func (m *VoteSetMaj23) Reset()         { *m = VoteSetMaj23{} }
func (m *VoteSetMaj23) String() string { return proto.CompactTextString(m) }
func (*VoteSetMaj23) ProtoMessage()    {}
func (*VoteSetMaj23) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{7}
}
func (m *VoteSetMaj23) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VoteSetMaj23) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VoteSetMaj23.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VoteSetMaj23) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteSetMaj23.Merge(m, src)
}
func (m *VoteSetMaj23) XXX_Size() int {
	return m.Size()
}
func (m *VoteSetMaj23) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteSetMaj23.DiscardUnknown(m)
}

var xxx_messageInfo_VoteSetMaj23 proto.InternalMessageInfo

func (m *VoteSetMaj23) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *VoteSetMaj23) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *VoteSetMaj23) GetType() types.SignedMsgType {
	if m != nil {
		return m.Type
	}
	return types.UnknownType
}

func (m *VoteSetMaj23) GetBlockID() types.BlockID {
	if m != nil {
		return m.BlockID
	}
	return types.BlockID{}
}

// VoteSetBits is sent to communicate the bit-array of votes seen for the BlockID.
type VoteSetBits struct {
	Height  int64               `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Round   int32               `protobuf:"varint,2,opt,name=round,proto3" json:"round,omitempty"`
	Type    types.SignedMsgType `protobuf:"varint,3,opt,name=type,proto3,enum=tendermint.types.SignedMsgType" json:"type,omitempty"`
	BlockID types.BlockID       `protobuf:"bytes,4,opt,name=block_id,json=blockId,proto3" json:"block_id"`
	Votes   bits.BitArray       `protobuf:"bytes,5,opt,name=votes,proto3" json:"votes"`
}

func (m *VoteSetBits) Reset()         { *m = VoteSetBits{} }
func (m *VoteSetBits) String() string { return proto.CompactTextString(m) }
func (*VoteSetBits) ProtoMessage()    {}
func (*VoteSetBits) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{8}
}
func (m *VoteSetBits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VoteSetBits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VoteSetBits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VoteSetBits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteSetBits.Merge(m, src)
}
func (m *VoteSetBits) XXX_Size() int {
	return m.Size()
}
func (m *VoteSetBits) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteSetBits.DiscardUnknown(m)
}

var xxx_messageInfo_VoteSetBits proto.InternalMessageInfo

func (m *VoteSetBits) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *VoteSetBits) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *VoteSetBits) GetType() types.SignedMsgType {
	if m != nil {
		return m.Type
	}
	return types.UnknownType
}

func (m *VoteSetBits) GetBlockID() types.BlockID {
	if m != nil {
		return m.BlockID
	}
	return types.BlockID{}
}

func (m *VoteSetBits) GetVotes() bits.BitArray {
	if m != nil {
		return m.Votes
	}
	return bits.BitArray{}
}

type Message struct {
	// Types that are valid to be assigned to Sum:
	//	*Message_NewRoundStep
	//	*Message_NewValidBlock
	//	*Message_Proposal
	//	*Message_ProposalPol
	//	*Message_BlockPart
	//	*Message_Vote
	//	*Message_HasVote
	//	*Message_VoteSetMaj23
	//	*Message_VoteSetBits
	Sum isMessage_Sum `protobuf_oneof:"sum"`
}

func (m *Message) Reset()         { *m = Message{} }
func (m *Message) String() string { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()    {}
func (*Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_81a22d2efc008981, []int{9}
}
func (m *Message) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Message.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Message.Merge(m, src)
}
func (m *Message) XXX_Size() int {
	return m.Size()
}
func (m *Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Message proto.InternalMessageInfo

type isMessage_Sum interface {
	isMessage_Sum()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Message_NewRoundStep struct {
	NewRoundStep *NewRoundStep `protobuf:"bytes,1,opt,name=new_round_step,json=newRoundStep,proto3,oneof" json:"new_round_step,omitempty"`
}
type Message_NewValidBlock struct {
	NewValidBlock *NewValidBlock `protobuf:"bytes,2,opt,name=new_valid_block,json=newValidBlock,proto3,oneof" json:"new_valid_block,omitempty"`
}
type Message_Proposal struct {
	Proposal *Proposal `protobuf:"bytes,3,opt,name=proposal,proto3,oneof" json:"proposal,omitempty"`
}
type Message_ProposalPol struct {
	ProposalPol *ProposalPOL `protobuf:"bytes,4,opt,name=proposal_pol,json=proposalPol,proto3,oneof" json:"proposal_pol,omitempty"`
}
type Message_BlockPart struct {
	BlockPart *BlockPart `protobuf:"bytes,5,opt,name=block_part,json=blockPart,proto3,oneof" json:"block_part,omitempty"`
}
type Message_Vote struct {
	Vote *Vote `protobuf:"bytes,6,opt,name=vote,proto3,oneof" json:"vote,omitempty"`
}
type Message_HasVote struct {
	HasVote *HasVote `protobuf:"bytes,7,opt,name=has_vote,json=hasVote,proto3,oneof" json:"has_vote,omitempty"`
}
type Message_VoteSetMaj23 struct {
	VoteSetMaj23 *VoteSetMaj23 `protobuf:"bytes,8,opt,name=vote_set_maj23,json=voteSetMaj23,proto3,oneof" json:"vote_set_maj23,omitempty"`
}
type Message_VoteSetBits struct {
	VoteSetBits *VoteSetBits `protobuf:"bytes,9,opt,name=vote_set_bits,json=voteSetBits,proto3,oneof" json:"vote_set_bits,omitempty"`
}

func (*Message_NewRoundStep) isMessage_Sum()  {}
func (*Message_NewValidBlock) isMessage_Sum() {}
func (*Message_Proposal) isMessage_Sum()      {}
func (*Message_ProposalPol) isMessage_Sum()   {}
func (*Message_BlockPart) isMessage_Sum()     {}
func (*Message_Vote) isMessage_Sum()          {}
func (*Message_HasVote) isMessage_Sum()       {}
func (*Message_VoteSetMaj23) isMessage_Sum()  {}
func (*Message_VoteSetBits) isMessage_Sum()   {}

func (m *Message) GetSum() isMessage_Sum {
	if m != nil {
		return m.Sum
	}
	return nil
}

func (m *Message) GetNewRoundStep() *NewRoundStep {
	if x, ok := m.GetSum().(*Message_NewRoundStep); ok {
		return x.NewRoundStep
	}
	return nil
}

func (m *Message) GetNewValidBlock() *NewValidBlock {
	if x, ok := m.GetSum().(*Message_NewValidBlock); ok {
		return x.NewValidBlock
	}
	return nil
}

func (m *Message) GetProposal() *Proposal {
	if x, ok := m.GetSum().(*Message_Proposal); ok {
		return x.Proposal
	}
	return nil
}

func (m *Message) GetProposalPol() *ProposalPOL {
	if x, ok := m.GetSum().(*Message_ProposalPol); ok {
		return x.ProposalPol
	}
	return nil
}

func (m *Message) GetBlockPart() *BlockPart {
	if x, ok := m.GetSum().(*Message_BlockPart); ok {
		return x.BlockPart
	}
	return nil
}

func (m *Message) GetVote() *Vote {
	if x, ok := m.GetSum().(*Message_Vote); ok {
		return x.Vote
	}
	return nil
}

func (m *Message) GetHasVote() *HasVote {
	if x, ok := m.GetSum().(*Message_HasVote); ok {
		return x.HasVote
	}
	return nil
}

func (m *Message) GetVoteSetMaj23() *VoteSetMaj23 {
	if x, ok := m.GetSum().(*Message_VoteSetMaj23); ok {
		return x.VoteSetMaj23
	}
	return nil
}

func (m *Message) GetVoteSetBits() *VoteSetBits {
	if x, ok := m.GetSum().(*Message_VoteSetBits); ok {
		return x.VoteSetBits
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Message) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Message_NewRoundStep)(nil),
		(*Message_NewValidBlock)(nil),
		(*Message_Proposal)(nil),
		(*Message_ProposalPol)(nil),
		(*Message_BlockPart)(nil),
		(*Message_Vote)(nil),
		(*Message_HasVote)(nil),
		(*Message_VoteSetMaj23)(nil),
		(*Message_VoteSetBits)(nil),
	}
}

func init() {
	proto.RegisterType((*NewRoundStep)(nil), "tendermint.consensus.NewRoundStep")
	proto.RegisterType((*NewValidBlock)(nil), "tendermint.consensus.NewValidBlock")
	proto.RegisterType((*Proposal)(nil), "tendermint.consensus.Proposal")
	proto.RegisterType((*ProposalPOL)(nil), "tendermint.consensus.ProposalPOL")
	proto.RegisterType((*BlockPart)(nil), "tendermint.consensus.BlockPart")
	proto.RegisterType((*Vote)(nil), "tendermint.consensus.Vote")
	proto.RegisterType((*HasVote)(nil), "tendermint.consensus.HasVote")
	proto.RegisterType((*VoteSetMaj23)(nil), "tendermint.consensus.VoteSetMaj23")
	proto.RegisterType((*VoteSetBits)(nil), "tendermint.consensus.VoteSetBits")
	proto.RegisterType((*Message)(nil), "tendermint.consensus.Message")
}

func init() { proto.RegisterFile("tendermint/consensus/types.proto", fileDescriptor_81a22d2efc008981) }

var fileDescriptor_81a22d2efc008981 = []byte{
	// 856 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x56, 0xcd, 0x8e, 0xe3, 0x44,
	0x10, 0xb6, 0x19, 0x67, 0x92, 0x94, 0x93, 0x19, 0x68, 0xcd, 0xae, 0x42, 0x80, 0x24, 0x98, 0xcb,
	0x08, 0x21, 0x07, 0x65, 0x0e, 0x2b, 0xad, 0x90, 0x00, 0xf3, 0xb3, 0xde, 0xd5, 0x66, 0x37, 0x38,
	0xab, 0x15, 0xe2, 0x62, 0x39, 0x71, 0x93, 0x34, 0x1b, 0xbb, 0x2d, 0x77, 0x27, 0xc3, 0x5c, 0x79,
	0x02, 0x1e, 0x80, 0xd7, 0x40, 0xe2, 0x11, 0xe6, 0x38, 0x47, 0x4e, 0x23, 0x94, 0x79, 0x04, 0x04,
	0x67, 0xd4, 0xed, 0x4e, 0xec, 0x30, 0x9e, 0x81, 0xb9, 0x20, 0x71, 0xeb, 0x4e, 0x55, 0x7d, 0x5d,
	0xf5, 0x55, 0xd5, 0x17, 0x43, 0x8f, 0xe3, 0x38, 0xc4, 0x69, 0x44, 0x62, 0xde, 0x9f, 0xd2, 0x98,
	0xe1, 0x98, 0x2d, 0x59, 0x9f, 0x9f, 0x25, 0x98, 0xd9, 0x49, 0x4a, 0x39, 0x45, 0x47, 0xb9, 0x87,
	0xbd, 0xf5, 0x68, 0x1f, 0xcd, 0xe8, 0x8c, 0x4a, 0x87, 0xbe, 0x38, 0x65, 0xbe, 0xed, 0xb7, 0x0b,
	0x68, 0x12, 0xa3, 0x88, 0xd4, 0x2e, 0xbe, 0xb5, 0x20, 0x13, 0xd6, 0x9f, 0x10, 0xbe, 0xe3, 0x61,
	0xfd, 0xac, 0x43, 0xe3, 0x19, 0x3e, 0xf5, 0xe8, 0x32, 0x0e, 0xc7, 0x1c, 0x27, 0xe8, 0x3e, 0xec,
	0xcf, 0x31, 0x99, 0xcd, 0x79, 0x4b, 0xef, 0xe9, 0xc7, 0x7b, 0x9e, 0xba, 0xa1, 0x23, 0xa8, 0xa4,
	0xc2, 0xa9, 0xf5, 0x5a, 0x4f, 0x3f, 0xae, 0x78, 0xd9, 0x05, 0x21, 0x30, 0x18, 0xc7, 0x49, 0x6b,
	0xaf, 0xa7, 0x1f, 0x37, 0x3d, 0x79, 0x46, 0x0f, 0xa0, 0xc5, 0xf0, 0x94, 0xc6, 0x21, 0xf3, 0x19,
	0x89, 0xa7, 0xd8, 0x67, 0x3c, 0x48, 0xb9, 0xcf, 0x49, 0x84, 0x5b, 0x86, 0xc4, 0xbc, 0xa7, 0xec,
	0x63, 0x61, 0x1e, 0x0b, 0xeb, 0x0b, 0x12, 0x61, 0xf4, 0x3e, 0xbc, 0xb1, 0x08, 0x18, 0xf7, 0xa7,
	0x34, 0x8a, 0x08, 0xf7, 0xb3, 0xe7, 0x2a, 0xf2, 0xb9, 0x43, 0x61, 0xf8, 0x4c, 0xfe, 0x2e, 0x53,
	0xb5, 0xfe, 0xd0, 0xa1, 0xf9, 0x0c, 0x9f, 0xbe, 0x0c, 0x16, 0x24, 0x74, 0x16, 0x74, 0xfa, 0xea,
	0x8e, 0x89, 0x7f, 0x0d, 0xf7, 0x26, 0x22, 0xcc, 0x4f, 0x44, 0x6e, 0x0c, 0x73, 0x7f, 0x8e, 0x83,
	0x10, 0xa7, 0xb2, 0x12, 0x73, 0xd0, 0xb5, 0x0b, 0x3d, 0xc8, 0xf8, 0x1a, 0x05, 0x29, 0x1f, 0x63,
	0xee, 0x4a, 0x37, 0xc7, 0x38, 0xbf, 0xec, 0x6a, 0x1e, 0x92, 0x18, 0x3b, 0x16, 0xf4, 0x31, 0x98,
	0x39, 0x32, 0x93, 0x15, 0x9b, 0x83, 0x4e, 0x11, 0x4f, 0x74, 0xc2, 0x16, 0x9d, 0xb0, 0x1d, 0xc2,
	0x3f, 0x4d, 0xd3, 0xe0, 0xcc, 0x83, 0x2d, 0x10, 0x43, 0x6f, 0x41, 0x9d, 0x30, 0x45, 0x82, 0x2c,
	0xbf, 0xe6, 0xd5, 0x08, 0xcb, 0x8a, 0xb7, 0x5c, 0xa8, 0x8d, 0x52, 0x9a, 0x50, 0x16, 0x2c, 0xd0,
	0x47, 0x50, 0x4b, 0xd4, 0x59, 0xd6, 0x6c, 0x0e, 0xda, 0x25, 0x69, 0x2b, 0x0f, 0x95, 0xf1, 0x36,
	0xc2, 0xfa, 0x49, 0x07, 0x73, 0x63, 0x1c, 0x3d, 0x7f, 0x7a, 0x23, 0x7f, 0x1f, 0x00, 0xda, 0xc4,
	0xf8, 0x09, 0x5d, 0xf8, 0x45, 0x32, 0x5f, 0xdf, 0x58, 0x46, 0x74, 0x21, 0xfb, 0x82, 0x1e, 0x41,
	0xa3, 0xe8, 0xad, 0xe8, 0xfc, 0x87, 0xf2, 0x55, 0x6e, 0x66, 0x01, 0xcd, 0x7a, 0x05, 0x75, 0x67,
	0xc3, 0xc9, 0x1d, 0x7b, 0xfb, 0x21, 0x18, 0x82, 0x7b, 0xf5, 0xf6, 0xfd, 0xf2, 0x56, 0xaa, 0x37,
	0xa5, 0xa7, 0x35, 0x00, 0xe3, 0x25, 0xe5, 0x62, 0x02, 0x8d, 0x15, 0xe5, 0x58, 0xb1, 0x59, 0x12,
	0x29, 0xbc, 0x3c, 0xe9, 0x63, 0xfd, 0xa0, 0x43, 0xd5, 0x0d, 0x98, 0x8c, 0xbb, 0x5b, 0x7e, 0x27,
	0x60, 0x08, 0x34, 0x99, 0xdf, 0x41, 0xd9, 0xa8, 0x8d, 0xc9, 0x2c, 0xc6, 0xe1, 0x90, 0xcd, 0x5e,
	0x9c, 0x25, 0xd8, 0x93, 0xce, 0x02, 0x8a, 0xc4, 0x21, 0xfe, 0x5e, 0x0e, 0x54, 0xc5, 0xcb, 0x2e,
	0xd6, 0x2f, 0x3a, 0x34, 0x44, 0x06, 0x63, 0xcc, 0x87, 0xc1, 0x77, 0x83, 0x93, 0xff, 0x22, 0x93,
	0x2f, 0xa0, 0x96, 0x0d, 0x38, 0x09, 0xd5, 0x74, 0xbf, 0x79, 0x3d, 0x50, 0xf6, 0xee, 0xf1, 0xe7,
	0xce, 0xa1, 0x60, 0x79, 0x7d, 0xd9, 0xad, 0xaa, 0x1f, 0xbc, 0xaa, 0x8c, 0x7d, 0x1c, 0x5a, 0xbf,
	0xeb, 0x60, 0xaa, 0xd4, 0x1d, 0xc2, 0xd9, 0xff, 0x27, 0x73, 0xf4, 0x10, 0x2a, 0x62, 0x02, 0x98,
	0x5c, 0xce, 0x7f, 0x3b, 0xdc, 0x59, 0x88, 0xf5, 0xa7, 0x01, 0xd5, 0x21, 0x66, 0x2c, 0x98, 0x61,
	0xf4, 0x04, 0x0e, 0x62, 0x7c, 0x9a, 0x2d, 0x94, 0x2f, 0x65, 0x34, 0x9b, 0x3b, 0xcb, 0x2e, 0xfb,
	0x03, 0xb0, 0x8b, 0x32, 0xed, 0x6a, 0x5e, 0x23, 0x2e, 0xca, 0xf6, 0x10, 0x0e, 0x05, 0xd6, 0x4a,
	0xe8, 0xa1, 0x2f, 0x13, 0x95, 0x7c, 0x99, 0x83, 0xf7, 0x6e, 0x04, 0xcb, 0xb5, 0xd3, 0xd5, 0xbc,
	0x66, 0xbc, 0x23, 0xa6, 0x45, 0x69, 0x29, 0x59, 0xe1, 0x1c, 0x67, 0xa3, 0x20, 0x6e, 0x41, 0x5a,
	0xd0, 0x97, 0x7f, 0x13, 0x81, 0x8c, 0xeb, 0x77, 0x6f, 0x47, 0x18, 0x3d, 0x7f, 0xea, 0xee, 0x6a,
	0x00, 0xfa, 0x04, 0x20, 0x97, 0x52, 0xc5, 0x76, 0xb7, 0x1c, 0x65, 0xab, 0x15, 0xae, 0xe6, 0xd5,
	0xb7, 0x62, 0x2a, 0xa4, 0x40, 0x2e, 0xf4, 0xfe, 0x75, 0x79, 0xcc, 0x63, 0xc5, 0x14, 0xba, 0x5a,
	0xb6, 0xd6, 0xe8, 0x21, 0xd4, 0xe6, 0x01, 0xf3, 0x65, 0x54, 0x55, 0x46, 0xbd, 0x53, 0x1e, 0xa5,
	0x76, 0xdf, 0xd5, 0xbc, 0xea, 0x5c, 0xc9, 0xc0, 0x13, 0x38, 0x10, 0x71, 0xf2, 0xef, 0x24, 0x12,
	0xeb, 0xd8, 0xaa, 0xdd, 0xd6, 0xd0, 0xe2, 0xe2, 0x8a, 0x86, 0xae, 0x8a, 0x8b, 0xfc, 0x08, 0x9a,
	0x5b, 0x2c, 0x31, 0x4f, 0xad, 0xfa, 0x6d, 0x24, 0x16, 0x16, 0x49, 0x90, 0xb8, 0xca, 0xaf, 0x4e,
	0x05, 0xf6, 0xd8, 0x32, 0x72, 0xbe, 0x3a, 0x5f, 0x77, 0xf4, 0x8b, 0x75, 0x47, 0xff, 0x6d, 0xdd,
	0xd1, 0x7f, 0xbc, 0xea, 0x68, 0x17, 0x57, 0x1d, 0xed, 0xd7, 0xab, 0x8e, 0xf6, 0xcd, 0x83, 0x19,
	0xe1, 0xf3, 0xe5, 0xc4, 0x9e, 0xd2, 0xa8, 0x3f, 0xa5, 0x11, 0xe6, 0x93, 0x6f, 0x79, 0x7e, 0xc8,
	0xbe, 0x38, 0xca, 0xbe, 0x59, 0x26, 0xfb, 0xd2, 0x76, 0xf2, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xfe, 0x06, 0x66, 0x65, 0xd2, 0x08, 0x00, 0x00,
}

func (m *NewRoundStep) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NewRoundStep) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NewRoundStep) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastCommitRound != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.LastCommitRound))
		i--
		dAtA[i] = 0x28
	}
	if m.SecondsSinceStartTime != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.SecondsSinceStartTime))
		i--
		dAtA[i] = 0x20
	}
	if m.Step != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Step))
		i--
		dAtA[i] = 0x18
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NewValidBlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NewValidBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NewValidBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsCommit {
		i--
		if m.IsCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.BlockParts != nil {
		{
			size, err := m.BlockParts.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	{
		size, err := m.BlockPartSetHeader.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Proposal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Proposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Proposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Proposal.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ProposalPOL) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProposalPOL) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProposalPOL) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.ProposalPol.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if m.ProposalPolRound != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.ProposalPolRound))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BlockPart) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlockPart) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BlockPart) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Part.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Vote) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Vote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Vote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Vote != nil {
		{
			size, err := m.Vote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HasVote) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HasVote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HasVote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x20
	}
	if m.Type != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *VoteSetMaj23) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VoteSetMaj23) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VoteSetMaj23) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.BlockID.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.Type != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *VoteSetBits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VoteSetBits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VoteSetBits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Votes.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	{
		size, err := m.BlockID.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.Type != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Message) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Sum != nil {
		{
			size := m.Sum.Size()
			i -= size
			if _, err := m.Sum.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Message_NewRoundStep) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_NewRoundStep) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.NewRoundStep != nil {
		{
			size, err := m.NewRoundStep.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Message_NewValidBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_NewValidBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.NewValidBlock != nil {
		{
			size, err := m.NewValidBlock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Message_Proposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_Proposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Proposal != nil {
		{
			size, err := m.Proposal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Message_ProposalPol) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_ProposalPol) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ProposalPol != nil {
		{
			size, err := m.ProposalPol.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Message_BlockPart) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_BlockPart) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BlockPart != nil {
		{
			size, err := m.BlockPart.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Message_Vote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_Vote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Vote != nil {
		{
			size, err := m.Vote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Message_HasVote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_HasVote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HasVote != nil {
		{
			size, err := m.HasVote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Message_VoteSetMaj23) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_VoteSetMaj23) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.VoteSetMaj23 != nil {
		{
			size, err := m.VoteSetMaj23.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Message_VoteSetBits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message_VoteSetBits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.VoteSetBits != nil {
		{
			size, err := m.VoteSetBits.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	offset -= sovTypes(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NewRoundStep) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if m.Step != 0 {
		n += 1 + sovTypes(uint64(m.Step))
	}
	if m.SecondsSinceStartTime != 0 {
		n += 1 + sovTypes(uint64(m.SecondsSinceStartTime))
	}
	if m.LastCommitRound != 0 {
		n += 1 + sovTypes(uint64(m.LastCommitRound))
	}
	return n
}

func (m *NewValidBlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	l = m.BlockPartSetHeader.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.BlockParts != nil {
		l = m.BlockParts.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.IsCommit {
		n += 2
	}
	return n
}

func (m *Proposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Proposal.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *ProposalPOL) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.ProposalPolRound != 0 {
		n += 1 + sovTypes(uint64(m.ProposalPolRound))
	}
	l = m.ProposalPol.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *BlockPart) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	l = m.Part.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *Vote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Vote != nil {
		l = m.Vote.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *HasVote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	return n
}

func (m *VoteSetMaj23) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = m.BlockID.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *VoteSetBits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = m.BlockID.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Votes.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *Message) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sum != nil {
		n += m.Sum.Size()
	}
	return n
}

func (m *Message_NewRoundStep) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NewRoundStep != nil {
		l = m.NewRoundStep.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_NewValidBlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NewValidBlock != nil {
		l = m.NewValidBlock.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_Proposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Proposal != nil {
		l = m.Proposal.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_ProposalPol) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProposalPol != nil {
		l = m.ProposalPol.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_BlockPart) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BlockPart != nil {
		l = m.BlockPart.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_Vote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Vote != nil {
		l = m.Vote.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_HasVote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HasVote != nil {
		l = m.HasVote.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_VoteSetMaj23) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VoteSetMaj23 != nil {
		l = m.VoteSetMaj23.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Message_VoteSetBits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VoteSetBits != nil {
		l = m.VoteSetBits.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func sovTypes(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NewRoundStep) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NewRoundStep: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NewRoundStep: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Step", wireType)
			}
			m.Step = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Step |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecondsSinceStartTime", wireType)
			}
			m.SecondsSinceStartTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SecondsSinceStartTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastCommitRound", wireType)
			}
			m.LastCommitRound = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastCommitRound |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NewValidBlock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NewValidBlock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NewValidBlock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockPartSetHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BlockPartSetHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockParts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BlockParts == nil {
				m.BlockParts = &bits.BitArray{}
			}
			if err := m.BlockParts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsCommit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Proposal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Proposal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Proposal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Proposal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProposalPOL) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProposalPOL: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProposalPOL: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposalPolRound", wireType)
			}
			m.ProposalPolRound = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProposalPolRound |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposalPol", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposalPol.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlockPart) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlockPart: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlockPart: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Part", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Part.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Vote) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Vote: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Vote: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Vote == nil {
				m.Vote = &types.Vote{}
			}
			if err := m.Vote.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HasVote) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HasVote: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HasVote: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= types.SignedMsgType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VoteSetMaj23) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VoteSetMaj23: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VoteSetMaj23: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= types.SignedMsgType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BlockID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VoteSetBits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VoteSetBits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VoteSetBits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= types.SignedMsgType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BlockID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Votes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Votes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Message) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRoundStep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NewRoundStep{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_NewRoundStep{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewValidBlock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NewValidBlock{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_NewValidBlock{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Proposal{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_Proposal{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposalPol", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProposalPOL{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_ProposalPol{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockPart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BlockPart{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_BlockPart{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Vote{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_Vote{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasVote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HasVote{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_HasVote{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteSetMaj23", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VoteSetMaj23{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_VoteSetMaj23{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteSetBits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VoteSetBits{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Sum = &Message_VoteSetBits{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTypes
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTypes
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTypes        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTypes = fmt.Errorf("proto: unexpected end of group")
)
