package types

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestQueryTxFor(t *testing.T) {
	tx := Tx("foo")
	assert.Equal(t,
		fmt.Sprintf("tm.event='Tx' AND tx.hash='%X'", tx.Hash()),
		EventQueryTxFor(tx).String(),
	)
}

func TestQueryForEvent(t *testing.T) {
	assert.Equal(t,
		"tm.event='NewBlock'",
		QueryForEvent(EventNewBlock).String(),
	)
	assert.Equal(t,
		"tm.event='NewEvidence'",
		QueryForEvent(EventNewEvidence).String(),
	)
}
