package query

// Code generated by ./.bin/peg -inline -switch query.peg DO NOT EDIT.

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	rulee
	rulecondition
	ruletag
	rulevalue
	rulenumber
	ruledigit
	ruletime
	ruledate
	ruleyear
	rulemonth
	ruleday
	ruleand
	ruleequal
	rulecontains
	ruleexists
	rulele
	rulege
	rulel
	ruleg
	rulePegText
)

var rul3s = [...]string{
	"Unknown",
	"e",
	"condition",
	"tag",
	"value",
	"number",
	"digit",
	"time",
	"date",
	"year",
	"month",
	"day",
	"and",
	"equal",
	"contains",
	"exists",
	"le",
	"ge",
	"l",
	"g",
	"PegText",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type QueryParser struct {
	Buffer string
	buffer []rune
	rules  [21]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *QueryParser) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *QueryParser) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *QueryParser
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *QueryParser) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *QueryParser) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *QueryParser) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func Pretty(pretty bool) func(*QueryParser) error {
	return func(p *QueryParser) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*QueryParser) error {
	return func(p *QueryParser) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *QueryParser) Init(options ...func(*QueryParser) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 e <- <('"' condition (' '+ and ' '+ condition)* '"' !.)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
				if buffer[position] != rune('"') {
					goto l0
				}
				position++
				if !_rules[rulecondition]() {
					goto l0
				}
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l3
					}
					position++
				l4:
					{
						position5, tokenIndex5 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l5
						}
						position++
						goto l4
					l5:
						position, tokenIndex = position5, tokenIndex5
					}
					{
						position6 := position
						{
							position7, tokenIndex7 := position, tokenIndex
							if buffer[position] != rune('a') {
								goto l8
							}
							position++
							goto l7
						l8:
							position, tokenIndex = position7, tokenIndex7
							if buffer[position] != rune('A') {
								goto l3
							}
							position++
						}
					l7:
						{
							position9, tokenIndex9 := position, tokenIndex
							if buffer[position] != rune('n') {
								goto l10
							}
							position++
							goto l9
						l10:
							position, tokenIndex = position9, tokenIndex9
							if buffer[position] != rune('N') {
								goto l3
							}
							position++
						}
					l9:
						{
							position11, tokenIndex11 := position, tokenIndex
							if buffer[position] != rune('d') {
								goto l12
							}
							position++
							goto l11
						l12:
							position, tokenIndex = position11, tokenIndex11
							if buffer[position] != rune('D') {
								goto l3
							}
							position++
						}
					l11:
						add(ruleand, position6)
					}
					if buffer[position] != rune(' ') {
						goto l3
					}
					position++
				l13:
					{
						position14, tokenIndex14 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l14
						}
						position++
						goto l13
					l14:
						position, tokenIndex = position14, tokenIndex14
					}
					if !_rules[rulecondition]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				if buffer[position] != rune('"') {
					goto l0
				}
				position++
				{
					position15, tokenIndex15 := position, tokenIndex
					if !matchDot() {
						goto l15
					}
					goto l0
				l15:
					position, tokenIndex = position15, tokenIndex15
				}
				add(rulee, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 condition <- <(tag ' '* ((le ' '* ((&('D' | 'd') date) | (&('T' | 't') time) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') number))) / (ge ' '* ((&('D' | 'd') date) | (&('T' | 't') time) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') number))) / ((&('E' | 'e') exists) | (&('=') (equal ' '* ((&('\'') value) | (&('D' | 'd') date) | (&('T' | 't') time) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') number)))) | (&('>') (g ' '* ((&('D' | 'd') date) | (&('T' | 't') time) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') number)))) | (&('<') (l ' '* ((&('D' | 'd') date) | (&('T' | 't') time) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') number)))) | (&('C' | 'c') (contains ' '* value)))))> */
		func() bool {
			position16, tokenIndex16 := position, tokenIndex
			{
				position17 := position
				{
					position18 := position
					{
						position19 := position
						{
							position22, tokenIndex22 := position, tokenIndex
							{
								switch buffer[position] {
								case '<':
									if buffer[position] != rune('<') {
										goto l22
									}
									position++
								case '>':
									if buffer[position] != rune('>') {
										goto l22
									}
									position++
								case '=':
									if buffer[position] != rune('=') {
										goto l22
									}
									position++
								case '\'':
									if buffer[position] != rune('\'') {
										goto l22
									}
									position++
								case '"':
									if buffer[position] != rune('"') {
										goto l22
									}
									position++
								case ')':
									if buffer[position] != rune(')') {
										goto l22
									}
									position++
								case '(':
									if buffer[position] != rune('(') {
										goto l22
									}
									position++
								case '\\':
									if buffer[position] != rune('\\') {
										goto l22
									}
									position++
								case '\r':
									if buffer[position] != rune('\r') {
										goto l22
									}
									position++
								case '\n':
									if buffer[position] != rune('\n') {
										goto l22
									}
									position++
								case '\t':
									if buffer[position] != rune('\t') {
										goto l22
									}
									position++
								default:
									if buffer[position] != rune(' ') {
										goto l22
									}
									position++
								}
							}

							goto l16
						l22:
							position, tokenIndex = position22, tokenIndex22
						}
						if !matchDot() {
							goto l16
						}
					l20:
						{
							position21, tokenIndex21 := position, tokenIndex
							{
								position24, tokenIndex24 := position, tokenIndex
								{
									switch buffer[position] {
									case '<':
										if buffer[position] != rune('<') {
											goto l24
										}
										position++
									case '>':
										if buffer[position] != rune('>') {
											goto l24
										}
										position++
									case '=':
										if buffer[position] != rune('=') {
											goto l24
										}
										position++
									case '\'':
										if buffer[position] != rune('\'') {
											goto l24
										}
										position++
									case '"':
										if buffer[position] != rune('"') {
											goto l24
										}
										position++
									case ')':
										if buffer[position] != rune(')') {
											goto l24
										}
										position++
									case '(':
										if buffer[position] != rune('(') {
											goto l24
										}
										position++
									case '\\':
										if buffer[position] != rune('\\') {
											goto l24
										}
										position++
									case '\r':
										if buffer[position] != rune('\r') {
											goto l24
										}
										position++
									case '\n':
										if buffer[position] != rune('\n') {
											goto l24
										}
										position++
									case '\t':
										if buffer[position] != rune('\t') {
											goto l24
										}
										position++
									default:
										if buffer[position] != rune(' ') {
											goto l24
										}
										position++
									}
								}

								goto l21
							l24:
								position, tokenIndex = position24, tokenIndex24
							}
							if !matchDot() {
								goto l21
							}
							goto l20
						l21:
							position, tokenIndex = position21, tokenIndex21
						}
						add(rulePegText, position19)
					}
					add(ruletag, position18)
				}
			l26:
				{
					position27, tokenIndex27 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l27
					}
					position++
					goto l26
				l27:
					position, tokenIndex = position27, tokenIndex27
				}
				{
					position28, tokenIndex28 := position, tokenIndex
					{
						position30 := position
						if buffer[position] != rune('<') {
							goto l29
						}
						position++
						if buffer[position] != rune('=') {
							goto l29
						}
						position++
						add(rulele, position30)
					}
				l31:
					{
						position32, tokenIndex32 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l32
						}
						position++
						goto l31
					l32:
						position, tokenIndex = position32, tokenIndex32
					}
					{
						switch buffer[position] {
						case 'D', 'd':
							if !_rules[ruledate]() {
								goto l29
							}
						case 'T', 't':
							if !_rules[ruletime]() {
								goto l29
							}
						default:
							if !_rules[rulenumber]() {
								goto l29
							}
						}
					}

					goto l28
				l29:
					position, tokenIndex = position28, tokenIndex28
					{
						position35 := position
						if buffer[position] != rune('>') {
							goto l34
						}
						position++
						if buffer[position] != rune('=') {
							goto l34
						}
						position++
						add(rulege, position35)
					}
				l36:
					{
						position37, tokenIndex37 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l37
						}
						position++
						goto l36
					l37:
						position, tokenIndex = position37, tokenIndex37
					}
					{
						switch buffer[position] {
						case 'D', 'd':
							if !_rules[ruledate]() {
								goto l34
							}
						case 'T', 't':
							if !_rules[ruletime]() {
								goto l34
							}
						default:
							if !_rules[rulenumber]() {
								goto l34
							}
						}
					}

					goto l28
				l34:
					position, tokenIndex = position28, tokenIndex28
					{
						switch buffer[position] {
						case 'E', 'e':
							{
								position40 := position
								{
									position41, tokenIndex41 := position, tokenIndex
									if buffer[position] != rune('e') {
										goto l42
									}
									position++
									goto l41
								l42:
									position, tokenIndex = position41, tokenIndex41
									if buffer[position] != rune('E') {
										goto l16
									}
									position++
								}
							l41:
								{
									position43, tokenIndex43 := position, tokenIndex
									if buffer[position] != rune('x') {
										goto l44
									}
									position++
									goto l43
								l44:
									position, tokenIndex = position43, tokenIndex43
									if buffer[position] != rune('X') {
										goto l16
									}
									position++
								}
							l43:
								{
									position45, tokenIndex45 := position, tokenIndex
									if buffer[position] != rune('i') {
										goto l46
									}
									position++
									goto l45
								l46:
									position, tokenIndex = position45, tokenIndex45
									if buffer[position] != rune('I') {
										goto l16
									}
									position++
								}
							l45:
								{
									position47, tokenIndex47 := position, tokenIndex
									if buffer[position] != rune('s') {
										goto l48
									}
									position++
									goto l47
								l48:
									position, tokenIndex = position47, tokenIndex47
									if buffer[position] != rune('S') {
										goto l16
									}
									position++
								}
							l47:
								{
									position49, tokenIndex49 := position, tokenIndex
									if buffer[position] != rune('t') {
										goto l50
									}
									position++
									goto l49
								l50:
									position, tokenIndex = position49, tokenIndex49
									if buffer[position] != rune('T') {
										goto l16
									}
									position++
								}
							l49:
								{
									position51, tokenIndex51 := position, tokenIndex
									if buffer[position] != rune('s') {
										goto l52
									}
									position++
									goto l51
								l52:
									position, tokenIndex = position51, tokenIndex51
									if buffer[position] != rune('S') {
										goto l16
									}
									position++
								}
							l51:
								add(ruleexists, position40)
							}
						case '=':
							{
								position53 := position
								if buffer[position] != rune('=') {
									goto l16
								}
								position++
								add(ruleequal, position53)
							}
						l54:
							{
								position55, tokenIndex55 := position, tokenIndex
								if buffer[position] != rune(' ') {
									goto l55
								}
								position++
								goto l54
							l55:
								position, tokenIndex = position55, tokenIndex55
							}
							{
								switch buffer[position] {
								case '\'':
									if !_rules[rulevalue]() {
										goto l16
									}
								case 'D', 'd':
									if !_rules[ruledate]() {
										goto l16
									}
								case 'T', 't':
									if !_rules[ruletime]() {
										goto l16
									}
								default:
									if !_rules[rulenumber]() {
										goto l16
									}
								}
							}

						case '>':
							{
								position57 := position
								if buffer[position] != rune('>') {
									goto l16
								}
								position++
								add(ruleg, position57)
							}
						l58:
							{
								position59, tokenIndex59 := position, tokenIndex
								if buffer[position] != rune(' ') {
									goto l59
								}
								position++
								goto l58
							l59:
								position, tokenIndex = position59, tokenIndex59
							}
							{
								switch buffer[position] {
								case 'D', 'd':
									if !_rules[ruledate]() {
										goto l16
									}
								case 'T', 't':
									if !_rules[ruletime]() {
										goto l16
									}
								default:
									if !_rules[rulenumber]() {
										goto l16
									}
								}
							}

						case '<':
							{
								position61 := position
								if buffer[position] != rune('<') {
									goto l16
								}
								position++
								add(rulel, position61)
							}
						l62:
							{
								position63, tokenIndex63 := position, tokenIndex
								if buffer[position] != rune(' ') {
									goto l63
								}
								position++
								goto l62
							l63:
								position, tokenIndex = position63, tokenIndex63
							}
							{
								switch buffer[position] {
								case 'D', 'd':
									if !_rules[ruledate]() {
										goto l16
									}
								case 'T', 't':
									if !_rules[ruletime]() {
										goto l16
									}
								default:
									if !_rules[rulenumber]() {
										goto l16
									}
								}
							}

						default:
							{
								position65 := position
								{
									position66, tokenIndex66 := position, tokenIndex
									if buffer[position] != rune('c') {
										goto l67
									}
									position++
									goto l66
								l67:
									position, tokenIndex = position66, tokenIndex66
									if buffer[position] != rune('C') {
										goto l16
									}
									position++
								}
							l66:
								{
									position68, tokenIndex68 := position, tokenIndex
									if buffer[position] != rune('o') {
										goto l69
									}
									position++
									goto l68
								l69:
									position, tokenIndex = position68, tokenIndex68
									if buffer[position] != rune('O') {
										goto l16
									}
									position++
								}
							l68:
								{
									position70, tokenIndex70 := position, tokenIndex
									if buffer[position] != rune('n') {
										goto l71
									}
									position++
									goto l70
								l71:
									position, tokenIndex = position70, tokenIndex70
									if buffer[position] != rune('N') {
										goto l16
									}
									position++
								}
							l70:
								{
									position72, tokenIndex72 := position, tokenIndex
									if buffer[position] != rune('t') {
										goto l73
									}
									position++
									goto l72
								l73:
									position, tokenIndex = position72, tokenIndex72
									if buffer[position] != rune('T') {
										goto l16
									}
									position++
								}
							l72:
								{
									position74, tokenIndex74 := position, tokenIndex
									if buffer[position] != rune('a') {
										goto l75
									}
									position++
									goto l74
								l75:
									position, tokenIndex = position74, tokenIndex74
									if buffer[position] != rune('A') {
										goto l16
									}
									position++
								}
							l74:
								{
									position76, tokenIndex76 := position, tokenIndex
									if buffer[position] != rune('i') {
										goto l77
									}
									position++
									goto l76
								l77:
									position, tokenIndex = position76, tokenIndex76
									if buffer[position] != rune('I') {
										goto l16
									}
									position++
								}
							l76:
								{
									position78, tokenIndex78 := position, tokenIndex
									if buffer[position] != rune('n') {
										goto l79
									}
									position++
									goto l78
								l79:
									position, tokenIndex = position78, tokenIndex78
									if buffer[position] != rune('N') {
										goto l16
									}
									position++
								}
							l78:
								{
									position80, tokenIndex80 := position, tokenIndex
									if buffer[position] != rune('s') {
										goto l81
									}
									position++
									goto l80
								l81:
									position, tokenIndex = position80, tokenIndex80
									if buffer[position] != rune('S') {
										goto l16
									}
									position++
								}
							l80:
								add(rulecontains, position65)
							}
						l82:
							{
								position83, tokenIndex83 := position, tokenIndex
								if buffer[position] != rune(' ') {
									goto l83
								}
								position++
								goto l82
							l83:
								position, tokenIndex = position83, tokenIndex83
							}
							if !_rules[rulevalue]() {
								goto l16
							}
						}
					}

				}
			l28:
				add(rulecondition, position17)
			}
			return true
		l16:
			position, tokenIndex = position16, tokenIndex16
			return false
		},
		/* 2 tag <- <<(!((&('<') '<') | (&('>') '>') | (&('=') '=') | (&('\'') '\'') | (&('"') '"') | (&(')') ')') | (&('(') '(') | (&('\\') '\\') | (&('\r') '\r') | (&('\n') '\n') | (&('\t') '\t') | (&(' ') ' ')) .)+>> */
		nil,
		/* 3 value <- <<('\'' (!('"' / '\'') .)* '\'')>> */
		func() bool {
			position85, tokenIndex85 := position, tokenIndex
			{
				position86 := position
				{
					position87 := position
					if buffer[position] != rune('\'') {
						goto l85
					}
					position++
				l88:
					{
						position89, tokenIndex89 := position, tokenIndex
						{
							position90, tokenIndex90 := position, tokenIndex
							{
								position91, tokenIndex91 := position, tokenIndex
								if buffer[position] != rune('"') {
									goto l92
								}
								position++
								goto l91
							l92:
								position, tokenIndex = position91, tokenIndex91
								if buffer[position] != rune('\'') {
									goto l90
								}
								position++
							}
						l91:
							goto l89
						l90:
							position, tokenIndex = position90, tokenIndex90
						}
						if !matchDot() {
							goto l89
						}
						goto l88
					l89:
						position, tokenIndex = position89, tokenIndex89
					}
					if buffer[position] != rune('\'') {
						goto l85
					}
					position++
					add(rulePegText, position87)
				}
				add(rulevalue, position86)
			}
			return true
		l85:
			position, tokenIndex = position85, tokenIndex85
			return false
		},
		/* 4 number <- <<('0' / ([1-9] digit* ('.' digit*)?))>> */
		func() bool {
			position93, tokenIndex93 := position, tokenIndex
			{
				position94 := position
				{
					position95 := position
					{
						position96, tokenIndex96 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l97
						}
						position++
						goto l96
					l97:
						position, tokenIndex = position96, tokenIndex96
						if c := buffer[position]; c < rune('1') || c > rune('9') {
							goto l93
						}
						position++
					l98:
						{
							position99, tokenIndex99 := position, tokenIndex
							if !_rules[ruledigit]() {
								goto l99
							}
							goto l98
						l99:
							position, tokenIndex = position99, tokenIndex99
						}
						{
							position100, tokenIndex100 := position, tokenIndex
							if buffer[position] != rune('.') {
								goto l100
							}
							position++
						l102:
							{
								position103, tokenIndex103 := position, tokenIndex
								if !_rules[ruledigit]() {
									goto l103
								}
								goto l102
							l103:
								position, tokenIndex = position103, tokenIndex103
							}
							goto l101
						l100:
							position, tokenIndex = position100, tokenIndex100
						}
					l101:
					}
				l96:
					add(rulePegText, position95)
				}
				add(rulenumber, position94)
			}
			return true
		l93:
			position, tokenIndex = position93, tokenIndex93
			return false
		},
		/* 5 digit <- <[0-9]> */
		func() bool {
			position104, tokenIndex104 := position, tokenIndex
			{
				position105 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l104
				}
				position++
				add(ruledigit, position105)
			}
			return true
		l104:
			position, tokenIndex = position104, tokenIndex104
			return false
		},
		/* 6 time <- <(('t' / 'T') ('i' / 'I') ('m' / 'M') ('e' / 'E') ' ' <(year '-' month '-' day 'T' digit digit ':' digit digit ':' digit digit ((('-' / '+') digit digit ':' digit digit) / 'Z'))>)> */
		func() bool {
			position106, tokenIndex106 := position, tokenIndex
			{
				position107 := position
				{
					position108, tokenIndex108 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l109
					}
					position++
					goto l108
				l109:
					position, tokenIndex = position108, tokenIndex108
					if buffer[position] != rune('T') {
						goto l106
					}
					position++
				}
			l108:
				{
					position110, tokenIndex110 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l111
					}
					position++
					goto l110
				l111:
					position, tokenIndex = position110, tokenIndex110
					if buffer[position] != rune('I') {
						goto l106
					}
					position++
				}
			l110:
				{
					position112, tokenIndex112 := position, tokenIndex
					if buffer[position] != rune('m') {
						goto l113
					}
					position++
					goto l112
				l113:
					position, tokenIndex = position112, tokenIndex112
					if buffer[position] != rune('M') {
						goto l106
					}
					position++
				}
			l112:
				{
					position114, tokenIndex114 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l115
					}
					position++
					goto l114
				l115:
					position, tokenIndex = position114, tokenIndex114
					if buffer[position] != rune('E') {
						goto l106
					}
					position++
				}
			l114:
				if buffer[position] != rune(' ') {
					goto l106
				}
				position++
				{
					position116 := position
					if !_rules[ruleyear]() {
						goto l106
					}
					if buffer[position] != rune('-') {
						goto l106
					}
					position++
					if !_rules[rulemonth]() {
						goto l106
					}
					if buffer[position] != rune('-') {
						goto l106
					}
					position++
					if !_rules[ruleday]() {
						goto l106
					}
					if buffer[position] != rune('T') {
						goto l106
					}
					position++
					if !_rules[ruledigit]() {
						goto l106
					}
					if !_rules[ruledigit]() {
						goto l106
					}
					if buffer[position] != rune(':') {
						goto l106
					}
					position++
					if !_rules[ruledigit]() {
						goto l106
					}
					if !_rules[ruledigit]() {
						goto l106
					}
					if buffer[position] != rune(':') {
						goto l106
					}
					position++
					if !_rules[ruledigit]() {
						goto l106
					}
					if !_rules[ruledigit]() {
						goto l106
					}
					{
						position117, tokenIndex117 := position, tokenIndex
						{
							position119, tokenIndex119 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l120
							}
							position++
							goto l119
						l120:
							position, tokenIndex = position119, tokenIndex119
							if buffer[position] != rune('+') {
								goto l118
							}
							position++
						}
					l119:
						if !_rules[ruledigit]() {
							goto l118
						}
						if !_rules[ruledigit]() {
							goto l118
						}
						if buffer[position] != rune(':') {
							goto l118
						}
						position++
						if !_rules[ruledigit]() {
							goto l118
						}
						if !_rules[ruledigit]() {
							goto l118
						}
						goto l117
					l118:
						position, tokenIndex = position117, tokenIndex117
						if buffer[position] != rune('Z') {
							goto l106
						}
						position++
					}
				l117:
					add(rulePegText, position116)
				}
				add(ruletime, position107)
			}
			return true
		l106:
			position, tokenIndex = position106, tokenIndex106
			return false
		},
		/* 7 date <- <(('d' / 'D') ('a' / 'A') ('t' / 'T') ('e' / 'E') ' ' <(year '-' month '-' day)>)> */
		func() bool {
			position121, tokenIndex121 := position, tokenIndex
			{
				position122 := position
				{
					position123, tokenIndex123 := position, tokenIndex
					if buffer[position] != rune('d') {
						goto l124
					}
					position++
					goto l123
				l124:
					position, tokenIndex = position123, tokenIndex123
					if buffer[position] != rune('D') {
						goto l121
					}
					position++
				}
			l123:
				{
					position125, tokenIndex125 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l126
					}
					position++
					goto l125
				l126:
					position, tokenIndex = position125, tokenIndex125
					if buffer[position] != rune('A') {
						goto l121
					}
					position++
				}
			l125:
				{
					position127, tokenIndex127 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l128
					}
					position++
					goto l127
				l128:
					position, tokenIndex = position127, tokenIndex127
					if buffer[position] != rune('T') {
						goto l121
					}
					position++
				}
			l127:
				{
					position129, tokenIndex129 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l130
					}
					position++
					goto l129
				l130:
					position, tokenIndex = position129, tokenIndex129
					if buffer[position] != rune('E') {
						goto l121
					}
					position++
				}
			l129:
				if buffer[position] != rune(' ') {
					goto l121
				}
				position++
				{
					position131 := position
					if !_rules[ruleyear]() {
						goto l121
					}
					if buffer[position] != rune('-') {
						goto l121
					}
					position++
					if !_rules[rulemonth]() {
						goto l121
					}
					if buffer[position] != rune('-') {
						goto l121
					}
					position++
					if !_rules[ruleday]() {
						goto l121
					}
					add(rulePegText, position131)
				}
				add(ruledate, position122)
			}
			return true
		l121:
			position, tokenIndex = position121, tokenIndex121
			return false
		},
		/* 8 year <- <(('1' / '2') digit digit digit)> */
		func() bool {
			position132, tokenIndex132 := position, tokenIndex
			{
				position133 := position
				{
					position134, tokenIndex134 := position, tokenIndex
					if buffer[position] != rune('1') {
						goto l135
					}
					position++
					goto l134
				l135:
					position, tokenIndex = position134, tokenIndex134
					if buffer[position] != rune('2') {
						goto l132
					}
					position++
				}
			l134:
				if !_rules[ruledigit]() {
					goto l132
				}
				if !_rules[ruledigit]() {
					goto l132
				}
				if !_rules[ruledigit]() {
					goto l132
				}
				add(ruleyear, position133)
			}
			return true
		l132:
			position, tokenIndex = position132, tokenIndex132
			return false
		},
		/* 9 month <- <(('0' / '1') digit)> */
		func() bool {
			position136, tokenIndex136 := position, tokenIndex
			{
				position137 := position
				{
					position138, tokenIndex138 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l139
					}
					position++
					goto l138
				l139:
					position, tokenIndex = position138, tokenIndex138
					if buffer[position] != rune('1') {
						goto l136
					}
					position++
				}
			l138:
				if !_rules[ruledigit]() {
					goto l136
				}
				add(rulemonth, position137)
			}
			return true
		l136:
			position, tokenIndex = position136, tokenIndex136
			return false
		},
		/* 10 day <- <(((&('3') '3') | (&('2') '2') | (&('1') '1') | (&('0') '0')) digit)> */
		func() bool {
			position140, tokenIndex140 := position, tokenIndex
			{
				position141 := position
				{
					switch buffer[position] {
					case '3':
						if buffer[position] != rune('3') {
							goto l140
						}
						position++
					case '2':
						if buffer[position] != rune('2') {
							goto l140
						}
						position++
					case '1':
						if buffer[position] != rune('1') {
							goto l140
						}
						position++
					default:
						if buffer[position] != rune('0') {
							goto l140
						}
						position++
					}
				}

				if !_rules[ruledigit]() {
					goto l140
				}
				add(ruleday, position141)
			}
			return true
		l140:
			position, tokenIndex = position140, tokenIndex140
			return false
		},
		/* 11 and <- <(('a' / 'A') ('n' / 'N') ('d' / 'D'))> */
		nil,
		/* 12 equal <- <'='> */
		nil,
		/* 13 contains <- <(('c' / 'C') ('o' / 'O') ('n' / 'N') ('t' / 'T') ('a' / 'A') ('i' / 'I') ('n' / 'N') ('s' / 'S'))> */
		nil,
		/* 14 exists <- <(('e' / 'E') ('x' / 'X') ('i' / 'I') ('s' / 'S') ('t' / 'T') ('s' / 'S'))> */
		nil,
		/* 15 le <- <('<' '=')> */
		nil,
		/* 16 ge <- <('>' '=')> */
		nil,
		/* 17 l <- <'<'> */
		nil,
		/* 18 g <- <'>'> */
		nil,
		nil,
	}
	p.rules = _rules
	return nil
}
