// Package token is generated by GoGLL. Do not edit
package token

import (
	"fmt"
)

// Token is returned by the lexer for every scanned lexical token
type Token struct {
	typ        Type
	lext, rext int
	input      []rune
}

/*
New returns a new token.
lext is the left extent and rext the right extent of the token in the input.
input is the input slice scanned by the lexer.
*/
func New(t Type, lext, rext int, input []rune) *Token {
	return &Token{
		typ:   t,
		lext:  lext,
		rext:  rext,
		input: input,
	}
}

// GetLineColumn returns the line and column of the left extent of t
func (t *Token) GetLineColumn() (line, col int) {
	line, col = 1, 1
	for j := 0; j < t.lext; j++ {
		switch t.input[j] {
		case '\n':
			line++
			col = 1
		case '\t':
			col += 4
		default:
			col++
		}
	}
	return
}

// GetInput returns the input from which t was parsed.
func (t *Token) GetInput() []rune {
	return t.input
}

// Lext returns the left extent of t in the input stream of runes
func (t *Token) Lext() int {
	return t.lext
}

// Literal returns the literal runes of t scanned by the lexer
func (t *Token) Literal() []rune {
	return t.input[t.lext:t.rext]
}

// LiteralString returns string(t.Literal())
func (t *Token) LiteralString() string {
	return string(t.Literal())
}

// LiteralStripEscape returns the literal runes of t scanned by the lexer
func (t *Token) LiteralStripEscape() []rune {
	lit := t.Literal()
	strip := make([]rune, 0, len(lit))
	for i := 0; i < len(lit); i++ {
		if lit[i] == '\\' {
			i++
			switch lit[i] {
			case 't':
				strip = append(strip, '\t')
			case 'r':
				strip = append(strip, '\r')
			case 'n':
				strip = append(strip, '\r')
			default:
				strip = append(strip, lit[i])
			}
		} else {
			strip = append(strip, lit[i])
		}
	}
	return strip
}

// LiteralStringStripEscape returns string(t.LiteralStripEscape())
func (t *Token) LiteralStringStripEscape() string {
	return string(t.LiteralStripEscape())
}

// Rext returns the right extent of t in the input stream of runes
func (t *Token) Rext() int {
	return t.rext
}

func (t *Token) String() string {
	return fmt.Sprintf("%s (%d,%d) %s",
		t.TypeID(), t.lext, t.rext, t.LiteralString())
}

// Suppress returns true iff t is suppressed by the lexer
func (t *Token) Suppress() bool {
	return Suppress[t.typ]
}

// Type returns the token Type of t
func (t *Token) Type() Type {
	return t.typ
}

// TypeID returns the token Type ID of t.
// This may be different from the literal of token t.
func (t *Token) TypeID() string {
	return t.Type().ID()
}

// Type is the token type
type Type int

func (t Type) String() string {
	return TypeToString[t]
}

// ID returns the token type ID of token Type t
func (t Type) ID() string {
	return TypeToID[t]
}

const (
	Error Type = iota // Error
	EOF               // $
	T_0               // apply_snapshot_chunk
	T_1               // commit
	T_2               // extend_vote
	T_3               // finalize_block
	T_4               // init_chain
	T_5               // offer_snapshot
	T_6               // prepare_proposal
	T_7               // process_proposal
	T_8               // verify_vote_extension
)

var TypeToString = []string{
	"Error",
	"EOF",
	"T_0",
	"T_1",
	"T_2",
	"T_3",
	"T_4",
	"T_5",
	"T_6",
	"T_7",
	"T_8",
}

var StringToType = map[string]Type{
	"Error": Error,
	"EOF":   EOF,
	"T_0":   T_0,
	"T_1":   T_1,
	"T_2":   T_2,
	"T_3":   T_3,
	"T_4":   T_4,
	"T_5":   T_5,
	"T_6":   T_6,
	"T_7":   T_7,
	"T_8":   T_8,
}

var TypeToID = []string{
	"Error",
	"$",
	"apply_snapshot_chunk",
	"commit",
	"extend_vote",
	"finalize_block",
	"init_chain",
	"offer_snapshot",
	"prepare_proposal",
	"process_proposal",
	"verify_vote_extension",
}

var IDToType = map[string]Type{
	"Error":                 0,
	"$":                     1,
	"apply_snapshot_chunk":  2,
	"commit":                3,
	"extend_vote":           4,
	"finalize_block":        5,
	"init_chain":            6,
	"offer_snapshot":        7,
	"prepare_proposal":      8,
	"process_proposal":      9,
	"verify_vote_extension": 10,
}

var Suppress = []bool{
	false,
	false,
	false,
	false,
	false,
	false,
	false,
	false,
	false,
	false,
	false,
}
