# The ``grammar`` folder structure

This folder has two subdirectories (`clean-start` and `recovery`), `checker.go` and `checker_test.go` files. 

Both `clean-start` and `recovery` folders have the same structure. They contain files with the context-free grammars 
`abci_grammar_clean_start.md` and `abci_grammar_recovery.md`, respectively. In addition, they have a subdirectory, 
`grammar-auto`, where the auto-generated code is stored. Namely, running `make grammar-gen` from the `e2e` directory will 
invoke the `gogll` program that will use `abci_grammar_clean_start.md` and `abci_grammar_recovery.md` grammars as 
input and produce lexer and parser for them. All the code `gogll` generates, is stored in the mentioned `grammar-auto` folder. 

`checker.go` and `checker_test.go` files contain the logic of the `GrammarChecker` abstraction and its tests. The 
`GrammarChecker` abstraction is used to check whether a specific set of `abci.Requests` respects the 
[ABCI grammar](https://github.com/cometbft/cometbft/blob/main/spec/abci/abci%2B%2B_comet_expected_behavior.md). It achieves this by using lexers 
and parsers generated by `gogll`. Namely, the only place where the auto-generated code is used is inside the `func (g *GrammarChecker) verifyRecovery(execution string) []*Error` function. 