

# events

`import "github.com/cometbft/cometbft/libs/events"`

## Overview

Pub-Sub in go with event caching

## Index

* [type EventCache](#type-eventcache)
    * [func NewEventCache(evsw Fireable) *EventCache](#func-neweventcache)
    * [func (evc *EventCache) FireEvent(event string, data EventData)](#func-eventcache-fireevent)
    * [func (evc *EventCache) Flush()](#func-eventcache-flush)
* [type EventCallback](#type-eventcallback)
* [type EventData](#type-eventdata)
* [type EventSwitch](#type-eventswitch)
    * [func NewEventSwitch() EventSwitch](#func-neweventswitch)
* [type Eventable](#type-eventable)
* [type Fireable](#type-fireable)


### Package files

[event_cache.go](./event_cache.go) [events.go](./events.go)


## Type [EventCache](./event_cache.go?s=116:179#L5)

``` go
type EventCache struct {
    // contains filtered or unexported fields
}
```

An EventCache buffers events for a Fireable
All events are cached. Filtering happens on Flush







### func [NewEventCache](./event_cache.go?s=239:284#L11)

``` go
func NewEventCache(evsw Fireable) *EventCache
```

Create a new EventCache with an EventSwitch as backend





### func (\*EventCache) [FireEvent](./event_cache.go?s=449:511#L24)

``` go
func (evc *EventCache) FireEvent(event string, data EventData)
```

Cache an event to be fired upon finality.




### func (\*EventCache) [Flush](./event_cache.go?s=735:765#L31)

``` go
func (evc *EventCache) Flush()
```

Fire events by running evsw.FireEvent on all cached events. Blocks.
Clears cached events




## Type [EventCallback](./events.go?s=4201:4240#L185)

``` go
type EventCallback func(data EventData)
```









## Type [EventData](./events.go?s=243:294#L14)

``` go
type EventData interface {
}
```

Generic event data can be typed and registered with [tendermint/go-amino](https://github.com/tendermint/go-amino)
via concrete implementation of this interface










## Type [EventSwitch](./events.go?s=560:771#L29)

``` go
type EventSwitch interface {
    service.Service
    Fireable

    AddListenerForEvent(listenerID, event string, cb EventCallback)
    RemoveListenerForEvent(event string, listenerID string)
    RemoveListener(listenerID string)
}
```






### func [NewEventSwitch](./events.go?s=917:950#L46)

``` go
func NewEventSwitch() EventSwitch
```




## Type [Eventable](./events.go?s=378:440#L20)

``` go
type Eventable interface {
    SetEventSwitch(evsw EventSwitch)
}
```

reactors and other modules should export
this interface to become eventable










## Type [Fireable](./events.go?s=490:558#L25)

``` go
type Fireable interface {
    FireEvent(event string, data EventData)
}
```

an event switch or cache implements fireable














- - -
Generated by [godoc2md](http://godoc.org/github.com/davecheney/godoc2md)
