---
order: 2
---

## How the Application Works

For the sake of simplicity, we will not be developing a fully functioning Forum Application. In our tutorial, we will focus
on `sender` and `messages` and the censorship of ill-behaved forum users.

The **Forum Application** accepts `sender` and `message` as input and checks if the `sender`
has been banned or not. If the `sender` is banned, it cannot send a `message` on the Forum.

If the `sender` is not banned, the `message` is checked for any curse words. If the `message` contains any curse words, the
`sender` is banned. If not, the `message` is persisted in the application state.

*Note: Curse words are defined in genesis, a copy of which is available with all nodes. To add a new curse word, the
node must use `VoteExtension`*

### Application Structure

In order to follow this tutorial, you can refer to the folder that hosts the finished [ABCI 2.0 Forum Application](../../../abci/tutorials/abci-v2-forum-app).

Here is an example of how the tutorial directory is structured:

- `abci`
    - `app.go`
    - `config.go`
    - `state.go`
    - `util.go`
- `model`
    - `db.go`
    - `messages.go`
    - `user.go`
- `forum.go`
- `app.toml`

---------------

*In the next session, you will learn more about how a user can [**send a message**](3.send-message.md) in the ABCI 2.0
Forum Application.*
