// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: cometbft/types/v1/params.proto

package v1

import (
	fmt "fmt"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	github_com_cosmos_gogoproto_types "github.com/cosmos/gogoproto/types"
	types "github.com/cosmos/gogoproto/types"
	_ "github.com/golang/protobuf/ptypes/duration"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ConsensusParams contains consensus critical parameters that determine the
// validity of blocks.
type ConsensusParams struct {
	Block     *BlockParams     `protobuf:"bytes,1,opt,name=block,proto3" json:"block,omitempty"`
	Evidence  *EvidenceParams  `protobuf:"bytes,2,opt,name=evidence,proto3" json:"evidence,omitempty"`
	Validator *ValidatorParams `protobuf:"bytes,3,opt,name=validator,proto3" json:"validator,omitempty"`
	Version   *VersionParams   `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	Abci      *ABCIParams      `protobuf:"bytes,5,opt,name=abci,proto3" json:"abci,omitempty"` // Deprecated: Do not use.
	Synchrony *SynchronyParams `protobuf:"bytes,6,opt,name=synchrony,proto3" json:"synchrony,omitempty"`
	Feature   *FeatureParams   `protobuf:"bytes,7,opt,name=feature,proto3" json:"feature,omitempty"`
}

func (m *ConsensusParams) Reset()         { *m = ConsensusParams{} }
func (m *ConsensusParams) String() string { return proto.CompactTextString(m) }
func (*ConsensusParams) ProtoMessage()    {}
func (*ConsensusParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{0}
}
func (m *ConsensusParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConsensusParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConsensusParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConsensusParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConsensusParams.Merge(m, src)
}
func (m *ConsensusParams) XXX_Size() int {
	return m.Size()
}
func (m *ConsensusParams) XXX_DiscardUnknown() {
	xxx_messageInfo_ConsensusParams.DiscardUnknown(m)
}

var xxx_messageInfo_ConsensusParams proto.InternalMessageInfo

func (m *ConsensusParams) GetBlock() *BlockParams {
	if m != nil {
		return m.Block
	}
	return nil
}

func (m *ConsensusParams) GetEvidence() *EvidenceParams {
	if m != nil {
		return m.Evidence
	}
	return nil
}

func (m *ConsensusParams) GetValidator() *ValidatorParams {
	if m != nil {
		return m.Validator
	}
	return nil
}

func (m *ConsensusParams) GetVersion() *VersionParams {
	if m != nil {
		return m.Version
	}
	return nil
}

// Deprecated: Do not use.
func (m *ConsensusParams) GetAbci() *ABCIParams {
	if m != nil {
		return m.Abci
	}
	return nil
}

func (m *ConsensusParams) GetSynchrony() *SynchronyParams {
	if m != nil {
		return m.Synchrony
	}
	return nil
}

func (m *ConsensusParams) GetFeature() *FeatureParams {
	if m != nil {
		return m.Feature
	}
	return nil
}

// BlockParams define limits on the block size and gas.
type BlockParams struct {
	// Maximum size of a block, in bytes.
	//
	// Must be greater or equal to -1 and cannot be greater than the hard-coded
	// maximum block size, which is 100MB.
	//
	// If set to -1, the limit is the hard-coded maximum block size.
	MaxBytes int64 `protobuf:"varint,1,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Maximum gas wanted by transactions included in a block.
	//
	// Must be greater or equal to -1. If set to -1, no limit is enforced.
	MaxGas int64 `protobuf:"varint,2,opt,name=max_gas,json=maxGas,proto3" json:"max_gas,omitempty"`
}

func (m *BlockParams) Reset()         { *m = BlockParams{} }
func (m *BlockParams) String() string { return proto.CompactTextString(m) }
func (*BlockParams) ProtoMessage()    {}
func (*BlockParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{1}
}
func (m *BlockParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BlockParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BlockParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BlockParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlockParams.Merge(m, src)
}
func (m *BlockParams) XXX_Size() int {
	return m.Size()
}
func (m *BlockParams) XXX_DiscardUnknown() {
	xxx_messageInfo_BlockParams.DiscardUnknown(m)
}

var xxx_messageInfo_BlockParams proto.InternalMessageInfo

func (m *BlockParams) GetMaxBytes() int64 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

func (m *BlockParams) GetMaxGas() int64 {
	if m != nil {
		return m.MaxGas
	}
	return 0
}

// EvidenceParams determine the validity of evidences of Byzantine behavior.
type EvidenceParams struct {
	// Maximum age of evidence, in blocks.
	//
	// The recommended formula for calculating it is max_age_duration / {average
	// block time}.
	MaxAgeNumBlocks int64 `protobuf:"varint,1,opt,name=max_age_num_blocks,json=maxAgeNumBlocks,proto3" json:"max_age_num_blocks,omitempty"`
	// Maximum age of evidence, in time.
	//
	// The recommended value of is should correspond to the application's
	// "unbonding period" or other similar mechanism for handling
	// Nothing-At-Stake attacks.
	// See: https://github.com/ethereum/wiki/wiki/Proof-of-Stake-FAQ#what-is-the-nothing-at-stake-problem-and-how-can-it-be-fixed.
	MaxAgeDuration time.Duration `protobuf:"bytes,2,opt,name=max_age_duration,json=maxAgeDuration,proto3,stdduration" json:"max_age_duration"`
	// Maximum size in bytes of evidence allowed to be included in a block.
	//
	// It should fall comfortably under the maximum size of a block.
	MaxBytes int64 `protobuf:"varint,3,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
}

func (m *EvidenceParams) Reset()         { *m = EvidenceParams{} }
func (m *EvidenceParams) String() string { return proto.CompactTextString(m) }
func (*EvidenceParams) ProtoMessage()    {}
func (*EvidenceParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{2}
}
func (m *EvidenceParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EvidenceParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EvidenceParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EvidenceParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvidenceParams.Merge(m, src)
}
func (m *EvidenceParams) XXX_Size() int {
	return m.Size()
}
func (m *EvidenceParams) XXX_DiscardUnknown() {
	xxx_messageInfo_EvidenceParams.DiscardUnknown(m)
}

var xxx_messageInfo_EvidenceParams proto.InternalMessageInfo

func (m *EvidenceParams) GetMaxAgeNumBlocks() int64 {
	if m != nil {
		return m.MaxAgeNumBlocks
	}
	return 0
}

func (m *EvidenceParams) GetMaxAgeDuration() time.Duration {
	if m != nil {
		return m.MaxAgeDuration
	}
	return 0
}

func (m *EvidenceParams) GetMaxBytes() int64 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

// ValidatorParams restrict the public key types validators can use.
//
// NOTE: uses ABCI public keys naming, not Amino names.
type ValidatorParams struct {
	PubKeyTypes []string `protobuf:"bytes,1,rep,name=pub_key_types,json=pubKeyTypes,proto3" json:"pub_key_types,omitempty"`
}

func (m *ValidatorParams) Reset()         { *m = ValidatorParams{} }
func (m *ValidatorParams) String() string { return proto.CompactTextString(m) }
func (*ValidatorParams) ProtoMessage()    {}
func (*ValidatorParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{3}
}
func (m *ValidatorParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidatorParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidatorParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidatorParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidatorParams.Merge(m, src)
}
func (m *ValidatorParams) XXX_Size() int {
	return m.Size()
}
func (m *ValidatorParams) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidatorParams.DiscardUnknown(m)
}

var xxx_messageInfo_ValidatorParams proto.InternalMessageInfo

func (m *ValidatorParams) GetPubKeyTypes() []string {
	if m != nil {
		return m.PubKeyTypes
	}
	return nil
}

// VersionParams contain the version of specific components of CometBFT.
type VersionParams struct {
	// The ABCI application version.
	//
	// It was named app_version in CometBFT 0.34.
	App uint64 `protobuf:"varint,1,opt,name=app,proto3" json:"app,omitempty"`
}

func (m *VersionParams) Reset()         { *m = VersionParams{} }
func (m *VersionParams) String() string { return proto.CompactTextString(m) }
func (*VersionParams) ProtoMessage()    {}
func (*VersionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{4}
}
func (m *VersionParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VersionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VersionParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VersionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionParams.Merge(m, src)
}
func (m *VersionParams) XXX_Size() int {
	return m.Size()
}
func (m *VersionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionParams.DiscardUnknown(m)
}

var xxx_messageInfo_VersionParams proto.InternalMessageInfo

func (m *VersionParams) GetApp() uint64 {
	if m != nil {
		return m.App
	}
	return 0
}

// HashedParams is a subset of ConsensusParams.
//
// It is hashed into the Header.ConsensusHash.
type HashedParams struct {
	BlockMaxBytes int64 `protobuf:"varint,1,opt,name=block_max_bytes,json=blockMaxBytes,proto3" json:"block_max_bytes,omitempty"`
	BlockMaxGas   int64 `protobuf:"varint,2,opt,name=block_max_gas,json=blockMaxGas,proto3" json:"block_max_gas,omitempty"`
}

func (m *HashedParams) Reset()         { *m = HashedParams{} }
func (m *HashedParams) String() string { return proto.CompactTextString(m) }
func (*HashedParams) ProtoMessage()    {}
func (*HashedParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{5}
}
func (m *HashedParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HashedParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HashedParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HashedParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HashedParams.Merge(m, src)
}
func (m *HashedParams) XXX_Size() int {
	return m.Size()
}
func (m *HashedParams) XXX_DiscardUnknown() {
	xxx_messageInfo_HashedParams.DiscardUnknown(m)
}

var xxx_messageInfo_HashedParams proto.InternalMessageInfo

func (m *HashedParams) GetBlockMaxBytes() int64 {
	if m != nil {
		return m.BlockMaxBytes
	}
	return 0
}

func (m *HashedParams) GetBlockMaxGas() int64 {
	if m != nil {
		return m.BlockMaxGas
	}
	return 0
}

// SynchronyParams determine the validity of block timestamps.
//
// These parameters are part of the Proposer-Based Timestamps (PBTS) algorithm.
// For more information on the relationship of the synchrony parameters to
// block timestamps validity, refer to the PBTS specification:
// https://github.com/tendermint/spec/blob/master/spec/consensus/proposer-based-timestamp/README.md
type SynchronyParams struct {
	// Bound for how skewed a proposer's clock may be from any validator on the
	// network while still producing valid proposals.
	Precision *time.Duration `protobuf:"bytes,1,opt,name=precision,proto3,stdduration" json:"precision,omitempty"`
	// Bound for how long a proposal message may take to reach all validators on
	// a network and still be considered valid.
	MessageDelay *time.Duration `protobuf:"bytes,2,opt,name=message_delay,json=messageDelay,proto3,stdduration" json:"message_delay,omitempty"`
}

func (m *SynchronyParams) Reset()         { *m = SynchronyParams{} }
func (m *SynchronyParams) String() string { return proto.CompactTextString(m) }
func (*SynchronyParams) ProtoMessage()    {}
func (*SynchronyParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{6}
}
func (m *SynchronyParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SynchronyParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SynchronyParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SynchronyParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SynchronyParams.Merge(m, src)
}
func (m *SynchronyParams) XXX_Size() int {
	return m.Size()
}
func (m *SynchronyParams) XXX_DiscardUnknown() {
	xxx_messageInfo_SynchronyParams.DiscardUnknown(m)
}

var xxx_messageInfo_SynchronyParams proto.InternalMessageInfo

func (m *SynchronyParams) GetPrecision() *time.Duration {
	if m != nil {
		return m.Precision
	}
	return nil
}

func (m *SynchronyParams) GetMessageDelay() *time.Duration {
	if m != nil {
		return m.MessageDelay
	}
	return nil
}

// FeatureParams configure the height from which features of CometBFT are enabled.
type FeatureParams struct {
	// Height during which vote extensions will be enabled.
	//
	// A value of 0 means vote extensions are disabled. A value > 0 denotes
	// the height at which vote extensions will be (or have been) enabled.
	//
	// During the specified height, and for all subsequent heights, precommit
	// messages that do not contain valid extension data will be considered
	// invalid. Prior to this height, or when this height is set to 0, vote
	// extensions will not be used or accepted by validators on the network.
	//
	// Once enabled, vote extensions will be created by the application in
	// ExtendVote, validated by the application in VerifyVoteExtension, and
	// used by the application in PrepareProposal, when proposing the next block.
	//
	// Cannot be set to heights lower or equal to the current blockchain height.
	VoteExtensionsEnableHeight *types.Int64Value `protobuf:"bytes,1,opt,name=vote_extensions_enable_height,json=voteExtensionsEnableHeight,proto3" json:"vote_extensions_enable_height,omitempty"`
	// Height at which Proposer-Based Timestamps (PBTS) will be enabled.
	//
	// A value of 0 means PBTS is disabled. A value > 0 denotes the height at
	// which PBTS will be (or has been) enabled.
	//
	// From the specified height, and for all subsequent heights, the PBTS
	// algorithm will be used to produce and validate block timestamps. Prior to
	// this height, or when this height is set to 0, the legacy BFT Time
	// algorithm is used to produce and validate timestamps.
	//
	// Cannot be set to heights lower or equal to the current blockchain height.
	PbtsEnableHeight *types.Int64Value `protobuf:"bytes,2,opt,name=pbts_enable_height,json=pbtsEnableHeight,proto3" json:"pbts_enable_height,omitempty"`
}

func (m *FeatureParams) Reset()         { *m = FeatureParams{} }
func (m *FeatureParams) String() string { return proto.CompactTextString(m) }
func (*FeatureParams) ProtoMessage()    {}
func (*FeatureParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{7}
}
func (m *FeatureParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FeatureParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FeatureParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FeatureParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeatureParams.Merge(m, src)
}
func (m *FeatureParams) XXX_Size() int {
	return m.Size()
}
func (m *FeatureParams) XXX_DiscardUnknown() {
	xxx_messageInfo_FeatureParams.DiscardUnknown(m)
}

var xxx_messageInfo_FeatureParams proto.InternalMessageInfo

func (m *FeatureParams) GetVoteExtensionsEnableHeight() *types.Int64Value {
	if m != nil {
		return m.VoteExtensionsEnableHeight
	}
	return nil
}

func (m *FeatureParams) GetPbtsEnableHeight() *types.Int64Value {
	if m != nil {
		return m.PbtsEnableHeight
	}
	return nil
}

// ABCIParams is deprecated and its contents moved to FeatureParams
//
// Deprecated: Do not use.
type ABCIParams struct {
	// vote_extensions_enable_height has been deprecated.
	// Instead, use FeatureParams.vote_extensions_enable_height.
	VoteExtensionsEnableHeight int64 `protobuf:"varint,1,opt,name=vote_extensions_enable_height,json=voteExtensionsEnableHeight,proto3" json:"vote_extensions_enable_height,omitempty"`
}

func (m *ABCIParams) Reset()         { *m = ABCIParams{} }
func (m *ABCIParams) String() string { return proto.CompactTextString(m) }
func (*ABCIParams) ProtoMessage()    {}
func (*ABCIParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c2f6d19461b2fe7, []int{8}
}
func (m *ABCIParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ABCIParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ABCIParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ABCIParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ABCIParams.Merge(m, src)
}
func (m *ABCIParams) XXX_Size() int {
	return m.Size()
}
func (m *ABCIParams) XXX_DiscardUnknown() {
	xxx_messageInfo_ABCIParams.DiscardUnknown(m)
}

var xxx_messageInfo_ABCIParams proto.InternalMessageInfo

func (m *ABCIParams) GetVoteExtensionsEnableHeight() int64 {
	if m != nil {
		return m.VoteExtensionsEnableHeight
	}
	return 0
}

func init() {
	proto.RegisterType((*ConsensusParams)(nil), "cometbft.types.v1.ConsensusParams")
	proto.RegisterType((*BlockParams)(nil), "cometbft.types.v1.BlockParams")
	proto.RegisterType((*EvidenceParams)(nil), "cometbft.types.v1.EvidenceParams")
	proto.RegisterType((*ValidatorParams)(nil), "cometbft.types.v1.ValidatorParams")
	proto.RegisterType((*VersionParams)(nil), "cometbft.types.v1.VersionParams")
	proto.RegisterType((*HashedParams)(nil), "cometbft.types.v1.HashedParams")
	proto.RegisterType((*SynchronyParams)(nil), "cometbft.types.v1.SynchronyParams")
	proto.RegisterType((*FeatureParams)(nil), "cometbft.types.v1.FeatureParams")
	proto.RegisterType((*ABCIParams)(nil), "cometbft.types.v1.ABCIParams")
}

func init() { proto.RegisterFile("cometbft/types/v1/params.proto", fileDescriptor_8c2f6d19461b2fe7) }

var fileDescriptor_8c2f6d19461b2fe7 = []byte{
	// 729 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x94, 0xbf, 0x4e, 0xdb, 0x50,
	0x14, 0xc6, 0x73, 0xe3, 0x00, 0xc9, 0x09, 0x21, 0xe9, 0x55, 0xa5, 0xba, 0x20, 0x1c, 0xea, 0xa1,
	0x42, 0x42, 0xb2, 0x05, 0xa5, 0x1d, 0x90, 0x50, 0x4b, 0x80, 0x02, 0xad, 0x68, 0x91, 0xa9, 0x18,
	0x58, 0xac, 0xeb, 0xe4, 0xe2, 0x58, 0xc4, 0x7f, 0xe4, 0x6b, 0xa7, 0xc9, 0x5b, 0x74, 0xaa, 0x3a,
	0x32, 0xb6, 0x6f, 0xd0, 0xbe, 0x40, 0xc5, 0xc8, 0xd8, 0x89, 0x56, 0x61, 0xe9, 0x63, 0x54, 0xbe,
	0xb6, 0x13, 0x12, 0x42, 0x61, 0xb3, 0x7d, 0xbe, 0xdf, 0xe7, 0xef, 0x9e, 0x73, 0x6c, 0x90, 0xea,
	0xae, 0x4d, 0x03, 0xe3, 0x24, 0x50, 0x83, 0xae, 0x47, 0x99, 0xda, 0x5e, 0x56, 0x3d, 0xe2, 0x13,
	0x9b, 0x29, 0x9e, 0xef, 0x06, 0x2e, 0x7e, 0x90, 0xd6, 0x15, 0x5e, 0x57, 0xda, 0xcb, 0xb3, 0x0f,
	0x4d, 0xd7, 0x74, 0x79, 0x55, 0x8d, 0xae, 0x62, 0xe1, 0xac, 0x64, 0xba, 0xae, 0xd9, 0xa2, 0x2a,
	0xbf, 0x33, 0xc2, 0x13, 0xb5, 0x11, 0xfa, 0x24, 0xb0, 0x5c, 0xe7, 0xb6, 0xfa, 0x47, 0x9f, 0x78,
	0x1e, 0xf5, 0x93, 0x17, 0xc9, 0x3f, 0x04, 0x28, 0x6f, 0xba, 0x0e, 0xa3, 0x0e, 0x0b, 0xd9, 0x01,
	0x8f, 0x80, 0x57, 0x61, 0xc2, 0x68, 0xb9, 0xf5, 0x53, 0x11, 0x2d, 0xa0, 0xc5, 0xe2, 0x8a, 0xa4,
	0xdc, 0x08, 0xa3, 0xd4, 0xa2, 0x7a, 0x2c, 0xd7, 0x62, 0x31, 0x5e, 0x87, 0x3c, 0x6d, 0x5b, 0x0d,
	0xea, 0xd4, 0xa9, 0x98, 0xe5, 0xe0, 0x93, 0x31, 0xe0, 0x76, 0x22, 0x49, 0xd8, 0x3e, 0x82, 0x5f,
	0x41, 0xa1, 0x4d, 0x5a, 0x56, 0x83, 0x04, 0xae, 0x2f, 0x0a, 0x9c, 0x97, 0xc7, 0xf0, 0x47, 0xa9,
	0x26, 0x31, 0x18, 0x40, 0x78, 0x0d, 0xa6, 0xda, 0xd4, 0x67, 0x96, 0xeb, 0x88, 0x39, 0xce, 0x2f,
	0x8c, 0xe3, 0x63, 0x45, 0x42, 0xa7, 0x00, 0x7e, 0x0e, 0x39, 0x62, 0xd4, 0x2d, 0x71, 0x82, 0x83,
	0xf3, 0x63, 0xc0, 0x8d, 0xda, 0xe6, 0x5e, 0x4c, 0xd5, 0xb2, 0x22, 0xd2, 0xb8, 0x3c, 0x0a, 0xcd,
	0xba, 0x4e, 0xbd, 0xe9, 0xbb, 0x4e, 0x57, 0x9c, 0xbc, 0x35, 0xf4, 0x61, 0xaa, 0x49, 0x43, 0xf7,
	0xa1, 0x28, 0xf4, 0x09, 0x25, 0x41, 0xe8, 0x53, 0x71, 0xea, 0xd6, 0xd0, 0xaf, 0x63, 0x45, 0x1a,
	0x3a, 0x01, 0xe4, 0x3d, 0x28, 0x5e, 0x9b, 0x03, 0x9e, 0x83, 0x82, 0x4d, 0x3a, 0xba, 0xd1, 0x0d,
	0x28, 0xe3, 0xa3, 0x13, 0xb4, 0xbc, 0x4d, 0x3a, 0xb5, 0xe8, 0x1e, 0x3f, 0x82, 0xa9, 0xa8, 0x68,
	0x12, 0xc6, 0x87, 0x23, 0x68, 0x93, 0x36, 0xe9, 0xec, 0x10, 0xf6, 0x26, 0x97, 0x17, 0x2a, 0x39,
	0xf9, 0x1b, 0x82, 0x99, 0xe1, 0xd1, 0xe0, 0x25, 0xc0, 0x11, 0x41, 0x4c, 0xaa, 0x3b, 0xa1, 0xad,
	0xf3, 0x21, 0xa7, 0xbe, 0x65, 0x9b, 0x74, 0x36, 0x4c, 0xfa, 0x2e, 0xb4, 0x79, 0x00, 0x86, 0xf7,
	0xa1, 0x92, 0x8a, 0xd3, 0x05, 0x4c, 0x96, 0xe0, 0xb1, 0x12, 0x6f, 0xa0, 0x92, 0x6e, 0xa0, 0xb2,
	0x95, 0x08, 0x6a, 0xf9, 0xf3, 0xcb, 0x6a, 0xe6, 0xcb, 0xef, 0x2a, 0xd2, 0x66, 0x62, 0xbf, 0xb4,
	0x32, 0x7c, 0x14, 0x61, 0xf8, 0x28, 0xf2, 0x4b, 0x28, 0x8f, 0x6c, 0x01, 0x96, 0xa1, 0xe4, 0x85,
	0x86, 0x7e, 0x4a, 0xbb, 0x3a, 0x6f, 0x9a, 0x88, 0x16, 0x84, 0xc5, 0x82, 0x56, 0xf4, 0x42, 0xe3,
	0x2d, 0xed, 0x7e, 0x88, 0x1e, 0xad, 0xe5, 0xbf, 0x9f, 0x55, 0xd1, 0xdf, 0xb3, 0x2a, 0x92, 0x97,
	0xa0, 0x34, 0xb4, 0x06, 0xb8, 0x02, 0x02, 0xf1, 0x3c, 0x7e, 0xb6, 0x9c, 0x16, 0x5d, 0x5e, 0x13,
	0x1f, 0xc3, 0xf4, 0x2e, 0x61, 0x4d, 0xda, 0x48, 0xb4, 0x4f, 0xa1, 0xcc, 0x5b, 0xa1, 0x8f, 0xf6,
	0xba, 0xc4, 0x1f, 0xef, 0xa7, 0x0d, 0x97, 0xa1, 0x34, 0xd0, 0x0d, 0xda, 0x5e, 0x4c, 0x55, 0x3b,
	0x84, 0xc9, 0x9f, 0x11, 0x94, 0x47, 0x76, 0x03, 0xaf, 0x43, 0xc1, 0xf3, 0x69, 0xdd, 0xe2, 0x7b,
	0x8c, 0xee, 0x6a, 0x61, 0x8e, 0xb7, 0x6f, 0x40, 0xe0, 0x2d, 0x28, 0xd9, 0x94, 0x31, 0x3e, 0x08,
	0xda, 0x22, 0xdd, 0xbb, 0xa7, 0x10, 0x5b, 0x4c, 0x27, 0xd4, 0x56, 0x04, 0xc9, 0x3f, 0x11, 0x94,
	0x86, 0x96, 0x0e, 0x37, 0x60, 0xbe, 0xed, 0x06, 0x54, 0xa7, 0x9d, 0x80, 0x3a, 0xd1, 0x9b, 0x98,
	0x4e, 0x1d, 0x62, 0xb4, 0xa8, 0xde, 0xa4, 0x96, 0xd9, 0x0c, 0x92, 0xa8, 0x73, 0x37, 0xde, 0xb3,
	0xe7, 0x04, 0x2f, 0x56, 0x8f, 0x48, 0x2b, 0xa4, 0xb5, 0xdc, 0xf9, 0x65, 0x15, 0x69, 0xb3, 0x91,
	0xcf, 0x76, 0xdf, 0x66, 0x9b, 0xbb, 0xec, 0x72, 0x13, 0xfc, 0x1e, 0xb0, 0x67, 0x04, 0xa3, 0xd6,
	0xd9, 0xfb, 0x5a, 0x57, 0x22, 0xf8, 0xba, 0xa1, 0x7c, 0x08, 0x30, 0xf8, 0x70, 0xf1, 0xc6, 0x7d,
	0x0e, 0x21, 0xfc, 0x2f, 0xe1, 0x5a, 0x56, 0x44, 0xb5, 0x83, 0xaf, 0x3d, 0x09, 0x9d, 0xf7, 0x24,
	0x74, 0xd1, 0x93, 0xd0, 0x9f, 0x9e, 0x84, 0x3e, 0x5d, 0x49, 0x99, 0x8b, 0x2b, 0x29, 0xf3, 0xeb,
	0x4a, 0xca, 0x1c, 0xaf, 0x98, 0x56, 0xd0, 0x0c, 0x8d, 0xe8, 0x33, 0x56, 0xfb, 0x7f, 0xf9, 0xfe,
	0x05, 0xf1, 0x2c, 0xf5, 0xc6, 0xbf, 0xdf, 0x98, 0xe4, 0x67, 0x7a, 0xf6, 0x2f, 0x00, 0x00, 0xff,
	0xff, 0xd6, 0x46, 0x5b, 0x10, 0x17, 0x06, 0x00, 0x00,
}

func (this *ConsensusParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConsensusParams)
	if !ok {
		that2, ok := that.(ConsensusParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Block.Equal(that1.Block) {
		return false
	}
	if !this.Evidence.Equal(that1.Evidence) {
		return false
	}
	if !this.Validator.Equal(that1.Validator) {
		return false
	}
	if !this.Version.Equal(that1.Version) {
		return false
	}
	if !this.Abci.Equal(that1.Abci) {
		return false
	}
	if !this.Synchrony.Equal(that1.Synchrony) {
		return false
	}
	if !this.Feature.Equal(that1.Feature) {
		return false
	}
	return true
}
func (this *BlockParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BlockParams)
	if !ok {
		that2, ok := that.(BlockParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MaxBytes != that1.MaxBytes {
		return false
	}
	if this.MaxGas != that1.MaxGas {
		return false
	}
	return true
}
func (this *EvidenceParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EvidenceParams)
	if !ok {
		that2, ok := that.(EvidenceParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MaxAgeNumBlocks != that1.MaxAgeNumBlocks {
		return false
	}
	if this.MaxAgeDuration != that1.MaxAgeDuration {
		return false
	}
	if this.MaxBytes != that1.MaxBytes {
		return false
	}
	return true
}
func (this *ValidatorParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ValidatorParams)
	if !ok {
		that2, ok := that.(ValidatorParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.PubKeyTypes) != len(that1.PubKeyTypes) {
		return false
	}
	for i := range this.PubKeyTypes {
		if this.PubKeyTypes[i] != that1.PubKeyTypes[i] {
			return false
		}
	}
	return true
}
func (this *VersionParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VersionParams)
	if !ok {
		that2, ok := that.(VersionParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.App != that1.App {
		return false
	}
	return true
}
func (this *HashedParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HashedParams)
	if !ok {
		that2, ok := that.(HashedParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BlockMaxBytes != that1.BlockMaxBytes {
		return false
	}
	if this.BlockMaxGas != that1.BlockMaxGas {
		return false
	}
	return true
}
func (this *SynchronyParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SynchronyParams)
	if !ok {
		that2, ok := that.(SynchronyParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Precision != nil && that1.Precision != nil {
		if *this.Precision != *that1.Precision {
			return false
		}
	} else if this.Precision != nil {
		return false
	} else if that1.Precision != nil {
		return false
	}
	if this.MessageDelay != nil && that1.MessageDelay != nil {
		if *this.MessageDelay != *that1.MessageDelay {
			return false
		}
	} else if this.MessageDelay != nil {
		return false
	} else if that1.MessageDelay != nil {
		return false
	}
	return true
}
func (this *FeatureParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FeatureParams)
	if !ok {
		that2, ok := that.(FeatureParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.VoteExtensionsEnableHeight.Equal(that1.VoteExtensionsEnableHeight) {
		return false
	}
	if !this.PbtsEnableHeight.Equal(that1.PbtsEnableHeight) {
		return false
	}
	return true
}
func (this *ABCIParams) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ABCIParams)
	if !ok {
		that2, ok := that.(ABCIParams)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.VoteExtensionsEnableHeight != that1.VoteExtensionsEnableHeight {
		return false
	}
	return true
}
func (m *ConsensusParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConsensusParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConsensusParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Feature != nil {
		{
			size, err := m.Feature.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Synchrony != nil {
		{
			size, err := m.Synchrony.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Abci != nil {
		{
			size, err := m.Abci.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Version != nil {
		{
			size, err := m.Version.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Validator != nil {
		{
			size, err := m.Validator.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Evidence != nil {
		{
			size, err := m.Evidence.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Block != nil {
		{
			size, err := m.Block.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BlockParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlockParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BlockParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxGas != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxGas))
		i--
		dAtA[i] = 0x10
	}
	if m.MaxBytes != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EvidenceParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EvidenceParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EvidenceParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxBytes != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxBytes))
		i--
		dAtA[i] = 0x18
	}
	n8, err8 := github_com_cosmos_gogoproto_types.StdDurationMarshalTo(m.MaxAgeDuration, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdDuration(m.MaxAgeDuration):])
	if err8 != nil {
		return 0, err8
	}
	i -= n8
	i = encodeVarintParams(dAtA, i, uint64(n8))
	i--
	dAtA[i] = 0x12
	if m.MaxAgeNumBlocks != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.MaxAgeNumBlocks))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ValidatorParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidatorParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValidatorParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PubKeyTypes) > 0 {
		for iNdEx := len(m.PubKeyTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PubKeyTypes[iNdEx])
			copy(dAtA[i:], m.PubKeyTypes[iNdEx])
			i = encodeVarintParams(dAtA, i, uint64(len(m.PubKeyTypes[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *VersionParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VersionParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VersionParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.App != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.App))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HashedParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HashedParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HashedParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BlockMaxGas != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.BlockMaxGas))
		i--
		dAtA[i] = 0x10
	}
	if m.BlockMaxBytes != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.BlockMaxBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SynchronyParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SynchronyParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SynchronyParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MessageDelay != nil {
		n9, err9 := github_com_cosmos_gogoproto_types.StdDurationMarshalTo(*m.MessageDelay, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdDuration(*m.MessageDelay):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintParams(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x12
	}
	if m.Precision != nil {
		n10, err10 := github_com_cosmos_gogoproto_types.StdDurationMarshalTo(*m.Precision, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdDuration(*m.Precision):])
		if err10 != nil {
			return 0, err10
		}
		i -= n10
		i = encodeVarintParams(dAtA, i, uint64(n10))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FeatureParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FeatureParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FeatureParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PbtsEnableHeight != nil {
		{
			size, err := m.PbtsEnableHeight.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.VoteExtensionsEnableHeight != nil {
		{
			size, err := m.VoteExtensionsEnableHeight.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintParams(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ABCIParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ABCIParams) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ABCIParams) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VoteExtensionsEnableHeight != 0 {
		i = encodeVarintParams(dAtA, i, uint64(m.VoteExtensionsEnableHeight))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintParams(dAtA []byte, offset int, v uint64) int {
	offset -= sovParams(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedValidatorParams(r randyParams, easy bool) *ValidatorParams {
	this := &ValidatorParams{}
	v1 := r.Intn(10)
	this.PubKeyTypes = make([]string, v1)
	for i := 0; i < v1; i++ {
		this.PubKeyTypes[i] = string(randStringParams(r))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedVersionParams(r randyParams, easy bool) *VersionParams {
	this := &VersionParams{}
	this.App = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyParams interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneParams(r randyParams) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringParams(r randyParams) string {
	v2 := r.Intn(100)
	tmps := make([]rune, v2)
	for i := 0; i < v2; i++ {
		tmps[i] = randUTF8RuneParams(r)
	}
	return string(tmps)
}
func randUnrecognizedParams(r randyParams, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldParams(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldParams(dAtA []byte, r randyParams, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateParams(dAtA, uint64(key))
		v3 := r.Int63()
		if r.Intn(2) == 0 {
			v3 *= -1
		}
		dAtA = encodeVarintPopulateParams(dAtA, uint64(v3))
	case 1:
		dAtA = encodeVarintPopulateParams(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateParams(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateParams(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateParams(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateParams(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *ConsensusParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Block != nil {
		l = m.Block.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Evidence != nil {
		l = m.Evidence.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Validator != nil {
		l = m.Validator.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Version != nil {
		l = m.Version.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Abci != nil {
		l = m.Abci.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Synchrony != nil {
		l = m.Synchrony.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.Feature != nil {
		l = m.Feature.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func (m *BlockParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxBytes != 0 {
		n += 1 + sovParams(uint64(m.MaxBytes))
	}
	if m.MaxGas != 0 {
		n += 1 + sovParams(uint64(m.MaxGas))
	}
	return n
}

func (m *EvidenceParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxAgeNumBlocks != 0 {
		n += 1 + sovParams(uint64(m.MaxAgeNumBlocks))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdDuration(m.MaxAgeDuration)
	n += 1 + l + sovParams(uint64(l))
	if m.MaxBytes != 0 {
		n += 1 + sovParams(uint64(m.MaxBytes))
	}
	return n
}

func (m *ValidatorParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PubKeyTypes) > 0 {
		for _, s := range m.PubKeyTypes {
			l = len(s)
			n += 1 + l + sovParams(uint64(l))
		}
	}
	return n
}

func (m *VersionParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.App != 0 {
		n += 1 + sovParams(uint64(m.App))
	}
	return n
}

func (m *HashedParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BlockMaxBytes != 0 {
		n += 1 + sovParams(uint64(m.BlockMaxBytes))
	}
	if m.BlockMaxGas != 0 {
		n += 1 + sovParams(uint64(m.BlockMaxGas))
	}
	return n
}

func (m *SynchronyParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Precision != nil {
		l = github_com_cosmos_gogoproto_types.SizeOfStdDuration(*m.Precision)
		n += 1 + l + sovParams(uint64(l))
	}
	if m.MessageDelay != nil {
		l = github_com_cosmos_gogoproto_types.SizeOfStdDuration(*m.MessageDelay)
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func (m *FeatureParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VoteExtensionsEnableHeight != nil {
		l = m.VoteExtensionsEnableHeight.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	if m.PbtsEnableHeight != nil {
		l = m.PbtsEnableHeight.Size()
		n += 1 + l + sovParams(uint64(l))
	}
	return n
}

func (m *ABCIParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VoteExtensionsEnableHeight != 0 {
		n += 1 + sovParams(uint64(m.VoteExtensionsEnableHeight))
	}
	return n
}

func sovParams(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozParams(x uint64) (n int) {
	return sovParams(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ConsensusParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConsensusParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConsensusParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Block", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Block == nil {
				m.Block = &BlockParams{}
			}
			if err := m.Block.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Evidence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Evidence == nil {
				m.Evidence = &EvidenceParams{}
			}
			if err := m.Evidence.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Validator == nil {
				m.Validator = &ValidatorParams{}
			}
			if err := m.Validator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &VersionParams{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Abci", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Abci == nil {
				m.Abci = &ABCIParams{}
			}
			if err := m.Abci.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Synchrony", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Synchrony == nil {
				m.Synchrony = &SynchronyParams{}
			}
			if err := m.Synchrony.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Feature", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Feature == nil {
				m.Feature = &FeatureParams{}
			}
			if err := m.Feature.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlockParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlockParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlockParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBytes", wireType)
			}
			m.MaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxGas", wireType)
			}
			m.MaxGas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxGas |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EvidenceParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EvidenceParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EvidenceParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAgeNumBlocks", wireType)
			}
			m.MaxAgeNumBlocks = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxAgeNumBlocks |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAgeDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdDurationUnmarshal(&m.MaxAgeDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBytes", wireType)
			}
			m.MaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidatorParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidatorParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidatorParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PubKeyTypes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PubKeyTypes = append(m.PubKeyTypes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VersionParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VersionParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VersionParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field App", wireType)
			}
			m.App = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.App |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HashedParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HashedParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HashedParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockMaxBytes", wireType)
			}
			m.BlockMaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockMaxBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockMaxGas", wireType)
			}
			m.BlockMaxGas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockMaxGas |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SynchronyParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SynchronyParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SynchronyParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Precision", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Precision == nil {
				m.Precision = new(time.Duration)
			}
			if err := github_com_cosmos_gogoproto_types.StdDurationUnmarshal(m.Precision, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MessageDelay == nil {
				m.MessageDelay = new(time.Duration)
			}
			if err := github_com_cosmos_gogoproto_types.StdDurationUnmarshal(m.MessageDelay, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FeatureParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FeatureParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FeatureParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteExtensionsEnableHeight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VoteExtensionsEnableHeight == nil {
				m.VoteExtensionsEnableHeight = &types.Int64Value{}
			}
			if err := m.VoteExtensionsEnableHeight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PbtsEnableHeight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthParams
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthParams
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PbtsEnableHeight == nil {
				m.PbtsEnableHeight = &types.Int64Value{}
			}
			if err := m.PbtsEnableHeight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ABCIParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowParams
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ABCIParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ABCIParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteExtensionsEnableHeight", wireType)
			}
			m.VoteExtensionsEnableHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowParams
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VoteExtensionsEnableHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipParams(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthParams
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipParams(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowParams
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowParams
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthParams
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupParams
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthParams
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthParams        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowParams          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupParams = fmt.Errorf("proto: unexpected end of group")
)
