// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: cometbft/abci/v1/types.proto

package v1

import (
	fmt "fmt"
	v11 "github.com/cometbft/cometbft/api/cometbft/crypto/v1"
	v1 "github.com/cometbft/cometbft/api/cometbft/types/v1"
	_ "github.com/cosmos/gogoproto/gogoproto"
	proto "github.com/cosmos/gogoproto/proto"
	_ "github.com/cosmos/gogoproto/types"
	github_com_cosmos_gogoproto_types "github.com/cosmos/gogoproto/types"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Type of the transaction check request.
//
// This enumeration is incompatible with the CheckTxType definition in
// cometbft.abci.v1beta1 and therefore shall not be used in encoding with the same
// field number.
type CheckTxType int32

const (
	// Unknown
	CHECK_TX_TYPE_UNKNOWN CheckTxType = 0
	// Recheck (2nd, 3rd, etc.)
	CHECK_TX_TYPE_RECHECK CheckTxType = 1
	// Check (1st time)
	CHECK_TX_TYPE_CHECK CheckTxType = 2
)

var CheckTxType_name = map[int32]string{
	0: "CHECK_TX_TYPE_UNKNOWN",
	1: "CHECK_TX_TYPE_RECHECK",
	2: "CHECK_TX_TYPE_CHECK",
}

var CheckTxType_value = map[string]int32{
	"CHECK_TX_TYPE_UNKNOWN": 0,
	"CHECK_TX_TYPE_RECHECK": 1,
	"CHECK_TX_TYPE_CHECK":   2,
}

func (x CheckTxType) String() string {
	return proto.EnumName(CheckTxType_name, int32(x))
}

func (CheckTxType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{0}
}

// The result of offering a snapshot.
type OfferSnapshotResult int32

const (
	// Unknown result, abort all snapshot restoration
	OFFER_SNAPSHOT_RESULT_UNKNOWN OfferSnapshotResult = 0
	// Snapshot accepted, apply chunks
	OFFER_SNAPSHOT_RESULT_ACCEPT OfferSnapshotResult = 1
	// Abort all snapshot restoration
	OFFER_SNAPSHOT_RESULT_ABORT OfferSnapshotResult = 2
	// Reject this specific snapshot, try others
	OFFER_SNAPSHOT_RESULT_REJECT OfferSnapshotResult = 3
	// Reject all snapshots of this format, try others
	OFFER_SNAPSHOT_RESULT_REJECT_FORMAT OfferSnapshotResult = 4
	// Reject all snapshots from the sender(s), try others
	OFFER_SNAPSHOT_RESULT_REJECT_SENDER OfferSnapshotResult = 5
)

var OfferSnapshotResult_name = map[int32]string{
	0: "OFFER_SNAPSHOT_RESULT_UNKNOWN",
	1: "OFFER_SNAPSHOT_RESULT_ACCEPT",
	2: "OFFER_SNAPSHOT_RESULT_ABORT",
	3: "OFFER_SNAPSHOT_RESULT_REJECT",
	4: "OFFER_SNAPSHOT_RESULT_REJECT_FORMAT",
	5: "OFFER_SNAPSHOT_RESULT_REJECT_SENDER",
}

var OfferSnapshotResult_value = map[string]int32{
	"OFFER_SNAPSHOT_RESULT_UNKNOWN":       0,
	"OFFER_SNAPSHOT_RESULT_ACCEPT":        1,
	"OFFER_SNAPSHOT_RESULT_ABORT":         2,
	"OFFER_SNAPSHOT_RESULT_REJECT":        3,
	"OFFER_SNAPSHOT_RESULT_REJECT_FORMAT": 4,
	"OFFER_SNAPSHOT_RESULT_REJECT_SENDER": 5,
}

func (x OfferSnapshotResult) String() string {
	return proto.EnumName(OfferSnapshotResult_name, int32(x))
}

func (OfferSnapshotResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{1}
}

// The result of applying a snapshot chunk.
type ApplySnapshotChunkResult int32

const (
	// Unknown result, abort all snapshot restoration
	APPLY_SNAPSHOT_CHUNK_RESULT_UNKNOWN ApplySnapshotChunkResult = 0
	// Chunk successfully accepted
	APPLY_SNAPSHOT_CHUNK_RESULT_ACCEPT ApplySnapshotChunkResult = 1
	// Abort all snapshot restoration
	APPLY_SNAPSHOT_CHUNK_RESULT_ABORT ApplySnapshotChunkResult = 2
	// Retry chunk (combine with refetch and reject)
	APPLY_SNAPSHOT_CHUNK_RESULT_RETRY ApplySnapshotChunkResult = 3
	// Retry snapshot (combine with refetch and reject)
	APPLY_SNAPSHOT_CHUNK_RESULT_RETRY_SNAPSHOT ApplySnapshotChunkResult = 4
	// Reject this snapshot, try others
	APPLY_SNAPSHOT_CHUNK_RESULT_REJECT_SNAPSHOT ApplySnapshotChunkResult = 5
)

var ApplySnapshotChunkResult_name = map[int32]string{
	0: "APPLY_SNAPSHOT_CHUNK_RESULT_UNKNOWN",
	1: "APPLY_SNAPSHOT_CHUNK_RESULT_ACCEPT",
	2: "APPLY_SNAPSHOT_CHUNK_RESULT_ABORT",
	3: "APPLY_SNAPSHOT_CHUNK_RESULT_RETRY",
	4: "APPLY_SNAPSHOT_CHUNK_RESULT_RETRY_SNAPSHOT",
	5: "APPLY_SNAPSHOT_CHUNK_RESULT_REJECT_SNAPSHOT",
}

var ApplySnapshotChunkResult_value = map[string]int32{
	"APPLY_SNAPSHOT_CHUNK_RESULT_UNKNOWN":         0,
	"APPLY_SNAPSHOT_CHUNK_RESULT_ACCEPT":          1,
	"APPLY_SNAPSHOT_CHUNK_RESULT_ABORT":           2,
	"APPLY_SNAPSHOT_CHUNK_RESULT_RETRY":           3,
	"APPLY_SNAPSHOT_CHUNK_RESULT_RETRY_SNAPSHOT":  4,
	"APPLY_SNAPSHOT_CHUNK_RESULT_REJECT_SNAPSHOT": 5,
}

func (x ApplySnapshotChunkResult) String() string {
	return proto.EnumName(ApplySnapshotChunkResult_name, int32(x))
}

func (ApplySnapshotChunkResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{2}
}

// ProcessProposalStatus is the status of the proposal processing.
type ProcessProposalStatus int32

const (
	// Unknown
	PROCESS_PROPOSAL_STATUS_UNKNOWN ProcessProposalStatus = 0
	// Accepted
	PROCESS_PROPOSAL_STATUS_ACCEPT ProcessProposalStatus = 1
	// Rejected
	PROCESS_PROPOSAL_STATUS_REJECT ProcessProposalStatus = 2
)

var ProcessProposalStatus_name = map[int32]string{
	0: "PROCESS_PROPOSAL_STATUS_UNKNOWN",
	1: "PROCESS_PROPOSAL_STATUS_ACCEPT",
	2: "PROCESS_PROPOSAL_STATUS_REJECT",
}

var ProcessProposalStatus_value = map[string]int32{
	"PROCESS_PROPOSAL_STATUS_UNKNOWN": 0,
	"PROCESS_PROPOSAL_STATUS_ACCEPT":  1,
	"PROCESS_PROPOSAL_STATUS_REJECT":  2,
}

func (x ProcessProposalStatus) String() string {
	return proto.EnumName(ProcessProposalStatus_name, int32(x))
}

func (ProcessProposalStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{3}
}

// VerifyVoteExtensionStatus is the status of the vote extension verification.
type VerifyVoteExtensionStatus int32

const (
	// Unknown
	VERIFY_VOTE_EXTENSION_STATUS_UNKNOWN VerifyVoteExtensionStatus = 0
	// Accepted
	VERIFY_VOTE_EXTENSION_STATUS_ACCEPT VerifyVoteExtensionStatus = 1
	// Rejecting the vote extension will reject the entire precommit by the sender.
	// Incorrectly implementing this thus has liveness implications as it may affect
	// CometBFT's ability to receive 2/3+ valid votes to finalize the block.
	// Honest nodes should never be rejected.
	VERIFY_VOTE_EXTENSION_STATUS_REJECT VerifyVoteExtensionStatus = 2
)

var VerifyVoteExtensionStatus_name = map[int32]string{
	0: "VERIFY_VOTE_EXTENSION_STATUS_UNKNOWN",
	1: "VERIFY_VOTE_EXTENSION_STATUS_ACCEPT",
	2: "VERIFY_VOTE_EXTENSION_STATUS_REJECT",
}

var VerifyVoteExtensionStatus_value = map[string]int32{
	"VERIFY_VOTE_EXTENSION_STATUS_UNKNOWN": 0,
	"VERIFY_VOTE_EXTENSION_STATUS_ACCEPT":  1,
	"VERIFY_VOTE_EXTENSION_STATUS_REJECT":  2,
}

func (x VerifyVoteExtensionStatus) String() string {
	return proto.EnumName(VerifyVoteExtensionStatus_name, int32(x))
}

func (VerifyVoteExtensionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{4}
}

// The type of misbehavior committed by a validator.
type MisbehaviorType int32

const (
	// Unknown
	MISBEHAVIOR_TYPE_UNKNOWN MisbehaviorType = 0
	// Duplicate vote
	MISBEHAVIOR_TYPE_DUPLICATE_VOTE MisbehaviorType = 1
	// Light client attack
	MISBEHAVIOR_TYPE_LIGHT_CLIENT_ATTACK MisbehaviorType = 2
)

var MisbehaviorType_name = map[int32]string{
	0: "MISBEHAVIOR_TYPE_UNKNOWN",
	1: "MISBEHAVIOR_TYPE_DUPLICATE_VOTE",
	2: "MISBEHAVIOR_TYPE_LIGHT_CLIENT_ATTACK",
}

var MisbehaviorType_value = map[string]int32{
	"MISBEHAVIOR_TYPE_UNKNOWN":             0,
	"MISBEHAVIOR_TYPE_DUPLICATE_VOTE":      1,
	"MISBEHAVIOR_TYPE_LIGHT_CLIENT_ATTACK": 2,
}

func (x MisbehaviorType) String() string {
	return proto.EnumName(MisbehaviorType_name, int32(x))
}

func (MisbehaviorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{5}
}

// Request represents a request to the ABCI application.
type Request struct {
	// Sum of all possible messages.
	//
	// Types that are valid to be assigned to Value:
	//	*Request_Echo
	//	*Request_Flush
	//	*Request_Info
	//	*Request_InitChain
	//	*Request_Query
	//	*Request_CheckTx
	//	*Request_Commit
	//	*Request_ListSnapshots
	//	*Request_OfferSnapshot
	//	*Request_LoadSnapshotChunk
	//	*Request_ApplySnapshotChunk
	//	*Request_PrepareProposal
	//	*Request_ProcessProposal
	//	*Request_ExtendVote
	//	*Request_VerifyVoteExtension
	//	*Request_FinalizeBlock
	Value isRequest_Value `protobuf_oneof:"value"`
}

func (m *Request) Reset()         { *m = Request{} }
func (m *Request) String() string { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()    {}
func (*Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{0}
}
func (m *Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Request.Merge(m, src)
}
func (m *Request) XXX_Size() int {
	return m.Size()
}
func (m *Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Request proto.InternalMessageInfo

type isRequest_Value interface {
	isRequest_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Request_Echo struct {
	Echo *EchoRequest `protobuf:"bytes,1,opt,name=echo,proto3,oneof" json:"echo,omitempty"`
}
type Request_Flush struct {
	Flush *FlushRequest `protobuf:"bytes,2,opt,name=flush,proto3,oneof" json:"flush,omitempty"`
}
type Request_Info struct {
	Info *InfoRequest `protobuf:"bytes,3,opt,name=info,proto3,oneof" json:"info,omitempty"`
}
type Request_InitChain struct {
	InitChain *InitChainRequest `protobuf:"bytes,5,opt,name=init_chain,json=initChain,proto3,oneof" json:"init_chain,omitempty"`
}
type Request_Query struct {
	Query *QueryRequest `protobuf:"bytes,6,opt,name=query,proto3,oneof" json:"query,omitempty"`
}
type Request_CheckTx struct {
	CheckTx *CheckTxRequest `protobuf:"bytes,8,opt,name=check_tx,json=checkTx,proto3,oneof" json:"check_tx,omitempty"`
}
type Request_Commit struct {
	Commit *CommitRequest `protobuf:"bytes,11,opt,name=commit,proto3,oneof" json:"commit,omitempty"`
}
type Request_ListSnapshots struct {
	ListSnapshots *ListSnapshotsRequest `protobuf:"bytes,12,opt,name=list_snapshots,json=listSnapshots,proto3,oneof" json:"list_snapshots,omitempty"`
}
type Request_OfferSnapshot struct {
	OfferSnapshot *OfferSnapshotRequest `protobuf:"bytes,13,opt,name=offer_snapshot,json=offerSnapshot,proto3,oneof" json:"offer_snapshot,omitempty"`
}
type Request_LoadSnapshotChunk struct {
	LoadSnapshotChunk *LoadSnapshotChunkRequest `protobuf:"bytes,14,opt,name=load_snapshot_chunk,json=loadSnapshotChunk,proto3,oneof" json:"load_snapshot_chunk,omitempty"`
}
type Request_ApplySnapshotChunk struct {
	ApplySnapshotChunk *ApplySnapshotChunkRequest `protobuf:"bytes,15,opt,name=apply_snapshot_chunk,json=applySnapshotChunk,proto3,oneof" json:"apply_snapshot_chunk,omitempty"`
}
type Request_PrepareProposal struct {
	PrepareProposal *PrepareProposalRequest `protobuf:"bytes,16,opt,name=prepare_proposal,json=prepareProposal,proto3,oneof" json:"prepare_proposal,omitempty"`
}
type Request_ProcessProposal struct {
	ProcessProposal *ProcessProposalRequest `protobuf:"bytes,17,opt,name=process_proposal,json=processProposal,proto3,oneof" json:"process_proposal,omitempty"`
}
type Request_ExtendVote struct {
	ExtendVote *ExtendVoteRequest `protobuf:"bytes,18,opt,name=extend_vote,json=extendVote,proto3,oneof" json:"extend_vote,omitempty"`
}
type Request_VerifyVoteExtension struct {
	VerifyVoteExtension *VerifyVoteExtensionRequest `protobuf:"bytes,19,opt,name=verify_vote_extension,json=verifyVoteExtension,proto3,oneof" json:"verify_vote_extension,omitempty"`
}
type Request_FinalizeBlock struct {
	FinalizeBlock *FinalizeBlockRequest `protobuf:"bytes,20,opt,name=finalize_block,json=finalizeBlock,proto3,oneof" json:"finalize_block,omitempty"`
}

func (*Request_Echo) isRequest_Value()                {}
func (*Request_Flush) isRequest_Value()               {}
func (*Request_Info) isRequest_Value()                {}
func (*Request_InitChain) isRequest_Value()           {}
func (*Request_Query) isRequest_Value()               {}
func (*Request_CheckTx) isRequest_Value()             {}
func (*Request_Commit) isRequest_Value()              {}
func (*Request_ListSnapshots) isRequest_Value()       {}
func (*Request_OfferSnapshot) isRequest_Value()       {}
func (*Request_LoadSnapshotChunk) isRequest_Value()   {}
func (*Request_ApplySnapshotChunk) isRequest_Value()  {}
func (*Request_PrepareProposal) isRequest_Value()     {}
func (*Request_ProcessProposal) isRequest_Value()     {}
func (*Request_ExtendVote) isRequest_Value()          {}
func (*Request_VerifyVoteExtension) isRequest_Value() {}
func (*Request_FinalizeBlock) isRequest_Value()       {}

func (m *Request) GetValue() isRequest_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Request) GetEcho() *EchoRequest {
	if x, ok := m.GetValue().(*Request_Echo); ok {
		return x.Echo
	}
	return nil
}

func (m *Request) GetFlush() *FlushRequest {
	if x, ok := m.GetValue().(*Request_Flush); ok {
		return x.Flush
	}
	return nil
}

func (m *Request) GetInfo() *InfoRequest {
	if x, ok := m.GetValue().(*Request_Info); ok {
		return x.Info
	}
	return nil
}

func (m *Request) GetInitChain() *InitChainRequest {
	if x, ok := m.GetValue().(*Request_InitChain); ok {
		return x.InitChain
	}
	return nil
}

func (m *Request) GetQuery() *QueryRequest {
	if x, ok := m.GetValue().(*Request_Query); ok {
		return x.Query
	}
	return nil
}

func (m *Request) GetCheckTx() *CheckTxRequest {
	if x, ok := m.GetValue().(*Request_CheckTx); ok {
		return x.CheckTx
	}
	return nil
}

func (m *Request) GetCommit() *CommitRequest {
	if x, ok := m.GetValue().(*Request_Commit); ok {
		return x.Commit
	}
	return nil
}

func (m *Request) GetListSnapshots() *ListSnapshotsRequest {
	if x, ok := m.GetValue().(*Request_ListSnapshots); ok {
		return x.ListSnapshots
	}
	return nil
}

func (m *Request) GetOfferSnapshot() *OfferSnapshotRequest {
	if x, ok := m.GetValue().(*Request_OfferSnapshot); ok {
		return x.OfferSnapshot
	}
	return nil
}

func (m *Request) GetLoadSnapshotChunk() *LoadSnapshotChunkRequest {
	if x, ok := m.GetValue().(*Request_LoadSnapshotChunk); ok {
		return x.LoadSnapshotChunk
	}
	return nil
}

func (m *Request) GetApplySnapshotChunk() *ApplySnapshotChunkRequest {
	if x, ok := m.GetValue().(*Request_ApplySnapshotChunk); ok {
		return x.ApplySnapshotChunk
	}
	return nil
}

func (m *Request) GetPrepareProposal() *PrepareProposalRequest {
	if x, ok := m.GetValue().(*Request_PrepareProposal); ok {
		return x.PrepareProposal
	}
	return nil
}

func (m *Request) GetProcessProposal() *ProcessProposalRequest {
	if x, ok := m.GetValue().(*Request_ProcessProposal); ok {
		return x.ProcessProposal
	}
	return nil
}

func (m *Request) GetExtendVote() *ExtendVoteRequest {
	if x, ok := m.GetValue().(*Request_ExtendVote); ok {
		return x.ExtendVote
	}
	return nil
}

func (m *Request) GetVerifyVoteExtension() *VerifyVoteExtensionRequest {
	if x, ok := m.GetValue().(*Request_VerifyVoteExtension); ok {
		return x.VerifyVoteExtension
	}
	return nil
}

func (m *Request) GetFinalizeBlock() *FinalizeBlockRequest {
	if x, ok := m.GetValue().(*Request_FinalizeBlock); ok {
		return x.FinalizeBlock
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Request) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Request_Echo)(nil),
		(*Request_Flush)(nil),
		(*Request_Info)(nil),
		(*Request_InitChain)(nil),
		(*Request_Query)(nil),
		(*Request_CheckTx)(nil),
		(*Request_Commit)(nil),
		(*Request_ListSnapshots)(nil),
		(*Request_OfferSnapshot)(nil),
		(*Request_LoadSnapshotChunk)(nil),
		(*Request_ApplySnapshotChunk)(nil),
		(*Request_PrepareProposal)(nil),
		(*Request_ProcessProposal)(nil),
		(*Request_ExtendVote)(nil),
		(*Request_VerifyVoteExtension)(nil),
		(*Request_FinalizeBlock)(nil),
	}
}

// EchoRequest is a request to "echo" the given string.
type EchoRequest struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *EchoRequest) Reset()         { *m = EchoRequest{} }
func (m *EchoRequest) String() string { return proto.CompactTextString(m) }
func (*EchoRequest) ProtoMessage()    {}
func (*EchoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{1}
}
func (m *EchoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EchoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EchoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EchoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EchoRequest.Merge(m, src)
}
func (m *EchoRequest) XXX_Size() int {
	return m.Size()
}
func (m *EchoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EchoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EchoRequest proto.InternalMessageInfo

func (m *EchoRequest) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// FlushRequest is a request to flush the write buffer.
type FlushRequest struct {
}

func (m *FlushRequest) Reset()         { *m = FlushRequest{} }
func (m *FlushRequest) String() string { return proto.CompactTextString(m) }
func (*FlushRequest) ProtoMessage()    {}
func (*FlushRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{2}
}
func (m *FlushRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlushRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlushRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlushRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlushRequest.Merge(m, src)
}
func (m *FlushRequest) XXX_Size() int {
	return m.Size()
}
func (m *FlushRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FlushRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FlushRequest proto.InternalMessageInfo

// InfoRequest is a request for the ABCI application version.
type InfoRequest struct {
	Version      string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	BlockVersion uint64 `protobuf:"varint,2,opt,name=block_version,json=blockVersion,proto3" json:"block_version,omitempty"`
	P2PVersion   uint64 `protobuf:"varint,3,opt,name=p2p_version,json=p2pVersion,proto3" json:"p2p_version,omitempty"`
	AbciVersion  string `protobuf:"bytes,4,opt,name=abci_version,json=abciVersion,proto3" json:"abci_version,omitempty"`
}

func (m *InfoRequest) Reset()         { *m = InfoRequest{} }
func (m *InfoRequest) String() string { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()    {}
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{3}
}
func (m *InfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoRequest.Merge(m, src)
}
func (m *InfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *InfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InfoRequest proto.InternalMessageInfo

func (m *InfoRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *InfoRequest) GetBlockVersion() uint64 {
	if m != nil {
		return m.BlockVersion
	}
	return 0
}

func (m *InfoRequest) GetP2PVersion() uint64 {
	if m != nil {
		return m.P2PVersion
	}
	return 0
}

func (m *InfoRequest) GetAbciVersion() string {
	if m != nil {
		return m.AbciVersion
	}
	return ""
}

// InitChainRequest is a request to initialize the blockchain.
type InitChainRequest struct {
	Time            time.Time           `protobuf:"bytes,1,opt,name=time,proto3,stdtime" json:"time"`
	ChainId         string              `protobuf:"bytes,2,opt,name=chain_id,json=chainId,proto3" json:"chain_id,omitempty"`
	ConsensusParams *v1.ConsensusParams `protobuf:"bytes,3,opt,name=consensus_params,json=consensusParams,proto3" json:"consensus_params,omitempty"`
	Validators      []ValidatorUpdate   `protobuf:"bytes,4,rep,name=validators,proto3" json:"validators"`
	AppStateBytes   []byte              `protobuf:"bytes,5,opt,name=app_state_bytes,json=appStateBytes,proto3" json:"app_state_bytes,omitempty"`
	InitialHeight   int64               `protobuf:"varint,6,opt,name=initial_height,json=initialHeight,proto3" json:"initial_height,omitempty"`
}

func (m *InitChainRequest) Reset()         { *m = InitChainRequest{} }
func (m *InitChainRequest) String() string { return proto.CompactTextString(m) }
func (*InitChainRequest) ProtoMessage()    {}
func (*InitChainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{4}
}
func (m *InitChainRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InitChainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InitChainRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InitChainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitChainRequest.Merge(m, src)
}
func (m *InitChainRequest) XXX_Size() int {
	return m.Size()
}
func (m *InitChainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InitChainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InitChainRequest proto.InternalMessageInfo

func (m *InitChainRequest) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *InitChainRequest) GetChainId() string {
	if m != nil {
		return m.ChainId
	}
	return ""
}

func (m *InitChainRequest) GetConsensusParams() *v1.ConsensusParams {
	if m != nil {
		return m.ConsensusParams
	}
	return nil
}

func (m *InitChainRequest) GetValidators() []ValidatorUpdate {
	if m != nil {
		return m.Validators
	}
	return nil
}

func (m *InitChainRequest) GetAppStateBytes() []byte {
	if m != nil {
		return m.AppStateBytes
	}
	return nil
}

func (m *InitChainRequest) GetInitialHeight() int64 {
	if m != nil {
		return m.InitialHeight
	}
	return 0
}

// QueryRequest is a request to query the application state.
type QueryRequest struct {
	Data   []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Path   string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Height int64  `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	Prove  bool   `protobuf:"varint,4,opt,name=prove,proto3" json:"prove,omitempty"`
}

func (m *QueryRequest) Reset()         { *m = QueryRequest{} }
func (m *QueryRequest) String() string { return proto.CompactTextString(m) }
func (*QueryRequest) ProtoMessage()    {}
func (*QueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{5}
}
func (m *QueryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRequest.Merge(m, src)
}
func (m *QueryRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRequest proto.InternalMessageInfo

func (m *QueryRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *QueryRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *QueryRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *QueryRequest) GetProve() bool {
	if m != nil {
		return m.Prove
	}
	return false
}

// CheckTxRequest is a request to check that the transaction is valid.
type CheckTxRequest struct {
	Tx   []byte      `protobuf:"bytes,1,opt,name=tx,proto3" json:"tx,omitempty"`
	Type CheckTxType `protobuf:"varint,3,opt,name=type,proto3,enum=cometbft.abci.v1.CheckTxType" json:"type,omitempty"`
}

func (m *CheckTxRequest) Reset()         { *m = CheckTxRequest{} }
func (m *CheckTxRequest) String() string { return proto.CompactTextString(m) }
func (*CheckTxRequest) ProtoMessage()    {}
func (*CheckTxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{6}
}
func (m *CheckTxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckTxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckTxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckTxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckTxRequest.Merge(m, src)
}
func (m *CheckTxRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckTxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckTxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckTxRequest proto.InternalMessageInfo

func (m *CheckTxRequest) GetTx() []byte {
	if m != nil {
		return m.Tx
	}
	return nil
}

func (m *CheckTxRequest) GetType() CheckTxType {
	if m != nil {
		return m.Type
	}
	return CHECK_TX_TYPE_UNKNOWN
}

// CommitRequest is a request to commit the pending application state.
type CommitRequest struct {
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{7}
}
func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(m, src)
}
func (m *CommitRequest) XXX_Size() int {
	return m.Size()
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

// Request to list available snapshots.
type ListSnapshotsRequest struct {
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{8}
}
func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(m, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

// Request offering a snapshot to the application.
type OfferSnapshotRequest struct {
	Snapshot *Snapshot `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	AppHash  []byte    `protobuf:"bytes,2,opt,name=app_hash,json=appHash,proto3" json:"app_hash,omitempty"`
}

func (m *OfferSnapshotRequest) Reset()         { *m = OfferSnapshotRequest{} }
func (m *OfferSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*OfferSnapshotRequest) ProtoMessage()    {}
func (*OfferSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{9}
}
func (m *OfferSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OfferSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OfferSnapshotRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OfferSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfferSnapshotRequest.Merge(m, src)
}
func (m *OfferSnapshotRequest) XXX_Size() int {
	return m.Size()
}
func (m *OfferSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OfferSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OfferSnapshotRequest proto.InternalMessageInfo

func (m *OfferSnapshotRequest) GetSnapshot() *Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

func (m *OfferSnapshotRequest) GetAppHash() []byte {
	if m != nil {
		return m.AppHash
	}
	return nil
}

// Request to load a snapshot chunk.
type LoadSnapshotChunkRequest struct {
	Height uint64 `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Format uint32 `protobuf:"varint,2,opt,name=format,proto3" json:"format,omitempty"`
	Chunk  uint32 `protobuf:"varint,3,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (m *LoadSnapshotChunkRequest) Reset()         { *m = LoadSnapshotChunkRequest{} }
func (m *LoadSnapshotChunkRequest) String() string { return proto.CompactTextString(m) }
func (*LoadSnapshotChunkRequest) ProtoMessage()    {}
func (*LoadSnapshotChunkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{10}
}
func (m *LoadSnapshotChunkRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadSnapshotChunkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadSnapshotChunkRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadSnapshotChunkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadSnapshotChunkRequest.Merge(m, src)
}
func (m *LoadSnapshotChunkRequest) XXX_Size() int {
	return m.Size()
}
func (m *LoadSnapshotChunkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadSnapshotChunkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LoadSnapshotChunkRequest proto.InternalMessageInfo

func (m *LoadSnapshotChunkRequest) GetHeight() uint64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *LoadSnapshotChunkRequest) GetFormat() uint32 {
	if m != nil {
		return m.Format
	}
	return 0
}

func (m *LoadSnapshotChunkRequest) GetChunk() uint32 {
	if m != nil {
		return m.Chunk
	}
	return 0
}

// Request to apply a snapshot chunk.
type ApplySnapshotChunkRequest struct {
	Index  uint32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Chunk  []byte `protobuf:"bytes,2,opt,name=chunk,proto3" json:"chunk,omitempty"`
	Sender string `protobuf:"bytes,3,opt,name=sender,proto3" json:"sender,omitempty"`
}

func (m *ApplySnapshotChunkRequest) Reset()         { *m = ApplySnapshotChunkRequest{} }
func (m *ApplySnapshotChunkRequest) String() string { return proto.CompactTextString(m) }
func (*ApplySnapshotChunkRequest) ProtoMessage()    {}
func (*ApplySnapshotChunkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{11}
}
func (m *ApplySnapshotChunkRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplySnapshotChunkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplySnapshotChunkRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplySnapshotChunkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplySnapshotChunkRequest.Merge(m, src)
}
func (m *ApplySnapshotChunkRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplySnapshotChunkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplySnapshotChunkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplySnapshotChunkRequest proto.InternalMessageInfo

func (m *ApplySnapshotChunkRequest) GetIndex() uint32 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *ApplySnapshotChunkRequest) GetChunk() []byte {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (m *ApplySnapshotChunkRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

// PrepareProposalRequest is a request for the ABCI application to prepare a new
// block proposal.
type PrepareProposalRequest struct {
	// the modified transactions cannot exceed this size.
	MaxTxBytes int64 `protobuf:"varint,1,opt,name=max_tx_bytes,json=maxTxBytes,proto3" json:"max_tx_bytes,omitempty"`
	// txs is an array of transactions that will be included in a block,
	// sent to the app for possible modifications.
	Txs                [][]byte           `protobuf:"bytes,2,rep,name=txs,proto3" json:"txs,omitempty"`
	LocalLastCommit    ExtendedCommitInfo `protobuf:"bytes,3,opt,name=local_last_commit,json=localLastCommit,proto3" json:"local_last_commit"`
	Misbehavior        []Misbehavior      `protobuf:"bytes,4,rep,name=misbehavior,proto3" json:"misbehavior"`
	Height             int64              `protobuf:"varint,5,opt,name=height,proto3" json:"height,omitempty"`
	Time               time.Time          `protobuf:"bytes,6,opt,name=time,proto3,stdtime" json:"time"`
	NextValidatorsHash []byte             `protobuf:"bytes,7,opt,name=next_validators_hash,json=nextValidatorsHash,proto3" json:"next_validators_hash,omitempty"`
	// address of the public key of the validator proposing the block.
	ProposerAddress []byte `protobuf:"bytes,8,opt,name=proposer_address,json=proposerAddress,proto3" json:"proposer_address,omitempty"`
}

func (m *PrepareProposalRequest) Reset()         { *m = PrepareProposalRequest{} }
func (m *PrepareProposalRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareProposalRequest) ProtoMessage()    {}
func (*PrepareProposalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{12}
}
func (m *PrepareProposalRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrepareProposalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrepareProposalRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrepareProposalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareProposalRequest.Merge(m, src)
}
func (m *PrepareProposalRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrepareProposalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareProposalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareProposalRequest proto.InternalMessageInfo

func (m *PrepareProposalRequest) GetMaxTxBytes() int64 {
	if m != nil {
		return m.MaxTxBytes
	}
	return 0
}

func (m *PrepareProposalRequest) GetTxs() [][]byte {
	if m != nil {
		return m.Txs
	}
	return nil
}

func (m *PrepareProposalRequest) GetLocalLastCommit() ExtendedCommitInfo {
	if m != nil {
		return m.LocalLastCommit
	}
	return ExtendedCommitInfo{}
}

func (m *PrepareProposalRequest) GetMisbehavior() []Misbehavior {
	if m != nil {
		return m.Misbehavior
	}
	return nil
}

func (m *PrepareProposalRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *PrepareProposalRequest) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *PrepareProposalRequest) GetNextValidatorsHash() []byte {
	if m != nil {
		return m.NextValidatorsHash
	}
	return nil
}

func (m *PrepareProposalRequest) GetProposerAddress() []byte {
	if m != nil {
		return m.ProposerAddress
	}
	return nil
}

// ProcessProposalRequest is a request for the ABCI application to process a proposal
// received from another validator.
type ProcessProposalRequest struct {
	Txs                [][]byte      `protobuf:"bytes,1,rep,name=txs,proto3" json:"txs,omitempty"`
	ProposedLastCommit CommitInfo    `protobuf:"bytes,2,opt,name=proposed_last_commit,json=proposedLastCommit,proto3" json:"proposed_last_commit"`
	Misbehavior        []Misbehavior `protobuf:"bytes,3,rep,name=misbehavior,proto3" json:"misbehavior"`
	// Merkle root hash of the fields of the proposed block.
	Hash               []byte    `protobuf:"bytes,4,opt,name=hash,proto3" json:"hash,omitempty"`
	Height             int64     `protobuf:"varint,5,opt,name=height,proto3" json:"height,omitempty"`
	Time               time.Time `protobuf:"bytes,6,opt,name=time,proto3,stdtime" json:"time"`
	NextValidatorsHash []byte    `protobuf:"bytes,7,opt,name=next_validators_hash,json=nextValidatorsHash,proto3" json:"next_validators_hash,omitempty"`
	// address of the public key of the original proposer of the block.
	ProposerAddress []byte `protobuf:"bytes,8,opt,name=proposer_address,json=proposerAddress,proto3" json:"proposer_address,omitempty"`
}

func (m *ProcessProposalRequest) Reset()         { *m = ProcessProposalRequest{} }
func (m *ProcessProposalRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessProposalRequest) ProtoMessage()    {}
func (*ProcessProposalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{13}
}
func (m *ProcessProposalRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessProposalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessProposalRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessProposalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessProposalRequest.Merge(m, src)
}
func (m *ProcessProposalRequest) XXX_Size() int {
	return m.Size()
}
func (m *ProcessProposalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessProposalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessProposalRequest proto.InternalMessageInfo

func (m *ProcessProposalRequest) GetTxs() [][]byte {
	if m != nil {
		return m.Txs
	}
	return nil
}

func (m *ProcessProposalRequest) GetProposedLastCommit() CommitInfo {
	if m != nil {
		return m.ProposedLastCommit
	}
	return CommitInfo{}
}

func (m *ProcessProposalRequest) GetMisbehavior() []Misbehavior {
	if m != nil {
		return m.Misbehavior
	}
	return nil
}

func (m *ProcessProposalRequest) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *ProcessProposalRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *ProcessProposalRequest) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *ProcessProposalRequest) GetNextValidatorsHash() []byte {
	if m != nil {
		return m.NextValidatorsHash
	}
	return nil
}

func (m *ProcessProposalRequest) GetProposerAddress() []byte {
	if m != nil {
		return m.ProposerAddress
	}
	return nil
}

// ExtendVoteRequest extends a precommit vote with application-injected data.
type ExtendVoteRequest struct {
	// the hash of the block that this vote may be referring to
	Hash []byte `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// the height of the extended vote
	Height int64 `protobuf:"varint,2,opt,name=height,proto3" json:"height,omitempty"`
	// info of the block that this vote may be referring to
	Time               time.Time     `protobuf:"bytes,3,opt,name=time,proto3,stdtime" json:"time"`
	Txs                [][]byte      `protobuf:"bytes,4,rep,name=txs,proto3" json:"txs,omitempty"`
	ProposedLastCommit CommitInfo    `protobuf:"bytes,5,opt,name=proposed_last_commit,json=proposedLastCommit,proto3" json:"proposed_last_commit"`
	Misbehavior        []Misbehavior `protobuf:"bytes,6,rep,name=misbehavior,proto3" json:"misbehavior"`
	NextValidatorsHash []byte        `protobuf:"bytes,7,opt,name=next_validators_hash,json=nextValidatorsHash,proto3" json:"next_validators_hash,omitempty"`
	// address of the public key of the original proposer of the block.
	ProposerAddress []byte `protobuf:"bytes,8,opt,name=proposer_address,json=proposerAddress,proto3" json:"proposer_address,omitempty"`
}

func (m *ExtendVoteRequest) Reset()         { *m = ExtendVoteRequest{} }
func (m *ExtendVoteRequest) String() string { return proto.CompactTextString(m) }
func (*ExtendVoteRequest) ProtoMessage()    {}
func (*ExtendVoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{14}
}
func (m *ExtendVoteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExtendVoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExtendVoteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExtendVoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtendVoteRequest.Merge(m, src)
}
func (m *ExtendVoteRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExtendVoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtendVoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExtendVoteRequest proto.InternalMessageInfo

func (m *ExtendVoteRequest) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *ExtendVoteRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *ExtendVoteRequest) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *ExtendVoteRequest) GetTxs() [][]byte {
	if m != nil {
		return m.Txs
	}
	return nil
}

func (m *ExtendVoteRequest) GetProposedLastCommit() CommitInfo {
	if m != nil {
		return m.ProposedLastCommit
	}
	return CommitInfo{}
}

func (m *ExtendVoteRequest) GetMisbehavior() []Misbehavior {
	if m != nil {
		return m.Misbehavior
	}
	return nil
}

func (m *ExtendVoteRequest) GetNextValidatorsHash() []byte {
	if m != nil {
		return m.NextValidatorsHash
	}
	return nil
}

func (m *ExtendVoteRequest) GetProposerAddress() []byte {
	if m != nil {
		return m.ProposerAddress
	}
	return nil
}

// VerifyVoteExtensionRequest is a request for the application to verify a vote extension
// produced by a different validator.
type VerifyVoteExtensionRequest struct {
	// the hash of the block that this received vote corresponds to
	Hash []byte `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// the validator that signed the vote extension
	ValidatorAddress []byte `protobuf:"bytes,2,opt,name=validator_address,json=validatorAddress,proto3" json:"validator_address,omitempty"`
	Height           int64  `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	VoteExtension    []byte `protobuf:"bytes,4,opt,name=vote_extension,json=voteExtension,proto3" json:"vote_extension,omitempty"`
}

func (m *VerifyVoteExtensionRequest) Reset()         { *m = VerifyVoteExtensionRequest{} }
func (m *VerifyVoteExtensionRequest) String() string { return proto.CompactTextString(m) }
func (*VerifyVoteExtensionRequest) ProtoMessage()    {}
func (*VerifyVoteExtensionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{15}
}
func (m *VerifyVoteExtensionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerifyVoteExtensionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerifyVoteExtensionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerifyVoteExtensionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyVoteExtensionRequest.Merge(m, src)
}
func (m *VerifyVoteExtensionRequest) XXX_Size() int {
	return m.Size()
}
func (m *VerifyVoteExtensionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyVoteExtensionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyVoteExtensionRequest proto.InternalMessageInfo

func (m *VerifyVoteExtensionRequest) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *VerifyVoteExtensionRequest) GetValidatorAddress() []byte {
	if m != nil {
		return m.ValidatorAddress
	}
	return nil
}

func (m *VerifyVoteExtensionRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *VerifyVoteExtensionRequest) GetVoteExtension() []byte {
	if m != nil {
		return m.VoteExtension
	}
	return nil
}

// FinalizeBlockRequest is a request to finalize the block.
type FinalizeBlockRequest struct {
	Txs               [][]byte      `protobuf:"bytes,1,rep,name=txs,proto3" json:"txs,omitempty"`
	DecidedLastCommit CommitInfo    `protobuf:"bytes,2,opt,name=decided_last_commit,json=decidedLastCommit,proto3" json:"decided_last_commit"`
	Misbehavior       []Misbehavior `protobuf:"bytes,3,rep,name=misbehavior,proto3" json:"misbehavior"`
	// Merkle root hash of the fields of the decided block.
	Hash               []byte    `protobuf:"bytes,4,opt,name=hash,proto3" json:"hash,omitempty"`
	Height             int64     `protobuf:"varint,5,opt,name=height,proto3" json:"height,omitempty"`
	Time               time.Time `protobuf:"bytes,6,opt,name=time,proto3,stdtime" json:"time"`
	NextValidatorsHash []byte    `protobuf:"bytes,7,opt,name=next_validators_hash,json=nextValidatorsHash,proto3" json:"next_validators_hash,omitempty"`
	// address of the public key of the original proposer of the block.
	ProposerAddress []byte `protobuf:"bytes,8,opt,name=proposer_address,json=proposerAddress,proto3" json:"proposer_address,omitempty"`
	// If the node is syncing/replaying blocks - target height. If not, syncing_to == height.
	SyncingToHeight int64 `protobuf:"varint,9,opt,name=syncing_to_height,json=syncingToHeight,proto3" json:"syncing_to_height,omitempty"`
}

func (m *FinalizeBlockRequest) Reset()         { *m = FinalizeBlockRequest{} }
func (m *FinalizeBlockRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeBlockRequest) ProtoMessage()    {}
func (*FinalizeBlockRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{16}
}
func (m *FinalizeBlockRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FinalizeBlockRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FinalizeBlockRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FinalizeBlockRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBlockRequest.Merge(m, src)
}
func (m *FinalizeBlockRequest) XXX_Size() int {
	return m.Size()
}
func (m *FinalizeBlockRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBlockRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBlockRequest proto.InternalMessageInfo

func (m *FinalizeBlockRequest) GetTxs() [][]byte {
	if m != nil {
		return m.Txs
	}
	return nil
}

func (m *FinalizeBlockRequest) GetDecidedLastCommit() CommitInfo {
	if m != nil {
		return m.DecidedLastCommit
	}
	return CommitInfo{}
}

func (m *FinalizeBlockRequest) GetMisbehavior() []Misbehavior {
	if m != nil {
		return m.Misbehavior
	}
	return nil
}

func (m *FinalizeBlockRequest) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *FinalizeBlockRequest) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *FinalizeBlockRequest) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *FinalizeBlockRequest) GetNextValidatorsHash() []byte {
	if m != nil {
		return m.NextValidatorsHash
	}
	return nil
}

func (m *FinalizeBlockRequest) GetProposerAddress() []byte {
	if m != nil {
		return m.ProposerAddress
	}
	return nil
}

func (m *FinalizeBlockRequest) GetSyncingToHeight() int64 {
	if m != nil {
		return m.SyncingToHeight
	}
	return 0
}

// Response represents a response from the ABCI application.
type Response struct {
	// Sum of all possible messages.
	//
	// Types that are valid to be assigned to Value:
	//
	//	*Response_Exception
	//	*Response_Echo
	//	*Response_Flush
	//	*Response_Info
	//	*Response_InitChain
	//	*Response_Query
	//	*Response_CheckTx
	//	*Response_Commit
	//	*Response_ListSnapshots
	//	*Response_OfferSnapshot
	//	*Response_LoadSnapshotChunk
	//	*Response_ApplySnapshotChunk
	//	*Response_PrepareProposal
	//	*Response_ProcessProposal
	//	*Response_ExtendVote
	//	*Response_VerifyVoteExtension
	//	*Response_FinalizeBlock
	Value isResponse_Value `protobuf_oneof:"value"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{17}
}
func (m *Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return m.Size()
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

type isResponse_Value interface {
	isResponse_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Response_Exception struct {
	Exception *ExceptionResponse `protobuf:"bytes,1,opt,name=exception,proto3,oneof" json:"exception,omitempty"`
}
type Response_Echo struct {
	Echo *EchoResponse `protobuf:"bytes,2,opt,name=echo,proto3,oneof" json:"echo,omitempty"`
}
type Response_Flush struct {
	Flush *FlushResponse `protobuf:"bytes,3,opt,name=flush,proto3,oneof" json:"flush,omitempty"`
}
type Response_Info struct {
	Info *InfoResponse `protobuf:"bytes,4,opt,name=info,proto3,oneof" json:"info,omitempty"`
}
type Response_InitChain struct {
	InitChain *InitChainResponse `protobuf:"bytes,6,opt,name=init_chain,json=initChain,proto3,oneof" json:"init_chain,omitempty"`
}
type Response_Query struct {
	Query *QueryResponse `protobuf:"bytes,7,opt,name=query,proto3,oneof" json:"query,omitempty"`
}
type Response_CheckTx struct {
	CheckTx *CheckTxResponse `protobuf:"bytes,9,opt,name=check_tx,json=checkTx,proto3,oneof" json:"check_tx,omitempty"`
}
type Response_Commit struct {
	Commit *CommitResponse `protobuf:"bytes,12,opt,name=commit,proto3,oneof" json:"commit,omitempty"`
}
type Response_ListSnapshots struct {
	ListSnapshots *ListSnapshotsResponse `protobuf:"bytes,13,opt,name=list_snapshots,json=listSnapshots,proto3,oneof" json:"list_snapshots,omitempty"`
}
type Response_OfferSnapshot struct {
	OfferSnapshot *OfferSnapshotResponse `protobuf:"bytes,14,opt,name=offer_snapshot,json=offerSnapshot,proto3,oneof" json:"offer_snapshot,omitempty"`
}
type Response_LoadSnapshotChunk struct {
	LoadSnapshotChunk *LoadSnapshotChunkResponse `protobuf:"bytes,15,opt,name=load_snapshot_chunk,json=loadSnapshotChunk,proto3,oneof" json:"load_snapshot_chunk,omitempty"`
}
type Response_ApplySnapshotChunk struct {
	ApplySnapshotChunk *ApplySnapshotChunkResponse `protobuf:"bytes,16,opt,name=apply_snapshot_chunk,json=applySnapshotChunk,proto3,oneof" json:"apply_snapshot_chunk,omitempty"`
}
type Response_PrepareProposal struct {
	PrepareProposal *PrepareProposalResponse `protobuf:"bytes,17,opt,name=prepare_proposal,json=prepareProposal,proto3,oneof" json:"prepare_proposal,omitempty"`
}
type Response_ProcessProposal struct {
	ProcessProposal *ProcessProposalResponse `protobuf:"bytes,18,opt,name=process_proposal,json=processProposal,proto3,oneof" json:"process_proposal,omitempty"`
}
type Response_ExtendVote struct {
	ExtendVote *ExtendVoteResponse `protobuf:"bytes,19,opt,name=extend_vote,json=extendVote,proto3,oneof" json:"extend_vote,omitempty"`
}
type Response_VerifyVoteExtension struct {
	VerifyVoteExtension *VerifyVoteExtensionResponse `protobuf:"bytes,20,opt,name=verify_vote_extension,json=verifyVoteExtension,proto3,oneof" json:"verify_vote_extension,omitempty"`
}
type Response_FinalizeBlock struct {
	FinalizeBlock *FinalizeBlockResponse `protobuf:"bytes,21,opt,name=finalize_block,json=finalizeBlock,proto3,oneof" json:"finalize_block,omitempty"`
}

func (*Response_Exception) isResponse_Value()           {}
func (*Response_Echo) isResponse_Value()                {}
func (*Response_Flush) isResponse_Value()               {}
func (*Response_Info) isResponse_Value()                {}
func (*Response_InitChain) isResponse_Value()           {}
func (*Response_Query) isResponse_Value()               {}
func (*Response_CheckTx) isResponse_Value()             {}
func (*Response_Commit) isResponse_Value()              {}
func (*Response_ListSnapshots) isResponse_Value()       {}
func (*Response_OfferSnapshot) isResponse_Value()       {}
func (*Response_LoadSnapshotChunk) isResponse_Value()   {}
func (*Response_ApplySnapshotChunk) isResponse_Value()  {}
func (*Response_PrepareProposal) isResponse_Value()     {}
func (*Response_ProcessProposal) isResponse_Value()     {}
func (*Response_ExtendVote) isResponse_Value()          {}
func (*Response_VerifyVoteExtension) isResponse_Value() {}
func (*Response_FinalizeBlock) isResponse_Value()       {}

func (m *Response) GetValue() isResponse_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Response) GetException() *ExceptionResponse {
	if x, ok := m.GetValue().(*Response_Exception); ok {
		return x.Exception
	}
	return nil
}

func (m *Response) GetEcho() *EchoResponse {
	if x, ok := m.GetValue().(*Response_Echo); ok {
		return x.Echo
	}
	return nil
}

func (m *Response) GetFlush() *FlushResponse {
	if x, ok := m.GetValue().(*Response_Flush); ok {
		return x.Flush
	}
	return nil
}

func (m *Response) GetInfo() *InfoResponse {
	if x, ok := m.GetValue().(*Response_Info); ok {
		return x.Info
	}
	return nil
}

func (m *Response) GetInitChain() *InitChainResponse {
	if x, ok := m.GetValue().(*Response_InitChain); ok {
		return x.InitChain
	}
	return nil
}

func (m *Response) GetQuery() *QueryResponse {
	if x, ok := m.GetValue().(*Response_Query); ok {
		return x.Query
	}
	return nil
}

func (m *Response) GetCheckTx() *CheckTxResponse {
	if x, ok := m.GetValue().(*Response_CheckTx); ok {
		return x.CheckTx
	}
	return nil
}

func (m *Response) GetCommit() *CommitResponse {
	if x, ok := m.GetValue().(*Response_Commit); ok {
		return x.Commit
	}
	return nil
}

func (m *Response) GetListSnapshots() *ListSnapshotsResponse {
	if x, ok := m.GetValue().(*Response_ListSnapshots); ok {
		return x.ListSnapshots
	}
	return nil
}

func (m *Response) GetOfferSnapshot() *OfferSnapshotResponse {
	if x, ok := m.GetValue().(*Response_OfferSnapshot); ok {
		return x.OfferSnapshot
	}
	return nil
}

func (m *Response) GetLoadSnapshotChunk() *LoadSnapshotChunkResponse {
	if x, ok := m.GetValue().(*Response_LoadSnapshotChunk); ok {
		return x.LoadSnapshotChunk
	}
	return nil
}

func (m *Response) GetApplySnapshotChunk() *ApplySnapshotChunkResponse {
	if x, ok := m.GetValue().(*Response_ApplySnapshotChunk); ok {
		return x.ApplySnapshotChunk
	}
	return nil
}

func (m *Response) GetPrepareProposal() *PrepareProposalResponse {
	if x, ok := m.GetValue().(*Response_PrepareProposal); ok {
		return x.PrepareProposal
	}
	return nil
}

func (m *Response) GetProcessProposal() *ProcessProposalResponse {
	if x, ok := m.GetValue().(*Response_ProcessProposal); ok {
		return x.ProcessProposal
	}
	return nil
}

func (m *Response) GetExtendVote() *ExtendVoteResponse {
	if x, ok := m.GetValue().(*Response_ExtendVote); ok {
		return x.ExtendVote
	}
	return nil
}

func (m *Response) GetVerifyVoteExtension() *VerifyVoteExtensionResponse {
	if x, ok := m.GetValue().(*Response_VerifyVoteExtension); ok {
		return x.VerifyVoteExtension
	}
	return nil
}

func (m *Response) GetFinalizeBlock() *FinalizeBlockResponse {
	if x, ok := m.GetValue().(*Response_FinalizeBlock); ok {
		return x.FinalizeBlock
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Response) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Response_Exception)(nil),
		(*Response_Echo)(nil),
		(*Response_Flush)(nil),
		(*Response_Info)(nil),
		(*Response_InitChain)(nil),
		(*Response_Query)(nil),
		(*Response_CheckTx)(nil),
		(*Response_Commit)(nil),
		(*Response_ListSnapshots)(nil),
		(*Response_OfferSnapshot)(nil),
		(*Response_LoadSnapshotChunk)(nil),
		(*Response_ApplySnapshotChunk)(nil),
		(*Response_PrepareProposal)(nil),
		(*Response_ProcessProposal)(nil),
		(*Response_ExtendVote)(nil),
		(*Response_VerifyVoteExtension)(nil),
		(*Response_FinalizeBlock)(nil),
	}
}

// nondeterministic
type ExceptionResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *ExceptionResponse) Reset()         { *m = ExceptionResponse{} }
func (m *ExceptionResponse) String() string { return proto.CompactTextString(m) }
func (*ExceptionResponse) ProtoMessage()    {}
func (*ExceptionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{18}
}
func (m *ExceptionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExceptionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExceptionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExceptionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExceptionResponse.Merge(m, src)
}
func (m *ExceptionResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExceptionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExceptionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExceptionResponse proto.InternalMessageInfo

func (m *ExceptionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// EchoResponse indicates that the connection is still alive.
type EchoResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *EchoResponse) Reset()         { *m = EchoResponse{} }
func (m *EchoResponse) String() string { return proto.CompactTextString(m) }
func (*EchoResponse) ProtoMessage()    {}
func (*EchoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{19}
}
func (m *EchoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EchoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EchoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EchoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EchoResponse.Merge(m, src)
}
func (m *EchoResponse) XXX_Size() int {
	return m.Size()
}
func (m *EchoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EchoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EchoResponse proto.InternalMessageInfo

func (m *EchoResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// FlushResponse indicates that the write buffer was flushed.
type FlushResponse struct {
}

func (m *FlushResponse) Reset()         { *m = FlushResponse{} }
func (m *FlushResponse) String() string { return proto.CompactTextString(m) }
func (*FlushResponse) ProtoMessage()    {}
func (*FlushResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{20}
}
func (m *FlushResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlushResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlushResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlushResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlushResponse.Merge(m, src)
}
func (m *FlushResponse) XXX_Size() int {
	return m.Size()
}
func (m *FlushResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FlushResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FlushResponse proto.InternalMessageInfo

// InfoResponse contains the ABCI application version information.
type InfoResponse struct {
	Data             string `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Version          string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	AppVersion       uint64 `protobuf:"varint,3,opt,name=app_version,json=appVersion,proto3" json:"app_version,omitempty"`
	LastBlockHeight  int64  `protobuf:"varint,4,opt,name=last_block_height,json=lastBlockHeight,proto3" json:"last_block_height,omitempty"`
	LastBlockAppHash []byte `protobuf:"bytes,5,opt,name=last_block_app_hash,json=lastBlockAppHash,proto3" json:"last_block_app_hash,omitempty"`
}

func (m *InfoResponse) Reset()         { *m = InfoResponse{} }
func (m *InfoResponse) String() string { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()    {}
func (*InfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{21}
}
func (m *InfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoResponse.Merge(m, src)
}
func (m *InfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *InfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InfoResponse proto.InternalMessageInfo

func (m *InfoResponse) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

func (m *InfoResponse) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *InfoResponse) GetAppVersion() uint64 {
	if m != nil {
		return m.AppVersion
	}
	return 0
}

func (m *InfoResponse) GetLastBlockHeight() int64 {
	if m != nil {
		return m.LastBlockHeight
	}
	return 0
}

func (m *InfoResponse) GetLastBlockAppHash() []byte {
	if m != nil {
		return m.LastBlockAppHash
	}
	return nil
}

// InitChainResponse contains the ABCI application's hash and updates to the
// validator set and/or the consensus params, if any.
type InitChainResponse struct {
	ConsensusParams *v1.ConsensusParams `protobuf:"bytes,1,opt,name=consensus_params,json=consensusParams,proto3" json:"consensus_params,omitempty"`
	Validators      []ValidatorUpdate   `protobuf:"bytes,2,rep,name=validators,proto3" json:"validators"`
	AppHash         []byte              `protobuf:"bytes,3,opt,name=app_hash,json=appHash,proto3" json:"app_hash,omitempty"`
}

func (m *InitChainResponse) Reset()         { *m = InitChainResponse{} }
func (m *InitChainResponse) String() string { return proto.CompactTextString(m) }
func (*InitChainResponse) ProtoMessage()    {}
func (*InitChainResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{22}
}
func (m *InitChainResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InitChainResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InitChainResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InitChainResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitChainResponse.Merge(m, src)
}
func (m *InitChainResponse) XXX_Size() int {
	return m.Size()
}
func (m *InitChainResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InitChainResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InitChainResponse proto.InternalMessageInfo

func (m *InitChainResponse) GetConsensusParams() *v1.ConsensusParams {
	if m != nil {
		return m.ConsensusParams
	}
	return nil
}

func (m *InitChainResponse) GetValidators() []ValidatorUpdate {
	if m != nil {
		return m.Validators
	}
	return nil
}

func (m *InitChainResponse) GetAppHash() []byte {
	if m != nil {
		return m.AppHash
	}
	return nil
}

// QueryResponse contains the ABCI application data along with a proof.
type QueryResponse struct {
	Code uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// bytes data = 2; // use "value" instead.
	Log       string        `protobuf:"bytes,3,opt,name=log,proto3" json:"log,omitempty"`
	Info      string        `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	Index     int64         `protobuf:"varint,5,opt,name=index,proto3" json:"index,omitempty"`
	Key       []byte        `protobuf:"bytes,6,opt,name=key,proto3" json:"key,omitempty"`
	Value     []byte        `protobuf:"bytes,7,opt,name=value,proto3" json:"value,omitempty"`
	ProofOps  *v11.ProofOps `protobuf:"bytes,8,opt,name=proof_ops,json=proofOps,proto3" json:"proof_ops,omitempty"`
	Height    int64         `protobuf:"varint,9,opt,name=height,proto3" json:"height,omitempty"`
	Codespace string        `protobuf:"bytes,10,opt,name=codespace,proto3" json:"codespace,omitempty"`
}

func (m *QueryResponse) Reset()         { *m = QueryResponse{} }
func (m *QueryResponse) String() string { return proto.CompactTextString(m) }
func (*QueryResponse) ProtoMessage()    {}
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{23}
}
func (m *QueryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponse.Merge(m, src)
}
func (m *QueryResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponse proto.InternalMessageInfo

func (m *QueryResponse) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *QueryResponse) GetLog() string {
	if m != nil {
		return m.Log
	}
	return ""
}

func (m *QueryResponse) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

func (m *QueryResponse) GetIndex() int64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *QueryResponse) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *QueryResponse) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *QueryResponse) GetProofOps() *v11.ProofOps {
	if m != nil {
		return m.ProofOps
	}
	return nil
}

func (m *QueryResponse) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *QueryResponse) GetCodespace() string {
	if m != nil {
		return m.Codespace
	}
	return ""
}

// CheckTxResponse shows if the transaction was deemed valid by the ABCI
// application.
type CheckTxResponse struct {
	Code      uint32  `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Data      []byte  `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Log       string  `protobuf:"bytes,3,opt,name=log,proto3" json:"log,omitempty"`
	Info      string  `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	GasWanted int64   `protobuf:"varint,5,opt,name=gas_wanted,proto3" json:"gas_wanted,omitempty"`
	GasUsed   int64   `protobuf:"varint,6,opt,name=gas_used,proto3" json:"gas_used,omitempty"`
	Events    []Event `protobuf:"bytes,7,rep,name=events,proto3" json:"events,omitempty"`
	Codespace string  `protobuf:"bytes,8,opt,name=codespace,proto3" json:"codespace,omitempty"`
}

func (m *CheckTxResponse) Reset()         { *m = CheckTxResponse{} }
func (m *CheckTxResponse) String() string { return proto.CompactTextString(m) }
func (*CheckTxResponse) ProtoMessage()    {}
func (*CheckTxResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{24}
}
func (m *CheckTxResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckTxResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckTxResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckTxResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckTxResponse.Merge(m, src)
}
func (m *CheckTxResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckTxResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckTxResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckTxResponse proto.InternalMessageInfo

func (m *CheckTxResponse) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *CheckTxResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *CheckTxResponse) GetLog() string {
	if m != nil {
		return m.Log
	}
	return ""
}

func (m *CheckTxResponse) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

func (m *CheckTxResponse) GetGasWanted() int64 {
	if m != nil {
		return m.GasWanted
	}
	return 0
}

func (m *CheckTxResponse) GetGasUsed() int64 {
	if m != nil {
		return m.GasUsed
	}
	return 0
}

func (m *CheckTxResponse) GetEvents() []Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *CheckTxResponse) GetCodespace() string {
	if m != nil {
		return m.Codespace
	}
	return ""
}

// CommitResponse indicates how much blocks should CometBFT retain.
type CommitResponse struct {
	RetainHeight int64 `protobuf:"varint,3,opt,name=retain_height,json=retainHeight,proto3" json:"retain_height,omitempty"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{25}
}
func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(m, src)
}
func (m *CommitResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetRetainHeight() int64 {
	if m != nil {
		return m.RetainHeight
	}
	return 0
}

// ListSnapshotsResponse contains the list of snapshots.
type ListSnapshotsResponse struct {
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{26}
}
func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(m, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

// OfferSnapshotResponse indicates the ABCI application decision whenever to
// provide a snapshot to the requester or not.
type OfferSnapshotResponse struct {
	Result OfferSnapshotResult `protobuf:"varint,1,opt,name=result,proto3,enum=cometbft.abci.v1.OfferSnapshotResult" json:"result,omitempty"`
}

func (m *OfferSnapshotResponse) Reset()         { *m = OfferSnapshotResponse{} }
func (m *OfferSnapshotResponse) String() string { return proto.CompactTextString(m) }
func (*OfferSnapshotResponse) ProtoMessage()    {}
func (*OfferSnapshotResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{27}
}
func (m *OfferSnapshotResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OfferSnapshotResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OfferSnapshotResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OfferSnapshotResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OfferSnapshotResponse.Merge(m, src)
}
func (m *OfferSnapshotResponse) XXX_Size() int {
	return m.Size()
}
func (m *OfferSnapshotResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_OfferSnapshotResponse.DiscardUnknown(m)
}

var xxx_messageInfo_OfferSnapshotResponse proto.InternalMessageInfo

func (m *OfferSnapshotResponse) GetResult() OfferSnapshotResult {
	if m != nil {
		return m.Result
	}
	return OFFER_SNAPSHOT_RESULT_UNKNOWN
}

// LoadSnapshotChunkResponse returns a snapshot's chunk.
type LoadSnapshotChunkResponse struct {
	Chunk []byte `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (m *LoadSnapshotChunkResponse) Reset()         { *m = LoadSnapshotChunkResponse{} }
func (m *LoadSnapshotChunkResponse) String() string { return proto.CompactTextString(m) }
func (*LoadSnapshotChunkResponse) ProtoMessage()    {}
func (*LoadSnapshotChunkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{28}
}
func (m *LoadSnapshotChunkResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadSnapshotChunkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadSnapshotChunkResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadSnapshotChunkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadSnapshotChunkResponse.Merge(m, src)
}
func (m *LoadSnapshotChunkResponse) XXX_Size() int {
	return m.Size()
}
func (m *LoadSnapshotChunkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadSnapshotChunkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LoadSnapshotChunkResponse proto.InternalMessageInfo

func (m *LoadSnapshotChunkResponse) GetChunk() []byte {
	if m != nil {
		return m.Chunk
	}
	return nil
}

// ApplySnapshotChunkResponse returns a result of applying the specified chunk.
type ApplySnapshotChunkResponse struct {
	Result        ApplySnapshotChunkResult `protobuf:"varint,1,opt,name=result,proto3,enum=cometbft.abci.v1.ApplySnapshotChunkResult" json:"result,omitempty"`
	RefetchChunks []uint32                 `protobuf:"varint,2,rep,packed,name=refetch_chunks,json=refetchChunks,proto3" json:"refetch_chunks,omitempty"`
	RejectSenders []string                 `protobuf:"bytes,3,rep,name=reject_senders,json=rejectSenders,proto3" json:"reject_senders,omitempty"`
}

func (m *ApplySnapshotChunkResponse) Reset()         { *m = ApplySnapshotChunkResponse{} }
func (m *ApplySnapshotChunkResponse) String() string { return proto.CompactTextString(m) }
func (*ApplySnapshotChunkResponse) ProtoMessage()    {}
func (*ApplySnapshotChunkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{29}
}
func (m *ApplySnapshotChunkResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplySnapshotChunkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplySnapshotChunkResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplySnapshotChunkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplySnapshotChunkResponse.Merge(m, src)
}
func (m *ApplySnapshotChunkResponse) XXX_Size() int {
	return m.Size()
}
func (m *ApplySnapshotChunkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplySnapshotChunkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplySnapshotChunkResponse proto.InternalMessageInfo

func (m *ApplySnapshotChunkResponse) GetResult() ApplySnapshotChunkResult {
	if m != nil {
		return m.Result
	}
	return APPLY_SNAPSHOT_CHUNK_RESULT_UNKNOWN
}

func (m *ApplySnapshotChunkResponse) GetRefetchChunks() []uint32 {
	if m != nil {
		return m.RefetchChunks
	}
	return nil
}

func (m *ApplySnapshotChunkResponse) GetRejectSenders() []string {
	if m != nil {
		return m.RejectSenders
	}
	return nil
}

// PrepareProposalResponse contains a list of transactions, which will form a block.
type PrepareProposalResponse struct {
	Txs [][]byte `protobuf:"bytes,1,rep,name=txs,proto3" json:"txs,omitempty"`
}

func (m *PrepareProposalResponse) Reset()         { *m = PrepareProposalResponse{} }
func (m *PrepareProposalResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareProposalResponse) ProtoMessage()    {}
func (*PrepareProposalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{30}
}
func (m *PrepareProposalResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrepareProposalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrepareProposalResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrepareProposalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareProposalResponse.Merge(m, src)
}
func (m *PrepareProposalResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrepareProposalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareProposalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareProposalResponse proto.InternalMessageInfo

func (m *PrepareProposalResponse) GetTxs() [][]byte {
	if m != nil {
		return m.Txs
	}
	return nil
}

// ProcessProposalResponse indicates the ABCI application's decision whenever
// the given proposal should be accepted or not.
type ProcessProposalResponse struct {
	Status ProcessProposalStatus `protobuf:"varint,1,opt,name=status,proto3,enum=cometbft.abci.v1.ProcessProposalStatus" json:"status,omitempty"`
}

func (m *ProcessProposalResponse) Reset()         { *m = ProcessProposalResponse{} }
func (m *ProcessProposalResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessProposalResponse) ProtoMessage()    {}
func (*ProcessProposalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{31}
}
func (m *ProcessProposalResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessProposalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessProposalResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessProposalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessProposalResponse.Merge(m, src)
}
func (m *ProcessProposalResponse) XXX_Size() int {
	return m.Size()
}
func (m *ProcessProposalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessProposalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessProposalResponse proto.InternalMessageInfo

func (m *ProcessProposalResponse) GetStatus() ProcessProposalStatus {
	if m != nil {
		return m.Status
	}
	return PROCESS_PROPOSAL_STATUS_UNKNOWN
}

// ExtendVoteResponse contains the vote extension that the application would like to
// attach to its next precommit vote.
type ExtendVoteResponse struct {
	VoteExtension []byte `protobuf:"bytes,1,opt,name=vote_extension,json=voteExtension,proto3" json:"vote_extension,omitempty"`
}

func (m *ExtendVoteResponse) Reset()         { *m = ExtendVoteResponse{} }
func (m *ExtendVoteResponse) String() string { return proto.CompactTextString(m) }
func (*ExtendVoteResponse) ProtoMessage()    {}
func (*ExtendVoteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{32}
}
func (m *ExtendVoteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExtendVoteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExtendVoteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExtendVoteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtendVoteResponse.Merge(m, src)
}
func (m *ExtendVoteResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExtendVoteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtendVoteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExtendVoteResponse proto.InternalMessageInfo

func (m *ExtendVoteResponse) GetVoteExtension() []byte {
	if m != nil {
		return m.VoteExtension
	}
	return nil
}

// VerifyVoteExtensionResponse indicates the ABCI application's decision
// whenever the vote extension should be accepted or not.
type VerifyVoteExtensionResponse struct {
	Status VerifyVoteExtensionStatus `protobuf:"varint,1,opt,name=status,proto3,enum=cometbft.abci.v1.VerifyVoteExtensionStatus" json:"status,omitempty"`
}

func (m *VerifyVoteExtensionResponse) Reset()         { *m = VerifyVoteExtensionResponse{} }
func (m *VerifyVoteExtensionResponse) String() string { return proto.CompactTextString(m) }
func (*VerifyVoteExtensionResponse) ProtoMessage()    {}
func (*VerifyVoteExtensionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{33}
}
func (m *VerifyVoteExtensionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerifyVoteExtensionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerifyVoteExtensionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerifyVoteExtensionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyVoteExtensionResponse.Merge(m, src)
}
func (m *VerifyVoteExtensionResponse) XXX_Size() int {
	return m.Size()
}
func (m *VerifyVoteExtensionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyVoteExtensionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyVoteExtensionResponse proto.InternalMessageInfo

func (m *VerifyVoteExtensionResponse) GetStatus() VerifyVoteExtensionStatus {
	if m != nil {
		return m.Status
	}
	return VERIFY_VOTE_EXTENSION_STATUS_UNKNOWN
}

// FinalizeBlockResponse contains the result of executing the block.
type FinalizeBlockResponse struct {
	// set of block events emitted as part of executing the block
	Events []Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	// the result of executing each transaction including the events
	// the particular transaction emitted. This should match the order
	// of the transactions delivered in the block itself
	TxResults []*ExecTxResult `protobuf:"bytes,2,rep,name=tx_results,json=txResults,proto3" json:"tx_results,omitempty"`
	// a list of updates to the validator set. These will reflect the validator set at current height + 2.
	ValidatorUpdates []ValidatorUpdate `protobuf:"bytes,3,rep,name=validator_updates,json=validatorUpdates,proto3" json:"validator_updates"`
	// updates to the consensus params, if any.
	ConsensusParamUpdates *v1.ConsensusParams `protobuf:"bytes,4,opt,name=consensus_param_updates,json=consensusParamUpdates,proto3" json:"consensus_param_updates,omitempty"`
	// app_hash is the hash of the applications' state which is used to confirm
	// that execution of the transactions was deterministic.
	// It is up to the application to decide which algorithm to use.
	AppHash []byte `protobuf:"bytes,5,opt,name=app_hash,json=appHash,proto3" json:"app_hash,omitempty"`
}

func (m *FinalizeBlockResponse) Reset()         { *m = FinalizeBlockResponse{} }
func (m *FinalizeBlockResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeBlockResponse) ProtoMessage()    {}
func (*FinalizeBlockResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{34}
}
func (m *FinalizeBlockResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FinalizeBlockResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FinalizeBlockResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FinalizeBlockResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBlockResponse.Merge(m, src)
}
func (m *FinalizeBlockResponse) XXX_Size() int {
	return m.Size()
}
func (m *FinalizeBlockResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBlockResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBlockResponse proto.InternalMessageInfo

func (m *FinalizeBlockResponse) GetEvents() []Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *FinalizeBlockResponse) GetTxResults() []*ExecTxResult {
	if m != nil {
		return m.TxResults
	}
	return nil
}

func (m *FinalizeBlockResponse) GetValidatorUpdates() []ValidatorUpdate {
	if m != nil {
		return m.ValidatorUpdates
	}
	return nil
}

func (m *FinalizeBlockResponse) GetConsensusParamUpdates() *v1.ConsensusParams {
	if m != nil {
		return m.ConsensusParamUpdates
	}
	return nil
}

func (m *FinalizeBlockResponse) GetAppHash() []byte {
	if m != nil {
		return m.AppHash
	}
	return nil
}

// CommitInfo contains votes for the particular round.
type CommitInfo struct {
	Round int32      `protobuf:"varint,1,opt,name=round,proto3" json:"round,omitempty"`
	Votes []VoteInfo `protobuf:"bytes,2,rep,name=votes,proto3" json:"votes"`
}

func (m *CommitInfo) Reset()         { *m = CommitInfo{} }
func (m *CommitInfo) String() string { return proto.CompactTextString(m) }
func (*CommitInfo) ProtoMessage()    {}
func (*CommitInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{35}
}
func (m *CommitInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitInfo.Merge(m, src)
}
func (m *CommitInfo) XXX_Size() int {
	return m.Size()
}
func (m *CommitInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CommitInfo proto.InternalMessageInfo

func (m *CommitInfo) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *CommitInfo) GetVotes() []VoteInfo {
	if m != nil {
		return m.Votes
	}
	return nil
}

// ExtendedCommitInfo is similar to CommitInfo except that it is only used in
// the PrepareProposal request such that Tendermint can provide vote extensions
// to the application.
type ExtendedCommitInfo struct {
	// The round at which the block proposer decided in the previous height.
	Round int32 `protobuf:"varint,1,opt,name=round,proto3" json:"round,omitempty"`
	// List of validators' addresses in the last validator set with their voting
	// information, including vote extensions.
	Votes []ExtendedVoteInfo `protobuf:"bytes,2,rep,name=votes,proto3" json:"votes"`
}

func (m *ExtendedCommitInfo) Reset()         { *m = ExtendedCommitInfo{} }
func (m *ExtendedCommitInfo) String() string { return proto.CompactTextString(m) }
func (*ExtendedCommitInfo) ProtoMessage()    {}
func (*ExtendedCommitInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{36}
}
func (m *ExtendedCommitInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExtendedCommitInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExtendedCommitInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExtendedCommitInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtendedCommitInfo.Merge(m, src)
}
func (m *ExtendedCommitInfo) XXX_Size() int {
	return m.Size()
}
func (m *ExtendedCommitInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtendedCommitInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExtendedCommitInfo proto.InternalMessageInfo

func (m *ExtendedCommitInfo) GetRound() int32 {
	if m != nil {
		return m.Round
	}
	return 0
}

func (m *ExtendedCommitInfo) GetVotes() []ExtendedVoteInfo {
	if m != nil {
		return m.Votes
	}
	return nil
}

// Event allows application developers to attach additional information to
// ResponseFinalizeBlock and ResponseCheckTx.
// Up to 0.37, this could also be used in ResponseBeginBlock, ResponseEndBlock,
// and ResponseDeliverTx.
// Later, transactions may be queried using these events.
type Event struct {
	Type       string           `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Attributes []EventAttribute `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{37}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Event) GetAttributes() []EventAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// EventAttribute is a single key-value pair, associated with an event.
type EventAttribute struct {
	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Index bool   `protobuf:"varint,3,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *EventAttribute) Reset()         { *m = EventAttribute{} }
func (m *EventAttribute) String() string { return proto.CompactTextString(m) }
func (*EventAttribute) ProtoMessage()    {}
func (*EventAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{38}
}
func (m *EventAttribute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventAttribute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventAttribute.Merge(m, src)
}
func (m *EventAttribute) XXX_Size() int {
	return m.Size()
}
func (m *EventAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_EventAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_EventAttribute proto.InternalMessageInfo

func (m *EventAttribute) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *EventAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EventAttribute) GetIndex() bool {
	if m != nil {
		return m.Index
	}
	return false
}

// ExecTxResult contains results of executing one individual transaction.
//
// * Its structure is equivalent to #ResponseDeliverTx which will be deprecated/deleted
type ExecTxResult struct {
	Code      uint32  `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Data      []byte  `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Log       string  `protobuf:"bytes,3,opt,name=log,proto3" json:"log,omitempty"`
	Info      string  `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	GasWanted int64   `protobuf:"varint,5,opt,name=gas_wanted,proto3" json:"gas_wanted,omitempty"`
	GasUsed   int64   `protobuf:"varint,6,opt,name=gas_used,proto3" json:"gas_used,omitempty"`
	Events    []Event `protobuf:"bytes,7,rep,name=events,proto3" json:"events,omitempty"`
	Codespace string  `protobuf:"bytes,8,opt,name=codespace,proto3" json:"codespace,omitempty"`
}

func (m *ExecTxResult) Reset()         { *m = ExecTxResult{} }
func (m *ExecTxResult) String() string { return proto.CompactTextString(m) }
func (*ExecTxResult) ProtoMessage()    {}
func (*ExecTxResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{39}
}
func (m *ExecTxResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecTxResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecTxResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecTxResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecTxResult.Merge(m, src)
}
func (m *ExecTxResult) XXX_Size() int {
	return m.Size()
}
func (m *ExecTxResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecTxResult.DiscardUnknown(m)
}

var xxx_messageInfo_ExecTxResult proto.InternalMessageInfo

func (m *ExecTxResult) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *ExecTxResult) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ExecTxResult) GetLog() string {
	if m != nil {
		return m.Log
	}
	return ""
}

func (m *ExecTxResult) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

func (m *ExecTxResult) GetGasWanted() int64 {
	if m != nil {
		return m.GasWanted
	}
	return 0
}

func (m *ExecTxResult) GetGasUsed() int64 {
	if m != nil {
		return m.GasUsed
	}
	return 0
}

func (m *ExecTxResult) GetEvents() []Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *ExecTxResult) GetCodespace() string {
	if m != nil {
		return m.Codespace
	}
	return ""
}

// TxResult contains results of executing the transaction.
//
// One usage is indexing transaction results.
type TxResult struct {
	Height int64        `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Index  uint32       `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	Tx     []byte       `protobuf:"bytes,3,opt,name=tx,proto3" json:"tx,omitempty"`
	Result ExecTxResult `protobuf:"bytes,4,opt,name=result,proto3" json:"result"`
}

func (m *TxResult) Reset()         { *m = TxResult{} }
func (m *TxResult) String() string { return proto.CompactTextString(m) }
func (*TxResult) ProtoMessage()    {}
func (*TxResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{40}
}
func (m *TxResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxResult.Merge(m, src)
}
func (m *TxResult) XXX_Size() int {
	return m.Size()
}
func (m *TxResult) XXX_DiscardUnknown() {
	xxx_messageInfo_TxResult.DiscardUnknown(m)
}

var xxx_messageInfo_TxResult proto.InternalMessageInfo

func (m *TxResult) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *TxResult) GetIndex() uint32 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *TxResult) GetTx() []byte {
	if m != nil {
		return m.Tx
	}
	return nil
}

func (m *TxResult) GetResult() ExecTxResult {
	if m != nil {
		return m.Result
	}
	return ExecTxResult{}
}

// Validator in the validator set.
type Validator struct {
	Address []byte `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// PubKey pub_key = 2 [(gogoproto.nullable)=false];
	Power int64 `protobuf:"varint,3,opt,name=power,proto3" json:"power,omitempty"`
}

func (m *Validator) Reset()         { *m = Validator{} }
func (m *Validator) String() string { return proto.CompactTextString(m) }
func (*Validator) ProtoMessage()    {}
func (*Validator) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{41}
}
func (m *Validator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Validator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Validator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Validator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Validator.Merge(m, src)
}
func (m *Validator) XXX_Size() int {
	return m.Size()
}
func (m *Validator) XXX_DiscardUnknown() {
	xxx_messageInfo_Validator.DiscardUnknown(m)
}

var xxx_messageInfo_Validator proto.InternalMessageInfo

func (m *Validator) GetAddress() []byte {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Validator) GetPower() int64 {
	if m != nil {
		return m.Power
	}
	return 0
}

// ValidatorUpdate is a singular update to a validator set.
type ValidatorUpdate struct {
	Power       int64  `protobuf:"varint,2,opt,name=power,proto3" json:"power,omitempty"`
	PubKeyBytes []byte `protobuf:"bytes,3,opt,name=pub_key_bytes,json=pubKeyBytes,proto3" json:"pub_key_bytes,omitempty"`
	PubKeyType  string `protobuf:"bytes,4,opt,name=pub_key_type,json=pubKeyType,proto3" json:"pub_key_type,omitempty"`
}

func (m *ValidatorUpdate) Reset()         { *m = ValidatorUpdate{} }
func (m *ValidatorUpdate) String() string { return proto.CompactTextString(m) }
func (*ValidatorUpdate) ProtoMessage()    {}
func (*ValidatorUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{42}
}
func (m *ValidatorUpdate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidatorUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidatorUpdate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidatorUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidatorUpdate.Merge(m, src)
}
func (m *ValidatorUpdate) XXX_Size() int {
	return m.Size()
}
func (m *ValidatorUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidatorUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_ValidatorUpdate proto.InternalMessageInfo

func (m *ValidatorUpdate) GetPower() int64 {
	if m != nil {
		return m.Power
	}
	return 0
}

func (m *ValidatorUpdate) GetPubKeyBytes() []byte {
	if m != nil {
		return m.PubKeyBytes
	}
	return nil
}

func (m *ValidatorUpdate) GetPubKeyType() string {
	if m != nil {
		return m.PubKeyType
	}
	return ""
}

// VoteInfo contains the information about the vote.
type VoteInfo struct {
	Validator   Validator      `protobuf:"bytes,1,opt,name=validator,proto3" json:"validator"`
	BlockIdFlag v1.BlockIDFlag `protobuf:"varint,3,opt,name=block_id_flag,json=blockIdFlag,proto3,enum=cometbft.types.v1.BlockIDFlag" json:"block_id_flag,omitempty"`
}

func (m *VoteInfo) Reset()         { *m = VoteInfo{} }
func (m *VoteInfo) String() string { return proto.CompactTextString(m) }
func (*VoteInfo) ProtoMessage()    {}
func (*VoteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{43}
}
func (m *VoteInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VoteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VoteInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VoteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoteInfo.Merge(m, src)
}
func (m *VoteInfo) XXX_Size() int {
	return m.Size()
}
func (m *VoteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VoteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VoteInfo proto.InternalMessageInfo

func (m *VoteInfo) GetValidator() Validator {
	if m != nil {
		return m.Validator
	}
	return Validator{}
}

func (m *VoteInfo) GetBlockIdFlag() v1.BlockIDFlag {
	if m != nil {
		return m.BlockIdFlag
	}
	return v1.BlockIDFlagUnknown
}

// ExtendedVoteInfo extends VoteInfo with the vote extensions (non-deterministic).
type ExtendedVoteInfo struct {
	// The validator that sent the vote.
	Validator Validator `protobuf:"bytes,1,opt,name=validator,proto3" json:"validator"`
	// Non-deterministic extension provided by the sending validator's application.
	VoteExtension []byte `protobuf:"bytes,3,opt,name=vote_extension,json=voteExtension,proto3" json:"vote_extension,omitempty"`
	// Vote extension signature created by CometBFT
	ExtensionSignature []byte `protobuf:"bytes,4,opt,name=extension_signature,json=extensionSignature,proto3" json:"extension_signature,omitempty"`
	// block_id_flag indicates whether the validator voted for a block, nil, or did not vote at all
	BlockIdFlag v1.BlockIDFlag `protobuf:"varint,5,opt,name=block_id_flag,json=blockIdFlag,proto3,enum=cometbft.types.v1.BlockIDFlag" json:"block_id_flag,omitempty"`
}

func (m *ExtendedVoteInfo) Reset()         { *m = ExtendedVoteInfo{} }
func (m *ExtendedVoteInfo) String() string { return proto.CompactTextString(m) }
func (*ExtendedVoteInfo) ProtoMessage()    {}
func (*ExtendedVoteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{44}
}
func (m *ExtendedVoteInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExtendedVoteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExtendedVoteInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExtendedVoteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtendedVoteInfo.Merge(m, src)
}
func (m *ExtendedVoteInfo) XXX_Size() int {
	return m.Size()
}
func (m *ExtendedVoteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtendedVoteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExtendedVoteInfo proto.InternalMessageInfo

func (m *ExtendedVoteInfo) GetValidator() Validator {
	if m != nil {
		return m.Validator
	}
	return Validator{}
}

func (m *ExtendedVoteInfo) GetVoteExtension() []byte {
	if m != nil {
		return m.VoteExtension
	}
	return nil
}

func (m *ExtendedVoteInfo) GetExtensionSignature() []byte {
	if m != nil {
		return m.ExtensionSignature
	}
	return nil
}

func (m *ExtendedVoteInfo) GetBlockIdFlag() v1.BlockIDFlag {
	if m != nil {
		return m.BlockIdFlag
	}
	return v1.BlockIDFlagUnknown
}

// Misbehavior is a type of misbehavior committed by a validator.
type Misbehavior struct {
	Type MisbehaviorType `protobuf:"varint,1,opt,name=type,proto3,enum=cometbft.abci.v1.MisbehaviorType" json:"type,omitempty"`
	// The offending validator
	Validator Validator `protobuf:"bytes,2,opt,name=validator,proto3" json:"validator"`
	// The height when the offense occurred
	Height int64 `protobuf:"varint,3,opt,name=height,proto3" json:"height,omitempty"`
	// The corresponding time where the offense occurred
	Time time.Time `protobuf:"bytes,4,opt,name=time,proto3,stdtime" json:"time"`
	// Total voting power of the validator set in case the ABCI application does
	// not store historical validators.
	// https://github.com/tendermint/tendermint/issues/4581
	TotalVotingPower int64 `protobuf:"varint,5,opt,name=total_voting_power,json=totalVotingPower,proto3" json:"total_voting_power,omitempty"`
}

func (m *Misbehavior) Reset()         { *m = Misbehavior{} }
func (m *Misbehavior) String() string { return proto.CompactTextString(m) }
func (*Misbehavior) ProtoMessage()    {}
func (*Misbehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{45}
}
func (m *Misbehavior) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Misbehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Misbehavior.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Misbehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Misbehavior.Merge(m, src)
}
func (m *Misbehavior) XXX_Size() int {
	return m.Size()
}
func (m *Misbehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_Misbehavior.DiscardUnknown(m)
}

var xxx_messageInfo_Misbehavior proto.InternalMessageInfo

func (m *Misbehavior) GetType() MisbehaviorType {
	if m != nil {
		return m.Type
	}
	return MISBEHAVIOR_TYPE_UNKNOWN
}

func (m *Misbehavior) GetValidator() Validator {
	if m != nil {
		return m.Validator
	}
	return Validator{}
}

func (m *Misbehavior) GetHeight() int64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Misbehavior) GetTime() time.Time {
	if m != nil {
		return m.Time
	}
	return time.Time{}
}

func (m *Misbehavior) GetTotalVotingPower() int64 {
	if m != nil {
		return m.TotalVotingPower
	}
	return 0
}

// Snapshot of the ABCI application state.
type Snapshot struct {
	Height   uint64 `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Format   uint32 `protobuf:"varint,2,opt,name=format,proto3" json:"format,omitempty"`
	Chunks   uint32 `protobuf:"varint,3,opt,name=chunks,proto3" json:"chunks,omitempty"`
	Hash     []byte `protobuf:"bytes,4,opt,name=hash,proto3" json:"hash,omitempty"`
	Metadata []byte `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_95dd8f7b670b96e3, []int{46}
}
func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return m.Size()
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetHeight() uint64 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Snapshot) GetFormat() uint32 {
	if m != nil {
		return m.Format
	}
	return 0
}

func (m *Snapshot) GetChunks() uint32 {
	if m != nil {
		return m.Chunks
	}
	return 0
}

func (m *Snapshot) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *Snapshot) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterEnum("cometbft.abci.v1.CheckTxType", CheckTxType_name, CheckTxType_value)
	proto.RegisterEnum("cometbft.abci.v1.OfferSnapshotResult", OfferSnapshotResult_name, OfferSnapshotResult_value)
	proto.RegisterEnum("cometbft.abci.v1.ApplySnapshotChunkResult", ApplySnapshotChunkResult_name, ApplySnapshotChunkResult_value)
	proto.RegisterEnum("cometbft.abci.v1.ProcessProposalStatus", ProcessProposalStatus_name, ProcessProposalStatus_value)
	proto.RegisterEnum("cometbft.abci.v1.VerifyVoteExtensionStatus", VerifyVoteExtensionStatus_name, VerifyVoteExtensionStatus_value)
	proto.RegisterEnum("cometbft.abci.v1.MisbehaviorType", MisbehaviorType_name, MisbehaviorType_value)
	proto.RegisterType((*Request)(nil), "cometbft.abci.v1.Request")
	proto.RegisterType((*EchoRequest)(nil), "cometbft.abci.v1.EchoRequest")
	proto.RegisterType((*FlushRequest)(nil), "cometbft.abci.v1.FlushRequest")
	proto.RegisterType((*InfoRequest)(nil), "cometbft.abci.v1.InfoRequest")
	proto.RegisterType((*InitChainRequest)(nil), "cometbft.abci.v1.InitChainRequest")
	proto.RegisterType((*QueryRequest)(nil), "cometbft.abci.v1.QueryRequest")
	proto.RegisterType((*CheckTxRequest)(nil), "cometbft.abci.v1.CheckTxRequest")
	proto.RegisterType((*CommitRequest)(nil), "cometbft.abci.v1.CommitRequest")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "cometbft.abci.v1.ListSnapshotsRequest")
	proto.RegisterType((*OfferSnapshotRequest)(nil), "cometbft.abci.v1.OfferSnapshotRequest")
	proto.RegisterType((*LoadSnapshotChunkRequest)(nil), "cometbft.abci.v1.LoadSnapshotChunkRequest")
	proto.RegisterType((*ApplySnapshotChunkRequest)(nil), "cometbft.abci.v1.ApplySnapshotChunkRequest")
	proto.RegisterType((*PrepareProposalRequest)(nil), "cometbft.abci.v1.PrepareProposalRequest")
	proto.RegisterType((*ProcessProposalRequest)(nil), "cometbft.abci.v1.ProcessProposalRequest")
	proto.RegisterType((*ExtendVoteRequest)(nil), "cometbft.abci.v1.ExtendVoteRequest")
	proto.RegisterType((*VerifyVoteExtensionRequest)(nil), "cometbft.abci.v1.VerifyVoteExtensionRequest")
	proto.RegisterType((*FinalizeBlockRequest)(nil), "cometbft.abci.v1.FinalizeBlockRequest")
	proto.RegisterType((*Response)(nil), "cometbft.abci.v1.Response")
	proto.RegisterType((*ExceptionResponse)(nil), "cometbft.abci.v1.ExceptionResponse")
	proto.RegisterType((*EchoResponse)(nil), "cometbft.abci.v1.EchoResponse")
	proto.RegisterType((*FlushResponse)(nil), "cometbft.abci.v1.FlushResponse")
	proto.RegisterType((*InfoResponse)(nil), "cometbft.abci.v1.InfoResponse")
	proto.RegisterType((*InitChainResponse)(nil), "cometbft.abci.v1.InitChainResponse")
	proto.RegisterType((*QueryResponse)(nil), "cometbft.abci.v1.QueryResponse")
	proto.RegisterType((*CheckTxResponse)(nil), "cometbft.abci.v1.CheckTxResponse")
	proto.RegisterType((*CommitResponse)(nil), "cometbft.abci.v1.CommitResponse")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "cometbft.abci.v1.ListSnapshotsResponse")
	proto.RegisterType((*OfferSnapshotResponse)(nil), "cometbft.abci.v1.OfferSnapshotResponse")
	proto.RegisterType((*LoadSnapshotChunkResponse)(nil), "cometbft.abci.v1.LoadSnapshotChunkResponse")
	proto.RegisterType((*ApplySnapshotChunkResponse)(nil), "cometbft.abci.v1.ApplySnapshotChunkResponse")
	proto.RegisterType((*PrepareProposalResponse)(nil), "cometbft.abci.v1.PrepareProposalResponse")
	proto.RegisterType((*ProcessProposalResponse)(nil), "cometbft.abci.v1.ProcessProposalResponse")
	proto.RegisterType((*ExtendVoteResponse)(nil), "cometbft.abci.v1.ExtendVoteResponse")
	proto.RegisterType((*VerifyVoteExtensionResponse)(nil), "cometbft.abci.v1.VerifyVoteExtensionResponse")
	proto.RegisterType((*FinalizeBlockResponse)(nil), "cometbft.abci.v1.FinalizeBlockResponse")
	proto.RegisterType((*CommitInfo)(nil), "cometbft.abci.v1.CommitInfo")
	proto.RegisterType((*ExtendedCommitInfo)(nil), "cometbft.abci.v1.ExtendedCommitInfo")
	proto.RegisterType((*Event)(nil), "cometbft.abci.v1.Event")
	proto.RegisterType((*EventAttribute)(nil), "cometbft.abci.v1.EventAttribute")
	proto.RegisterType((*ExecTxResult)(nil), "cometbft.abci.v1.ExecTxResult")
	proto.RegisterType((*TxResult)(nil), "cometbft.abci.v1.TxResult")
	proto.RegisterType((*Validator)(nil), "cometbft.abci.v1.Validator")
	proto.RegisterType((*ValidatorUpdate)(nil), "cometbft.abci.v1.ValidatorUpdate")
	proto.RegisterType((*VoteInfo)(nil), "cometbft.abci.v1.VoteInfo")
	proto.RegisterType((*ExtendedVoteInfo)(nil), "cometbft.abci.v1.ExtendedVoteInfo")
	proto.RegisterType((*Misbehavior)(nil), "cometbft.abci.v1.Misbehavior")
	proto.RegisterType((*Snapshot)(nil), "cometbft.abci.v1.Snapshot")
}

func init() { proto.RegisterFile("cometbft/abci/v1/types.proto", fileDescriptor_95dd8f7b670b96e3) }

var fileDescriptor_95dd8f7b670b96e3 = []byte{
	// 3168 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5a, 0xcd, 0x6f, 0x1b, 0xc7,
	0xd9, 0xf7, 0xf2, 0x43, 0x22, 0x1f, 0x92, 0xd2, 0x6a, 0x24, 0xd9, 0xb4, 0xe2, 0x48, 0xf2, 0x3a,
	0x8e, 0x1d, 0x3b, 0x91, 0x5e, 0x3b, 0x79, 0xf3, 0xf1, 0xe6, 0x4d, 0x02, 0x8a, 0xa6, 0x22, 0xc9,
	0xb2, 0xc8, 0x2c, 0x69, 0x35, 0x36, 0xda, 0x6e, 0x96, 0xe4, 0x90, 0xdc, 0x98, 0xe4, 0x6e, 0x76,
	0x87, 0x0a, 0xd5, 0x9e, 0x5a, 0x34, 0x45, 0x91, 0x53, 0x2e, 0xbd, 0x14, 0x2d, 0x50, 0xa0, 0xe8,
	0xa9, 0x40, 0x0f, 0x3d, 0xf5, 0x2f, 0x28, 0x72, 0x6a, 0x73, 0xec, 0x29, 0x2d, 0x92, 0x5b, 0x0f,
	0xbd, 0x05, 0xe8, 0xb1, 0x98, 0x8f, 0xfd, 0x22, 0x77, 0x25, 0xd9, 0x49, 0x0f, 0x45, 0x7b, 0xe3,
	0xcc, 0xfc, 0x9e, 0x67, 0x66, 0x9e, 0x99, 0x79, 0x3e, 0x7e, 0x4b, 0xb8, 0xd4, 0x32, 0x07, 0x98,
	0x34, 0x3b, 0x64, 0x53, 0x6f, 0xb6, 0x8c, 0xcd, 0xa3, 0x5b, 0x9b, 0xe4, 0xd8, 0xc2, 0xce, 0x86,
	0x65, 0x9b, 0xc4, 0x44, 0xb2, 0x3b, 0xba, 0x41, 0x47, 0x37, 0x8e, 0x6e, 0xad, 0xac, 0x7a, 0xf8,
	0x96, 0x7d, 0x6c, 0x11, 0x93, 0x4a, 0x58, 0xb6, 0x69, 0x76, 0xb8, 0x44, 0x60, 0x9c, 0xe9, 0x61,
	0xc3, 0xba, 0xad, 0x0f, 0x84, 0xc6, 0x95, 0xcb, 0xd3, 0xe3, 0x47, 0x7a, 0xdf, 0x68, 0xeb, 0xc4,
	0xb4, 0x05, 0x64, 0xa9, 0x6b, 0x76, 0x4d, 0xf6, 0x73, 0x93, 0xfe, 0x12, 0xbd, 0x6b, 0x5d, 0xd3,
	0xec, 0xf6, 0xf1, 0x26, 0x6b, 0x35, 0x47, 0x9d, 0x4d, 0x62, 0x0c, 0xb0, 0x43, 0xf4, 0x81, 0xc5,
	0x01, 0xca, 0x9f, 0xb2, 0x30, 0xab, 0xe2, 0x0f, 0x46, 0xd8, 0x21, 0xe8, 0x45, 0x48, 0xe1, 0x56,
	0xcf, 0x2c, 0x4a, 0xeb, 0xd2, 0xf5, 0xdc, 0xed, 0xa7, 0x37, 0x26, 0xb7, 0xb1, 0x51, 0x69, 0xf5,
	0x4c, 0x01, 0xde, 0x39, 0xa7, 0x32, 0x30, 0x7a, 0x19, 0xd2, 0x9d, 0xfe, 0xc8, 0xe9, 0x15, 0x13,
	0x4c, 0x6a, 0x75, 0x5a, 0x6a, 0x9b, 0x0e, 0xfb, 0x62, 0x1c, 0x4e, 0x27, 0x33, 0x86, 0x1d, 0xb3,
	0x98, 0x8c, 0x9b, 0x6c, 0x77, 0xd8, 0x09, 0x4e, 0x46, 0xc1, 0xa8, 0x0c, 0x60, 0x0c, 0x0d, 0xa2,
	0xb5, 0x7a, 0xba, 0x31, 0x2c, 0xa6, 0x99, 0xa8, 0x12, 0x25, 0x6a, 0x90, 0x32, 0x85, 0xf8, 0xf2,
	0x59, 0xc3, 0xed, 0xa3, 0x2b, 0xfe, 0x60, 0x84, 0xed, 0xe3, 0xe2, 0x4c, 0xdc, 0x8a, 0xdf, 0xa1,
	0xc3, 0x81, 0x15, 0x33, 0x38, 0x7a, 0x03, 0x32, 0xad, 0x1e, 0x6e, 0x3d, 0xd2, 0xc8, 0xb8, 0x98,
	0x61, 0xa2, 0xeb, 0xd3, 0xa2, 0x65, 0x8a, 0x68, 0x8c, 0x7d, 0xe1, 0xd9, 0x16, 0xef, 0x41, 0xaf,
	0xc1, 0x4c, 0xcb, 0x1c, 0x0c, 0x0c, 0x52, 0xcc, 0x31, 0xe1, 0xb5, 0x08, 0x61, 0x36, 0xee, 0xcb,
	0x0a, 0x01, 0x54, 0x85, 0xb9, 0xbe, 0xe1, 0x10, 0xcd, 0x19, 0xea, 0x96, 0xd3, 0x33, 0x89, 0x53,
	0xcc, 0x33, 0x15, 0xcf, 0x4e, 0xab, 0xd8, 0x37, 0x1c, 0x52, 0x77, 0x61, 0xbe, 0xa6, 0x42, 0x3f,
	0xd8, 0x4f, 0x15, 0x9a, 0x9d, 0x0e, 0xb6, 0x3d, 0x8d, 0xc5, 0x42, 0x9c, 0xc2, 0x2a, 0xc5, 0xb9,
	0x92, 0x01, 0x85, 0x66, 0xb0, 0x1f, 0x7d, 0x1b, 0x16, 0xfb, 0xa6, 0xde, 0xf6, 0xf4, 0x69, 0xad,
	0xde, 0x68, 0xf8, 0xa8, 0x38, 0xc7, 0xb4, 0xde, 0x88, 0x58, 0xa6, 0xa9, 0xb7, 0x5d, 0xe1, 0x32,
	0x85, 0xfa, 0x9a, 0x17, 0xfa, 0x93, 0x63, 0x48, 0x83, 0x25, 0xdd, 0xb2, 0xfa, 0xc7, 0x93, 0xea,
	0xe7, 0x99, 0xfa, 0x9b, 0xd3, 0xea, 0x4b, 0x14, 0x1d, 0xa3, 0x1f, 0xe9, 0x53, 0x83, 0xe8, 0x3e,
	0xc8, 0x96, 0x8d, 0x2d, 0xdd, 0xc6, 0x9a, 0x65, 0x9b, 0x96, 0xe9, 0xe8, 0xfd, 0xa2, 0xcc, 0x94,
	0x5f, 0x9f, 0x56, 0x5e, 0xe3, 0xc8, 0x9a, 0x00, 0xfa, 0x9a, 0xe7, 0xad, 0xf0, 0x08, 0x57, 0x6b,
	0xb6, 0xb0, 0xe3, 0xf8, 0x6a, 0x17, 0xe2, 0xd5, 0x32, 0x64, 0xa4, 0xda, 0xd0, 0x08, 0xda, 0x86,
	0x1c, 0x1e, 0x13, 0x3c, 0x6c, 0x6b, 0x47, 0x26, 0xc1, 0x45, 0xc4, 0x34, 0x5e, 0x89, 0x78, 0xae,
	0x0c, 0x74, 0x68, 0x12, 0xec, 0x2b, 0x03, 0xec, 0x75, 0xa2, 0x26, 0x2c, 0x1f, 0x61, 0xdb, 0xe8,
	0x1c, 0x33, 0x3d, 0x1a, 0x1b, 0x71, 0x0c, 0x73, 0x58, 0x5c, 0x64, 0x1a, 0x9f, 0x9f, 0xd6, 0x78,
	0xc8, 0xe0, 0x54, 0xb8, 0xe2, 0x82, 0x7d, 0xd5, 0x8b, 0x47, 0xd3, 0xa3, 0xf4, 0xa6, 0x75, 0x8c,
	0xa1, 0xde, 0x37, 0xbe, 0x87, 0xb5, 0x66, 0xdf, 0x6c, 0x3d, 0x2a, 0x2e, 0xc5, 0xdd, 0xb4, 0x6d,
	0x81, 0xdb, 0xa2, 0xb0, 0xc0, 0x4d, 0xeb, 0x04, 0xfb, 0xb7, 0x66, 0x21, 0x7d, 0xa4, 0xf7, 0x47,
	0x78, 0x2f, 0x95, 0x49, 0xc9, 0xe9, 0xbd, 0x54, 0x66, 0x56, 0xce, 0xec, 0xa5, 0x32, 0x59, 0x19,
	0xf6, 0x52, 0x19, 0x90, 0x73, 0xca, 0x35, 0xc8, 0x05, 0xfc, 0x14, 0x2a, 0xc2, 0xec, 0x00, 0x3b,
	0x8e, 0xde, 0xc5, 0xcc, 0xaf, 0x65, 0x55, 0xb7, 0xa9, 0xcc, 0x41, 0x3e, 0xe8, 0x9a, 0x94, 0x4f,
	0x24, 0xc8, 0x05, 0x9c, 0x0e, 0x95, 0x3c, 0xc2, 0x36, 0x33, 0x88, 0x90, 0x14, 0x4d, 0x74, 0x05,
	0x0a, 0x6c, 0x2f, 0x9a, 0x3b, 0x4e, 0x7d, 0x5f, 0x4a, 0xcd, 0xb3, 0xce, 0x43, 0x01, 0x5a, 0x83,
	0x9c, 0x75, 0xdb, 0xf2, 0x20, 0x49, 0x06, 0x01, 0xeb, 0xb6, 0xe5, 0x02, 0x2e, 0x43, 0x9e, 0x6e,
	0xdd, 0x43, 0xa4, 0xd8, 0x24, 0x39, 0xda, 0x27, 0x20, 0xca, 0x1f, 0x13, 0x20, 0x4f, 0x3a, 0x33,
	0xf4, 0x2a, 0xa4, 0xa8, 0x17, 0x17, 0x6e, 0x7a, 0x65, 0x83, 0xbb, 0xf8, 0x0d, 0xd7, 0xc5, 0x6f,
	0x34, 0x5c, 0x17, 0xbf, 0x95, 0xf9, 0xf4, 0xf3, 0xb5, 0x73, 0x9f, 0xfc, 0x65, 0x4d, 0x52, 0x99,
	0x04, 0xba, 0x48, 0x3d, 0x98, 0x6e, 0x0c, 0x35, 0xa3, 0xcd, 0x96, 0x9c, 0xa5, 0xde, 0x49, 0x37,
	0x86, 0xbb, 0x6d, 0x74, 0x0f, 0xe4, 0x96, 0x39, 0x74, 0xf0, 0xd0, 0x19, 0x39, 0x1a, 0x8f, 0x3d,
	0xc2, 0x35, 0x07, 0xfc, 0x2b, 0x0f, 0x72, 0xcc, 0x51, 0x09, 0x68, 0x8d, 0x21, 0xd5, 0xf9, 0x56,
	0xb8, 0x03, 0xbd, 0x0d, 0xe0, 0x05, 0x28, 0xa7, 0x98, 0x5a, 0x4f, 0x5e, 0xcf, 0xdd, 0xbe, 0x1c,
	0x71, 0x9f, 0x5c, 0xcc, 0x7d, 0xab, 0xad, 0x13, 0xbc, 0x95, 0xa2, 0x0b, 0x56, 0x03, 0xa2, 0xe8,
	0x59, 0x98, 0xd7, 0x2d, 0x4b, 0x73, 0x88, 0x4e, 0xb0, 0xd6, 0x3c, 0x26, 0xd8, 0x61, 0x6e, 0x3f,
	0xaf, 0x16, 0x74, 0xcb, 0xaa, 0xd3, 0xde, 0x2d, 0xda, 0x89, 0xae, 0xc2, 0x1c, 0xf5, 0xf0, 0x86,
	0xde, 0xd7, 0x7a, 0xd8, 0xe8, 0xf6, 0x08, 0xf3, 0xee, 0x49, 0xb5, 0x20, 0x7a, 0x77, 0x58, 0xa7,
	0xd2, 0x86, 0x7c, 0xd0, 0xb9, 0x23, 0x04, 0xa9, 0xb6, 0x4e, 0x74, 0x66, 0xcb, 0xbc, 0xca, 0x7e,
	0xd3, 0x3e, 0x4b, 0x27, 0x3d, 0x61, 0x21, 0xf6, 0x1b, 0x9d, 0x87, 0x19, 0xa1, 0x36, 0xc9, 0xd4,
	0x8a, 0x16, 0x5a, 0x82, 0xb4, 0x65, 0x9b, 0x47, 0x98, 0x1d, 0x5e, 0x46, 0xe5, 0x0d, 0xe5, 0x01,
	0xcc, 0x85, 0xe3, 0x00, 0x9a, 0x83, 0x04, 0x19, 0x8b, 0x59, 0x12, 0x64, 0x8c, 0x6e, 0x41, 0x8a,
	0x1a, 0x93, 0x69, 0x9b, 0x8b, 0x8a, 0x7e, 0x42, 0xbe, 0x71, 0x6c, 0x61, 0x95, 0x41, 0xf7, 0x52,
	0x99, 0x84, 0x9c, 0x54, 0xe6, 0xa1, 0x10, 0x8a, 0x12, 0xca, 0x79, 0x58, 0x8a, 0xf2, 0xf9, 0x8a,
	0x01, 0x4b, 0x51, 0xae, 0x1b, 0xbd, 0x0c, 0x19, 0xcf, 0xe9, 0xbb, 0x37, 0x68, 0x6a, 0x76, 0x4f,
	0xc8, 0xc3, 0xd2, 0xbb, 0x43, 0x0f, 0xa2, 0xa7, 0x8b, 0x50, 0x9f, 0x57, 0x67, 0x75, 0xcb, 0xda,
	0xd1, 0x9d, 0x9e, 0xf2, 0x1e, 0x14, 0xe3, 0xfc, 0x79, 0xc0, 0x70, 0x12, 0x7b, 0x00, 0xae, 0xe1,
	0xce, 0xc3, 0x4c, 0xc7, 0xb4, 0x07, 0x3a, 0x61, 0xca, 0x0a, 0xaa, 0x68, 0x51, 0x83, 0x72, 0xdf,
	0x9e, 0x64, 0xdd, 0xbc, 0xa1, 0x68, 0x70, 0x31, 0xd6, 0xa5, 0x53, 0x11, 0x63, 0xd8, 0xc6, 0xdc,
	0xbc, 0x05, 0x95, 0x37, 0x7c, 0x45, 0x7c, 0xb1, 0xbc, 0x41, 0xa7, 0x75, 0xf0, 0xb0, 0x8d, 0x6d,
	0xa6, 0x3f, 0xab, 0x8a, 0x96, 0xf2, 0xb3, 0x24, 0x9c, 0x8f, 0xf6, 0xeb, 0x68, 0x1d, 0xf2, 0x03,
	0x7d, 0xac, 0x91, 0xb1, 0xb8, 0x7e, 0x12, 0xbb, 0x00, 0x30, 0xd0, 0xc7, 0x8d, 0x31, 0xbf, 0x7b,
	0x32, 0x24, 0xc9, 0xd8, 0x29, 0x26, 0xd6, 0x93, 0xd7, 0xf3, 0x2a, 0xfd, 0x89, 0x0e, 0x61, 0xa1,
	0x6f, 0xb6, 0xf4, 0xbe, 0xd6, 0xd7, 0x1d, 0xa2, 0x89, 0xb0, 0xcf, 0x9f, 0xd3, 0x33, 0x71, 0x7e,
	0x1a, 0xb7, 0xf9, 0xc1, 0x52, 0x17, 0x24, 0x1e, 0xc2, 0x3c, 0x53, 0xb2, 0xaf, 0x3b, 0x84, 0x0f,
	0xa1, 0x0a, 0xe4, 0x06, 0x86, 0xd3, 0xc4, 0x3d, 0xfd, 0xc8, 0x30, 0x6d, 0xf1, 0xae, 0x22, 0x6e,
	0xcf, 0x3d, 0x1f, 0x24, 0x54, 0x05, 0xe5, 0x02, 0x87, 0x92, 0x0e, 0xdd, 0x66, 0xd7, 0xb3, 0xcc,
	0x3c, 0xb6, 0x67, 0xf9, 0x1f, 0x58, 0x1a, 0xe2, 0x31, 0xd1, 0xfc, 0x97, 0xcb, 0x6f, 0xca, 0x2c,
	0x33, 0x3e, 0xa2, 0x63, 0xde, 0x5b, 0x77, 0xe8, 0xa5, 0x41, 0xcf, 0xb1, 0xd8, 0x68, 0x99, 0x0e,
	0xb6, 0x35, 0xbd, 0xdd, 0xb6, 0xb1, 0xe3, 0xb0, 0xac, 0x2a, 0xcf, 0xe2, 0x1d, 0xeb, 0x2f, 0xf1,
	0x6e, 0xe5, 0x63, 0x76, 0x38, 0x51, 0xd1, 0xd1, 0x35, 0xbd, 0xe4, 0x9b, 0xbe, 0x01, 0x4b, 0x42,
	0xbe, 0x1d, 0xb2, 0x3e, 0x4f, 0x4f, 0x2f, 0xc5, 0x25, 0x5d, 0x01, 0xab, 0x23, 0x57, 0x3e, 0xde,
	0xf0, 0xc9, 0x27, 0x34, 0x3c, 0x82, 0x14, 0x33, 0x4b, 0x8a, 0xbb, 0x1b, 0xfa, 0xfb, 0xdf, 0xed,
	0x30, 0x3e, 0x4a, 0xc2, 0xc2, 0x54, 0x62, 0xe1, 0x6d, 0x4c, 0x8a, 0xdc, 0x58, 0x22, 0x72, 0x63,
	0xc9, 0xc7, 0xde, 0x98, 0x38, 0xed, 0xd4, 0xe9, 0xa7, 0x9d, 0xfe, 0x26, 0x4f, 0x7b, 0xe6, 0x09,
	0x4f, 0xfb, 0x5f, 0x7a, 0x0e, 0x3f, 0x97, 0x60, 0x25, 0x3e, 0x1d, 0x8b, 0x3c, 0x90, 0x9b, 0xb0,
	0xe0, 0x2d, 0xc5, 0x53, 0xcf, 0xdd, 0xa3, 0xec, 0x0d, 0x08, 0xfd, 0xb1, 0x11, 0xef, 0x2a, 0xcc,
	0x4d, 0x64, 0x8b, 0xfc, 0x32, 0x17, 0x8e, 0x82, 0xcb, 0x50, 0x7e, 0x97, 0x84, 0xa5, 0xa8, 0x84,
	0x2e, 0xe2, 0xc5, 0xaa, 0xb0, 0xd8, 0xc6, 0x2d, 0xa3, 0xfd, 0xc4, 0x0f, 0x76, 0x41, 0x88, 0xff,
	0xf7, 0xbd, 0x4e, 0xdf, 0x13, 0x74, 0x03, 0x16, 0x9c, 0xe3, 0x61, 0xcb, 0x18, 0x76, 0x35, 0x62,
	0xba, 0xb9, 0x51, 0x96, 0xad, 0x7c, 0x5e, 0x0c, 0x34, 0x4c, 0x91, 0x1d, 0xfd, 0x1a, 0x20, 0xa3,
	0x62, 0xc7, 0xa2, 0xc9, 0x1c, 0x2a, 0x43, 0x16, 0x8f, 0x5b, 0xd8, 0x22, 0x6e, 0x02, 0x1c, 0x53,
	0x63, 0x08, 0x88, 0x2b, 0x47, 0x6b, 0x6d, 0x4f, 0x0e, 0xbd, 0x24, 0x28, 0x85, 0x58, 0x72, 0x80,
	0xa7, 0xea, 0x9e, 0x28, 0xe7, 0x14, 0x5e, 0x71, 0x39, 0x85, 0x64, 0x5c, 0xa5, 0x2c, 0x12, 0x77,
	0x4f, 0x4e, 0x90, 0x0a, 0x2f, 0x09, 0x52, 0x21, 0x15, 0x37, 0x1d, 0xcf, 0xef, 0xfd, 0xe9, 0x18,
	0xab, 0x70, 0x27, 0xc4, 0x2a, 0xcc, 0xc4, 0x6d, 0x35, 0x90, 0x88, 0xfb, 0x5b, 0xf5, 0x69, 0x85,
	0x57, 0x5c, 0x5a, 0x61, 0x36, 0x6e, 0xd1, 0x22, 0xf3, 0xf4, 0x17, 0xcd, 0x79, 0x85, 0x37, 0x03,
	0xbc, 0x42, 0x96, 0xc9, 0x5e, 0x3e, 0x81, 0x57, 0xf0, 0xa4, 0x3d, 0x62, 0xe1, 0xff, 0x3c, 0x62,
	0x21, 0x1f, 0xcb, 0x4a, 0x88, 0x94, 0xd1, 0x13, 0x76, 0x99, 0x85, 0xda, 0x14, 0xb3, 0xc0, 0x89,
	0x80, 0x6b, 0xa7, 0x32, 0x0b, 0x9e, 0xaa, 0x09, 0x6a, 0xa1, 0x36, 0x45, 0x2d, 0xcc, 0xc5, 0x69,
	0x9c, 0xc8, 0x4f, 0x7d, 0x8d, 0x61, 0x6e, 0xe1, 0x3b, 0xd1, 0xdc, 0x42, 0x6c, 0xf1, 0x1f, 0x91,
	0x8b, 0x7a, 0xaa, 0x23, 0xc8, 0x85, 0xf7, 0x62, 0xc8, 0x05, 0x39, 0xae, 0x08, 0x8e, 0xca, 0x44,
	0xbd, 0x09, 0xa2, 0xd8, 0x85, 0xc3, 0x08, 0x76, 0x81, 0xd3, 0x00, 0xcf, 0x9d, 0x81, 0x5d, 0xf0,
	0x54, 0x4f, 0xd1, 0x0b, 0x87, 0x11, 0xf4, 0x02, 0x8a, 0xd7, 0x3b, 0x91, 0x40, 0x05, 0xf5, 0x86,
	0xf9, 0x85, 0xb7, 0xc3, 0xfc, 0xc2, 0xe2, 0xc9, 0x79, 0x2b, 0x4f, 0x03, 0x3c, 0x6d, 0x41, 0x82,
	0xa1, 0x15, 0x47, 0x30, 0x70, 0x0e, 0xe0, 0x85, 0x33, 0x12, 0x0c, 0x9e, 0xee, 0x48, 0x86, 0xa1,
	0x36, 0xc5, 0x30, 0x2c, 0xc7, 0x5d, 0xb8, 0x89, 0x80, 0xe4, 0x5f, 0xb8, 0x58, 0x8a, 0x21, 0x2d,
	0xcf, 0xec, 0xa5, 0x32, 0x19, 0x39, 0xcb, 0xc9, 0x85, 0xbd, 0x54, 0x26, 0x27, 0xe7, 0x95, 0xe7,
	0x68, 0x0a, 0x34, 0xe1, 0xf7, 0x68, 0xc1, 0x81, 0x6d, 0xdb, 0xb4, 0x05, 0x59, 0xc0, 0x1b, 0xca,
	0x75, 0xc8, 0x07, 0x5d, 0xdc, 0x09, 0x74, 0xc4, 0x3c, 0x14, 0x42, 0x5e, 0x4d, 0xf9, 0xbd, 0x04,
	0xf9, 0xa0, 0xbf, 0x0a, 0x15, 0xab, 0x59, 0x51, 0xac, 0x06, 0x48, 0x8a, 0x44, 0x98, 0xa4, 0x58,
	0x83, 0x1c, 0x2d, 0xd8, 0x26, 0xf8, 0x07, 0xdd, 0xf2, 0xf8, 0x87, 0x1b, 0xb0, 0xc0, 0xe2, 0x2d,
	0xa7, 0x32, 0x44, 0x64, 0x48, 0xf1, 0xc8, 0x40, 0x07, 0x98, 0x31, 0x78, 0x64, 0x40, 0x2f, 0xc0,
	0x62, 0x00, 0xeb, 0x15, 0x82, 0xbc, 0x14, 0x97, 0x3d, 0x74, 0x49, 0x54, 0x84, 0x7f, 0x90, 0x60,
	0x61, 0xca, 0x5d, 0x46, 0x72, 0x0c, 0xd2, 0x37, 0xc5, 0x31, 0x24, 0x9e, 0x9c, 0x63, 0x08, 0x96,
	0xb6, 0xc9, 0x70, 0x69, 0xfb, 0x0f, 0x09, 0x0a, 0x21, 0xb7, 0x4d, 0x0f, 0xa1, 0x65, 0xb6, 0xb1,
	0x28, 0x36, 0xd9, 0x6f, 0x9a, 0xd3, 0xf4, 0xcd, 0xae, 0x28, 0x29, 0xe9, 0x4f, 0x8a, 0xf2, 0x02,
	0x51, 0x56, 0x84, 0x19, 0xaf, 0x4e, 0xe5, 0x79, 0x83, 0xa8, 0x53, 0x65, 0x48, 0x3e, 0xc2, 0x9c,
	0x8b, 0xce, 0xab, 0xf4, 0x27, 0xc5, 0xb1, 0xeb, 0x27, 0xe2, 0x3f, 0x6f, 0xa0, 0xd7, 0x20, 0xcb,
	0xbe, 0x18, 0x68, 0xa6, 0xe5, 0x08, 0xfa, 0x39, 0x90, 0x1b, 0xf1, 0xcf, 0x0a, 0xe2, 0x9d, 0x9b,
	0x9d, 0xaa, 0xe5, 0xa8, 0x19, 0x4b, 0xfc, 0x0a, 0x64, 0x2c, 0xd9, 0x50, 0xc6, 0x72, 0x09, 0xb2,
	0x74, 0xf9, 0x8e, 0xa5, 0xb7, 0x70, 0x11, 0xd8, 0x4a, 0xfd, 0x0e, 0xe5, 0x37, 0x09, 0x98, 0x9f,
	0x88, 0x3a, 0x91, 0x9b, 0x77, 0x6f, 0x65, 0x22, 0x40, 0xa1, 0x9c, 0xcd, 0x20, 0xab, 0x00, 0x5d,
	0xdd, 0xd1, 0x3e, 0xd4, 0x87, 0x04, 0xb7, 0x85, 0x55, 0x02, 0x3d, 0x68, 0x05, 0x32, 0xb4, 0x35,
	0x72, 0x70, 0x5b, 0xb0, 0x39, 0x5e, 0x1b, 0xed, 0xc2, 0x0c, 0x3e, 0xc2, 0x43, 0xe2, 0x14, 0x67,
	0xd9, 0xc1, 0x5f, 0x88, 0x70, 0x4f, 0x74, 0x7c, 0xab, 0x48, 0x8f, 0xfb, 0x6f, 0x9f, 0xaf, 0xc9,
	0x1c, 0xfe, 0xbc, 0x39, 0x30, 0x08, 0x1e, 0x58, 0xe4, 0x58, 0x15, 0x0a, 0xc2, 0x66, 0xc8, 0x4c,
	0x98, 0x81, 0x51, 0x8b, 0x79, 0x97, 0x27, 0xa0, 0x46, 0x35, 0x4c, 0xdb, 0x20, 0xc7, 0x6a, 0x61,
	0x80, 0x07, 0x96, 0x69, 0xf6, 0x35, 0xfe, 0xce, 0x4b, 0x30, 0x17, 0x0e, 0xb2, 0xe8, 0x0a, 0x14,
	0x6c, 0x4c, 0x74, 0x63, 0xa8, 0x85, 0xf2, 0xe8, 0x3c, 0xef, 0xe4, 0xef, 0x6a, 0x2f, 0x95, 0x91,
	0xe4, 0x84, 0xa0, 0x76, 0xde, 0x81, 0xe5, 0xc8, 0x18, 0x8b, 0x5e, 0x85, 0xac, 0x1f, 0x9f, 0x25,
	0xb6, 0xdd, 0x93, 0x38, 0x1b, 0x1f, 0xac, 0x1c, 0xc2, 0x72, 0x64, 0x90, 0x45, 0x6f, 0xc0, 0x8c,
	0x8d, 0x9d, 0x51, 0x9f, 0xd3, 0x32, 0x73, 0xb7, 0xaf, 0x9e, 0x1e, 0x9d, 0x47, 0x7d, 0xa2, 0x0a,
	0x21, 0xe5, 0x16, 0x5c, 0x8c, 0x8d, 0xb2, 0x3e, 0xf3, 0x22, 0x05, 0x98, 0x17, 0xe5, 0xb7, 0x12,
	0xac, 0xc4, 0x47, 0x4e, 0xb4, 0x35, 0xb1, 0xa0, 0x1b, 0x67, 0x8c, 0xbb, 0x81, 0x55, 0xd1, 0xd2,
	0xc4, 0xc6, 0x1d, 0x4c, 0x5a, 0x3d, 0x1e, 0xc2, 0xb9, 0x53, 0x28, 0xa8, 0x05, 0xd1, 0xcb, 0x64,
	0x1c, 0x0e, 0x7b, 0x1f, 0xb7, 0x88, 0xc6, 0x0f, 0xd5, 0x61, 0xe5, 0x41, 0x96, 0xc2, 0x68, 0x6f,
	0x9d, 0x77, 0x2a, 0x37, 0xe1, 0x42, 0x4c, 0x2c, 0x9e, 0xae, 0x61, 0x94, 0x87, 0x14, 0x1c, 0x19,
	0x60, 0xd1, 0x5b, 0x30, 0xe3, 0x10, 0x9d, 0x8c, 0x1c, 0xb1, 0xb3, 0x6b, 0xa7, 0xc6, 0xe6, 0x3a,
	0x83, 0xab, 0x42, 0x4c, 0x79, 0x1d, 0xd0, 0x74, 0xa4, 0x8d, 0xa8, 0xc3, 0xa4, 0xa8, 0x3a, 0xac,
	0x09, 0x4f, 0x9d, 0x10, 0x53, 0x51, 0x79, 0x62, 0x71, 0x37, 0xcf, 0x14, 0x92, 0x27, 0x16, 0xf8,
	0xf7, 0x04, 0x2c, 0x47, 0x86, 0xd6, 0xc0, 0x2b, 0x95, 0xbe, 0xee, 0x2b, 0x7d, 0x03, 0x80, 0x8c,
	0x35, 0x7e, 0xd2, 0xae, 0xb7, 0x8f, 0xaa, 0x27, 0xc6, 0xb8, 0xc5, 0x1c, 0x16, 0xbd, 0x18, 0x59,
	0x22, 0x7e, 0x39, 0xa8, 0x11, 0xac, 0x7d, 0x47, 0x2c, 0x12, 0x38, 0xa2, 0x2c, 0x3c, 0x73, 0xcc,
	0xf0, 0x8b, 0x64, 0xde, 0xed, 0xa0, 0x87, 0x70, 0x61, 0x22, 0xa2, 0x79, 0xba, 0x53, 0x67, 0x0e,
	0x6c, 0xcb, 0xe1, 0xc0, 0xe6, 0xea, 0x0e, 0x46, 0xa5, 0x74, 0x38, 0x2a, 0x3d, 0x04, 0xf0, 0x8b,
	0x60, 0xfa, 0xde, 0x6c, 0x73, 0x34, 0x6c, 0xb3, 0x23, 0x4c, 0xab, 0xbc, 0x81, 0x5e, 0x86, 0x34,
	0xbd, 0x09, 0xae, 0xa9, 0x22, 0x1c, 0x06, 0x3d, 0xd2, 0x40, 0x15, 0xcd, 0xe1, 0xca, 0xfb, 0xee,
	0x6d, 0x0b, 0xf2, 0x91, 0x31, 0x73, 0xbc, 0x19, 0x9e, 0x43, 0x89, 0xa7, 0x36, 0xa3, 0xe7, 0xfa,
	0x3e, 0xa4, 0xd9, 0xf1, 0xd3, 0xe8, 0xc0, 0xe8, 0x70, 0x91, 0xd9, 0xd0, 0xdf, 0xe8, 0xbb, 0x00,
	0x3a, 0x21, 0xb6, 0xd1, 0x1c, 0xf9, 0x33, 0xac, 0xc7, 0xdc, 0x9f, 0x92, 0x0b, 0xdc, 0xba, 0x24,
	0x2e, 0xd2, 0x92, 0x2f, 0x1b, 0xb8, 0x4c, 0x01, 0x8d, 0xca, 0x01, 0xcc, 0x85, 0x65, 0xdd, 0x50,
	0xcc, 0x17, 0x11, 0x0e, 0xc5, 0x3c, 0xb7, 0x12, 0xa1, 0xd8, 0x0b, 0xe4, 0x49, 0x4e, 0xfa, 0xb3,
	0x86, 0xf2, 0x83, 0x04, 0xe4, 0x83, 0xb7, 0xef, 0x3f, 0x30, 0x58, 0x2a, 0x3f, 0x96, 0x20, 0xe3,
	0xed, 0x3f, 0x4c, 0xfd, 0x87, 0xbe, 0x99, 0x70, 0xf3, 0x25, 0x82, 0x7c, 0x3d, 0xff, 0x42, 0x92,
	0xf4, 0xbe, 0x90, 0xfc, 0xbf, 0x17, 0x10, 0x62, 0x8b, 0xf9, 0xa0, 0xb5, 0xc5, 0xc5, 0x72, 0x03,
	0xd4, 0xeb, 0x90, 0xf5, 0xde, 0x30, 0xcd, 0x91, 0x5d, 0x92, 0x44, 0x12, 0x0f, 0x49, 0x90, 0x23,
	0x4b, 0x90, 0xb6, 0xcc, 0x0f, 0xc5, 0xd7, 0x80, 0xa4, 0xca, 0x1b, 0x8a, 0x03, 0xf3, 0x13, 0x0e,
	0xc0, 0x07, 0x26, 0x02, 0x40, 0xa4, 0x40, 0xc1, 0x1a, 0x35, 0xb5, 0x47, 0xf8, 0x58, 0x7c, 0x1b,
	0xe0, 0xcb, 0xcf, 0x59, 0xa3, 0xe6, 0x5d, 0x7c, 0xcc, 0x3f, 0x0e, 0xac, 0x43, 0xde, 0xc5, 0xb0,
	0x2b, 0xce, 0xcf, 0x14, 0x38, 0xa4, 0xc1, 0x3f, 0xec, 0x48, 0x72, 0x42, 0xf9, 0xa9, 0x04, 0x19,
	0xf7, 0x95, 0xa0, 0xb7, 0x20, 0xeb, 0xf9, 0x1a, 0x91, 0x22, 0x3f, 0x75, 0x82, 0x97, 0x12, 0x9b,
	0xf7, 0x65, 0xd0, 0x96, 0xfb, 0x85, 0xd2, 0x68, 0x6b, 0x9d, 0xbe, 0xde, 0x15, 0x1f, 0x9a, 0x56,
	0x23, 0xdc, 0x11, 0xf3, 0xd8, 0xbb, 0x77, 0xb6, 0xfb, 0x7a, 0x57, 0xcd, 0x31, 0xa1, 0xdd, 0x36,
	0x6d, 0x88, 0xac, 0xe4, 0x2b, 0x09, 0xe4, 0xc9, 0x57, 0xfc, 0xf5, 0xd7, 0x37, 0x1d, 0xbd, 0x92,
	0x11, 0xd1, 0x0b, 0x6d, 0xc2, 0xa2, 0x87, 0xd0, 0x1c, 0xa3, 0x3b, 0xd4, 0xc9, 0xc8, 0xc6, 0x82,
	0x8e, 0x43, 0xde, 0x50, 0xdd, 0x1d, 0x99, 0xde, 0x77, 0xfa, 0x49, 0xf7, 0xfd, 0x51, 0x02, 0x72,
	0x01, 0x76, 0x10, 0xfd, 0x6f, 0xc0, 0x45, 0xcd, 0x45, 0xc5, 0x8c, 0x00, 0xd8, 0xff, 0x6a, 0x17,
	0xb6, 0x54, 0xe2, 0x09, 0x2c, 0x15, 0xc7, 0xc3, 0xba, 0x74, 0x63, 0xea, 0xb1, 0xe9, 0xc6, 0xe7,
	0x01, 0x11, 0x93, 0xe8, 0x7d, 0x5a, 0x94, 0x1b, 0xc3, 0xae, 0xc6, 0x2f, 0x36, 0xf7, 0x28, 0x32,
	0x1b, 0x39, 0x64, 0x03, 0x35, 0xf6, 0x18, 0x7e, 0x28, 0x41, 0xc6, 0xa3, 0x62, 0x1e, 0xf7, 0x6b,
	0xde, 0x79, 0x98, 0x11, 0x99, 0x18, 0xff, 0x9c, 0x27, 0x5a, 0x91, 0xbc, 0xea, 0x0a, 0x64, 0x06,
	0x98, 0xe8, 0xcc, 0x3d, 0xf2, 0x78, 0xe7, 0xb5, 0x6f, 0x34, 0x21, 0x17, 0xf8, 0x20, 0x8a, 0x2e,
	0xc2, 0x72, 0x79, 0xa7, 0x52, 0xbe, 0xab, 0x35, 0xde, 0xd5, 0x1a, 0x0f, 0x6a, 0x15, 0xed, 0xfe,
	0xc1, 0xdd, 0x83, 0xea, 0xb7, 0x0e, 0xe4, 0x73, 0xd3, 0x43, 0x6a, 0x85, 0xb5, 0x65, 0x09, 0x5d,
	0x80, 0xc5, 0xf0, 0x10, 0x1f, 0x48, 0xac, 0xa4, 0x7e, 0xf2, 0xab, 0xd5, 0x73, 0x37, 0xbe, 0x92,
	0x60, 0x31, 0x22, 0xe7, 0x45, 0x97, 0xe1, 0xe9, 0xea, 0xf6, 0x76, 0x45, 0xd5, 0xea, 0x07, 0xa5,
	0x5a, 0x7d, 0xa7, 0xda, 0xd0, 0xd4, 0x4a, 0xfd, 0xfe, 0x7e, 0x23, 0x30, 0xe9, 0x3a, 0x5c, 0x8a,
	0x86, 0x94, 0xca, 0xe5, 0x4a, 0xad, 0x21, 0x4b, 0x68, 0x0d, 0x9e, 0x8a, 0x41, 0x6c, 0x55, 0xd5,
	0x86, 0x9c, 0x88, 0x57, 0xa1, 0x56, 0xf6, 0x2a, 0xe5, 0x86, 0x9c, 0x44, 0xd7, 0xe0, 0xca, 0x49,
	0x08, 0x6d, 0xbb, 0xaa, 0xde, 0x2b, 0x35, 0xe4, 0xd4, 0xa9, 0xc0, 0x7a, 0xe5, 0xe0, 0x4e, 0x45,
	0x95, 0xd3, 0x62, 0xdf, 0xbf, 0x4c, 0x40, 0x31, 0x2e, 0xb5, 0xa6, 0xba, 0x4a, 0xb5, 0xda, 0xfe,
	0x03, 0x5f, 0x57, 0x79, 0xe7, 0xfe, 0xc1, 0xdd, 0x69, 0x13, 0x3c, 0x0b, 0xca, 0x49, 0x40, 0xcf,
	0x10, 0x57, 0xe1, 0xf2, 0x89, 0x38, 0x61, 0x8e, 0x53, 0x60, 0x6a, 0xa5, 0xa1, 0x3e, 0x90, 0x93,
	0x68, 0x03, 0x6e, 0x9c, 0x0a, 0xf3, 0xc6, 0xe4, 0x14, 0xda, 0x84, 0x9b, 0x27, 0xe3, 0xb9, 0x81,
	0x5c, 0x01, 0xd7, 0x44, 0x1f, 0x4b, 0xb0, 0x1c, 0x99, 0xa3, 0xa3, 0x2b, 0xb0, 0x56, 0x53, 0xab,
	0xe5, 0x4a, 0xbd, 0xae, 0xd5, 0xd4, 0x6a, 0xad, 0x5a, 0x2f, 0xed, 0x6b, 0xf5, 0x46, 0xa9, 0x71,
	0xbf, 0x1e, 0xb0, 0x8d, 0x02, 0xab, 0x71, 0x20, 0xcf, 0x2e, 0x27, 0x60, 0xc4, 0x0d, 0x70, 0xef,
	0xe9, 0x2f, 0x24, 0xb8, 0x18, 0x9b, 0x93, 0xa3, 0xeb, 0xf0, 0xcc, 0x61, 0x45, 0xdd, 0xdd, 0x7e,
	0xa0, 0x1d, 0x56, 0x1b, 0x15, 0xad, 0xf2, 0x6e, 0xa3, 0x72, 0x50, 0xdf, 0xad, 0x1e, 0x4c, 0xaf,
	0xea, 0x1a, 0x5c, 0x39, 0x11, 0xe9, 0x2d, 0xed, 0x34, 0xe0, 0xc4, 0xfa, 0x7e, 0x24, 0xc1, 0xfc,
	0x84, 0x2f, 0x44, 0x97, 0xa0, 0x78, 0x6f, 0xb7, 0xbe, 0x55, 0xd9, 0x29, 0x1d, 0xee, 0x56, 0xd5,
	0xc9, 0x37, 0x7b, 0x05, 0xd6, 0xa6, 0x46, 0xef, 0xdc, 0xaf, 0xed, 0xef, 0x96, 0x4b, 0x8d, 0x0a,
	0x9b, 0x54, 0x96, 0xe8, 0xc6, 0xa6, 0x40, 0xfb, 0xbb, 0x6f, 0xef, 0x34, 0xb4, 0xf2, 0xfe, 0x6e,
	0xe5, 0xa0, 0xa1, 0x95, 0x1a, 0x8d, 0x92, 0xff, 0x9c, 0xb7, 0xee, 0x7e, 0xfa, 0xc5, 0xaa, 0xf4,
	0xd9, 0x17, 0xab, 0xd2, 0x5f, 0xbf, 0x58, 0x95, 0x3e, 0xf9, 0x72, 0xf5, 0xdc, 0x67, 0x5f, 0xae,
	0x9e, 0xfb, 0xf3, 0x97, 0xab, 0xe7, 0x1e, 0xde, 0xea, 0x1a, 0xa4, 0x37, 0x6a, 0x52, 0x2f, 0xbc,
	0xe9, 0xff, 0x2f, 0xd3, 0xfb, 0x43, 0xa7, 0x65, 0x6c, 0x4e, 0xfe, 0xbb, 0xb3, 0x39, 0xc3, 0xdc,
	0xea, 0x8b, 0xff, 0x0c, 0x00, 0x00, 0xff, 0xff, 0x7c, 0xee, 0x5e, 0x4c, 0xf8, 0x29, 0x00, 0x00,
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Request_Echo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_Echo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Echo != nil {
		{
			size, err := m.Echo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Request_Flush) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_Flush) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Flush != nil {
		{
			size, err := m.Flush.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Request_Info) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_Info) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Request_InitChain) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_InitChain) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.InitChain != nil {
		{
			size, err := m.InitChain.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Request_Query) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_Query) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Request_CheckTx) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_CheckTx) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.CheckTx != nil {
		{
			size, err := m.CheckTx.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Request_Commit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_Commit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Commit != nil {
		{
			size, err := m.Commit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Request_ListSnapshots) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_ListSnapshots) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ListSnapshots != nil {
		{
			size, err := m.ListSnapshots.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *Request_OfferSnapshot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_OfferSnapshot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OfferSnapshot != nil {
		{
			size, err := m.OfferSnapshot.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	return len(dAtA) - i, nil
}
func (m *Request_LoadSnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_LoadSnapshotChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LoadSnapshotChunk != nil {
		{
			size, err := m.LoadSnapshotChunk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *Request_ApplySnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_ApplySnapshotChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ApplySnapshotChunk != nil {
		{
			size, err := m.ApplySnapshotChunk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	return len(dAtA) - i, nil
}
func (m *Request_PrepareProposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_PrepareProposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.PrepareProposal != nil {
		{
			size, err := m.PrepareProposal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *Request_ProcessProposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_ProcessProposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ProcessProposal != nil {
		{
			size, err := m.ProcessProposal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	return len(dAtA) - i, nil
}
func (m *Request_ExtendVote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_ExtendVote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExtendVote != nil {
		{
			size, err := m.ExtendVote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	return len(dAtA) - i, nil
}
func (m *Request_VerifyVoteExtension) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_VerifyVoteExtension) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.VerifyVoteExtension != nil {
		{
			size, err := m.VerifyVoteExtension.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	return len(dAtA) - i, nil
}
func (m *Request_FinalizeBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Request_FinalizeBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.FinalizeBlock != nil {
		{
			size, err := m.FinalizeBlock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	return len(dAtA) - i, nil
}
func (m *EchoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EchoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EchoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FlushRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlushRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlushRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AbciVersion) > 0 {
		i -= len(m.AbciVersion)
		copy(dAtA[i:], m.AbciVersion)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AbciVersion)))
		i--
		dAtA[i] = 0x22
	}
	if m.P2PVersion != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.P2PVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.BlockVersion != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.BlockVersion))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InitChainRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitChainRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InitChainRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitialHeight != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.InitialHeight))
		i--
		dAtA[i] = 0x30
	}
	if len(m.AppStateBytes) > 0 {
		i -= len(m.AppStateBytes)
		copy(dAtA[i:], m.AppStateBytes)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AppStateBytes)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Validators) > 0 {
		for iNdEx := len(m.Validators) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Validators[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ConsensusParams != nil {
		{
			size, err := m.ConsensusParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ChainId) > 0 {
		i -= len(m.ChainId)
		copy(dAtA[i:], m.ChainId)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ChainId)))
		i--
		dAtA[i] = 0x12
	}
	n18, err18 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err18 != nil {
		return 0, err18
	}
	i -= n18
	i = encodeVarintTypes(dAtA, i, uint64(n18))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *QueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Prove {
		i--
		if m.Prove {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckTxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckTxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckTxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Tx) > 0 {
		i -= len(m.Tx)
		copy(dAtA[i:], m.Tx)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Tx)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ListSnapshotsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSnapshotsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSnapshotsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *OfferSnapshotRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OfferSnapshotRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OfferSnapshotRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AppHash) > 0 {
		i -= len(m.AppHash)
		copy(dAtA[i:], m.AppHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AppHash)))
		i--
		dAtA[i] = 0x12
	}
	if m.Snapshot != nil {
		{
			size, err := m.Snapshot.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LoadSnapshotChunkRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadSnapshotChunkRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadSnapshotChunkRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Chunk != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Chunk))
		i--
		dAtA[i] = 0x18
	}
	if m.Format != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Format))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ApplySnapshotChunkRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplySnapshotChunkRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplySnapshotChunkRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Sender) > 0 {
		i -= len(m.Sender)
		copy(dAtA[i:], m.Sender)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Sender)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Chunk) > 0 {
		i -= len(m.Chunk)
		copy(dAtA[i:], m.Chunk)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Chunk)))
		i--
		dAtA[i] = 0x12
	}
	if m.Index != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PrepareProposalRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrepareProposalRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrepareProposalRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ProposerAddress) > 0 {
		i -= len(m.ProposerAddress)
		copy(dAtA[i:], m.ProposerAddress)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProposerAddress)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.NextValidatorsHash) > 0 {
		i -= len(m.NextValidatorsHash)
		copy(dAtA[i:], m.NextValidatorsHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.NextValidatorsHash)))
		i--
		dAtA[i] = 0x3a
	}
	n20, err20 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err20 != nil {
		return 0, err20
	}
	i -= n20
	i = encodeVarintTypes(dAtA, i, uint64(n20))
	i--
	dAtA[i] = 0x32
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Misbehavior) > 0 {
		for iNdEx := len(m.Misbehavior) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Misbehavior[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	{
		size, err := m.LocalLastCommit.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if len(m.Txs) > 0 {
		for iNdEx := len(m.Txs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Txs[iNdEx])
			copy(dAtA[i:], m.Txs[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Txs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.MaxTxBytes != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.MaxTxBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcessProposalRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessProposalRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessProposalRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ProposerAddress) > 0 {
		i -= len(m.ProposerAddress)
		copy(dAtA[i:], m.ProposerAddress)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProposerAddress)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.NextValidatorsHash) > 0 {
		i -= len(m.NextValidatorsHash)
		copy(dAtA[i:], m.NextValidatorsHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.NextValidatorsHash)))
		i--
		dAtA[i] = 0x3a
	}
	n22, err22 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err22 != nil {
		return 0, err22
	}
	i -= n22
	i = encodeVarintTypes(dAtA, i, uint64(n22))
	i--
	dAtA[i] = 0x32
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Misbehavior) > 0 {
		for iNdEx := len(m.Misbehavior) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Misbehavior[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	{
		size, err := m.ProposedLastCommit.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if len(m.Txs) > 0 {
		for iNdEx := len(m.Txs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Txs[iNdEx])
			copy(dAtA[i:], m.Txs[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Txs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExtendVoteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExtendVoteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExtendVoteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ProposerAddress) > 0 {
		i -= len(m.ProposerAddress)
		copy(dAtA[i:], m.ProposerAddress)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProposerAddress)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.NextValidatorsHash) > 0 {
		i -= len(m.NextValidatorsHash)
		copy(dAtA[i:], m.NextValidatorsHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.NextValidatorsHash)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Misbehavior) > 0 {
		for iNdEx := len(m.Misbehavior) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Misbehavior[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	{
		size, err := m.ProposedLastCommit.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	if len(m.Txs) > 0 {
		for iNdEx := len(m.Txs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Txs[iNdEx])
			copy(dAtA[i:], m.Txs[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Txs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	n25, err25 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err25 != nil {
		return 0, err25
	}
	i -= n25
	i = encodeVarintTypes(dAtA, i, uint64(n25))
	i--
	dAtA[i] = 0x1a
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerifyVoteExtensionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerifyVoteExtensionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerifyVoteExtensionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VoteExtension) > 0 {
		i -= len(m.VoteExtension)
		copy(dAtA[i:], m.VoteExtension)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.VoteExtension)))
		i--
		dAtA[i] = 0x22
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ValidatorAddress) > 0 {
		i -= len(m.ValidatorAddress)
		copy(dAtA[i:], m.ValidatorAddress)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ValidatorAddress)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FinalizeBlockRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FinalizeBlockRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FinalizeBlockRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SyncingToHeight != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.SyncingToHeight))
		i--
		dAtA[i] = 0x48
	}
	if len(m.ProposerAddress) > 0 {
		i -= len(m.ProposerAddress)
		copy(dAtA[i:], m.ProposerAddress)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProposerAddress)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.NextValidatorsHash) > 0 {
		i -= len(m.NextValidatorsHash)
		copy(dAtA[i:], m.NextValidatorsHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.NextValidatorsHash)))
		i--
		dAtA[i] = 0x3a
	}
	n26, err26 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err26 != nil {
		return 0, err26
	}
	i -= n26
	i = encodeVarintTypes(dAtA, i, uint64(n26))
	i--
	dAtA[i] = 0x32
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Misbehavior) > 0 {
		for iNdEx := len(m.Misbehavior) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Misbehavior[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	{
		size, err := m.DecidedLastCommit.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if len(m.Txs) > 0 {
		for iNdEx := len(m.Txs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Txs[iNdEx])
			copy(dAtA[i:], m.Txs[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Txs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Response_Exception) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Exception) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Exception != nil {
		{
			size, err := m.Exception.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Response_Echo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Echo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Echo != nil {
		{
			size, err := m.Echo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Response_Flush) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Flush) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Flush != nil {
		{
			size, err := m.Flush.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Response_Info) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Info) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Response_InitChain) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_InitChain) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.InitChain != nil {
		{
			size, err := m.InitChain.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Response_Query) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Query) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Response_CheckTx) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_CheckTx) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.CheckTx != nil {
		{
			size, err := m.CheckTx.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Response_Commit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_Commit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Commit != nil {
		{
			size, err := m.Commit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *Response_ListSnapshots) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_ListSnapshots) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ListSnapshots != nil {
		{
			size, err := m.ListSnapshots.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	return len(dAtA) - i, nil
}
func (m *Response_OfferSnapshot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_OfferSnapshot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.OfferSnapshot != nil {
		{
			size, err := m.OfferSnapshot.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	return len(dAtA) - i, nil
}
func (m *Response_LoadSnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_LoadSnapshotChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.LoadSnapshotChunk != nil {
		{
			size, err := m.LoadSnapshotChunk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	return len(dAtA) - i, nil
}
func (m *Response_ApplySnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_ApplySnapshotChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ApplySnapshotChunk != nil {
		{
			size, err := m.ApplySnapshotChunk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	return len(dAtA) - i, nil
}
func (m *Response_PrepareProposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_PrepareProposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.PrepareProposal != nil {
		{
			size, err := m.PrepareProposal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	return len(dAtA) - i, nil
}
func (m *Response_ProcessProposal) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_ProcessProposal) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ProcessProposal != nil {
		{
			size, err := m.ProcessProposal.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	return len(dAtA) - i, nil
}
func (m *Response_ExtendVote) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_ExtendVote) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExtendVote != nil {
		{
			size, err := m.ExtendVote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	return len(dAtA) - i, nil
}
func (m *Response_VerifyVoteExtension) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_VerifyVoteExtension) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.VerifyVoteExtension != nil {
		{
			size, err := m.VerifyVoteExtension.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	return len(dAtA) - i, nil
}
func (m *Response_FinalizeBlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Response_FinalizeBlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.FinalizeBlock != nil {
		{
			size, err := m.FinalizeBlock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}
func (m *ExceptionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExceptionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExceptionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EchoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EchoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EchoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FlushResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlushResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlushResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LastBlockAppHash) > 0 {
		i -= len(m.LastBlockAppHash)
		copy(dAtA[i:], m.LastBlockAppHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.LastBlockAppHash)))
		i--
		dAtA[i] = 0x2a
	}
	if m.LastBlockHeight != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.LastBlockHeight))
		i--
		dAtA[i] = 0x20
	}
	if m.AppVersion != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.AppVersion))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InitChainResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitChainResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InitChainResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AppHash) > 0 {
		i -= len(m.AppHash)
		copy(dAtA[i:], m.AppHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AppHash)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Validators) > 0 {
		for iNdEx := len(m.Validators) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Validators[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ConsensusParams != nil {
		{
			size, err := m.ConsensusParams.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Codespace) > 0 {
		i -= len(m.Codespace)
		copy(dAtA[i:], m.Codespace)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Codespace)))
		i--
		dAtA[i] = 0x52
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x48
	}
	if m.ProofOps != nil {
		{
			size, err := m.ProofOps.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x32
	}
	if m.Index != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Log) > 0 {
		i -= len(m.Log)
		copy(dAtA[i:], m.Log)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Log)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Code != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CheckTxResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckTxResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckTxResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Codespace) > 0 {
		i -= len(m.Codespace)
		copy(dAtA[i:], m.Codespace)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Codespace)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.GasUsed != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x30
	}
	if m.GasWanted != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.GasWanted))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Log) > 0 {
		i -= len(m.Log)
		copy(dAtA[i:], m.Log)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Log)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	if m.Code != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RetainHeight != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.RetainHeight))
		i--
		dAtA[i] = 0x18
	}
	return len(dAtA) - i, nil
}

func (m *ListSnapshotsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSnapshotsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSnapshotsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Snapshots) > 0 {
		for iNdEx := len(m.Snapshots) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Snapshots[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *OfferSnapshotResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OfferSnapshotResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OfferSnapshotResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Result))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LoadSnapshotChunkResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadSnapshotChunkResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadSnapshotChunkResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Chunk) > 0 {
		i -= len(m.Chunk)
		copy(dAtA[i:], m.Chunk)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Chunk)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplySnapshotChunkResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplySnapshotChunkResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplySnapshotChunkResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RejectSenders) > 0 {
		for iNdEx := len(m.RejectSenders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RejectSenders[iNdEx])
			copy(dAtA[i:], m.RejectSenders[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.RejectSenders[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.RefetchChunks) > 0 {
		dAtA48 := make([]byte, len(m.RefetchChunks)*10)
		var j47 int
		for _, num := range m.RefetchChunks {
			for num >= 1<<7 {
				dAtA48[j47] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j47++
			}
			dAtA48[j47] = uint8(num)
			j47++
		}
		i -= j47
		copy(dAtA[i:], dAtA48[:j47])
		i = encodeVarintTypes(dAtA, i, uint64(j47))
		i--
		dAtA[i] = 0x12
	}
	if m.Result != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Result))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PrepareProposalResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrepareProposalResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrepareProposalResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Txs) > 0 {
		for iNdEx := len(m.Txs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Txs[iNdEx])
			copy(dAtA[i:], m.Txs[iNdEx])
			i = encodeVarintTypes(dAtA, i, uint64(len(m.Txs[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessProposalResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessProposalResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessProposalResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExtendVoteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExtendVoteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExtendVoteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VoteExtension) > 0 {
		i -= len(m.VoteExtension)
		copy(dAtA[i:], m.VoteExtension)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.VoteExtension)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerifyVoteExtensionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerifyVoteExtensionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerifyVoteExtensionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *FinalizeBlockResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FinalizeBlockResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FinalizeBlockResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.AppHash) > 0 {
		i -= len(m.AppHash)
		copy(dAtA[i:], m.AppHash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AppHash)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ConsensusParamUpdates != nil {
		{
			size, err := m.ConsensusParamUpdates.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTypes(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ValidatorUpdates) > 0 {
		for iNdEx := len(m.ValidatorUpdates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ValidatorUpdates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.TxResults) > 0 {
		for iNdEx := len(m.TxResults) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TxResults[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CommitInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Votes) > 0 {
		for iNdEx := len(m.Votes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Votes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExtendedCommitInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExtendedCommitInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExtendedCommitInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Votes) > 0 {
		for iNdEx := len(m.Votes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Votes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Round != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Round))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventAttribute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventAttribute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventAttribute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Index {
		i--
		if m.Index {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecTxResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecTxResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecTxResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Codespace) > 0 {
		i -= len(m.Codespace)
		copy(dAtA[i:], m.Codespace)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Codespace)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTypes(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.GasUsed != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.GasUsed))
		i--
		dAtA[i] = 0x30
	}
	if m.GasWanted != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.GasWanted))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Log) > 0 {
		i -= len(m.Log)
		copy(dAtA[i:], m.Log)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Log)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	if m.Code != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TxResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if len(m.Tx) > 0 {
		i -= len(m.Tx)
		copy(dAtA[i:], m.Tx)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Tx)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Index != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Validator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Validator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Validator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Power != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Power))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ValidatorUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidatorUpdate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValidatorUpdate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PubKeyType) > 0 {
		i -= len(m.PubKeyType)
		copy(dAtA[i:], m.PubKeyType)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.PubKeyType)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.PubKeyBytes) > 0 {
		i -= len(m.PubKeyBytes)
		copy(dAtA[i:], m.PubKeyBytes)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.PubKeyBytes)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Power != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Power))
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *VoteInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VoteInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VoteInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BlockIdFlag != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.BlockIdFlag))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Validator.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ExtendedVoteInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExtendedVoteInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExtendedVoteInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BlockIdFlag != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.BlockIdFlag))
		i--
		dAtA[i] = 0x28
	}
	if len(m.ExtensionSignature) > 0 {
		i -= len(m.ExtensionSignature)
		copy(dAtA[i:], m.ExtensionSignature)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ExtensionSignature)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.VoteExtension) > 0 {
		i -= len(m.VoteExtension)
		copy(dAtA[i:], m.VoteExtension)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.VoteExtension)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.Validator.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Misbehavior) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Misbehavior) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Misbehavior) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TotalVotingPower != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.TotalVotingPower))
		i--
		dAtA[i] = 0x28
	}
	n53, err53 := github_com_cosmos_gogoproto_types.StdTimeMarshalTo(m.Time, dAtA[i-github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time):])
	if err53 != nil {
		return 0, err53
	}
	i -= n53
	i = encodeVarintTypes(dAtA, i, uint64(n53))
	i--
	dAtA[i] = 0x22
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Validator.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTypes(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if m.Type != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Snapshot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Snapshot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Snapshot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		i -= len(m.Metadata)
		copy(dAtA[i:], m.Metadata)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Metadata)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0x22
	}
	if m.Chunks != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Chunks))
		i--
		dAtA[i] = 0x18
	}
	if m.Format != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Format))
		i--
		dAtA[i] = 0x10
	}
	if m.Height != 0 {
		i = encodeVarintTypes(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	offset -= sovTypes(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Request_Echo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Echo != nil {
		l = m.Echo.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_Flush) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Flush != nil {
		l = m.Flush.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_Info) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_InitChain) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitChain != nil {
		l = m.InitChain.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_Query) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_CheckTx) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckTx != nil {
		l = m.CheckTx.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_Commit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Commit != nil {
		l = m.Commit.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_ListSnapshots) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListSnapshots != nil {
		l = m.ListSnapshots.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_OfferSnapshot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OfferSnapshot != nil {
		l = m.OfferSnapshot.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_LoadSnapshotChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LoadSnapshotChunk != nil {
		l = m.LoadSnapshotChunk.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_ApplySnapshotChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ApplySnapshotChunk != nil {
		l = m.ApplySnapshotChunk.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_PrepareProposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PrepareProposal != nil {
		l = m.PrepareProposal.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_ProcessProposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProcessProposal != nil {
		l = m.ProcessProposal.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_ExtendVote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExtendVote != nil {
		l = m.ExtendVote.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_VerifyVoteExtension) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VerifyVoteExtension != nil {
		l = m.VerifyVoteExtension.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Request_FinalizeBlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FinalizeBlock != nil {
		l = m.FinalizeBlock.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *EchoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *FlushRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.BlockVersion != 0 {
		n += 1 + sovTypes(uint64(m.BlockVersion))
	}
	if m.P2PVersion != 0 {
		n += 1 + sovTypes(uint64(m.P2PVersion))
	}
	l = len(m.AbciVersion)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *InitChainRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.ChainId)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ConsensusParams != nil {
		l = m.ConsensusParams.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Validators) > 0 {
		for _, e := range m.Validators {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.AppStateBytes)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.InitialHeight != 0 {
		n += 1 + sovTypes(uint64(m.InitialHeight))
	}
	return n
}

func (m *QueryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Prove {
		n += 2
	}
	return n
}

func (m *CheckTxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Tx)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	return n
}

func (m *CommitRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ListSnapshotsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *OfferSnapshotRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Snapshot != nil {
		l = m.Snapshot.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.AppHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *LoadSnapshotChunkRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Format != 0 {
		n += 1 + sovTypes(uint64(m.Format))
	}
	if m.Chunk != 0 {
		n += 1 + sovTypes(uint64(m.Chunk))
	}
	return n
}

func (m *ApplySnapshotChunkRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	l = len(m.Chunk)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Sender)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *PrepareProposalRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxTxBytes != 0 {
		n += 1 + sovTypes(uint64(m.MaxTxBytes))
	}
	if len(m.Txs) > 0 {
		for _, b := range m.Txs {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.LocalLastCommit.Size()
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Misbehavior) > 0 {
		for _, e := range m.Misbehavior {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.NextValidatorsHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProposerAddress)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ProcessProposalRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Txs) > 0 {
		for _, b := range m.Txs {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.ProposedLastCommit.Size()
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Misbehavior) > 0 {
		for _, e := range m.Misbehavior {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.NextValidatorsHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProposerAddress)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ExtendVoteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Txs) > 0 {
		for _, b := range m.Txs {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.ProposedLastCommit.Size()
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Misbehavior) > 0 {
		for _, e := range m.Misbehavior {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.NextValidatorsHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProposerAddress)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *VerifyVoteExtensionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ValidatorAddress)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = len(m.VoteExtension)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *FinalizeBlockRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Txs) > 0 {
		for _, b := range m.Txs {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.DecidedLastCommit.Size()
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Misbehavior) > 0 {
		for _, e := range m.Misbehavior {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.NextValidatorsHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProposerAddress)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.SyncingToHeight != 0 {
		n += 1 + sovTypes(uint64(m.SyncingToHeight))
	}
	return n
}

func (m *Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Response_Exception) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Exception != nil {
		l = m.Exception.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_Echo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Echo != nil {
		l = m.Echo.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_Flush) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Flush != nil {
		l = m.Flush.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_Info) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_InitChain) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitChain != nil {
		l = m.InitChain.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_Query) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_CheckTx) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckTx != nil {
		l = m.CheckTx.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_Commit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Commit != nil {
		l = m.Commit.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_ListSnapshots) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListSnapshots != nil {
		l = m.ListSnapshots.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_OfferSnapshot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OfferSnapshot != nil {
		l = m.OfferSnapshot.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_LoadSnapshotChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LoadSnapshotChunk != nil {
		l = m.LoadSnapshotChunk.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_ApplySnapshotChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ApplySnapshotChunk != nil {
		l = m.ApplySnapshotChunk.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_PrepareProposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PrepareProposal != nil {
		l = m.PrepareProposal.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_ProcessProposal) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProcessProposal != nil {
		l = m.ProcessProposal.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_ExtendVote) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExtendVote != nil {
		l = m.ExtendVote.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_VerifyVoteExtension) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.VerifyVoteExtension != nil {
		l = m.VerifyVoteExtension.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *Response_FinalizeBlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FinalizeBlock != nil {
		l = m.FinalizeBlock.Size()
		n += 2 + l + sovTypes(uint64(l))
	}
	return n
}
func (m *ExceptionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *EchoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *FlushResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.AppVersion != 0 {
		n += 1 + sovTypes(uint64(m.AppVersion))
	}
	if m.LastBlockHeight != 0 {
		n += 1 + sovTypes(uint64(m.LastBlockHeight))
	}
	l = len(m.LastBlockAppHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *InitChainResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsensusParams != nil {
		l = m.ConsensusParams.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Validators) > 0 {
		for _, e := range m.Validators {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.AppHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *QueryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovTypes(uint64(m.Code))
	}
	l = len(m.Log)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ProofOps != nil {
		l = m.ProofOps.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = len(m.Codespace)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *CheckTxResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovTypes(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Log)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.GasWanted != 0 {
		n += 1 + sovTypes(uint64(m.GasWanted))
	}
	if m.GasUsed != 0 {
		n += 1 + sovTypes(uint64(m.GasUsed))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Codespace)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *CommitResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RetainHeight != 0 {
		n += 1 + sovTypes(uint64(m.RetainHeight))
	}
	return n
}

func (m *ListSnapshotsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Snapshots) > 0 {
		for _, e := range m.Snapshots {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *OfferSnapshotResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != 0 {
		n += 1 + sovTypes(uint64(m.Result))
	}
	return n
}

func (m *LoadSnapshotChunkResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Chunk)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *ApplySnapshotChunkResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != 0 {
		n += 1 + sovTypes(uint64(m.Result))
	}
	if len(m.RefetchChunks) > 0 {
		l = 0
		for _, e := range m.RefetchChunks {
			l += sovTypes(uint64(e))
		}
		n += 1 + sovTypes(uint64(l)) + l
	}
	if len(m.RejectSenders) > 0 {
		for _, s := range m.RejectSenders {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *PrepareProposalResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Txs) > 0 {
		for _, b := range m.Txs {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *ProcessProposalResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovTypes(uint64(m.Status))
	}
	return n
}

func (m *ExtendVoteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.VoteExtension)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *VerifyVoteExtensionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovTypes(uint64(m.Status))
	}
	return n
}

func (m *FinalizeBlockResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.TxResults) > 0 {
		for _, e := range m.TxResults {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.ValidatorUpdates) > 0 {
		for _, e := range m.ValidatorUpdates {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.ConsensusParamUpdates != nil {
		l = m.ConsensusParamUpdates.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.AppHash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *CommitInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if len(m.Votes) > 0 {
		for _, e := range m.Votes {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *ExtendedCommitInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Round != 0 {
		n += 1 + sovTypes(uint64(m.Round))
	}
	if len(m.Votes) > 0 {
		for _, e := range m.Votes {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *EventAttribute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Index {
		n += 2
	}
	return n
}

func (m *ExecTxResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovTypes(uint64(m.Code))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Log)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.GasWanted != 0 {
		n += 1 + sovTypes(uint64(m.GasWanted))
	}
	if m.GasUsed != 0 {
		n += 1 + sovTypes(uint64(m.GasUsed))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Codespace)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *TxResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	l = len(m.Tx)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Result.Size()
	n += 1 + l + sovTypes(uint64(l))
	return n
}

func (m *Validator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Power != 0 {
		n += 1 + sovTypes(uint64(m.Power))
	}
	return n
}

func (m *ValidatorUpdate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Power != 0 {
		n += 1 + sovTypes(uint64(m.Power))
	}
	l = len(m.PubKeyBytes)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.PubKeyType)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *VoteInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Validator.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.BlockIdFlag != 0 {
		n += 1 + sovTypes(uint64(m.BlockIdFlag))
	}
	return n
}

func (m *ExtendedVoteInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Validator.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.VoteExtension)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ExtensionSignature)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.BlockIdFlag != 0 {
		n += 1 + sovTypes(uint64(m.BlockIdFlag))
	}
	return n
}

func (m *Misbehavior) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = m.Validator.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	l = github_com_cosmos_gogoproto_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	if m.TotalVotingPower != 0 {
		n += 1 + sovTypes(uint64(m.TotalVotingPower))
	}
	return n
}

func (m *Snapshot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Height != 0 {
		n += 1 + sovTypes(uint64(m.Height))
	}
	if m.Format != 0 {
		n += 1 + sovTypes(uint64(m.Format))
	}
	if m.Chunks != 0 {
		n += 1 + sovTypes(uint64(m.Chunks))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Metadata)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func sovTypes(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Echo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EchoRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_Echo{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flush", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FlushRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_Flush{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InfoRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_Info{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitChainRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_InitChain{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_Query{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckTx", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckTxRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_CheckTx{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CommitRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_Commit{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListSnapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ListSnapshotsRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_ListSnapshots{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferSnapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OfferSnapshotRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_OfferSnapshot{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadSnapshotChunk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadSnapshotChunkRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_LoadSnapshotChunk{v}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplySnapshotChunk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ApplySnapshotChunkRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_ApplySnapshotChunk{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrepareProposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PrepareProposalRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_PrepareProposal{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessProposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProcessProposalRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_ProcessProposal{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendVote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExtendVoteRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_ExtendVote{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyVoteExtension", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VerifyVoteExtensionRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_VerifyVoteExtension{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinalizeBlock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FinalizeBlockRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Request_FinalizeBlock{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EchoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EchoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EchoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlushRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlushRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlushRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockVersion", wireType)
			}
			m.BlockVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field P2PVersion", wireType)
			}
			m.P2PVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.P2PVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AbciVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AbciVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitChainRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitChainRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitChainRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChainId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChainId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsensusParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsensusParams == nil {
				m.ConsensusParams = &v1.ConsensusParams{}
			}
			if err := m.ConsensusParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validators", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Validators = append(m.Validators, ValidatorUpdate{})
			if err := m.Validators[len(m.Validators)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppStateBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppStateBytes = append(m.AppStateBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.AppStateBytes == nil {
				m.AppStateBytes = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialHeight", wireType)
			}
			m.InitialHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitialHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prove", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Prove = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckTxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckTxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckTxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tx", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tx = append(m.Tx[:0], dAtA[iNdEx:postIndex]...)
			if m.Tx == nil {
				m.Tx = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= CheckTxType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSnapshotsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSnapshotsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSnapshotsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OfferSnapshotRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OfferSnapshotRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OfferSnapshotRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Snapshot == nil {
				m.Snapshot = &Snapshot{}
			}
			if err := m.Snapshot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppHash = append(m.AppHash[:0], dAtA[iNdEx:postIndex]...)
			if m.AppHash == nil {
				m.AppHash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadSnapshotChunkRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadSnapshotChunkRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadSnapshotChunkRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			m.Format = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Format |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			m.Chunk = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Chunk |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplySnapshotChunkRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplySnapshotChunkRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplySnapshotChunkRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunk = append(m.Chunk[:0], dAtA[iNdEx:postIndex]...)
			if m.Chunk == nil {
				m.Chunk = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sender", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sender = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrepareProposalRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrepareProposalRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrepareProposalRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTxBytes", wireType)
			}
			m.MaxTxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTxBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Txs = append(m.Txs, make([]byte, postIndex-iNdEx))
			copy(m.Txs[len(m.Txs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalLastCommit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LocalLastCommit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Misbehavior", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Misbehavior = append(m.Misbehavior, Misbehavior{})
			if err := m.Misbehavior[len(m.Misbehavior)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextValidatorsHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextValidatorsHash = append(m.NextValidatorsHash[:0], dAtA[iNdEx:postIndex]...)
			if m.NextValidatorsHash == nil {
				m.NextValidatorsHash = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerAddress", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProposerAddress = append(m.ProposerAddress[:0], dAtA[iNdEx:postIndex]...)
			if m.ProposerAddress == nil {
				m.ProposerAddress = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessProposalRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessProposalRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessProposalRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Txs = append(m.Txs, make([]byte, postIndex-iNdEx))
			copy(m.Txs[len(m.Txs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposedLastCommit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposedLastCommit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Misbehavior", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Misbehavior = append(m.Misbehavior, Misbehavior{})
			if err := m.Misbehavior[len(m.Misbehavior)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], dAtA[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextValidatorsHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextValidatorsHash = append(m.NextValidatorsHash[:0], dAtA[iNdEx:postIndex]...)
			if m.NextValidatorsHash == nil {
				m.NextValidatorsHash = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerAddress", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProposerAddress = append(m.ProposerAddress[:0], dAtA[iNdEx:postIndex]...)
			if m.ProposerAddress == nil {
				m.ProposerAddress = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExtendVoteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtendVoteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtendVoteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], dAtA[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Txs = append(m.Txs, make([]byte, postIndex-iNdEx))
			copy(m.Txs[len(m.Txs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposedLastCommit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposedLastCommit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Misbehavior", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Misbehavior = append(m.Misbehavior, Misbehavior{})
			if err := m.Misbehavior[len(m.Misbehavior)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextValidatorsHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextValidatorsHash = append(m.NextValidatorsHash[:0], dAtA[iNdEx:postIndex]...)
			if m.NextValidatorsHash == nil {
				m.NextValidatorsHash = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerAddress", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProposerAddress = append(m.ProposerAddress[:0], dAtA[iNdEx:postIndex]...)
			if m.ProposerAddress == nil {
				m.ProposerAddress = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VerifyVoteExtensionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VerifyVoteExtensionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VerifyVoteExtensionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], dAtA[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidatorAddress", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidatorAddress = append(m.ValidatorAddress[:0], dAtA[iNdEx:postIndex]...)
			if m.ValidatorAddress == nil {
				m.ValidatorAddress = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteExtension", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VoteExtension = append(m.VoteExtension[:0], dAtA[iNdEx:postIndex]...)
			if m.VoteExtension == nil {
				m.VoteExtension = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FinalizeBlockRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FinalizeBlockRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FinalizeBlockRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Txs = append(m.Txs, make([]byte, postIndex-iNdEx))
			copy(m.Txs[len(m.Txs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecidedLastCommit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DecidedLastCommit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Misbehavior", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Misbehavior = append(m.Misbehavior, Misbehavior{})
			if err := m.Misbehavior[len(m.Misbehavior)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], dAtA[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextValidatorsHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextValidatorsHash = append(m.NextValidatorsHash[:0], dAtA[iNdEx:postIndex]...)
			if m.NextValidatorsHash == nil {
				m.NextValidatorsHash = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerAddress", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProposerAddress = append(m.ProposerAddress[:0], dAtA[iNdEx:postIndex]...)
			if m.ProposerAddress == nil {
				m.ProposerAddress = []byte{}
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncingToHeight", wireType)
			}
			m.SyncingToHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SyncingToHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exception", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExceptionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Exception{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Echo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EchoResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Echo{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flush", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FlushResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Flush{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InfoResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Info{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitChainResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_InitChain{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Query{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckTx", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckTxResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_CheckTx{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CommitResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_Commit{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListSnapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ListSnapshotsResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_ListSnapshots{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OfferSnapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OfferSnapshotResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_OfferSnapshot{v}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadSnapshotChunk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadSnapshotChunkResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_LoadSnapshotChunk{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplySnapshotChunk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ApplySnapshotChunkResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_ApplySnapshotChunk{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrepareProposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PrepareProposalResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_PrepareProposal{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessProposal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProcessProposalResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_ProcessProposal{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendVote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExtendVoteResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_ExtendVote{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyVoteExtension", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VerifyVoteExtensionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_VerifyVoteExtension{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinalizeBlock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FinalizeBlockResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Response_FinalizeBlock{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExceptionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExceptionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExceptionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EchoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EchoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EchoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlushResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlushResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlushResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppVersion", wireType)
			}
			m.AppVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AppVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBlockHeight", wireType)
			}
			m.LastBlockHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastBlockHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBlockAppHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastBlockAppHash = append(m.LastBlockAppHash[:0], dAtA[iNdEx:postIndex]...)
			if m.LastBlockAppHash == nil {
				m.LastBlockAppHash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitChainResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitChainResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitChainResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsensusParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsensusParams == nil {
				m.ConsensusParams = &v1.ConsensusParams{}
			}
			if err := m.ConsensusParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validators", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Validators = append(m.Validators, ValidatorUpdate{})
			if err := m.Validators[len(m.Validators)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppHash = append(m.AppHash[:0], dAtA[iNdEx:postIndex]...)
			if m.AppHash == nil {
				m.AppHash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Log = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProofOps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProofOps == nil {
				m.ProofOps = &v11.ProofOps{}
			}
			if err := m.ProofOps.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Codespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Codespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckTxResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckTxResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckTxResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Log = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasWanted", wireType)
			}
			m.GasWanted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasWanted |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Codespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Codespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetainHeight", wireType)
			}
			m.RetainHeight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetainHeight |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSnapshotsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSnapshotsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSnapshotsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Snapshots = append(m.Snapshots, &Snapshot{})
			if err := m.Snapshots[len(m.Snapshots)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OfferSnapshotResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OfferSnapshotResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OfferSnapshotResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			m.Result = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Result |= OfferSnapshotResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadSnapshotChunkResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadSnapshotChunkResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadSnapshotChunkResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunk = append(m.Chunk[:0], dAtA[iNdEx:postIndex]...)
			if m.Chunk == nil {
				m.Chunk = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplySnapshotChunkResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplySnapshotChunkResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplySnapshotChunkResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			m.Result = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Result |= ApplySnapshotChunkResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RefetchChunks = append(m.RefetchChunks, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthTypes
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthTypes
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.RefetchChunks) == 0 {
					m.RefetchChunks = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RefetchChunks = append(m.RefetchChunks, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RefetchChunks", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectSenders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RejectSenders = append(m.RejectSenders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrepareProposalResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrepareProposalResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrepareProposalResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txs", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Txs = append(m.Txs, make([]byte, postIndex-iNdEx))
			copy(m.Txs[len(m.Txs)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessProposalResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessProposalResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessProposalResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= ProcessProposalStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExtendVoteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtendVoteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtendVoteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteExtension", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VoteExtension = append(m.VoteExtension[:0], dAtA[iNdEx:postIndex]...)
			if m.VoteExtension == nil {
				m.VoteExtension = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VerifyVoteExtensionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VerifyVoteExtensionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VerifyVoteExtensionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= VerifyVoteExtensionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FinalizeBlockResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FinalizeBlockResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FinalizeBlockResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxResults", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxResults = append(m.TxResults, &ExecTxResult{})
			if err := m.TxResults[len(m.TxResults)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidatorUpdates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidatorUpdates = append(m.ValidatorUpdates, ValidatorUpdate{})
			if err := m.ValidatorUpdates[len(m.ValidatorUpdates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsensusParamUpdates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsensusParamUpdates == nil {
				m.ConsensusParamUpdates = &v1.ConsensusParams{}
			}
			if err := m.ConsensusParamUpdates.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppHash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppHash = append(m.AppHash[:0], dAtA[iNdEx:postIndex]...)
			if m.AppHash == nil {
				m.AppHash = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Votes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Votes = append(m.Votes, VoteInfo{})
			if err := m.Votes[len(m.Votes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExtendedCommitInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtendedCommitInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtendedCommitInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Round", wireType)
			}
			m.Round = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Round |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Votes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Votes = append(m.Votes, ExtendedVoteInfo{})
			if err := m.Votes[len(m.Votes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, EventAttribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventAttribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventAttribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventAttribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Index = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecTxResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecTxResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecTxResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Log = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasWanted", wireType)
			}
			m.GasWanted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasWanted |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GasUsed", wireType)
			}
			m.GasUsed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GasUsed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Codespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Codespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tx", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tx = append(m.Tx[:0], dAtA[iNdEx:postIndex]...)
			if m.Tx == nil {
				m.Tx = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Validator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Validator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Validator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = append(m.Address[:0], dAtA[iNdEx:postIndex]...)
			if m.Address == nil {
				m.Address = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Power", wireType)
			}
			m.Power = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Power |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidatorUpdate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidatorUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidatorUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Power", wireType)
			}
			m.Power = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Power |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PubKeyBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PubKeyBytes = append(m.PubKeyBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.PubKeyBytes == nil {
				m.PubKeyBytes = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PubKeyType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PubKeyType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VoteInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VoteInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VoteInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Validator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockIdFlag", wireType)
			}
			m.BlockIdFlag = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockIdFlag |= v1.BlockIDFlag(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExtendedVoteInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtendedVoteInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtendedVoteInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Validator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VoteExtension", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VoteExtension = append(m.VoteExtension[:0], dAtA[iNdEx:postIndex]...)
			if m.VoteExtension == nil {
				m.VoteExtension = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtensionSignature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtensionSignature = append(m.ExtensionSignature[:0], dAtA[iNdEx:postIndex]...)
			if m.ExtensionSignature == nil {
				m.ExtensionSignature = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockIdFlag", wireType)
			}
			m.BlockIdFlag = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockIdFlag |= v1.BlockIDFlag(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Misbehavior) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Misbehavior: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Misbehavior: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= MisbehaviorType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Validator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_cosmos_gogoproto_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalVotingPower", wireType)
			}
			m.TotalVotingPower = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalVotingPower |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Snapshot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Snapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Snapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			m.Format = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Format |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunks", wireType)
			}
			m.Chunks = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Chunks |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = append(m.Hash[:0], dAtA[iNdEx:postIndex]...)
			if m.Hash == nil {
				m.Hash = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTypes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata[:0], dAtA[iNdEx:postIndex]...)
			if m.Metadata == nil {
				m.Metadata = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTypes
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTypes
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTypes        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTypes = fmt.Errorf("proto: unexpected end of group")
)
