Project: /_project.yaml
Book: /_book.yaml

# Getting Started with Bazel

This page contains resources that help you get started with Bazel, including
installation steps and container information. It also provides links to
tutorials and migration guides.

If you have not already done so, first read the [Bazel Overview](/start/bazel-intro).

## Installation {:#installation}

To install Bazel, see [Installing Bazel](/install).
If you use Windows, please read also [Using Bazel on Windows](/install/windows).

You might also want to [integrate Bazel with your IDE](/install/ide).

## Bazel container {:#bazel-container}

To try out Bazel inside a
[Docker](https://www.docker.com/){: .external} container, check out
our public Ubuntu Linux (16.04) based Bazel container in
[Google Cloud Marketplace](https://console.cloud.google.com/marketplace/details/google/bazel){: .external}.

To get started with the Bazel container, check out
[Getting started with Bazel Docker Container](/docs/bazel-container).

## Tutorials {:#tutorials}

To get hands-on with Bazel and understand its core concepts, complete a
tutorial:

*   [Tutorial: Build a C++ Project](/tutorials/cpp)

*   [Tutorial: Build a Java Project](/tutorials/java)

*   [Tutorial: Build an Android Application](/tutorials/android-app)

*   [Tutorial: Build an iOS Application](/tutorials/ios-app)

If you are unsure of how Workspace, Packages, Targets and Rules relate to each
other, see [Workspaces, packages, and targets](/concepts/build-ref).

Once you are familiar with the basics, you can try the rules for
[other languages](/rules).

## Migration {:#migration}

To learn how to migrate your project to Bazel, see the appropriate migration
guide:

*   [Migrating from Maven to Bazel](/migrate/maven)

*   [Migrating from Xcode to Bazel](/migrate/xcode)

## Reference {:#reference}

To further explore Bazel, refer to the following resources:

*   [Bazel Concepts and Terminology](/concepts/)

*   [Bazel User Manual](/docs/user-manual)

*   [Rules](/rules) for many languages
