# [Bazel](https://bazel.build)

*{Fast, Correct} - Choose two*

Build and test software of any size, quickly and reliably.

* **Speed up your builds and tests**:
  Bazel rebuilds only what is necessary.
  With advanced local and distributed caching, optimized dependency analysis and
  parallel execution, you get fast and incremental builds.

* **One tool, multiple languages**: Build and test Java, C++, Android, iOS, Go,
  and a wide variety of other language platforms. Bazel runs on Windows, macOS,
  and Linux.

* **Scalable**: Bazel helps you scale your organization, codebase, and
  continuous integration solution. It handles codebases of any size, in multiple
  repositories or a huge monorepo.

* **Extensible to your needs**: Easily add support for new languages and
  platforms with Bazel's familiar extension language. Share and re-use language
  rules written by the growing Bazel community.

## Getting Started

  * [Install Bazel](https://bazel.build/install)
  * [Get started with Bazel](https://bazel.build/contribute/getting-started)
  * Follow our tutorials:

    - [Build C++](https://bazel.build/tutorials/cpp)
    - [Build Java](https://bazel.build/tutorials/java)
    - [Android](https://bazel.build/tutorials/android-app)
    - [iOS](https://bazel.build/tutorials/ios-app)

## Documentation

  * [Bazel command line](https://bazel.build/docs/user-manual)
  * [Rule reference](https://bazel.build/reference/be/overview)
  * [Use the query command](https://bazel.build/reference/query)
  * [Extend Bazel](https://bazel.build/rules/concepts)
  * [Write tests](https://bazel.build/reference/test-encyclopedia)
  * [Roadmap](https://bazel.build/community/roadmaps)
  * [Who is using Bazel?](https://github.com/bazelbuild/bazel/wiki/Bazel-Users)

## Reporting a Vulnerability

To report a security issue, please email security@bazel.build with a description
of the issue, the steps you took to create the issue, affected versions, and, if
known, mitigations for the issue. Our vulnerability management team will respond
within 3 working days of your email. If the issue is confirmed as a
vulnerability, we will open a Security Advisory. This project follows a 90 day
disclosure timeline.

## Contributing to Bazel

See [CONTRIBUTING.md](CONTRIBUTING.md)

[![Build status](https://badge.buildkite.com/1fd282f8ad98c3fb10758a821e5313576356709dd7d11e9618.svg?status=master)](https://ci.bazel.build)
