/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class SortedSetNavigationTester<E>
extends AbstractSetTester<E> {
    private SortedSet<E> sortedSet;
    private List<E> values;
    private E a;
    private E b;
    private E c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sortedSet = (SortedSet)this.getSet();
        this.values = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.values, this.sortedSet.comparator());
        if (this.values.size() >= 1) {
            this.a = this.values.get(0);
            if (this.values.size() >= 3) {
                this.b = this.values.get(1);
                this.c = this.values.get(2);
            }
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetFirst() {
        try {
            this.sortedSet.first();
            SortedSetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetLast() {
        try {
            this.sortedSet.last();
            SortedSetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetFirst() {
        SortedSetNavigationTester.assertEquals(this.a, this.sortedSet.first());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetLast() {
        SortedSetNavigationTester.assertEquals(this.a, this.sortedSet.last());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        SortedSetNavigationTester.assertEquals(this.a, this.sortedSet.first());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        SortedSetNavigationTester.assertEquals(this.c, this.sortedSet.last());
    }
}

