/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.stream.Stream;

@BugPattern(name="SynchronizeOnNonFinalField", summary="Synchronizing on non-final fields is not safe: if the field is ever updated, different threads may end up locking on different objects.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class SynchronizeOnNonFinalField
extends BugChecker
implements BugChecker.SynchronizedTreeMatcher {
    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)ASTHelpers.stripParentheses((ExpressionTree)tree.getExpression()));
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
        if (ASTHelpers.isLocal((Symbol)varSymbol) || varSymbol.isStatic() || (varSymbol.flags() & 0x10L) != 0L) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)varSymbol, LazyInit.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Name ownerName = varSymbol.owner.enclClass().getQualifiedName();
        if (Stream.of("java.io.Writer", "java.io.Reader").anyMatch(ownerName::contentEquals)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree.getExpression());
    }
}

