/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Optional;

abstract class AbstractMethodReturnsNull
extends BugChecker
implements BugChecker.ReturnTreeMatcher {
    private final Matcher<MethodTree> methodTreeMatcher;

    AbstractMethodReturnsNull(Matcher<MethodTree> methodTreeMatcher) {
        this.methodTreeMatcher = methodTreeMatcher;
    }

    protected abstract Optional<Fix> provideFix(ReturnTree var1);

    public final Description matchReturn(ReturnTree tree, VisitorState state) {
        TreePath path;
        if (tree.getExpression() == null || tree.getExpression().getKind() != Tree.Kind.NULL_LITERAL) {
            return Description.NO_MATCH;
        }
        for (path = state.getPath(); path != null && path.getLeaf() instanceof StatementTree; path = path.getParentPath()) {
        }
        if (path == null || !(path.getLeaf() instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        if (!this.methodTreeMatcher.matches((Tree)((MethodTree)path.getLeaf()), state)) {
            return Description.NO_MATCH;
        }
        return this.provideFix(tree).map(fix -> this.describeMatch(tree, (Fix)fix)).orElseGet(() -> this.describeMatch(tree));
    }
}

