/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.stream.Collectors;

@BugPattern(name="WithSignatureDiscouraged", summary="withSignature is discouraged. Prefer .named and/or .withParameters where possible.", severity=BugPattern.SeverityLevel.WARNING)
public class WithSignatureDiscouraged
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> WITH_SIGNATURE = Matchers.instanceMethod().onExactClass("com.google.errorprone.matchers.method.MethodMatchers.MethodClassMatcher").named("withSignature").withParameters(new String[]{"java.lang.String"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!WITH_SIGNATURE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = tree.getArguments().get(0);
        String sig = (String)ASTHelpers.constValue((Tree)argument, String.class);
        if (sig == null) {
            return Description.NO_MATCH;
        }
        if (sig.contains("...") || sig.contains("<")) {
            return Description.NO_MATCH;
        }
        int firstParenIndex = sig.indexOf(40);
        if (firstParenIndex == -1) {
            return this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"named", (VisitorState)state));
        }
        if (!(tree instanceof JCTree)) {
            return Description.NO_MATCH;
        }
        String methodName = sig.substring(0, firstParenIndex);
        String paramList = sig.substring(firstParenIndex + 1, sig.length() - 1);
        return this.fixWithParameters((JCTree)((Object)tree), state, methodName, paramList);
    }

    private Description fixWithParameters(JCTree tree, VisitorState state, String methodName, String paramList) {
        ImmutableList paramTypes = ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)paramList));
        if (paramTypes.stream().anyMatch(type -> WithSignatureDiscouraged.isProbableTypeParameter(type) || WithSignatureDiscouraged.isArrayType(type))) {
            return Description.NO_MATCH;
        }
        int treeStart = tree.getStartPosition();
        String source = state.getSourceForNode((Tree)tree);
        if (source == null) {
            return Description.NO_MATCH;
        }
        int offset = source.indexOf(".withSignature");
        if (offset == -1) {
            return Description.NO_MATCH;
        }
        int startPosition = treeStart + offset;
        int endPosition = state.getEndPosition((Tree)tree);
        String withParameters = paramTypes.isEmpty() ? "withNoParameters()" : paramTypes.stream().map(type -> String.format("\"%s\"", type)).collect(Collectors.joining(", ", "withParameters(", ")"));
        String replacementText = String.format(".named(\"%s\").%s", methodName, withParameters);
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)startPosition, (int)endPosition, (String)replacementText));
    }

    private static boolean isArrayType(String type) {
        return type.contains("[");
    }

    private static boolean isProbableTypeParameter(String type) {
        return !type.contains(".") && !type.equals(Ascii.toLowerCase((String)type));
    }
}

