/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="IgnoredPureGetter", severity=BugPattern.SeverityLevel.WARNING, summary="Getters on AutoValue classes and protos are side-effect free, so there is no point in calling them if the return value is ignored. While there are no side effects from the getter, the receiver may have side effects.")
public final class IgnoredPureGetter
extends AbstractReturnValueIgnored {
    private static final String MESSAGE_LITE = "com.google.protobuf.MessageLite";
    private static final String MUTABLE_MESSAGE_LITE = "com.google.protobuf.MutableMessageLite";

    @Override
    protected Matcher<? super ExpressionTree> specializedMatcher() {
        return IgnoredPureGetter::isPureGetter;
    }

    @Override
    protected Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description.Builder builder = this.buildDescription(methodInvocationTree).addFix((Fix)SuggestedFix.builder().setShortDescription("Remove with any side effects from the receiver").delete((Tree)methodInvocationTree).build());
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        if (receiver instanceof MethodInvocationTree) {
            builder.addFix((Fix)SuggestedFix.builder().setShortDescription("Remove but keep side effects from the receiver").replace((Tree)methodInvocationTree, state.getSourceForNode((Tree)receiver)).build());
        }
        return builder.build();
    }

    private static boolean isPureGetter(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (!(symbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)"com.google.auto.value.AutoValue", (VisitorState)state) && symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)state.getTypeFromString(MESSAGE_LITE), (VisitorState)state) && !ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)state.getTypeFromString(MUTABLE_MESSAGE_LITE), (VisitorState)state)) {
            String name = symbol.getSimpleName().toString();
            return (name.startsWith("get") || name.startsWith("has")) && ((List)((Symbol.MethodSymbol)symbol).getParameters()).isEmpty();
        }
        return false;
    }
}

