/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="IdentityHashMapUsage", summary="IdentityHashMap usage shouldn't be intermingled with Map", severity=BugPattern.SeverityLevel.WARNING)
public class IdentityHashMapUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String IDENTITY_HASH_MAP = "java.util.IdentityHashMap";
    private static final Matcher<ExpressionTree> IHM_ONE_ARG_METHODS = MethodMatchers.instanceMethod().onExactClass("java.util.IdentityHashMap").namedAnyOf(new String[]{"equals", "putAll"});
    private static final Matcher<ExpressionTree> IHM_CTOR_MAP_ARG = MethodMatchers.constructor().forClass("java.util.IdentityHashMap").withParameters(new String[]{"java.util.Map"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IHM_ONE_ARG_METHODS.matches((Tree)tree, state) && !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getArguments().get(0)), (Type)state.getTypeFromString(IDENTITY_HASH_MAP), (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        Type ihmType = state.getTypeFromString(IDENTITY_HASH_MAP);
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getExpression()), (Type)ihmType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getVariable()), (Type)ihmType, (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        Type ihmType = state.getTypeFromString(IDENTITY_HASH_MAP);
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getType()), (Type)ihmType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getInitializer()), (Type)ihmType, (VisitorState)state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(tree.getType(), "IdentityHashMap").addImport(IDENTITY_HASH_MAP).build());
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (IHM_CTOR_MAP_ARG.matches((Tree)tree, state) && !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getArguments().get(0)), (Type)state.getTypeFromString(IDENTITY_HASH_MAP), (VisitorState)state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

