/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="DoNotClaimAnnotations", summary="Don't 'claim' annotations in annotation processors; Processor#process should unconditionally return `false`", severity=BugPattern.SeverityLevel.WARNING)
public class DoNotClaimAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Supplier<Name> PROCESS_NAME = VisitorState.memoize((Supplier & Serializable)s -> s.getName("process"));
    private static final Supplier<ImmutableList<Type>> PARAMETER_TYPES = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableList)Stream.of("java.util.Set", "javax.annotation.processing.RoundEnvironment").map(arg_0 -> ((VisitorState)s).getTypeFromString(arg_0)).filter(x -> x != null).collect(ImmutableList.toImmutableList()));
    private static final Supplier<Symbol> PROCESSOR_SYMBOL = VisitorState.memoize((Supplier & Serializable)s -> s.getSymbolFromString("javax.annotation.processing.Processor"));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!tree.getName().equals(PROCESS_NAME.get(state))) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (!ASTHelpers.isSameType((Type)sym.getReturnType(), (Type)state.getSymtab().booleanType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (((List)sym.getParameters()).size() != 2) {
            return Description.NO_MATCH;
        }
        if (!Streams.zip(sym.getParameters().stream(), (Stream)((ImmutableList)PARAMETER_TYPES.get(state)).stream(), (p, t) -> ASTHelpers.isSameType((Type)p.asType(), (Type)t, (VisitorState)state)).allMatch(x -> x)) {
            return Description.NO_MATCH;
        }
        if (!sym.owner.enclClass().isSubClass((Symbol)PROCESSOR_SYMBOL.get(state), state.getTypes())) {
            return Description.NO_MATCH;
        }
        final ArrayList returns = new ArrayList();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void aVoid) {
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void aVoid) {
                return null;
            }

            @Override
            public Void visitReturn(ReturnTree node, Void unused) {
                if (!Objects.equals(ASTHelpers.constValue((Tree)node.getExpression(), Boolean.class), false)) {
                    returns.add(node);
                }
                return (Void)super.visitReturn(node, null);
            }
        }.scan(tree.getBody(), null);
        if (returns.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (ReturnTree returnTree : returns) {
            if (!Objects.equals(ASTHelpers.constValue((Tree)returnTree.getExpression(), Boolean.class), true)) continue;
            fix.replace((Tree)returnTree.getExpression(), "false");
        }
        return this.describeMatch((Tree)returns.get(0), (Fix)fix.build());
    }
}

