/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Map;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoNotCall", summary="This method should not be called.", severity=BugPattern.SeverityLevel.ERROR)
public class DoNotCallChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final ImmutableMap<Matcher<ExpressionTree>, String> THIRD_PARTY_METHODS = new ImmutableMap.Builder().put((Object)MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters(new String[]{"double", "double"}), (Object)"This method always throws java.lang.AssertionError. Use assertEquals(expected, actual, delta) to compare floating-point numbers").put((Object)MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters(new String[]{"java.lang.String", "double", "double"}), (Object)"This method always throws java.lang.AssertionError. Use assertEquals(String, expected, actual, delta) to compare floating-point numbers").put((Object)MethodMatchers.instanceMethod().onExactClass("java.lang.Thread").named("stop").withParameters(new String[]{"java.lang.Throwable"}), (Object)"Thread.stop(Throwable) always throws an UnsupportedOperationException").put((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Date").namedAnyOf(new String[]{"getHours", "getMinutes", "getSeconds", "setHours", "setMinutes", "setSeconds"}), (Object)"The hour/minute/second getters and setters on java.sql.Date are guaranteed to throw IllegalArgumentException because java.sql.Date does not have a time component.").put((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Date").named("toInstant"), (Object)"sqlDate.toInstant() is not supported. Did you mean to call toLocalDate() instead?").put((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Time").namedAnyOf(new String[]{"getYear", "getMonth", "getDay", "getDate", "setYear", "setMonth", "setDate"}), (Object)"The year/month/day getters and setters on java.sql.Time are guaranteed to throw IllegalArgumentException because java.sql.Time does not have a date component.").put((Object)MethodMatchers.instanceMethod().onExactClass("java.sql.Time").named("toInstant"), (Object)"sqlTime.toInstant() is not supported. Did you mean to call toLocalTime() instead?").put((Object)MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.ThreadLocalRandom").named("setSeed"), (Object)"ThreadLocalRandom does not support setting a seed.").put((Object)MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.locks.ReentrantReadWriteLock.ReadLock").named("newCondition"), (Object)"ReadLocks do not support conditions.").build();
    static final String DO_NOT_CALL = "com.google.errorprone.annotations.DoNotCall";
    private final boolean checkThirdPartyMethods;

    public DoNotCallChecker(ErrorProneFlags flags) {
        this.checkThirdPartyMethods = flags.getBoolean("DoNotCallChecker:CheckThirdPartyMethods").orElse(true);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, (String)DO_NOT_CALL, (VisitorState)state)) {
            if (symbol.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return this.buildDescription(tree).setMessage("A private method that should not be called should simply be removed.").build();
            }
            if (symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Description.NO_MATCH;
            }
            if (!ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)symbol)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("Methods annotated with @DoNotCall should be final or static.").addFix(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).stream().filter(s -> ASTHelpers.hasAnnotation((Symbol)s, (String)DO_NOT_CALL, (VisitorState)state)).findAny().map(s -> {
            String message = String.format("Method overrides %s in %s which is annotated @DoNotCall, it should also be annotated.", s.getSimpleName(), s.owner.getSimpleName());
            return this.buildDescription(tree).setMessage(message).addFix((Fix)SuggestedFix.builder().addImport(DO_NOT_CALL).prefixWith((Tree)tree, "@DoNotCall ").build()).build();
        }).orElse(Description.NO_MATCH);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (this.checkThirdPartyMethods) {
            for (Map.Entry matcher : THIRD_PARTY_METHODS.entrySet()) {
                if (!((Matcher)matcher.getKey()).matches((Tree)tree, state)) continue;
                return this.buildDescription(tree).setMessage((String)matcher.getValue()).build();
            }
        }
        return this.checkTree(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkTree(tree, ASTHelpers.getSymbol((MemberReferenceTree)tree), state);
    }

    private Description checkTree(Tree tree, Symbol.MethodSymbol sym, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Symbol)sym, (String)DO_NOT_CALL, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String doNotCall = DoNotCallChecker.getDoNotCallValue(sym);
        StringBuilder message = new StringBuilder("This method should not be called");
        if (doNotCall.isEmpty()) {
            message.append(", see its documentation for details.");
        } else {
            message.append(": ").append(doNotCall);
        }
        return this.buildDescription(tree).setMessage(message.toString()).build();
    }

    private static String getDoNotCallValue(Symbol symbol) {
        for (Attribute.Compound a : symbol.getRawAttributes()) {
            if (!a.type.tsym.getQualifiedName().contentEquals(DO_NOT_CALL)) continue;
            return MoreAnnotations.getAnnotationValue((Attribute.Compound)a, (String)"value").flatMap(MoreAnnotations::asStringValue).orElse("");
        }
        throw new IllegalStateException();
    }
}

